# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1484-1 (xulrunner)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60363);
 script_cve_id("CVE-2008-0412", "CVE-2008-0413", "CVE-2008-0414", "CVE-2008-0415", "CVE-2008-0416", "CVE-2008-0417", "CVE-2008-0418", "CVE-2008-0419", "CVE-2008-0591", "CVE-2008-0592", "CVE-2008-0593", "CVE-2008-0594");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1484-1 (xulrunner)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to xulrunner
announced via advisory DSA 1484-1.

Several remote vulnerabilities have been discovered in Xulrunner, a
runtime environment for XUL applications. The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2008-0412

Jesse Ruderman, Kai Engert, Martijn Wargers, Mats Palmgren and Paul
Nickerson discovered crashes in the layout engine, which might allow
the execution of arbitrary code.

CVE-2008-0413

Carsten Book, Wesley Garland, Igor Bukanov, moz_bug_r_a4, shutdown,
Philip Taylor and tgirmann discovered crashes in the Javascript
engine, which might allow the execution of arbitrary code.

CVE-2008-0414

hong and Gregory Fleisher discovered that file input focus
vulnerabilities in the file upload control could allow information
disclosure of local files.

CVE-2008-0415

moz_bug_r_a4 and Boris Zbarsky discovered discovered several
vulnerabilities in Javascript handling, which could allow
privilege escalation.

CVE-2008-0417

Justin Dolske discovered that the password storage machanism could
be abused by malicious web sites to corrupt existing saved passwords.

CVE-2008-0418

Gerry Eisenhaur and moz_bug_r_a4 discovered that a directory
traversal vulnerability in chrome: URI handling could lead to
information disclosure.

CVE-2008-0419

David Bloom discovered a race condition in the image handling of
designMode elements, which could lead to information disclosure or
potentially the execution of arbitrary code.

CVE-2008-0591

Michal Zalewski discovered that timers protecting security-sensitive
dialogs (which disable dialog elements until a timeout is reached)
could be bypassed by window focus changes through Javascript.

CVE-2008-0592

It was discovered that malformed content declarations of saved
attachments could prevent a user in the opening local files
with a .txt file name, resulting in minor denial of service.

CVE-2008-0593

Martin Straka discovered that insecure stylesheet handling during
redirects could lead to information disclosure.

CVE-2008-0594

Emil Ljungdahl and Lars-Olof Moilanen discovered that phishing
protections could be bypassed with <div> elements.

For the stable distribution (etch), these problems have been fixed in
version 1.8.0.15~pre080131b-0etch1.

The old stable distribution (sarge) doesn't contain xulrunner.

We recommend that you upgrade your xulrunner packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201484-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1484-1 (xulrunner)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libxul-dev", ver:"1.8.0.15~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxul-common", ver:"1.8.0.15~pre080131a-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmozjs-dev", ver:"1.8.0.15~pre080131a-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-dev", ver:"1.8.0.15~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnspr4-dev", ver:"1.8.0.15~pre080131a-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmjs1", ver:"1.8.0.15~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmjs-dev", ver:"1.8.0.15~pre080131a-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmozillainterfaces-java", ver:"1.8.0.15~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnspr4-0d-dbg", ver:"1.8.0.15~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner", ver:"1.8.0.15~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-0d", ver:"1.8.0.15~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-0d-dbg", ver:"1.8.0.15~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmozjs0d-dbg", ver:"1.8.0.15~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmozjs0d", ver:"1.8.0.15~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxul0d", ver:"1.8.0.15~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-xpcom", ver:"1.8.0.15~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxul0d-dbg", ver:"1.8.0.15~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"spidermonkey-bin", ver:"1.8.0.15~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-tools", ver:"1.8.0.15~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-gnome-support", ver:"1.8.0.15~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnspr4-0d", ver:"1.8.0.15~pre080131b-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
