# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1460-1 (postgresql-8.1)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60178);
 script_cve_id("CVE-2007-3278", "CVE-2007-4769", "CVE-2007-4772", "CVE-2007-6067", "CVE-2007-6600", "CVE-2007-6601");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1460-1 (postgresql-8.1)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to postgresql-8.1
announced via advisory DSA 1460-1.

Several local vulnerabilities have been discovered in PostgreSQL, an
object-relational SQL database. The Common Vulnerabilities and Exposures
project identifies the following problems:

CVE-2007-3278

It was discovered that the DBLink module performed insufficient
credential validation. This issue is also tracked as CVE-2007-6601,
since the initial upstream fix was incomplete.

CVE-2007-4769

Tavis Ormandy and Will Drewry discovered that a bug in the handling
of back-references inside the regular expressions engine could lead
to an out of bands read, resulting in a crash. This constitutes only
a security problem if an application using ProgreSQL processes
regular expressions from untrusted sources.

CVE-2007-4772

Tavis Ormandy and Will Drewry discovered that the optimizer for regular
expression could be tricked into an infinite loop, resulting in denial
of service. This constitutes only a security problem if an application
using ProgreSQL processes regular expressions from untrusted sources.

CVE-2007-6067

Tavis Ormandy and Will Drewry discovered that the optimizer for regular
expression could be tricked massive ressource consumption. This
constitutes only a security problem if an application using ProgreSQL
processes regular expressions from untrusted sources.

CVE-2007-6600

Functions in index expressions could lead to privilege escalation. For
a more in depth explanation please see the upstream announce available
at http://www.postgresql.org/about/news.905.

For the unstable distribution (sid), these problems have been fixed in
version 8.2.6-1 of postgresql-8.2.

For the stable distribution (etch), these problems have been fixed in version
postgresql-8.1 8.1.11-0etch1.

The old stable distribution (sarge), doesn't contain postgresql-8.1.

We recommend that you upgrade your postgresql-8.1 (8.1.11-0etch1) package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201460-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1460-1 (postgresql-8.1)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"postgresql-doc-8.1", ver:"8.1.11-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-contrib-8.1", ver:"8.1.11-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-8.1", ver:"8.1.11-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-server-dev-8.1", ver:"8.1.11-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-plpython-8.1", ver:"8.1.11-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpq4", ver:"8.1.11-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpgtypes2", ver:"8.1.11-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.1.11-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg5", ver:"8.1.11-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpq-dev", ver:"8.1.11-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-pltcl-8.1", ver:"8.1.11-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg-compat2", ver:"8.1.11-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-client-8.1", ver:"8.1.11-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-plperl-8.1", ver:"8.1.11-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
