# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1156-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57301);
 script_cve_id("CVE-2006-2449");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1156-1 (kdebase)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to kdebase
announced via advisory DSA 1156-1.

Ludwig Nussel discovered that kdm, the X display manager for KDE, handles
access to the session type configuration file insecurely, which may lead
to the disclosure of arbitrary files through a symlink attack.

For the stable distribution (sarge) this problem has been fixed in
version 3.3.2-1sarge3.

For the unstable distribution (sid) this problem has been fixed in
version 3.5.2-2.

We recommend that you upgrade your kdm package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201156-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1156-1 (kdebase)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kdebase-data", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdebase-doc", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdebase", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfonts-konsole", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kappfinder", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kate", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kcontrol", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdebase-bin", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdebase-dev", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdebase-kio-plugins", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdepasswd", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdeprint", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdesktop", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdm", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kfind", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"khelpcenter", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kicker", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"klipper", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kmenuedit", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"konqueror", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"konqueror-nsplugins", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"konsole", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kpager", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kpersonalizer", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ksmserver", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ksplash", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ksysguard", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ksysguardd", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ktip", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kwin", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkonq4", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkonq4-dev", ver:"3.3.2-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
