# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1087-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56857);
 script_cve_id("CVE-2006-2313", "CVE-2006-2314");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1087-1 (postgresql)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to postgresql
announced via advisory DSA 1087-1.

Several encoding problems have been discovered in PostgreSQL, a
popular SQL database.  The Common Vulnerabilities and Exposures
project identifies the following problems:

CVE-2006-2313

Akio Ishida and Yasuo Ohgaki discovered a weakness in the handling
of invalidly-encoded multibyte text data which could allow an
attacker to inject arbitrary SQL commands.

CVE-2006-2314

A similar problem exists in client-side encodings (such as SJIS,
BIG5, GBK, GB18030, and UHC) which contain valid multibyte
characters that end with the backslash character.  An attacker
could supply a specially crafted byte sequence that is able to
inject arbitrary SQL commands.

This issue does not affect you if you only use single-byte (like
SQL_ASCII or the ISO-8859-X family) or unaffected multibyte (like
UTF-8) encodings.

psycopg and python-pgsql use the old encoding for binary data and
may have to be updated.

The old stable distribution (woody) is affected by these problems but
we're unable to correct the package.

For the stable distribution (sarge) these problems have been fixed in
version 7.4.7-6sarge2.

For the unstable distribution (sid) these problems have been fixed in
version 7.4.13-1.

We recommend that you upgrade your postgresql packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201087-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1087-1 (postgresql)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"postgresql-doc", ver:"7.4.7-6sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg-dev", ver:"7.4.7-6sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg4", ver:"7.4.7-6sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpgtcl", ver:"7.4.7-6sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpgtcl-dev", ver:"7.4.7-6sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpq3", ver:"7.4.7-6sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql", ver:"7.4.7-6sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-client", ver:"7.4.7-6sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-contrib", ver:"7.4.7-6sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-dev", ver:"7.4.7-6sarge2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
