# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:1024 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63978);
 script_cve_id("CVE-2009-1336", "CVE-2009-1337");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:1024";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates to the kernel announced in
advisory RHSA-2009:1024.

Security Fixes:

* the exit_notify() function in the Linux kernel did not properly reset the
exit signal if a process executed a set user ID (setuid) application before
exiting. This could allow a local, unprivileged user to elevate their
privileges. (CVE-2009-1337, Important)

* the Linux kernel implementation of the Network File System (NFS) did not
properly initialize the file name limit in the nfs_server data structure.
This flaw could possibly lead to a denial of service on a client mounting
an NFS share. (CVE-2009-1336, Moderate)

For information on additional bug fixes made in this package,
please visit the referenced security advisories.

Users should install this update, which resolves these issues and adds
these enhancements.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-1024.html
http://www.redhat.com/security/updates/classification/#important
http://www.redhat.com/docs/en-US/Red_Hat_Enterprise_Linux/4.8/html/Release_Notes/index.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:1024";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.9~89.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo", rpm:"kernel-debuginfo~2.6.9~89.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.9~89.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-hugemem", rpm:"kernel-hugemem~2.6.9~89.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-hugemem-devel", rpm:"kernel-hugemem-devel~2.6.9~89.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.9~89.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-devel", rpm:"kernel-smp-devel~2.6.9~89.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-xenU", rpm:"kernel-xenU~2.6.9~89.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-xenU-devel", rpm:"kernel-xenU-devel~2.6.9~89.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-largesmp", rpm:"kernel-largesmp~2.6.9~89.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-largesmp-devel", rpm:"kernel-largesmp-devel~2.6.9~89.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.9~89.EL", rls:"RHENT_4")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
