# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0446 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63870);
 script_cve_id("CVE-2008-5519");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0446";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0446.

mod_jk is an Apache Tomcat connector that allows Apache Tomcat and the
Apache HTTP Server to communicate with each other.

An information disclosure flaw was found in mod_jk. In certain situations,
if a faulty client set the Content-Length header without providing data,
or if a user sent repeated requests very quickly, one user may view a
response intended for another user. (CVE-2008-5519)

As well, the sample configuration files provided in the documentation have
been updated to reflect recommended practice.

All mod_jk users are advised to upgrade to this updated package. It
provides mod_jk 1.2.28, which is not vulnerable to this issue.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0446.html
http://www.redhat.com/security/updates/classification/#important

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0446";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"mod_jk-ap20", rpm:"mod_jk-ap20~1.2.28~1.el5s2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mod_jk-debuginfo", rpm:"mod_jk-debuginfo~1.2.28~1.el5s2", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
