# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0020 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63133);
 script_cve_id("CVE-2009-0025");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0020";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0020.

A flaw was discovered in the way BIND checked the return value of the
OpenSSL DSA_do_verify function. On systems using DNSSEC, a malicious zone
could present a malformed DSA certificate and bypass proper certificate
validation, allowing spoofing attacks. (CVE-2009-0025)

For users of Red Hat Enterprise Linux 3 this update also addresses a bug
which can cause BIND to occasionally exit with an assertion failure.

All BIND users are advised to upgrade to the updated package, which
contains a backported patch to resolve this issue. After installing the
update, BIND daemon will be restarted automatically.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0020.html
http://www.redhat.com/security/updates/classification/#moderate

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0020";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"bind", rpm:"bind~9.2.1~11.el2", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.2.1~11.el2", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.2.1~11.el2", rls:"RHENT_2.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind", rpm:"bind~9.2.4~23.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-chroot", rpm:"bind-chroot~9.2.4~23.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-debuginfo", rpm:"bind-debuginfo~9.2.4~23.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.2.4~23.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.2.4~23.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.2.4~23.el3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind", rpm:"bind~9.2.4~30.el4_7.1", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-chroot", rpm:"bind-chroot~9.2.4~30.el4_7.1", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-debuginfo", rpm:"bind-debuginfo~9.2.4~30.el4_7.1", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.2.4~30.el4_7.1", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.2.4~30.el4_7.1", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.2.4~30.el4_7.1", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.4~6.0.3.P1.el5_2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-debuginfo", rpm:"bind-debuginfo~9.3.4~6.0.3.P1.el5_2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.3.4~6.0.3.P1.el5_2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-sdb", rpm:"bind-sdb~9.3.4~6.0.3.P1.el5_2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.3.4~6.0.3.P1.el5_2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-chroot", rpm:"bind-chroot~9.3.4~6.0.3.P1.el5_2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.3.4~6.0.3.P1.el5_2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-libbind-devel", rpm:"bind-libbind-devel~9.3.4~6.0.3.P1.el5_2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"caching-nameserver", rpm:"caching-nameserver~9.3.4~6.0.3.P1.el5_2", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
