#include "jdxwidget.h"
#include "jdxblockwidget.h"



/////////////////////////////////////////////////////////////////////////////

JcampDxBlockGrid::JcampDxBlockGrid(JcampDxBlock& block,unsigned int columns,QWidget *parent,const char* omittext)
   : QWidget(parent), val(block) {
  Log<OdinQt> odinlog(&block,"JcampDxBlockGrid(...)");

  grid=0;

  STD_list<JDXwidget*> subwidgets;
  STD_list<JDXwidget*>::iterator it;


  unsigned int numof_pars=block.numof_pars();
  JcampDxClass* ldrptr;


  // fill list with subwidgets
  for(unsigned int i=0;i<numof_pars;i++) {
    ldrptr=&(block[i]);
    if(ldrptr && ldrptr->isUserDefParameter() && (ldrptr->get_parmode()!=hidden)) {
      JDXwidget* ldrwidget=0;
      JcampDxBlock* blockdummy=ldrptr->cast(blockdummy);
      if(blockdummy) {
        unsigned int cols4block=1;
        if(blockdummy->numof_pars()>5) cols4block=2;
        ldrwidget=new JDXwidget(*ldrptr,cols4block,this,false,omittext);

      } else ldrwidget=new JDXwidget(*ldrptr,1,this,false,omittext);
      subwidgets.push_back(ldrwidget);
    }
  }

  unsigned int n_widget_rows=0;
  unsigned int rowheight=0;
  unsigned int colstart=0;

  // calculate n_widget_rows layout
  for(it=subwidgets.begin(); it!=subwidgets.end(); ++it) {
    unsigned int colwidth=(*it)->get_cols();

    if( (colstart+colwidth) > 2 ) {
      // goto new row
      n_widget_rows+=rowheight;
      colstart=0;
      rowheight=0;
    }

    ODINLOG(odinlog,normalDebug) << "rows(" << (*it)->get_label() << ")=" << (*it)->get_rows() << STD_endl;
    if ( (*it)->get_rows() > rowheight ) rowheight=(*it)->get_rows();
    colstart+=colwidth;
  }
  n_widget_rows+=rowheight;

  ODINLOG(odinlog,normalDebug) << "n_widget_rows/columns" << n_widget_rows << "/" << columns << STD_endl;
  unsigned int rows=(n_widget_rows/columns);
//  if(n_widget_rows%columns) rows++;
  rows++;


  unsigned int irow=0;
  unsigned int icolumn=0;
  rowheight=0;
  colstart=0;

  grid = new GuiGridLayout( this, rows , columns*2);
  ODINLOG(odinlog,normalDebug) << "creating " << rows << "x" << columns*2 << " grid" << STD_endl;

  for(it=subwidgets.begin(); it!=subwidgets.end(); ++it) {

    unsigned int colwidth=(*it)->get_cols();

    if( (colstart+colwidth) > 2 ) {
      // goto new row
      irow+=rowheight;
      colstart=0;
      rowheight=0;
    }

//    rowheight=(*it)->get_rows();
    if ( (*it)->get_rows() > rowheight ) rowheight=(*it)->get_rows();
    if( (irow+rowheight) > rows ) {
      icolumn++;
      irow=0;
    }

    unsigned int coloffset=2*icolumn+colstart;
    unsigned int rowoffset=irow;

    colstart+=colwidth;

    int rowstart=rowoffset;
//    int rowend=rowoffset+rowheight-1;
//    int colstart=coloffset;
//    int colend=coloffset+colwidth-1;
    ODINLOG(odinlog,normalDebug) << (*it)->get_label() << " at " << "(" << rowstart << "-" << coloffset << "," << rowheight << "-" << colwidth << ")" << STD_endl;

    grid->add_widget( (*it), rowoffset, coloffset, GuiGridLayout::Center, rowheight, colwidth );

    connect((*it),SIGNAL(valueChanged()),this,SLOT(emitValueChanged()));
    connect(this,SIGNAL(updateSubWidget()),(*it),SLOT(updateWidget()));
    connect(this,SIGNAL(deleteSubDialogs()),(*it),SLOT(deleteDialogs()));
  }
}

void JcampDxBlockGrid::updateWidget() {
  for(STD_list<JDXwidgetDialog*>::iterator it=subdialogs.begin(); it!=subdialogs.end(); ++it) {
    (*it)->updateWidget();
  }
  emit updateSubWidget();
}


void JcampDxBlockGrid::deleteDialogs() {
  emit deleteSubDialogs();
}



void JcampDxBlockGrid::createDialog() {
  Log<OdinQt> odinlog(&val,"createDialog");
  JDXwidgetDialog* dlg=new JDXwidgetDialog(val,1,this);
  subdialogs.push_back(dlg);
  connect(dlg,SIGNAL(valueChanged()), this,SLOT(emitValueChanged()));
  emit valueChanged();
}


/////////////////////////////////////////////////////////////////////////////

JcampDxBlockScrollView::JcampDxBlockScrollView(JcampDxBlock& block,unsigned int columns,QWidget *parent,const char* omittext) {
  Log<OdinQt> odinlog(&block,"JcampDxBlockScrollView(...)");

  jdxgrid=new JcampDxBlockGrid(block,columns,parent,omittext);
  connect(jdxgrid,SIGNAL(valueChanged()),this,SLOT(emitValueChanged()));

  scroll=new GuiScroll(jdxgrid,parent);
}


JcampDxBlockScrollView::~JcampDxBlockScrollView() {
  delete scroll;
}

/////////////////////////////////////////////////////////////////////////////


JcampDxBlockWidget::JcampDxBlockWidget(JcampDxBlock& jdxblock,unsigned int columns,QWidget *parent,bool doneButton,bool is_dialog,const char* omittext, bool storeLoadButtons)
   : QGroupBox(jdxblock.get_label().c_str(), parent ), parblock(jdxblock) {
  Log<OdinQt> odinlog(&jdxblock,"JcampDxBlockWidget(...)");

  pb_done=0;
  pb_edit=0;
  pb_store=0;
  pb_load=0;
  grid=0;
  jdxscroll=0;



  if(jdxblock.is_embedded() || is_dialog) {

    int height=1;
    if(doneButton || storeLoadButtons) height=2;

    grid=new GuiGridLayout(this, height, 3);

    jdxscroll=new JcampDxBlockScrollView(jdxblock,columns,this,omittext);
    grid->add_widget( jdxscroll->get_widget(), 0, 0, GuiGridLayout::Default, 1, 3);
    connect(jdxscroll,SIGNAL(valueChanged()),this,SLOT(emitValueChanged()));

    // dummy button which gets the focus
    if(doneButton || storeLoadButtons) {
      GuiButton* pb_dummy = new GuiButton( this, 0, "", "Dummy" );
      pb_dummy->set_default(true);
      pb_dummy->get_widget()->hide();
    }
   
    if(doneButton) {
      pb_done = new GuiButton( this, this, SLOT(emitDone()), "Done" );
      pb_done->set_default(false);
      grid->add_widget( pb_done->get_widget(), 1, 2, GuiGridLayout::Center );
//      connect( pb_done->get_widget(), SIGNAL(clicked()), this,SLOT(emitDone()) );
    }

    if(storeLoadButtons) {
      pb_store = new GuiButton( this, this, SLOT(storeBlock()), "Store ..." );
      pb_load =  new GuiButton( this, this, SLOT(loadBlock()),  "Load ..." );
      pb_store->set_default(false);
      pb_load->set_default(false);
      grid->add_widget( pb_store->get_widget(), 1, 0, GuiGridLayout::Center );
      grid->add_widget( pb_load->get_widget(), 1, 1, GuiGridLayout::Center );
//      connect( pb_store->get_widget(), SIGNAL(clicked()), this,SLOT(storeBlock()) );
//      connect( pb_load->get_widget(), SIGNAL(clicked()), this,SLOT(loadBlock()) );
    }
    
  } else {  // if(block.is_embedded())

    jdxscroll=new JcampDxBlockScrollView(jdxblock,columns,0,omittext);
    connect(jdxscroll,SIGNAL(valueChanged()),this,SLOT(emitValueChanged()));

    grid=new GuiGridLayout( this, 1 , 1);

    pb_edit = new GuiButton( this, this, SLOT(createDialog()), "Edit" );
    grid->add_widget( pb_edit->get_widget(), 0, 0, GuiGridLayout::Center );
//    connect( pb_edit->get_widget(), SIGNAL(clicked()), this,SLOT(createDialog()) );
  }

}

void JcampDxBlockWidget::createDialog() {
  Log<OdinQt> odinlog("JcampDxBlockWidget","createDialog");
  ODINLOG(odinlog,normalDebug) << "jdxscroll=" << jdxscroll << STD_endl;
  if(jdxscroll) jdxscroll->createDialog();
}

JcampDxBlockWidget::~JcampDxBlockWidget() {
  if(pb_done) delete pb_done;
  if(pb_store) delete pb_store;
  if(pb_load) delete pb_load;
  if(grid) delete grid;
  if(jdxscroll) delete jdxscroll;
}



void JcampDxBlockWidget::emitDone() {
  emit doneButtonPressed();
}

void JcampDxBlockWidget::storeBlock() {
  STD_string fname=get_save_filename(("Storing "+STD_string(parblock.get_label())).c_str(),"","",this);
  if(fname=="") return;
  parblock.write(fname);
}

void JcampDxBlockWidget::loadBlock() {
  STD_string fname=get_open_filename(("Loading "+STD_string(parblock.get_label())).c_str(),"","",this);
  if(fname=="") return;
  parblock.load(fname);
  updateWidget();
}


/////////////////////////////////////////////////////////////////////////////////


JDXwidgetDialog::JDXwidgetDialog(JcampDxBlock& ldr,unsigned int columns,QWidget *parent, bool modal)
 : GuiDialog(parent, ldr.get_label().c_str(), modal) {
  Log<OdinQt> odinlog(&ldr,"JDXwidgetDialog(...)");

  grid=new GuiGridLayout(GuiDialog::get_widget(), 2, 1);

  jdx=new JcampDxBlockWidget(ldr,columns,GuiDialog::get_widget(),true,true);

  grid->add_widget( jdx, 0, 0 );
  connect(jdx,SIGNAL(valueChanged()),this,SLOT(emitChanged()));
  connect(jdx,SIGNAL(doneButtonPressed()), this,SLOT(callDone()) );


  GuiDialog::show();

#if QT_VERSION > 299
  if(modal) GuiDialog::exec();
#endif
}


JDXwidgetDialog::~JDXwidgetDialog() {
  delete jdx;
  delete grid;
}

void JDXwidgetDialog::updateWidget() {
  jdx->updateWidget();
}

void JDXwidgetDialog::callDone() {
  emit finished();
  GuiDialog::done();
}

void JDXwidgetDialog::emitChanged() {
  emit valueChanged();
}
