/****************************************************************************************/
/*											*/
/* This program is free software; you can redistribute it and/or modify it under the	*/
/* terms of the GNU General Public License as published by the Free Software		*/
/* Foundation; either version 2 of the License, or (at your option) any later version.	*/
/*											*/
/* This program is distributed in the hope that it will be useful, but WITHOUT ANY	*/
/* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A	*/
/* PARTICULAR PURPOSE. See the GNU General Public License for more details.		*/
/*											*/
/* You should have received a copy of the GNU General Public License along with this	*/
/* program; (See "COPYING"). If not, If not, see <http://www.gnu.org/licenses/>.        */
/*											*/
/*--------------------------------------------------------------------------------------*/
/*											*/
/*  Copyright   Joerg Anders, TU Chemnitz, Fakultaet fuer Informatik, GERMANY           */
/*		ja@informatik.tu-chemnitz.de						*/
/*											*/
/*											*/
/****************************************************************************************/

#ifndef CHORD_OR_REST_H

#define CHORD_OR_REST_H
#include "config.h"
#include "resource.h"

#include <gtk/gtk.h>
#include <cairo.h>

#define LAST_TUPLET_FLAG (1 << 24)
#define TUPLET_VAR_MASK (0xfff)

#define BREAK_TIE_FORWARD (1 << 0)
#define BREAK_TIE_BACKWARD (1 << 1)

#define TYPE_REST (1 << 0)
#define TYPE_NOTE (1 << 1)
#define TYPE_CLEF (1 << 2)
#define TYPE_KEYSIG (1 << 3)
#define TYPE_GRACE (1 << 4)
#define STAFF_ELEM_MASK (TYPE_CLEF)

#define LYR_CURSOR_LEFT -1
#define LYR_CURSOR_RIGHT 1
#define LYR_CURSOR_START -2
#define LYR_CURSOR_END 2

#define MAX_ARTICULATIONS 10


class NedMainWindow;
class NedPage;
class NedSystem;
class NedStaff;
class NedVoice;
class NedBeam;
class NedTuplet;
class BBox;
class NedCommandList;
class NedNote;


class NedChordOrRest {
	public:
		NedChordOrRest(NedVoice *voice, int type, bool is_hidden, int line, int dot_count, unsigned int length, int head, unsigned int status, unsigned long long time);
		NedChordOrRest(NedVoice *voice, int type, unsigned int clef_number, int octave_shift, unsigned long long time, bool dummy); // clef
		NedChordOrRest(NedVoice *voice, int type, int keysig, int last_keysig, unsigned long long time); // key signature
		~NedChordOrRest();
		NedChordOrRest *clone(struct addr_ref_str **addrlist, bool keep_beam = false);
		bool hasUpDir();
		void draw(cairo_t *cr, bool *lyrics_present);
		void drawlyrics(cairo_t *cr);
		double getRealXpos() {return m_xpos;}
		double getXPos() {if (m_tmp_xpos < 0.0) return m_xpos; return m_tmp_xpos;}
		void insertNoteAt(NedNote *note, bool echo = FALSE);
		bool removeNoteAt(int line);
		bool noConflict(int line);
		void reConfigure();
		NedNote *getFirstNote();
		NedMainWindow *getMainWindow();
		NedPage *getPage();
		NedSystem *getSystem();
		NedStaff *getStaff();
		NedVoice *getVoice() {return m_voice;}
		void createLyrics(int line, char *text);
		void setLyrics(int line, char *text);
		void computeLyricsParams();
		void appendToLyrics(NedCommandList *command_list, int line, char *text); 
		bool deleteLyricsLetter(NedCommandList *command_list, int line);
		void computeFontExtentions(int line);
		bool setLyricsCursor(int line, int pos);
		void selectNextChord(int line, bool lyrics_required);
		void selectPreviousChord(int line, bool lyrics_required);
		void setVoice(NedVoice *voice) {m_voice = voice;}
		void removeUnneededAccidentals(int clef, int keysig, int octave_shift);
		void setToRest(bool toRest);
		int getType() {return m_type;}
		bool isRest() {return (m_type == TYPE_REST);}
		bool isHidden() {return m_is_hidden;}
		void setTime(unsigned int time)  {m_time = time;}
		unsigned int getStatus() {return m_status;}
		void setStatus(unsigned int status) {m_status = status;}
		unsigned int getLength() {return m_length;}
		void setLength(int length);
		bool trySelect (double x, double y);
		bool tryErease (double x, double y, bool *removed);
		bool testXShift(double x);
		bool ReleaseTmpValue();
		static int compareMidiTimes(NedChordOrRest *c1, NedChordOrRest *c2);
		unsigned int getTime() {return m_time;}
		unsigned int getDuration(unsigned int measure_duration = -1);
		void setXPos(double pos) {m_xpos = pos;}
		void shiftX(double x) {m_xpos += x;}
		void shiftY(double y);
		void setXPosAccordingBBox(double pos) {m_xpos = pos - m_bbox.x;}
		unsigned int getStopTime();
		void setBeam(NedBeam *beam) {m_beam = beam;}
		NedBeam *getBeam() {return m_beam;}
		void reposit(unsigned int pos);
		void xPositNotes();
		void sortNotes();
		double getBeamXPos();
		double getStemTop();
		double getStemBottom();
		void resetYPos() {m_ypos = - 3 * LINE_DIST/2.0;}
		double getStemYStart();
		void getTopBotY(int *lyrics_lines, double *topy, double *boty);
		double getTopOfChordOrRest();
		double getBottomOfChordOrRest();
		bool testForTiesToDelete(NedCommandList *command_list, unsigned int dir = BREAK_TIE_BACKWARD, bool execute = false);
		void tieComplete(NedChordOrRest *other_chord);
		int getDotCount() {return m_dot_count;}
		void setDotCount(int dot_count) {m_dot_count = dot_count;}
		NedBbox *getBBox() {return &m_bbox;}
		void computeBbox();
		double getNeededSpace();
		void setMidiTime(unsigned long long time, bool resetRestYPos = FALSE);
		void incrMidiTime(unsigned long long incr) {m_midi_time += incr;}
		void decrMidiTime(unsigned long long incr); // {m_midi_time -= incr;}
		unsigned long long getMidiTime() {return m_midi_time;}
		int getSorting(NedChordOrRest *other_chord);
		void changeDuration(unsigned int new_duration, int tuplet_val);
		NedChordOrRest *cloneWithDifferentLength(unsigned int newlen, int dotcount);
		static unsigned int computeDuration(unsigned int length, int dotcount, int tuplet_val);
		static void compute_fitting_duration(unsigned int sum, unsigned int *length, int *dot_count);
		static NedChordOrRest *restoreChordOrRest(FILE *fp, NedVoice *voice);
		NedChordOrRest *getNextChordOrRest();
		NedChordOrRest *getPreviousChordOrRest();
		int m_position;
		double computeStemDist(bool thisup, NedChordOrRest *other_chord, bool otherup);
		void saveChordOrRest(FILE *fp);
		void changeStemDir(int dir);
		void saveTies(FILE *fp, bool *ties_written);
		void prepareReplay(int clef, int keysig, int octave_shift, int grace_time);
		void setOffset(char offs_array[115]);
		int getPitchOfFirstNote();
		double compute_microshift(NedChordOrRest *left_chord);
		double compute_y_shift(NedChordOrRest *other_chord, int dir);
		bool hasLastTupletFlag() {return (m_tuplet_val & LAST_TUPLET_FLAG);}
		void setLastTupletFlag(bool on) {if (on) m_tuplet_val |= LAST_TUPLET_FLAG; else m_tuplet_val &= (~(LAST_TUPLET_FLAG));}
		void correctTiesForward();
		void tieCompleteTo(NedChordOrRest *other);
		void removeAllBackwardTies();
		bool tieBackward(NedChordOrRest *prev, NedNote *note);
		void setTupletVal(int tuplet_val)  {m_tuplet_val = tuplet_val;}
		void setTupletPtr(NedTuplet *tuplet_ptr) {m_tuplet_ptr = tuplet_ptr;}
		NedTuplet *getTupletPtr() {return m_tuplet_ptr;}
		int getTupletVal() {return m_tuplet_val & TUPLET_VAR_MASK;}
		int getTupletValRaw() {return m_tuplet_val;}
		bool isUp();
		void adjust_pointers(struct addr_ref_str *addrlist);
		char *getLyrics(int line) {return m_lyrics[line];}
	private:
		GList *m_notes;
		NedBeam *m_beam;
		NedTuplet *m_tuplet_ptr;
		int m_tuplet_val;
		int m_type;
		bool m_is_hidden;
		unsigned int m_length;
		double m_xpos, m_ypos;
		unsigned int m_time;
		int m_dot_count;
		unsigned int m_status;
		int m_line;
		NedVoice *m_voice;
		NedBbox m_bbox;
		unsigned long long m_midi_time;
		double m_tmp_xpos;
		bool m_all_shifted;
		double m_art_y_pos[MAX_ARTICULATIONS], m_art_up_y_pos[MAX_ARTICULATIONS];
		int m_art_count, m_up_art_count;
		char *m_lyrics[MAX_LYRICS_LINES];
		cairo_text_extents_t *m_lyrics_extends[MAX_LYRICS_LINES];
		int m_cursorpos;
	friend class NedNewLyricsCommand;
	friend class NedDeleteLyricsCommand;
};

#endif /* CHORD_OR_REST_H */
