/*
 * ReminderPanel.java
 *
 * Created on December 11, 2007, 4:01 PM
 */

package org.netbeans.modules.registration;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/**
 *
 * @author  mslama
 */
public class ReminderPanel extends javax.swing.JPanel {

    class BackgroundPanel extends javax.swing.JPanel {
        ImageIcon backgroundImage;
        boolean resize;
        public BackgroundPanel(String image, boolean resize) {
            backgroundImage = ImageUtilities.loadImageIcon(
                    image, false);
            this.resize = resize;
            if(!resize) {
                this.setSize(backgroundImage.getIconWidth(), backgroundImage.getIconHeight());
                this.setPreferredSize(new Dimension(backgroundImage.getIconWidth(), backgroundImage.getIconHeight()));
            }

        }

          @Override
          protected void paintComponent(Graphics graphics)
          {
                super.paintComponent(graphics);
                if (backgroundImage != null) {
                    graphics.drawImage(
                            backgroundImage.getImage(),
                            0, 0,
                            resize ? backgroundImage.getIconWidth() : this.getWidth(),
                            backgroundImage.getIconHeight(),
                            0, 0,
                            backgroundImage.getIconWidth(), backgroundImage.getIconHeight(),
                            this);
                }
          }
    }
    
    /** Creates new form ReminderPanel */
    public ReminderPanel() {
        initComponents();
        loadImages();
        setText();
    }
    
    private void loadImages () {
        Image img; 
        ImageIcon icon;
        
        //img = ImageUtilities.loadImage("org/netbeans/modules/registration/resources/netbeans.png");
        //icon = new ImageIcon(img);
        //jLeftLabel.setIcon(icon);
        
        //img = ImageUtilities.loadImage("org/netbeans/modules/registration/resources/oracle.png");
        //icon = new ImageIcon(img);
        //jRightLabel.setIcon(icon);
        
        img = Utilities.loadImage("org/netbeans/modules/registration/resources/dot.png");
        icon = new ImageIcon(img);
        jBottomLabel2.setIcon(icon);
        jBottomLabel3.setIcon(icon);
        jBottomLabel4.setIcon(icon);
        jBottomLabel5.setIcon(icon);
    }

    private void setText () {
        jTopLabel1.setText(NbBundle.getMessage(ReminderPanel.class, "LBL_TopText1"));
        jTopLabel2.setText(NbBundle.getMessage(ReminderPanel.class, "LBL_TopText2"));
        jBottomLabel1.setText(NbBundle.getMessage(ReminderPanel.class, "LBL_BottomText1"));
        jBottomLabel2.setText(NbBundle.getMessage(ReminderPanel.class, "LBL_BottomText2"));
        jBottomLabel3.setText(NbBundle.getMessage(ReminderPanel.class, "LBL_BottomText3"));
        jBottomLabel4.setText(NbBundle.getMessage(ReminderPanel.class, "LBL_BottomText4"));
        jBottomLabel5.setText(NbBundle.getMessage(ReminderPanel.class, "LBL_BottomText5"));
        jBottomLabel6.setText(NbBundle.getMessage(ReminderPanel.class, "LBL_BottomText6"));
        Font controlFont = UIManager.getFont("controlFont");
        if (controlFont != null) {
            jTopLabel1.setFont(controlFont);
            Font bold = controlFont.deriveFont(Font.BOLD);
            jTopLabel2.setFont(bold);
            jBottomLabel1.setFont(controlFont);
            jBottomLabel2.setFont(controlFont);
            jBottomLabel3.setFont(controlFont);
            jBottomLabel4.setFont(controlFont);
            jBottomLabel5.setFont(controlFont);
            jBottomLabel6.setFont(controlFont);
        }
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jTopPanel = new javax.swing.JPanel();
        jLeftLabel = new BackgroundPanel("org/netbeans/modules/registration/resources/netbeans.png", false);
        jRightLabel = new BackgroundPanel("org/netbeans/modules/registration/resources/oracle.png", false);
        jInnerPanel = new BackgroundPanel("org/netbeans/modules/registration/resources/background.png", true);
        jTopLabel1 = new javax.swing.JLabel();
        jTopLabel2 = new javax.swing.JLabel();
        jBottomPanel = new javax.swing.JPanel();
        jBottomLabel1 = new javax.swing.JLabel();
        jBottomLabel2 = new javax.swing.JLabel();
        jBottomLabel3 = new javax.swing.JLabel();
        jBottomLabel4 = new javax.swing.JLabel();
        jBottomLabel5 = new javax.swing.JLabel();
        jBottomLabel6 = new javax.swing.JLabel();

        setFocusable(false);
        setLayout(new java.awt.BorderLayout());

        jTopPanel.setFocusable(false);
        jTopPanel.setLayout(new java.awt.BorderLayout());

        jLeftLabel.setBorder(javax.swing.BorderFactory.createEmptyBorder(10, 20, 10, 10));
        jLeftLabel.setFocusable(false);
        jTopPanel.add(jLeftLabel, java.awt.BorderLayout.WEST);

        jRightLabel.setBorder(javax.swing.BorderFactory.createEmptyBorder(10, 20, 10, 10));
        jRightLabel.setFocusable(false);
        jTopPanel.add(jRightLabel, java.awt.BorderLayout.EAST);

        jInnerPanel.setBorder(javax.swing.BorderFactory.createEmptyBorder(10, 20, 10, 10));
        jInnerPanel.setFocusable(false);
        jInnerPanel.setLayout(new javax.swing.BoxLayout(jInnerPanel, javax.swing.BoxLayout.Y_AXIS));

        jTopLabel1.setText("Take Control"); // NOI18N
        jTopLabel1.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        jTopLabel1.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 2, 0));
        jTopLabel1.setFocusable(false);
        jInnerPanel.add(jTopLabel1);

        jTopLabel2.setText("Register Your NetBeans IDE"); // NOI18N
        jTopLabel2.setVerticalAlignment(javax.swing.SwingConstants.BOTTOM);
        jTopLabel2.setBorder(javax.swing.BorderFactory.createEmptyBorder(2, 0, 0, 0));
        jTopLabel2.setFocusable(false);
        jInnerPanel.add(jTopLabel2);

        jTopPanel.add(jInnerPanel, java.awt.BorderLayout.CENTER);

        add(jTopPanel, java.awt.BorderLayout.CENTER);

        jBottomPanel.setBorder(javax.swing.BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jBottomPanel.setFocusable(false);
        jBottomPanel.setFont(new java.awt.Font("Dialog", 0, 12));
        jBottomPanel.setLayout(new javax.swing.BoxLayout(jBottomPanel, javax.swing.BoxLayout.Y_AXIS));

        jBottomLabel1.setText("<html>Register the NetBeans IDE to get the following benefits:</html>"); // NOI18N
        jBottomLabel1.setBorder(javax.swing.BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jBottomLabel1.setFocusable(false);
        jBottomPanel.add(jBottomLabel1);

        jBottomLabel2.setText("<html>Notifications of new versions, patches and updates</html>"); // NOI18N
        jBottomLabel2.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 30, 1, 10));
        jBottomLabel2.setFocusable(false);
        jBottomPanel.add(jBottomLabel2);

        jBottomLabel3.setText("<html>Special offers on Sun developer products, services and training</html>"); // NOI18N
        jBottomLabel3.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 30, 1, 10));
        jBottomLabel3.setFocusable(false);
        jBottomPanel.add(jBottomLabel3);

        jBottomLabel4.setText("<html>Access to early releases and documentation</html>"); // NOI18N
        jBottomLabel4.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 30, 1, 10));
        jBottomLabel4.setFocusable(false);
        jBottomPanel.add(jBottomLabel4);

        jBottomLabel5.setText("<html>Ability to track and manage your registered products on the SunConnection Inventory site</html>"); // NOI18N
        jBottomLabel5.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 30, 1, 10));
        jBottomLabel5.setFocusable(false);
        jBottomPanel.add(jBottomLabel5);

        jBottomLabel6.setText("<html>Registration is FREE.</html>"); // NOI18N
        jBottomLabel6.setBorder(javax.swing.BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jBottomLabel6.setFocusable(false);
        jBottomPanel.add(jBottomLabel6);

        add(jBottomPanel, java.awt.BorderLayout.SOUTH);
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jBottomLabel1;
    private javax.swing.JLabel jBottomLabel2;
    private javax.swing.JLabel jBottomLabel3;
    private javax.swing.JLabel jBottomLabel4;
    private javax.swing.JLabel jBottomLabel5;
    private javax.swing.JLabel jBottomLabel6;
    private javax.swing.JPanel jBottomPanel;
    private javax.swing.JPanel jInnerPanel;
    private javax.swing.JPanel jLeftLabel;
    private javax.swing.JPanel jRightLabel;
    private javax.swing.JLabel jTopLabel1;
    private javax.swing.JLabel jTopLabel2;
    private javax.swing.JPanel jTopPanel;
    // End of variables declaration//GEN-END:variables
    
}
