/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2009 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 * 
 * Contributor(s):
 * 
 * Portions Copyrighted 2008 Sun Microsystems, Inc.
 */

package org.netbeans.modules.hibernate.loaders.cfg.multiview;

import javax.swing.JTextField;

/**
 * Panel for adding and editing security. This panel is used in the popup dialog.
 * 
 * @author  Dongmei
 */
public class GrantPanel extends javax.swing.JPanel {
    
    /** Creates new form GrantPanel */
    public GrantPanel() {
        initComponents();
    }
    
    public void initValues( String role, String entityName, String actions ) {
        roleTextField.setText( role );
        entityNameTextField.setText( entityName );
        actionsTextField.setText( actions );
    }
    
    public JTextField getRoleTextField() {
        return this.roleTextField;
    }
    
    public JTextField getEntityNameTextField() {
        return this.entityNameTextField;
    }
    
    public JTextField getActionsTextField() {
        return this.actionsTextField;
    }
    
    public String getRole() {
        return this.roleTextField.getText().trim();
    }
    
    public String getEntityName() {
        return this.entityNameTextField.getText().trim();
    }
    
    public String getActions() {
        return this.actionsTextField.getText().trim();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        roleLabel = new javax.swing.JLabel();
        roleTextField = new javax.swing.JTextField();
        entityNameLabel = new javax.swing.JLabel();
        entityNameTextField = new javax.swing.JTextField();
        actionsLabel = new javax.swing.JLabel();
        actionsTextField = new javax.swing.JTextField();

        setLayout(new java.awt.GridBagLayout());

        roleLabel.setLabelFor(roleTextField);
        org.openide.awt.Mnemonics.setLocalizedText(roleLabel, org.openide.util.NbBundle.getMessage(GrantPanel.class, "LBL_Role2")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 12, 0, 0);
        add(roleLabel, gridBagConstraints);
        roleLabel.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(GrantPanel.class, "LBL_Role2")); // NOI18N
        roleLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(GrantPanel.class, "LBL_Role2")); // NOI18N

        roleTextField.setText(org.openide.util.NbBundle.getMessage(GrantPanel.class, "GrantPanel.roleTextField.text")); // NOI18N
        roleTextField.setPreferredSize(new java.awt.Dimension(200, 19));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 12, 0, 12);
        add(roleTextField, gridBagConstraints);

        entityNameLabel.setLabelFor(entityNameTextField);
        org.openide.awt.Mnemonics.setLocalizedText(entityNameLabel, org.openide.util.NbBundle.getMessage(GrantPanel.class, "LBL_Entity_Name2")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 12, 0, 0);
        add(entityNameLabel, gridBagConstraints);
        entityNameLabel.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(GrantPanel.class, "LBL_Entity_Name2")); // NOI18N
        entityNameLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(GrantPanel.class, "LBL_Entity_Name2")); // NOI18N

        entityNameTextField.setText(org.openide.util.NbBundle.getMessage(GrantPanel.class, "GrantPanel.entityNameTextField.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 12, 0, 12);
        add(entityNameTextField, gridBagConstraints);

        actionsLabel.setLabelFor(actionsTextField);
        org.openide.awt.Mnemonics.setLocalizedText(actionsLabel, org.openide.util.NbBundle.getMessage(GrantPanel.class, "LBL_Actions2")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 12, 0, 0);
        add(actionsLabel, gridBagConstraints);
        actionsLabel.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(GrantPanel.class, "LBL_Actions2")); // NOI18N
        actionsLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(GrantPanel.class, "LBL_Actions2")); // NOI18N

        actionsTextField.setText(org.openide.util.NbBundle.getMessage(GrantPanel.class, "GrantPanel.actionsTextField.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 12, 0, 12);
        add(actionsTextField, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel actionsLabel;
    private javax.swing.JTextField actionsTextField;
    private javax.swing.JLabel entityNameLabel;
    private javax.swing.JTextField entityNameTextField;
    private javax.swing.JLabel roleLabel;
    private javax.swing.JTextField roleTextField;
    // End of variables declaration//GEN-END:variables
    
}
