/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2009 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */


package org.netbeans.modules.apisupport.project.ui.customizer;

import org.netbeans.modules.apisupport.project.universe.TestModuleDependency;
import org.openide.util.NbBundle;

/**
 *
 * @author Tomas Musil
 */
public class EditTestDependencyPanel extends javax.swing.JPanel {
    private TestModuleDependency tmd ;
    
    /** Creates new form EditTestDependencyPanel */
    public EditTestDependencyPanel(final TestModuleDependency originalDep) {
        tmd = originalDep;
        initComponents();
        // #114356: dependency can be set as runtime only in project.xml
        compile.setVisible(false);
        fillOriginal();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        moduleJar = new javax.swing.JLabel();
        moduleJarValue = new javax.swing.JTextField();
        tests = new javax.swing.JCheckBox();
        compile = new javax.swing.JCheckBox();
        dependencies = new javax.swing.JCheckBox();

        moduleJar.setDisplayedMnemonic('M');
        moduleJar.setLabelFor(moduleJarValue);
        org.openide.awt.Mnemonics.setLocalizedText(moduleJar, org.openide.util.NbBundle.getMessage(EditTestDependencyPanel.class, "EditTestDependencyPanel.moduleJar.text")); // NOI18N

        moduleJarValue.setEditable(false);
        moduleJarValue.setText(org.openide.util.NbBundle.getMessage(EditTestDependencyPanel.class, "EditTestDependencyPanel.moduleJarValue.text")); // NOI18N

        tests.setMnemonic('T');
        org.openide.awt.Mnemonics.setLocalizedText(tests, org.openide.util.NbBundle.getMessage(EditTestDependencyPanel.class, "EditTestDependencyPanel.tests.text")); // NOI18N
        tests.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        tests.setMargin(new java.awt.Insets(0, 0, 0, 0));

        compile.setMnemonic('C');
        org.openide.awt.Mnemonics.setLocalizedText(compile, org.openide.util.NbBundle.getMessage(EditTestDependencyPanel.class, "EditTestDependencyPanel.compile.text")); // NOI18N
        compile.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        compile.setMargin(new java.awt.Insets(0, 0, 0, 0));

        dependencies.setMnemonic('R');
        org.openide.awt.Mnemonics.setLocalizedText(dependencies, org.openide.util.NbBundle.getMessage(EditTestDependencyPanel.class, "EditTestDependencyPanel.dependencies.text")); // NOI18N
        dependencies.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        dependencies.setMargin(new java.awt.Insets(0, 0, 0, 0));

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(moduleJar)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(moduleJarValue, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 262, Short.MAX_VALUE))
                    .add(tests)
                    .add(dependencies)
                    .add(compile))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(moduleJar)
                    .add(moduleJarValue, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(15, 15, 15)
                .add(tests)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(dependencies)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(compile)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        moduleJar.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(EditTestDependencyPanel.class, "EditTestDependencyPanel.moduleJar.AccessibleContext.accessibleDescription")); // NOI18N
        moduleJarValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EditTestDependencyPanel.class, "EditTestDependencyPanel.moduleJarValue.AccessibleContext.accessibleName")); // NOI18N
        moduleJarValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditTestDependencyPanel.class, "EditTestDependencyPanel.moduleJarValue.AccessibleContext.accessibleDescription")); // NOI18N
        tests.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(EditTestDependencyPanel.class, "EditTestDependencyPanel.tests.AccessibleContext.accessibleDescription")); // NOI18N
        compile.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(EditTestDependencyPanel.class, "EditTestDependencyPanel.compile.AccessibleContext.accessibleDescription")); // NOI18N
        dependencies.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(EditTestDependencyPanel.class, "EditTestDependencyPanel.dependencies.AccessibleContext.accessibleDescription")); // NOI18N

        getAccessibleContext().setAccessibleName(NbBundle.getMessage(EditTestDependencyPanel.class, "EditTestDependencyPanel.AccessibleContext.accessibleName")); // NOI18N
        getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditTestDependencyPanel.class, "EditTestDependencyPanel.AccessibleContext.accessibleDescription")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents
    
    private void fillOriginal(){
        moduleJarValue.setText(tmd.getModule().getCodeNameBase());
        tests.setSelected(tmd.isTest());
        compile.setSelected(tmd.isCompile());
        dependencies.setSelected(tmd.isRecursive());
    }
    
    
    public TestModuleDependency getEditedDependency(){
        
        return new TestModuleDependency(tmd.getModule(), tests.isSelected(), dependencies.isSelected(), 
                compile.isSelected());
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox compile;
    private javax.swing.JCheckBox dependencies;
    private javax.swing.JLabel moduleJar;
    private javax.swing.JTextField moduleJarValue;
    private javax.swing.JCheckBox tests;
    // End of variables declaration//GEN-END:variables
    
}
