#!/usr/bin/env python

import os
import tarfile
import time
import shutil
import subprocess
import platform

class Backup():

    def backup_job(self, BackupDB=True, Location="/var/lib/mythtv/bare"):
        """Backup all the files"""
        ## Check backup directory exists
        if not os.path.exists(Location):
            os.makedirs(Location)
        ## Array of files to Backup
        BACKUPFILES = [
        "/etc/mythtv/config.xml",
        "/etc/mythtv/mysql.txt",
        "/etc/lirc/lircd.conf",
        "/etc/lirc/hardware.conf",
        "/etc/hostname",
        "/etc/hosts",
        ]
        USER=os.getenv("HOME")
        BACKUPFILES.append(USER+"/.lirc")
        ## Set up backup location
        TMPDIR="/tmp/mythbuntu-bare"
        if not os.path.exists(TMPDIR):
            os.makedirs(TMPDIR)
        BACKUPFILES.append(TMPDIR)
        ## Set status file
        STATUSFILE="/tmp/mythbuntu-bare-status"
        if os.path.isfile(STATUSFILE):
            os.remove(STATUSFILE)
        timestamp=time.strftime("%Y%m%d-%H%M", time.localtime())
        ## Backup database only if told to do so
        DBB=""
        MBE=""
        if os.path.isfile("/usr/share/doc/mythtv-backend-master"):
          MBE="_MBE"
          DBB="_NODB"
          if BackupDB == True:
            #Run DB Backup
            os.system("echo '20\nBacking up database (this could take a few minutes)'>"+STATUSFILE)
            backupscript="/usr/share/mythtv/mythconverg_backup.pl"
            pipe = subprocess.Popen([backupscript, '--directory', TMPDIR], stdout=subprocess.PIPE).communicate()
            DBB="_YESDB"
        ## Setup for final tar file
        hostname = platform.node()
        tarfilename=Location+'/mythbuntu-system-backup_'+hostname+'_'+timestamp+MBE+DBB+'.tar.gz'
        TF=tarfile.open(tarfilename,mode='w:gz')
        os.system("echo '90\nZipping up files'>"+STATUSFILE)
	## Add files to tarball
        for item in BACKUPFILES:
            if os.path.exists(item):
              TF.add(item)
        TF.close()
        ## Remove tmp Backup directory and status file
        if os.path.exists(TMPDIR):
            shutil.rmtree(TMPDIR)
        if os.path.isfile(STATUSFILE):
            os.remove(STATUSFILE)

