//!
//! \addtogroup linuxui Linux UI
//! @{
//! 

#ifndef _HISTORY_TREE_H_
#define _HISTORY_TREE_H_

#include <gtkmm/scrolledwindow.h>
#include <gtkmm/liststore.h>
#include <gtkmm/treeview.h>
#include "workbench/wb_context_ui.h"
#include "base/trackable.h"    

class HistoryTree : public Gtk::ScrolledWindow, public base::trackable
{
  class Record : public Gtk::TreeModelColumnRecord
  {
  public:
    Gtk::TreeModelColumn<Glib::ustring> text;
    
    Record() { add(text); }
  } record;
  
  wb::WBContextUI *_wbui;
  Gtk::TreeView _tree;
  Glib::RefPtr<Gtk::ListStore> _model;
  wb::HistoryTreeBE *_history;
  boost::signals2::connection _refresh_conn;

  void activate_row(const Gtk::TreeModel::Path &path, Gtk::TreeViewColumn *column);

  void handle_menu(const std::string&, const std::vector<bec::NodeId>&);
  void refresh_tree(const bec::NodeId &parent, int ocount);
public:
  HistoryTree(wb::WBContextUI *wbui);
  virtual ~HistoryTree();

  void refresh();
};


#endif /* _HISTORY_TREE_H_ */

//!                                                                                                                                     
//! @}                                                                                                                                  
//!
