import zope.interface

from multibuild.builder.hooks import interfaces, register, support

class Hook(support.Hook):
    zope.interface.implements(interfaces.IHookBuildSourceGet)

    name = "source-apt"

    def sourceGet(self, build):
        cmd = ["apt-get", "source", "%s=%s" % (build.package, build.version)]

        f = build.environment.run_dir(cmd, build.environment.build_dir)

        while True:
            i = f.readline()
            if not i:
                break
            build.log.write(i)
            build.log.flush()

        if f.close():
            raise RuntimeError, "Failed"

register(Hook)
