import os
import shutil
import zope.interface

from multibuild.builder.hooks import interfaces, register, apt, spawn

try:
    from UUID import uuid4
except ImportError:
    class UUID(object):
        def __init__(self, bytes=None, version=None):
            int = long(('%02x'*16) % tuple(map(ord, bytes)), 16)
            if version is not None:
                int &= ~(0xc000 << 48L)
                int |= 0x8000 << 48L
                int &= ~(0xf000 << 64L)
                int |= version << 76L
            self.__dict__['int'] = int

        def __str__(self):
            hex = '%032x' % self.int
            return '%s-%s-%s-%s-%s' % (
                hex[:8], hex[8:12], hex[12:16], hex[16:20], hex[20:])

    def uuid4():
        return UUID(bytes=os.urandom(16), version=4)

class Hook(apt.Hook):
    zope.interface.implements(interfaces.IHookEnvironment)
    zope.interface.classProvides(interfaces.IHookEnvironmentFactory)

    name = "environment-own"

    root = "/srv/chroot"
    build_dir = "/build"

    def __init__(self, id, dist, arch, user, log):
        self.id, self.dist, self.arch, self.user, self.log = id, dist, arch, user, log
        self.uuid = '_'.join((str(uuid4()), arch, dist, user, str(os.getpid())))
        self.path = "%s/active/%s" % (self.root, self.uuid)
        self.build_path = "%s%s" % (self.path, self.build_dir)

    def _exec(self, mcmd, cmd = ''):
        pcmd = "sudo multibuild-chroot %s %s %s %s" % (mcmd, self.root, self.uuid, cmd)
        return spawn.spawn(pcmd)

    def cleanup(self, build):
        f = self._exec('remove-active')
        try:
            self._output_log(f, build.log)
        finally:
            if f.kill():
                self.log.write("chroot removal failed")

    def install(self, build, packages):
        self.install_apt(build, packages)

    def prepare(self, build):
        f = self._exec('build-active', "%s %s buildd" % (self.dist, self.arch))
        try:
            self._output_log(f, build.log)
        finally:
            if f.kill():
                self.log.write("chroot creation failed")

        try:
            os.stat(self.path)
        except OSError:
            raise RuntimeError, "Environment does not exist"

        f = self.run("dpkg --print-installation-architecture")
        self.arch_root = f.readline().strip()
        if f.close():
            raise RuntimeError, "dpkg failed"

        self.run(['mkdir', '-p', self.build_dir])

        self.prepare_apt()

    def run(self, cmd, dir = None, root = False):
        if isinstance(cmd, list):
            cmd = ' '.join(cmd)
        cmd = cmd.replace("'", r"'\''")
        if dir is not None:
            cmd = "cd '%s'; %s" % (dir.replace("'", r"'\''"), cmd)
        if root:
            pcmd = "sh -c 'set -e; %s' 2>&1" % cmd
        else:
            pcmd = "su -s /bin/sh -c 'set -e; %s' '%s' 2>&1" % (cmd, self.user)
        return self._exec('execute-active', pcmd)

    run_dir = run

    def suexec(self, cmd):
        return self.run(cmd, root = True)

register(Hook)
