#pragma warning( disable : 4786 )

// ----------------------------------------------------------------------------
// headers
// ----------------------------------------------------------------------------
// For compilers that support precompilation, includes "wx/wx.h".
#if defined(__WXGTK__) || defined(__WXMOTIF__)
        #include <wx/wx.h>
#endif

#include <wx/wxprec.h>
#include <wx/config.h>

#include <string>
#include <fstream>
#include "StringConvert.h"

#include "MRIConvert.h"
#include "McFrame.h"
#include "McPanel.h"
#include "TextFileViewer.h"

#include "MRIConvert.xpm"

using namespace std;

// ----------------------------------------------------------------------------
// resources
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// constants
// ----------------------------------------------------------------------------
enum {
	MENU_INPUT_ADD_FILES = 1,
	MENU_INPUT_ADD_DIR,
	MENU_INPUT_REMOVE,
	MENU_INPUT_INFO,
	MENU_INPUT_DICOM,
	MENU_INPUT_IMAGE,
	MENU_CONVERT_NEW,
	MENU_CONVERT_CONVERT,
	MENU_OUTPUT_DIRECTORY,
	MENU_OUTPUT_RENAME,
	MENU_OUTPUT_OPTIONS,
	MENU_OUTPUT_OVERRIDE,
	MENU_HELP
};

BEGIN_EVENT_TABLE(McFrame, wxFrame)

	EVT_MENU(MENU_CONVERT_NEW,			McFrame::OnNew)
	EVT_MENU(MENU_INPUT_ADD_FILES,		McFrame::OnAddFiles)
	EVT_MENU(MENU_INPUT_ADD_DIR,		McFrame::OnAddDir)
	EVT_MENU(MENU_OUTPUT_DIRECTORY,		McFrame::OnDirectory)
	EVT_MENU(MENU_CONVERT_CONVERT,		McFrame::OnConvert)
	EVT_MENU(MENU_INPUT_INFO,			McFrame::OnInfo)
	EVT_MENU(MENU_INPUT_DICOM,			McFrame::OnDicom)
	EVT_MENU(MENU_INPUT_IMAGE,			McFrame::OnImage)
	EVT_MENU(MENU_INPUT_REMOVE,			McFrame::OnRemove)
	EVT_MENU(MENU_OUTPUT_RENAME,		McFrame::OnRename)
	EVT_MENU(MENU_OUTPUT_OPTIONS,		McFrame::OnOptions)
	EVT_MENU(MENU_OUTPUT_OVERRIDE,		McFrame::OnOverride)
	EVT_MENU(wxID_ABOUT,				McFrame::OnAbout)
	EVT_MENU(MENU_HELP,					McFrame::OnHelp)
	EVT_MENU(wxID_EXIT,					McFrame::OnQuit)

END_EVENT_TABLE()

// ----------------------------------------------------------------------------
// main frame
// ----------------------------------------------------------------------------

// frame constructor
McFrame::McFrame(const wxString& title, const wxPoint& pos, const wxSize& size)
       : wxFrame((wxFrame *)NULL, -1, title, pos, size)
{
//	SetIcon(wxIcon("MRICONVERT", wxBITMAP_TYPE_ICO_RESOURCE));
	SetIcon(wxIcon(MRIConvert));

	CreateStatusBar();

	wxMenuBar* pMenuBar = new wxMenuBar();

	wxMenu* pInputMenu = new wxMenu();
	pInputMenu->Append(MENU_INPUT_ADD_FILES, _T("&Add Files\tCtrl+A"), _T("Add files to convert"));
	pInputMenu->Append(MENU_INPUT_ADD_DIR, _T("Add &Folder\tCtrl+F"), 
		_T("Add directory of files to convert"));
	pInputMenu->Append(MENU_INPUT_REMOVE, _T("&Remove\tCtrl+R"), _T("Remove files"));

	pInputMenu->AppendSeparator();
	pInputMenu->Append(MENU_INPUT_INFO, _T("&Series Info\tCtrl+S"), _T("View series information"));
	pInputMenu->AppendSeparator();
	pInputMenu->Append(MENU_INPUT_DICOM, _T("View &DICOM\tCtrl+D"), _T("View DICOM file as text"));
	pInputMenu->Append(MENU_INPUT_IMAGE, _T("View &Image\tCtrl+I"), _T("View image from DICOM file"));
	pMenuBar->Append(pInputMenu, _T("&Input"));

	wxMenu* pOutputMenu = new wxMenu();
	pOutputMenu->Append(MENU_OUTPUT_DIRECTORY, _T("&Directory\tAlt+D"), _T("Set output directory"));
	pOutputMenu->Append(MENU_OUTPUT_RENAME, _T("&Rename\tAlt+R"), _T("Rename output files/directories"));
	pOutputMenu->Append(MENU_OUTPUT_OPTIONS, _T("&Options\tAlt+O"), 
		_T("Set default options for this format"));
	pOutputMenu->Append(MENU_OUTPUT_OVERRIDE, _T("Override"), _T("Override default options for this format"));

	pMenuBar->Append(pOutputMenu, _T("&Output"));

	wxMenu* pConvertMenu = new wxMenu();
	pConvertMenu->Append(MENU_CONVERT_CONVERT, _T("&Convert All\tCtrl+C"), _T("Convert all files"));
	pConvertMenu->Append(MENU_CONVERT_NEW, _T("&New session\tCtrl+N"), _T("Start new session"));
	pConvertMenu->Append(wxID_EXIT, _T("E&xit\tCtrl+X"), _T("Quit the application"));
	pMenuBar->Append(pConvertMenu, _T("&Convert"));

	wxMenu* pHelpMenu = new wxMenu();
	pHelpMenu->Append(MENU_HELP, _T("File formats"), _T("About output file formats"));
	pHelpMenu->Append(wxID_ABOUT, _T("&About"), _T("About MRIConvert"));
	pMenuBar->Append(pHelpMenu, _T("&Help"));

	SetMenuBar(pMenuBar);

	mpPanel = new McPanel(this);

	wxBoxSizer* sizer = new wxBoxSizer(wxVERTICAL);
	sizer->Add(mpPanel, 1, wxEXPAND);
	SetSizer(sizer);
	sizer->SetSizeHints(this);
	SetSize(size);

}

McFrame::~McFrame()
{
	wxConfig::Get()->Write(_T("framewidth"), GetSize().GetWidth());
	wxConfig::Get()->Write(_T("frameheight"), GetSize().GetHeight());
}

void
McFrame::OnAddDir(wxCommandEvent& event)
{
	wxCommandEvent nullEvent(0,0);
	mpPanel->OnAddDir(nullEvent);
}

void
McFrame::OnAddFiles(wxCommandEvent& event)
{
	wxCommandEvent nullEvent(0,0);
	mpPanel->OnAddFiles(nullEvent);

}

void
McFrame::OnDicom(wxCommandEvent& event)
{
	wxCommandEvent nullEvent(0,0);
	mpPanel->OnDicom(nullEvent);
}

void
McFrame::OnImage(wxCommandEvent& event)
{
	wxCommandEvent nullEvent(0,0);
	mpPanel->OnImage(nullEvent);
}

void
McFrame::OnInfo(wxCommandEvent& event)
{
	wxCommandEvent nullEvent(0,0);
	mpPanel->OnInfo(nullEvent);
}

void
McFrame::OnRemove(wxCommandEvent& event)
{
	wxCommandEvent nullEvent(0,0);
	mpPanel->OnRemove(nullEvent);
}

void
McFrame::OnDirectory(wxCommandEvent& event)
{
	wxCommandEvent nullEvent(0,0);
	mpPanel->OnDirectory(nullEvent);
}

void
McFrame::OnNew(wxCommandEvent& event)
{
	wxCommandEvent nullEvent(0,0);
	mpPanel->OnNew(nullEvent);
}

void
McFrame::OnConvert(wxCommandEvent& event)
{
	wxCommandEvent nullEvent(0,0);
	mpPanel->OnConvert(nullEvent);
}

void
McFrame::OnRename(wxCommandEvent& event)
{
	wxCommandEvent nullEvent(0,0);
	mpPanel->OnRename(nullEvent);
}

void
McFrame::OnOptions(wxCommandEvent& event)
{
	wxCommandEvent nullEvent(0,0);
	mpPanel->OnOptions(nullEvent);
}

void
McFrame::OnOverride(wxCommandEvent& event)
{
	mpPanel->OnMenuOverride();
}

void
McFrame::OnAbout(wxCommandEvent& event)
{
	wxString message_text;
	message_text << _T("MRIConvert\n")
				 << _T("version 2.0 rev. 190\n")
				 << _T("Jolinda Smith\n")
				 << _T("Lewis Center for NeuroImaging         \n")
				 << _T("University of Oregon\n")
				 << _T("http://lcni.uoregon.edu\n")
				 << _T("jolinda@uoregon.edu\n");
	
	wxMessageBox(message_text,
                 _T("About MRIConvert"),
                 wxICON_INFORMATION);
}

void
McFrame::OnHelp(wxCommandEvent& event)
{
	wxFileName appPath(wxGetApp().argv[0]);
    wxString appDir(appPath.GetPath(wxPATH_GET_VOLUME));

	wxString filename = appDir + _T("/fileformats.txt");

	TextFileViewer *view = new TextFileViewer(this, "About file formats", filename.mb_str(wxConvLocal));
	view->Show();
}

void 
McFrame::OnQuit(wxCommandEvent& event)
{
	Close(true);
}
