/*
  Main workhorse for getting field definitions for various formats.
 */

/*
I'm not sure what happened to the various string conversions in this file, but they're a total mess.
todo -- fix!
jcs
*/

#include <wx/filename.h>
#include <wx/stdpaths.h>
#include <wx/log.h>
#include <wx/app.h>

#include <iostream>
#include <fstream>
#include <sstream>
#include <algorithm>

#include "Dictionary.h"

using namespace jcs;

using std::map;
using std::vector;
using std::string;
using std::ios_base;

std::string __OS_X_BUG_argv_0__ = "";

/**
   Returns as a wxString the directory in which dictionary definition files are found.
**/
wxString
GetDictionaryDir()
{
  wxString dir;

  // Use hammer to make OS X mcverter work.
  // __OS_X_BUG_argv_0__ is set only in McVerter main function.
  // Trying to fix Chuck's hammer.
#ifdef ABC  //WXOSX_
  if (__OS_X_BUG_argv_0__.compare ("") != 0) {
    wxString cwd = wxGetCwd();
    std::cout << "cwd: " << cwd << std::endl;
    FILE * fp = popen ("pwd", "r");
    char buff[2048];
    fgets (buff, sizeof (buff), fp);
    pclose (fp);
    dir = ((wxFileName)(wxString (buff, wxConvLocal).Trim() +
			//dir = ((wxFileName)(cwd +
			_T("/") +
			wxString(__OS_X_BUG_argv_0__.c_str(), wxConvLocal))).GetPath();
    std::cout << dir << std::endl;
  } else {
    // This works for OS X and Linux MRIConvert and for Linux mcverter.
    dir = ((wxFileName)wxStandardPaths::Get().GetExecutablePath()).GetPath();
  }
#else
  // This works for Windows MRIConvert.
  dir = ((wxFileName)wxStandardPaths::Get().GetExecutablePath()).GetPath();
#endif
  return dir;
}


static bool
IsComment(string& s)
{
	return (!s.compare(0, 2, "//"));
}

DicomTag
jcs::Tag(const std::string& s, const Dictionary* dict)
{
	return dict->Lookup(s).tag;
}

bool
DicomTag::operator== (const DicomTag& rhs) const 
{
	return((group   == rhs.group)
	    && (element == rhs.element));
}

bool
DicomTag::operator!= (const DicomTag& rhs) const 
{
	return !(*this == rhs);
}

bool
DicomTag::operator< (const DicomTag& rhs) const
{
	return((group < rhs.group) ||
		((group == rhs.group) && (element < rhs.element)));
}

bool
DicomTag::operator> (const DicomTag& rhs) const
{
	return((group > rhs.group) ||
		((group == rhs.group) && (element > rhs.element)));
}

std::ostream&
jcs::operator<< (std::ostream& out, const DicomTag& rhs)
{
	out << std::hex << '(';
	out.fill('0');
	out.width(4);
	out << rhs.group << ',';
	out.width(4); 
	out << rhs.element << ')' << ' ';
	out << std::dec;
	return out;
}

/**
   Dictionary class, used to maintain tuples of DICOM field definitions.
   Parent class of more-specific Dictionaries.
   Field definitions are maintained as a TagMap and a StringMap.
 **/
Dictionary::Dictionary(const std::string& filename)
: mFilename(filename)
{
	NULL_ENTRY = DicomElement(DicomTag(0x0000, 0x0000), "");
	Init();
}

void
Dictionary::Init()
{
  if (mFilename.compare (fnDicom) == 0) {
    std::cout << "fnDicom" << std::endl;
#include "DicomDictionary.h"
  } else if (mFilename.compare (fnExcite) == 0) {
    std::cout << "fnExcite" << std::endl;
#include "ExciteDictionary.h"
  } else if (mFilename.compare (fnNumaris) == 0) {
    std::cout << "fnNumaris" << std::endl;
#include "NumarisDictionary.h"
  } else if (mFilename.compare (fnPhilips) == 0) {
    std::cout << "fnPhilips" << std::endl;
#include "PhilipsDictionary.h"
  } else {
    std::cout << "no fnWhatever" << std::endl;
    wxString file = GetDictionaryDir() + _T("/") + wxString(mFilename.c_str(), wxConvLocal);
    std::ifstream input(file.mb_str(wxConvLocal));
    if (input.good()) {
      string line;
      std::getline(input, line);
      while (input.good()) {
	if(!IsComment(line) && !line.empty()) {
	  DicomElement e;
	  std::stringstream ss;
	  ss.setf(ios_base::hex, ios_base::basefield ); 
	  ss << line;
	  ss >> e.description;
	  ss >> e.tag.group;
	  ss >> e.tag.element;
	  if (ss.good()) ss >> e.vr;
	  mAddEntry(e);
	}
	std::getline (input, line);
      }
      input.close();
    } else {
      wxLogError (_T("Error opening dictionary file."));
    }
  }
}

/**
   Look up a DICOM element in mTagMap.
 **/
const DicomElement
Dictionary::Lookup(const DicomTag& tag) const
{
	if (mTagMap.size() == 0) {
	  wxLogError(_T("Error: dictionary file %s not found in %s."),
	  	     wxString(mFilename.c_str(), wxConvLocal).c_str(),
		     GetDictionaryDir().c_str());
	  return DicomElement(tag, "unknown");
	}
	if (mTagMap.count(tag) == 0) {
		return DicomElement(tag, "unknown");
	} else {
		DicomElement e = (*mTagMap.find(tag)).second;
		return e;
	}
}

/**
   Look up a DICOM element in mStringMap.
 **/
const DicomElement
Dictionary::Lookup(const std::string& desc) const
{
	if (mStringMap.size() == 0) {
	  wxLogError(_T("Error: dictionary file %s not found in %s."),
	  	     wxString(mFilename.c_str(), wxConvLocal).c_str(),
		     GetDictionaryDir().c_str());
	  return NULL_ENTRY;
	}
	if (mStringMap.count(desc) == 0) {
		wxLogError(_T("%s not in dictionary"),
			   wxString(desc.c_str(), wxConvLocal).c_str());
		return NULL_ENTRY;
	} else {
		DicomElement e = (*mStringMap.find(desc)).second;
		return e;
	}
}

static std::string
GetDescription(std::pair<DicomTag, DicomElement> tag_pair)
{
	return tag_pair.second.description;
}

vector<std::string>
Dictionary::TagList() const
{
	vector<std::string> v;
	v.reserve(mTagMap.size());
	std::transform(mTagMap.begin(), mTagMap.end(),
		std::back_inserter(v), GetDescription);
	return v;
}

void
Dictionary::mAddEntry(const DicomElement& e)
{
	mTagMap[e.tag] = e;
	mStringMap[e.description] = e;
}

Dictionary*
Numaris_Dictionary::Instance()
{
	static Numaris_Dictionary inst;
	return &inst;
}

Dictionary*
Excite_Dictionary::Instance()
{
	static Excite_Dictionary inst;
	return &inst;
}

Dictionary*
PhilipsMr_Dictionary::Instance()
{
	static PhilipsMr_Dictionary inst;
	return &inst;
}

Dictionary*
Dicom_Dictionary::Instance()
{
	static Dicom_Dictionary inst;
	return &inst;
}

