#ifndef BT_TYPES_BCODE_H
#define BT_TYPES_BCODE_H

#include <apr.h>
#include <apr_pools.h>
#include <apr_errno.h>
#include <sys/types.h>
#include <stdint.h>

#define BT_BCODE_TYPE_INT   1
#define BT_BCODE_TYPE_STR   2
#define BT_BCODE_TYPE_LIST  4
#define BT_BCODE_TYPE_DICT  8

#define BT_BCODE_LIST_SIZE 20

#define BT_BCODE_ERR_START              APR_OS_START_USERERR + 1000

#define BT_BCODE_SUCCESS                APR_SUCCESS
#define BT_BCODE_ERR_BAD_INT            BT_BCODE_ERR_START + 1
#define BT_BCODE_ERR_BAD_LIST           BT_BCODE_ERR_START + 2
#define BT_BCODE_ERR_BAD_DICT           BT_BCODE_ERR_START + 3
#define BT_BCODE_ERR_DICT_UNEVEN        BT_BCODE_ERR_START + 4
#define BT_BCODE_ERR_BAD_STRING         BT_BCODE_ERR_START + 5
#define BT_BCODE_ERR_BAD_STRING_LENGTH  BT_BCODE_ERR_START + 6

typedef struct bt_bcode_s bt_bcode;

typedef union {
    int64_t i;
    struct {
        apr_size_t  i;
        char*       s;
    } s;
    struct {
        apr_size_t  alloc;
        uint32_t    count;
        bt_bcode*   vals;
    } l;
} bt_bcode_val;


struct bt_bcode_s {
    char*           begin;
    char*           end;
    char            type;
    bt_bcode_val    val;
};

/* to/from buffers */
extern int bt_bcode_decode(apr_pool_t* p, char* buf, bt_bcode* val, char** end);
extern int bt_bcode_encode(
    apr_pool_t* p, bt_bcode* val, char** rv, apr_size_t* len, apr_pool_t** rpool
);

/* bcode assembly */
extern bt_bcode* bt_bcode_new_int(apr_pool_t* p, int64_t i);
extern bt_bcode* bt_bcode_new_strn(
    apr_pool_t* p, const uint8_t* buf, apr_size_t len
);
extern bt_bcode* bt_bcode_new_str(apr_pool_t* p, const char* buf);
extern bt_bcode* bt_bcode_new_list(apr_pool_t* p, unsigned int size);
extern bt_bcode* bt_bcode_new_dict(apr_pool_t* p, unsigned int size);
extern apr_status_t bt_bcode_list_add(
    bt_bcode* list, unsigned int pos, bt_bcode* entry
);
extern apr_status_t bt_bcode_dict_add(
    apr_pool_t* p,
    bt_bcode* dict, unsigned int pos, const char* name, bt_bcode* entry
);

/* misc */
extern bt_bcode* bt_bcode_find(bt_bcode* val, char* key);
extern const char* bt_bcode_error(int val);

#endif /* BT_TYPES_BCODE_H */
