#include <libbtutil.h>
#include <libbtpeer/io.h>
#include <libbtpeer/metainfo.h>
#include <libbtpeer/types/btp_torrent.h>
#include <libbtpeer/types/btp_torrent/pieces.h>
#include <libbtpeer/hooks.h>

#include <apr.h>
#include <apr_errno.h>
#include <apr_hooks.h>
#include <stdint.h>
#include <malloc.h>
#include <string.h>

apr_status_t btp_metainfo_check(btp_torrent* t, void* data) {
    uint8_t* buf = malloc(t->info->piece_size);
    uint8_t hash[BT_SHA1_OUTPUT_SIZE];
    int i;
    bt_off_t actual, size;
    apr_status_t ret;

    t->pieces = btp_torrent_pieces_init(t);
    t->status = t->status | BTP_TORRENT_STATUS_CHECK;
    
    for(i=0; i<t->info->piece_count; i++) {
        size = bt_metainfo_piece_size(t->info, i);
        
        if(
            (ret = btp_torrent_io_piece_buffer(t, i, buf, 0, &actual))
            != APR_SUCCESS
        ) {
            t->status =
                (t->status & ~BTP_TORRENT_STATUS_CHECK) |
                BTP_TORRENT_STATUS_ERROR;
            btp_run_metainfo_sha1(t, NULL, data);
            free(buf);
            return ret;
        }
        
        if(actual == size) {
            BT_SHA1(buf, size, hash);
            if(!memcmp(
                hash, &(t->info->pieces[BT_SHA1_OUTPUT_SIZE * i]),
                BT_SHA1_OUTPUT_SIZE
             ))
                btp_torrent_piece_add(t, i);
            
            btp_run_metainfo_sha1(t, NULL, data);
        }
    }
    
    t->status &= ~BTP_TORRENT_STATUS_CHECK;
    btp_run_metainfo_sha1(t, NULL, data);
    free(buf);
    return APR_SUCCESS;
}

apr_status_t btp_metainfo_generate_hash(btp_torrent* t, void* data) {
    uint8_t* buf = malloc(t->info->piece_size);
    uint8_t hash[BT_SHA1_OUTPUT_SIZE];
    int i;
    bt_off_t actual, size;
    apr_status_t ret;

    t->pieces = btp_torrent_pieces_init(t);
    
    for(i=0; i<t->info->piece_count; i++) {
        size = bt_metainfo_piece_size(t->info, i);
        
        if(
            (ret = btp_torrent_io_piece_buffer(t, i, buf, 0, &actual))
            != APR_SUCCESS
        ) {
            btp_run_metainfo_sha1(t, NULL, data);
            free(buf);
            return ret;
        }
        
        if(actual == size) {
            BT_SHA1(buf, size, hash);
            bt_metainfo_set_piece_hash(t->info, i, hash);
            btp_torrent_piece_add(t, i);
            btp_run_metainfo_sha1(t, NULL, data);            
        } else {
            btp_run_metainfo_sha1(t, NULL, data);
            return APR_EOF;
        }
    }
    
    btp_run_metainfo_sha1(t, NULL, data);
    free(buf);
    return APR_SUCCESS;
}
