#!@PERL@

use strict;
use warnings;
use vars qw(@ARGV);

use LWP::UserAgent;
use LWP::Simple qw(get);
use HTTP::Request;
use HTTP::Response;
use URI::Escape;
use Convert::Bencode_XS qw(bdecode);
use Data::Dumper;

sub bhex ($);
sub hashjunk ();

if(@ARGV != 2 && @ARGV != 3)
{
 die "Usage: $0 tracker_scrape_url tracker_announce_url [tracker_register_url]\n";
}

my $data;

$data = bdecode(get($ARGV[0]));
keys(%$data);

my $ua = LWP::UserAgent->new();
my $url;
my $req;
my $st = time();
my $nn = 0;
$|=1;

while(my($k,$v) = each(%{$data->{files}}))
{
 my $hashstr = $k;
 my $complete = $v->{snatches} || $v->{complete};
 print bhex($k), ": $complete ";

 if($ARGV[2])
 {
  $url = "$ARGV[2]?name=" . uri_escape($v->{name}) . "\&info_hash=" . uri_escape($hashstr);
  print "$url\n ";
  $req = HTTP::Request->new(GET => $url);
  $ua->request($req);
 }
 
 my $j = 0;
 while($j < $complete)
 {
  $j++;
  $nn++;
  my $port;
  my $peerid = hashjunk();
  $port = int(rand(30000)+3000);
  $url = sprintf("%s?info_hash=%s&peer_id=%s&port=%s&downloaded=0&left=0&uploaded=0&event=completed", $ARGV[1], uri_escape($hashstr), uri_escape($peerid), $port);
  $req = HTTP::Request->new(GET => $url);
  my $response = $ua->request($req);
  $url = sprintf("%s?info_hash=%s&peer_id=%s&port=%s&downloaded=0&left=0&uploaded=0&event=stopped", $ARGV[1], uri_escape($hashstr), uri_escape($peerid), $port);
  $req = HTTP::Request->new(GET => $url);
  $response = $ua->request($req);
  print ".";
 }

 print "\n";
}

my $et = time();
my $tt = $et - $st;
my $rps = $nn / $tt;

printf("Sent %d requests in %d seconds (%.02f req/s)\n", $nn, $tt, $rps);

exit(0);

sub bhex ($)
{
 my $datax = shift;
 my $rv;
 
 for my $i (0 .. length($datax) - 1)
 {
  $rv .= sprintf("%02x", ord(substr($datax, $i, 1)));
 }
 return $rv;
}

sub hashjunk ()
{
 my $junk = '';
 my $i;
 for $i (1 .. 20)
 {
  $junk.=chr(int(rand(255))+1);
 }
 return $junk;
}
