/* $Id: openssdpsocket.h,v 1.3 2011/05/23 12:23:21 nanard Exp $ */
/* MiniUPnP project
 * http://miniupnp.free.fr/ or http://miniupnp.tuxfamily.org/
 * (c) 2006-2011 Thomas Bernard
 * This software is subject to the conditions detailed
 * in the LICENCE file provided within the distribution */
#ifndef __OPENSSDPSOCKET_H__
#define __OPENSSDPSOCKET_H__

/**
 * Open a socket and configure it for receiving SSDP packets
 *
 * @param n_listen_addr	size of listen_addr array
 * @param listen_addr	array of address (or interface names) to listen
 * @param ipv6	open INET6 or INET socket
 * @return socket
 */
int
OpenAndConfSSDPReceiveSocket(int n_listen_addr,
							 const char * * listen_addr,
                             int ipv6);

#endif

