/*  This file is part of MED.
 *
 *  COPYRIGHT (C) 1999 - 2009  EDF R&D, CEA/DEN
 *  MED is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  MED is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with MED.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <med.h>
#include <med_config.h>
#include <med_utils.h>
#include <stdlib.h>



int main(int argc, char *argv[]) {
  med_idt fid;
  med_int majeur, mineur, release;
  med_err ret;

  if (argc != 2) {
    fprintf(stdout,">> Utilisation : medconforme <nom_de_fichier_med> \n");
    return 0;
  }

  /*
   * Quelle version de la bibliotheque MED est utilisee ?
   */
  MEDversionDonner(&majeur, &mineur, &release);
  fprintf(stdout,"- Version de MED-fichier utilise par medconforme : %d.%d.%d \n",majeur,mineur,release); 

  /*
   * Le fichier  lire est-il au bon format de fichier HDF ?
   */
  if (! MEDformatConforme(argv[1]) )
    fprintf(stdout,"- Format HDF du fichier MED [%s] conforme au format HDF utilis par la bibliothque \n",argv[1]);
  else {
    fprintf(stdout,"- Format HDF du fichier MED [%s] non conforme au format HDF utilis par la bibliothque \n",argv[1]);
    return -1;
  }

  /*
   * Le fichier  lire a-t-il t cr avec une version de la bilbiothque MED conforme avec celle utilise ?
   * (Numros majeur et mineur identiques).
   */
  if (! MEDversionConforme(argv[1]))
    fprintf(stdout,"- Version MED du fichier [%s] conforme a la bibliothque MED utilise \n",argv[1]);
  else 
    fprintf(stdout,"- Version MED du fichier [%s] non conforme avec celle de la bibliothque utilise \n",argv[1]);

  fid = MEDouvrir(argv[1],MED_LECTURE);
  if (fid < 0)
    fprintf(stderr,">> ERREUR a l'ouverture du fichier [%s] \n",argv[1]);

  /*
   * Une fois le fichier ouvert on peut avoir acces au numero de version complet
   */
  ret = MEDversionLire(fid, &majeur, &mineur, &release);
  EXIT_IF(ret < 0,"Lecture du numro de version",NULL);

  if (mineur != -1)
    fprintf(stdout,"- Ce fichier a ete cr avec MED-fichier V%d.%d.%d \n",majeur,mineur,release); 
  else
    fprintf(stdout,"- Ce fichier a ete cr avec MED-fichier V2.0 ou MED-fichier V2.1.X avec X <= 4 \n"); 

  ret = MEDfermer(fid);
  EXIT_IF(ret < 0,"Fermeture du fichier",argv[1]);

  return 0;
}
