/*  This file is part of MED.
 *
 *  COPYRIGHT (C) 1999 - 2009  EDF R&D, CEA/DEN
 *  MED is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  MED is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with MED.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <med.h>
#include <med_config.h>
#include <med_outils.h>

#include <string.h>
#include <stdlib.h>

med_err
MEDpolygoneInfo(med_idt fid, char *maa, med_entite_maillage type_ent, med_connectivite type_conn, 
		med_int *consize)
{
  med_idt root, maaid, entid,geoid, dataset=0;
  med_err ret = 0;
  char chemin[MED_TAILLE_MAA+MED_TAILLE_NOM+1];
  char nom_ent[MED_TAILLE_NOM_ENTITE+1];
  char nom_geo[MED_TAILLE_NOM_ENTITE+1];
  char nom_dataset[MED_TAILLE_NOM_ENTITE+1];
  med_int res = 0;
  med_entite_maillage _type_ent=type_ent;

  if ( type_ent == MED_NOEUD_MAILLE ) _type_ent=MED_NOEUD ;
  /*
   * On inhibe le gestionnaire d'erreur HDF 5
   */
  _MEDmodeErreurVerrouiller();

  /*
   * Si le maillage n'existe pas => erreur
   */
  strcpy(chemin,MED_MAA);
  strcat(chemin,maa);
  if ((maaid = _MEDdatagroupOuvrir(fid,chemin)) < 0)
    return -1;

  /*
   * Acces au groupe HDF des entites (MAILLE | FACE)
   */
  if ((ret = _MEDnomEntite(nom_ent,_type_ent)) < 0)
    return -1;
  if ((entid = _MEDdatagroupOuvrir(maaid,nom_ent)) < 0)
    return -1;

  /*
   * Acces au groupe HDF du type geometrique MED_POLYGONE
   */
  if ((ret = _MEDnomGeometrie(nom_geo,MED_POLYGONE)) < 0)
    return -1;
  if ((geoid = _MEDdatagroupOuvrir(entid,nom_geo)) < 0)
    return -1;
  
   /*
    * Ouverture du dataset HDF correspondant au mode de connectivite 
    * S'il n'existe pas => erreur
    * Sinon lecture de l'attribut HDF "TAI" qui designe la taille
    * du tableau des connectivites
    */ 
   switch(type_conn)
     {
     case MED_NOD :
       strcpy(nom_dataset,MED_NOM_NOD);
       break;

     case MED_DESC :
       strcpy(nom_dataset,MED_NOM_DES);
       break;
       
     default :
       return -1;
     }
   if ((dataset = _MEDdatasetOuvrir(geoid,nom_dataset)) < 0)
     return -1;
   if ((ret = _MEDattrEntierLire(dataset,MED_NOM_TAI,consize)) < 0)
     return -1;
   if ((ret = _MEDdatasetFermer(dataset)) < 0)
     return -1;

   /*
    * On ferme tout
    */
   if (geoid > 0)
     if ((ret = _MEDdatagroupFermer(geoid)) < 0)
       return -1;
   if (entid > 0)
     if ((ret = _MEDdatagroupFermer(entid)) < 0)
       return -1;
   if ((ret = _MEDdatagroupFermer(maaid)) < 0)
     return -1; 

  return ret;
}
