/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file IsoShadingAttributes.cc
    \brief Implemtation of IsoShading Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Thu Jun 16 12:02:55 2011
*/    

#include "IsoShadingAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;

template <class P>
IsoShadingAttributes<P>::IsoShadingAttributes():
	max_(ParameterManager::getDouble("contour_shade_max_level")),
	min_(ParameterManager::getDouble("contour_shade_min_level")),
	colourMethod_(Translator<string, ColourTechnique>().magics("contour_shade_colour_method")),
	labelBlanking_(Translator<string, bool>().magics("contour_shade_label_blanking"))
{

	Translator<string, ShadingTechnique<P> > technique;
	setTechnique(technique.magics("contour_shade_technique"));
} 


template <class P>
IsoShadingAttributes<P>::~IsoShadingAttributes()
{
}

template <class P>    
void IsoShadingAttributes<P>::set(const std::map<string, string>& params)
{
	vector<string> prefix(5);
	prefix[0] = "contour_shade";
	prefix[1] = "contour_shade";
	prefix[2] = "contour_shade";
	prefix[3] = "contour";
	prefix[4] = "contour";

	setMember(prefix, "contour_shade_technique", technique_, params);
	setAttribute(prefix, "contour_shade_max_level", max_, params);
	setAttribute(prefix, "contour_shade_min_level", min_, params);
	setMember(prefix, "contour_shade_colour_method", colourMethod_, params);
	setAttribute(prefix, "contour_shade_label_blanking", labelBlanking_, params);
}
template <class P>
void IsoShadingAttributes<P>::copy(const IsoShadingAttributes& other)
{
	setTechnique(other.technique_->clone());
	max_ = other.max_;
	min_ = other.min_;
	setColourMethod(other.colourMethod_->clone());
	labelBlanking_ = other.labelBlanking_;
} 

template <class P>
bool IsoShadingAttributes<P>::accept(const string& node)
{	
	if ( magCompare(node, "shading")  )
		return true;

	if ( acceptNode(node, technique_) )
		return true;

	if ( acceptNode(node, colourMethod_) )
		return true;
	return false;
}
template <class P>
void IsoShadingAttributes<P>::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "shading") )
		set(node.attributes());
	else {
		setMember(node.name(), technique_, node);
		setMember(node.name(), colourMethod_, node);
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
		setMember((*elt)->name(), technique_, *(*elt)); 
		setMember((*elt)->name(), colourMethod_, *(*elt)); 
	}
}
template <class P>
void IsoShadingAttributes<P>::print(ostream& out)  const
{
	out << "IsoShadingAttributes[";
	out << "technique = " << *technique_;
	out << ", max = " << max_;
	out << ", min = " << min_;
	out << ", colourMethod = " << *colourMethod_;
	out << ", labelBlanking = " << labelBlanking_;
	out << "]" << "\n";
}

template <class P>
void IsoShadingAttributes<P>::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "	";
	
	out << tab << "<" << tag << "\n";
	out << tab << "\tcontour_shade_max_level = \'" << max_ << "\'\n";
	out << tab << "\tcontour_shade_min_level = \'" << min_ << "\'\n";
	out << tab << "\tcontour_shade_label_blanking = \'" << labelBlanking_ << "\'\n";
	out << tab << ">";

 	technique_->toxml(out, tabs+1);
 	colourMethod_->toxml(out, tabs+1);

	out << tab << "</" << tag << ">\n";
}

static MagicsParameter<string> contour_shade_technique("contour_shade_technique", "polygon_shading", "");
static MagicsParameter<double> contour_shade_max_level("contour_shade_max_level", 1.0e+21, "");
static MagicsParameter<double> contour_shade_min_level("contour_shade_min_level", -1.0e+21, "");
static MagicsParameter<string> contour_shade_colour_method("contour_shade_colour_method", "calculate", "");
static MagicsParameter<string> contour_shade_label_blanking("contour_shade_label_blanking", "on", "");
#include "UserPoint.h"
#include "PolyShadingTechnique.h"
#include "MarkerShadingTechnique.h"
#include "CellShading.h"
#include "GeoPoint.h"
static SimpleObjectMaker<PolyShadingTechnique<GeoPoint>, ShadingTechnique<GeoPoint> > polygon_shading_PolyShadingTechnique_GeoPoint("polygon_shading");
static SimpleObjectMaker<PolyShadingTechnique<GeoPoint>, ShadingTechnique<GeoPoint> > polygon_PolyShadingTechnique_GeoPoint("polygon");
static SimpleObjectMaker<PolyShadingTechnique<UserPoint>, ShadingTechnique<UserPoint> > polygon_shading_PolyShadingTechnique_UserPoint("polygon_shading");
static SimpleObjectMaker<PolyShadingTechnique<UserPoint>, ShadingTechnique<UserPoint> > polygon_PolyShadingTechnique_UserPoint("polygon");
static SimpleObjectMaker<GridShading<GeoPoint>, ShadingTechnique<GeoPoint> > grid_shading_GridShading_GeoPoint("grid_shading");
static SimpleObjectMaker<GridShading<UserPoint>, ShadingTechnique<UserPoint> > grid_shading_GridShading_UserPoint("grid_shading");
static SimpleObjectMaker<CellShading<GeoPoint>, ShadingTechnique<GeoPoint> > cell_shading_CellShading_GeoPoint("cell_shading");
static SimpleObjectMaker<CellShading<UserPoint>, ShadingTechnique<UserPoint> > cell_shading_CellShading_UserPoint("cell_shading");
static SimpleObjectMaker<MarkerShadingTechnique<GeoPoint>, ShadingTechnique<GeoPoint> > marker_MarkerShadingTechnique_GeoPoint("marker");
static SimpleObjectMaker<MarkerShadingTechnique<UserPoint>, ShadingTechnique<UserPoint> > marker_MarkerShadingTechnique_UserPoint("marker");
#include "CalculateColourTechnique.h"
#include "ListColourTechnique.h"
static SimpleObjectMaker<CalculateColourTechnique, ColourTechnique> calculate_CalculateColourTechnique("calculate");
static SimpleObjectMaker<ListColourTechnique, ColourTechnique> list_ListColourTechnique("list");
