//------------------------------------------------------------------------------
// Desc:	Routines to support NATIVE to/from internal numeric types and
// 		string comparision/shift routines.
//
// Tabs:	3
//
//		Copyright (c) 1991-1993, 1996-1998, 2000, 2002-2006 Novell, Inc. All Rights Reserved.
//
//		This program is free software; you can redistribute it and/or
//		modify it under the terms of version 2 of the GNU General Public
//		License as published by the Free Software Foundation.
//
//		This program is distributed in the hope that it will be useful,
//		but WITHOUT ANY WARRANTY; without even the implied warranty of
//		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//		GNU General Public License for more details.
//
//		You should have received a copy of the GNU General Public License
//		along with this program; if not, contact Novell, Inc.
//
//		To contact Novell about this file by physical or electronic mail,
//		you may find current contact information at www.novell.com
//
// $Id: $
//------------------------------------------------------------------------------

#include "ftksys.h"

FSTATIC FLMBOOL f_addMetaphone(
	const char *	pszStr,
	const char *	pszAltStr,
	FLMBYTE *		pszMeta,
	FLMUINT *		puiMetaOffset,
	FLMBYTE *		pszAltMeta,
	FLMUINT *		puiAltMetaOffset);

FSTATIC void f_metaStrToNum(
	FLMBYTE *		pszMeta,
	FLMUINT *		puiMeta);

#ifdef FLM_DEBUG

	typedef struct
	{
		const char *	pszWord;
		FLMUINT			uiMeta;
		FLMUINT			uiAltMeta;
	} METAPHONE_MAPPING;

	static METAPHONE_MAPPING gv_MetaTestTable[] =
	{
		{ "ghislane",				0x4680, 0x4680 },
		{ "ghiradelli",			0x4AC6, 0x4AC6 },
		{ "hugh",					0x3000, 0x3000 },
		{ "san francisco",		0xB82A, 0xB82A },
		{ "van wagner",			0x2858, 0x2858 },
		{ "vanwagner",				0x2858, 0x2858 },
		{ "gnome",					0x8700, 0x8700 },
		{ "write",					0xAC00, 0xAC00 },
		{ "dumb",					0xC700, 0xC700 },
		{ "caesar",					0xBBA0, 0xBBA0 },
		{ "chianti",				0x58C0, 0x58C0 },
		{ "michael",				0x7560, 0x7D60 },
		{ "chemistry",				0x57BC, 0x57BC },
		{ "chorus",					0x5AB0, 0x5AB0 },
		{ "mchugh",					0x7500, 0x7500 },
		{ "czerny",					0xBA80, 0xDA80 },
		{ "focaccia",				0x25D0, 0x25D0 },
		{ "mcclellan",				0x7566, 0x7566 },
		{ "bellocchio",			0x96D0, 0x96D0 },
		{ "bacchus",				0x95B0, 0x95B0 },
		{ "accident",				0x15BC, 0x15BC },
		{ "accede",					0x15BC, 0x15BC },
		{ "succeed",				0xB5BC, 0xB5BC },
		{ "bacci",					0x9D00, 0x9D00 },
		{ "mac caffrey",			0x752A, 0x752A },
		{ "edge",					0x1400, 0x1400 },
		{ "edgar",					0x1C5A, 0x1C5A },
		{ "laugh",					0x6200, 0x6200 },
		{ "caugh",					0x5200, 0x5200 },
		{ "cagney",					0x5580, 0x5580 },
		{ "tagliaro",				0xC56A, 0xC6A0 },
		{ "biaggi",					0x9400, 0x9500 },
		{ "jose",					0x3B00, 0x3B00 },
		{ "yankelovich",			0x1856, 0x1856 },
		{ "bajador",				0x94CA, 0x93CA },
		{ "cabrillo",				0x59A6, 0x59A0 },
		{ "campbell",				0x5796, 0x5796 },
		{ "rogier",					0xA400, 0xA4A0 },
		{ "hochmeier",				0x357A, 0x357A },
		{ "island",					0x168C, 0x168C },
		{ "isle",					0x1600, 0x1600 },
		{ "sugar",					0xD5A0, 0xB5A0 },
		{ "herb",					0x3A90, 0x3A90 },
		{ "mannheim",				0x7870, 0x7870 },
		{ "snider",					0xB8CA, 0xD8CA },
		{ "schneider",				0xD8CA, 0xB8CA },
		{ "smith",					0xB700, 0xD7C0 },
		{ "schmidt",				0xD7C0, 0xB7C0 },
		{ "school",					0xB560, 0xB560 },
		{ "schenker",				0xD85A, 0xB585 },
		{ "resnais",				0xAB80, 0xAB8B },
		{ "artois",					0x1AC0, 0x1ACB },
		{ "celebration",			0xB69A, 0xB69A },
		{ "thomas",					0xC7B0, 0xC7B0 },
		{ "uomo",					0x1700, 0x1700 },
		{ "womo",					0x1700, 0x2700 },
		{ "arnow",					0x1A80, 0x1A82 },
		{ "arnoff",					0x1A82, 0x1A82 },
		{ "filipowicz",			0x269C, 0x2692 },
		{ "breaux",					0x9A00, 0x9A00 },
		{ "zhao",					0x4000, 0x4000 },
		{ NULL,						0x0000, 0x0000 }
	};
#endif

#define UNICODE_DECIMAL_DIGIT_MASK		0x08
#define UNICODE_ALPHABETIC_MASK			0x04
#define UNICODE_UPPERCASE_MASK			0x02
#define UNICODE_LOWERCASE_MASK			0x01

const unsigned char UnicodeProperties[ 32768] = 
{
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0, 136, 136, 136, 136, 136,   0,   0,   0,
   6, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102,  96,   0,   0,
   5,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  80,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,  80,   0,   0,   0,   0,   5,   0,   0,  80,   0,   0,
 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102,  96, 102, 102, 102, 101,
  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  80,  85,  85,  85,  85,
 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101,
 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101,  86,  86,  86,  86,
  86,  86,  86,  86,  85, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101,
 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 102,  86,  86,  85,
  86, 101, 101, 102,  86, 102,  85, 102, 102,  86, 101, 102, 101,  85, 102,  86,
 101, 101, 101, 102,  86,  85, 101, 102,  86, 102,  86,  86, 101,  84, 101,  85,
  68,  68, 100,  86,  69, 100,  86,  86,  86,  86,  86,  86,  86,  86,  85, 101,
 101, 101, 101, 101, 101, 101, 101, 101,  86,  69, 101, 102, 101, 101, 101, 101,
 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101,
 101, 101, 101, 101, 101, 101, 101, 101, 101, 101,  85,  80,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,  85,  85,  85,  85,  85,  85,  85,  85,
  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,
  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,
  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  84,  68,  68,  68,
  85,   0,   0,  68,  68,  68,  68,  68,  68,   0,   0,   0,   0,   0,   0,   0,
  85,  85,  80,   0,   0,   0,   0,  64,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  80,   0,   0,
   0,   0,   0,  96, 102,  96,  96, 102,  86, 102, 102, 102, 102, 102, 102, 102,
 102,   6, 102, 102, 102, 102,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,
  85,  85,  85,  85,  85,  85,  85,  80,  85, 102, 101,  85, 101, 101, 101, 101,
 101, 101, 101, 101, 101, 101, 101, 101,  85,  85, 101,   6,  86, 101,   0,   0,
 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102,
 102, 102, 102, 102, 102, 102, 102, 102,  85,  85,  85,  85,  85,  85,  85,  85,
  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,
 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101,
 101,   0,   0,   0,   0, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101,
 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101,
 102,  86,  86,  86,  86,  86,  86,  80, 101, 101, 101, 101, 101, 101, 101, 101,
 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101,   0, 101,   0,   0,   0,
 101, 101, 101, 101, 101, 101, 101, 101,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   6, 102, 102, 102, 102, 102, 102, 102,
 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102,  96,   4,   0,   0,   0,
   5,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,
  85,  85,  85,  85,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,  68,  68,  68,  68,  68,   4,  68,   4,
   4,  64,  64,   0,   0,   0,   0,   0,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  64,   0,   0,  68,  64,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,  68,  68,  68,   0,   0,   0,   0,   0,
	4,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  64,   0,   0,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,   0,   0,   0,   0,
 136, 136, 136, 136, 136,   0,   0,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,   4,  68,  68,  68,  64,   0,
   4,  68,  68,  68,  64,   0,   4,  68, 136, 136, 136, 136, 136,  68,  64,   4,
   0,   0,   0,   0,   0,   0,   0,   0,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
   0,   0,   0,   0,   0,   0,   4,  68,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   4,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,   0,   4,  68,
  68,  68,  68,  68,  68,  68,  64,   0,  64,   0,   0,   0,  68,  68,  68,  68,
  68,  68,   0, 136, 136, 136, 136, 136,   0,   0,   0,   0,   0,   0,   0,   0,
   4,  68,   4,  68,  68,  68,  64,   4,  64,   4,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  64,  68,  68,  68,  64,  64,   0,  68,  68,   0,   4,  68,
  68,  68,  64,   4,  64,   4,  64,   0,   0,   0,   0,   4,   0,   0,  68,   4,
  68,  68,   0, 136, 136, 136, 136, 136,  68,   0,   0,   0,   0,   0,   0,   0,
   4,  68,   4,  68,  68,  64,   0,   4,  64,   4,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  64,  68,  68,  68,  64,  68,   4,  64,  68,   0,   0,  68,
  68,  64,   0,   4,  64,   4,  64,   0,   0,   0,   0,   0,   4,  68,  64,  64,
   0,   0,   0, 136, 136, 136, 136, 136,  68,  68,  64,   0,   0,   0,   0,   0,
   4,  68,   4,  68,  68,  68,  68,   4,  68,   4,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  64,  68,  68,  68,  64,  68,   4,  68,  68,   0,   4,  68,
  68,  68,  68,   4,  68,   4,  64,   0,  64,   0,   0,   0,   0,   0,   0,   0,
  68,  68,   0, 136, 136, 136, 136, 136,   0,   0,   0,   0,   0,   0,   0,   0,
   4,  68,   4,  68,  68,  68,  64,   4,  64,   4,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  64,  68,  68,  68,  64,  68,   4,  68,  68,   0,   4,  68,
  68,  68,   0,   4,  64,   4,  64,   0,   0,   0,   0,  68,   0,   0,  68,   4,
  68,   0,   0, 136, 136, 136, 136, 136,   4,   0,   0,   0,   0,   0,   0,   0,
   0,  68,   4,  68,  68,  64,   0,  68,  64,  68,  68,   0,   4,  64,  64,  68,
   0,   4,  64,   0,  68,  64,   0,  68,  68,  68,  68,   4,  68,   0,   0,  68,
  68,  64,   0,  68,  64,  68,  64,   0,   0,   0,   0,   4,   0,   0,   0,   0,
   0,   0,   0,   8, 136, 136, 136, 136,   0,   0,   0,   0,   0,   0,   0,   0,
   4,  68,   4,  68,  68,  68,  64,  68,  64,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  64,  68,  68,  68,  68,  68,   4,  68,  68,   0,   0,  68,
  68,  68,  64,  68,  64,  68,  64,   0,   0,   0,   4,  64,   0,   0,   0,   0,
  68,   0,   0, 136, 136, 136, 136, 136,   0,   0,   0,   0,   0,   0,   0,   0,
   0,  68,   4,  68,  68,  68,  64,  68,  64,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  64,  68,  68,  68,  68,  68,   4,  68,  68,   0,   4,  68,
  68,  68,  64,  68,  64,  68,  64,   0,   0,   0,   4,  64,   0,   0,   0,  64,
  68,   0,   0, 136, 136, 136, 136, 136,   0,   0,   0,   0,   0,   0,   0,   0,
   0,  68,   4,  68,  68,  68,  64,  68,  64,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  64,  68,  68,  68,  68,  68,  68,  68,  68,   0,   0,  68,
  68,  68,   0,  68,  64,  68,  64,   0,   0,   0,   0,   4,   0,   0,   0,   0,
  68,   0,   0, 136, 136, 136, 136, 136,   0,   0,   0,   0,   0,   0,   0,   0,
   0,  68,   4,  68,  68,  68,  68,  68,  68,  68,  68,  64,   0,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,   4,  68,  68,  68,  68,   4,   0,
  68,  68,  68,  64,   0,   0,   0,   4,  68,  68,  64,  64,  68,  68,  68,  68,
   0,   0,   0,   0,   0,   0,   0,   0,   0,  68,   0,   0,   0,   0,   0,   0,
   4,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  64,   0,   0,
  68,  68,  68,  64,   0,   0,   4,   0, 136, 136, 136, 136, 136,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   4,  64,  64,   4,  64,  64,   4,   0,   0,   0,  68,  68,   4,  68,  68,  68,
   4,  68,   4,   4,   0,  68,   4,  68,  68,  68,  68,  68,  68,   4,  68,   0,
  68,  68,  64,  64,   0,   0,   4,   0, 136, 136, 136, 136, 136,   0,  68,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  64,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 136, 136, 136, 136, 136,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  68,  68,  68,  68,   4,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  64,   0,   0,   4,  68,  68,  68,  68,  68,  68,  68,
  68,   0,   0,   0,  68,  68,   0,   0,  68,  68,  68,  68,   4,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  64,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,   4,  68,  68,   4,  64,  68,  68,  68,  64,   0,  64,  64,   0,   0,   0,
 136, 136, 136, 136, 136,   0,   0,   0,  68,  68,  68,  68,  68,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102,
 102, 102, 102,   0,   0,   0,   0,   0,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  64,   0,   0,   0,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,   0,   0,   4,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  64,   0,   0,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,   0,   0,   0,
  68,  68,  68,  64,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  64,  64,  68,  68,   0,  68,  68,  68,  64,  64,  68,  68,   0,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  64,  64,  68,  68,   0,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  64,  64,  68,  68,   0,  68,  68,  68,  64,
  64,  68,  68,   0,  68,  68,  68,  64,  68,  68,  68,  64,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  64,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  64,  64,  68,  68,   0,  68,  68,  68,  64,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  64,  68,  68,  68,  68,  68,  68,  68,  68,  68,  64,   0,   0,
   0,   0,   0,   0,   8, 136, 136, 136, 136,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  64,   0,   0,   0,   0,   0,
   4,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  64,   4,  68,  68,  68,  64,   0,   0,   0,   0,
   4,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  64,   0,   0,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  64,   0,  68,  64,   0,   0,   0,   0,   0,   0,   0,
  68,  68,  68,  68,  68,  68,  64,  68,  68,  68,   0,   0,   0,   0,   0,   0,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,   0,   0,   0,   0,   0,   0,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,   0,   0,   0,   0,   0,   0,
  68,  68,  68,  68,  68,  68,  64,  68,  64,  68,   0,   0,   0,   0,   0,   0,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,   0,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  64,   0,   0,   0,   0,   0,   0,   4,   0,   0,  64,   0,
 136, 136, 136, 136, 136,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0, 136, 136, 136, 136, 136,   0,   0,   0,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,   0,   0,   0,   0,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  64,   0,
  68,  68,  68,  68,  68,  68,   0,   0,  68,  68,  68,  68,  64,   0,   0,   0,
   0,   0,   0, 136, 136, 136, 136, 136,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,   0,  68,  68,  64,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,
  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,
  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,
  85,  85,  85,  85,  85,  85,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101,
 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101,
 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101,
 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101,
 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101,  85,  85,  85,   0,   0,
 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101,
 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101,
 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101,   0,   0,   0,
  85,  85,  85,  85, 102, 102, 102, 102,  85,  85,  85,   0, 102, 102, 102,   0,
  85,  85,  85,  85, 102, 102, 102, 102,  85,  85,  85,  85, 102, 102, 102, 102,
  85,  85,  85,   0, 102, 102, 102,   0,  85,  85,  85,  85,   6,   6,   6,   6,
  85,  85,  85,  85, 102, 102, 102, 102,  85,  85,  85,  85,  85,  85,  85,   0,
  85,  85,  85,  85,  68,  68,  68,  68,  85,  85,  85,  85,  68,  68,  68,  68,
  85,  85,  85,  85,  68,  68,  68,  68,  85,  85,  80,  85, 102, 102,  64,  80,
   0,  85,  80,  85, 102, 102,  64,   0,  85,  85,   0,  85, 102, 102,   0,   0,
  85,  85,  85,  85, 102, 102,  96,   0,   0,  85,  80,  85, 102, 102,  64,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   0,   5,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,  96,   0,   6,   0,  86, 102,  85, 102, 101,   6,   0,   6, 102, 102,   0,
   0,   0,  96,  96,  96, 102, 102,   5, 102,   6,  84,  68,  69,   0,   5, 102,
   0,   0,   6,  85,  85,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 102, 102, 102, 102, 102, 102, 102, 102,  85,  85,  85,  85,  85,  85,  85,  85,
  68,  68,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  34,  34,  34,  34,  34,
  34,  34,  34,  34,  34,  34,  34,  34,  17,  17,  17,  17,  17,  17,  17,  17,
  17,  17,  17,  17,  17,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   4,  68,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   4,  68,  68,  68,  68,   0,   0,   0,   4,  68,  68,   0,  68,  68,  64,   0,
   4,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  64,   0,   0,   4,  68,
   4,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  64,  68,  68,
   0,   0,   4,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  64,   0,   4,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  64,   0,   0,   0,   0,   0,   0,   0,   0,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,  68,  68,  68,  68,  68,  68,  68,  68,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  64,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,   0,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  64,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  85,  85,  85,  80,   0,   0,   0,   0,   0,   5,  85,  85,   0,   0,   4,  68,
  68,  68,  68,  68,  64,  68,  68,  68,  68,  68,  68,  64,  68,  68,  64,  64,
  68,   4,  64,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,   0,
   0,   0,   0,   0,   0,   0,   0,   0,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,   0,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,  68,  68,  68,  68,  68,  68,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,  68,  68,  64,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  64,   0,
   0,   0,   0,   0,   0,   0,   0,   0, 136, 136, 136, 136, 136,   0,   0,   0,
   6, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102,  96,   0,   0,
   5,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,  80,   0,   0,
   0,   0,   0,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,
  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  68,  64,
   0,  68,  68,  68,   0,  68,  68,  68,   0,  68,  68,  68,   0,  68,  64,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};

#define HANDLE_NEGATIVE \
	if( value < 0) \
	{	*ptr++ = '-'; \
		absValue = (FLMUINT)(-(value)); \
	} \
	else absValue = (FLMUINT)value;

#define HANDLE_DNEGATIVE \
	if( value < 0) \
	{	*ptr++ = '-'; \
		absValue = (FLMUINT)(-(value)); \
	} \
	else absValue = (FLMUINT)value;

#define PUSH_DIGITS( v) \
	{register FLMUINT reg = v; \
		do{ *sp++ = (char)((reg % 10) + '0'); \
		} while( reg /= 10); \
	}

#define POP_DIGITS \
	while( stack < sp--) \
		*ptr++ = *sp; \
	*ptr = '\0';

/****************************************************************************
Desc:
****************************************************************************/
FLMBOOL FLMAPI f_isWhitespace(
	FLMUNICODE		uzChar)
{
	return( f_getXmlObjPtr()->isWhitespace( uzChar));
}

/****************************************************************************
Desc:  	Unsigned word to NATIVE value - null terminate the native string
Return:	char pointer to the NULL byte in the native string
Notes: 	Radix not defined because it is not needed
****************************************************************************/
char * FLMAPI f_uwtoa(
	FLMUINT16	value,
	char *		ptr)
{
	char		stack[ 10];
	char *	sp = stack;

	PUSH_DIGITS( value);

	POP_DIGITS;

	return( ptr);
}

/****************************************************************************
Desc:  	Native to UDWORD value.  Supports 0x<HEX> codes. Non digits NOT ALLOWED
			NO LEADING SPACES ALLOWED ! ! !  No checks for overflow over 4 bytes!
Return:	UDWORD value of what is being pointed to
Notes: 	This algorithm is NOT standard, assumes UNSIGNED char arithmetic
				so (20 - 30) should be 245 and NOT -10.
****************************************************************************/
FLMUINT FLMAPI f_atoud(
	const char *  	pszBuf,
	FLMBOOL			bAllowUnprefixedHex)
{
	FLMUINT			uiValue;
	FLMBOOL			bAllowHex = FALSE;

	if( *pszBuf == NATIVE_ZERO &&
		(*(pszBuf + 1) == NATIVE_LOWER_X || *(pszBuf + 1) == NATIVE_UPPER_X))
	{
		pszBuf += 2;
		bAllowHex = TRUE;
	}
	else if( bAllowUnprefixedHex)
	{
		bAllowHex = TRUE;
	}

	uiValue = 0;
	while( *pszBuf)
	{
		if( *pszBuf >= '0' && *pszBuf <= '9')
		{
			if( !bAllowHex)
			{
				uiValue *= 10;
			}
			else
			{
				uiValue <<= 4;
			}

			uiValue += (FLMUINT)(*pszBuf - '0');
		}
		else if( bAllowHex)
		{
			if( *pszBuf >= 'A' && *pszBuf <= 'F')
			{
				uiValue <<= 4;
				uiValue += (FLMUINT)(*pszBuf - 'A') + 10;
			}
			else if( *pszBuf >= 'a' && *pszBuf <= 'f')
			{
				uiValue <<= 4;
				uiValue += (FLMUINT)(*pszBuf - 'a') + 10;
			}
			else
			{
				break;
			}
		}
		else
		{
			break;
		}
		pszBuf++;
	}

	return( uiValue);
}

/****************************************************************************
Desc:  	Native to FLMUINT64 value.  Supports 0x<HEX> codes. Non digits 
			NOT ALLOWED NO LEADING SPACES ALLOWED! No checks for overflow
			over 4 bytes!
Return:	FLMUINT64 value of what is being pointed to
Notes: 	This algorithm is NOT standard, assumes UNSIGNED char arithmetic
			so (20 - 30) should be 245 and NOT -10.
****************************************************************************/
FLMUINT64 FLMAPI f_atou64(
	const char *  	pszBuf)
{
	FLMUINT64	ui64Value;
	FLMBOOL		bAllowHex = FALSE;

	if( *pszBuf == NATIVE_ZERO &&
		(*(pszBuf + 1) == NATIVE_LOWER_X || *(pszBuf + 1) == NATIVE_UPPER_X))
	{
		pszBuf += 2;
		bAllowHex = TRUE;
	}

	ui64Value = 0;
	while( *pszBuf)
	{
		if( *pszBuf >= '0' && *pszBuf <= '9')
		{
			if( !bAllowHex)
			{
				ui64Value *= 10;
			}
			else
			{
				ui64Value <<= 4;
			}

			ui64Value += (FLMUINT64)(*pszBuf - '0');
		}
		else if( bAllowHex)
		{
			if( *pszBuf >= 'A' && *pszBuf <= 'F')
			{
				ui64Value <<= 4;
				ui64Value += (FLMUINT64)(*pszBuf - 'A') + 10;
			}
			else if( *pszBuf >= 'a' && *pszBuf <= 'f')
			{
				ui64Value <<= 4;
				ui64Value += (FLMUINT64)(*pszBuf - 'a') + 10;
			}
			else
			{
				break;
			}
		}
		else
		{
			break;
		}
		pszBuf++;
	}

	return( ui64Value);
}

/****************************************************************************
Desc:  	Unsigned double (4 byte) number to native value & null terminate
Return:	char pointer to the NULL byte in the native string
Notes: 	Radix not defined.
****************************************************************************/
char * FLMAPI f_udtoa(
	FLMUINT		value,
	char *		ptr)
{
	char 		stack[ 10];
	char *	sp = stack;

	PUSH_DIGITS( value);

	POP_DIGITS;

	return( ptr);
}

/****************************************************************************
Desc:  	Word to native value - null terminate the native string
Return:	char pointer to the NULL byte in the native string
Notes: 	Radix not defined because it is not needed
****************************************************************************/
char * FLMAPI f_wtoa(
	FLMINT16		value,
	char *		ptr)
{
	char  		stack[ 10];
	char *		sp = stack;
	FLMUINT		absValue;

	HANDLE_NEGATIVE;

	PUSH_DIGITS( absValue);

	POP_DIGITS;

	return( ptr);
}

/****************************************************************************
Desc:  	Double (4 byte) number to native value - null terminate the string
Return:	char pointer to the NULL byte in the native string
****************************************************************************/
char * FLMAPI f_dtoa(
	FLMINT		value,
	char *		ptr)
{
	char			stack[ 10];
	char *		sp = stack;
	FLMUINT		absValue;

	HANDLE_DNEGATIVE;

	PUSH_DIGITS( absValue);

	POP_DIGITS;

	return( ptr);
}

/*****************************************************************************
Desc:	Convert unsigned 64 bit value to ASCII.
*****************************************************************************/
char * FLMAPI f_ui64toa(
	FLMUINT64	ui64Value,
	char *		pszAscii)
{
	char 		szStack [30];
	char *	pszStack = &szStack [0];
	
	do
	{
		*pszStack++ = (char)((ui64Value % 10) + '0');
	}
	while ((ui64Value /= 10) > 0);

	pszStack--;
	for (;;)
	{
		*pszAscii++ = *pszStack;
		if (pszStack == &szStack [0])
		{
			break;
		}
		pszStack--;
	}
	*pszAscii = 0;
	
	// Return pointer to terminating null character
	
	return( pszAscii);
}

/*****************************************************************************
Desc:	Convert signed 64 bit value to ASCII.
*****************************************************************************/
char * FLMAPI f_i64toa(
	FLMINT64	i64Value,
	char *	pszAscii)
{
	if (i64Value < 0)
	{
		*pszAscii++ = '-';
		i64Value = -i64Value;
	}
	return( f_ui64toa( (FLMUINT64)i64Value, pszAscii));
}

/****************************************************************************
Desc:	Ascii to integer
****************************************************************************/
FLMINT FLMAPI f_atoi(
	const char *	pszStr)
{
	return( f_atod( pszStr));
}

/****************************************************************************
Desc:	native to long
****************************************************************************/
FLMINT FLMAPI f_atol(
	const char *	pszStr)
{
	return( f_atod( pszStr));
}

/****************************************************************************
Desc:		native to DWORD value.  Supports 0x<HEX> codes. Non digits NOT ALLOWED
			NO LEADING SPACES ALLOWED ! ! !  No checks for overflow over 4 bytes!
Return:	DWORD value of what is being pointed to
Notes: 	This algorithm is NOT standard! Assumes UNSIGNED char arithmetic
			so (20 - 30) should be 245 and NOT -10.
****************************************************************************/
FLMINT FLMAPI f_atod(
	const char *	pszBuf)
{
	FLMINT		iValue;
	FLMBOOL		bNeg = FALSE;

	if( *pszBuf == '-')
	{
		bNeg = TRUE;
		pszBuf++;
	}
	else if( *pszBuf == '+')
	{
		pszBuf++;
	}

	iValue = (FLMINT)f_atoud( pszBuf);
	return( bNeg ? -iValue : iValue);
}

/****************************************************************************
Desc:	Utility function to return the maximum size of a hex number
		represented as a string.
****************************************************************************/
FINLINE FLMUINT maxHexSize(
	FLMUINT			uiSizeOfPtr)
{
	return uiSizeOfPtr * 2;
}

/****************************************************************************
Desc:	Utility function to return the maximum size of a decimal number
		represented as a string.
****************************************************************************/
FINLINE FLMUINT maxDecimalSize(
	FLMUINT		uiSizeOfPtr)
{
	switch (uiSizeOfPtr)
	{
		case 4:
			return 10;
		case 8:
			return 20;
		default:
			f_assert( 0);
			return 0;
	}
}

/****************************************************************************
Desc: Returns the length of a unicode string
****************************************************************************/
FLMUINT FLMAPI f_unilen(
	const FLMUNICODE *	puzStr)
{
	FLMUINT		uiLen = 0;

	if( !puzStr)
	{
		goto Exit;
	}

	while( *puzStr)
	{
		puzStr++;
		uiLen++;
	}

Exit:

	return( uiLen);
}

/****************************************************************************
Desc: Copies a unicode string
****************************************************************************/
FLMUNICODE * FLMAPI f_unicpy(
	FLMUNICODE *			puzDestStr,
	const FLMUNICODE *	puzSrcStr)
{
	const FLMUNICODE *	puzSrc = puzSrcStr;
	FLMUNICODE *			puzDest = puzDestStr;

	while( *puzSrc)
	{
		*puzDest++ = *puzSrc++;
	}

	*puzDest = 0;
	return( puzDestStr);
}

/****************************************************************************
Desc: A rather trivial unicode monocase function.
****************************************************************************/
FLMUNICODE FLMAPI f_uniToLower(
	FLMUNICODE		uChar)
{
	static const FLMUNICODE basicAlpha[ 0x600] =
	{
		0x0000, /* Monocases to self */
		0x0001, /* Monocases to self */
		0x0002, /* Monocases to self */
		0x0003, /* Monocases to self */
		0x0004, /* Monocases to self */
		0x0005, /* Monocases to self */
		0x0006, /* Monocases to self */
		0x0007, /* Monocases to self */
		0x0008, /* Monocases to self */
		0x0009, /* Monocases to self */
		0x000A, /* Monocases to self */
		0x000B, /* Monocases to self */
		0x000C, /* Monocases to self */
		0x000D, /* Monocases to self */
		0x000E, /* Monocases to self */
		0x000F, /* Monocases to self */
		0x0010, /* Monocases to self */
		0x0011, /* Monocases to self */
		0x0012, /* Monocases to self */
		0x0013, /* Monocases to self */
		0x0014, /* Monocases to self */
		0x0015, /* Monocases to self */
		0x0016, /* Monocases to self */
		0x0017, /* Monocases to self */
		0x0018, /* Monocases to self */
		0x0019, /* Monocases to self */
		0x001A, /* Monocases to self */
		0x001B, /* Monocases to self */
		0x001C, /* Monocases to self */
		0x001D, /* Monocases to self */
		0x001E, /* Monocases to self */
		0x001F, /* Monocases to self */
		0x0020, /* Monocases to self */
		0x0021, /* Monocases to self */
		0x0022, /* Monocases to self */
		0x0023, /* Monocases to self */
		0x0024, /* Monocases to self */
		0x0025, /* Monocases to self */
		0x0026, /* Monocases to self */
		0x0027, /* Monocases to self */
		0x0028, /* Monocases to self */
		0x0029, /* Monocases to self */
		0x002A, /* Monocases to self */
		0x002B, /* Monocases to self */
		0x002C, /* Monocases to self */
		0x002D, /* Monocases to self */
		0x002E, /* Monocases to self */
		0x002F, /* Monocases to self */
		0x0030, /* Monocases to self */
		0x0031, /* Monocases to self */
		0x0032, /* Monocases to self */
		0x0033, /* Monocases to self */
		0x0034, /* Monocases to self */
		0x0035, /* Monocases to self */
		0x0036, /* Monocases to self */
		0x0037, /* Monocases to self */
		0x0038, /* Monocases to self */
		0x0039, /* Monocases to self */
		0x003A, /* Monocases to self */
		0x003B, /* Monocases to self */
		0x003C, /* Monocases to self */
		0x003D, /* Monocases to self */
		0x003E, /* Monocases to self */
		0x003F, /* Monocases to self */
		0x0040, /* Monocases to self */
		0x0061, /* LATIN LETTER A */
		0x0062, /* LATIN LETTER B */
		0x0063, /* LATIN LETTER C */
		0x0064, /* LATIN LETTER D */
		0x0065, /* LATIN LETTER E */
		0x0066, /* LATIN LETTER F */
		0x0067, /* LATIN LETTER G */
		0x0068, /* LATIN LETTER H */
		0x0069, /* LATIN LETTER I */
		0x006A, /* LATIN LETTER J */
		0x006B, /* LATIN LETTER K */
		0x006C, /* LATIN LETTER L */
		0x006D, /* LATIN LETTER M */
		0x006E, /* LATIN LETTER N */
		0x006F, /* LATIN LETTER O */
		0x0070, /* LATIN LETTER P */
		0x0071, /* LATIN LETTER Q */
		0x0072, /* LATIN LETTER R */
		0x0073, /* LATIN LETTER S */
		0x0074, /* LATIN LETTER T */
		0x0075, /* LATIN LETTER U */
		0x0076, /* LATIN LETTER V */
		0x0077, /* LATIN LETTER W */
		0x0078, /* LATIN LETTER X */
		0x0079, /* LATIN LETTER Y */
		0x007A, /* LATIN LETTER Z */
		0x005B, /* Monocases to self */
		0x005C, /* Monocases to self */
		0x005D, /* Monocases to self */
		0x005E, /* Monocases to self */
		0x005F, /* Monocases to self */
		0x0060, /* Monocases to self */
		0x0061, /* Monocases to self */
		0x0062, /* Monocases to self */
		0x0063, /* Monocases to self */
		0x0064, /* Monocases to self */
		0x0065, /* Monocases to self */
		0x0066, /* Monocases to self */
		0x0067, /* Monocases to self */
		0x0068, /* Monocases to self */
		0x0069, /* Monocases to self */
		0x006A, /* Monocases to self */
		0x006B, /* Monocases to self */
		0x006C, /* Monocases to self */
		0x006D, /* Monocases to self */
		0x006E, /* Monocases to self */
		0x006F, /* Monocases to self */
		0x0070, /* Monocases to self */
		0x0071, /* Monocases to self */
		0x0072, /* Monocases to self */
		0x0073, /* Monocases to self */
		0x0074, /* Monocases to self */
		0x0075, /* Monocases to self */
		0x0076, /* Monocases to self */
		0x0077, /* Monocases to self */
		0x0078, /* Monocases to self */
		0x0079, /* Monocases to self */
		0x007A, /* Monocases to self */
		0x007B, /* Monocases to self */
		0x007C, /* Monocases to self */
		0x007D, /* Monocases to self */
		0x007E, /* Monocases to self */
		0x007F, /* Monocases to self */
		0x0080, /* Monocases to self */
		0x0081, /* Monocases to self */
		0x0082, /* Monocases to self */
		0x0083, /* Monocases to self */
		0x0084, /* Monocases to self */
		0x0085, /* Monocases to self */
		0x0086, /* Monocases to self */
		0x0087, /* Monocases to self */
		0x0088, /* Monocases to self */
		0x0089, /* Monocases to self */
		0x008A, /* Monocases to self */
		0x008B, /* Monocases to self */
		0x008C, /* Monocases to self */
		0x008D, /* Monocases to self */
		0x008E, /* Monocases to self */
		0x008F, /* Monocases to self */
		0x0090, /* Monocases to self */
		0x0091, /* Monocases to self */
		0x0092, /* Monocases to self */
		0x0093, /* Monocases to self */
		0x0094, /* Monocases to self */
		0x0095, /* Monocases to self */
		0x0096, /* Monocases to self */
		0x0097, /* Monocases to self */
		0x0098, /* Monocases to self */
		0x0099, /* Monocases to self */
		0x009A, /* Monocases to self */
		0x009B, /* Monocases to self */
		0x009C, /* Monocases to self */
		0x009D, /* Monocases to self */
		0x009E, /* Monocases to self */
		0x009F, /* Monocases to self */
		0x00A0, /* Monocases to self */
		0x00A1, /* Monocases to self */
		0x00A2, /* Monocases to self */
		0x00A3, /* Monocases to self */
		0x00A4, /* Monocases to self */
		0x00A5, /* Monocases to self */
		0x00A6, /* Monocases to self */
		0x00A7, /* Monocases to self */
		0x00A8, /* Monocases to self */
		0x00A9, /* Monocases to self */
		0x00AA, /* Monocases to self */
		0x00AB, /* Monocases to self */
		0x00AC, /* Monocases to self */
		0x00AD, /* Monocases to self */
		0x00AE, /* Monocases to self */
		0x00AF, /* Monocases to self */
		0x00B0, /* Monocases to self */
		0x00B1, /* Monocases to self */
		0x00B2, /* Monocases to self */
		0x00B3, /* Monocases to self */
		0x00B4, /* Monocases to self */
		0x00B5, /* Monocases to self */
		0x00B6, /* Monocases to self */
		0x00B7, /* Monocases to self */
		0x00B8, /* Monocases to self */
		0x00B9, /* Monocases to self */
		0x00BA, /* Monocases to self */
		0x00BB, /* Monocases to self */
		0x00BC, /* Monocases to self */
		0x00BD, /* Monocases to self */
		0x00BE, /* Monocases to self */
		0x00BF, /* Monocases to self */
		0x00E0, /* LATIN LETTER A GRAVE */
		0x00E1, /* LATIN LETTER A ACUTE */
		0x00E2, /* LATIN LETTER A CIRCUMFLEX */
		0x00E3, /* LATIN LETTER A TILDE */
		0x00E4, /* LATIN LETTER A DIAERESIS */
		0x00E5, /* LATIN LETTER A RING */
		0x00E6, /* LATIN LETTER A E */
		0x00E7, /* LATIN LETTER C CEDILLA */
		0x00E8, /* LATIN LETTER E GRAVE */
		0x00E9, /* LATIN LETTER E ACUTE */
		0x00EA, /* LATIN LETTER E CIRCUMFLEX */
		0x00EB, /* LATIN LETTER E DIAERESIS */
		0x00EC, /* LATIN LETTER I GRAVE */
		0x00ED, /* LATIN LETTER I ACUTE */
		0x00EE, /* LATIN LETTER I CIRCUMFLEX */
		0x00EF, /* LATIN LETTER I DIAERESIS */
		0x00F0, /* LATIN LETTER ETH */
		0x00F1, /* LATIN LETTER N TILDE */
		0x00F2, /* LATIN LETTER O GRAVE */
		0x00F3, /* LATIN LETTER O ACUTE */
		0x00F4, /* LATIN LETTER O CIRCUMFLEX */
		0x00F5, /* LATIN LETTER O TILDE */
		0x00F6, /* LATIN LETTER O DIAERESIS */
		0x00D7, /* Monocases to self */
		0x00F8, /* LATIN LETTER O SLASH */
		0x00F9, /* LATIN LETTER U GRAVE */
		0x00FA, /* LATIN LETTER U ACUTE */
		0x00FB, /* LATIN LETTER U CIRCUMFLEX */
		0x00FC, /* LATIN LETTER U DIAERESIS */
		0x00FD, /* LATIN LETTER Y ACUTE */
		0x00FE, /* LATIN LETTER THORN */
		0x00DF, /* Monocases to self */
		0x00E0, /* Monocases to self */
		0x00E1, /* Monocases to self */
		0x00E2, /* Monocases to self */
		0x00E3, /* Monocases to self */
		0x00E4, /* Monocases to self */
		0x00E5, /* Monocases to self */
		0x00E6, /* Monocases to self */
		0x00E7, /* Monocases to self */
		0x00E8, /* Monocases to self */
		0x00E9, /* Monocases to self */
		0x00EA, /* Monocases to self */
		0x00EB, /* Monocases to self */
		0x00EC, /* Monocases to self */
		0x00ED, /* Monocases to self */
		0x00EE, /* Monocases to self */
		0x00EF, /* Monocases to self */
		0x00F0, /* Monocases to self */
		0x00F1, /* Monocases to self */
		0x00F2, /* Monocases to self */
		0x00F3, /* Monocases to self */
		0x00F4, /* Monocases to self */
		0x00F5, /* Monocases to self */
		0x00F6, /* Monocases to self */
		0x00F7, /* Monocases to self */
		0x00F8, /* Monocases to self */
		0x00F9, /* Monocases to self */
		0x00FA, /* Monocases to self */
		0x00FB, /* Monocases to self */
		0x00FC, /* Monocases to self */
		0x00FD, /* Monocases to self */
		0x00FE, /* Monocases to self */
		0x00FF, /* Monocases to self */
		0x0101, /* LATIN LETTER A MACRON */
		0x0101, /* Monocases to self */
		0x0103, /* LATIN LETTER A BREVE */
		0x0103, /* Monocases to self */
		0x0105, /* LATIN LETTER A OGONEK */
		0x0105, /* Monocases to self */
		0x0107, /* LATIN LETTER C ACUTE */
		0x0107, /* Monocases to self */
		0x0109, /* LATIN LETTER C CIRCUMFLEX */
		0x0109, /* Monocases to self */
		0x010B, /* LATIN LETTER C DOT */
		0x010B, /* Monocases to self */
		0x010D, /* LATIN LETTER C HACEK */
		0x010D, /* Monocases to self */
		0x010F, /* LATIN LETTER D HACEK */
		0x010F, /* Monocases to self */
		0x0111, /* LATIN LETTER D BAR */
		0x0111, /* Monocases to self */
		0x0113, /* LATIN LETTER E MACRON */
		0x0113, /* Monocases to self */
		0x0115, /* LATIN LETTER E BREVE */
		0x0115, /* Monocases to self */
		0x0117, /* LATIN LETTER E DOT */
		0x0117, /* Monocases to self */
		0x0119, /* LATIN LETTER E OGONEK */
		0x0119, /* Monocases to self */
		0x011B, /* LATIN LETTER E HACEK */
		0x011B, /* Monocases to self */
		0x011D, /* LATIN LETTER G CIRCUMFLEX */
		0x011D, /* Monocases to self */
		0x011F, /* LATIN LETTER G BREVE */
		0x011F, /* Monocases to self */
		0x0121, /* LATIN LETTER G DOT */
		0x0121, /* Monocases to self */
		0x0123, /* LATIN LETTER G CEDILLA */
		0x0123, /* Monocases to self */
		0x0125, /* LATIN LETTER H CIRCUMFLEX */
		0x0125, /* Monocases to self */
		0x0127, /* LATIN LETTER H BAR */
		0x0127, /* Monocases to self */
		0x0129, /* LATIN LETTER I TILDE */
		0x0129, /* Monocases to self */
		0x012B, /* LATIN LETTER I MACRON */
		0x012B, /* Monocases to self */
		0x012D, /* LATIN LETTER I BREVE */
		0x012D, /* Monocases to self */
		0x012F, /* LATIN LETTER I OGONEK */
		0x012F, /* Monocases to self */
		0x0069, /* LATIN LETTER I DOT */
		0x0131, /* Monocases to self */
		0x0133, /* LATIN LETTER I J */
		0x0133, /* Monocases to self */
		0x0135, /* LATIN LETTER J CIRCUMFLEX */
		0x0135, /* Monocases to self */
		0x0137, /* LATIN LETTER K CEDILLA */
		0x0137, /* Monocases to self */
		0x0138, /* Monocases to self */
		0x013A, /* LATIN LETTER L ACUTE */
		0x013A, /* Monocases to self */
		0x013C, /* LATIN LETTER L CEDILLA */
		0x013C, /* Monocases to self */
		0x013E, /* LATIN LETTER L HACEK */
		0x013E, /* Monocases to self */
		0x0140, /* LATIN LETTER L WITH MIDDLE DOT */
		0x0140, /* Monocases to self */
		0x0142, /* LATIN LETTER L SLASH */
		0x0142, /* Monocases to self */
		0x0144, /* LATIN LETTER N ACUTE */
		0x0144, /* Monocases to self */
		0x0146, /* LATIN LETTER N CEDILLA */
		0x0146, /* Monocases to self */
		0x0148, /* LATIN LETTER N HACEK */
		0x0148, /* Monocases to self */
		0x0149, /* Monocases to self */
		0x014B, /* LATIN LETTER ENG */
		0x014B, /* Monocases to self */
		0x014D, /* LATIN LETTER O MACRON */
		0x014D, /* Monocases to self */
		0x014F, /* LATIN LETTER O BREVE */
		0x014F, /* Monocases to self */
		0x0151, /* LATIN LETTER O DOUBLE ACUTE */
		0x0151, /* Monocases to self */
		0x0153, /* LATIN LETTER O E */
		0x0153, /* Monocases to self */
		0x0155, /* LATIN LETTER R ACUTE */
		0x0155, /* Monocases to self */
		0x0157, /* LATIN LETTER R CEDILLA */
		0x0157, /* Monocases to self */
		0x0159, /* LATIN LETTER R HACEK */
		0x0159, /* Monocases to self */
		0x015B, /* LATIN LETTER S ACUTE */
		0x015B, /* Monocases to self */
		0x015D, /* LATIN LETTER S CIRCUMFLEX */
		0x015D, /* Monocases to self */
		0x015F, /* LATIN LETTER S CEDILLA */
		0x015F, /* Monocases to self */
		0x0161, /* LATIN LETTER S HACEK */
		0x0161, /* Monocases to self */
		0x0163, /* LATIN LETTER T CEDILLA */
		0x0163, /* Monocases to self */
		0x0165, /* LATIN LETTER T HACEK */
		0x0165, /* Monocases to self */
		0x0167, /* LATIN LETTER T BAR */
		0x0167, /* Monocases to self */
		0x0169, /* LATIN LETTER U TILDE */
		0x0169, /* Monocases to self */
		0x016B, /* LATIN LETTER U MACRON */
		0x016B, /* Monocases to self */
		0x016D, /* LATIN LETTER U BREVE */
		0x016D, /* Monocases to self */
		0x016F, /* LATIN LETTER U RING */
		0x016F, /* Monocases to self */
		0x0171, /* LATIN LETTER U DOUBLE ACUTE */
		0x0171, /* Monocases to self */
		0x0173, /* LATIN LETTER U OGONEK */
		0x0173, /* Monocases to self */
		0x0175, /* LATIN LETTER W CIRCUMFLEX */
		0x0175, /* Monocases to self */
		0x0177, /* LATIN LETTER Y CIRCUMFLEX */
		0x0177, /* Monocases to self */
		0x00FF, /* LATIN LETTER Y DIAERESIS */
		0x017A, /* LATIN LETTER Z ACUTE */
		0x017A, /* Monocases to self */
		0x017C, /* LATIN LETTER Z DOT */
		0x017C, /* Monocases to self */
		0x017E, /* LATIN LETTER Z HACEK */
		0x017E, /* Monocases to self */
		0x017F, /* Monocases to self */
		0x0180, /* Monocases to self */
		0x0253, /* LATIN LETTER B HOOK */
		0x0183, /* LATIN LETTER B TOPBAR */
		0x0183, /* Monocases to self */
		0x0185, /* LATIN LETTER TONE SIX */
		0x0185, /* Monocases to self */
		0x0254, /* LATIN LETTER OPEN O */
		0x0188, /* LATIN LETTER C HOOK */
		0x0188, /* Monocases to self */
		0x0256, /* LATIN LETTER AFRICAN D */
		0x0257, /* LATIN LETTER D HOOK */
		0x018C, /* LATIN LETTER D TOPBAR */
		0x018C, /* Monocases to self */
		0x018D, /* Monocases to self */
		0x01DD, /* LATIN LETTER TURNED E */
		0x0259, /* LATIN LETTER SCHWA */
		0x025B, /* LATIN LETTER EPSILON */
		0x0192, /* LATIN LETTER F HOOK */
		0x0192, /* Monocases to self */
		0x0260, /* LATIN LETTER G HOOK */
		0x0263, /* LATIN LETTER GAMMA */
		0x0195, /* Monocases to self */
		0x0269, /* LATIN LETTER IOTA */
		0x0268, /* LATIN LETTER BARRED I */
		0x0199, /* LATIN LETTER K HOOK */
		0x0199, /* Monocases to self */
		0x019A, /* Monocases to self */
		0x019B, /* Monocases to self */
		0x026F, /* LATIN LETTER TURNED M */
		0x0272, /* LATIN LETTER N HOOK */
		0x019E, /* Monocases to self */
		0x0275, /* LATIN LETTER BARRED O */
		0x01A1, /* LATIN LETTER O HORN */
		0x01A1, /* Monocases to self */
		0x01A3, /* LATIN LETTER O I */
		0x01A3, /* Monocases to self */
		0x01A5, /* LATIN LETTER P HOOK */
		0x01A5, /* Monocases to self */
		0x01A6, /* Monocases to self */
		0x01A8, /* LATIN LETTER TONE TWO */
		0x01A8, /* Monocases to self */
		0x0283, /* LATIN LETTER ESH */
		0x01AA, /* Monocases to self */
		0x01AB, /* Monocases to self */
		0x01AD, /* LATIN LETTER T HOOK */
		0x01AD, /* Monocases to self */
		0x0288, /* LATIN LETTER T RETROFLEX HOOK */
		0x01B0, /* LATIN LETTER U HORN */
		0x01B0, /* Monocases to self */
		0x028A, /* LATIN LETTER UPSILON */
		0x028B, /* LATIN LETTER SCRIPT V */
		0x01B4, /* LATIN LETTER Y HOOK */
		0x01B4, /* Monocases to self */
		0x01B6, /* LATIN LETTER Z BAR */
		0x01B6, /* Monocases to self */
		0x0292, /* LATIN LETTER YOGH */
		0x01B9, /* LATIN LETTER REVERSED YOGH */
		0x01B9, /* Monocases to self */
		0x01BA, /* Monocases to self */
		0x01BB, /* Monocases to self */
		0x01BD, /* LATIN LETTER TONE FIVE */
		0x01BD, /* Monocases to self */
		0x01BE, /* Monocases to self */
		0x01BF, /* Monocases to self */
		0x01C0, /* Monocases to self */
		0x01C1, /* Monocases to self */
		0x01C2, /* Monocases to self */
		0x01C3, /* Monocases to self */
		0x01C6, /* LATIN LETTER D Z HACEK */
		0x01C6, /* LATIN LETTER CAPITAL D SMALL Z HACEK */
		0x01C6, /* Monocases to self */
		0x01C9, /* LATIN LETTER CAPITAL L CAPTIAL J */
		0x01C9, /* LATIN LETTER CAPITAL L SMALL J */
		0x01C9, /* Monocases to self */
		0x01CC, /* LATIN LETTER CAPITAL N CAPITAL J */
		0x01CC, /* LATIN LETTER CAPITAL N SMALL J */
		0x01CC, /* Monocases to self */
		0x01CE, /* LATIN LETTER A HACEK */
		0x01CE, /* Monocases to self */
		0x01D0, /* LATIN LETTER I HACEK */
		0x01D0, /* Monocases to self */
		0x01D2, /* LATIN LETTER O HACEK */
		0x01D2, /* Monocases to self */
		0x01D4, /* LATIN LETTER U HACEK */
		0x01D4, /* Monocases to self */
		0x01D6, /* LATIN LETTER U DIAERESIS MACRON */
		0x01D6, /* Monocases to self */
		0x01D8, /* LATIN LETTER U DIAERESIS ACUTE */
		0x01D8, /* Monocases to self */
		0x01DA, /* LATIN LETTER U DIAERESIS HACEK */
		0x01DA, /* Monocases to self */
		0x01DC, /* LATIN LETTER U DIAERESIS GRAVE */
		0x01DC, /* Monocases to self */
		0x01DD, /* Monocases to self */
		0x01DF, /* LATIN LETTER A DIAERESIS MACRON */
		0x01DF, /* Monocases to self */
		0x01E1, /* LATIN LETTER A DOT MACRON */
		0x01E1, /* Monocases to self */
		0x01E3, /* LATIN LETTER A E MACRON */
		0x01E3, /* Monocases to self */
		0x01E5, /* LATIN LETTER G BAR */
		0x01E5, /* Monocases to self */
		0x01E7, /* LATIN LETTER G HACEK */
		0x01E7, /* Monocases to self */
		0x01E9, /* LATIN LETTER K HACEK */
		0x01E9, /* Monocases to self */
		0x01EB, /* LATIN LETTER O OGONEK */
		0x01EB, /* Monocases to self */
		0x01ED, /* LATIN LETTER O OGONEK MACRON */
		0x01ED, /* Monocases to self */
		0x01EF, /* LATIN LETTER YOGH HACEK */
		0x01EF, /* Monocases to self */
		0x01F0, /* Monocases to self */
		0x01F1, /* Monocases to self */
		0x01F2, /* Monocases to self */
		0x01F3, /* Monocases to self */
		0x01F4, /* Monocases to self */
		0x01F5, /* Monocases to self */
		0x01F6, /* Monocases to self */
		0x01F7, /* Monocases to self */
		0x01F8, /* Monocases to self */
		0x01F9, /* Monocases to self */
		0x01FA, /* Monocases to self */
		0x01FB, /* Monocases to self */
		0x01FC, /* Monocases to self */
		0x01FD, /* Monocases to self */
		0x01FE, /* Monocases to self */
		0x01FF, /* Monocases to self */
		0x0200, /* Monocases to self */
		0x0201, /* Monocases to self */
		0x0202, /* Monocases to self */
		0x0203, /* Monocases to self */
		0x0204, /* Monocases to self */
		0x0205, /* Monocases to self */
		0x0206, /* Monocases to self */
		0x0207, /* Monocases to self */
		0x0208, /* Monocases to self */
		0x0209, /* Monocases to self */
		0x020A, /* Monocases to self */
		0x020B, /* Monocases to self */
		0x020C, /* Monocases to self */
		0x020D, /* Monocases to self */
		0x020E, /* Monocases to self */
		0x020F, /* Monocases to self */
		0x0210, /* Monocases to self */
		0x0211, /* Monocases to self */
		0x0212, /* Monocases to self */
		0x0213, /* Monocases to self */
		0x0214, /* Monocases to self */
		0x0215, /* Monocases to self */
		0x0216, /* Monocases to self */
		0x0217, /* Monocases to self */
		0x0218, /* Monocases to self */
		0x0219, /* Monocases to self */
		0x021A, /* Monocases to self */
		0x021B, /* Monocases to self */
		0x021C, /* Monocases to self */
		0x021D, /* Monocases to self */
		0x021E, /* Monocases to self */
		0x021F, /* Monocases to self */
		0x0220, /* Monocases to self */
		0x0221, /* Monocases to self */
		0x0222, /* Monocases to self */
		0x0223, /* Monocases to self */
		0x0224, /* Monocases to self */
		0x0225, /* Monocases to self */
		0x0226, /* Monocases to self */
		0x0227, /* Monocases to self */
		0x0228, /* Monocases to self */
		0x0229, /* Monocases to self */
		0x022A, /* Monocases to self */
		0x022B, /* Monocases to self */
		0x022C, /* Monocases to self */
		0x022D, /* Monocases to self */
		0x022E, /* Monocases to self */
		0x022F, /* Monocases to self */
		0x0230, /* Monocases to self */
		0x0231, /* Monocases to self */
		0x0232, /* Monocases to self */
		0x0233, /* Monocases to self */
		0x0234, /* Monocases to self */
		0x0235, /* Monocases to self */
		0x0236, /* Monocases to self */
		0x0237, /* Monocases to self */
		0x0238, /* Monocases to self */
		0x0239, /* Monocases to self */
		0x023A, /* Monocases to self */
		0x023B, /* Monocases to self */
		0x023C, /* Monocases to self */
		0x023D, /* Monocases to self */
		0x023E, /* Monocases to self */
		0x023F, /* Monocases to self */
		0x0240, /* Monocases to self */
		0x0241, /* Monocases to self */
		0x0242, /* Monocases to self */
		0x0243, /* Monocases to self */
		0x0244, /* Monocases to self */
		0x0245, /* Monocases to self */
		0x0246, /* Monocases to self */
		0x0247, /* Monocases to self */
		0x0248, /* Monocases to self */
		0x0249, /* Monocases to self */
		0x024A, /* Monocases to self */
		0x024B, /* Monocases to self */
		0x024C, /* Monocases to self */
		0x024D, /* Monocases to self */
		0x024E, /* Monocases to self */
		0x024F, /* Monocases to self */
		0x0250, /* Monocases to self */
		0x0251, /* Monocases to self */
		0x0252, /* Monocases to self */
		0x0253, /* Monocases to self */
		0x0254, /* Monocases to self */
		0x0255, /* Monocases to self */
		0x0256, /* Monocases to self */
		0x0257, /* Monocases to self */
		0x0258, /* Monocases to self */
		0x0259, /* Monocases to self */
		0x025A, /* Monocases to self */
		0x025B, /* Monocases to self */
		0x025C, /* Monocases to self */
		0x025D, /* Monocases to self */
		0x025E, /* Monocases to self */
		0x025F, /* Monocases to self */
		0x0260, /* Monocases to self */
		0x0261, /* Monocases to self */
		0x0262, /* Monocases to self */
		0x0263, /* Monocases to self */
		0x0264, /* Monocases to self */
		0x0265, /* Monocases to self */
		0x0266, /* Monocases to self */
		0x0267, /* Monocases to self */
		0x0268, /* Monocases to self */
		0x0269, /* Monocases to self */
		0x026A, /* Monocases to self */
		0x026B, /* Monocases to self */
		0x026C, /* Monocases to self */
		0x026D, /* Monocases to self */
		0x026E, /* Monocases to self */
		0x026F, /* Monocases to self */
		0x0270, /* Monocases to self */
		0x0271, /* Monocases to self */
		0x0272, /* Monocases to self */
		0x0273, /* Monocases to self */
		0x0274, /* Monocases to self */
		0x0275, /* Monocases to self */
		0x0276, /* Monocases to self */
		0x0277, /* Monocases to self */
		0x0278, /* Monocases to self */
		0x0279, /* Monocases to self */
		0x027A, /* Monocases to self */
		0x027B, /* Monocases to self */
		0x027C, /* Monocases to self */
		0x027D, /* Monocases to self */
		0x027E, /* Monocases to self */
		0x027F, /* Monocases to self */
		0x0280, /* Monocases to self */
		0x0281, /* Monocases to self */
		0x0282, /* Monocases to self */
		0x0283, /* Monocases to self */
		0x0284, /* Monocases to self */
		0x0285, /* Monocases to self */
		0x0286, /* Monocases to self */
		0x0287, /* Monocases to self */
		0x0288, /* Monocases to self */
		0x0289, /* Monocases to self */
		0x028A, /* Monocases to self */
		0x028B, /* Monocases to self */
		0x028C, /* Monocases to self */
		0x028D, /* Monocases to self */
		0x028E, /* Monocases to self */
		0x028F, /* Monocases to self */
		0x0290, /* Monocases to self */
		0x0291, /* Monocases to self */
		0x0292, /* Monocases to self */
		0x0293, /* Monocases to self */
		0x0294, /* Monocases to self */
		0x0295, /* Monocases to self */
		0x0296, /* Monocases to self */
		0x0297, /* Monocases to self */
		0x0298, /* Monocases to self */
		0x0299, /* Monocases to self */
		0x029A, /* Monocases to self */
		0x029B, /* Monocases to self */
		0x029C, /* Monocases to self */
		0x029D, /* Monocases to self */
		0x029E, /* Monocases to self */
		0x029F, /* Monocases to self */
		0x02A0, /* Monocases to self */
		0x02A1, /* Monocases to self */
		0x02A2, /* Monocases to self */
		0x02A3, /* Monocases to self */
		0x02A4, /* Monocases to self */
		0x02A5, /* Monocases to self */
		0x02A6, /* Monocases to self */
		0x02A7, /* Monocases to self */
		0x02A8, /* Monocases to self */
		0x02A9, /* Monocases to self */
		0x02AA, /* Monocases to self */
		0x02AB, /* Monocases to self */
		0x02AC, /* Monocases to self */
		0x02AD, /* Monocases to self */
		0x02AE, /* Monocases to self */
		0x02AF, /* Monocases to self */
		0x02B0, /* Monocases to self */
		0x02B1, /* Monocases to self */
		0x02B2, /* Monocases to self */
		0x02B3, /* Monocases to self */
		0x02B4, /* Monocases to self */
		0x02B5, /* Monocases to self */
		0x02B6, /* Monocases to self */
		0x02B7, /* Monocases to self */
		0x02B8, /* Monocases to self */
		0x02B9, /* Monocases to self */
		0x02BA, /* Monocases to self */
		0x02BB, /* Monocases to self */
		0x02BC, /* Monocases to self */
		0x02BD, /* Monocases to self */
		0x02BE, /* Monocases to self */
		0x02BF, /* Monocases to self */
		0x02C0, /* Monocases to self */
		0x02C1, /* Monocases to self */
		0x02C2, /* Monocases to self */
		0x02C3, /* Monocases to self */
		0x02C4, /* Monocases to self */
		0x02C5, /* Monocases to self */
		0x02C6, /* Monocases to self */
		0x02C7, /* Monocases to self */
		0x02C8, /* Monocases to self */
		0x02C9, /* Monocases to self */
		0x02CA, /* Monocases to self */
		0x02CB, /* Monocases to self */
		0x02CC, /* Monocases to self */
		0x02CD, /* Monocases to self */
		0x02CE, /* Monocases to self */
		0x02CF, /* Monocases to self */
		0x02D0, /* Monocases to self */
		0x02D1, /* Monocases to self */
		0x02D2, /* Monocases to self */
		0x02D3, /* Monocases to self */
		0x02D4, /* Monocases to self */
		0x02D5, /* Monocases to self */
		0x02D6, /* Monocases to self */
		0x02D7, /* Monocases to self */
		0x02D8, /* Monocases to self */
		0x02D9, /* Monocases to self */
		0x02DA, /* Monocases to self */
		0x02DB, /* Monocases to self */
		0x02DC, /* Monocases to self */
		0x02DD, /* Monocases to self */
		0x02DE, /* Monocases to self */
		0x02DF, /* Monocases to self */
		0x02E0, /* Monocases to self */
		0x02E1, /* Monocases to self */
		0x02E2, /* Monocases to self */
		0x02E3, /* Monocases to self */
		0x02E4, /* Monocases to self */
		0x02E5, /* Monocases to self */
		0x02E6, /* Monocases to self */
		0x02E7, /* Monocases to self */
		0x02E8, /* Monocases to self */
		0x02E9, /* Monocases to self */
		0x02EA, /* Monocases to self */
		0x02EB, /* Monocases to self */
		0x02EC, /* Monocases to self */
		0x02ED, /* Monocases to self */
		0x02EE, /* Monocases to self */
		0x02EF, /* Monocases to self */
		0x02F0, /* Monocases to self */
		0x02F1, /* Monocases to self */
		0x02F2, /* Monocases to self */
		0x02F3, /* Monocases to self */
		0x02F4, /* Monocases to self */
		0x02F5, /* Monocases to self */
		0x02F6, /* Monocases to self */
		0x02F7, /* Monocases to self */
		0x02F8, /* Monocases to self */
		0x02F9, /* Monocases to self */
		0x02FA, /* Monocases to self */
		0x02FB, /* Monocases to self */
		0x02FC, /* Monocases to self */
		0x02FD, /* Monocases to self */
		0x02FE, /* Monocases to self */
		0x02FF, /* Monocases to self */
		0x0300, /* Monocases to self */
		0x0301, /* Monocases to self */
		0x0302, /* Monocases to self */
		0x0303, /* Monocases to self */
		0x0304, /* Monocases to self */
		0x0305, /* Monocases to self */
		0x0306, /* Monocases to self */
		0x0307, /* Monocases to self */
		0x0308, /* Monocases to self */
		0x0309, /* Monocases to self */
		0x030A, /* Monocases to self */
		0x030B, /* Monocases to self */
		0x030C, /* Monocases to self */
		0x030D, /* Monocases to self */
		0x030E, /* Monocases to self */
		0x030F, /* Monocases to self */
		0x0310, /* Monocases to self */
		0x0311, /* Monocases to self */
		0x0312, /* Monocases to self */
		0x0313, /* Monocases to self */
		0x0314, /* Monocases to self */
		0x0315, /* Monocases to self */
		0x0316, /* Monocases to self */
		0x0317, /* Monocases to self */
		0x0318, /* Monocases to self */
		0x0319, /* Monocases to self */
		0x031A, /* Monocases to self */
		0x031B, /* Monocases to self */
		0x031C, /* Monocases to self */
		0x031D, /* Monocases to self */
		0x031E, /* Monocases to self */
		0x031F, /* Monocases to self */
		0x0320, /* Monocases to self */
		0x0321, /* Monocases to self */
		0x0322, /* Monocases to self */
		0x0323, /* Monocases to self */
		0x0324, /* Monocases to self */
		0x0325, /* Monocases to self */
		0x0326, /* Monocases to self */
		0x0327, /* Monocases to self */
		0x0328, /* Monocases to self */
		0x0329, /* Monocases to self */
		0x032A, /* Monocases to self */
		0x032B, /* Monocases to self */
		0x032C, /* Monocases to self */
		0x032D, /* Monocases to self */
		0x032E, /* Monocases to self */
		0x032F, /* Monocases to self */
		0x0330, /* Monocases to self */
		0x0331, /* Monocases to self */
		0x0332, /* Monocases to self */
		0x0333, /* Monocases to self */
		0x0334, /* Monocases to self */
		0x0335, /* Monocases to self */
		0x0336, /* Monocases to self */
		0x0337, /* Monocases to self */
		0x0338, /* Monocases to self */
		0x0339, /* Monocases to self */
		0x033A, /* Monocases to self */
		0x033B, /* Monocases to self */
		0x033C, /* Monocases to self */
		0x033D, /* Monocases to self */
		0x033E, /* Monocases to self */
		0x033F, /* Monocases to self */
		0x0340, /* Monocases to self */
		0x0341, /* Monocases to self */
		0x0342, /* Monocases to self */
		0x0343, /* Monocases to self */
		0x0344, /* Monocases to self */
		0x0345, /* Monocases to self */
		0x0346, /* Monocases to self */
		0x0347, /* Monocases to self */
		0x0348, /* Monocases to self */
		0x0349, /* Monocases to self */
		0x034A, /* Monocases to self */
		0x034B, /* Monocases to self */
		0x034C, /* Monocases to self */
		0x034D, /* Monocases to self */
		0x034E, /* Monocases to self */
		0x034F, /* Monocases to self */
		0x0350, /* Monocases to self */
		0x0351, /* Monocases to self */
		0x0352, /* Monocases to self */
		0x0353, /* Monocases to self */
		0x0354, /* Monocases to self */
		0x0355, /* Monocases to self */
		0x0356, /* Monocases to self */
		0x0357, /* Monocases to self */
		0x0358, /* Monocases to self */
		0x0359, /* Monocases to self */
		0x035A, /* Monocases to self */
		0x035B, /* Monocases to self */
		0x035C, /* Monocases to self */
		0x035D, /* Monocases to self */
		0x035E, /* Monocases to self */
		0x035F, /* Monocases to self */
		0x0360, /* Monocases to self */
		0x0361, /* Monocases to self */
		0x0362, /* Monocases to self */
		0x0363, /* Monocases to self */
		0x0364, /* Monocases to self */
		0x0365, /* Monocases to self */
		0x0366, /* Monocases to self */
		0x0367, /* Monocases to self */
		0x0368, /* Monocases to self */
		0x0369, /* Monocases to self */
		0x036A, /* Monocases to self */
		0x036B, /* Monocases to self */
		0x036C, /* Monocases to self */
		0x036D, /* Monocases to self */
		0x036E, /* Monocases to self */
		0x036F, /* Monocases to self */
		0x0370, /* Monocases to self */
		0x0371, /* Monocases to self */
		0x0372, /* Monocases to self */
		0x0373, /* Monocases to self */
		0x0374, /* Monocases to self */
		0x0375, /* Monocases to self */
		0x0376, /* Monocases to self */
		0x0377, /* Monocases to self */
		0x0378, /* Monocases to self */
		0x0379, /* Monocases to self */
		0x037A, /* Monocases to self */
		0x037B, /* Monocases to self */
		0x037C, /* Monocases to self */
		0x037D, /* Monocases to self */
		0x037E, /* Monocases to self */
		0x037F, /* Monocases to self */
		0x0380, /* Monocases to self */
		0x0381, /* Monocases to self */
		0x0382, /* Monocases to self */
		0x0383, /* Monocases to self */
		0x0384, /* Monocases to self */
		0x0385, /* Monocases to self */
		0x03AC, /* GREEK LETTER ALPHA TONOS */
		0x0387, /* Monocases to self */
		0x03AD, /* GREEK LETTER EPSILON TONOS */
		0x03AE, /* GREEK LETTER ETA TONOS */
		0x03AF, /* GREEK LETTER IOTA TONOS */
		0x038B, /* Monocases to self */
		0x03CC, /* GREEK LETTER OMICRON TONOS */
		0x038D, /* Monocases to self */
		0x03CD, /* GREEK LETTER UPSILON TONOS */
		0x03CE, /* GREEK LETTER OMEGA TONOS */
		0x0390, /* Monocases to self */
		0x03B1, /* GREEK LETTER ALPHA */
		0x03B2, /* GREEK LETTER BETA */
		0x03B3, /* GREEK LETTER GAMMA */
		0x03B4, /* GREEK LETTER DELTA */
		0x03B5, /* GREEK LETTER EPSILON */
		0x03B6, /* GREEK LETTER ZETA */
		0x03B7, /* GREEK LETTER ETA */
		0x03B8, /* GREEK LETTER THETA */
		0x03B9, /* GREEK LETTER IOTA */
		0x03BA, /* GREEK LETTER KAPPA */
		0x03BB, /* GREEK LETTER LAMBDA */
		0x03BC, /* GREEK LETTER MU */
		0x03BD, /* GREEK LETTER NU */
		0x03BE, /* GREEK LETTER Xl */
		0x03BF, /* GREEK LETTER OMICRON */
		0x03C0, /* GREEK LETTER PI */
		0x03C1, /* GREEK LETTER RHO */
		0x03A2, /* Monocases to self */
		0x03C3, /* GREEK LETTER SIGMA */
		0x03C4, /* GREEK LETTER TAU */
		0x03C5, /* GREEK LETTER UPSILON */
		0x03C6, /* GREEK LETTER PHI */
		0x03C7, /* GREEK LETTER CHI */
		0x03C8, /* GREEK LETTER PSI */
		0x03C9, /* GREEK LETTER OMEGA */
		0x03CA, /* GREEK LETTER IOTA DIAERESIS */
		0x03CB, /* GREEK LETTER UPSILON DIAERESIS */
		0x03AC, /* Monocases to self */
		0x03AD, /* Monocases to self */
		0x03AE, /* Monocases to self */
		0x03AF, /* Monocases to self */
		0x03B0, /* Monocases to self */
		0x03B1, /* Monocases to self */
		0x03B2, /* Monocases to self */
		0x03B3, /* Monocases to self */
		0x03B4, /* Monocases to self */
		0x03B5, /* Monocases to self */
		0x03B6, /* Monocases to self */
		0x03B7, /* Monocases to self */
		0x03B8, /* Monocases to self */
		0x03B9, /* Monocases to self */
		0x03BA, /* Monocases to self */
		0x03BB, /* Monocases to self */
		0x03BC, /* Monocases to self */
		0x03BD, /* Monocases to self */
		0x03BE, /* Monocases to self */
		0x03BF, /* Monocases to self */
		0x03C0, /* Monocases to self */
		0x03C1, /* Monocases to self */
		0x03C2, /* Monocases to self */
		0x03C3, /* Monocases to self */
		0x03C4, /* Monocases to self */
		0x03C5, /* Monocases to self */
		0x03C6, /* Monocases to self */
		0x03C7, /* Monocases to self */
		0x03C8, /* Monocases to self */
		0x03C9, /* Monocases to self */
		0x03CA, /* Monocases to self */
		0x03CB, /* Monocases to self */
		0x03CC, /* Monocases to self */
		0x03CD, /* Monocases to self */
		0x03CE, /* Monocases to self */
		0x03CF, /* Monocases to self */
		0x03D0, /* Monocases to self */
		0x03D1, /* Monocases to self */
		0x03C5, /* GREEK LETTER UPSILON HOOK */
		0x03CD, /* GREEK LETTER UPSILON HOOK TONOS */
		0x03CB, /* GREEK LETTER UPSILON HOOK DIAERESIS */
		0x03D5, /* Monocases to self */
		0x03D6, /* Monocases to self */
		0x03D7, /* Monocases to self */
		0x03D8, /* Monocases to self */
		0x03D9, /* Monocases to self */
		0x03DB, /* GREEK LETTER STIGMA */
		0x03DB, /* Monocases to self */
		0x03DD, /* GREEK LETTER DIGAMMA */
		0x03DD, /* Monocases to self */
		0x03DF, /* GREEK LETTER KOPPA */
		0x03DF, /* Monocases to self */
		0x03E1, /* GREEK LETTER SAMPI */
		0x03E1, /* Monocases to self */
		0x03E3, /* GREEK LETTER SHEI */
		0x03E3, /* Monocases to self */
		0x03E5, /* GREEK LETTER FEI */
		0x03E5, /* Monocases to self */
		0x03E7, /* GREEK LETTER KHEI */
		0x03E7, /* Monocases to self */
		0x03E9, /* GREEK LETTER HORI */
		0x03E9, /* Monocases to self */
		0x03EB, /* GREEK LETTER GANGIA */
		0x03EB, /* Monocases to self */
		0x03ED, /* GREEK LETTER SHIMA */
		0x03ED, /* Monocases to self */
		0x03EF, /* GREEK LETTER DEI */
		0x03EF, /* Monocases to self */
		0x03F0, /* Monocases to self */
		0x03F1, /* Monocases to self */
		0x03F2, /* Monocases to self */
		0x03F3, /* Monocases to self */
		0x03F4, /* Monocases to self */
		0x03F5, /* Monocases to self */
		0x03F6, /* Monocases to self */
		0x03F7, /* Monocases to self */
		0x03F8, /* Monocases to self */
		0x03F9, /* Monocases to self */
		0x03FA, /* Monocases to self */
		0x03FB, /* Monocases to self */
		0x03FC, /* Monocases to self */
		0x03FD, /* Monocases to self */
		0x03FE, /* Monocases to self */
		0x03FF, /* Monocases to self */
		0x0400, /* Monocases to self */
		0x0451, /* CYRILLIC LETTER IO */
		0x0452, /* CYRILLIC LETTER DJE */
		0x0453, /* CYRILLIC LETTER GJE */
		0x0454, /* CYRILLIC LETTER E */
		0x0455, /* CYRILLIC LETTER DZE */
		0x0456, /* CYRILLIC LETTER I */
		0x0457, /* CYRILLIC LETTER YI */
		0x0458, /* CYRILLIC LETTER JE */
		0x0459, /* CYRILLIC LETTER LJE */
		0x045A, /* CYRILLIC LETTER NJE */
		0x045B, /* CYRILLIC LETTER TSHE */
		0x045C, /* CYRILLIC LETTER KJE */
		0x040D, /* Monocases to self */
		0x045E, /* CYRILLIC LETTER SHORT U */
		0x045F, /* CYRILLIC LETTER DZHE */
		0x0430, /* CYRILLIC LETTER A */
		0x0431, /* CYRILLIC LETTER BE */
		0x0432, /* CYRILLIC LETTER VE */
		0x0433, /* CYRILLIC LETTER GE */
		0x0434, /* CYRILLIC LETTER DE */
		0x0435, /* CYRILLIC LETTER IE */
		0x0436, /* CYRILLIC LETTER ZHE */
		0x0437, /* CYRILLIC LETTER ZE */
		0x0438, /* CYRILLIC LETTER II */
		0x0439, /* CYRILLIC LETTER SHORT II */
		0x043A, /* CYRILLIC LETTER KA */
		0x043B, /* CYRILLIC LETTER EL */
		0x043C, /* CYRILLIC LETTER EM */
		0x043D, /* CYRILLIC LETTER EN */
		0x043E, /* CYRILLIC LETTER O */
		0x043F, /* CYRILLIC LETTER PE */
		0x0440, /* CYRILLIC LETTER ER */
		0x0441, /* CYRILLIC LETTER ES */
		0x0442, /* CYRILLIC LETTER TE */
		0x0443, /* CYRILLIC LETTER U */
		0x0444, /* CYRILLIC LETTER EF */
		0x0445, /* CYRILLIC LETTER KHA */
		0x0446, /* CYRILLIC LETTER TSE */
		0x0447, /* CYRILLIC LETTER CHE */
		0x0448, /* CYRILLIC LETTER SHA */
		0x0449, /* CYRILLIC LETTER SHCHA */
		0x044A, /* CYRILLIC LETTER HARD SIGN */
		0x044B, /* CYRILLIC LETTER YERI */
		0x044C, /* CYRILLIC LETTER SOFT SIGN */
		0x044D, /* CYRILLIC LETTER REVERSED E */
		0x044E, /* CYRILLIC LETTER IU */
		0x044F, /* CYRILLIC LETTER IA */
		0x0430, /* Monocases to self */
		0x0431, /* Monocases to self */
		0x0432, /* Monocases to self */
		0x0433, /* Monocases to self */
		0x0434, /* Monocases to self */
		0x0435, /* Monocases to self */
		0x0436, /* Monocases to self */
		0x0437, /* Monocases to self */
		0x0438, /* Monocases to self */
		0x0439, /* Monocases to self */
		0x043A, /* Monocases to self */
		0x043B, /* Monocases to self */
		0x043C, /* Monocases to self */
		0x043D, /* Monocases to self */
		0x043E, /* Monocases to self */
		0x043F, /* Monocases to self */
		0x0440, /* Monocases to self */
		0x0441, /* Monocases to self */
		0x0442, /* Monocases to self */
		0x0443, /* Monocases to self */
		0x0444, /* Monocases to self */
		0x0445, /* Monocases to self */
		0x0446, /* Monocases to self */
		0x0447, /* Monocases to self */
		0x0448, /* Monocases to self */
		0x0449, /* Monocases to self */
		0x044A, /* Monocases to self */
		0x044B, /* Monocases to self */
		0x044C, /* Monocases to self */
		0x044D, /* Monocases to self */
		0x044E, /* Monocases to self */
		0x044F, /* Monocases to self */
		0x0450, /* Monocases to self */
		0x0451, /* Monocases to self */
		0x0452, /* Monocases to self */
		0x0453, /* Monocases to self */
		0x0454, /* Monocases to self */
		0x0455, /* Monocases to self */
		0x0456, /* Monocases to self */
		0x0457, /* Monocases to self */
		0x0458, /* Monocases to self */
		0x0459, /* Monocases to self */
		0x045A, /* Monocases to self */
		0x045B, /* Monocases to self */
		0x045C, /* Monocases to self */
		0x045D, /* Monocases to self */
		0x045E, /* Monocases to self */
		0x045F, /* Monocases to self */
		0x0461, /* CYRILLIC LETTER OMEGA */
		0x0461, /* Monocases to self */
		0x0463, /* CYRILLIC LETTER YAT */
		0x0463, /* Monocases to self */
		0x0465, /* CYRILLIC LETTER IOTIFIED E */
		0x0465, /* Monocases to self */
		0x0467, /* CYRILLIC LETTER LITTLE YUS */
		0x0467, /* Monocases to self */
		0x0469, /* CYRILLIC LETTER IOTIFIED LITTLE YUS */
		0x0469, /* Monocases to self */
		0x046B, /* CYRILLIC LETTER BIG YUS */
		0x046B, /* Monocases to self */
		0x046D, /* CYRILLIC LETTER IOTIFIED BIG YUS */
		0x046D, /* Monocases to self */
		0x046F, /* CYRILLIC LETTER KSI */
		0x046F, /* Monocases to self */
		0x0471, /* CYRILLIC LETTER PSI */
		0x0471, /* Monocases to self */
		0x0473, /* CYRILLIC LETTER FITA */
		0x0473, /* Monocases to self */
		0x0475, /* CYRILLIC LETTER IZHITSA */
		0x0475, /* Monocases to self */
		0x0477, /* CYRILLIC LETTER IZHITSA DOUBLE GRAVE */
		0x0477, /* Monocases to self */
		0x0479, /* CYRILLIC LETTER UK DIGRAPH */
		0x0479, /* Monocases to self */
		0x047B, /* CYRILLIC LETTER ROUND OMEGA */
		0x047B, /* Monocases to self */
		0x047D, /* CYRILLIC LETTER OMEGA TITLO */
		0x047D, /* Monocases to self */
		0x047F, /* CYRILLIC LETTER OT */
		0x047F, /* Monocases to self */
		0x0481, /* CYRILLIC LETTER KOPPA */
		0x0481, /* Monocases to self */
		0x0482, /* Monocases to self */
		0x0483, /* Monocases to self */
		0x0484, /* Monocases to self */
		0x0485, /* Monocases to self */
		0x0486, /* Monocases to self */
		0x0487, /* Monocases to self */
		0x0488, /* Monocases to self */
		0x0489, /* Monocases to self */
		0x048A, /* Monocases to self */
		0x048B, /* Monocases to self */
		0x048C, /* Monocases to self */
		0x048D, /* Monocases to self */
		0x048E, /* Monocases to self */
		0x048F, /* Monocases to self */
		0x0491, /* CYRILLIC LETTER GE WITH UPTURN */
		0x0491, /* Monocases to self */
		0x0493, /* CYRILLIC LETTER GE BAR */
		0x0493, /* Monocases to self */
		0x0495, /* CYRILLIC LETTER GE HOOK */
		0x0495, /* Monocases to self */
		0x0497, /* CYRILLIC LETTER ZHE WITH RIGHT DESCENDER */
		0x0497, /* Monocases to self */
		0x0499, /* CYRILLIC LETTER ZE CEDILLA */
		0x0499, /* Monocases to self */
		0x049B, /* CYRILLIC LETTER KA WITH RIGHT DESCENDER */
		0x049B, /* Monocases to self */
		0x049D, /* CYRILLIC LETTER KA VERTICAL BAR */
		0x049D, /* Monocases to self */
		0x049F, /* CYRILLIC LETTER KA BAR */
		0x049F, /* Monocases to self */
		0x04A1, /* CYRILLIC LETTER REVERSED GE KA */
		0x04A1, /* Monocases to self */
		0x04A3, /* CYRILLIC LETTER EN WITH RIGHT DESCENDER */
		0x04A3, /* Monocases to self */
		0x04A5, /* CYRILLIC LETTER EN GE */
		0x04A5, /* Monocases to self */
		0x04A7, /* CYRILLIC LETTER PE HOOK */
		0x04A7, /* Monocases to self */
		0x04A9, /* CYRILLIC LETTER O HOOK */
		0x04A9, /* Monocases to self */
		0x04AB, /* CYRILLIC LETTER ES CEDILLA */
		0x04AB, /* Monocases to self */
		0x04AD, /* CYRILLIC LETTER TE WITH RIGHT DESCENDER */
		0x04AD, /* Monocases to self */
		0x04AF, /* CYRILLIC LETTER STRAIGHT U */
		0x04AF, /* Monocases to self */
		0x04B1, /* CYRILLIC LETTER STRAIGHT U BAR */
		0x04B1, /* Monocases to self */
		0x04B3, /* CYRILLIC LETTER KHA WITH RIGHT DESCENDER */
		0x04B3, /* Monocases to self */
		0x04B5, /* CYRILLIC LETTER TE TSE */
		0x04B5, /* Monocases to self */
		0x04B7, /* CYRILLIC LETTER CHE WITH RIGHT DESCENDER */
		0x04B7, /* Monocases to self */
		0x04B9, /* CYRILLIC LETTER CHE VERTICAL BAR */
		0x04B9, /* Monocases to self */
		0x04BB, /* CYRILLIC LETTER H */
		0x04BB, /* Monocases to self */
		0x04BD, /* CYRILLIC LETTER IE HOOK */
		0x04BD, /* Monocases to self */
		0x04BF, /* CYRILLIC LETTER IE HOOK OGONEK */
		0x04BF, /* Monocases to self */
		0x04C0, /* Monocases to self */
		0x04C2, /* CYRILLIC LETTER SHORT ZHE */
		0x04C2, /* Monocases to self */
		0x04C4, /* CYRILLIC LETTER KA HOOK */
		0x04C4, /* Monocases to self */
		0x04C6, /* CYRILLIC LETTER KA OGONEK */
		0x04C6, /* Monocases to self */
		0x04C8, /* CYRILLIC LETTER EN HOOK */
		0x04C8, /* Monocases to self */
		0x04CA, /* CYRILLIC LETTER KHA OGONEK */
		0x04CA, /* Monocases to self */
		0x04CC, /* CYRILLIC LETTER CHE WITH LEFT DESCENDER */
		0x04CC, /* Monocases to self */
		0x04CD, /* Monocases to self */
		0x04CE, /* Monocases to self */
		0x04CF, /* Monocases to self */
		0x04D0, /* Monocases to self */
		0x04D1, /* Monocases to self */
		0x04D2, /* Monocases to self */
		0x04D3, /* Monocases to self */
		0x04D4, /* Monocases to self */
		0x04D5, /* Monocases to self */
		0x04D6, /* Monocases to self */
		0x04D7, /* Monocases to self */
		0x04D8, /* Monocases to self */
		0x04D9, /* Monocases to self */
		0x04DA, /* Monocases to self */
		0x04DB, /* Monocases to self */
		0x04DC, /* Monocases to self */
		0x04DD, /* Monocases to self */
		0x04DE, /* Monocases to self */
		0x04DF, /* Monocases to self */
		0x04E0, /* Monocases to self */
		0x04E1, /* Monocases to self */
		0x04E2, /* Monocases to self */
		0x04E3, /* Monocases to self */
		0x04E4, /* Monocases to self */
		0x04E5, /* Monocases to self */
		0x04E6, /* Monocases to self */
		0x04E7, /* Monocases to self */
		0x04E8, /* Monocases to self */
		0x04E9, /* Monocases to self */
		0x04EA, /* Monocases to self */
		0x04EB, /* Monocases to self */
		0x04EC, /* Monocases to self */
		0x04ED, /* Monocases to self */
		0x04EE, /* Monocases to self */
		0x04EF, /* Monocases to self */
		0x04F0, /* Monocases to self */
		0x04F1, /* Monocases to self */
		0x04F2, /* Monocases to self */
		0x04F3, /* Monocases to self */
		0x04F4, /* Monocases to self */
		0x04F5, /* Monocases to self */
		0x04F6, /* Monocases to self */
		0x04F7, /* Monocases to self */
		0x04F8, /* Monocases to self */
		0x04F9, /* Monocases to self */
		0x04FA, /* Monocases to self */
		0x04FB, /* Monocases to self */
		0x04FC, /* Monocases to self */
		0x04FD, /* Monocases to self */
		0x04FE, /* Monocases to self */
		0x04FF, /* Monocases to self */
		0x0500, /* Monocases to self */
		0x0501, /* Monocases to self */
		0x0502, /* Monocases to self */
		0x0503, /* Monocases to self */
		0x0504, /* Monocases to self */
		0x0505, /* Monocases to self */
		0x0506, /* Monocases to self */
		0x0507, /* Monocases to self */
		0x0508, /* Monocases to self */
		0x0509, /* Monocases to self */
		0x050A, /* Monocases to self */
		0x050B, /* Monocases to self */
		0x050C, /* Monocases to self */
		0x050D, /* Monocases to self */
		0x050E, /* Monocases to self */
		0x050F, /* Monocases to self */
		0x0510, /* Monocases to self */
		0x0511, /* Monocases to self */
		0x0512, /* Monocases to self */
		0x0513, /* Monocases to self */
		0x0514, /* Monocases to self */
		0x0515, /* Monocases to self */
		0x0516, /* Monocases to self */
		0x0517, /* Monocases to self */
		0x0518, /* Monocases to self */
		0x0519, /* Monocases to self */
		0x051A, /* Monocases to self */
		0x051B, /* Monocases to self */
		0x051C, /* Monocases to self */
		0x051D, /* Monocases to self */
		0x051E, /* Monocases to self */
		0x051F, /* Monocases to self */
		0x0520, /* Monocases to self */
		0x0521, /* Monocases to self */
		0x0522, /* Monocases to self */
		0x0523, /* Monocases to self */
		0x0524, /* Monocases to self */
		0x0525, /* Monocases to self */
		0x0526, /* Monocases to self */
		0x0527, /* Monocases to self */
		0x0528, /* Monocases to self */
		0x0529, /* Monocases to self */
		0x052A, /* Monocases to self */
		0x052B, /* Monocases to self */
		0x052C, /* Monocases to self */
		0x052D, /* Monocases to self */
		0x052E, /* Monocases to self */
		0x052F, /* Monocases to self */
		0x0530, /* Monocases to self */
		0x0561, /* ARMENIAN LETTER AYB */
		0x0562, /* ARMENIAN LETTER BEN */
		0x0563, /* ARMENIAN LETTER GIM */
		0x0564, /* ARMENIAN LETTER DA */
		0x0565, /* ARMENIAN LETTER ECH */
		0x0566, /* ARMENIAN LETTER ZA */
		0x0567, /* ARMENIAN LETTER EH */
		0x0568, /* ARMENIAN LETTER ET */
		0x0569, /* ARMENIAN LETTER TO */
		0x056A, /* ARMENIAN LETTER ZHE */
		0x056B, /* ARMENIAN LETTER INI */
		0x056C, /* ARMENIAN LETTER LIWN */
		0x056D, /* ARMENIAN LETTER XEH */
		0x056E, /* ARMENIAN LETTER CA */
		0x056F, /* ARMENIAN LETTER KEN */
		0x0570, /* ARMENIAN LETTER HO */
		0x0571, /* ARMENIAN LETTER JA */
		0x0572, /* ARMENIAN LETTER LAD */
		0x0573, /* ARMENIAN LETTER CHEH */
		0x0574, /* ARMENIAN LETTER MEN */
		0x0575, /* ARMENIAN LETTER YI */
		0x0576, /* ARMENIAN LETTER NOW */
		0x0577, /* ARMENIAN LETTER SHA */
		0x0578, /* ARMENIAN LETTER VO */
		0x0579, /* ARMENIAN LETTER CHA */
		0x057A, /* ARMENIAN LETTER PEH */
		0x057B, /* ARMENIAN LETTER JHEH */
		0x057C, /* ARMENIAN LETTER RA */
		0x057D, /* ARMENIAN LETTER SEH */
		0x057E, /* ARMENIAN LETTER VEW */
		0x057F, /* ARMENIAN LETTER TIWN */
		0x0580, /* ARMENIAN LETTER REH */
		0x0581, /* ARMENIAN LETTER CO */
		0x0582, /* ARMENIAN LETTER YIWN */
		0x0583, /* ARMENIAN LETTER PIWR */
		0x0584, /* ARMENIAN LETTER KEH */
		0x0585, /* ARMENIAN LETTER OH */
		0x0586, /* ARMENIAN LETTER FEH */
		0x0557, /* Monocases to self */
		0x0558, /* Monocases to self */
		0x0559, /* Monocases to self */
		0x055A, /* Monocases to self */
		0x055B, /* Monocases to self */
		0x055C, /* Monocases to self */
		0x055D, /* Monocases to self */
		0x055E, /* Monocases to self */
		0x055F, /* Monocases to self */
		0x0560, /* Monocases to self */
		0x0561, /* Monocases to self */
		0x0562, /* Monocases to self */
		0x0563, /* Monocases to self */
		0x0564, /* Monocases to self */
		0x0565, /* Monocases to self */
		0x0566, /* Monocases to self */
		0x0567, /* Monocases to self */
		0x0568, /* Monocases to self */
		0x0569, /* Monocases to self */
		0x056A, /* Monocases to self */
		0x056B, /* Monocases to self */
		0x056C, /* Monocases to self */
		0x056D, /* Monocases to self */
		0x056E, /* Monocases to self */
		0x056F, /* Monocases to self */
		0x0570, /* Monocases to self */
		0x0571, /* Monocases to self */
		0x0572, /* Monocases to self */
		0x0573, /* Monocases to self */
		0x0574, /* Monocases to self */
		0x0575, /* Monocases to self */
		0x0576, /* Monocases to self */
		0x0577, /* Monocases to self */
		0x0578, /* Monocases to self */
		0x0579, /* Monocases to self */
		0x057A, /* Monocases to self */
		0x057B, /* Monocases to self */
		0x057C, /* Monocases to self */
		0x057D, /* Monocases to self */
		0x057E, /* Monocases to self */
		0x057F, /* Monocases to self */
		0x0580, /* Monocases to self */
		0x0581, /* Monocases to self */
		0x0582, /* Monocases to self */
		0x0583, /* Monocases to self */
		0x0584, /* Monocases to self */
		0x0585, /* Monocases to self */
		0x0586, /* Monocases to self */
		0x0587, /* Monocases to self */
		0x0588, /* Monocases to self */
		0x0589, /* Monocases to self */
		0x058A, /* Monocases to self */
		0x058B, /* Monocases to self */
		0x058C, /* Monocases to self */
		0x058D, /* Monocases to self */
		0x058E, /* Monocases to self */
		0x058F, /* Monocases to self */
		0x0590, /* Monocases to self */
		0x0591, /* Monocases to self */
		0x0592, /* Monocases to self */
		0x0593, /* Monocases to self */
		0x0594, /* Monocases to self */
		0x0595, /* Monocases to self */
		0x0596, /* Monocases to self */
		0x0597, /* Monocases to self */
		0x0598, /* Monocases to self */
		0x0599, /* Monocases to self */
		0x059A, /* Monocases to self */
		0x059B, /* Monocases to self */
		0x059C, /* Monocases to self */
		0x059D, /* Monocases to self */
		0x059E, /* Monocases to self */
		0x059F, /* Monocases to self */
		0x05A0, /* Monocases to self */
		0x05A1, /* Monocases to self */
		0x05A2, /* Monocases to self */
		0x05A3, /* Monocases to self */
		0x05A4, /* Monocases to self */
		0x05A5, /* Monocases to self */
		0x05A6, /* Monocases to self */
		0x05A7, /* Monocases to self */
		0x05A8, /* Monocases to self */
		0x05A9, /* Monocases to self */
		0x05AA, /* Monocases to self */
		0x05AB, /* Monocases to self */
		0x05AC, /* Monocases to self */
		0x05AD, /* Monocases to self */
		0x05AE, /* Monocases to self */
		0x05AF, /* Monocases to self */
		0x05B0, /* Monocases to self */
		0x05B1, /* Monocases to self */
		0x05B2, /* Monocases to self */
		0x05B3, /* Monocases to self */
		0x05B4, /* Monocases to self */
		0x05B5, /* Monocases to self */
		0x05B6, /* Monocases to self */
		0x05B7, /* Monocases to self */
		0x05B8, /* Monocases to self */
		0x05B9, /* Monocases to self */
		0x05BA, /* Monocases to self */
		0x05BB, /* Monocases to self */
		0x05BC, /* Monocases to self */
		0x05BD, /* Monocases to self */
		0x05BE, /* Monocases to self */
		0x05BF, /* Monocases to self */
		0x05C0, /* Monocases to self */
		0x05C1, /* Monocases to self */
		0x05C2, /* Monocases to self */
		0x05C3, /* Monocases to self */
		0x05C4, /* Monocases to self */
		0x05C5, /* Monocases to self */
		0x05C6, /* Monocases to self */
		0x05C7, /* Monocases to self */
		0x05C8, /* Monocases to self */
		0x05C9, /* Monocases to self */
		0x05CA, /* Monocases to self */
		0x05CB, /* Monocases to self */
		0x05CC, /* Monocases to self */
		0x05CD, /* Monocases to self */
		0x05CE, /* Monocases to self */
		0x05CF, /* Monocases to self */
		0x05D0, /* Monocases to self */
		0x05D1, /* Monocases to self */
		0x05D2, /* Monocases to self */
		0x05D3, /* Monocases to self */
		0x05D4, /* Monocases to self */
		0x05D5, /* Monocases to self */
		0x05D6, /* Monocases to self */
		0x05D7, /* Monocases to self */
		0x05D8, /* Monocases to self */
		0x05D9, /* Monocases to self */
		0x05DA, /* Monocases to self */
		0x05DB, /* Monocases to self */
		0x05DC, /* Monocases to self */
		0x05DD, /* Monocases to self */
		0x05DE, /* Monocases to self */
		0x05DF, /* Monocases to self */
		0x05E0, /* Monocases to self */
		0x05E1, /* Monocases to self */
		0x05E2, /* Monocases to self */
		0x05E3, /* Monocases to self */
		0x05E4, /* Monocases to self */
		0x05E5, /* Monocases to self */
		0x05E6, /* Monocases to self */
		0x05E7, /* Monocases to self */
		0x05E8, /* Monocases to self */
		0x05E9, /* Monocases to self */
		0x05EA, /* Monocases to self */
		0x05EB, /* Monocases to self */
		0x05EC, /* Monocases to self */
		0x05ED, /* Monocases to self */
		0x05EE, /* Monocases to self */
		0x05EF, /* Monocases to self */
		0x05F0, /* Monocases to self */
		0x05F1, /* Monocases to self */
		0x05F2, /* Monocases to self */
		0x05F3, /* Monocases to self */
		0x05F4, /* Monocases to self */
		0x05F5, /* Monocases to self */
		0x05F6, /* Monocases to self */
		0x05F7, /* Monocases to self */
		0x05F8, /* Monocases to self */
		0x05F9, /* Monocases to self */
		0x05FA, /* Monocases to self */
		0x05FB, /* Monocases to self */
		0x05FC, /* Monocases to self */
		0x05FD, /* Monocases to self */
		0x05FE, /* Monocases to self */
		0x05FF, /* Monocases to self */
	};

	static const FLMUNICODE georgian[ 40] =
	{
		0x10D0, /* GEORGIAN LETTER AN */
		0x10D1, /* GEORGIAN LETTER BAN */
		0x10D2, /* GEORGIAN LETTER GAN */
		0x10D3, /* GEORGIAN LETTER DON */
		0x10D4, /* GEORGIAN LETTER EN */
		0x10D5, /* GEORGIAN LETTER VIN */
		0x10D6, /* GEORGIAN LETTER ZEN */
		0x10D7, /* GEORGIAN LETTER TAN */
		0x10D8, /* GEORGIAN LETTER IN */
		0x10D9, /* GEORGIAN LETTER KAN */
		0x10DA, /* GEORGIAN LETTER LAS */
		0x10DB, /* GEORGIAN LETTER MAN */
		0x10DC, /* GEORGIAN LETTER NAR */
		0x10DD, /* GEORGIAN LETTER ON */
		0x10DE, /* GEORGIAN LETTER PAR */
		0x10DF, /* GEORGIAN LETTER ZHAR */
		0x10E0, /* GEORGIAN LETTER RAE */
		0x10E1, /* GEORGIAN LETTER SAN */
		0x10E2, /* GEORGIAN LETTER TAR */
		0x10E3, /* GEORGIAN LETTER UN */
		0x10E4, /* GEORGIAN LETTER PHAR */
		0x10E5, /* GEORGIAN LETTER KHAR */
		0x10E6, /* GEORGIAN LETTER GHAN */
		0x10E7, /* GEORGIAN LETTER QAR */
		0x10E8, /* GEORGIAN LETTER SHIN */
		0x10E9, /* GEORGIAN LETTER CHIN */
		0x10EA, /* GEORGIAN LETTER CAN */
		0x10EB, /* GEORGIAN LETTER JIL */
		0x10EC, /* GEORGIAN LETTER CIL */
		0x10ED, /* GEORGIAN LETTER CHAR */
		0x10EE, /* GEORGIAN LETTER XAN */
		0x10EF, /* GEORGIAN LETTER JHAN */
		0x10F0, /* GEORGIAN LETTER HAE */
		0x10F1, /* GEORGIAN LETTER HE */
		0x10F2, /* GEORGIAN LETTER HIE */
		0x10F3, /* GEORGIAN LETTER WE */
		0x10F4, /* GEORGIAN LETTER HAR */
		0x10F5, /* GEORGIAN LETTER HOE */
	};

	static const FLMUNICODE circledLatin[26] =
	{
		0x24D0, /* CIRCLED LATIN LETTER A */
		0x24D1, /* CIRCLED LATIN LETTER B */
		0x24D2, /* CIRCLED LATIN LETTER C */
		0x24D3, /* CIRCLED LATIN LETTER D */
		0x24D4, /* CIRCLED LATIN LETTER E */
		0x24D5, /* CIRCLED LATIN LETTER F */
		0x24D6, /* CIRCLED LATIN LETTER G */
		0x24D7, /* CIRCLED LATIN LETTER H */
		0x24D8, /* CIRCLED LATIN LETTER I */
		0x24D9, /* CIRCLED LATIN LETTER J */
		0x24DA, /* CIRCLED LATIN LETTER K */
		0x24DB, /* CIRCLED LATIN LETTER L */
		0x24DC, /* CIRCLED LATIN LETTER M */
		0x24DD, /* CIRCLED LATIN LETTER N */
		0x24DE, /* CIRCLED LATIN LETTER O */
		0x24DF, /* CIRCLED LATIN LETTER P */
		0x24E0, /* CIRCLED LATIN LETTER Q */
		0x24E1, /* CIRCLED LATIN LETTER R */
		0x24E2, /* CIRCLED LATIN LETTER S */
		0x24E3, /* CIRCLED LATIN LETTER T */
		0x24E4, /* CIRCLED LATIN LETTER U */
		0x24E5, /* CIRCLED LATIN LETTER V */
		0x24E6, /* CIRCLED LATIN LETTER W */
		0x24E7, /* CIRCLED LATIN LETTER X */
		0x24E8, /* CIRCLED LATIN LETTER Y */
		0x24E9, /* CIRCLED LATIN LETTER Z */
	};

	static const FLMUNICODE compat[] =
	{
		0x2025,
		0x2014,
		0x2013,
		0x005F,
		0x005F,
		0x0028,
		0x0029,
		0x007B,
		0x007D,
		0x3014,
		0x3015,
		0x3010,
		0x3011,
		0x300A,
		0x300B,
		0x3008,
		0x3009,
		0x300C,
		0x300D,
		0x300E,
		0x300F,
		0xFE45,
		0xFE46,
		0xFE47,
		0xFE48,
		0x203E,
		0x203E,
		0x203E,
		0x203E,
		0x005F,
		0x005F,
		0x005F,
		0x002C,
		0x3001,
		0x002E,
		0xFE53,
		0x003B,
		0x003A,
		0x003F,
		0x0021,
		0x2014,
		0x0028,
		0x0029,
		0x007B,
		0x007D,
		0x3014,
		0x3015,
		0x0023,
		0x0026,
		0x002A,
		0x002B,
		0x002D,
		0x003C,
		0x003E,
		0x003D,
		0xFE67,
		0x005C,
		0x0024,
		0x0025,
		0x0040,
		0xFE6C,
		0xFE6D,
		0xFE6E,
		0xFE6F,
		0x064B,
		0x064B,
		0x064C,
		0xFE73,
		0x064D,
		0xFE75,
		0x064E,
		0x064E,
		0x064F,
		0x064F,
		0x0650,
		0x0650,
		0x0651,
		0x0651,
		0x0652,
		0x0652,
		0x0621,
		0x0622,
		0x0622,
		0x0623,
		0x0623,
		0x0624,
		0x0624,
		0x0625,
		0x0625,
		0x0626,
		0x0626,
		0x0626,
		0x0626,
		0x0627,
		0x0627,
		0x0628,
		0x0628,
		0x0628,
		0x0628,
		0x0629,
		0x0629,
		0x062A,
		0x062A,
		0x062A,
		0x062A,
		0x062B,
		0x062B,
		0x062B,
		0x062B,
		0x062C,
		0x062C,
		0x062C,
		0x062C,
		0x062D,
		0x062D,
		0x062D,
		0x062D,
		0x062E,
		0x062E,
		0x062E,
		0x062E,
		0x062F,
		0x062F,
		0x0630,
		0x0630,
		0x0631,
		0x0631,
		0x0632,
		0x0632,
		0x0633,
		0x0633,
		0x0633,
		0x0633,
		0x0634,
		0x0634,
		0x0634,
		0x0634,
		0x0635,
		0x0635,
		0x0635,
		0x0635,
		0x0636,
		0x0636,
		0x0636,
		0x0636,
		0x0637,
		0x0637,
		0x0637,
		0x0637,
		0x0638,
		0x0638,
		0x0638,
		0x0638,
		0x0639,
		0x0639,
		0x0639,
		0x0639,
		0x063A,
		0x063A,
		0x063A,
		0x063A,
		0x0641,
		0x0641,
		0x0641,
		0x0641,
		0x0642,
		0x0642,
		0x0642,
		0x0642,
		0x0643,
		0x0643,
		0x0643,
		0x0643,
		0x0644,
		0x0644,
		0x0644,
		0x0644,
		0x0645,
		0x0645,
		0x0645,
		0x0645,
		0x0646,
		0x0646,
		0x0646,
		0x0646,
		0x0647,
		0x0647,
		0x0647,
		0x0647,
		0x0648,
		0x0648,
		0x0649,
		0x0649,
		0x064A,
		0x064A,
		0x064A,
		0x064A,
		0xFEF5,
		0xFEF6,
		0xFEF7,
		0xFEF8,
		0xFEF9,
		0xFEFA,
		0xFEFB,
		0xFEFC,
		0xFEFD,
		0xFEFE,
		0xFEFE,
		0xFE00,
		0x0021,
		0x0022,
		0x0023,
		0x0024,
		0x0025,
		0x0026,
		0x0027,
		0x0028,
		0x0029,
		0x002A,
		0x002B,
		0x002C,
		0x002D,
		0x002E,
		0x002F,
		0x0030,
		0x0031,
		0x0032,
		0x0033,
		0x0034,
		0x0035,
		0x0036,
		0x0037,
		0x0038,
		0x0039,
		0x003A,
		0x003B,
		0x003C,
		0x003D,
		0x003E,
		0x003F,
		0x0040,
		0x0061,
		0x0062,
		0x0063,
		0x0064,
		0x0065,
		0x0066,
		0x0067,
		0x0068,
		0x0069,
		0x006A,
		0x006B,
		0x006C,
		0x006D,
		0x006E,
		0x006F,
		0x0070,
		0x0071,
		0x0072,
		0x0073,
		0x0074,
		0x0075,
		0x0076,
		0x0077,
		0x0078,
		0x0079,
		0x007A,
		0x005B,
		0x005C,
		0x005D,
		0x005E,
		0x005F,
		0x0060,
		0x0061,
		0x0062,
		0x0063,
		0x0064,
		0x0065,
		0x0066,
		0x0067,
		0x0068,
		0x0069,
		0x006A,
		0x006B,
		0x006C,
		0x006D,
		0x006E,
		0x006F,
		0x0070,
		0x0071,
		0x0072,
		0x0073,
		0x0074,
		0x0075,
		0x0076,
		0x0077,
		0x0078,
		0x0079,
		0x007A,
		0x007B,
		0x007C,
		0x007D,
		0x007E,
		0xFF5F,
		0xFF60,
		0x3002,
		0x300C,
		0x300D,
		0x3001,
		0x30FB,
		0x30F2,
		0x30A1,
		0x30A3,
		0x30A5,
		0x30A7,
		0x30A9,
		0x30E3,
		0x30E5,
		0x30E7,
		0x30C3,
		0x30FC,
		0x30A2,
		0x30A4,
		0x30A6,
		0x30A8,
		0x30AA,
		0x30AB,
		0x30AD,
		0x30AF,
		0x30B1,
		0x30B3,
		0x30B5,
		0x30B7,
		0x30B9,
		0x30BB,
		0x30BD,
		0x30BF,
		0x30C1,
		0x30C4,
		0x30C6,
		0x30C8,
		0x30CA,
		0x30CB,
		0x30CC,
		0x30CD,
		0x30CE,
		0x30CF,
		0x30D2,
		0x30D5,
		0x30D8,
		0x30DB,
		0x30DE,
		0x30DF,
		0x30E0,
		0x30E1,
		0x30E2,
		0x30E4,
		0x30E6,
		0x30E8,
		0x30E9,
		0x30EA,
		0x30EB,
		0x30EC,
		0x30ED,
		0x30EF,
		0x30F3,
		0x309B,
		0x309C,
		0x3164,
		0x3131,
		0x3132,
		0x3133,
		0x3134,
		0x3135,
		0x3136,
		0x3137,
		0x3138,
		0x3139,
		0x313A,
		0x313B,
		0x313C,
		0x313D,
		0x313E,
		0x313F,
		0x3140,
		0x3141,
		0x3142,
		0x3143,
		0x3144,
		0x3145,
		0x3146,
		0x3147,
		0x3148,
		0x3149,
		0x314A,
		0x314B,
		0x314C,
		0x314D,
		0x314E,
		0xFFBF,
		0xFFC0,
		0xFFC1,
		0x314F,
		0x3150,
		0x3151,
		0x3152,
		0x3153,
		0x3154,
		0xFFC8,
		0xFFC9,
		0x3155,
		0x3156,
		0x3157,
		0x3158,
		0x3159,
		0x315A,
		0xFFD0,
		0xFFD1,
		0x315B,
		0x315C,
		0x315D,
		0x315E,
		0x315F,
		0x3160,
		0xFFD8,
		0xFFD9,
		0x3161,
		0x3162,
		0x3163,
		0xFFDD,
		0xFFDE,
		0xFFDF,
		0x00A2,
		0x00A3,
		0x00AC,
		0x00AF,
		0x00A6,
		0x00A5,
		0x20A9
	};

	if( uChar < 0x600)
	{
		uChar = basicAlpha[ uChar];
	}
	else if( uChar < 0x10A0)
	{
		;
	}
	else if( uChar >= 0x10A0 && uChar <= 0x10C5)
	{
		uChar = georgian[ uChar - 0x10A0];
	}
	else if( uChar >= 0x24B6 && uChar <= 0x24CF)
	{
		uChar = circledLatin[ uChar - 0x24B6];
	}
	else if( uChar >= 0xFE30 && uChar <= 0xFFE6)
	{
		uChar = compat[ uChar - 0xFE30];
	}

	return( uChar);
}

/****************************************************************************
Desc: Compares two Unicode strings
****************************************************************************/
FLMINT FLMAPI f_unicmp(
	const FLMUNICODE *	puzStr1,
	const FLMUNICODE *	puzStr2)
{
	while( *puzStr1 == *puzStr2 && *puzStr1)
	{
		puzStr1++;
		puzStr2++;
	}

	return( (FLMINT)*puzStr1 - (FLMINT)*puzStr2);
}

/****************************************************************************
Desc: Performs a case-insensitive comparision of two Unicode strings
****************************************************************************/
FLMINT FLMAPI f_uniicmp(
	const FLMUNICODE *	puzStr1,
	const FLMUNICODE *	puzStr2)
{
	while( f_uniToLower( *puzStr1) == f_uniToLower( *puzStr2) && *puzStr1)
	{
		puzStr1++;
		puzStr2++;
	}

	return( (FLMINT)f_uniToLower( *puzStr1) - (FLMINT)f_uniToLower( *puzStr2));
}

/****************************************************************************
Desc: Compares two strings, one Unicode and one native
****************************************************************************/
FLMINT FLMAPI f_uninativecmp(
	const FLMUNICODE *	puzStr1,
	const char *			pszStr2)
{
	while( *puzStr1 == ((FLMUNICODE)f_toascii( *pszStr2)) && *puzStr1)
	{
		puzStr1++;
		pszStr2++;
	}

	return( (FLMINT)*puzStr1 - (FLMINT)*pszStr2);
}

/****************************************************************************
Desc: Compares two strings, one Unicode and one native
****************************************************************************/
FLMINT FLMAPI f_uninativencmp(
	const FLMUNICODE *	puzStr1,
	const char *			pszStr2,
	FLMUINT					uiCount)
{
	if( !uiCount)
	{
		return( 0);
	}

	while( uiCount && 
		*puzStr1 == ((FLMUNICODE)f_toascii( *pszStr2)) && *puzStr1)
	{
		puzStr1++;
		pszStr2++;
		uiCount--;
	}

	return( uiCount ? ((FLMINT)*puzStr1 - (FLMINT)*pszStr2) : 0);
}

/***************************************************************************
Desc:
****************************************************************************/
FLMBOOL FLMAPI f_uniIsUpper(
	FLMUNICODE	uzChar)
{
	FLMBOOL	bRV;

	if (uzChar & 0x1)
	{
		bRV = (UnicodeProperties[uzChar / 2] & UNICODE_UPPERCASE_MASK) 
									? TRUE 
									: FALSE;	
	}
	else
	{
		bRV = ((UnicodeProperties[ uzChar / 2] >> 4) & UNICODE_UPPERCASE_MASK) 
									? TRUE 
									: FALSE;
	}
	
	return( bRV);
}

/***************************************************************************
Desc:
****************************************************************************/
FLMBOOL FLMAPI f_uniIsLower(
	FLMUNICODE	uzChar)
{
	FLMBOOL	bRV;

	if (uzChar & 0x1)
	{
		bRV = (UnicodeProperties[ uzChar / 2] & UNICODE_LOWERCASE_MASK) 
								? TRUE 
								: FALSE;	
	}
	else
	{
		bRV = ((UnicodeProperties[ uzChar / 2] >> 4) & UNICODE_LOWERCASE_MASK) 
								? TRUE 
								: FALSE;
	}
	
	return( bRV);
}

/***************************************************************************
Desc:
****************************************************************************/
FLMBOOL FLMAPI f_uniIsAlpha(
	FLMUNICODE	uzChar)
{
	FLMBOOL	bRV;

	if (uzChar & 0x1)
	{
		bRV = (UnicodeProperties[ uzChar / 2] & UNICODE_ALPHABETIC_MASK) 
							? TRUE 
							: FALSE;	
	}
	else
	{
		bRV = ((UnicodeProperties[ uzChar / 2] >> 4) & UNICODE_ALPHABETIC_MASK) 
							? TRUE 
							: FALSE;
	}
	
	return( bRV);
}

/***************************************************************************
Desc:
****************************************************************************/
FLMBOOL FLMAPI f_uniIsDecimalDigit(
	FLMUNICODE	uzChar)
{
	FLMBOOL	bRV;

	if (uzChar & 0x1)
	{
		bRV = (UnicodeProperties[ uzChar / 2] & UNICODE_DECIMAL_DIGIT_MASK) 
							? TRUE 
							: FALSE;	
	}
	else
	{
		bRV = ((UnicodeProperties[ uzChar / 2] >> 4) & UNICODE_DECIMAL_DIGIT_MASK) 
							? TRUE 
							: FALSE;
	}
	
	return( bRV);
}

/***************************************************************************
Desc:
****************************************************************************/
RCODE	FLMAPI f_nextUCS2Char(
	const FLMBYTE **		ppszUTF8,
	const FLMBYTE *		pszEndOfUTF8String,
	FLMUNICODE *			puzChar)
{
	return( f_getCharFromUTF8Buf( ppszUTF8, pszEndOfUTF8String, puzChar));
}

/***************************************************************************
Desc:
****************************************************************************/
RCODE FLMAPI f_numUCS2Chars(
	const FLMBYTE *	pszUTF8,
	FLMUINT *			puiNumChars)
{
	RCODE					rc = NE_FLM_OK;
	FLMUINT				uiTemp = 0;
	FLMUNICODE			uzChar;
	
	for (;;)
	{
		if( RC_BAD( rc = f_getCharFromUTF8Buf( &pszUTF8, NULL, &uzChar)))
		{
			goto Exit;
		}
		
		if (!uzChar)
		{
			break;
		}
		
		uiTemp++;
	}

Exit:

	*puiNumChars = uiTemp;
	return( rc);
}

/****************************************************************************
Desc:	Reads the next character from the storage buffer
****************************************************************************/
RCODE FLMAPI f_getCharFromUTF8Buf(
	const FLMBYTE **		ppucBuf,
	const FLMBYTE *		pucEnd,
	FLMUNICODE *			puChar)
{
	const FLMBYTE *	pucBuf = *ppucBuf;
	FLMUINT				uiMaxLen = pucEnd ? (FLMUINT)(pucEnd - *ppucBuf) : 3;

	if( !uiMaxLen)
	{
		*puChar = 0;
		return( NE_FLM_OK);
	}
	
	if( pucBuf[ 0] <= 0x7F)
	{
		if( (*puChar = (FLMUNICODE)pucBuf[ 0]) != 0)
		{
			(*ppucBuf)++;
		}
		return( NE_FLM_OK);
	}

	if( uiMaxLen < 2 || (pucBuf[ 1] >> 6) != 0x02)
	{
		return( RC_SET( NE_FLM_BAD_UTF8));
	}

	if( (pucBuf[ 0] >> 5) == 0x06)
	{
		*puChar = 
			(FLMUNICODE)(((FLMUNICODE)( pucBuf[ 0] - 0xC0) << 6) +
							(FLMUNICODE)(pucBuf[ 1] - 0x80));
		(*ppucBuf) += 2;
		return( NE_FLM_OK);
	}

	if( uiMaxLen < 3 ||
		 (pucBuf[ 0] >> 4) != 0x0E ||
		 (pucBuf[ 2] >> 6) != 0x02)
	{
		return( RC_SET( NE_FLM_BAD_UTF8));
	}

	*puChar = 
		(FLMUNICODE)(((FLMUNICODE)(pucBuf[ 0] - 0xE0) << 12) +
			((FLMUNICODE)(pucBuf[ 1] - 0x80) << 6) +
						(FLMUNICODE)(pucBuf[ 2] - 0x80));
	(*ppucBuf) += 3;

	return( NE_FLM_OK);
}

/****************************************************************************
Desc: 	Convert a Unicode character to UTF-8
*****************************************************************************/
RCODE FLMAPI f_uni2UTF8(
	FLMUNICODE		uChar,
	FLMBYTE *		pucBuf,
	FLMUINT *		puiBufSize)
{
	if( uChar <= 0x007F)
	{
		if( pucBuf)
		{
			if( *puiBufSize < 1)
			{
				return( RC_SET( NE_FLM_CONV_DEST_OVERFLOW));
			}

			*pucBuf = (FLMBYTE)uChar;
		}
		*puiBufSize = 1;
	}
	else if( uChar <= 0x07FF)
	{
		if( pucBuf)
		{
			if( *puiBufSize < 2)
			{
				return( RC_SET( NE_FLM_CONV_DEST_OVERFLOW));
			}

			*pucBuf++ = (FLMBYTE)(0xC0 | (FLMBYTE)(uChar >> 6));
			*pucBuf = (FLMBYTE)(0x80 | (FLMBYTE)(uChar & 0x003F));
		}
		*puiBufSize = 2;
	}
	else
	{
		if( pucBuf)
		{
			if( *puiBufSize < 3)
			{
				return( RC_SET( NE_FLM_CONV_DEST_OVERFLOW));
			}

			*pucBuf++ = (FLMBYTE)(0xE0 | (FLMBYTE)(uChar >> 12));
			*pucBuf++ = (FLMBYTE)(0x80 | (FLMBYTE)((uChar & 0x0FC0) >> 6));
			*pucBuf = (FLMBYTE)(0x80 | (FLMBYTE)(uChar & 0x003F));
		}
		*puiBufSize = 3;
	}

	return( NE_FLM_OK);
}

/****************************************************************************
Desc:		Reads the next UTF-8 character from a UTF-8 buffer
Notes:	This routine assumes that the destination buffer can hold at least
			three bytes
****************************************************************************/
RCODE FLMAPI f_getUTF8CharFromUTF8Buf(
	FLMBYTE **		ppucBuf,
	FLMBYTE *		pucEnd,
	FLMBYTE *		pucDestBuf,
	FLMUINT *		puiLen)
{
	FLMBYTE *	pucBuf = *ppucBuf;
	FLMUINT		uiMaxLen = pucEnd ? (FLMUINT)(pucEnd - *ppucBuf) : 3;

	if( !uiMaxLen || !pucBuf[ 0])
	{
		*puiLen = 0;
		return( NE_FLM_OK);
	}
	
	if( pucBuf[ 0] <= 0x7F)
	{
		*pucDestBuf = pucBuf[ 0];
		(*ppucBuf)++;
		*puiLen = 1;
		return( NE_FLM_OK);
	}

	if( uiMaxLen < 2 || (pucBuf[ 1] >> 6) != 0x02)
	{
		return( RC_SET( NE_FLM_BAD_UTF8));
	}

	if( (pucBuf[ 0] >> 5) == 0x06)
	{
		pucDestBuf[ 0] = pucBuf[ 0];
		pucDestBuf[ 1] = pucBuf[ 1];
		(*ppucBuf) += 2;
		*puiLen = 2;
		return( NE_FLM_OK);
	}

	if( uiMaxLen < 3 ||
		 (pucBuf[ 0] >> 4) != 0x0E || 
		 (pucBuf[ 2] >> 6) != 0x02)
	{
		return( RC_SET( NE_FLM_BAD_UTF8));
	}

	pucDestBuf[ 0] = pucBuf[ 0];
	pucDestBuf[ 1] = pucBuf[ 1];
	pucDestBuf[ 2] = pucBuf[ 2];
	(*ppucBuf) += 3;
	*puiLen = 3;

	return( NE_FLM_OK);
}

/****************************************************************************
Desc:
****************************************************************************/
RCODE FLMAPI f_getUTF8Length(
	const FLMBYTE *	pucBuf,
	FLMUINT				uiBufLen,
	FLMUINT *			puiBytes,
	FLMUINT *			puiChars)
{
	const FLMBYTE *	pucStart = pucBuf;
	const FLMBYTE *	pucEnd = uiBufLen ? (pucStart + uiBufLen) : NULL;
	FLMUINT				uiChars = 0;

	if (!pucBuf)
	{
		goto Exit;
	}

	while( (!pucEnd || pucBuf < pucEnd) && *pucBuf)
	{
		if( *pucBuf <= 0x7F)
		{
			pucBuf++;
			uiChars++;
			continue;
		}
	
		if( (pucEnd && pucBuf + 1 >= pucEnd) ||
			 (pucBuf[ 1] >> 6) != 0x02)
		{
			return( RC_SET( NE_FLM_BAD_UTF8));
		}
	
		if( ((*pucBuf) >> 5) == 0x06)
		{
			pucBuf += 2;
			uiChars++;
			continue;
		}
	
		if( (pucEnd && pucBuf + 2 >= pucEnd) ||
			 (pucBuf[ 0] >> 4) != 0x0E || 
			 (pucBuf[ 2] >> 6) != 0x02)
		{
			return( RC_SET( NE_FLM_BAD_UTF8));
		}
		
		pucBuf += 3;
		uiChars++;
	}

Exit:

	*puiChars = uiChars;
	if (pucEnd && pucBuf == pucEnd)
	{
		*puiBytes = (FLMUINT)(pucBuf - pucStart);
	}
	else
	{
		// Hit a null byte
		*puiBytes = (FLMUINT)(pucBuf - pucStart) + 1;
	}

	return( NE_FLM_OK);
}

/****************************************************************************
Desc:	Reads the next UTF-8 character from the stream
****************************************************************************/
RCODE FLMAPI f_readUTF8CharAsUnicode(
	IF_IStream *	pIStream,
	FLMUNICODE *	puChar)
{
	RCODE			rc = NE_FLM_OK;
	FLMBYTE		ucBuf[ 3];
	FLMUINT		uiLen;

	uiLen = 1;
	if( RC_BAD( rc = pIStream->read( &ucBuf[ 0], uiLen, &uiLen)))
	{
		goto Exit;
	}

	if( ucBuf[ 0] <= 0x7F)
	{
		if( !ucBuf [0])
		{
			rc = RC_SET( NE_FLM_EOF_HIT);
			goto Exit;
		}
		*puChar = (FLMUNICODE)ucBuf[ 0];
		goto Exit;
	}

	uiLen = 1;
	if( RC_BAD( rc = pIStream->read( &ucBuf[ 1], uiLen, &uiLen)))
	{
		goto Exit;
	}

	if( (ucBuf[ 1] >> 6) != 0x02)
	{
		rc = RC_SET_AND_ASSERT( NE_FLM_BAD_UTF8);
		goto Exit;
	}

	if( (ucBuf[ 0] >> 5) == 0x06)
	{
		*puChar = ((FLMUNICODE)( ucBuf[ 0] - 0xC0) << 6) +
							(FLMUNICODE)(ucBuf[ 1] - 0x80);
		goto Exit;
	}

	uiLen = 1;
	if( RC_BAD( rc = pIStream->read( &ucBuf[ 2], uiLen, &uiLen)))
	{
		goto Exit;
	}

	if( (ucBuf[ 0] >> 4) != 0x0E || (ucBuf[ 2] >> 6) != 0x02)
	{
		rc = RC_SET_AND_ASSERT( NE_FLM_BAD_UTF8);
		goto Exit;
	}

	*puChar = ((FLMUNICODE)(ucBuf[ 0] - 0xE0) << 12) +
						((FLMUNICODE)(ucBuf[ 1] - 0x80) << 6) +
						(FLMUNICODE)(ucBuf[ 2] - 0x80);

Exit:

	if( RC_BAD( rc))
	{
		*puChar = 0;
	}

	return( rc);
}

/****************************************************************************
Desc:		Format text removing leading and trailing spaces.  Treat
			underscores as spaces.  As options, remove all spaces and dashes.
****************************************************************************/
RCODE FLMAPI f_formatUTF8Text(
	IF_PosIStream *	pIStream,
	FLMBOOL				bAllowEscapes,
	FLMUINT				uiCompareRules,
	F_DynaBuf *			pDynaBuf)
{
	RCODE			rc = NE_FLM_OK;
	FLMUINT		uiFirstSpaceCharPos = FLM_MAX_UINT;
	FLMUNICODE	uChar;
	FLMUINT		uiSize;
	FLMUINT		uiStrSize = 0;
	FLMBYTE *	pucTmp;

	if( !pIStream->remainingSize())
	{
		pDynaBuf->truncateData( 0);
		goto Exit;
	}

	for (;;)
	{
		if (RC_BAD( rc = f_readUTF8CharAsUnicode( pIStream, &uChar)))
		{
			if (rc == NE_FLM_EOF_HIT)
			{
				rc = NE_FLM_OK;
				break;
			}
			goto Exit;
		}
		
		if ((uChar = f_convertChar( uChar, uiCompareRules)) == 0)
		{
			continue;
		}

		if (uChar == ASCII_SPACE)
		{
			if (uiCompareRules &
				 (FLM_COMP_COMPRESS_WHITESPACE |
				  FLM_COMP_IGNORE_TRAILING_SPACE))
			{
				
				// Remember the position of the first space.
				// When we come to the end of the spaces, we may reset
				// the size to compress out spaces if necessary.  Or,
				// we may opt to get rid of all of them.

				if (uiFirstSpaceCharPos == FLM_MAX_UINT)
				{
					uiFirstSpaceCharPos = uiStrSize;
				}
			}
		}
		else
		{
			
			// Once we hit a non-space character, we can turn off the
			// ignore leading spaces flag.
			
			uiCompareRules &= (~(FLM_COMP_IGNORE_LEADING_SPACE));
			
			// See if we need to compress spaces.
			
			if (uiFirstSpaceCharPos != FLM_MAX_UINT)
			{
				
				// Output exactly one ASCII_SPACE character if we are compressing
				// spaces.  If we are not compressing spaces, then the only other
				// way uiFirstSpaceCharPos would have been set is if we were
				// ignoring trailing spaces.  In that case, since the spaces
				// were not trailing spaces, we need to leave them as is.
				
				if (uiCompareRules & FLM_COMP_COMPRESS_WHITESPACE)
				{
					
					// A space will already have been encoded into the string.
					// Since we know a space takes exactly one byte in the UTF8
					// space, we can simply set our pointer one byte past where
					// the last non-space character was found.
					
					uiStrSize = uiFirstSpaceCharPos + 1;
					pDynaBuf->truncateData( uiStrSize);
				}
				uiFirstSpaceCharPos = FLM_MAX_UINT;
			}
			
			// If we are allowing escaped characters, backslash is treated
			// always as an escape character.  Whatever follows the
			// backslash is the character we need to process.

			if (uChar == ASCII_BACKSLASH && bAllowEscapes)
			{
				if (RC_BAD( rc = f_readUTF8CharAsUnicode( pIStream, &uChar)))
				{
					if (rc == NE_FLM_EOF_HIT)
					{
						rc = NE_FLM_OK;
					}
					else
					{
						goto Exit;
					}
				}
			}
		}
		
		// Output the character - need at most three bytes
		
		if (RC_BAD( rc = pDynaBuf->allocSpace( 3, (void **)&pucTmp)))
		{
			goto Exit;
		}
		uiSize = 3;
		if (RC_BAD( rc = f_uni2UTF8( uChar, pucTmp, &uiSize)))
		{
			goto Exit;
		}
		uiStrSize += uiSize;
		pDynaBuf->truncateData( uiStrSize);
	}

	// If uiFirstSpaceCharPos != FLM_MAX_UINT, it means that all of the
	// characters at the end of the string were spaces.  If we
	// are ignoring trailing spaces, we need to truncate the string so
	// they will be ignored.  Otherwise, we need to compress them into
	// a single space.
	
	if (uiFirstSpaceCharPos != FLM_MAX_UINT)
	{
		if (uiCompareRules & FLM_COMP_IGNORE_TRAILING_SPACE)
		{
			uiStrSize = uiFirstSpaceCharPos;
		}
		else
		{
			f_assert( uiCompareRules & FLM_COMP_COMPRESS_WHITESPACE);
			
			// A space will already have been encoded into the string.
			// Since we know a space takes exactly one byte in the UTF8
			// space, we can simply set our pointer one byte past where
			// the last non-space character was found.

			uiStrSize = uiFirstSpaceCharPos + 1;
		}
		pDynaBuf->truncateData( uiStrSize);
	}
	
	// Terminate the UTF-8 string
	
	if (RC_BAD( rc = pDynaBuf->appendByte( 0)))
	{
		goto Exit;
	}

Exit:

	return( rc);
}

/****************************************************************************
Desc:
****************************************************************************/
FSTATIC FLMBOOL f_addMetaphone(
	const char *		pszStr,
	const char *		pszAltStr,
	FLMBYTE *			pszMeta,
	FLMUINT *			puiMetaOffset,
	FLMBYTE *			pszAltMeta,
	FLMUINT *			puiAltMetaOffset)
{
	FLMBOOL		bDone = FALSE;

	if( pszStr)
	{
		while( *pszStr)
		{
			if( *puiMetaOffset < 4)
			{
				pszMeta[ (*puiMetaOffset)++] = *pszStr;
			}

			if( !pszAltStr && pszAltMeta && *puiAltMetaOffset < 4)
			{
				pszAltMeta[ (*puiAltMetaOffset)++] = *pszStr;
			}

			if( *puiMetaOffset == 4 && *puiAltMetaOffset == 4)
			{
				bDone = TRUE;
				break;
			}

			pszStr++;
		}
	}

	if( pszAltStr)
	{
		while( *pszAltStr)
		{
			if( *puiAltMetaOffset < 4)
			{
				pszAltMeta[ (*puiAltMetaOffset)++] = *pszAltStr;
			}

			if( *puiMetaOffset == 4 && *puiAltMetaOffset == 4)
			{
				bDone = TRUE;
				break;
			}

			pszAltStr++;
		}
	}

	return( bDone);
}

/****************************************************************************
Desc:
****************************************************************************/
FSTATIC void f_metaStrToNum(
	FLMBYTE *		pszMeta,
	FLMUINT *		puiMeta)
{
	FLMUINT		uiMeta = 0;
	FLMUINT		uiOffset = 0;

	for( ;;)
	{
		if( *pszMeta)
		{
			switch( *pszMeta)
			{
				case '0':
					break;
				case 'A':
					uiMeta += 1;
					break;
				case 'F':
					uiMeta += 2;
					break;
				case 'H':
					uiMeta += 3;
					break;
				case 'J':
					uiMeta += 4;
					break;
				case 'K':
					uiMeta += 5;
					break;
				case 'L':
					uiMeta += 6;
					break;
				case 'M':
					uiMeta += 7;
					break;
				case 'N':
					uiMeta += 8;
					break;
				case 'P':
					uiMeta += 9;
					break;
				case 'R':
					uiMeta += 10;
					break;
				case 'S':
					uiMeta += 11;
					break;
				case 'T':
					uiMeta += 12;
					break;
				case 'X':
					uiMeta += 13;
					break;
				default:
					f_assert( 0);
			}

			pszMeta++;
		}

		if( ++uiOffset == 4)
		{
			f_assert( *pszMeta == 0);
			break;
		}
		uiMeta <<= 4;
	}

	*puiMeta = uiMeta;
}

/****************************************************************************
Desc:		Generate the metaphone and alternate metaphone keys for a given
			input string
Notes:	Lawrence Philips' Metaphone Algorithm is an algorithm which returns
			the rough approximation of how an English word sounds.  Rather
			than returning the character representation of the encoded word,
			this routine returns a 16-bit numeric representation.
****************************************************************************/
RCODE FLMAPI f_getNextMetaphone(
	IF_IStream *	pIStream,
	FLMUINT *		puiMetaphone,
	FLMUINT *		puiAltMetaphone)
{
	RCODE				rc = NE_FLM_OK;
	FLMUINT			uiInputOffset = 0;
	FLMUINT			uiInputLen = 0;
	FLMUINT			uiLast;
	FLMUINT			uiLoop;
	FLMUINT			uiMetaOffset = 0;
	FLMUINT			uiAltMetaOffset = 0;
	FLMBOOL			bSlavoGermanic = FALSE;
	FLMBOOL			bHavePrefix = FALSE;
#define MAX_METAPHONE_INPUT_CHARS		32
	FLMUNICODE		uzRealInputBuffer[ MAX_METAPHONE_INPUT_CHARS + 6];
	FLMUNICODE *	uzInput = &uzRealInputBuffer [5];
	FLMUNICODE		uChar;
	FLMBYTE			ucMeta[ 5];
	FLMBYTE			ucAltMeta[ 5];

	// Tack on five extra spaces at the beginning of the real buffer, so that we
	// can safely access characters before the beginning of the string:
	// i.e., the uzInput [uiInputLen - n] comparisons.  NOTE: n never
	// gets to be more than 5.

	for( uiLoop = 0; uiLoop < 5; uiLoop++)
	{
		uzRealInputBuffer [uiLoop] = FLM_UNICODE_SPACE;
	}

	*puiMetaphone = 0;

	if( puiAltMetaphone)
	{
		*puiAltMetaphone = 0;
	}

	// Get the first word from the stream

	for( ;;)
	{
		if( RC_BAD( rc = f_readUTF8CharAsUnicode( 
			pIStream, &uChar)))
		{
			if (rc == NE_FLM_EOF_HIT)
			{
				if( uiInputLen)
				{
					rc = NE_FLM_OK;
					break;
				}
			}

			goto Exit;
		}

		if( f_isWhitespace( uChar))
		{
			if( !uiInputLen)
			{
				continue;
			}
			else
			{
				// Handle the special cases of "san ", "van ", "von ",
				// and "mac ".  Since these are common name prefixes 
				// handled by the metaphone algorithm, we want to continue
				// getting the rest of the name.

				if( !bHavePrefix && uiInputLen == 3 &&
					 (f_uninativencmp( uzInput, "san", 3) == 0 ||
					  f_uninativencmp( uzInput, "van", 3) == 0 ||
					  f_uninativencmp( uzInput, "von", 3) == 0 ||
					  f_uninativencmp( uzInput, "mac", 3) == 0))
				{
					uzInput[ uiInputLen++] = FLM_UNICODE_SPACE;
					bHavePrefix = TRUE;
					continue;
				}
				else
				{
					if( bHavePrefix && uiInputLen == 4)
					{
						// Since there wasn't anything following the "prefix",
						// the trailing space needs to be removed

						uiInputLen--;
					}
					break;
				}
			}
		}

		if( uiInputLen < (MAX_METAPHONE_INPUT_CHARS - 5))
		{
			uzInput[ uiInputLen++] = f_uniToLower( uChar);

			if( !bSlavoGermanic &&
				 (uChar == FLM_UNICODE_w ||
				  uChar == FLM_UNICODE_k ||
				  (uiInputLen > 1 && uChar == FLM_UNICODE_z && 
					uzInput[ uiInputLen - 2] == FLM_UNICODE_c) ||
				  (uiInputLen >= 4 && uChar == FLM_UNICODE_z &&
					uzInput[ uiInputLen - 2] == FLM_UNICODE_t &&
					uzInput[ uiInputLen - 3] == FLM_UNICODE_i &&
					uzInput[ uiInputLen - 4] == FLM_UNICODE_w)))
			{
				bSlavoGermanic = TRUE;
			}
		}
	}

	// Tack on five extra spaces to the end of the string so that
	// the algorithm below can access characters beyond the end safely.

	for( uiLoop = 0; uiLoop < 5; uiLoop++)
	{
		uzInput[ uiInputLen + uiLoop] = FLM_UNICODE_SPACE;
	}

	uzInput[ uiInputLen + 5] = 0;
	uiLast = uiInputLen - 1;

	// Skip the first letter of the following sequences when
	// they are found at the beginning of the word

	if( f_uninativencmp( &uzInput[ uiInputOffset], "gn", 2) == 0 ||
		f_uninativencmp( &uzInput[ uiInputOffset], "kn", 2) == 0 ||
		f_uninativencmp( &uzInput[ uiInputOffset], "pn", 2) == 0 ||
		f_uninativencmp( &uzInput[ uiInputOffset], "wr", 2) == 0 ||
		f_uninativencmp( &uzInput[ uiInputOffset], "ps", 2) == 0)
	{
		uiInputOffset++;
	}
	else if( uzInput[ uiInputOffset] == FLM_UNICODE_x)
	{
		// An initial 'X' is pronounced as a 'Z' which maps to 'S'

		if( f_addMetaphone( "S", NULL, ucMeta, &uiMetaOffset, 
			ucAltMeta, &uiAltMetaOffset))
		{
			goto Done;
		}

		uiInputOffset++;
	}

	while( uiMetaOffset < 4 || uiAltMetaOffset < 4)
	{
		if( uiInputOffset >= uiInputLen)
		{
			break;
		}

		switch( uzInput[ uiInputOffset])
		{
			case FLM_UNICODE_a:
			case FLM_UNICODE_e:
			case FLM_UNICODE_i:
			case FLM_UNICODE_o:
			case FLM_UNICODE_u:
			case FLM_UNICODE_y:
			{
				if( !uiInputOffset)
				{
					// All initial vowels map to 'A'

					if( f_addMetaphone( "A", NULL, ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}
				}

				uiInputOffset++;
				break;
			}
               
			case FLM_UNICODE_b:
			{
				//"-mb", e.g", "dumb", already skipped over...

				if( f_addMetaphone( "P", NULL, ucMeta, &uiMetaOffset, 
					ucAltMeta, &uiAltMetaOffset))
				{
					goto Done;
				}

				if( uzInput[ uiInputOffset + 1] == FLM_UNICODE_b)
				{
					uiInputOffset += 2;
				}
				else
				{
					uiInputOffset++;
				}
				break;
			}

			case FLM_UNICODE_c_CEDILLA:
			{
				if( f_addMetaphone( "S", NULL, ucMeta, &uiMetaOffset, 
					ucAltMeta, &uiAltMetaOffset))
				{
					goto Done;
				}

				uiInputOffset++;
				break;
			}

			case FLM_UNICODE_c:
			{
				// Various Germanic

				if( uiInputOffset && !f_isvowel( uzInput[ uiInputOffset - 2]) &&
					f_uninativencmp( &uzInput[ uiInputOffset], "ach", 3) == 0 &&
					((f_uninativencmp( &uzInput[ uiInputOffset + 2], "i", 1) != 0) && 
					((f_uninativencmp( &uzInput[ uiInputOffset + 2], "e", 1) != 0) ||
					f_uninativencmp( &uzInput[ uiInputOffset - 2], "bacher", 6) == 0 ||
					f_uninativencmp( &uzInput[ uiInputOffset - 2], "macher", 6) == 0)))
				{       
					if( f_addMetaphone( "K", NULL, ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}

					uiInputOffset += 2;
					break;
				}

				// Special case of "caesar"

				if( !uiInputOffset && 
					f_uninativencmp( &uzInput[ uiInputOffset], "caesar", 6) == 0)
				{
					if( f_addMetaphone( "S", NULL, ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}

					uiInputOffset +=2;
					break;
				}

				// Italian "chianti"

				if( f_uninativencmp( &uzInput[ uiInputOffset], "chia", 4) == 0)
				{
					if( f_addMetaphone( "K", NULL, ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}

					uiInputOffset += 2;
					break;
				}

				if( f_uninativencmp( &uzInput[ uiInputOffset], "ch", 2) == 0)
            {       
					// Handle case of "Michael"

					if( uiInputOffset && 
						f_uninativencmp( &uzInput[ uiInputOffset], "chae", 4) == 0)
					{
						if( f_addMetaphone( "K", "X", ucMeta, &uiMetaOffset, 
							ucAltMeta, &uiAltMetaOffset))
						{
							goto Done;
						}

						uiInputOffset +=2;
						break;
					}

					// Greek roots such as "chemistry" and "chorus"

					if( !uiInputOffset && 
						(f_uninativencmp( &uzInput[ uiInputOffset + 1], "harac", 5) == 0 ||
						 f_uninativencmp( &uzInput[ uiInputOffset + 1], "haris", 5) == 0 ||
						 f_uninativencmp( &uzInput[ uiInputOffset + 1], "hor", 3) == 0 ||
						 f_uninativencmp( &uzInput[ uiInputOffset + 1], "hym", 3) == 0 ||
						 f_uninativencmp( &uzInput[ uiInputOffset + 1], "hia", 3) == 0 ||
						 f_uninativencmp( &uzInput[ uiInputOffset + 1], "hem", 3) == 0) &&
						f_uninativencmp( &uzInput[ uiInputOffset + 1], "chore", 5) != 0)
					{
						if( f_addMetaphone( "K", NULL, ucMeta, &uiMetaOffset, 
							ucAltMeta, &uiAltMetaOffset))
						{
							goto Done;
						}

						uiInputOffset += 2;
						break;
					}

					// Germanic, Greek 'CH' -> 'KH'

					if( f_uninativencmp( &uzInput[ 0], "van ", 4) == 0 ||
						 f_uninativencmp( &uzInput[ 0], "von ", 4) == 0 ||
						 f_uninativencmp( &uzInput[ 0], "sch", 3) == 0 ||
						 f_uninativencmp( &uzInput[ uiInputOffset - 2], "orches", 6) == 0 ||
						 f_uninativencmp( &uzInput[ uiInputOffset - 2], "archit", 6) == 0 ||
						 f_uninativencmp( &uzInput[ uiInputOffset - 2], "orchid", 6) == 0 ||
						 uzInput[ uiInputOffset + 2] == FLM_UNICODE_t ||
						 uzInput[ uiInputOffset + 2] == FLM_UNICODE_s ||
						 ((uzInput[ uiInputOffset - 1] == FLM_UNICODE_a ||
						   uzInput[ uiInputOffset - 1] == FLM_UNICODE_o ||
						   uzInput[ uiInputOffset - 1] == FLM_UNICODE_u ||
						   uzInput[ uiInputOffset - 1] == FLM_UNICODE_e ||
						   !uiInputOffset) &&
						  (uzInput[ uiInputOffset + 2] == FLM_UNICODE_l ||
						   uzInput[ uiInputOffset + 2] == FLM_UNICODE_r ||
						   uzInput[ uiInputOffset + 2] == FLM_UNICODE_n ||
						   uzInput[ uiInputOffset + 2] == FLM_UNICODE_m ||
						   uzInput[ uiInputOffset + 2] == FLM_UNICODE_b ||
						   uzInput[ uiInputOffset + 2] == FLM_UNICODE_h ||
						   uzInput[ uiInputOffset + 2] == FLM_UNICODE_f ||
						   uzInput[ uiInputOffset + 2] == FLM_UNICODE_v ||
						   uzInput[ uiInputOffset + 2] == FLM_UNICODE_w ||
						   uzInput[ uiInputOffset + 2] == FLM_UNICODE_SPACE)))
					{
						if( f_addMetaphone( "K", NULL, ucMeta, &uiMetaOffset, 
							ucAltMeta, &uiAltMetaOffset))
						{
							goto Done;
						}
					}
					else
					{  
						if( uiInputOffset)
						{
							if( f_uninativencmp( &uzInput[ 0], "mc", 2) == 0)
							{
								// Names such as "McHugh"

								if( f_addMetaphone( "K", NULL, ucMeta, &uiMetaOffset, 
									ucAltMeta, &uiAltMetaOffset))
								{
									goto Done;
								}
							}
							else
							{
								if( f_addMetaphone( "X", "K", ucMeta, &uiMetaOffset, 
									ucAltMeta, &uiAltMetaOffset))
								{
									goto Done;
								}
							}
						}
						else
						{
							if( f_addMetaphone( "X", NULL, ucMeta, &uiMetaOffset, 
								ucAltMeta, &uiAltMetaOffset))
							{
								goto Done;
							}
						}
					}

					uiInputOffset += 2;
					break;
				}

				// "czerny"

				if( f_uninativencmp( &uzInput[ uiInputOffset], "cz", 2) == 0 &&
					f_uninativencmp( &uzInput[ uiInputOffset - 2], "wicz", 4) != 0)
				{
					if( f_addMetaphone( "S", "X", ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}

					uiInputOffset += 2;
					break;
				}

				if( f_uninativencmp( &uzInput[ uiInputOffset + 1], "cia", 3) == 0)
				{
					// Words such as "focaccia"

					if( f_addMetaphone( "X", NULL, ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}

					uiInputOffset += 3;
					break;
				}

				// Double 'C', but not if in a name such as "McClellan"

				if( f_uninativencmp( &uzInput[ uiInputOffset], "cc", 2) == 0 &&
					!(uiInputOffset == 1 && uzInput[ 0] == FLM_UNICODE_m))
				{
					// "bellocchio" but not "bacchus"

					if( (uzInput[ uiInputOffset + 2] == FLM_UNICODE_i ||
						  uzInput[ uiInputOffset + 2] == FLM_UNICODE_e ||
						  uzInput[ uiInputOffset + 2] == FLM_UNICODE_h) &&
						 f_uninativencmp( &uzInput[ uiInputOffset + 2], "hu", 2) != 0)
					{
						// "accident", "accede", "succeed"

						if( (uiInputOffset == 1 && 
							 uzInput[ uiInputOffset - 1] == FLM_UNICODE_a) ||
							 f_uninativencmp( &uzInput[ uiInputOffset - 1], "uccee", 5) == 0 ||
							 f_uninativencmp( &uzInput[ uiInputOffset - 1], "ucces", 5) == 0)
						{
							if( f_addMetaphone( "KS", NULL, ucMeta, &uiMetaOffset, 
								ucAltMeta, &uiAltMetaOffset))
							{
								goto Done;
							}
						}
						else
						{
							// "bacci", "bertucci", and other Italian words

							if( f_addMetaphone( "X", NULL, ucMeta, &uiMetaOffset, 
								ucAltMeta, &uiAltMetaOffset))
							{
								goto Done;
							}
						}
						uiInputOffset += 3;
						break;
					}
					else
					{
						// Pierce's rule

						if( f_addMetaphone( "K", NULL, ucMeta, &uiMetaOffset, 
							ucAltMeta, &uiAltMetaOffset))
						{
							goto Done;
						}

						uiInputOffset += 2;
						break;
					}
				}

				if( f_uninativencmp( &uzInput[ uiInputOffset], "ck", 2) == 0 ||
					 f_uninativencmp( &uzInput[ uiInputOffset], "cg", 2) == 0 || 
					 f_uninativencmp( &uzInput[ uiInputOffset], "cq", 2) == 0)
				{
					if( f_addMetaphone( "K", NULL, ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}

					uiInputOffset += 2;
					break;
				}

				if( f_uninativencmp( &uzInput[ uiInputOffset], "ci", 2) == 0 ||
					 f_uninativencmp( &uzInput[ uiInputOffset], "ce", 2) == 0 || 
					 f_uninativencmp( &uzInput[ uiInputOffset], "cy", 2) == 0)
				{
					// Italian vs. English

					if( f_uninativencmp( &uzInput[ uiInputOffset], "cio", 3) == 0 || 
						 f_uninativencmp( &uzInput[ uiInputOffset], "cie", 3) == 0 || 
						 f_uninativencmp( &uzInput[ uiInputOffset], "cia", 3) == 0)
					{
						if( f_addMetaphone( "S", "X", ucMeta, &uiMetaOffset, 
							ucAltMeta, &uiAltMetaOffset))
						{
							goto Done;
						}
					}
					else
					{
						if( f_addMetaphone( "S", NULL, ucMeta, &uiMetaOffset, 
							ucAltMeta, &uiAltMetaOffset))
						{
							goto Done;
						}
					}

					uiInputOffset += 2;
					break;
				}

				// else

				if( f_addMetaphone( "K", NULL, ucMeta, &uiMetaOffset, 
					ucAltMeta, &uiAltMetaOffset))
				{
					goto Done;
				}
                       
				// Name such as "Mac Caffrey", "Mac Gregor"

				if( f_uninativencmp( &uzInput[ uiInputOffset + 1], " c", 2) == 0 ||
					 f_uninativencmp( &uzInput[ uiInputOffset + 1], " q", 2) == 0 ||
					 f_uninativencmp( &uzInput[ uiInputOffset + 1], " g", 2) == 0)
				{
					uiInputOffset += 3;
				}
				else
				{
					if( (uzInput[ uiInputOffset + 1] == FLM_UNICODE_c ||
						  uzInput[ uiInputOffset + 1] == FLM_UNICODE_k ||	
						  uzInput[ uiInputOffset + 1] == FLM_UNICODE_q) &&
						 !(f_uninativencmp( &uzInput[ uiInputOffset + 1], "ce", 2) == 0 ||
						  f_uninativencmp( &uzInput[ uiInputOffset + 1], "ci", 2) == 0))
					{
						uiInputOffset += 2;
					}
					else
					{
						uiInputOffset += 1;
					}
				}

				break;
			}

			case FLM_UNICODE_d:
			{
				if( f_uninativencmp( &uzInput[ uiInputOffset], "dg", 2) == 0)
				{
					if( uzInput[ uiInputOffset + 2] == FLM_UNICODE_i ||
						 uzInput[ uiInputOffset + 2] == FLM_UNICODE_e ||
						 uzInput[ uiInputOffset + 2] == FLM_UNICODE_y)
					{
						// "edge"

						if( f_addMetaphone( "J", NULL, ucMeta, &uiMetaOffset, 
							ucAltMeta, &uiAltMetaOffset))
						{
							goto Done;
						}

						uiInputOffset += 3;
						break;
					}
					else
					{
						// "edgar"

						if( f_addMetaphone( "TK", NULL, ucMeta, &uiMetaOffset, 
							ucAltMeta, &uiAltMetaOffset))
						{
							goto Done;
						}

						uiInputOffset += 2;
						break;
					}
				}

				if( f_uninativencmp( &uzInput[ uiInputOffset], "dt", 2) == 0 ||
					 f_uninativencmp( &uzInput[ uiInputOffset], "dd", 2) == 0)
				{
					if( f_addMetaphone( "T", NULL, ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}

					uiInputOffset += 2;
					break;
				}
                    
				// else

				if( f_addMetaphone( "T", NULL, ucMeta, &uiMetaOffset, 
					ucAltMeta, &uiAltMetaOffset))
				{
					goto Done;
				}

				uiInputOffset++;
				break;
			}

			case FLM_UNICODE_f:
			{
				if( uzInput[ uiInputOffset + 1] == FLM_UNICODE_f)
				{
					uiInputOffset += 2;
				}
				else
				{
					uiInputOffset += 1;
				}

				if( f_addMetaphone( "F", NULL, ucMeta, &uiMetaOffset, 
					ucAltMeta, &uiAltMetaOffset))
				{
					goto Done;
				}

				break;
			}

			case FLM_UNICODE_g:
			{
				if( uzInput[ uiInputOffset + 1] == FLM_UNICODE_h)
				{
					if( uiInputOffset > 0 && 
						!f_isvowel( uzInput[ uiInputOffset - 1]))
					{
						if( f_addMetaphone( "K", NULL, ucMeta, &uiMetaOffset, 
							ucAltMeta, &uiAltMetaOffset))
						{
							goto Done;
						}

						uiInputOffset += 2;
						break;
					}

					if( uiInputOffset < 3)
					{
						// "ghislane", "ghiradelli"

						if( !uiInputOffset)
						{ 
							if( uzInput[ uiInputOffset + 2] == FLM_UNICODE_i)
							{
								if( f_addMetaphone( "J", NULL, ucMeta, &uiMetaOffset, 
									ucAltMeta, &uiAltMetaOffset))
								{
									goto Done;
								}
							}
							else
							{
								if( f_addMetaphone( "K", NULL, ucMeta, &uiMetaOffset, 
									ucAltMeta, &uiAltMetaOffset))
								{
									goto Done;
								}
							}
							uiInputOffset += 2;
							break;
						}
					}

					// Parker's rule (with some further refinements) - "hugh"

					if( (uiInputOffset && 
						  (uzInput[ uiInputOffset - 2] == FLM_UNICODE_b ||
							uzInput[ uiInputOffset - 2] == FLM_UNICODE_h ||
							uzInput[ uiInputOffset - 2] == FLM_UNICODE_d)) ||
						 (uiInputOffset > 2 && // "bough"
						  (uzInput[ uiInputOffset - 3] == FLM_UNICODE_b ||
							uzInput[ uiInputOffset - 3] == FLM_UNICODE_h ||
							uzInput[ uiInputOffset - 3] == FLM_UNICODE_d)) ||
						 (uiInputOffset > 3 && // "broughton"
						  (uzInput[ uiInputOffset - 4] == FLM_UNICODE_b ||
							uzInput[ uiInputOffset - 4] == FLM_UNICODE_h)))
					{
						uiInputOffset += 2;
						break;
					}
					else
					{
						// "laugh", "McLaughlin", "cough", "gough", "rough", "tough"

						if( uiInputOffset > 2 && 
							 uzInput[ uiInputOffset - 1] == FLM_UNICODE_u &&
							 (uzInput[ uiInputOffset - 3] == FLM_UNICODE_c ||
							  uzInput[ uiInputOffset - 3] == FLM_UNICODE_g ||
							  uzInput[ uiInputOffset - 3] == FLM_UNICODE_l ||
							  uzInput[ uiInputOffset - 3] == FLM_UNICODE_r ||
							  uzInput[ uiInputOffset - 3] == FLM_UNICODE_t))
						{
							if( f_addMetaphone( "F", NULL, ucMeta, &uiMetaOffset, 
								ucAltMeta, &uiAltMetaOffset))
							{
								goto Done;
							}
						}
						else if( uiInputOffset && uzInput[ uiInputOffset - 1] != FLM_UNICODE_i)
						{
							if( f_addMetaphone( "K", NULL, ucMeta, &uiMetaOffset, 
								ucAltMeta, &uiAltMetaOffset))
							{
								goto Done;
							}
						}

						uiInputOffset += 2;
						break;
					}
				}

				if( uzInput[ uiInputOffset + 1] == FLM_UNICODE_n)
				{
					if( uiInputOffset == 1 && f_isvowel( uzInput[ 0]) && 
						!bSlavoGermanic)
					{
						if( f_addMetaphone( "KN", "N", ucMeta, &uiMetaOffset, 
							ucAltMeta, &uiAltMetaOffset))
						{
							goto Done;
						}
					}
					else
					{
						// Not "cagney", etc.

						if( f_uninativencmp( &uzInput[ uiInputOffset + 2], "ey", 2) != 0 && 
							uzInput[ uiInputOffset + 1] != FLM_UNICODE_y && 
							!bSlavoGermanic)
						{
							if( f_addMetaphone( "N", "KN", ucMeta, &uiMetaOffset, 
								ucAltMeta, &uiAltMetaOffset))
							{
								goto Done;
							}
						}
						else
						{
							if( f_addMetaphone( "KN", NULL, ucMeta, &uiMetaOffset, 
								ucAltMeta, &uiAltMetaOffset))
							{
								goto Done;
							}
						}
					}

					uiInputOffset += 2;
					break;
				}

				// "tagliaro"

				if( f_uninativencmp( &uzInput[ uiInputOffset + 1], "li", 2) == 0 &&
					!bSlavoGermanic)
				{
					if( f_addMetaphone( "KL", "L", ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}

					uiInputOffset += 2;
					break;
				}

				// Words starting with "ges", "gep", "gel", "gie", etc.

				if( !uiInputOffset && 
					(uzInput[ uiInputOffset + 1] == FLM_UNICODE_y ||
					 f_uninativencmp( &uzInput[ uiInputOffset + 1], "es", 2) == 0 ||
					 f_uninativencmp( &uzInput[ uiInputOffset + 1], "ep", 2) == 0 ||
					 f_uninativencmp( &uzInput[ uiInputOffset + 1], "eb", 2) == 0 ||
					 f_uninativencmp( &uzInput[ uiInputOffset + 1], "el", 2) == 0 ||
					 f_uninativencmp( &uzInput[ uiInputOffset + 1], "ey", 2) == 0 ||
					 f_uninativencmp( &uzInput[ uiInputOffset + 1], "ib", 2) == 0 ||
					 f_uninativencmp( &uzInput[ uiInputOffset + 1], "il", 2) == 0 ||
					 f_uninativencmp( &uzInput[ uiInputOffset + 1], "in", 2) == 0 ||
					 f_uninativencmp( &uzInput[ uiInputOffset + 1], "ie", 2) == 0 ||
					 f_uninativencmp( &uzInput[ uiInputOffset + 1], "ei", 2) == 0 ||
					 f_uninativencmp( &uzInput[ uiInputOffset + 1], "er", 2) == 0))
				{
					if( f_addMetaphone( "K", "J", ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}

					uiInputOffset += 2;
					break;
				}

				// -ger-,  -gy-

				if( (f_uninativencmp( &uzInput[ uiInputOffset + 1], "er", 2) == 0 ||
					  uzInput[ uiInputOffset + 1] == FLM_UNICODE_y) &&
					 !(f_uninativencmp( &uzInput[ 0], "danger", 6) == 0 ||
						f_uninativencmp( &uzInput[ 0], "ranger", 6) == 0 ||
						f_uninativencmp( &uzInput[ 0], "manger", 6) == 0) &&
					 !(uzInput[ uiInputOffset - 1] == FLM_UNICODE_e ||
						uzInput[ uiInputOffset - 1] == FLM_UNICODE_i) &&
					 !(f_uninativencmp( &uzInput[ uiInputOffset - 1], "rgy", 3) == 0 ||
						f_uninativencmp( &uzInput[ uiInputOffset - 1], "ogy", 3) == 0))
				{
					if( f_addMetaphone( "K", "J", ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}

					uiInputOffset += 2;
					break;
				}

				// Italian words such as "biaggi"

				if( uzInput[ uiInputOffset + 1] == FLM_UNICODE_e ||
					 uzInput[ uiInputOffset + 1] == FLM_UNICODE_i ||
					 uzInput[ uiInputOffset + 1] == FLM_UNICODE_y ||
					 f_uninativencmp( &uzInput[ uiInputOffset - 1], "aggi", 4) == 0 ||
					 f_uninativencmp( &uzInput[ uiInputOffset - 1], "oggi", 4) == 0)
				{
					// Obvious Germanic

					if( f_uninativencmp( &uzInput[ 0], "van ", 4) == 0 ||
						 f_uninativencmp( &uzInput[ 0], "von ", 4) == 0 ||
						 f_uninativencmp( &uzInput[ 0], "sch", 3) == 0 ||
						 f_uninativencmp( &uzInput[ uiInputOffset + 1], "et", 2) == 0)
					{
						if( f_addMetaphone( "K", NULL, ucMeta, &uiMetaOffset, 
							ucAltMeta, &uiAltMetaOffset))
						{
							goto Done;
						}
					}
					else
					{
						// Always soft if French ending

						if( f_uninativencmp( &uzInput[ uiInputOffset + 1], "ier ", 4) == 0)
						{
							if( f_addMetaphone( "J", NULL, ucMeta, &uiMetaOffset, 
								ucAltMeta, &uiAltMetaOffset))
							{
								goto Done;
							}
						}
						else
						{
							if( f_addMetaphone( "J", "K", ucMeta, &uiMetaOffset, 
								ucAltMeta, &uiAltMetaOffset))
							{
								goto Done;
							}
						}
						uiInputOffset += 2;
						break;
					}
				}

				if( uzInput[ uiInputOffset + 1] == FLM_UNICODE_g)
				{
					uiInputOffset += 2;
				}
				else
				{
					uiInputOffset += 1;
				}

				if( f_addMetaphone( "K", NULL, ucMeta, &uiMetaOffset, 
					ucAltMeta, &uiAltMetaOffset))
				{
					goto Done;
				}

				break;
			}

			case FLM_UNICODE_h:
			{
				// Only keep if first and if before a vowel or between two vowels

				if( (!uiInputOffset || f_isvowel( uzInput[ uiInputOffset - 1])) &&
					f_isvowel( uzInput[ uiInputOffset + 1]))
				{
					if( f_addMetaphone( "H", NULL, ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}

					uiInputOffset += 2;
				}
				else
				{
					// Take care of "HH"

					uiInputOffset++;
				}
				break;
			}

			case FLM_UNICODE_j:
			{
				// Obvious Spanish such as "Jose" and "San Jacinto"

				if( f_uninativencmp( &uzInput[ uiInputOffset], "jose", 4) == 0 ||
					f_uninativencmp( &uzInput[ 0], "san ", 4) == 0)
				{
					if( (!uiInputOffset && uzInput[ uiInputOffset + 4] == FLM_UNICODE_SPACE) ||
						f_uninativencmp( &uzInput[ 0], "san ", 4) == 0)
					{
						if( f_addMetaphone( "H", NULL, ucMeta, &uiMetaOffset, 
							ucAltMeta, &uiAltMetaOffset))
						{
							goto Done;
						}
					}
					else
					{
						if( f_addMetaphone( "J", "H", ucMeta, &uiMetaOffset, 
							ucAltMeta, &uiAltMetaOffset))
						{
							goto Done;
						}
					}
					uiInputOffset++;
					break;
				}

				if( !uiInputOffset && 
					f_uninativencmp( &uzInput[ uiInputOffset], "jose", 4) != 0)
				{
					// Yankelovich / Jankelowicz

					if( f_addMetaphone( "J", "A", ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}
				}
				else
				{
					// Spanish pronunciation of words such as "bajador"

					if( f_isvowel( uzInput[ uiInputOffset - 1]) && 
						!bSlavoGermanic && 
						  (uzInput[ uiInputOffset + 1] == FLM_UNICODE_a || 
							uzInput[ uiInputOffset + 1] == FLM_UNICODE_o))
					{
						if( f_addMetaphone( "J", "H", ucMeta, &uiMetaOffset, 
							ucAltMeta, &uiAltMetaOffset))
						{
							goto Done;
						}
					}
					else
					{
						if( uiInputOffset == uiLast)
						{
							if( f_addMetaphone( "J", NULL, ucMeta, &uiMetaOffset, 
								NULL, &uiAltMetaOffset))
							{
								goto Done;
							}
						}
						else
						{
							if( uzInput[ uiInputOffset + 1] != FLM_UNICODE_l &&
								 uzInput[ uiInputOffset + 1] != FLM_UNICODE_t &&
								 uzInput[ uiInputOffset + 1] != FLM_UNICODE_k &&
								 uzInput[ uiInputOffset + 1] != FLM_UNICODE_s &&
								 uzInput[ uiInputOffset + 1] != FLM_UNICODE_n &&
								 uzInput[ uiInputOffset + 1] != FLM_UNICODE_m &&
								 uzInput[ uiInputOffset + 1] != FLM_UNICODE_b &&
								 uzInput[ uiInputOffset + 1] != FLM_UNICODE_z &&
								 uzInput[ uiInputOffset - 1] != FLM_UNICODE_s &&
								 uzInput[ uiInputOffset - 1] != FLM_UNICODE_k &&
								 uzInput[ uiInputOffset - 1] != FLM_UNICODE_l)
							{
								if( f_addMetaphone( "J", NULL, ucMeta, &uiMetaOffset, 
									ucAltMeta, &uiAltMetaOffset))
								{
									goto Done;
								}
							}
						}
					}
				}

				if( uzInput[ uiInputOffset + 1] == FLM_UNICODE_j)
				{
					uiInputOffset += 2;
				}
				else
				{
					uiInputOffset++;
				}
				break;
			}

			case FLM_UNICODE_k:
			{
				if( uzInput[ uiInputOffset + 1] == FLM_UNICODE_k)
				{
					uiInputOffset += 2;
				}
				else
				{
					uiInputOffset++;
				}

				if( f_addMetaphone( "K", NULL, ucMeta, &uiMetaOffset, 
					ucAltMeta, &uiAltMetaOffset))
				{
					goto Done;
				}
				break;
			}

			case FLM_UNICODE_l:
			{
				if( uzInput[ uiInputOffset + 1] == FLM_UNICODE_l)
				{
					// Spanish words such as "cabrillo" and "gallegos"

					if( (uiInputOffset == (uiInputLen - 3) && 
							(f_uninativencmp( &uzInput[ uiInputOffset - 1], "illo", 4) == 0 ||
							 f_uninativencmp( &uzInput[ uiInputOffset - 1], "illa", 4) == 0 ||
							 f_uninativencmp( &uzInput[ uiInputOffset - 1], "alle", 4) == 0)) ||
						 ((f_uninativencmp( &uzInput[ uiLast - 1], "as", 2) == 0 ||
						   f_uninativencmp( &uzInput[ uiLast - 1], "os", 2) == 0 ||
							uzInput[ uiLast] == FLM_UNICODE_a ||
							uzInput[ uiLast] == FLM_UNICODE_o) &&
						  f_uninativencmp( &uzInput[ uiInputOffset - 1], "alle", 4) == 0))
					{
						if( f_addMetaphone( "L", NULL, ucMeta, &uiMetaOffset, 
							NULL, &uiAltMetaOffset))
						{
							goto Done;
						}

						uiInputOffset += 2;
						break;
					}
					uiInputOffset += 2;
				}
				else
				{
					uiInputOffset++;
				}

				if( f_addMetaphone( "L", NULL, ucMeta, &uiMetaOffset, 
					ucAltMeta, &uiAltMetaOffset))
				{
					goto Done;
				}

				break;
			}

			case FLM_UNICODE_m:
			{
				if( (f_uninativencmp( &uzInput[ uiInputOffset - 1], "umb", 3) == 0 &&
						((uiInputOffset + 1) == uiLast || 
							f_uninativencmp( &uzInput[ uiInputOffset + 2], "er", 2) == 0)) ||
					uzInput[ uiInputOffset + 1] == FLM_UNICODE_m)	// "dumb", "thumb", etc.
				{
					uiInputOffset += 2;
				}
				else
				{
					uiInputOffset++;
				}

				if( f_addMetaphone( "M", NULL, ucMeta, &uiMetaOffset, 
					ucAltMeta, &uiAltMetaOffset))
				{
					goto Done;
				}

				break;
			}

			case FLM_UNICODE_n:
			{
				if( uzInput[ uiInputOffset + 1] == FLM_UNICODE_n)
				{
					uiInputOffset += 2;
				}
				else
				{
					uiInputOffset++;
				}

				if( f_addMetaphone( "N", NULL, ucMeta, &uiMetaOffset, 
					ucAltMeta, &uiAltMetaOffset))
				{
					goto Done;
				}

				break;
			}

			case FLM_UNICODE_n_TILDE:
			{
				if( f_addMetaphone( "N", NULL, ucMeta, &uiMetaOffset, 
					ucAltMeta, &uiAltMetaOffset))
				{
					goto Done;
				}

				uiInputOffset++;
				break;
			}

			case FLM_UNICODE_p:
			{
				if( uzInput[ uiInputOffset + 1] == FLM_UNICODE_h)
				{
					if( f_addMetaphone( "F", NULL, ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}

					uiInputOffset += 2;
					break;
				}

				// Account for "Campbell", "raspberry", etc.

				if( uzInput[ uiInputOffset + 1] == FLM_UNICODE_p ||
					 uzInput[ uiInputOffset + 1] == FLM_UNICODE_b)
				{
					uiInputOffset += 2;
				}
				else
				{
					uiInputOffset++;
				}

				if( f_addMetaphone( "P", NULL, ucMeta, &uiMetaOffset, 
					ucAltMeta, &uiAltMetaOffset))
				{
					goto Done;
				}

				break;
			}

			case FLM_UNICODE_q:
			{
				if( uzInput[ uiInputOffset + 1] == FLM_UNICODE_q)
				{
					uiInputOffset += 2;
				}
				else
				{
					uiInputOffset += 1;
				}

				if( f_addMetaphone( "K", NULL, ucMeta, &uiMetaOffset, 
					ucAltMeta, &uiAltMetaOffset))
				{
					goto Done;
				}

				break;
			}

			case FLM_UNICODE_r:
			{
				// French words such as "rogier".  Excludes "Hochmeier"

				if( uiInputOffset == uiLast && 
					!bSlavoGermanic &&
					f_uninativencmp( &uzInput[ uiInputOffset - 2], "ie", 2) == 0 &&
					f_uninativencmp( &uzInput[ uiInputOffset - 4], "me", 2) != 0 &&
					f_uninativencmp( &uzInput[ uiInputOffset - 4], "ma", 2) != 0)
				{
					if( f_addMetaphone( NULL, "R", ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}
				}
				else
				{
					if( f_addMetaphone( "R", NULL, ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}
				}

				if( uzInput[ uiInputOffset + 1] == FLM_UNICODE_r)
				{
					uiInputOffset += 2;
				}
				else
				{
					uiInputOffset++;
				}
				break;
			}

			case FLM_UNICODE_s:
			{
				// Special cases of "island", "isle", "carlisle", "carlysle"
				
				if( f_uninativencmp( &uzInput[ uiInputOffset - 1], "isl", 3) == 0 ||
					f_uninativencmp( &uzInput[ uiInputOffset - 1], "ysl", 3) == 0)
				{
					uiInputOffset++;
					break;
				}

				// Special case of 'sugar-'

				if( !uiInputOffset && 
					f_uninativencmp( &uzInput[ uiInputOffset], "sugar", 5) == 0)
				{
					if( f_addMetaphone( "X", "S", ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}

					uiInputOffset++;
					break;
				}

				if( f_uninativencmp( &uzInput[ uiInputOffset], "sh", 2) == 0)
				{
					// Germanic

					if( f_uninativencmp( &uzInput[ uiInputOffset + 1], "heim", 4) == 0 ||
						 f_uninativencmp( &uzInput[ uiInputOffset + 1], "hoek", 4) == 0 ||
						 f_uninativencmp( &uzInput[ uiInputOffset + 1], "holm", 4) == 0 ||
						 f_uninativencmp( &uzInput[ uiInputOffset + 1], "holz", 4) == 0)
					{
						if( f_addMetaphone( "S", NULL, ucMeta, &uiMetaOffset, 
							ucAltMeta, &uiAltMetaOffset))
						{
							goto Done;
						}
					}
					else
					{
						if( f_addMetaphone( "X", NULL, ucMeta, &uiMetaOffset, 
							ucAltMeta, &uiAltMetaOffset))
						{
							goto Done;
						}
					}

					uiInputOffset += 2;
					break;
				}

				// Italian and Armenian

				if( f_uninativencmp( &uzInput[ uiInputOffset], "sio", 3) == 0 ||
					 f_uninativencmp( &uzInput[ uiInputOffset], "sia", 3) == 0 ||
					 f_uninativencmp( &uzInput[ uiInputOffset], "sian", 4) == 0)
				{
					if( !bSlavoGermanic)
					{
						if( f_addMetaphone( "S", "X", ucMeta, &uiMetaOffset, 
							ucAltMeta, &uiAltMetaOffset))
						{
							goto Done;
						}
					}
					else
					{
						if( f_addMetaphone( "S", NULL, ucMeta, &uiMetaOffset, 
							ucAltMeta, &uiAltMetaOffset))
						{
							goto Done;
						}
					}

					uiInputOffset += 3;
					break;
				}

				// German & Anglicisations such as "Smith" matching "Schmidt" and
				// "Snider" matching "Schneider"

				if( (!uiInputOffset && 
					  (uzInput[ uiInputOffset + 1] == FLM_UNICODE_m ||
					   uzInput[ uiInputOffset + 1] == FLM_UNICODE_n ||
						uzInput[ uiInputOffset + 1] == FLM_UNICODE_l ||
						uzInput[ uiInputOffset + 1] == FLM_UNICODE_w)) ||
					 uzInput[ uiInputOffset + 1] == FLM_UNICODE_z)
				{
					if( f_addMetaphone( "S", "X", ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}

					if( uzInput[ uiInputOffset + 1] == FLM_UNICODE_z)
					{
						uiInputOffset += 2;
					}
					else
					{
						uiInputOffset++;
					}
					break;
				}

				if( f_uninativencmp( &uzInput[ uiInputOffset], "sc", 2) == 0)
				{
					// Schlesinger's rule

					if( uzInput[ uiInputOffset + 2] == FLM_UNICODE_h)
					{
						// Words of Dutch origin such as "school" and "schooner"

						if( f_uninativencmp( &uzInput[ uiInputOffset + 3], "oo", 2) == 0 ||
							 f_uninativencmp( &uzInput[ uiInputOffset + 3], "er", 2) == 0 ||
							 f_uninativencmp( &uzInput[ uiInputOffset + 3], "en", 2) == 0 ||
							 f_uninativencmp( &uzInput[ uiInputOffset + 3], "uy", 2) == 0 ||
							 f_uninativencmp( &uzInput[ uiInputOffset + 3], "ed", 2) == 0 ||
							 f_uninativencmp( &uzInput[ uiInputOffset + 3], "em", 2) == 0)
						{
							// "Schermerhorn", "Schenker"

							if( f_uninativencmp( &uzInput[ uiInputOffset + 3], "er", 2) == 0 ||
								 f_uninativencmp( &uzInput[ uiInputOffset + 3], "en", 2) == 0)
							{
								if( f_addMetaphone( "X", "SK", ucMeta, &uiMetaOffset, 
									ucAltMeta, &uiAltMetaOffset))
								{
									goto Done;
								}
							}
							else
							{
								if( f_addMetaphone( "SK", NULL, ucMeta, &uiMetaOffset, 
									ucAltMeta, &uiAltMetaOffset))
								{
									goto Done;
								}
							}

							uiInputOffset += 3;
							break;
						}
						else
						{
							if( !uiInputOffset && !f_isvowel( uzInput[ 3]) && 
								uzInput[ 3] != FLM_UNICODE_w)
							{
								if( f_addMetaphone( "X", "S", ucMeta, &uiMetaOffset, 
									ucAltMeta, &uiAltMetaOffset))
								{
									goto Done;
								}
							}
							else
							{
								if( f_addMetaphone( "X", NULL, ucMeta, &uiMetaOffset, 
									ucAltMeta, &uiAltMetaOffset))
								{
									goto Done;
								}
							}

							uiInputOffset += 3;
							break;
						}
					}

					if( uzInput[ uiInputOffset + 2] == FLM_UNICODE_i ||
						 uzInput[ uiInputOffset + 2] == FLM_UNICODE_e ||
						 uzInput[ uiInputOffset + 2] == FLM_UNICODE_y)
					{
						if( f_addMetaphone( "S", NULL, ucMeta, &uiMetaOffset, 
							ucAltMeta, &uiAltMetaOffset))
						{
							goto Done;
						}

						uiInputOffset += 3;
						break;
					}

					if( f_addMetaphone( "SK", NULL, ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}

					uiInputOffset += 3;
					break;
				}

				// French words such as "resnais" and "artois"

				if( uiInputOffset == uiLast &&
					(f_uninativencmp( &uzInput[ uiInputOffset - 2], "ai", 2) == 0 ||
					 f_uninativencmp( &uzInput[ uiInputOffset - 2], "oi", 2) == 0))
				{
					if( f_addMetaphone( NULL, "S", ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}
				}
				else
				{
					if( f_addMetaphone( "S", NULL, ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}
				}

				if( uzInput[ uiInputOffset + 1] == FLM_UNICODE_s ||
					uzInput[ uiInputOffset + 1] == FLM_UNICODE_z)
				{
					uiInputOffset += 2;
				}
				else
				{
					uiInputOffset++;
				}
				break;
			}

			case FLM_UNICODE_t:
			{
				if( f_uninativencmp( &uzInput[ uiInputOffset], "tion", 4) == 0)
				{
					if( f_addMetaphone( "X", NULL, ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}

					uiInputOffset += 3;
					break;
				}

				if( f_uninativencmp( &uzInput[ uiInputOffset], "tia", 3) == 0 ||
					f_uninativencmp( &uzInput[ uiInputOffset], "tch", 3) == 0)
				{
					if( f_addMetaphone( "X", NULL, ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}

					uiInputOffset += 3;
					break;
				}

				if( f_uninativencmp( &uzInput[ uiInputOffset], "th", 2) == 0 ||
					 f_uninativencmp( &uzInput[ uiInputOffset], "tth", 3) == 0)
				{
					// Special cases of "Thomas", "Thames", or Germanic

					if( f_uninativencmp( &uzInput[ uiInputOffset + 2], "om", 2) == 0 ||
						 f_uninativencmp( &uzInput[ uiInputOffset + 2], "am", 2) == 0 ||
						 f_uninativencmp( &uzInput[ 0], "van ", 4) == 0 ||
						 f_uninativencmp( &uzInput[ 0], "von ", 4) == 0 ||
						 f_uninativencmp( &uzInput[ 0], "sch", 3) == 0)
					{
						if( f_addMetaphone( "T", NULL, ucMeta, &uiMetaOffset, 
							ucAltMeta, &uiAltMetaOffset))
						{
							goto Done;
						}
					}
					else
					{
						if( f_addMetaphone( "0", "T", ucMeta, &uiMetaOffset, 
							ucAltMeta, &uiAltMetaOffset))
						{
							goto Done;
						}
					}

					uiInputOffset += 2;
					break;
				}

				if( uzInput[ uiInputOffset + 1] == FLM_UNICODE_t ||
					uzInput[ uiInputOffset] == FLM_UNICODE_d)
				{
					uiInputOffset += 2;
				}
				else
				{
					uiInputOffset++;
				}

				if( f_addMetaphone( "T", NULL, ucMeta, &uiMetaOffset, 
					ucAltMeta, &uiAltMetaOffset))
				{
					goto Done;
				}

				break;
			}

			case FLM_UNICODE_v:
			{
				if( uzInput[ uiInputOffset + 1] == FLM_UNICODE_v)
				{
					uiInputOffset += 2;
				}
				else
				{
					uiInputOffset++;
				}

				if( f_addMetaphone( "F", NULL, ucMeta, &uiMetaOffset, 
					ucAltMeta, &uiAltMetaOffset))
				{
					goto Done;
				}

				break;
			}

			case FLM_UNICODE_w:
			{
				if( f_uninativencmp( &uzInput[ uiInputOffset], "wr", 2) == 0)
				{
					if( f_addMetaphone( "R", NULL, ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}

					uiInputOffset += 2;
					break;
				}

				if( !uiInputOffset &&
					(f_isvowel( uzInput[ uiInputOffset + 1]) || 
					 f_uninativencmp( &uzInput[ uiInputOffset], "wh", 2) == 0))
				{
					// "Wasserman" should match "Vasserman"

					if( f_isvowel( uzInput[ uiInputOffset + 1]))
					{
						if( f_addMetaphone( "A", "F", ucMeta, &uiMetaOffset, 
							ucAltMeta, &uiAltMetaOffset))
						{
							goto Done;
						}
					}
					else
					{
						// "Uomo" should match "Womo"

						if( f_addMetaphone( "A", NULL, ucMeta, &uiMetaOffset, 
							ucAltMeta, &uiAltMetaOffset))
						{
							goto Done;
						}
					}
				}

				// "Arnow" should match "Arnoff"

				if( (uiInputOffset == uiLast && 
					 f_isvowel( uzInput[ uiInputOffset - 1])) ||
					 f_uninativencmp( &uzInput[ uiInputOffset - 1], "ewski", 5) == 0 ||
					 f_uninativencmp( &uzInput[ uiInputOffset - 1], "ewsky", 5) == 0 ||
					 f_uninativencmp( &uzInput[ uiInputOffset - 1], "owski", 5) == 0 ||
					 f_uninativencmp( &uzInput[ uiInputOffset - 1], "owsky", 5) == 0 ||
					 f_uninativencmp( &uzInput[ 0], "sch", 3) == 0)
				{
					if( f_addMetaphone( NULL, "F", ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}

					uiInputOffset++;
					break;
				}

				// Polish names and words such as "Filipowicz"

				if( f_uninativencmp( &uzInput[ uiInputOffset], "wicz", 4) == 0 ||
					 f_uninativencmp( &uzInput[ uiInputOffset], "witz", 4) == 0)
				{
					if( f_addMetaphone( "TS", "FX", ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}

					uiInputOffset +=4;
					break;
				}

				// otherwise, skip the current character

				uiInputOffset++;
				break;
			}

			case FLM_UNICODE_x:
			{
				// French words such as "breaux"

				if( !(uiInputOffset == uiLast && 
						(f_uninativencmp( &uzInput[ uiInputOffset - 3], "iau", 3) == 0 ||
						 f_uninativencmp( &uzInput[ uiInputOffset - 3], "eau", 3) == 0 ||
						 f_uninativencmp( &uzInput[ uiInputOffset - 2], "au", 2) == 0 ||
						 f_uninativencmp( &uzInput[ uiInputOffset - 2], "ou", 2) == 0)))
				{
					if( f_addMetaphone( "KS", NULL, ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}
				}

				if( uzInput[ uiInputOffset + 1] == FLM_UNICODE_c ||
					 uzInput[ uiInputOffset + 1] == FLM_UNICODE_x)
				{
					uiInputOffset += 2;
				}
				else
				{
					uiInputOffset++;
				}
				break;
			}

			case FLM_UNICODE_z:
			{
				// Chinese pinyin such as "Zhao"

				if( uzInput[ uiInputOffset + 1] == FLM_UNICODE_h)
				{
					if( f_addMetaphone( "J", NULL, ucMeta, &uiMetaOffset, 
						ucAltMeta, &uiAltMetaOffset))
					{
						goto Done;
					}

					uiInputOffset += 2;
					break;
				}
				else
				{
					if( f_uninativencmp( &uzInput[ uiInputOffset + 1], "zo", 2) == 0 ||
						 f_uninativencmp( &uzInput[ uiInputOffset + 1], "zi", 2) == 0 ||
						 f_uninativencmp( &uzInput[ uiInputOffset + 1], "za", 2) == 0 ||
						 (bSlavoGermanic && uiInputOffset && 
							uzInput[ uiInputOffset - 1] != FLM_UNICODE_t))
					{
						if( f_addMetaphone( "S", "TS", ucMeta, &uiMetaOffset, 
							ucAltMeta, &uiAltMetaOffset))
						{
							goto Done;
						}
					}
					else
					{
						if( f_addMetaphone( "S", NULL, ucMeta, &uiMetaOffset, 
							ucAltMeta, &uiAltMetaOffset))
						{
							goto Done;
						}
					}

					if( uzInput[ uiInputOffset + 1] == FLM_UNICODE_z)
					{
						uiInputOffset += 2;
					}
					else
					{
						uiInputOffset++;
					}
				}

				break;
			}

			default:
			{
				uiInputOffset++;
				break;
			}
		}
	}

Done:

	ucMeta[ uiMetaOffset] = 0;
	f_metaStrToNum( ucMeta, puiMetaphone);

	if( puiAltMetaphone)
	{
		ucAltMeta[ uiAltMetaOffset] = 0;
		f_metaStrToNum( ucAltMeta, puiAltMetaphone);
	}

Exit:

	return( rc);
}

/****************************************************************************
Desc:		Verifies that the metaphone routines are generating the correct
			codes for a hard-coded set of words.
****************************************************************************/
#ifdef FLM_DEBUG
RCODE f_verifyMetaphoneRoutines( void)
{
	RCODE						rc = NE_FLM_OK;
	METAPHONE_MAPPING *	pMetaMap = gv_MetaTestTable;
	IF_BufferIStream *	pBufferStream = NULL;
	FLMUINT					uiMeta;
	FLMUINT					uiAltMeta;
	
	if( RC_BAD( rc = FlmAllocBufferIStream( &pBufferStream)))
	{
		goto Exit;
	}

	for( ;;)
	{
		if( !pMetaMap->pszWord)
		{
			break;
		}

		if( RC_BAD( rc = pBufferStream->openStream( 
			pMetaMap->pszWord, f_strlen( pMetaMap->pszWord))))
		{
			goto Exit;
		}

		if( RC_BAD( rc = f_getNextMetaphone( pBufferStream, 
			&uiMeta, &uiAltMeta)))
		{
			goto Exit;
		}

		if( uiMeta != pMetaMap->uiMeta ||
			uiAltMeta != pMetaMap->uiAltMeta)
		{
			rc = RC_SET_AND_ASSERT( NE_FLM_FAILURE);
			goto Exit;
		}

		pBufferStream->closeStream();
		pMetaMap++;
	}

Exit:

	if( pBufferStream)
	{
		pBufferStream->Release();
	}

	f_assert( RC_OK( rc));
	return( rc);
}
#endif

/*****************************************************************************
Desc:
Notes:	pucBuf must be able to contain at least 3 bytes
******************************************************************************/
RCODE FLMAPI f_readUTF8CharAsUTF8(
	IF_IStream *	pIStream,
	FLMBYTE *		pucBuf,
	FLMUINT *		puiLen)
{
	RCODE			rc = NE_FLM_OK;
	FLMUINT		uiLen;

	if( *puiLen == 0)
	{
		rc = RC_SET_AND_ASSERT( NE_FLM_CONV_DEST_OVERFLOW);
		goto Exit;
	}

	uiLen = 1;
	if( RC_BAD( rc = pIStream->read( pucBuf, uiLen, &uiLen)))
	{
		goto Exit;
	}

	if( pucBuf[ 0] <= 0x7F)
	{
		if( !pucBuf[ 0])
		{
			rc = RC_SET( NE_FLM_EOF_HIT);
			goto Exit;
		}
		
		*puiLen = 1;
		goto Exit;
	}

	if( *puiLen < 2)
	{
		rc = RC_SET_AND_ASSERT( NE_FLM_CONV_DEST_OVERFLOW);
		goto Exit;
	}

	uiLen = 1;
	if( RC_BAD( rc = pIStream->read( &pucBuf[ 1], uiLen, &uiLen)))
	{
		if( rc == NE_FLM_EOF_HIT)
		{
			rc = RC_SET_AND_ASSERT( NE_FLM_BAD_UTF8);
		}
		goto Exit;
	}

	if( (pucBuf[ 1] >> 6) != 0x02)
	{
		rc = RC_SET_AND_ASSERT( NE_FLM_BAD_UTF8);
		goto Exit;
	}

	if( (pucBuf[ 0] >> 5) == 0x06)
	{
		*puiLen = 2;
		goto Exit;
	}

	if( *puiLen < 3)
	{
		rc = RC_SET_AND_ASSERT( NE_FLM_CONV_DEST_OVERFLOW);
		goto Exit;
	}

	uiLen = 1;
	if( RC_BAD( rc = pIStream->read( &pucBuf[ 2], uiLen, &uiLen)))
	{
		if( rc == NE_FLM_EOF_HIT)
		{
			rc = RC_SET_AND_ASSERT( NE_FLM_BAD_UTF8);
		}
		goto Exit;
	}

	if( (pucBuf[ 0] >> 4) != 0x0E || (pucBuf[ 2] >> 6) != 0x02)
	{
		rc = RC_SET_AND_ASSERT( NE_FLM_BAD_UTF8);
		goto Exit;
	}

	*puiLen = 3;

Exit:

	return( rc);
}

/***************************************************************************
Desc:
****************************************************************************/
RCODE FLMAPI f_compareUnicodeStrings(
	const FLMUNICODE *	puzLString,
	FLMUINT					uiLStrBytes,
	FLMBOOL					bLeftWild,
	const FLMUNICODE *	puzRString,
	FLMUINT					uiRStrBytes,
	FLMBOOL					bRightWild,
	FLMUINT					uiCompareRules,
	FLMUINT					uiLanguage,
	FLMINT *					piResult)
{
	RCODE						rc = NE_FLM_OK;
	F_BufferIStream 		bufferLStream;
	F_BufferIStream		bufferRStream;
	F_CollIStream			lStream;
	F_CollIStream			rStream;

	if( RC_BAD( rc = bufferLStream.openStream( 
		(const char *)puzLString, uiLStrBytes)))
	{
		goto Exit;
	}

	if( RC_BAD( rc = bufferRStream.openStream( 
		(const char *)puzRString, uiRStrBytes)))
	{
		goto Exit;
	}

	if( RC_BAD( rc = lStream.openStream( &bufferLStream, TRUE, uiLanguage,
		uiCompareRules, bLeftWild)))
	{
		goto Exit;
	}

	if( RC_BAD( rc = rStream.openStream( &bufferRStream, TRUE, uiLanguage,
		uiCompareRules, bRightWild)))
	{
		goto Exit;
	}

	if( RC_BAD( rc = f_compareCollStreams( 
		(IF_CollIStream *)&lStream, (IF_CollIStream *)&rStream,
		(bLeftWild || bRightWild) ? TRUE : FALSE, uiLanguage, piResult)))
	{
		goto Exit;
	}

Exit:

	return( rc);
}

/***************************************************************************
Desc:
****************************************************************************/
RCODE FLMAPI f_compareUTF8Strings(
	const FLMBYTE *		pucLString,
	FLMUINT					uiLStrBytes,
	FLMBOOL					bLeftWild,
	const FLMBYTE *		pucRString,
	FLMUINT					uiRStrBytes,
	FLMBOOL					bRightWild,
	FLMUINT					uiCompareRules,
	FLMUINT					uiLanguage,
	FLMINT *					piResult)
{
	RCODE						rc = NE_FLM_OK;
	F_BufferIStream		bufferLStream;
	F_BufferIStream		bufferRStream;
	F_CollIStream			lStream;
	F_CollIStream			rStream;

	if (RC_BAD( rc = bufferLStream.openStream( 
		(const char *)pucLString, uiLStrBytes)))
	{
		goto Exit;
	}

	if( RC_BAD( rc = bufferRStream.openStream( 
		(const char *)pucRString, uiRStrBytes)))
	{
		goto Exit;
	}

	if( RC_BAD( rc = lStream.openStream( &bufferLStream, FALSE, uiLanguage,
								uiCompareRules, bLeftWild)))
	{
		goto Exit;
	}

	if( RC_BAD( rc = rStream.openStream( &bufferRStream, FALSE, uiLanguage,
								uiCompareRules, bRightWild)))
	{
		goto Exit;
	}

	if( RC_BAD( rc = f_compareCollStreams( 
		(IF_CollIStream *)&lStream, (IF_CollIStream *)&rStream,
		(bLeftWild || bRightWild) ? TRUE : FALSE,
		uiLanguage, piResult)))
	{
		goto Exit;
	}

Exit:

	return( rc);
}

/***************************************************************************
Desc:
****************************************************************************/
RCODE FLMAPI f_compareUTF8Streams(
	IF_PosIStream *			pLStream,
	FLMBOOL						bLeftWild,
	IF_PosIStream *			pRStream,
	FLMBOOL						bRightWild,
	FLMUINT						uiCompareRules,
	FLMUINT						uiLanguage,
	FLMINT *						piResult)
{
	RCODE						rc = NE_FLM_OK;
	F_CollIStream			lStream;
	F_CollIStream			rStream;

	if( RC_BAD( rc = lStream.openStream( pLStream, FALSE, uiLanguage,
								uiCompareRules, bLeftWild)))
	{
		goto Exit;
	}

	if( RC_BAD( rc = rStream.openStream( pRStream, FALSE, uiLanguage,
								uiCompareRules, bRightWild)))
	{
		goto Exit;
	}

	if( RC_BAD( rc = f_compareCollStreams( 
		&lStream, &rStream, (bLeftWild || bRightWild) ? TRUE : FALSE,
		uiLanguage, piResult)))
	{
		goto Exit;
	}

Exit:

	return( rc);
}

/***************************************************************************
Desc:
****************************************************************************/
RCODE FLMAPI f_compareUnicodeStreams(
	IF_PosIStream *			pLStream,
	FLMBOOL						bLeftWild,
	IF_PosIStream *			pRStream,
	FLMBOOL						bRightWild,
	FLMUINT						uiCompareRules,
	FLMUINT						uiLanguage,
	FLMINT *						piResult)
{
	RCODE						rc = NE_FLM_OK;
	F_CollIStream			lStream;
	F_CollIStream			rStream;

	if( RC_BAD( rc = lStream.openStream( pLStream, TRUE, uiLanguage,
								uiCompareRules, bLeftWild)))
	{
		goto Exit;
	}

	if( RC_BAD( rc = rStream.openStream( pRStream, TRUE, uiLanguage,
								uiCompareRules, bRightWild)))
	{
		goto Exit;
	}

	if( RC_BAD( rc = f_compareCollStreams( 
		&lStream, &rStream, (bLeftWild || bRightWild) ? TRUE : FALSE,
		uiLanguage, piResult)))
	{
		goto Exit;
	}

Exit:

	return( rc);
}

/***************************************************************************
Desc:
****************************************************************************/
RCODE FLMAPI f_utf8IsSubStr(
	const FLMBYTE *	pszString,
	const FLMBYTE *	pszSubString,
	FLMUINT				uiCompareRules,
	FLMUINT				uiLanguage,
	FLMBOOL *			pbExists)
{
	RCODE				rc = NE_FLM_OK;
	FLMINT			iResult = 0;
	FLMBYTE *		pszSearch = NULL;
	FLMUINT			uiSubStringLen = f_strlen( (const char *)pszSubString);
	
	if( RC_BAD( rc = f_alloc( uiSubStringLen + 3, &pszSearch)))
	{
		goto Exit;
	}
	
	pszSearch[0] = '*';
	f_memcpy( &pszSearch[ 1], pszSubString, uiSubStringLen);
	pszSearch[ uiSubStringLen + 1] = '*';
	pszSearch[ uiSubStringLen + 2] = '\0';

	if( RC_BAD( rc = f_compareUTF8Strings( 
		pszString, f_strlen( (const char *)pszString), FALSE, pszSearch, 
		uiSubStringLen + 2, TRUE, uiCompareRules, uiLanguage, &iResult)))
	{
		goto Exit;
	}
	
	*pbExists = (iResult)?FALSE:TRUE;

Exit:

	if( pszSearch)
	{
		f_free( &pszSearch);
	}
	
	return( rc);
}

/****************************************************************************
Desc:
****************************************************************************/
RCODE FLMAPI f_strdup(
	const char *		pszSrc,
	char **				ppszDup)
{
	RCODE					rc = NE_FLM_OK;
	char * 				pszDup = NULL;

	if( RC_BAD( rc = f_alloc( f_strlen( pszSrc) + 1, &pszDup)))
	{
		goto Exit;
	}

	f_strcpy( pszDup, pszSrc);
	*ppszDup = pszDup;
	pszDup = NULL;

Exit:

	if( pszDup)
	{
		f_free( &pszDup);
	}

	return( rc);
}

