/* package-info.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

/**
 * Various simple classes that do not fit into one of the other packages
 * of this library. See documentation of each individual class for more information.
 * <ul>
 * <li>{@link be.ugent.caagt.swirl.SelectionGroup} acts like a button group
 * with an associated single selection model. This is useful when two button groups
 * need to be 'synchronized', or when the program needs to know which of
 * the buttons in the group is selected.</li>
 * <li>{@link be.ugent.caagt.swirl.GenericSelectionGroup} is very similar to
 * {@code SelectionGroup} but associates an object of a fixed
 * type with each selection - instead of an index. The associated model
 * of type {@link be.ugent.caagt.swirl.GenericSelectionModel GenericSelectionModel&lt;E&gt;} is
 * used by the {@link be.ugent.caagt.swirl.menus.MenuBuilder}.</li>
 * <li>{@link be.ugent.caagt.swirl.StandardButtons} allows creation of OK, Cancel,
 *  Yes and No buttons with captions and mnemonics from the current look and feel.</li>
 * <li>{@link be.ugent.caagt.swirl.ActionRepeater} allows you to have an action repeated
 * at regular intervals while an associated button is kept pressed down.</li>
 * <li>{@link be.ugent.caagt.swirl.SwirlUtilities} contains some utilities
 * which retrieve descendant components by name. {@link be.ugent.caagt.swirl.SelectOnFocusGained}
 * selects the contents of text fields when they gain focus.</li>
 * </ul>
 */
package be.ugent.caagt.swirl;

