/* package-info.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

/**
 * Provides XML-based configuration of buttons and menus.
 * The most important class of this package
 * is {@link be.ugent.caagt.swirl.menus.MenuBuilder} which can be used to 
 * build menus, tool bars and individual buttons from descriptions given in
 * an XML configuration file. All descriptions are internationalized by means of
 * a corresponding resource bundle.<p>
 * More information can be found in the <a href="../../../../../../tutorial.html">MenuBuilder tutorial</a>.
 * <h2>Button descriptions</h2>
 * For each button or menu item, the following information can be placed in the
 * configuration file:
 * <ul>
 * <li>The (internationalized) caption.</li>
 * <li>An (internationalized) mnemonic.</li>
 * <li>An (internationalized) acceleration key.</li>
 * <li>An (internationalized) tool tip for use in tool bars.</li>
 * <li>An icon for use in menus.</li>
 * <li>A 'disabled' icon for use in menus.</li>
 * <li>An icon for use in tool bars.</li>
 * <li>A 'disabled' icon for use in tool bars.</li>
 * </ul>
 * You can also configure caption, mnemonic and acceleration key for menus 
 * and submenus.
 * <h2>Actions, toggles and groups.</h2>
 * Menu items and tool bar buttons are built indirectly from one of the following
 * types of entities:
 * <ul>
 * <li>Standard Swing <i>actions</i> (of type {@code Action})
 * are used to create standard menu items and push buttons.</li>
 * <li><i>Toggles</i> are instantiated as check boxes in menus and toggle buttons
 * in tool bars. An {@code ItemListener} can be registered with a toggle to
 * process changes in its selection state.</li>
 * <li><i>Groups</i> become 'button groups' of radio buttons (in menus) or of toggle
 * buttons (in tool bars). Groups are governed by a selection model of type
 * {@link be.ugent.caagt.swirl.GenericSelectionModel}.</li>
 * </ul>
 * Actions, toggles and groups have an associated identifier, allowing the same
 * entity to occur more than once in the same application, in which case they will
 * share their model.
 */
package be.ugent.caagt.swirl.menus;

