/****************************************************************************
**
** This file is part of the LibreCAD project, a 2D CAD program
**
** Copyright (C) 2010 R. van Twisk (librecad@rvt.dds.nl)
** Copyright (C) 2001-2003 RibbonSoft. All rights reserved.
**
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
** This copyright notice MUST APPEAR in all copies of the script!  
**
**********************************************************************/
#ifndef QG_DLGTEXT_H
#define QG_DLGTEXT_H

#include <qvariant.h>


#include <Qt3Support/Q3ButtonGroup>
#include <Qt3Support/Q3TextEdit>
#include <QtCore/QVariant>
#include <QtGui/QAction>
#include <QtGui/QApplication>
#include <QtGui/QButtonGroup>
#include <QtGui/QCheckBox>
#include <QtGui/QComboBox>
#include <QtGui/QDialog>
#include <QtGui/QGridLayout>
#include <QtGui/QHBoxLayout>
#include <QtGui/QHeaderView>
#include <QtGui/QLabel>
#include <QtGui/QLineEdit>
#include <QtGui/QPushButton>
#include <QtGui/QSpacerItem>
#include <QtGui/QToolButton>
#include <QtGui/QVBoxLayout>
#include <Qt3Support/Q3FileDialog>
#include <QtCore/QFile>
#include "qg_fontbox.h"
#include "rs_filterdxf.h"
#include "rs_font.h"
#include "rs_math.h"
#include "rs_settings.h"
#include "rs_text.h"

QT_BEGIN_NAMESPACE

class Ui_QG_DlgText
{
public:
    QVBoxLayout *vboxLayout;
    QHBoxLayout *hboxLayout;
    QVBoxLayout *vboxLayout1;
    Q3ButtonGroup *bgFont;
    QGridLayout *gridLayout;
    QLineEdit *leHeight;
    QLabel *lHeight;
    QSpacerItem *spacer2_2;
    QG_FontBox *cbFont;
    QSpacerItem *spacer2;
    QLabel *lLineSpacingFactor;
    QLineEdit *leLineSpacingFactor;
    QCheckBox *cbDefault;
    QHBoxLayout *hboxLayout1;
    Q3ButtonGroup *bgAlignment;
    QGridLayout *gridLayout1;
    QToolButton *bTR;
    QToolButton *bTL;
    QToolButton *bML;
    QToolButton *bMC;
    QToolButton *bMR;
    QToolButton *bBL;
    QToolButton *bBR;
    QToolButton *bBC;
    QToolButton *bTC;
    Q3ButtonGroup *bgShape;
    QVBoxLayout *vboxLayout2;
    QLineEdit *leAngle;
    QSpacerItem *spacer13;
    QVBoxLayout *vboxLayout3;
    QHBoxLayout *hboxLayout2;
    QLabel *lText;
    QSpacerItem *spacer4;
    QToolButton *bClear;
    QToolButton *bLoad;
    QToolButton *bSave;
    QToolButton *bCut;
    QToolButton *bCopy;
    QToolButton *bPaste;
    Q3TextEdit *teText;
    QHBoxLayout *hboxLayout3;
    Q3ButtonGroup *buttonGroup7;
    QVBoxLayout *vboxLayout4;
    QComboBox *cbSymbol;
    Q3ButtonGroup *buttonGroup5;
    QGridLayout *gridLayout2;
    QLabel *textLabel1;
    QLabel *textLabel1_2;
    QComboBox *cbUniPage;
    QComboBox *cbUniChar;
    QToolButton *bUnicode;
    QHBoxLayout *hboxLayout4;
    QSpacerItem *Horizontal_Spacing2;
    QPushButton *buttonOk;
    QPushButton *buttonCancel;

    void setupUi(QDialog *QG_DlgText)
    {
        if (QG_DlgText->objectName().isEmpty())
            QG_DlgText->setObjectName(QString::fromUtf8("QG_DlgText"));
        QG_DlgText->resize(619, 429);
        QG_DlgText->setSizeGripEnabled(true);
        vboxLayout = new QVBoxLayout(QG_DlgText);
        vboxLayout->setSpacing(6);
        vboxLayout->setContentsMargins(11, 11, 11, 11);
        vboxLayout->setObjectName(QString::fromUtf8("vboxLayout"));
        hboxLayout = new QHBoxLayout();
        hboxLayout->setSpacing(6);
        hboxLayout->setObjectName(QString::fromUtf8("hboxLayout"));
        vboxLayout1 = new QVBoxLayout();
        vboxLayout1->setSpacing(6);
        vboxLayout1->setObjectName(QString::fromUtf8("vboxLayout1"));
        bgFont = new Q3ButtonGroup(QG_DlgText);
        bgFont->setObjectName(QString::fromUtf8("bgFont"));
        QSizePolicy sizePolicy(static_cast<QSizePolicy::Policy>(5), static_cast<QSizePolicy::Policy>(5));
        sizePolicy.setHorizontalStretch(0);
        sizePolicy.setVerticalStretch(0);
        sizePolicy.setHeightForWidth(bgFont->sizePolicy().hasHeightForWidth());
        bgFont->setSizePolicy(sizePolicy);
        bgFont->setColumnLayout(0, Qt::Vertical);
        bgFont->layout()->setSpacing(2);
        bgFont->layout()->setContentsMargins(11, 11, 11, 11);
        gridLayout = new QGridLayout();
        QBoxLayout *boxlayout = qobject_cast<QBoxLayout *>(bgFont->layout());
        if (boxlayout)
            boxlayout->addLayout(gridLayout);
        gridLayout->setAlignment(Qt::AlignTop);
        gridLayout->setObjectName(QString::fromUtf8("gridLayout"));
        leHeight = new QLineEdit(bgFont);
        leHeight->setObjectName(QString::fromUtf8("leHeight"));
        QSizePolicy sizePolicy1(static_cast<QSizePolicy::Policy>(7), static_cast<QSizePolicy::Policy>(0));
        sizePolicy1.setHorizontalStretch(0);
        sizePolicy1.setVerticalStretch(0);
        sizePolicy1.setHeightForWidth(leHeight->sizePolicy().hasHeightForWidth());
        leHeight->setSizePolicy(sizePolicy1);

        gridLayout->addWidget(leHeight, 1, 1, 1, 1);

        lHeight = new QLabel(bgFont);
        lHeight->setObjectName(QString::fromUtf8("lHeight"));
        lHeight->setWordWrap(false);

        gridLayout->addWidget(lHeight, 1, 0, 1, 1);

        spacer2_2 = new QSpacerItem(20, 16, QSizePolicy::Minimum, QSizePolicy::Expanding);

        gridLayout->addItem(spacer2_2, 5, 1, 1, 1);

        cbFont = new QG_FontBox(bgFont);
        cbFont->setObjectName(QString::fromUtf8("cbFont"));
        sizePolicy1.setHeightForWidth(cbFont->sizePolicy().hasHeightForWidth());
        cbFont->setSizePolicy(sizePolicy1);

        gridLayout->addWidget(cbFont, 0, 0, 1, 2);

        spacer2 = new QSpacerItem(20, 16, QSizePolicy::Minimum, QSizePolicy::Expanding);

        gridLayout->addItem(spacer2, 5, 0, 1, 1);

        lLineSpacingFactor = new QLabel(bgFont);
        lLineSpacingFactor->setObjectName(QString::fromUtf8("lLineSpacingFactor"));
        lLineSpacingFactor->setWordWrap(false);

        gridLayout->addWidget(lLineSpacingFactor, 3, 0, 1, 1);

        leLineSpacingFactor = new QLineEdit(bgFont);
        leLineSpacingFactor->setObjectName(QString::fromUtf8("leLineSpacingFactor"));
        sizePolicy1.setHeightForWidth(leLineSpacingFactor->sizePolicy().hasHeightForWidth());
        leLineSpacingFactor->setSizePolicy(sizePolicy1);

        gridLayout->addWidget(leLineSpacingFactor, 3, 1, 1, 1);

        cbDefault = new QCheckBox(bgFont);
        cbDefault->setObjectName(QString::fromUtf8("cbDefault"));
        sizePolicy1.setHeightForWidth(cbDefault->sizePolicy().hasHeightForWidth());
        cbDefault->setSizePolicy(sizePolicy1);

        gridLayout->addWidget(cbDefault, 2, 0, 1, 2);


        vboxLayout1->addWidget(bgFont);

        hboxLayout1 = new QHBoxLayout();
        hboxLayout1->setSpacing(6);
        hboxLayout1->setObjectName(QString::fromUtf8("hboxLayout1"));
        bgAlignment = new Q3ButtonGroup(QG_DlgText);
        bgAlignment->setObjectName(QString::fromUtf8("bgAlignment"));
        QSizePolicy sizePolicy2(static_cast<QSizePolicy::Policy>(0), static_cast<QSizePolicy::Policy>(5));
        sizePolicy2.setHorizontalStretch(0);
        sizePolicy2.setVerticalStretch(0);
        sizePolicy2.setHeightForWidth(bgAlignment->sizePolicy().hasHeightForWidth());
        bgAlignment->setSizePolicy(sizePolicy2);
        bgAlignment->setColumnLayout(0, Qt::Vertical);
        bgAlignment->layout()->setSpacing(6);
        bgAlignment->layout()->setContentsMargins(11, 11, 11, 11);
        gridLayout1 = new QGridLayout();
        QBoxLayout *boxlayout1 = qobject_cast<QBoxLayout *>(bgAlignment->layout());
        if (boxlayout1)
            boxlayout1->addLayout(gridLayout1);
        gridLayout1->setAlignment(Qt::AlignTop);
        gridLayout1->setObjectName(QString::fromUtf8("gridLayout1"));
        bTR = new QToolButton(bgAlignment);
        bTR->setObjectName(QString::fromUtf8("bTR"));
        QSizePolicy sizePolicy3(static_cast<QSizePolicy::Policy>(5), static_cast<QSizePolicy::Policy>(0));
        sizePolicy3.setHorizontalStretch(0);
        sizePolicy3.setVerticalStretch(0);
        sizePolicy3.setHeightForWidth(bTR->sizePolicy().hasHeightForWidth());
        bTR->setSizePolicy(sizePolicy3);
        bTR->setMinimumSize(QSize(25, 25));
        bTR->setCheckable(true);
        const QIcon icon = qt_get_icon(image0_ID);
        bTR->setIcon(icon);

        gridLayout1->addWidget(bTR, 0, 2, 1, 1);

        bTL = new QToolButton(bgAlignment);
        bTL->setObjectName(QString::fromUtf8("bTL"));
        sizePolicy3.setHeightForWidth(bTL->sizePolicy().hasHeightForWidth());
        bTL->setSizePolicy(sizePolicy3);
        bTL->setMinimumSize(QSize(25, 25));
        bTL->setCheckable(true);
        const QIcon icon1 = qt_get_icon(image1_ID);
        bTL->setIcon(icon1);

        gridLayout1->addWidget(bTL, 0, 0, 1, 1);

        bML = new QToolButton(bgAlignment);
        bML->setObjectName(QString::fromUtf8("bML"));
        sizePolicy3.setHeightForWidth(bML->sizePolicy().hasHeightForWidth());
        bML->setSizePolicy(sizePolicy3);
        bML->setMinimumSize(QSize(25, 25));
        bML->setCheckable(true);
        const QIcon icon2 = qt_get_icon(image2_ID);
        bML->setIcon(icon2);

        gridLayout1->addWidget(bML, 1, 0, 1, 1);

        bMC = new QToolButton(bgAlignment);
        bMC->setObjectName(QString::fromUtf8("bMC"));
        sizePolicy3.setHeightForWidth(bMC->sizePolicy().hasHeightForWidth());
        bMC->setSizePolicy(sizePolicy3);
        bMC->setMinimumSize(QSize(25, 25));
        bMC->setCheckable(true);
        const QIcon icon3 = qt_get_icon(image3_ID);
        bMC->setIcon(icon3);

        gridLayout1->addWidget(bMC, 1, 1, 1, 1);

        bMR = new QToolButton(bgAlignment);
        bMR->setObjectName(QString::fromUtf8("bMR"));
        sizePolicy3.setHeightForWidth(bMR->sizePolicy().hasHeightForWidth());
        bMR->setSizePolicy(sizePolicy3);
        bMR->setMinimumSize(QSize(25, 25));
        bMR->setCheckable(true);
        const QIcon icon4 = qt_get_icon(image4_ID);
        bMR->setIcon(icon4);

        gridLayout1->addWidget(bMR, 1, 2, 1, 1);

        bBL = new QToolButton(bgAlignment);
        bBL->setObjectName(QString::fromUtf8("bBL"));
        sizePolicy3.setHeightForWidth(bBL->sizePolicy().hasHeightForWidth());
        bBL->setSizePolicy(sizePolicy3);
        bBL->setMinimumSize(QSize(25, 25));
        bBL->setCheckable(true);
        const QIcon icon5 = qt_get_icon(image5_ID);
        bBL->setIcon(icon5);

        gridLayout1->addWidget(bBL, 2, 0, 1, 1);

        bBR = new QToolButton(bgAlignment);
        bBR->setObjectName(QString::fromUtf8("bBR"));
        sizePolicy3.setHeightForWidth(bBR->sizePolicy().hasHeightForWidth());
        bBR->setSizePolicy(sizePolicy3);
        bBR->setMinimumSize(QSize(25, 25));
        bBR->setCheckable(true);
        const QIcon icon6 = qt_get_icon(image6_ID);
        bBR->setIcon(icon6);

        gridLayout1->addWidget(bBR, 2, 2, 1, 1);

        bBC = new QToolButton(bgAlignment);
        bBC->setObjectName(QString::fromUtf8("bBC"));
        sizePolicy3.setHeightForWidth(bBC->sizePolicy().hasHeightForWidth());
        bBC->setSizePolicy(sizePolicy3);
        bBC->setMinimumSize(QSize(25, 25));
        bBC->setCheckable(true);
        const QIcon icon7 = qt_get_icon(image7_ID);
        bBC->setIcon(icon7);

        gridLayout1->addWidget(bBC, 2, 1, 1, 1);

        bTC = new QToolButton(bgAlignment);
        bTC->setObjectName(QString::fromUtf8("bTC"));
        sizePolicy3.setHeightForWidth(bTC->sizePolicy().hasHeightForWidth());
        bTC->setSizePolicy(sizePolicy3);
        bTC->setMinimumSize(QSize(25, 25));
        bTC->setCheckable(true);
        const QIcon icon8 = qt_get_icon(image8_ID);
        bTC->setIcon(icon8);

        gridLayout1->addWidget(bTC, 0, 1, 1, 1);


        hboxLayout1->addWidget(bgAlignment);

        bgShape = new Q3ButtonGroup(QG_DlgText);
        bgShape->setObjectName(QString::fromUtf8("bgShape"));
        QSizePolicy sizePolicy4(static_cast<QSizePolicy::Policy>(1), static_cast<QSizePolicy::Policy>(5));
        sizePolicy4.setHorizontalStretch(0);
        sizePolicy4.setVerticalStretch(0);
        sizePolicy4.setHeightForWidth(bgShape->sizePolicy().hasHeightForWidth());
        bgShape->setSizePolicy(sizePolicy4);
        bgShape->setMinimumSize(QSize(80, 0));
        bgShape->setColumnLayout(0, Qt::Vertical);
        bgShape->layout()->setSpacing(6);
        bgShape->layout()->setContentsMargins(11, 11, 11, 11);
        vboxLayout2 = new QVBoxLayout();
        QBoxLayout *boxlayout2 = qobject_cast<QBoxLayout *>(bgShape->layout());
        if (boxlayout2)
            boxlayout2->addLayout(vboxLayout2);
        vboxLayout2->setAlignment(Qt::AlignTop);
        vboxLayout2->setObjectName(QString::fromUtf8("vboxLayout2"));
        leAngle = new QLineEdit(bgShape);
        leAngle->setObjectName(QString::fromUtf8("leAngle"));
        sizePolicy1.setHeightForWidth(leAngle->sizePolicy().hasHeightForWidth());
        leAngle->setSizePolicy(sizePolicy1);

        vboxLayout2->addWidget(leAngle);

        spacer13 = new QSpacerItem(20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding);

        vboxLayout2->addItem(spacer13);


        hboxLayout1->addWidget(bgShape);


        vboxLayout1->addLayout(hboxLayout1);


        hboxLayout->addLayout(vboxLayout1);

        vboxLayout3 = new QVBoxLayout();
        vboxLayout3->setSpacing(6);
        vboxLayout3->setObjectName(QString::fromUtf8("vboxLayout3"));
        hboxLayout2 = new QHBoxLayout();
        hboxLayout2->setSpacing(6);
        hboxLayout2->setObjectName(QString::fromUtf8("hboxLayout2"));
        lText = new QLabel(QG_DlgText);
        lText->setObjectName(QString::fromUtf8("lText"));
        lText->setWordWrap(false);

        hboxLayout2->addWidget(lText);

        spacer4 = new QSpacerItem(110, 20, QSizePolicy::Expanding, QSizePolicy::Minimum);

        hboxLayout2->addItem(spacer4);

        bClear = new QToolButton(QG_DlgText);
        bClear->setObjectName(QString::fromUtf8("bClear"));
        const QIcon icon9 = qt_get_icon(image9_ID);
        bClear->setIcon(icon9);

        hboxLayout2->addWidget(bClear);

        bLoad = new QToolButton(QG_DlgText);
        bLoad->setObjectName(QString::fromUtf8("bLoad"));
        const QIcon icon10 = qt_get_icon(image10_ID);
        bLoad->setIcon(icon10);

        hboxLayout2->addWidget(bLoad);

        bSave = new QToolButton(QG_DlgText);
        bSave->setObjectName(QString::fromUtf8("bSave"));
        const QIcon icon11 = qt_get_icon(image11_ID);
        bSave->setIcon(icon11);

        hboxLayout2->addWidget(bSave);

        bCut = new QToolButton(QG_DlgText);
        bCut->setObjectName(QString::fromUtf8("bCut"));
        const QIcon icon12 = qt_get_icon(image12_ID);
        bCut->setIcon(icon12);

        hboxLayout2->addWidget(bCut);

        bCopy = new QToolButton(QG_DlgText);
        bCopy->setObjectName(QString::fromUtf8("bCopy"));
        const QIcon icon13 = qt_get_icon(image13_ID);
        bCopy->setIcon(icon13);

        hboxLayout2->addWidget(bCopy);

        bPaste = new QToolButton(QG_DlgText);
        bPaste->setObjectName(QString::fromUtf8("bPaste"));
        const QIcon icon14 = qt_get_icon(image14_ID);
        bPaste->setIcon(icon14);

        hboxLayout2->addWidget(bPaste);


        vboxLayout3->addLayout(hboxLayout2);

        teText = new Q3TextEdit(QG_DlgText);
        teText->setObjectName(QString::fromUtf8("teText"));
        teText->setTextFormat(Qt::PlainText);
        teText->setLinkUnderline(false);

        vboxLayout3->addWidget(teText);


        hboxLayout->addLayout(vboxLayout3);


        vboxLayout->addLayout(hboxLayout);

        hboxLayout3 = new QHBoxLayout();
        hboxLayout3->setSpacing(6);
        hboxLayout3->setObjectName(QString::fromUtf8("hboxLayout3"));
        buttonGroup7 = new Q3ButtonGroup(QG_DlgText);
        buttonGroup7->setObjectName(QString::fromUtf8("buttonGroup7"));
        sizePolicy.setHeightForWidth(buttonGroup7->sizePolicy().hasHeightForWidth());
        buttonGroup7->setSizePolicy(sizePolicy);
        buttonGroup7->setMinimumSize(QSize(148, 0));
        buttonGroup7->setColumnLayout(0, Qt::Vertical);
        buttonGroup7->layout()->setSpacing(6);
        buttonGroup7->layout()->setContentsMargins(11, 11, 11, 11);
        vboxLayout4 = new QVBoxLayout();
        QBoxLayout *boxlayout3 = qobject_cast<QBoxLayout *>(buttonGroup7->layout());
        if (boxlayout3)
            boxlayout3->addLayout(vboxLayout4);
        vboxLayout4->setAlignment(Qt::AlignTop);
        vboxLayout4->setObjectName(QString::fromUtf8("vboxLayout4"));
        cbSymbol = new QComboBox(buttonGroup7);
        cbSymbol->setObjectName(QString::fromUtf8("cbSymbol"));
        QSizePolicy sizePolicy5(static_cast<QSizePolicy::Policy>(3), static_cast<QSizePolicy::Policy>(0));
        sizePolicy5.setHorizontalStretch(0);
        sizePolicy5.setVerticalStretch(0);
        sizePolicy5.setHeightForWidth(cbSymbol->sizePolicy().hasHeightForWidth());
        cbSymbol->setSizePolicy(sizePolicy5);

        vboxLayout4->addWidget(cbSymbol);


        hboxLayout3->addWidget(buttonGroup7);

        buttonGroup5 = new Q3ButtonGroup(QG_DlgText);
        buttonGroup5->setObjectName(QString::fromUtf8("buttonGroup5"));
        buttonGroup5->setColumnLayout(0, Qt::Vertical);
        buttonGroup5->layout()->setSpacing(6);
        buttonGroup5->layout()->setContentsMargins(11, 11, 11, 11);
        gridLayout2 = new QGridLayout();
        QBoxLayout *boxlayout4 = qobject_cast<QBoxLayout *>(buttonGroup5->layout());
        if (boxlayout4)
            boxlayout4->addLayout(gridLayout2);
        gridLayout2->setAlignment(Qt::AlignTop);
        gridLayout2->setObjectName(QString::fromUtf8("gridLayout2"));
        textLabel1 = new QLabel(buttonGroup5);
        textLabel1->setObjectName(QString::fromUtf8("textLabel1"));
        textLabel1->setWordWrap(false);

        gridLayout2->addWidget(textLabel1, 0, 0, 1, 1);

        textLabel1_2 = new QLabel(buttonGroup5);
        textLabel1_2->setObjectName(QString::fromUtf8("textLabel1_2"));
        textLabel1_2->setWordWrap(false);

        gridLayout2->addWidget(textLabel1_2, 1, 0, 1, 1);

        cbUniPage = new QComboBox(buttonGroup5);
        cbUniPage->setObjectName(QString::fromUtf8("cbUniPage"));
        sizePolicy5.setHeightForWidth(cbUniPage->sizePolicy().hasHeightForWidth());
        cbUniPage->setSizePolicy(sizePolicy5);
        cbUniPage->setMinimumSize(QSize(280, 0));

        gridLayout2->addWidget(cbUniPage, 0, 1, 1, 1);

        cbUniChar = new QComboBox(buttonGroup5);
        cbUniChar->setObjectName(QString::fromUtf8("cbUniChar"));
        sizePolicy5.setHeightForWidth(cbUniChar->sizePolicy().hasHeightForWidth());
        cbUniChar->setSizePolicy(sizePolicy5);
        cbUniChar->setMinimumSize(QSize(92, 0));

        gridLayout2->addWidget(cbUniChar, 1, 1, 1, 1);

        bUnicode = new QToolButton(buttonGroup5);
        bUnicode->setObjectName(QString::fromUtf8("bUnicode"));
        sizePolicy3.setHeightForWidth(bUnicode->sizePolicy().hasHeightForWidth());
        bUnicode->setSizePolicy(sizePolicy3);
        bUnicode->setMinimumSize(QSize(25, 25));
        bUnicode->setMaximumSize(QSize(25, 25));

        gridLayout2->addWidget(bUnicode, 0, 2, 1, 1);


        hboxLayout3->addWidget(buttonGroup5);


        vboxLayout->addLayout(hboxLayout3);

        hboxLayout4 = new QHBoxLayout();
        hboxLayout4->setSpacing(6);
        hboxLayout4->setContentsMargins(0, 0, 0, 0);
        hboxLayout4->setObjectName(QString::fromUtf8("hboxLayout4"));
        Horizontal_Spacing2 = new QSpacerItem(20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum);

        hboxLayout4->addItem(Horizontal_Spacing2);

        buttonOk = new QPushButton(QG_DlgText);
        buttonOk->setObjectName(QString::fromUtf8("buttonOk"));
        buttonOk->setAutoDefault(true);
        buttonOk->setDefault(true);

        hboxLayout4->addWidget(buttonOk);

        buttonCancel = new QPushButton(QG_DlgText);
        buttonCancel->setObjectName(QString::fromUtf8("buttonCancel"));
        buttonCancel->setAutoDefault(true);

        hboxLayout4->addWidget(buttonCancel);


        vboxLayout->addLayout(hboxLayout4);

#ifndef QT_NO_SHORTCUT
        lHeight->setBuddy(leHeight);
        lLineSpacingFactor->setBuddy(leLineSpacingFactor);
#endif // QT_NO_SHORTCUT

        retranslateUi(QG_DlgText);
        QObject::connect(buttonOk, SIGNAL(clicked()), QG_DlgText, SLOT(accept()));
        QObject::connect(buttonCancel, SIGNAL(clicked()), QG_DlgText, SLOT(reject()));
        QObject::connect(bTL, SIGNAL(clicked()), QG_DlgText, SLOT(setAlignmentTL()));
        QObject::connect(bTC, SIGNAL(clicked()), QG_DlgText, SLOT(setAlignmentTC()));
        QObject::connect(bTR, SIGNAL(clicked()), QG_DlgText, SLOT(setAlignmentTR()));
        QObject::connect(bML, SIGNAL(clicked()), QG_DlgText, SLOT(setAlignmentML()));
        QObject::connect(bMC, SIGNAL(clicked()), QG_DlgText, SLOT(setAlignmentMC()));
        QObject::connect(bMR, SIGNAL(clicked()), QG_DlgText, SLOT(setAlignmentMR()));
        QObject::connect(bBL, SIGNAL(clicked()), QG_DlgText, SLOT(setAlignmentBL()));
        QObject::connect(bBC, SIGNAL(clicked()), QG_DlgText, SLOT(setAlignmentBC()));
        QObject::connect(bBR, SIGNAL(clicked()), QG_DlgText, SLOT(setAlignmentBR()));
        QObject::connect(cbDefault, SIGNAL(toggled(bool)), leLineSpacingFactor, SLOT(setDisabled(bool)));
        QObject::connect(cbDefault, SIGNAL(toggled(bool)), QG_DlgText, SLOT(defaultChanged(bool)));
        QObject::connect(bClear, SIGNAL(clicked()), teText, SLOT(clear()));
        QObject::connect(bCut, SIGNAL(clicked()), teText, SLOT(cut()));
        QObject::connect(bCopy, SIGNAL(clicked()), teText, SLOT(copy()));
        QObject::connect(bPaste, SIGNAL(clicked()), teText, SLOT(paste()));
        QObject::connect(bLoad, SIGNAL(clicked()), QG_DlgText, SLOT(loadText()));
        QObject::connect(bSave, SIGNAL(clicked()), QG_DlgText, SLOT(saveText()));
        QObject::connect(cbUniPage, SIGNAL(activated(int)), QG_DlgText, SLOT(updateUniCharComboBox(int)));
        QObject::connect(bUnicode, SIGNAL(clicked()), QG_DlgText, SLOT(insertChar()));
        QObject::connect(cbUniPage, SIGNAL(activated(int)), QG_DlgText, SLOT(updateUniCharButton(int)));
        QObject::connect(cbUniChar, SIGNAL(activated(int)), QG_DlgText, SLOT(updateUniCharButton(int)));
        QObject::connect(cbSymbol, SIGNAL(activated(int)), QG_DlgText, SLOT(insertSymbol(int)));

        QMetaObject::connectSlotsByName(QG_DlgText);
    } // setupUi

    void retranslateUi(QDialog *QG_DlgText)
    {
        QG_DlgText->setWindowTitle(QApplication::translate("QG_DlgText", "Text", 0, QApplication::UnicodeUTF8));
        bgFont->setTitle(QApplication::translate("QG_DlgText", "Font", 0, QApplication::UnicodeUTF8));
        lHeight->setText(QApplication::translate("QG_DlgText", "&Height:", 0, QApplication::UnicodeUTF8));
        lLineSpacingFactor->setText(QApplication::translate("QG_DlgText", "Line &spacing:", 0, QApplication::UnicodeUTF8));
        cbDefault->setText(QApplication::translate("QG_DlgText", "&Default line spacing", 0, QApplication::UnicodeUTF8));
        cbDefault->setShortcut(QApplication::translate("QG_DlgText", "Alt+D", 0, QApplication::UnicodeUTF8));
        bgAlignment->setTitle(QApplication::translate("QG_DlgText", "Alignment", 0, QApplication::UnicodeUTF8));
        bTR->setText(QString());
#ifndef QT_NO_TOOLTIP
        bTR->setProperty("toolTip", QVariant(QApplication::translate("QG_DlgText", "Top Right", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bTL->setText(QString());
#ifndef QT_NO_TOOLTIP
        bTL->setProperty("toolTip", QVariant(QApplication::translate("QG_DlgText", "Top Left", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bML->setText(QString());
#ifndef QT_NO_TOOLTIP
        bML->setProperty("toolTip", QVariant(QApplication::translate("QG_DlgText", "Middle Left", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bMC->setText(QString());
#ifndef QT_NO_TOOLTIP
        bMC->setProperty("toolTip", QVariant(QApplication::translate("QG_DlgText", "Middle Center", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bMR->setText(QString());
#ifndef QT_NO_TOOLTIP
        bMR->setProperty("toolTip", QVariant(QApplication::translate("QG_DlgText", "Middle Right", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bBL->setText(QString());
#ifndef QT_NO_TOOLTIP
        bBL->setProperty("toolTip", QVariant(QApplication::translate("QG_DlgText", "Bottom Left", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bBR->setText(QString());
#ifndef QT_NO_TOOLTIP
        bBR->setProperty("toolTip", QVariant(QApplication::translate("QG_DlgText", "Bottom Right", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bBC->setText(QString());
#ifndef QT_NO_TOOLTIP
        bBC->setProperty("toolTip", QVariant(QApplication::translate("QG_DlgText", "Bottom Center", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bTC->setText(QString());
#ifndef QT_NO_TOOLTIP
        bTC->setProperty("toolTip", QVariant(QApplication::translate("QG_DlgText", "Top Center", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bgShape->setTitle(QApplication::translate("QG_DlgText", "Angle", 0, QApplication::UnicodeUTF8));
        lText->setText(QApplication::translate("QG_DlgText", "Text:", 0, QApplication::UnicodeUTF8));
        bClear->setText(QString());
#ifndef QT_NO_TOOLTIP
        bClear->setProperty("toolTip", QVariant(QApplication::translate("QG_DlgText", "Clear Text", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bLoad->setText(QString());
#ifndef QT_NO_TOOLTIP
        bLoad->setProperty("toolTip", QVariant(QApplication::translate("QG_DlgText", "Load Text From File", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bSave->setText(QString());
#ifndef QT_NO_TOOLTIP
        bSave->setProperty("toolTip", QVariant(QApplication::translate("QG_DlgText", "Save Text To File", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bCut->setText(QString());
#ifndef QT_NO_TOOLTIP
        bCut->setProperty("toolTip", QVariant(QApplication::translate("QG_DlgText", "Cut", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bCopy->setText(QString());
#ifndef QT_NO_TOOLTIP
        bCopy->setProperty("toolTip", QVariant(QApplication::translate("QG_DlgText", "Copy", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bPaste->setText(QString());
#ifndef QT_NO_TOOLTIP
        bPaste->setProperty("toolTip", QVariant(QApplication::translate("QG_DlgText", "Paste", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        buttonGroup7->setTitle(QApplication::translate("QG_DlgText", "Insert Symbol", 0, QApplication::UnicodeUTF8));
        cbSymbol->clear();
        cbSymbol->insertItems(0, QStringList()
         << QApplication::translate("QG_DlgText", "Diameter (\303\270)", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "Degree (\302\260)", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "Plus / Minus (\302\261)", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "At (@)", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "Hash (#)", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "Dollar ($)", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "Copyright (\302\251)", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "Registered (\302\256)", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "Paragraph (\302\247)", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "Pi (π)", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "Pound (\302\243)", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "Yen (\302\245)", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "Times (\303\227)", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "Division (\303\267)", 0, QApplication::UnicodeUTF8)
        );
        buttonGroup5->setTitle(QApplication::translate("QG_DlgText", "Insert Unicode", 0, QApplication::UnicodeUTF8));
        textLabel1->setText(QApplication::translate("QG_DlgText", "Page:", 0, QApplication::UnicodeUTF8));
        textLabel1_2->setText(QApplication::translate("QG_DlgText", "Char:", 0, QApplication::UnicodeUTF8));
        cbUniPage->clear();
        cbUniPage->insertItems(0, QStringList()
         << QApplication::translate("QG_DlgText", "[0000-007F] Basic Latin", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[0080-00FF] Latin-1 Supplementary", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[0100-017F] Latin Extended-A", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[0180-024F] Latin Extended-B", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[0250-02AF] IPA Extensions", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[02B0-02FF] Spacing Modifier Letters", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[0300-036F] Combining Diacritical Marks", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[0370-03FF] Greek and Coptic", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[0400-04FF] Cyrillic", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[0500-052F] Cyrillic Supplementary", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[0530-058F] Armenian", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[0590-05FF] Hebrew", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[0600-06FF] Arabic", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[0700-074F] Syriac", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[0780-07BF] Thaana", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[0900-097F] Devanagari", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[0980-09FF] Bengali", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[0A00-0A7F] Gurmukhi", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[0A80-0AFF] Gujarati", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[0B00-0B7F] Oriya", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[0B80-0BFF] Tamil", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[0C00-0C7F] Telugu", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[0C80-0CFF] Kannada", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[0D00-0D7F] Malayalam", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[0D80-0DFF] Sinhala", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[0E00-0E7F] Thai", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[0E80-0EFF] Lao", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[0F00-0FFF] Tibetan", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[1000-109F] Myanmar", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[10A0-10FF] Georgian", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[1100-11FF] Hangul Jamo", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[1200-137F] Ethiopic", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[13A0-13FF] Cherokee", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[1400-167F] Unified Canadian Aboriginal Syllabic", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[1680-169F] Ogham", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[16A0-16FF] Runic", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[1700-171F] Tagalog", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[1720-173F] Hanunoo", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[1740-175F] Buhid", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[1760-177F] Tagbanwa", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[1780-17FF] Khmer", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[1800-18AF] Mongolian", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[1E00-1EFF] Latin Extended Additional", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[1F00-1FFF] Greek Extended", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[2000-206F] General Punctuation", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[2070-209F] Superscripts and Subscripts", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[20A0-20CF] Currency Symbols", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[20D0-20FF] Combining Marks for Symbols", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[2100-214F] Letterlike Symbols", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[2150-218F] Number Forms", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[2190-21FF] Arrows", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[2200-22FF] Mathematical Operators", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[2300-23FF] Miscellaneous Technical", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[2400-243F] Control Pictures", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[2440-245F] Optical Character Recognition", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[2460-24FF] Enclosed Alphanumerics", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[2500-257F] Box Drawing", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[2580-259F] Block Elements", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[25A0-25FF] Geometric Shapes", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[2600-26FF] Miscellaneous Symbols", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[2700-27BF] Dingbats", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[27C0-27EF] Miscellaneous Mathematical Symbols-A", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[27F0-27FF] Supplemental Arrows-A", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[2800-28FF] Braille Patterns", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[2900-297F] Supplemental Arrows-B", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[2980-29FF] Miscellaneous Mathematical Symbols-B", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[2A00-2AFF] Supplemental Mathematical Operators", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[2E80-2EFF] CJK Radicals Supplement", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[2F00-2FDF] Kangxi Radicals", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[2FF0-2FFF] Ideographic Description Characters", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[3000-303F] CJK Symbols and Punctuation", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[3040-309F] Hiragana", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[30A0-30FF] Katakana", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[3100-312F] Bopomofo", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[3130-318F] Hangul Compatibility Jamo", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[3190-319F] Kanbun", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[31A0-31BF] Bopomofo Extended", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[3200-32FF] Enclosed CJK Letters and Months", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[3300-33FF] CJK Compatibility", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[3400-4DBF] CJK Unified Ideographs Extension A", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[4E00-9FAF] CJK Unified Ideographs", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[A000-A48F] Yi Syllables", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[A490-A4CF] Yi Radicals", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[AC00-D7AF] Hangul Syllables", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[D800-DBFF] High Surrogates", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[DC00-DFFF] Low Surrogate Area", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[E000-F8FF] Private Use Area", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[F900-FAFF] CJK Compatibility Ideographs", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[FB00-FB4F] Alphabetic Presentation Forms", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[FB50-FDFF] Arabic Presentation Forms-A", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[FE00-FE0F] Variation Selectors", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[FE20-FE2F] Combining Half Marks", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[FE30-FE4F] CJK Compatibility Forms", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[FE50-FE6F] Small Form Variants", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[FE70-FEFF] Arabic Presentation Forms-B", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[FF00-FFEF] Halfwidth and Fullwidth Forms", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[FFF0-FFFF] Specials", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[10300-1032F] Old Italic", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[10330-1034F] Gothic", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[10400-1044F] Deseret", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[1D000-1D0FF] Byzantine Musical Symbols", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[1D100-1D1FF] Musical Symbols", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[1D400-1D7FF] Mathematical Alphanumeric Symbols", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[20000-2A6DF] CJK Unified Ideographs Extension B", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[2F800-2FA1F] CJK Compatibility Ideographs Supplement", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[E0000-E007F] Tags", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[F0000-FFFFD] Supplementary Private Use Area-A", 0, QApplication::UnicodeUTF8)
         << QApplication::translate("QG_DlgText", "[100000-10FFFD] Supplementary Private Use Area-B", 0, QApplication::UnicodeUTF8)
        );
        bUnicode->setText(QString());
        buttonOk->setText(QApplication::translate("QG_DlgText", "&OK", 0, QApplication::UnicodeUTF8));
        buttonCancel->setText(QApplication::translate("QG_DlgText", "Cancel", 0, QApplication::UnicodeUTF8));
        buttonCancel->setShortcut(QApplication::translate("QG_DlgText", "Esc", 0, QApplication::UnicodeUTF8));
    } // retranslateUi


protected:
    enum IconID
    {
        image0_ID,
        image1_ID,
        image2_ID,
        image3_ID,
        image4_ID,
        image5_ID,
        image6_ID,
        image7_ID,
        image8_ID,
        image9_ID,
        image10_ID,
        image11_ID,
        image12_ID,
        image13_ID,
        image14_ID,
        image15_ID,
        unknown_ID
    };
    static QPixmap qt_get_icon(IconID id)
    {
    static const unsigned char image0_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x0f,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x3b, 0xd6, 0x95, 0x4a, 0x00, 0x00, 0x00,
    0x66, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xc5, 0x92, 0x41, 0x0a, 0x80,
    0x40, 0x0c, 0x03, 0x27, 0xb2, 0x9f, 0xb2, 0xff, 0x27, 0x3e, 0xab, 0x1e,
    0xc4, 0xa5, 0x08, 0x82, 0xbb, 0x1e, 0x36, 0xa7, 0x16, 0x32, 0x21, 0x85,
    0xca, 0x36, 0xb3, 0xda, 0xa6, 0xc9, 0xa5, 0xb0, 0x20, 0x73, 0x04, 0x48,
    0xd4, 0xe7, 0x46, 0x59, 0xaa, 0x6c, 0x0b, 0x20, 0x22, 0x5e, 0xc3, 0x5b,
    0x35, 0xdd, 0xf3, 0x5b, 0x10, 0x97, 0xb1, 0x87, 0x0d, 0xdf, 0x7c, 0xd8,
    0x12, 0x20, 0x92, 0xf6, 0x05, 0x78, 0x56, 0xb7, 0xad, 0x08, 0xf2, 0x13,
    0x5c, 0x6b, 0xc7, 0x9f, 0xda, 0x35, 0x60, 0x18, 0xae, 0x2d, 0x34, 0xfb,
    0xdb, 0x11, 0x7b, 0xae, 0x7b, 0xcf, 0x13, 0x9d, 0xa8, 0x28, 0x54, 0x62,
    0x3c, 0xa0, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae,
    0x42, 0x60, 0x82
};

    static const unsigned char image1_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x0f,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x3b, 0xd6, 0x95, 0x4a, 0x00, 0x00, 0x00,
    0x5e, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xc5, 0x91, 0x4b, 0x0e, 0x80,
    0x20, 0x0c, 0x44, 0x19, 0xc3, 0xa5, 0x9c, 0xfb, 0xe7, 0x71, 0xac, 0xba,
    0x51, 0x49, 0x40, 0xa2, 0xc1, 0x05, 0xb3, 0x6a, 0x9b, 0x79, 0x4d, 0x3f,
    0x02, 0xd2, 0xac, 0xb6, 0x69, 0xf2, 0x2f, 0xac, 0x48, 0x29, 0xae, 0xa4,
    0x80, 0xa6, 0x61, 0xd5, 0xf0, 0x93, 0x72, 0xd3, 0xab, 0x33, 0x70, 0x4e,
    0x63, 0x3b, 0x68, 0x26, 0xcb, 0x05, 0x64, 0xef, 0x01, 0x45, 0x0c, 0x4c,
    0x23, 0xad, 0xbb, 0xf6, 0x3a, 0x38, 0xbf, 0x5b, 0xaa, 0x6c, 0xdf, 0xbf,
    0x04, 0xd4, 0xc1, 0xa3, 0x4b, 0x3f, 0xd5, 0xd7, 0xed, 0x7c, 0x00, 0x9f,
    0xe3, 0x23, 0xda, 0xc4, 0xec, 0x15, 0x22, 0x00, 0x00, 0x00, 0x00, 0x49,
    0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

    static const unsigned char image2_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x0f,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x3b, 0xd6, 0x95, 0x4a, 0x00, 0x00, 0x00,
    0x5f, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xe5, 0x92, 0x41, 0x0a, 0xc0,
    0x30, 0x10, 0x02, 0xdd, 0x92, 0x4f, 0xd5, 0xff, 0x33, 0x79, 0xd6, 0xf6,
    0x14, 0x48, 0x42, 0x29, 0x0d, 0xb9, 0x14, 0xea, 0x51, 0x59, 0x15, 0xd9,
    0x00, 0x64, 0x9f, 0x09, 0x35, 0xb4, 0x88, 0x63, 0xf5, 0xe0, 0x63, 0xc7,
    0xb6, 0xd3, 0x76, 0xf6, 0xe2, 0xcc, 0xcd, 0xfa, 0x56, 0x72, 0x39, 0xed,
    0x6c, 0x76, 0xab, 0x73, 0x0f, 0xc9, 0x40, 0xb4, 0x6a, 0xb6, 0x13, 0x78,
    0xf4, 0xdb, 0x1b, 0xac, 0x42, 0x84, 0x72, 0xa8, 0xfc, 0x26, 0x55, 0x92,
    0xca, 0x4c, 0xf4, 0xd5, 0xef, 0xd0, 0x6b, 0xf1, 0xc3, 0xf7, 0xbc, 0x00,
    0x02, 0xab, 0x2c, 0xd4, 0x18, 0x0a, 0x8a, 0x6a, 0x00, 0x00, 0x00, 0x00,
    0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

    static const unsigned char image3_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x0f,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x3b, 0xd6, 0x95, 0x4a, 0x00, 0x00, 0x00,
    0x63, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xe5, 0x92, 0x51, 0x0a, 0x80,
    0x30, 0x0c, 0x43, 0x13, 0xd9, 0xa9, 0x7a, 0x7f, 0xde, 0x8e, 0x35, 0xbf,
    0x8a, 0x73, 0x32, 0x94, 0x21, 0xf8, 0x61, 0xfe, 0xd2, 0x36, 0x6d, 0x5a,
    0x6a, 0x40, 0xab, 0xd8, 0x96, 0x95, 0x9f, 0x8a, 0x8b, 0x24, 0x45, 0x44,
    0x93, 0x24, 0xc0, 0x99, 0x18, 0x63, 0xc9, 0x13, 0x80, 0xcb, 0x93, 0x09,
    0xb3, 0xe6, 0x53, 0x71, 0x3b, 0xaa, 0x2e, 0xc2, 0xe4, 0x5b, 0x4f, 0x72,
    0xc2, 0x68, 0x71, 0x86, 0x77, 0xaf, 0x1d, 0x11, 0x0d, 0x70, 0x05, 0x5b,
    0x52, 0x1d, 0xec, 0xf6, 0x75, 0xa7, 0x9d, 0x7b, 0xeb, 0x77, 0x71, 0xc0,
    0xfe, 0xe1, 0x7b, 0xee, 0x1e, 0x1b, 0x37, 0xe4, 0x7b, 0xfa, 0x35, 0x7b,
    0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

    static const unsigned char image4_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x0f,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x3b, 0xd6, 0x95, 0x4a, 0x00, 0x00, 0x00,
    0x70, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xe5, 0x52, 0x49, 0x0e, 0x80,
    0x20, 0x10, 0xeb, 0x18, 0x3f, 0x45, 0xff, 0x9f, 0xf2, 0xac, 0x7a, 0x70,
    0x1b, 0x88, 0x46, 0x39, 0x79, 0xb0, 0x49, 0x03, 0x99, 0xd0, 0x0e, 0xb3,
    0x84, 0x24, 0x8c, 0x82, 0x2c, 0x96, 0x6a, 0x4c, 0xc3, 0xca, 0x84, 0xef,
    0xc4, 0x01, 0xc0, 0x00, 0x20, 0x29, 0xf6, 0x20, 0xc9, 0x23, 0xb6, 0xdf,
    0x5b, 0x18, 0x52, 0x8d, 0xf9, 0x4d, 0x86, 0x6c, 0xbc, 0x9a, 0x87, 0x01,
    0xe1, 0x95, 0x38, 0xa3, 0x90, 0xf6, 0xea, 0x60, 0x00, 0xf0, 0x36, 0xae,
    0xdb, 0x33, 0xd3, 0x89, 0xe3, 0xdf, 0x4e, 0x3d, 0x68, 0xba, 0x4d, 0xd2,
    0x7d, 0x7d, 0x3d, 0x62, 0x63, 0x95, 0xce, 0x25, 0x79, 0x12, 0x5d, 0xbd,
    0x8b, 0x1f, 0xae, 0xe7, 0x02, 0x30, 0xb8, 0x47, 0xbd, 0xaf, 0x4d, 0x66,
    0xe8, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60,
    0x82
};

    static const unsigned char image5_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x0f,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x3b, 0xd6, 0x95, 0x4a, 0x00, 0x00, 0x00,
    0x61, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xcd, 0x92, 0x51, 0x0a, 0x80,
    0x30, 0x0c, 0x43, 0x1b, 0xf1, 0x52, 0xf6, 0xfe, 0xc4, 0x63, 0xd5, 0xaf,
    0x49, 0xec, 0x06, 0xae, 0x28, 0x62, 0xbe, 0x36, 0xba, 0x47, 0xde, 0xc6,
    0x40, 0xd2, 0xdc, 0xb7, 0x20, 0x77, 0x58, 0x31, 0x4b, 0x15, 0xf8, 0x07,
    0xbc, 0xb6, 0x85, 0xbb, 0x87, 0x0e, 0x48, 0x42, 0x67, 0xba, 0xef, 0xe0,
    0x59, 0x40, 0xf3, 0x8e, 0x76, 0x6b, 0x1b, 0x59, 0x4c, 0xc1, 0x9f, 0x6a,
    0x23, 0xcc, 0x4e, 0x55, 0xad, 0xc9, 0x16, 0x23, 0xc3, 0x04, 0x5f, 0xce,
    0xdc, 0x26, 0xdd, 0xb9, 0xf6, 0xbf, 0x41, 0xb2, 0xd4, 0xa6, 0x79, 0xf4,
    0x60, 0x07, 0xd2, 0xa2, 0x2f, 0x13, 0x70, 0x70, 0x93, 0xd8, 0x00, 0x00,
    0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

    static const unsigned char image6_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x0f,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x3b, 0xd6, 0x95, 0x4a, 0x00, 0x00, 0x00,
    0x75, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xc5, 0x93, 0x51, 0x0a, 0x80,
    0x30, 0x0c, 0x43, 0x53, 0xf1, 0x52, 0xe6, 0xfe, 0x64, 0xc7, 0xaa, 0x1f,
    0xa2, 0x96, 0x3a, 0x95, 0xaa, 0x60, 0xfe, 0x96, 0x92, 0xf4, 0x41, 0x99,
    0x49, 0x42, 0x55, 0xe4, 0xe4, 0x52, 0xb3, 0xa1, 0x9c, 0x0c, 0xfa, 0x2f,
    0x3c, 0x02, 0x00, 0x49, 0x8f, 0xa6, 0x24, 0xeb, 0xf9, 0x71, 0xb6, 0x85,
    0xb3, 0x49, 0xd2, 0xd7, 0x77, 0xf4, 0xf7, 0x42, 0xff, 0x08, 0x3b, 0x23,
    0x66, 0x8a, 0x8c, 0x4d, 0x2e, 0xab, 0x4b, 0xd8, 0xb9, 0xa8, 0x8c, 0x1d,
    0x0b, 0x6e, 0xb1, 0x33, 0xf2, 0x44, 0x3a, 0x60, 0x00, 0xe1, 0x06, 0xf8,
    0xe1, 0x1c, 0x57, 0x72, 0xec, 0xbd, 0xa3, 0xd4, 0xba, 0x5b, 0xce, 0xb9,
    0xb1, 0x2d, 0xb3, 0x27, 0x1f, 0x63, 0xd5, 0xab, 0x3b, 0xcf, 0x4f, 0xbe,
    0x41, 0x55, 0x1f, 0xe2, 0x4c, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45,
    0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

    static const unsigned char image7_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x0f,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x3b, 0xd6, 0x95, 0x4a, 0x00, 0x00, 0x00,
    0x6f, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xc5, 0x93, 0x41, 0x0e, 0x80,
    0x20, 0x0c, 0x04, 0xb7, 0x86, 0x4f, 0xd9, 0xff, 0x67, 0x7d, 0x56, 0x3d,
    0x18, 0xe2, 0x6a, 0x5a, 0x54, 0x2e, 0xf6, 0x44, 0xd8, 0x4e, 0x98, 0x42,
    0x30, 0x92, 0x98, 0xad, 0x65, 0x9a, 0xfc, 0x15, 0x6e, 0x00, 0xe0, 0xee,
    0xa1, 0x9b, 0x24, 0xad, 0xaf, 0x47, 0x59, 0xab, 0x00, 0x92, 0xd6, 0xc1,
    0x2c, 0x7b, 0xa5, 0xad, 0x60, 0x79, 0xb2, 0xea, 0xdd, 0x81, 0xaa, 0x86,
    0xda, 0x4f, 0xf0, 0xe7, 0xdb, 0x56, 0xc3, 0x52, 0x7b, 0x75, 0x8f, 0x38,
    0x82, 0x50, 0x05, 0x35, 0x32, 0x20, 0x2e, 0x4f, 0xd1, 0x2b, 0x70, 0x22,
    0x86, 0xb4, 0x05, 0x8d, 0xdc, 0xf2, 0xd9, 0x1c, 0x62, 0x92, 0xf7, 0xd8,
    0x6f, 0x1f, 0x63, 0x07, 0x27, 0x03, 0x40, 0x16, 0x4b, 0x20, 0x09, 0x23,
    0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

    static const unsigned char image8_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x0f,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x3b, 0xd6, 0x95, 0x4a, 0x00, 0x00, 0x00,
    0x69, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xc5, 0x51, 0x41, 0x0e, 0xc0,
    0x20, 0x08, 0xa3, 0x8b, 0x9f, 0x1a, 0xff, 0x4f, 0x7d, 0x16, 0xbb, 0x8c,
    0x84, 0x29, 0x26, 0x1b, 0x3b, 0xd8, 0x93, 0x42, 0x0b, 0xa4, 0x05, 0x49,
    0xa9, 0xe2, 0x28, 0x2b, 0xff, 0x8a, 0xdb, 0xaa, 0x71, 0xaa, 0x9a, 0xbf,
    0x3b, 0x89, 0x8c, 0x03, 0x11, 0xb3, 0xac, 0x61, 0x82, 0x40, 0x4a, 0x29,
    0xd2, 0xc8, 0x0e, 0x0d, 0x5b, 0x72, 0x3c, 0x17, 0xf3, 0xbe, 0x04, 0xd1,
    0x6d, 0x55, 0x35, 0x0e, 0x27, 0xfa, 0xe0, 0x58, 0x77, 0xde, 0x2b, 0xc3,
    0xc6, 0x81, 0xfe, 0xdf, 0x17, 0x55, 0x49, 0xec, 0x3e, 0x2c, 0x73, 0x76,
    0x90, 0x9c, 0xd2, 0x48, 0xdd, 0xfe, 0x8a, 0x7d, 0x86, 0x5d, 0x61, 0xe0,
    0x2e, 0x10, 0xe4, 0x88, 0xf2, 0x7d, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45,
    0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

    static const unsigned char image9_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x1f, 0xf3, 0xff, 0x61, 0x00, 0x00, 0x01,
    0xdd, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0x8d, 0x93, 0xbd, 0x6a, 0x55,
    0x41, 0x10, 0xc7, 0x7f, 0xb3, 0x67, 0xf7, 0x28, 0x18, 0x44, 0x24, 0x82,
    0x56, 0x56, 0xa2, 0x4d, 0x7c, 0x01, 0x9b, 0x54, 0xe2, 0x03, 0xd8, 0x5a,
    0xf9, 0x04, 0x3e, 0x80, 0x8d, 0x45, 0xc0, 0x5a, 0xb0, 0xb1, 0xb4, 0x11,
    0x04, 0x5b, 0xb5, 0xb0, 0x92, 0x40, 0x08, 0x1a, 0x3f, 0x90, 0x34, 0x26,
    0x51, 0x50, 0x50, 0xf1, 0x92, 0xfb, 0xed, 0xfd, 0xd8, 0xdd, 0x19, 0x8b,
    0x73, 0x4e, 0x3c, 0x68, 0x72, 0x71, 0x60, 0x61, 0x77, 0x76, 0xf7, 0xb7,
    0x33, 0xfb, 0x9f, 0x91, 0xf5, 0xcd, 0xed, 0xce, 0xa9, 0x93, 0x4b, 0xc7,
    0xd4, 0x8c, 0xc6, 0xd4, 0x60, 0x3a, 0x9d, 0x11, 0xe7, 0x91, 0xce, 0x7e,
    0xdf, 0xa5, 0xa8, 0xdd, 0x5e, 0x7f, 0x7c, 0xed, 0xe6, 0x8d, 0xab, 0x1f,
    0xf8, 0xdb, 0x5e, 0xbd, 0xdd, 0x99, 0xa8, 0xaa, 0xb5, 0x47, 0xce, 0xd9,
    0xc6, 0x93, 0x68, 0x83, 0x61, 0xb4, 0x37, 0xef, 0xf7, 0xec, 0xe3, 0xee,
    0x37, 0x7b, 0xf6, 0x62, 0xeb, 0xe7, 0x83, 0x87, 0x4f, 0x57, 0xcd, 0x8c,
    0xf6, 0x70, 0xff, 0x10, 0x01, 0x11, 0xc1, 0x39, 0x10, 0xa7, 0xb8, 0xc2,
    0x71, 0xf6, 0xdc, 0x32, 0xab, 0x57, 0x56, 0x96, 0x2f, 0x5d, 0x38, 0xff,
    0xfc, 0xd1, 0x93, 0x97, 0xd7, 0xdb, 0x67, 0x0f, 0x05, 0x18, 0x20, 0x40,
    0x59, 0x7a, 0x3e, 0x7d, 0xfe, 0xc2, 0xc6, 0xc6, 0x16, 0xaf, 0xdf, 0x6d,
    0x93, 0xe2, 0xb4, 0x1c, 0x0e, 0x7a, 0x8f, 0x6f, 0xdf, 0xb9, 0x7f, 0x6b,
    0x21, 0x00, 0x40, 0x9c, 0xe0, 0x04, 0xce, 0x2c, 0x9f, 0x66, 0x1e, 0x8d,
    0x1f, 0xdf, 0xbb, 0xec, 0xec, 0x7e, 0xa5, 0x3c, 0x5e, 0x32, 0x1c, 0xf5,
    0xd6, 0x9a, 0x73, 0xfe, 0xd0, 0xcb, 0x80, 0x13, 0x21, 0x45, 0xe5, 0xf2,
    0xca, 0x45, 0x66, 0xd3, 0xc8, 0x7e, 0xb7, 0x4f, 0x67, 0xbf, 0x47, 0x08,
    0x25, 0x9b, 0x1b, 0xeb, 0x2c, 0x04, 0x98, 0x19, 0x39, 0x2b, 0x89, 0x4c,
    0xaf, 0xf7, 0x8b, 0xd1, 0x68, 0xca, 0x6c, 0x36, 0xa7, 0x0c, 0x81, 0x10,
    0x3c, 0x45, 0x51, 0x2c, 0x06, 0x24, 0x35, 0x86, 0xa3, 0x39, 0x29, 0x25,
    0x34, 0x1b, 0x65, 0x19, 0x10, 0x07, 0xaa, 0x4a, 0xf0, 0x01, 0x11, 0x8e,
    0x06, 0xc4, 0xac, 0x4c, 0x26, 0x91, 0xac, 0x55, 0x32, 0xae, 0x10, 0x3c,
    0x0e, 0x91, 0x92, 0x9c, 0x13, 0x21, 0x84, 0x3a, 0xc9, 0x06, 0x50, 0xcf,
    0xa7, 0x31, 0x23, 0x40, 0x4c, 0xb9, 0x56, 0xc0, 0xa1, 0x19, 0xc4, 0x41,
    0x12, 0x45, 0xb2, 0x02, 0x9e, 0xc2, 0x7b, 0xa4, 0x15, 0x82, 0x6f, 0x64,
    0x48, 0x49, 0x0f, 0x42, 0x93, 0x42, 0x20, 0x19, 0x82, 0x54, 0x35, 0x21,
    0x82, 0x15, 0xe0, 0x14, 0x0a, 0x81, 0x4a, 0xe8, 0xca, 0x9c, 0xb6, 0x7f,
    0x1e, 0x2a, 0x48, 0xe3, 0xac, 0xe9, 0xae, 0x70, 0x08, 0x0e, 0x11, 0xa9,
    0x5f, 0xff, 0x13, 0xc1, 0x91, 0x75, 0xf0, 0xbf, 0xe6, 0x1a, 0x82, 0x69,
    0xd5, 0x44, 0x58, 0x15, 0x60, 0xab, 0xb7, 0x30, 0xad, 0x17, 0x56, 0x49,
    0xdc, 0x4e, 0xc1, 0x37, 0x7b, 0x4b, 0x27, 0xc2, 0x81, 0x53, 0xa1, 0x52,
    0xc1, 0x20, 0x25, 0x23, 0xab, 0x91, 0x72, 0x46, 0x63, 0xc6, 0x87, 0x92,
    0xb6, 0x8e, 0xbe, 0x3f, 0x18, 0x8c, 0xd7, 0xee, 0xde, 0x4b, 0xce, 0xf9,
    0xfa, 0x11, 0x45, 0x70, 0x98, 0x29, 0x66, 0x60, 0x75, 0x67, 0x98, 0x19,
    0x98, 0x21, 0xe2, 0x18, 0x0f, 0x86, 0xb3, 0x06, 0xf0, 0x1b, 0xda, 0xc4,
    0xfd, 0x8b, 0x61, 0x0d, 0x6a, 0xd5, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45,
    0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

    static const unsigned char image10_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x1f, 0xf3, 0xff, 0x61, 0x00, 0x00, 0x02,
    0xeb, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xa5, 0x8f, 0xcb, 0x6b, 0x5c,
    0x65, 0x00, 0x47, 0xcf, 0x7d, 0xcc, 0xcb, 0x99, 0x49, 0x27, 0x36, 0xb1,
    0x9d, 0x18, 0x92, 0x46, 0x0c, 0x38, 0x4d, 0x25, 0xc6, 0x6a, 0x89, 0x82,
    0xa5, 0x12, 0xed, 0x2a, 0x94, 0x0a, 0x82, 0x08, 0xa2, 0xc6, 0x07, 0x88,
    0x22, 0xa2, 0x3b, 0x15, 0x5c, 0xa8, 0x1b, 0xf1, 0x4f, 0x28, 0x88, 0x08,
    0x2a, 0xba, 0xe9, 0x46, 0xbb, 0x10, 0x4a, 0x8b, 0xa2, 0x2d, 0xd8, 0x48,
    0xd3, 0x36, 0x49, 0xb5, 0x29, 0x93, 0xce, 0x24, 0x93, 0x4c, 0x92, 0xc9,
    0x9d, 0x49, 0xe6, 0xbe, 0xbe, 0xfb, 0x3d, 0x5c, 0x08, 0x45, 0x5c, 0xe8,
    0xc2, 0xdf, 0xf6, 0x77, 0xce, 0xe2, 0x58, 0xc6, 0x18, 0xfe, 0xcf, 0xdc,
    0xff, 0x02, 0x66, 0xde, 0x3e, 0x5f, 0xca, 0xd9, 0xd6, 0x87, 0xb9, 0x6c,
    0x7a, 0x7a, 0x6d, 0x23, 0x78, 0xe4, 0xab, 0x53, 0x53, 0xcd, 0xbf, 0xff,
    0xf6, 0xbf, 0xc9, 0x2f, 0xbe, 0xf6, 0xc3, 0xd1, 0x7b, 0xca, 0x85, 0x33,
    0xaf, 0x3e, 0xff, 0xc0, 0x9b, 0xaf, 0xbf, 0x32, 0x31, 0x62, 0x1b, 0xf3,
    0xc1, 0x3f, 0x19, 0xeb, 0xc0, 0x73, 0x57, 0x3f, 0x9b, 0x9c, 0xe8, 0xcf,
    0xf8, 0x81, 0xc6, 0x00, 0x3f, 0x5f, 0x6c, 0xfa, 0x4f, 0x0c, 0xb7, 0xdf,
    0xd9, 0x5f, 0xb0, 0xdf, 0x38, 0xf2, 0xe0, 0xe0, 0x7b, 0xc7, 0x1f, 0x1f,
    0xea, 0xc9, 0x65, 0x1d, 0x84, 0xd0, 0x9c, 0x3e, 0x53, 0xdd, 0xfd, 0xfa,
    0x9b, 0x85, 0xe9, 0xb3, 0xdf, 0x9f, 0xf8, 0xf1, 0x76, 0x42, 0x65, 0xb4,
    0x38, 0x33, 0xf3, 0x42, 0x1f, 0xad, 0x1d, 0xf0, 0x25, 0x1c, 0xbc, 0x2f,
    0x4b, 0xbc, 0xc8, 0xf4, 0x4b, 0x4f, 0x0d, 0x95, 0xc7, 0x2a, 0xbd, 0x04,
    0x01, 0x74, 0xbb, 0x0a, 0x34, 0x4c, 0x3d, 0x36, 0x58, 0xfc, 0xe9, 0xd7,
    0xf5, 0x4f, 0xac, 0xbb, 0xbf, 0x7b, 0xc6, 0xac, 0x4e, 0xd7, 0x00, 0xdc,
    0x74, 0x8a, 0x6e, 0x6f, 0xc9, 0x2e, 0x04, 0x42, 0xe3, 0xcd, 0xb7, 0x19,
    0x33, 0x1d, 0x4e, 0xbe, 0x75, 0xa8, 0x5c, 0x2c, 0x3a, 0xc4, 0x31, 0x48,
    0x09, 0xb6, 0x0d, 0x89, 0x54, 0x6c, 0xb4, 0x25, 0x63, 0x95, 0xbe, 0xc9,
    0x81, 0x72, 0xf3, 0xa4, 0xd5, 0x73, 0xfa, 0x4b, 0x7a, 0xc0, 0x95, 0x0a,
    0xb4, 0x81, 0xf5, 0xcb, 0x5b, 0x8c, 0x17, 0x25, 0x8f, 0x3e, 0x3d, 0x72,
    0xbb, 0x2f, 0x93, 0x81, 0xb4, 0x05, 0x3a, 0xeb, 0xf0, 0xee, 0xa9, 0x3a,
    0x57, 0xaa, 0x92, 0x81, 0x7d, 0x79, 0x0e, 0x8c, 0xdf, 0xfb, 0x51, 0xff,
    0xa8, 0x75, 0xe2, 0xf7, 0xb9, 0x86, 0x72, 0xb5, 0x02, 0xc7, 0x86, 0x28,
    0x93, 0xe3, 0xdb, 0x4b, 0x5b, 0xfc, 0xe6, 0xed, 0x90, 0xc4, 0x09, 0x52,
    0x29, 0x54, 0x02, 0x28, 0xc3, 0xb5, 0x1b, 0x1d, 0xaa, 0x6d, 0x87, 0xa1,
    0xfb, 0x87, 0x69, 0x44, 0x29, 0x7a, 0x1f, 0x1a, 0xec, 0xd9, 0xba, 0xd0,
    0x3c, 0x26, 0xfd, 0x95, 0x59, 0x57, 0x19, 0x8d, 0x6b, 0xc1, 0xf9, 0xb9,
    0x80, 0x7e, 0x93, 0xa2, 0xbf, 0x94, 0x22, 0x72, 0x32, 0xb4, 0x43, 0x4d,
    0x67, 0x57, 0xe3, 0x75, 0x0d, 0xf9, 0xa1, 0x02, 0x87, 0x2a, 0x79, 0xae,
    0xd4, 0x20, 0x0c, 0x35, 0xde, 0x92, 0xa7, 0xeb, 0xe7, 0xe6, 0x6d, 0x4c,
    0x74, 0xd6, 0xd5, 0xca, 0xd0, 0xee, 0x42, 0xb3, 0xd6, 0xe5, 0xd3, 0xf7,
    0x47, 0x08, 0x62, 0x49, 0x6a, 0x5f, 0x8a, 0x6b, 0x75, 0x8b, 0xed, 0x3f,
    0x0c, 0x1b, 0x4d, 0x43, 0x7d, 0xdd, 0xb0, 0xb9, 0x16, 0xe1, 0xad, 0xb4,
    0xe8, 0xdc, 0x68, 0x10, 0xaf, 0x76, 0x1a, 0xa4, 0x92, 0x3b, 0x48, 0xeb,
    0x4b, 0xae, 0xeb, 0x5a, 0xfc, 0x32, 0x1b, 0x52, 0x19, 0x2e, 0x90, 0xd9,
    0x6b, 0x73, 0x71, 0x11, 0x5a, 0xcb, 0x9a, 0xe5, 0x35, 0x87, 0x9b, 0x37,
    0x35, 0x2b, 0xb5, 0x88, 0xc6, 0xaa, 0xa0, 0x7d, 0xab, 0x85, 0xd8, 0xf6,
    0x20, 0x0c, 0x0d, 0xd8, 0x1a, 0x3b, 0xa9, 0xa1, 0xac, 0x05, 0x1b, 0x0b,
    0x2e, 0xcf, 0x6d, 0x73, 0xf4, 0x70, 0x8e, 0xeb, 0x1e, 0xd4, 0xc3, 0x34,
    0xf3, 0xcb, 0x1a, 0xaf, 0xa3, 0x49, 0xa4, 0x26, 0x12, 0x86, 0x9d, 0x56,
    0x88, 0x88, 0x81, 0x74, 0x0e, 0xdc, 0x2c, 0x58, 0xaa, 0x84, 0x95, 0xcc,
    0xd3, 0xda, 0xbb, 0xe4, 0xde, 0xaa, 0xc5, 0x54, 0x46, 0xd3, 0x94, 0xef,
    0xca, 0xb2, 0x07, 0x38, 0xd8, 0x03, 0x77, 0x0e, 0x3a, 0x74, 0xb6, 0x13,
    0x06, 0x1c, 0x49, 0x6f, 0x1c, 0xb0, 0xdf, 0x51, 0x24, 0x21, 0x28, 0x5f,
    0x12, 0xfb, 0xd2, 0x5a, 0xa9, 0xeb, 0xc2, 0x66, 0x43, 0x5e, 0x35, 0xe6,
    0x98, 0x74, 0xab, 0x4b, 0x3b, 0x4c, 0x1d, 0xde, 0xc3, 0xf1, 0xd1, 0x34,
    0x58, 0x40, 0x09, 0xa2, 0x32, 0x04, 0x01, 0x04, 0xbe, 0x26, 0x9e, 0x74,
    0x09, 0x42, 0x4d, 0xd7, 0x37, 0x04, 0x7e, 0x01, 0x21, 0xb2, 0x7c, 0xfc,
    0x79, 0x18, 0x6e, 0x2e, 0xeb, 0x59, 0x00, 0x37, 0xe9, 0x0a, 0x9e, 0x1c,
    0xcf, 0xff, 0x25, 0x03, 0x58, 0x90, 0xcd, 0xdb, 0x38, 0x8e, 0x8b, 0xd1,
    0x09, 0x42, 0x28, 0x94, 0x4c, 0x10, 0x22, 0x44, 0x88, 0x08, 0x3f, 0x4a,
    0x58, 0x58, 0xdc, 0x6d, 0x50, 0x50, 0x17, 0x00, 0x2c, 0x77, 0xe2, 0x9c,
    0xf7, 0xf0, 0x91, 0xbe, 0x42, 0x3e, 0x63, 0xa3, 0x14, 0xa0, 0x15, 0x89,
    0xd4, 0x24, 0x91, 0x40, 0xc4, 0x02, 0x11, 0xc7, 0x88, 0x28, 0x41, 0xc6,
    0x02, 0x29, 0x24, 0x71, 0x2c, 0xd9, 0xa8, 0xca, 0x2f, 0x4c, 0xeb, 0xd9,
    0x97, 0x01, 0xfe, 0x04, 0xaa, 0x0f, 0x80, 0xde, 0x45, 0xb1, 0x26, 0x99,
    0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

    static const unsigned char image11_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x1f, 0xf3, 0xff, 0x61, 0x00, 0x00, 0x02,
    0x35, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xa5, 0x93, 0xb1, 0x6e, 0x55,
    0x47, 0x10, 0x86, 0xbf, 0x73, 0xcd, 0xe5, 0xda, 0x26, 0x60, 0xe9, 0x36,
    0x48, 0x24, 0x15, 0x0a, 0x95, 0x0b, 0x9a, 0x44, 0x51, 0xa4, 0x08, 0x51,
    0x92, 0x3e, 0x6f, 0x40, 0x49, 0x49, 0xcd, 0x6b, 0xa4, 0xa1, 0x42, 0x0a,
    0x28, 0x52, 0xa4, 0xf0, 0x02, 0x94, 0x20, 0x11, 0x51, 0x44, 0x46, 0x01,
    0x1a, 0x64, 0x99, 0x04, 0x2c, 0xd9, 0xd7, 0xbe, 0x3e, 0xf7, 0xec, 0xee,
    0xcc, 0xee, 0x9e, 0xb3, 0x3b, 0x29, 0x6e, 0x6c, 0x4c, 0xa0, 0x63, 0xa4,
    0x29, 0xe7, 0xd3, 0x3f, 0xff, 0xfc, 0xd3, 0x98, 0x19, 0x9f, 0x53, 0x67,
    0x00, 0x7e, 0xb9, 0xff, 0x78, 0x7b, 0x6d, 0xfd, 0xec, 0x54, 0x43, 0x8f,
    0x95, 0x1e, 0x17, 0x94, 0xb6, 0xf5, 0x78, 0x2f, 0x88, 0x44, 0x42, 0x50,
    0x44, 0x22, 0xaa, 0x89, 0xf9, 0x91, 0x67, 0x6b, 0xeb, 0xc5, 0xa2, 0x3d,
    0xda, 0xb9, 0x69, 0xf6, 0xf2, 0x11, 0x66, 0xc6, 0xef, 0x0f, 0x9f, 0x85,
    0x2e, 0x56, 0xab, 0xb5, 0xda, 0xcf, 0x0f, 0x9e, 0xd8, 0x4f, 0xb7, 0xee,
    0xda, 0xd3, 0xad, 0xbf, 0xad, 0xd6, 0xfa, 0x51, 0xbf, 0xd8, 0x3e, 0xb4,
    0xdb, 0x77, 0x7e, 0xb5, 0xc9, 0xd9, 0xef, 0x76, 0xcd, 0x8c, 0x11, 0x80,
    0x77, 0xa9, 0x6f, 0x5d, 0x8f, 0xf6, 0xf0, 0xf4, 0xcf, 0xd7, 0xec, 0xbc,
    0xdd, 0xa7, 0x94, 0x4f, 0xaf, 0x36, 0x9b, 0x3b, 0x42, 0x3f, 0xb0, 0xba,
    0xb6, 0x7e, 0xfe, 0x64, 0x05, 0x1f, 0x02, 0x2e, 0x44, 0xd6, 0xc6, 0xc6,
    0x8f, 0xd7, 0xaf, 0x72, 0xed, 0xfb, 0x4d, 0x36, 0xaf, 0x5c, 0xfa, 0x24,
    0x20, 0xc6, 0xc8, 0xdb, 0x37, 0xff, 0xd0, 0xf7, 0x7d, 0x39, 0x01, 0x04,
    0x89, 0x88, 0x64, 0x76, 0x73, 0xe6, 0x87, 0x6f, 0xae, 0x50, 0x4a, 0x61,
    0x76, 0x14, 0xd8, 0x9d, 0x0d, 0x94, 0x52, 0xa8, 0xc5, 0xe8, 0x6b, 0xc5,
    0xbb, 0xc0, 0x1f, 0xcf, 0x5e, 0xd1, 0x75, 0x1d, 0x66, 0xe5, 0xbd, 0x89,
    0xc1, 0x2b, 0x29, 0x0f, 0xbc, 0x79, 0xd7, 0x12, 0x24, 0xa3, 0x31, 0x21,
    0x31, 0xa3, 0x31, 0x23, 0x92, 0xe8, 0xbc, 0x67, 0x3e, 0x3b, 0x62, 0x7e,
    0x38, 0x27, 0xa7, 0x4c, 0x9f, 0x32, 0xa5, 0x9c, 0x02, 0xb8, 0xa0, 0x38,
    0xaf, 0x18, 0xc6, 0x85, 0x2f, 0x26, 0x8c, 0xc7, 0x0d, 0x2b, 0x0d, 0x58,
    0xce, 0x68, 0xcd, 0x34, 0x29, 0x31, 0x19, 0x19, 0xd3, 0xf3, 0xeb, 0xec,
    0xe7, 0x4c, 0xe7, 0x3a, 0x6a, 0x3d, 0x05, 0x90, 0xa0, 0xb4, 0x4e, 0xb9,
    0xfc, 0xd5, 0x05, 0xbe, 0xdd, 0xfc, 0x12, 0x80, 0x52, 0xc0, 0xb9, 0x82,
    0x48, 0x44, 0x24, 0xe2, 0x7d, 0x04, 0x8c, 0x7b, 0xbf, 0x3d, 0xe2, 0xe5,
    0xf3, 0xbf, 0x3e, 0x04, 0x84, 0xb0, 0xbc, 0x71, 0x8a, 0x85, 0xfd, 0xbd,
    0x84, 0x0f, 0x19, 0xd5, 0x1e, 0x95, 0x88, 0x68, 0xfa, 0x2f, 0x0b, 0x89,
    0x33, 0x2b, 0x0d, 0xc1, 0x47, 0xa2, 0x08, 0xc7, 0x01, 0x5c, 0x2a, 0xd0,
    0xc8, 0xc2, 0x05, 0x16, 0xdd, 0x84, 0x61, 0x68, 0x70, 0x2e, 0x9e, 0x04,
    0xe7, 0x58, 0x81, 0x48, 0x62, 0x65, 0xd4, 0x10, 0x42, 0x20, 0x25, 0xfd,
    0x9f, 0x89, 0xa2, 0x1c, 0x1c, 0xcc, 0x99, 0xae, 0x4f, 0x90, 0x20, 0x84,
    0xa0, 0xa8, 0x2e, 0x87, 0x8e, 0x41, 0xaa, 0xca, 0xa8, 0x19, 0x21, 0x12,
    0xc8, 0x49, 0x80, 0x53, 0x0a, 0xbc, 0x13, 0xda, 0xd6, 0x11, 0xa6, 0x1b,
    0x2c, 0xba, 0x44, 0xd7, 0x29, 0x22, 0x09, 0xd5, 0x78, 0xd2, 0x22, 0x71,
    0x09, 0xd0, 0xc4, 0x30, 0x24, 0xe0, 0x94, 0x02, 0xdf, 0xf9, 0x71, 0xbb,
    0x77, 0xc0, 0xde, 0x64, 0x85, 0xf4, 0xf5, 0x45, 0x72, 0xee, 0xc8, 0x59,
    0x49, 0x29, 0x11, 0x63, 0x22, 0xe7, 0x48, 0xce, 0x09, 0xac, 0xa1, 0x9d,
    0xcd, 0xa8, 0xda, 0x01, 0xcd, 0x18, 0xa0, 0x31, 0x33, 0x36, 0x36, 0x6e,
    0x6c, 0x8f, 0x1a, 0x9b, 0xd2, 0xf4, 0x9c, 0x3b, 0xb7, 0x8a, 0x59, 0x65,
    0x18, 0x2a, 0x50, 0x29, 0xc5, 0x30, 0x33, 0x6a, 0xad, 0x2c, 0x0d, 0x5f,
    0xd0, 0xf7, 0x0e, 0x18, 0xcf, 0xcd, 0x5e, 0x5d, 0x6e, 0x3e, 0xf7, 0x9d,
    0xff, 0x05, 0xb2, 0xb7, 0xde, 0x32, 0xa8, 0xff, 0xa8, 0xbc, 0x00, 0x00,
    0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

    static const unsigned char image12_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x1f, 0xf3, 0xff, 0x61, 0x00, 0x00, 0x02,
    0xc1, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0x8d, 0x92, 0x5d, 0x48, 0x93,
    0x61, 0x14, 0xc7, 0xcf, 0xfb, 0xa1, 0x6e, 0x73, 0x9f, 0xe5, 0xc4, 0x96,
    0x2b, 0xb5, 0x34, 0x21, 0x48, 0x66, 0x31, 0x24, 0x04, 0x11, 0x84, 0x40,
    0x25, 0xb5, 0x20, 0x98, 0xc6, 0xac, 0x1b, 0xa3, 0x1b, 0x2f, 0x82, 0xa2,
    0x25, 0x5e, 0x75, 0x53, 0x37, 0xa1, 0x37, 0x99, 0x33, 0xc3, 0x8c, 0x84,
    0x52, 0x1b, 0x96, 0xa5, 0xa9, 0x98, 0xca, 0xdc, 0x9a, 0x96, 0xd3, 0xa9,
    0xf9, 0x35, 0x29, 0x3f, 0xf2, 0x73, 0x1f, 0xba, 0x77, 0xef, 0x5a, 0x7b,
    0xf7, 0xbe, 0x4f, 0x17, 0xb5, 0x61, 0x14, 0xea, 0x1f, 0xce, 0xcd, 0x73,
    0xce, 0xf3, 0x3b, 0xff, 0xc3, 0x39, 0x80, 0x10, 0x82, 0xdd, 0xc2, 0x60,
    0x18, 0x28, 0xb4, 0x58, 0xa6, 0x51, 0x67, 0xa7, 0x25, 0xef, 0x7f, 0x79,
    0x1c, 0xf6, 0x90, 0x42, 0x11, 0xa3, 0x57, 0x2a, 0xe5, 0xe0, 0xf1, 0xd0,
    0xe1, 0x37, 0xbd, 0xbe, 0x3d, 0xc6, 0x60, 0x30, 0x96, 0x03, 0xc0, 0xde,
    0x00, 0xa1, 0x90, 0x27, 0xa7, 0x69, 0x1f, 0xb8, 0xdd, 0x14, 0x00, 0x00,
    0xe8, 0x74, 0x35, 0x32, 0xb9, 0x5c, 0xd2, 0x90, 0x9a, 0x7a, 0xb4, 0x7a,
    0x5f, 0x00, 0x97, 0x8b, 0x02, 0x8a, 0xf2, 0xc3, 0xcc, 0xcc, 0x37, 0x54,
    0x52, 0xa2, 0x93, 0x25, 0x25, 0x1d, 0x6e, 0x2d, 0x28, 0xc8, 0xcc, 0x73,
    0xbb, 0x29, 0xe7, 0xbe, 0x00, 0x0e, 0x87, 0x07, 0xb6, 0xb6, 0xb6, 0x61,
    0x72, 0x72, 0x36, 0x45, 0xad, 0x4e, 0x6f, 0xd6, 0x68, 0xce, 0x65, 0x5b,
    0xad, 0x76, 0xb6, 0xaf, 0x6f, 0xa8, 0x1c, 0x00, 0x00, 0x43, 0x08, 0xed,
    0x0a, 0xa8, 0xab, 0x7b, 0x87, 0x70, 0x9c, 0x85, 0x95, 0x15, 0x87, 0xbf,
    0xb4, 0x34, 0x97, 0x67, 0x32, 0x4d, 0xf8, 0xba, 0xbb, 0x3f, 0x96, 0xd5,
    0xd7, 0x57, 0x3c, 0x07, 0x00, 0x20, 0x77, 0x16, 0xbf, 0x2d, 0x91, 0xca,
    0xc8, 0x28, 0x48, 0x8c, 0xe2, 0x07, 0xb9, 0x43, 0x42, 0x7a, 0xfe, 0xc4,
    0x7d, 0x44, 0x7d, 0x1e, 0x1e, 0x83, 0xe3, 0x29, 0x09, 0x90, 0x93, 0x93,
    0xc1, 0x6b, 0x78, 0xda, 0xb9, 0x6d, 0x34, 0x59, 0xb5, 0x5d, 0x1d, 0x55,
    0xaf, 0x43, 0x7f, 0xc2, 0x0e, 0x1a, 0x35, 0xe2, 0x22, 0x55, 0x1a, 0x77,
    0x37, 0xfe, 0x14, 0x79, 0x8c, 0x14, 0x13, 0x81, 0xf5, 0x4f, 0x9c, 0x85,
    0x5b, 0xf3, 0x3d, 0x69, 0x89, 0xb8, 0xd3, 0x24, 0x88, 0xcd, 0xc0, 0xcc,
    0x96, 0x91, 0xe5, 0xa5, 0xd9, 0xf1, 0xcb, 0xa6, 0xa1, 0xa6, 0xfe, 0x9d,
    0x4d, 0x31, 0x84, 0x10, 0x54, 0xe5, 0x8b, 0x2e, 0x9c, 0xcf, 0x0c, 0xb4,
    0xf2, 0x25, 0xa4, 0x87, 0x0b, 0x12, 0xb6, 0x98, 0x64, 0x22, 0x21, 0x52,
    0x41, 0xc4, 0x33, 0x1c, 0xc1, 0x0d, 0x2e, 0xa6, 0xe1, 0xa6, 0x37, 0x22,
    0xb0, 0x4d, 0xad, 0x5f, 0x7f, 0x61, 0x34, 0x3e, 0xfa, 0x67, 0x46, 0x84,
    0x10, 0xb4, 0x69, 0x23, 0x57, 0xe7, 0x2a, 0x08, 0xba, 0xee, 0xa2, 0x38,
    0x17, 0x21, 0x04, 0x23, 0x37, 0xc5, 0x1a, 0x6e, 0x54, 0x8a, 0x38, 0x47,
    0x2c, 0xa2, 0x7a, 0x64, 0x88, 0x19, 0x90, 0x20, 0x5f, 0x8b, 0x68, 0x6a,
    0xad, 0x51, 0xd2, 0x3b, 0x7c, 0x4b, 0x54, 0xf6, 0xcf, 0x21, 0x25, 0x45,
    0x07, 0xe2, 0xe6, 0x17, 0xd0, 0x9c, 0x75, 0x91, 0x1d, 0xa9, 0x2a, 0x92,
    0x49, 0x83, 0x04, 0x5b, 0x0c, 0xae, 0x20, 0x8c, 0xd6, 0xf8, 0x47, 0xb7,
    0x37, 0x39, 0x44, 0x9c, 0x24, 0x81, 0x97, 0x14, 0x99, 0x1a, 0xab, 0x22,
    0xb3, 0x93, 0xb3, 0x88, 0xda, 0xf7, 0x65, 0xa2, 0x4b, 0x21, 0x03, 0x38,
    0x00, 0xc0, 0xa2, 0x03, 0xf3, 0x9f, 0x55, 0x70, 0x69, 0x59, 0x89, 0xfe,
    0x36, 0x95, 0xc2, 0x3b, 0xa4, 0x94, 0x33, 0xf9, 0xbd, 0x06, 0xd4, 0x3b,
    0x6e, 0x63, 0xf2, 0x23, 0x82, 0x2c, 0xe6, 0x1d, 0x08, 0x50, 0xd3, 0xcd,
    0x8c, 0xf6, 0xeb, 0x2b, 0xe6, 0x06, 0x8f, 0x61, 0xe1, 0xa0, 0x02, 0x34,
    0x0d, 0x57, 0x31, 0x5e, 0x18, 0xd0, 0x65, 0x17, 0x5c, 0xfb, 0x60, 0xc7,
    0x97, 0x54, 0x71, 0xac, 0x1a, 0x07, 0x24, 0xea, 0x30, 0xe3, 0x95, 0x0b,
    0x0b, 0xfc, 0x42, 0xed, 0x4b, 0xdf, 0xf7, 0x1f, 0xeb, 0x2c, 0x2c, 0x8f,
    0x07, 0xfb, 0x27, 0xec, 0x9e, 0xa6, 0x41, 0x3b, 0x5f, 0xff, 0x65, 0x8c,
    0x75, 0x44, 0x44, 0xb2, 0x4a, 0x76, 0x55, 0x2c, 0x08, 0xaf, 0xb1, 0xda,
    0x4a, 0x3f, 0x93, 0xf1, 0xc4, 0xed, 0x3f, 0x09, 0x8f, 0xd0, 0xee, 0x12,
    0xd0, 0xba, 0x1e, 0x8f, 0x33, 0x64, 0x71, 0x79, 0x81, 0x75, 0xc6, 0x49,
    0xd9, 0xd3, 0xfd, 0x76, 0x91, 0x9a, 0xcf, 0xf7, 0x81, 0xfa, 0x48, 0x20,
    0x66, 0x6d, 0x03, 0xb3, 0x39, 0xbd, 0xd1, 0x4c, 0x18, 0x80, 0x7e, 0xef,
    0xd2, 0xf5, 0x27, 0xfe, 0x92, 0x79, 0x9a, 0x7c, 0x78, 0xe5, 0x4c, 0xa0,
    0xb2, 0x38, 0xdd, 0xdb, 0x4a, 0xe2, 0x70, 0x40, 0xca, 0x20, 0x30, 0xcc,
    0x44, 0xb7, 0xdf, 0x36, 0x6e, 0x52, 0xe1, 0x11, 0x76, 0x13, 0xed, 0xf2,
    0xdd, 0xab, 0x35, 0xf3, 0xea, 0x85, 0x18, 0x8a, 0x85, 0x20, 0xe2, 0x1e,
    0x9b, 0xa3, 0x1e, 0x38, 0x37, 0x68, 0x7d, 0x28, 0xff, 0x0b, 0x17, 0x24,
    0x78, 0xb2, 0xac, 0x05, 0x65, 0x63, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45,
    0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

    static const unsigned char image13_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x1f, 0xf3, 0xff, 0x61, 0x00, 0x00, 0x02,
    0x18, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0x7d, 0x92, 0xcb, 0x4a, 0x5c,
    0x41, 0x10, 0x86, 0xbf, 0xea, 0xee, 0x39, 0x73, 0xc6, 0x11, 0x41, 0x72,
    0x11, 0x11, 0x02, 0x51, 0xb3, 0x90, 0x90, 0x59, 0x8a, 0xb8, 0xc8, 0x22,
    0x2f, 0x12, 0x12, 0x92, 0x07, 0x08, 0x24, 0x8b, 0x11, 0x02, 0x82, 0x1b,
    0x4d, 0xde, 0x20, 0x31, 0x97, 0x95, 0x1b, 0x1f, 0x20, 0xcc, 0xd2, 0x80,
    0x8a, 0x06, 0xc4, 0x45, 0x44, 0x54, 0x22, 0x51, 0x88, 0x59, 0xa8, 0xa8,
    0x73, 0xc6, 0xb9, 0x9e, 0xd3, 0x95, 0xc5, 0x78, 0xd7, 0x49, 0x41, 0x6d,
    0xaa, 0xe8, 0xbf, 0xff, 0xff, 0xeb, 0x96, 0xd9, 0xd9, 0xf5, 0x83, 0xce,
    0xce, 0x76, 0xa7, 0xea, 0x89, 0x63, 0x8f, 0xf7, 0x8a, 0x31, 0x96, 0x95,
    0x95, 0xcd, 0xf6, 0xe5, 0xe5, 0xb5, 0xe7, 0x13, 0x13, 0x2f, 0xbe, 0xf0,
    0xbf, 0x5a, 0x5a, 0xda, 0x6c, 0x78, 0xef, 0xf5, 0xb4, 0x6b, 0x35, 0xaf,
    0xfb, 0xfb, 0x15, 0x5d, 0x5d, 0xfd, 0xab, 0x53, 0x53, 0xdf, 0x75, 0x64,
    0xe4, 0xd3, 0x1b, 0x55, 0xa5, 0x55, 0x9b, 0xab, 0x82, 0xd6, 0x42, 0x10,
    0x04, 0x6c, 0x6c, 0xfc, 0x61, 0x6f, 0xef, 0x80, 0x30, 0x0c, 0xde, 0xe5,
    0xf3, 0x93, 0x6f, 0x5b, 0x19, 0xb8, 0x26, 0x20, 0x02, 0x49, 0x12, 0x93,
    0xcb, 0xf5, 0x33, 0x38, 0xf8, 0x90, 0x81, 0x81, 0x5e, 0x44, 0xcc, 0xfd,
    0x56, 0x02, 0xee, 0x26, 0x01, 0x6b, 0x2d, 0xc5, 0x62, 0x99, 0x4a, 0xa5,
    0x4e, 0x47, 0x47, 0x96, 0xe1, 0xe1, 0x47, 0x8f, 0x17, 0x16, 0x7e, 0x7d,
    0x88, 0xe3, 0x38, 0x53, 0x2c, 0x56, 0xb2, 0x33, 0x33, 0x3f, 0xbe, 0x8d,
    0x8f, 0xbf, 0xfc, 0x78, 0x23, 0x83, 0x28, 0xf2, 0xba, 0xbd, 0x7d, 0xa8,
    0x73, 0x73, 0xeb, 0x7a, 0x74, 0x54, 0xbd, 0x34, 0xdf, 0xd9, 0x89, 0x74,
    0x6b, 0xeb, 0x50, 0xa7, 0xa7, 0xe7, 0x74, 0x74, 0xf4, 0xeb, 0x6b, 0x55,
    0xbd, 0xec, 0xa0, 0x5a, 0x85, 0x72, 0xb9, 0x8a, 0x31, 0x16, 0x6b, 0x2d,
    0xe9, 0xf4, 0xf9, 0x3a, 0x9b, 0x05, 0xef, 0x33, 0xec, 0xee, 0x1e, 0x12,
    0x45, 0x11, 0xe9, 0x74, 0xf8, 0x3e, 0x9f, 0x9f, 0xbc, 0x7b, 0xc6, 0x40,
    0x15, 0xea, 0xf5, 0x06, 0xce, 0x19, 0xc2, 0xd0, 0x21, 0x22, 0xa8, 0x5e,
    0xc9, 0xeb, 0x84, 0x20, 0x48, 0xd1, 0xdd, 0x7d, 0x87, 0xfe, 0xfe, 0x7b,
    0xb4, 0xb5, 0x85, 0xaf, 0xce, 0x04, 0xea, 0x75, 0x10, 0xb1, 0x88, 0xb4,
    0xc2, 0x05, 0xc6, 0x08, 0xe9, 0x74, 0x8a, 0xae, 0xae, 0x5b, 0xf4, 0xf4,
    0xdc, 0xc6, 0xb9, 0x14, 0xce, 0x98, 0xf3, 0x87, 0x70, 0x4e, 0x30, 0xc6,
    0x91, 0x24, 0x70, 0x71, 0x7e, 0x5a, 0xe5, 0x72, 0x9d, 0x52, 0xa9, 0x8c,
    0xf7, 0x4a, 0x26, 0x93, 0x46, 0x44, 0x70, 0x51, 0x54, 0x21, 0x8a, 0x1a,
    0x44, 0x51, 0x15, 0xef, 0x15, 0xef, 0x3d, 0x49, 0xa2, 0xd4, 0xeb, 0x31,
    0x72, 0xc1, 0x4e, 0x14, 0x79, 0x8e, 0x8f, 0x6b, 0xa8, 0x0a, 0xd9, 0x6c,
    0x06, 0x6b, 0x2d, 0xce, 0x81, 0x2b, 0x14, 0xe6, 0xa7, 0x0a, 0x85, 0x79,
    0x73, 0xf9, 0xa6, 0x5a, 0x25, 0x97, 0x7b, 0xf0, 0x64, 0x68, 0xa8, 0xb7,
    0xef, 0x14, 0x6e, 0x1c, 0x37, 0x08, 0x02, 0x87, 0x31, 0x06, 0x63, 0xe4,
    0xc4, 0xa1, 0xe0, 0xc6, 0xc6, 0x9e, 0x3d, 0xbd, 0x29, 0x6f, 0xa1, 0xb0,
    0xfc, 0xd9, 0x7b, 0xfa, 0x8c, 0x81, 0x24, 0xf1, 0x58, 0x6b, 0x88, 0x63,
    0xc5, 0x5a, 0x83, 0xb5, 0x06, 0x11, 0xdb, 0xe4, 0xd2, 0x0a, 0x58, 0x18,
    0x86, 0x27, 0x51, 0x00, 0x9a, 0x51, 0xac, 0xbd, 0x4e, 0xf8, 0xda, 0x4f,
    0x3c, 0x27, 0xde, 0x3c, 0x98, 0x4a, 0x81, 0x88, 0xe0, 0x7d, 0x0a, 0x11,
    0x8f, 0x48, 0x0c, 0x80, 0x88, 0x69, 0x42, 0x6c, 0x25, 0xb0, 0xb8, 0xf8,
    0xb3, 0xb6, 0xb6, 0xf6, 0x1b, 0xa0, 0x04, 0xa0, 0xaa, 0x24, 0x49, 0x73,
    0xa7, 0x9a, 0x20, 0x02, 0xa5, 0x52, 0x25, 0xfe, 0x07, 0xd9, 0xbb, 0x1d,
    0xb5, 0x0b, 0x97, 0x87, 0x95, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e,
    0x44, 0xae, 0x42, 0x60, 0x82
};

    static const unsigned char image14_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x1f, 0xf3, 0xff, 0x61, 0x00, 0x00, 0x02,
    0xc5, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0x75, 0x93, 0x4d, 0x68, 0x5c,
    0x55, 0x18, 0x86, 0x9f, 0xef, 0xdc, 0x33, 0xf7, 0xde, 0x94, 0x9a, 0xcc,
    0x64, 0xf2, 0xeb, 0x04, 0x89, 0xb4, 0xa5, 0x0d, 0x82, 0x52, 0xb0, 0x62,
    0x2c, 0x44, 0x84, 0x08, 0x11, 0xd1, 0x55, 0xbb, 0x10, 0x5d, 0xd4, 0x5d,
    0x70, 0x61, 0xed, 0xa6, 0x88, 0x2e, 0x2c, 0xb8, 0xa8, 0xb8, 0x6a, 0xc1,
    0x45, 0xd1, 0x95, 0x0b, 0x71, 0xd3, 0x2e, 0xc4, 0xad, 0x28, 0x2e, 0x94,
    0x16, 0x14, 0xa1, 0x0b, 0x37, 0x35, 0x89, 0x4e, 0x7f, 0x08, 0x69, 0xf3,
    0xd3, 0xcc, 0xdc, 0x7b, 0xe7, 0x9e, 0x7b, 0x7e, 0xba, 0x48, 0x27, 0x49,
    0x17, 0xbe, 0x9b, 0x03, 0x1f, 0xe7, 0x7b, 0x3e, 0xce, 0x7b, 0xbe, 0x57,
    0x42, 0x08, 0xf4, 0xb5, 0xb8, 0xf8, 0xf9, 0x6c, 0xab, 0x35, 0x71, 0xa1,
    0xd5, 0x1a, 0x6d, 0x00, 0x3c, 0x78, 0xb0, 0x6d, 0x6e, 0x2d, 0xaf, 0x5e,
    0xfa, 0xe6, 0xca, 0xf9, 0xab, 0xfc, 0x8f, 0xe4, 0xaf, 0x0b, 0xd3, 0x75,
    0x65, 0xba, 0x0b, 0xbf, 0x3d, 0x9c, 0x99, 0xb8, 0x53, 0x7f, 0xe7, 0x83,
    0xc5, 0xc5, 0xd3, 0x47, 0xa6, 0x5a, 0x4d, 0x00, 0xd6, 0xd7, 0xb7, 0xb8,
    0xf2, 0xf5, 0x8f, 0xeb, 0xea, 0xf6, 0xb5, 0xaf, 0xde, 0x6c, 0x5e, 0x5f,
    0xea, 0x5a, 0xfd, 0xeb, 0xc9, 0x2f, 0xee, 0xb6, 0xf7, 0x03, 0x74, 0xa5,
    0xe3, 0xef, 0x0f, 0xbf, 0xf1, 0xfa, 0x42, 0xf8, 0xa5, 0xc9, 0x4b, 0xc7,
    0x5e, 0xe0, 0xc0, 0x40, 0x4a, 0xbb, 0x7d, 0x1f, 0x11, 0x48, 0x92, 0x84,
    0x57, 0xe7, 0x5e, 0x6c, 0xfe, 0xfe, 0xf3, 0xdf, 0x9f, 0x8d, 0xcf, 0x1f,
    0x24, 0xfc, 0x71, 0xf3, 0xe6, 0x4f, 0x1f, 0x0d, 0xbf, 0x35, 0x7f, 0x69,
    0x63, 0x17, 0xa2, 0xf5, 0xd4, 0xd8, 0xcb, 0xf5, 0x13, 0x87, 0x18, 0x59,
    0x29, 0xf8, 0x67, 0xe9, 0x16, 0xed, 0xf6, 0x7f, 0x80, 0x43, 0x24, 0x10,
    0x45, 0x25, 0xce, 0x45, 0x0c, 0x4f, 0x94, 0x8c, 0xcf, 0x4e, 0x92, 0xad,
    0xad, 0x3c, 0xbf, 0x9a, 0xbf, 0x36, 0x0e, 0xec, 0x02, 0xa2, 0xf7, 0x16,
    0xa6, 0x3e, 0x7e, 0xe6, 0xb9, 0x46, 0x3a, 0x39, 0x5c, 0x92, 0xe8, 0x7f,
    0x19, 0xad, 0x2f, 0xf3, 0xf4, 0xc8, 0x12, 0x8d, 0xc1, 0x75, 0x0a, 0x7b,
    0x84, 0x38, 0xae, 0x71, 0xf4, 0xf0, 0x34, 0xb6, 0x7c, 0x96, 0xad, 0xf2,
    0x18, 0x76, 0xe2, 0xd4, 0xd1, 0x6b, 0x3f, 0xdc, 0x18, 0x7c, 0x65, 0x76,
    0xe6, 0x06, 0x80, 0xde, 0x7e, 0x58, 0xe1, 0x3a, 0x39, 0x43, 0x89, 0xe3,
    0xe4, 0x89, 0xbe, 0x33, 0x86, 0x6e, 0xa6, 0x38, 0xd4, 0x9b, 0x67, 0x7a,
    0xba, 0x81, 0xa9, 0x20, 0xeb, 0x42, 0x5a, 0x0f, 0x8c, 0x9a, 0xee, 0x9c,
    0x45, 0xe6, 0x2e, 0x5f, 0xbe, 0x3a, 0x7e, 0xf6, 0xec, 0xa9, 0x4f, 0x75,
    0xa7, 0x6b, 0xf0, 0xbd, 0x0e, 0xd6, 0x78, 0xe8, 0x08, 0x08, 0x28, 0x31,
    0xe4, 0x79, 0x86, 0x4b, 0x2b, 0x00, 0xe2, 0x1a, 0xe8, 0x21, 0xa8, 0xe5,
    0x96, 0x8d, 0x5e, 0x45, 0xa7, 0x53, 0x10, 0xc7, 0xf1, 0x27, 0x17, 0x2f,
    0x7e, 0x77, 0x40, 0x77, 0x73, 0x8b, 0x2b, 0x72, 0x5c, 0xe5, 0x09, 0x01,
    0x08, 0x01, 0x85, 0xc1, 0x9a, 0xa7, 0x20, 0xdd, 0x73, 0xbb, 0xff, 0xdb,
    0x5a, 0x6b, 0x46, 0x46, 0x86, 0x88, 0xe3, 0x1a, 0xd6, 0xba, 0x33, 0xda,
    0x57, 0x96, 0xd0, 0xcb, 0xb0, 0x99, 0x85, 0x4e, 0x05, 0x85, 0x05, 0xdb,
    0x23, 0x48, 0x0d, 0xea, 0x7b, 0x80, 0x28, 0x82, 0x28, 0x8a, 0xd0, 0x5a,
    0xd1, 0x68, 0x0c, 0x91, 0xa6, 0x31, 0xf7, 0xee, 0xad, 0xa1, 0x83, 0x73,
    0xd8, 0xcd, 0x0e, 0x6e, 0xb5, 0x80, 0xd2, 0x83, 0x40, 0xf0, 0x25, 0x4e,
    0x17, 0x4f, 0x2c, 0x8c, 0x73, 0x50, 0x96, 0x15, 0x59, 0x56, 0xe2, 0x7d,
    0x20, 0x49, 0x62, 0x44, 0x04, 0x1d, 0x8c, 0xc1, 0xde, 0xdd, 0xc4, 0x76,
    0x2c, 0x88, 0xec, 0x78, 0xe8, 0x4b, 0x5c, 0xad, 0x04, 0xd9, 0x6b, 0xce,
    0x73, 0x43, 0x9e, 0x17, 0x84, 0xe0, 0x19, 0x18, 0x48, 0x00, 0x50, 0x2a,
    0x42, 0x93, 0x95, 0xd8, 0x8d, 0x1e, 0xce, 0xed, 0x4d, 0x53, 0xde, 0xe0,
    0x5d, 0x8f, 0x3e, 0xc1, 0x18, 0x8f, 0x31, 0x15, 0x51, 0x14, 0x91, 0x24,
    0x20, 0xb2, 0x73, 0x59, 0x04, 0x34, 0x95, 0x25, 0xaa, 0x2a, 0x5c, 0xb5,
    0x6f, 0xbf, 0x9d, 0x41, 0xa4, 0xa0, 0x9f, 0x12, 0x6b, 0x2d, 0x22, 0x0a,
    0x91, 0x80, 0x88, 0x42, 0xeb, 0xc7, 0x86, 0xa3, 0xd0, 0x77, 0x36, 0x58,
    0x59, 0xbe, 0x6d, 0x8f, 0x2b, 0xc5, 0x6e, 0x03, 0x95, 0xa5, 0x1a, 0xb4,
    0x8c, 0x09, 0x38, 0x0f, 0xce, 0x05, 0x44, 0x04, 0x79, 0xfc, 0xc4, 0x27,
    0xb2, 0xb0, 0xb6, 0x15, 0x9d, 0xfe, 0xf6, 0xfa, 0xc0, 0x87, 0xf5, 0x34,
    0x18, 0xef, 0x77, 0x8a, 0xde, 0x2a, 0x73, 0xb0, 0x59, 0x9b, 0x7c, 0x37,
    0x52, 0xef, 0x2b, 0x05, 0x49, 0x52, 0xc3, 0x7b, 0x87, 0x88, 0xa0, 0x94,
    0xa2, 0xaa, 0xc0, 0x7b, 0x50, 0x0a, 0x64, 0x7f, 0x9c, 0xf7, 0xeb, 0xcb,
    0x73, 0xe7, 0x66, 0xc6, 0x8e, 0xbf, 0xfd, 0x67, 0x1a, 0x13, 0x9c, 0xf3,
    0x3e, 0x04, 0x08, 0x21, 0xb0, 0x73, 0x7a, 0x80, 0x78, 0x73, 0x73, 0xfb,
    0xfe, 0x23, 0x90, 0xd7, 0x4c, 0xbe, 0xe4, 0x95, 0xa4, 0x91, 0x00, 0x00,
    0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

    static const unsigned char image15_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x16,
    0x08, 0x06, 0x00, 0x00, 0x00, 0xc4, 0xb4, 0x6c, 0x3b, 0x00, 0x00, 0x02,
    0xff, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xb5, 0x95, 0x31, 0x68, 0x1c,
    0x47, 0x14, 0x86, 0x3f, 0x99, 0x2d, 0xde, 0x82, 0x0c, 0xb3, 0x70, 0x81,
    0x5b, 0x50, 0x60, 0x0f, 0x54, 0xe8, 0xca, 0x0b, 0xa4, 0x39, 0x70, 0x71,
    0x2a, 0x8f, 0xb8, 0x38, 0x43, 0x8a, 0x38, 0x95, 0x63, 0x48, 0x13, 0xd2,
    0x38, 0xa5, 0xab, 0x80, 0xe3, 0x14, 0xae, 0x4d, 0x0a, 0x81, 0x20, 0x60,
    0xa4, 0x22, 0x60, 0x17, 0xc2, 0x72, 0x21, 0xc8, 0xa9, 0xda, 0x6b, 0x8c,
    0x4f, 0xe0, 0xe0, 0x0d, 0x28, 0xb0, 0x57, 0x1c, 0xec, 0x82, 0x04, 0x3b,
    0x85, 0x61, 0x1f, 0x78, 0xc1, 0x29, 0x66, 0xef, 0xa4, 0xbb, 0x8b, 0xc0,
    0x85, 0xf2, 0x9a, 0x65, 0x67, 0xdf, 0x7c, 0xef, 0x9f, 0x7f, 0xde, 0xcc,
    0xae, 0xc5, 0x71, 0xcc, 0x2c, 0xba, 0xdd, 0xee, 0x47, 0xae, 0x21, 0xe2,
    0x38, 0x5e, 0x5b, 0x9b, 0x81, 0x5f, 0x1e, 0xbc, 0xfc, 0xd8, 0xde, 0x6a,
    0x63, 0xad, 0x25, 0xcb, 0x33, 0x8a, 0xf7, 0xc5, 0x27, 0x41, 0xac, 0xb5,
    0xa4, 0xa7, 0x29, 0xa3, 0xd7, 0x23, 0xa8, 0x2e, 0xc6, 0xbd, 0x99, 0xd2,
    0x67, 0xbf, 0x3f, 0x23, 0xfc, 0x1c, 0x4c, 0xab, 0x24, 0x42, 0xd1, 0x4a,
    0x91, 0x59, 0x86, 0xe7, 0x92, 0xfd, 0xfa, 0x59, 0x56, 0x97, 0x66, 0x57,
    0x30, 0x49, 0x41, 0x77, 0x84, 0xf1, 0xb1, 0x2e, 0x82, 0x67, 0x95, 0x4d,
    0xab, 0x24, 0xb7, 0x87, 0x14, 0x45, 0x0a, 0x28, 0xbe, 0xaf, 0x94, 0x1f,
    0x84, 0x7c, 0x2a, 0x14, 0xe7, 0x0a, 0x08, 0x41, 0x03, 0x5a, 0x2d, 0x45,
    0xd6, 0x41, 0xeb, 0x02, 0x72, 0x13, 0xc2, 0x10, 0xc6, 0x97, 0x56, 0x32,
    0x07, 0x67, 0x79, 0x46, 0x84, 0xd6, 0x50, 0x8b, 0xef, 0x0b, 0xef, 0xde,
    0x1a, 0x86, 0x07, 0x96, 0xe4, 0xc4, 0x02, 0x33, 0x35, 0x42, 0xb4, 0x25,
    0x6c, 0x0f, 0x0c, 0xdd, 0x1e, 0x50, 0xb9, 0x71, 0x91, 0x45, 0x8b, 0xe6,
    0xe0, 0xe2, 0x7d, 0x81, 0x56, 0x3a, 0x87, 0xc6, 0x43, 0xd8, 0xfb, 0x2d,
    0x77, 0x93, 0xd6, 0x85, 0xd6, 0x96, 0x41, 0x3c, 0xc8, 0xa6, 0xca, 0xe4,
    0x6f, 0x65, 0xf7, 0xd7, 0x9c, 0x7c, 0x62, 0xb8, 0x7b, 0x4f, 0x2e, 0x15,
    0xfd, 0x0f, 0xb0, 0xd3, 0x02, 0xbe, 0x0f, 0xef, 0xde, 0x4a, 0x0d, 0x55,
    0x7a, 0x5f, 0x35, 0xe9, 0x0f, 0x84, 0xe0, 0x33, 0x40, 0x14, 0xd5, 0x90,
    0xf8, 0x55, 0xc9, 0xde, 0x4e, 0xce, 0xe1, 0x7e, 0x4e, 0xb3, 0x19, 0xd1,
    0xff, 0x3a, 0x00, 0xec, 0x02, 0xf8, 0xc6, 0x72, 0x99, 0xf2, 0x83, 0x30,
    0x7c, 0x61, 0xe7, 0xd0, 0x6f, 0xbf, 0x17, 0x82, 0xd0, 0x82, 0x58, 0x8a,
    0x33, 0xe1, 0xcf, 0x17, 0x05, 0xfd, 0x81, 0xcf, 0x77, 0x3f, 0x36, 0x01,
    0xe1, 0xf9, 0xbe, 0xc5, 0x9e, 0x2f, 0x4b, 0x5c, 0x7e, 0xf5, 0x20, 0x9f,
    0x0a, 0xc9, 0x5f, 0x16, 0x63, 0x0c, 0xfd, 0x81, 0x80, 0x67, 0xc1, 0x03,
    0xb5, 0x86, 0xdd, 0x27, 0x4a, 0x72, 0x62, 0x29, 0xce, 0xe0, 0xfe, 0x83,
    0x80, 0xd1, 0x91, 0xcb, 0x4d, 0x12, 0x67, 0xd3, 0xd5, 0x8a, 0xa1, 0xde,
    0x7d, 0x25, 0x8c, 0xea, 0xe5, 0xd7, 0xd0, 0xa7, 0x8f, 0xdd, 0x26, 0x9a,
    0x86, 0xf0, 0xc5, 0x2d, 0x41, 0x4c, 0x49, 0xbb, 0xe3, 0x76, 0x2c, 0x9b,
    0x68, 0x6d, 0xe4, 0x15, 0x60, 0xd7, 0xa7, 0x2e, 0x41, 0xc4, 0x79, 0x5a,
    0x64, 0x86, 0xa7, 0x8f, 0x95, 0xe4, 0xc4, 0x15, 0x14, 0x81, 0xd6, 0x86,
    0xef, 0xbe, 0x7b, 0x33, 0x98, 0xac, 0x58, 0xb1, 0xa2, 0x38, 0x68, 0xb8,
    0xc4, 0x74, 0xaa, 0xa8, 0x06, 0x8c, 0x8e, 0x71, 0x4a, 0x8d, 0xd0, 0x6c,
    0x1a, 0xf2, 0xa9, 0xe5, 0xd1, 0xc3, 0x8c, 0x64, 0x1c, 0x90, 0x9d, 0xba,
    0x6e, 0x08, 0x23, 0x7f, 0x19, 0xb3, 0x58, 0xa7, 0xac, 0x5c, 0xf3, 0x47,
    0x9b, 0xc2, 0xe4, 0x1f, 0x25, 0x7e, 0x55, 0xd2, 0xff, 0xc6, 0xa7, 0x38,
    0x33, 0x74, 0x6f, 0x09, 0xe1, 0x86, 0xcf, 0xa3, 0x87, 0x90, 0x4f, 0x2c,
    0xbf, 0xfc, 0x90, 0xa2, 0xaa, 0x98, 0x86, 0xd0, 0xe9, 0x94, 0x64, 0xd3,
    0xc5, 0x96, 0x5b, 0x51, 0x2c, 0xeb, 0xd0, 0x1f, 0x18, 0x00, 0xf6, 0x76,
    0x72, 0xe2, 0xa3, 0x92, 0xfb, 0x0f, 0x02, 0x3a, 0x3d, 0x88, 0x3a, 0x05,
    0x3f, 0xfd, 0xdc, 0xc2, 0x34, 0x0d, 0xd6, 0x5a, 0xb4, 0x52, 0xb6, 0x07,
    0x4d, 0xc2, 0xcd, 0x15, 0xc1, 0xcb, 0xce, 0xb8, 0x63, 0xda, 0xed, 0x41,
    0x3e, 0x35, 0x3c, 0xdf, 0xcf, 0xd9, 0x7d, 0x92, 0x33, 0x3a, 0x12, 0xda,
    0x6d, 0x01, 0x81, 0xec, 0x34, 0x43, 0xcf, 0x75, 0x3e, 0xf3, 0xcd, 0xd0,
    0x92, 0xde, 0x0e, 0x11, 0x6f, 0xf1, 0xa0, 0x2c, 0xdc, 0x15, 0x73, 0x38,
    0xca, 0x9d, 0x7b, 0x82, 0x69, 0x46, 0x1c, 0xfe, 0xe1, 0xba, 0x21, 0x39,
    0xb9, 0x28, 0x6e, 0x1a, 0x42, 0x7f, 0x10, 0x11, 0x0f, 0x2d, 0x56, 0x15,
    0x55, 0xb0, 0x76, 0xd1, 0x8a, 0x39, 0x38, 0x3d, 0x4d, 0x99, 0xa4, 0xc0,
    0xcd, 0x0b, 0x78, 0x7f, 0x20, 0x74, 0x7b, 0x21, 0x49, 0x62, 0xc8, 0x26,
    0x6e, 0x3c, 0xdc, 0xf0, 0xe9, 0x7c, 0x59, 0x12, 0x6e, 0xc2, 0xf6, 0xed,
    0xd0, 0x89, 0xf4, 0x0a, 0x92, 0xf1, 0x15, 0xe0, 0xd1, 0xeb, 0x11, 0xba,
    0x23, 0x84, 0x61, 0xdd, 0x6a, 0x15, 0xf3, 0x2b, 0x53, 0x66, 0x6d, 0xe8,
    0x41, 0x96, 0x5b, 0xb2, 0x03, 0x57, 0x5a, 0x3c, 0xc1, 0x5a, 0x48, 0xc6,
    0x4a, 0x96, 0x5f, 0xe5, 0x71, 0x05, 0xe3, 0x63, 0x5d, 0xb8, 0xfa, 0x96,
    0xdc, 0xff, 0xc4, 0x31, 0x17, 0x2b, 0x5d, 0x71, 0x5d, 0x71, 0x03, 0xdc,
    0x3f, 0xea, 0x7f, 0x01, 0x5f, 0x37, 0x3c, 0x8e, 0xe3, 0xb5, 0x7f, 0x01,
    0x35, 0x10, 0x5a, 0x0f, 0xfe, 0x02, 0xa8, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

    switch (id) {
        case image0_ID:  { QImage img; img.loadFromData(image0_data, sizeof(image0_data), "PNG"); return QPixmap::fromImage(img); }
        case image1_ID:  { QImage img; img.loadFromData(image1_data, sizeof(image1_data), "PNG"); return QPixmap::fromImage(img); }
        case image2_ID:  { QImage img; img.loadFromData(image2_data, sizeof(image2_data), "PNG"); return QPixmap::fromImage(img); }
        case image3_ID:  { QImage img; img.loadFromData(image3_data, sizeof(image3_data), "PNG"); return QPixmap::fromImage(img); }
        case image4_ID:  { QImage img; img.loadFromData(image4_data, sizeof(image4_data), "PNG"); return QPixmap::fromImage(img); }
        case image5_ID:  { QImage img; img.loadFromData(image5_data, sizeof(image5_data), "PNG"); return QPixmap::fromImage(img); }
        case image6_ID:  { QImage img; img.loadFromData(image6_data, sizeof(image6_data), "PNG"); return QPixmap::fromImage(img); }
        case image7_ID:  { QImage img; img.loadFromData(image7_data, sizeof(image7_data), "PNG"); return QPixmap::fromImage(img); }
        case image8_ID:  { QImage img; img.loadFromData(image8_data, sizeof(image8_data), "PNG"); return QPixmap::fromImage(img); }
        case image9_ID:  { QImage img; img.loadFromData(image9_data, sizeof(image9_data), "PNG"); return QPixmap::fromImage(img); }
        case image10_ID:  { QImage img; img.loadFromData(image10_data, sizeof(image10_data), "PNG"); return QPixmap::fromImage(img); }
        case image11_ID:  { QImage img; img.loadFromData(image11_data, sizeof(image11_data), "PNG"); return QPixmap::fromImage(img); }
        case image12_ID:  { QImage img; img.loadFromData(image12_data, sizeof(image12_data), "PNG"); return QPixmap::fromImage(img); }
        case image13_ID:  { QImage img; img.loadFromData(image13_data, sizeof(image13_data), "PNG"); return QPixmap::fromImage(img); }
        case image14_ID:  { QImage img; img.loadFromData(image14_data, sizeof(image14_data), "PNG"); return QPixmap::fromImage(img); }
        case image15_ID:  { QImage img; img.loadFromData(image15_data, sizeof(image15_data), "PNG"); return QPixmap::fromImage(img); }
        default: return QPixmap();
    } // switch
    } // icon

};

namespace Ui {
    class QG_DlgText: public Ui_QG_DlgText {};
} // namespace Ui

QT_END_NAMESPACE

class QG_DlgText : public QDialog, public Ui::QG_DlgText
{
    Q_OBJECT

public:
    QG_DlgText(QWidget* parent = 0, const char* name = 0, bool modal = false, Qt::WindowFlags fl = 0);
    ~QG_DlgText();

    virtual int getAlignment();

public slots:
    virtual void updateUniCharComboBox( int );
    virtual void setText( RS_Text & t, bool isNew );
    virtual void updateText();
    virtual void setAlignmentTL();
    virtual void setAlignmentTC();
    virtual void setAlignmentTR();
    virtual void setAlignmentML();
    virtual void setAlignmentMC();
    virtual void setAlignmentMR();
    virtual void setAlignmentBL();
    virtual void setAlignmentBC();
    virtual void setAlignmentBR();
    virtual void setAlignment( int a );
    virtual void setFont( const QString & f );
    virtual void defaultChanged( bool );
    virtual void loadText();
    virtual void load( const QString & fn );
    virtual void saveText();
    virtual void save( const QString & fn );
    virtual void insertSymbol( int );
    virtual void updateUniCharButton( int );
    virtual void insertChar();

protected slots:
    virtual void languageChange();

private:
    bool isNew;
    RS_Text* text;
    RS_Font* font;

    void init();
    void destroy();

};

#endif // QG_DLGTEXT_H
