; libclaw.nsi
;
; Windows installer for Claw, a C++ Library Absolutely Wonderful

;--------------------------------
; Find the position of a given string, starting from the end of an other string
;
; Usage:
;   Push "this is a string"
;   Push "str"
;   Call Strrstr
;   Pop $0
;  ($0 at this point is 10)

Function Strrstr
  Exch $1 ; st=haystack,old$1, $1=needle
  Exch    ; st=old$1,haystack
  Exch $2 ; st=old$1,old$2, $2=haystack
  Push $3 ; len(haystack), result
  Push $4 ; len(needle)
  Push $5 ; tmp

  StrLen $3 $2
  StrLen $4 $1

  loop:
    IntOp $3 $3 - 1
    IntCmp $3 -1 done
    StrCpy $5 $2 $4 $3
    StrCmp $5 $1 done
    Goto loop
  done:
  Pop $5
  Pop $4
  Pop $2
  Pop $1
  Exch $3
FunctionEnd

; same as above
Function un.Strrstr
  Exch $1 ; st=haystack,old$1, $1=needle
  Exch    ; st=old$1,haystack
  Exch $2 ; st=old$1,old$2, $2=haystack
  Push $3 ; len(haystack), result
  Push $4 ; len(needle)
  Push $5 ; tmp

  StrLen $3 $2
  StrLen $4 $1

  loop:
    IntOp $3 $3 - 1
    IntCmp $3 -1 done
    StrCpy $5 $2 $4 $3
    StrCmp $5 $1 done
    Goto loop
  done:
  Pop $5
  Pop $4
  Pop $2
  Pop $1
  Exch $3
FunctionEnd

;--------------------------------

; The name of the installer
Name "Claw Windows installer"

; The file to write
OutFile libclaw.exe

; The default installation directory
InstallDir $PROGRAMFILES\claw
InstallDirRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\libclaw" "UninstallString"

XPStyle on

;--------------------------------

Page license
Page components
Page directory
Page instfiles

;--------------------------------

LicenseData COPYING

InstType Runtime
InstType Development
InstType Full

;--------------------------------
; .dll files
Section "Runtime libraries (required)"

  SectionIn 1 2 3

  ; Set output path to the installation directory.
  SetOutPath "$INSTDIR\lib"
  
  File "*.dll"

  SetOutPath "$INSTDIR\share\doc"

  File COPYING

SectionEnd ; end of "Runtime libraries"

;--------------------------------
; .dll.a files
Section "Static libraries"

  SectionIn 2 3

  ; Set output path to the installation directory.
  SetOutPath "$INSTDIR\lib"
  
  File "*.dll.a"
SectionEnd ; end of "Static libraries"

;--------------------------------
; Library's headers
Section "Source headers"

  SectionIn 2 3

  ; Set output path to the installation directory.
  SetOutPath "$INSTDIR\include\claw"
  
  File "claw\*.hpp"

  ; Set output path to the installation directory.
  SetOutPath "$INSTDIR\include\claw\impl"

  File "claw\impl\*.tpp"
  File "claw\impl\*.ipp"

  ; Set output path to the installation directory.
  SetOutPath "$INSTDIR\include\claw\meta"
  
  File "claw\meta\*.hpp"

  ; Set output path to the installation directory.
  SetOutPath "$INSTDIR\win"

  File "win\definitions.txt"

SectionEnd ; end of "Source headers"

;--------------------------------
; documentation of the classes
Section "Classes documentation"

  SectionIn 2 3

  ; Set output path to the installation directory.
  SetOutPath "$INSTDIR\share\doc\html"
  
  File /r "doc\html\"

SectionEnd ; end of "Classes documentation"

;--------------------------------
; CMake modules for using the library
Section "CMake modules"

  SectionIn 2 3

  ; Check that CMake is installed
  EnumRegKey $0 HKLM "Software\Kitware" 0
  ReadRegStr $1 HKLM "Software\Kitware\$0" ""

  ; extract major and minor version numbers
  Push $1
  Push $0
  Push " "
  Call Strrstr
  Pop $3
  Pop $1
  IntCmp $3 -1 cmake_failed
  IntOp $3 $3 + 1
  StrCpy $3 $0 3 $3

  IfErrors cmake_failed

  ; Set output path to the installation directory.
  SetOutPath $1\share\cmake-$3\Modules
  
  File "cmake-module\FindCLAW*.cmake"

  goto cmake_end

  cmake_failed:
    ClearErrors
    MessageBox MB_OK "CMake not found. Skipping."

  cmake_end:
    ; nothing to do
SectionEnd ; end of "CMake modules"

;--------------------------------
; Example programs
Section "Example programs"

  SectionIn 3

  ; Set output path to the installation directory.
  SetOutPath "$INSTDIR\share\doc\examples"
  
  File /r "examples\"

SectionEnd ; end of "Example programs"

;--------------------------------
Section -PostInstall
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\libclaw" "DisplayName" "Claw library (uninstall)"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\libclaw" "UninstallString" '"$INSTDIR\uninst-libclaw.exe"'
  WriteUninstaller "uninst-libclaw.exe"
SectionEnd

UninstallText "Ready to uninstall Claw."

;--------------------------------
Section "Uninstall"
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\libclaw"
  Delete "$INSTDIR\uninst-libclaw.exe"
  RMDir /r "$INSTDIR\include"
  RMDir /r "$INSTDIR\lib"
  RMDir /r "$INSTDIR\share"
  RMDir /r "$INSTDIR\win"

  ; Check if CMake is installed
  EnumRegKey $0 HKLM "Software\Kitware" 0
  ReadRegStr $1 HKLM "Software\Kitware\$0" ""

  ; extract major and minor version numbers
  Push $1
  Push $0
  Push " "
  Call un.Strrstr
  Pop $3
  Pop $1
  IntCmp $3 -1 cmake_failed
  IntOp $3 $3 + 1
  StrCpy $3 $0 3 $3

  IfErrors cmake_failed

  ; Remove modules for Claw
  Delete "$1\share\cmake-$3\Modules\FindCLAW*.cmake"

  cmake_failed:
    ClearErrors
SectionEnd
