#ifndef _KVI_DYNAMICTOOLTIP_H_
#define _KVI_DYNAMICTOOLTIP_H_

//
//   File : kvi_dynamictooltip.h
//   Creation date : Wed Nov 01 2000 15:23:12 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"
#include <qtooltip.h>
#include <qobject.h>

class KviDynamicToolTip;

class KVIRC_API KviDynamicToolTipHelper : public QToolTip
{
	friend class KviDynamicToolTip;
protected:
	KviDynamicToolTipHelper(QWidget * parent,KviDynamicToolTip * parToolTip);
	virtual ~KviDynamicToolTipHelper();
protected:
	KviDynamicToolTip * m_pParentToolTip;
protected:
	virtual void maybeTip(const QPoint &pnt);
};

class KVIRC_API KviDynamicToolTip : public QObject
{
	friend class KviDynamicToolTipHelper;
	Q_OBJECT
public:
	KviDynamicToolTip(QWidget * parent,const char * name = 0);
	virtual ~KviDynamicToolTip();
protected:
	KviDynamicToolTipHelper * m_pHelper;
public:
	void tip(const QRect &rct,const QString & text);
protected:
	void maybeTip(const QPoint &pnt);
signals:
	void tipRequest(KviDynamicToolTip *tip,const QPoint &pnt);
};

#endif //!_KVI_DYNAMICTOOLTIP_H_
