/***********************************************************************
*                                                                      *
*               This software is part of the ast package               *
*          Copyright (c) 1985-2009 AT&T Intellectual Property          *
*                      and is licensed under the                       *
*                  Common Public License, Version 1.0                  *
*                    by AT&T Intellectual Property                     *
*                                                                      *
*                A copy of the License is available at                 *
*            http://www.opensource.org/licenses/cpl1.0.txt             *
*         (with md5 checksum 059e8cd6165cb4c31e351f2b69388fd9)         *
*                                                                      *
*              Information and Software Systems Research               *
*                            AT&T Research                             *
*                           Florham Park NJ                            *
*                                                                      *
*                 Glenn Fowler <gsf@research.att.com>                  *
*                  David Korn <dgk@research.att.com>                   *
*                   Phong Vo <kpv@research.att.com>                    *
*                                                                      *
***********************************************************************/
/* : : generated by ucs_names-index.c : : */

/*
 * ucs name and alias tables
 * define UCS_BYTE for 8 bit ascii/latin only
 */

#include <ast_common.h>

#define UCS_UC		1
#define UCS_LC		2

typedef uint16_t Ucs_code_t;
typedef uint32_t Ucs_attr_t;

typedef struct Ucs_dat_s
{
	Ucs_attr_t		attr[3];
	Ucs_code_t		code;
	Ucs_code_t		table;
	Ucs_code_t		index;
} Ucs_dat_t;

static const char	ucs_strings_0[] = "\
letter\0\
with\0\
and\0\
digit\0\
form\0\
sign\0\
capital\0\
uc\0\
small\0\
lc\0\
above\0\
acute\0\
alef\0\
alpha\0\
arabic\0\
below\0\
bopomofo\0\
box\0\
breve\0\
caron\0\
cedilla\0\
circled\0\
circumflex\0\
cyrillic\0\
dasia\0\
diaeresis\0\
dot\0\
double\0\
down\0\
drawings\0\
eta\0\
final\0\
full\0\
grave\0\
greek\0\
heavy\0\
hebrew\0\
hiragana\0\
hook\0\
horizontal\0\
horn\0\
initial\0\
iota\0\
isolated\0\
katakana\0\
latin\0\
left\0\
light\0\
line\0\
macron\0\
mark\0\
medial\0\
number\0\
numeral\0\
omega\0\
one\0\
oxia\0\
parenthesized\0\
perispomeni\0\
prosgegrammeni\0\
psili\0\
right\0\
roman\0\
single\0\
tilde\0\
to\0\
up\0\
upsilon\0\
varia\0\
vertical\0\
white\0\
of\0\
stop\0\
"
"black\0\
fraction\0\
vulgar\0\
superscript\0\
subscript\0\
square\0\
ligature\0\
space\0\
indic\0\
ideograph\0\
ideographic\0\
equal\0\
arrow\0\
than\0\
suit\0\
or\0\
bracket\0\
ocr\0\
half\0\
end\0\
big\0\
byelorussian\0\
inverted\0\
middle\0\
ogonek\0\
ring\0\
short\0\
stroke\0\
tonos\0\
ukrainian\0\
upturn\0\
null\0\
nul\0\
nu\0\
start heading\0\
soh\0\
sh\0\
start text\0\
stx\0\
sx\0\
text\0\
etx\0\
ex\0\
transmission\0\
eot\0\
et\0\
enquiry\0\
enq\0\
eq\0\
acknowledge\0\
ack\0\
ak\0\
bell\0\
bel\0\
bl\0\
alert\0\
backspace\0\
bs\0\
tabulation\0\
tab\0\
ht\0\
feed\0\
lf\0\
newline\0\
vt\0\
ff\0\
carriage return\0\
cr\0\
shift out\0\
so\0\
shift in\0\
si\0\
data link escape\0\
dl\0\
dle\0\
"
"device control\0\
d1\0\
dc1\0\
device control two\0\
d2\0\
dc2\0\
device control three\0\
d3\0\
dc3\0\
device control four\0\
d4\0\
dc4\0\
negative acknowledge\0\
nak\0\
nk\0\
synchronous idle\0\
sy\0\
syn\0\
transmission block\0\
eb\0\
etb\0\
cancel\0\
can\0\
cn\0\
medium\0\
em\0\
substitute\0\
sb\0\
sub\0\
escape\0\
ec\0\
esc\0\
file separator\0\
fs\0\
is4\0\
group separator\0\
gs\0\
is3\0\
intro\0\
record separator\0\
is2\0\
rs\0\
unit separator\0\
is1\0\
us\0\
\0\
sp\0\
exclamation\0\
quotation\0\
nb\0\
h-\0\
dollar\0\
do\0\
!s\0\
percent\0\
ampersand\0\
apostrophe\0\
parenthesis\0\
asterisk\0\
plus\0\
comma\0\
hyphen minus\0\
hyphen\0\
period\0\
solidus\0\
slash\0\
zero\0\
two\0\
three\0\
four\0\
five\0\
six\0\
"
"seven\0\
eight\0\
nine\0\
colon\0\
semicolon\0\
less\0\
equals\0\
greater\0\
question\0\
commercial at\0\
at\0\
oa\0\
a\0\
b\0\
c\0\
d\0\
e\0\
f\0\
g\0\
h\0\
i\0\
j\0\
k\0\
l\0\
m\0\
n\0\
o\0\
p\0\
q\0\
r\0\
s\0\
t\0\
u\0\
v\0\
w\0\
x\0\
y\0\
z\0\
reverse solidus\0\
backslash\0\
)>\0\
accent\0\
hat\0\
'>\0\
low\0\
underscore\0\
'!\0\
curly\0\
brace\0\
(!\0\
bar\0\
!)\0\
'?e\0\
delete\0\
del\0\
dt\0\
padding character\0\
pa\0\
pad\0\
high octet preset\0\
ho\0\
hop\0\
break permitted here\0\
bh\0\
bph\0\
no break here\0\
nh\0\
nbh\0\
index\0\
in\0\
ind\0\
next\0\
nl\0\
nel\0\
start selected area\0\
sa\0\
ssa\0\
selected area\0\
es\0\
esa\0\
character tabulation set\0\
hs\0\
"
"hts\0\
character tabulation justification\0\
hj\0\
htj\0\
tabulation set\0\
vs\0\
vts\0\
partial forward\0\
pd\0\
pld\0\
partial backward\0\
pu\0\
plu\0\
reverse feed\0\
ri\0\
shift two\0\
s2\0\
ss2\0\
shift three\0\
s3\0\
ss3\0\
device control string\0\
dc\0\
dcs\0\
private use\0\
p1\0\
pu1\0\
private use two\0\
p2\0\
pu2\0\
set transmit state\0\
ts\0\
sts\0\
cancel character\0\
cc\0\
cch\0\
message waiting\0\
mw\0\
start guarded area\0\
sg\0\
spa\0\
guarded area\0\
eg\0\
epa\0\
start string\0\
sos\0\
graphic character introducer\0\
gc\0\
sgci\0\
character introducer\0\
sc\0\
sci\0\
control sequence introducer\0\
ci\0\
csi\0\
string terminator\0\
st\0\
operating system command\0\
oc\0\
osc\0\
privacy message\0\
pm\0\
application program command\0\
"
"ac\0\
apc\0\
no break\0\
ns\0\
!i\0\
cent\0\
ct\0\
!c\0\
pound\0\
l-\0\
currency\0\
cu\0\
xo\0\
yen\0\
ye\0\
y-\0\
broken bar\0\
bb\0\
!b\0\
section\0\
se\0\
':\0\
copyright\0\
co\0\
feminine ordinal indicator\0\
-a\0\
pointing angle quotation\0\
<<\0\
not\0\
no\0\
7!\0\
soft hyphen\0\
--\0\
registered\0\
rg\0\
'm\0\
degree\0\
dg\0\
plus minus\0\
+-\0\
2s\0\
3s\0\
micro\0\
my\0\
pilcrow\0\
pi\0\
9i\0\
.m\0\
',\0\
1s\0\
masculine ordinal indicator\0\
-o\0\
>>\0\
quarter\0\
14\0\
12\0\
three quarters\0\
34\0\
?i\0\
a!\0\
a'\0\
a>\0\
a?\0\
a:\0\
aa\0\
ae\0\
c,\0\
e!\0\
e'\0\
e>\0\
e:\0\
i!\0\
i'\0\
i>\0\
i:\0\
eth\0\
d-\0\
n?\0\
o!\0\
o'\0\
o>\0\
o?\0\
o:\0\
"
"multiplication\0\
*x\0\
o/\0\
u!\0\
u'\0\
u>\0\
u:\0\
y'\0\
thorn\0\
th\0\
sharp s\0\
ss\0\
division\0\
-:\0\
y:\0\
";

#if !UCS_BYTE
static const char ucs_strings_1[] = "\
a-\0\
a(\0\
a;\0\
c'\0\
c>\0\
c.\0\
c<\0\
d<\0\
d/\0\
e-\0\
e(\0\
e.\0\
e;\0\
e<\0\
g>\0\
g(\0\
g.\0\
g,\0\
h>\0\
h/\0\
i?\0\
i-\0\
i(\0\
i;\0\
i.\0\
dotless i\0\
ij\0\
j>\0\
k,\0\
kra\0\
kk\0\
l'\0\
l,\0\
l<\0\
l.\0\
l/\0\
n'\0\
n,\0\
n<\0\
n preceded by apostrophe\0\
'n\0\
eng\0\
ng\0\
o-\0\
o(\0\
o\"\0\
oe\0\
r'\0\
r,\0\
r<\0\
s'\0\
s>\0\
s,\0\
s<\0\
t,\0\
t<\0\
t/\0\
u?\0\
u-\0\
u(\0\
u0\0\
u\"\0\
u;\0\
w>\0\
y>\0\
z'\0\
z.\0\
z<\0\
long s\0\
s1\0\
b/\0\
b2\0\
c2\0\
f2\0\
k2\0\
o9\0\
oi\0\
yr\0\
u9\0\
z/\0\
ezh\0\
ed\0\
dz\0\
dz<\0\
d z\0\
lj\0\
lj3\0\
l j\0\
nj\0\
nj3\0\
n j\0\
a<\0\
i<\0\
o<\0\
u<\0\
"
"u:-\0\
u:'\0\
u:<\0\
u:!\0\
turned e\0\
e1\0\
a1\0\
a7\0\
a3\0\
g/\0\
g<\0\
k<\0\
o;\0\
o1\0\
ez\0\
j<\0\
dz3\0\
g'\0\
aa'\0\
ae'\0\
o/'\0\
a!!\0\
a)\0\
e!!\0\
e)\0\
i!!\0\
i)\0\
o!!\0\
o)\0\
r!!\0\
r)\0\
u!!\0\
u)\0\
r long leg\0\
r1\0\
modifier turned comma\0\
;s\0\
modifier accent\0\
1>\0\
'<\0\
modifier\0\
1-\0\
1!\0\
'(\0\
'.\0\
'0\0\
';\0\
1?\0\
'\"\0\
combining accent\0\
\"`\0\
\"'\0\
'g\0\
lower\0\
,g\0\
ypogegrammeni\0\
j3\0\
?%\0\
'*\0\
dialytika\0\
'%\0\
a%\0\
ano teleia\0\
.*\0\
epsilon\0\
e%\0\
y%\0\
i%\0\
omicron\0\
o%\0\
u%\0\
w%\0\
i3\0\
a*\0\
beta\0\
b*\0\
gamma\0\
g*\0\
delta\0\
d*\0\
e*\0\
zeta\0\
z*\0\
y*\0\
theta\0\
h*\0\
i*\0\
"
"kappa\0\
k*\0\
lamda\0\
l*\0\
mu\0\
m*\0\
n*\0\
xi\0\
c*\0\
o*\0\
p*\0\
rho\0\
r*\0\
sigma\0\
s*\0\
tau\0\
t*\0\
u*\0\
phi\0\
f*\0\
chi\0\
x*\0\
psi\0\
q*\0\
w*\0\
j*\0\
v*\0\
u3\0\
*s\0\
beta symbol\0\
b3\0\
stigma\0\
t3\0\
digamma\0\
m3\0\
koppa\0\
k3\0\
sampi\0\
p3\0\
io\0\
dje\0\
d%\0\
gje\0\
g%\0\
ie\0\
dze\0\
ds\0\
ii\0\
yi\0\
je\0\
j%\0\
lje\0\
nje\0\
tshe\0\
kje\0\
kj\0\
v%\0\
dzhe\0\
a=\0\
be\0\
b=\0\
ve\0\
v=\0\
ghe\0\
g=\0\
de\0\
d=\0\
e=\0\
zhe\0\
z%\0\
ze\0\
z=\0\
i=\0\
j=\0\
ka\0\
k=\0\
el\0\
l=\0\
m=\0\
en\0\
n=\0\
o=\0\
pe\0\
p=\0\
er\0\
r=\0\
s=\0\
te\0\
t=\0\
u=\0\
ef\0\
f=\0\
ha\0\
h=\0\
tse\0\
c=\0\
"
"che\0\
c%\0\
sha\0\
s%\0\
shcha\0\
hard\0\
=\"\0\
yeru\0\
y=\0\
soft\0\
%\"\0\
yu\0\
ju\0\
ya\0\
ja\0\
='\0\
%'\0\
yat\0\
y3\0\
yus\0\
o3\0\
fita\0\
f3\0\
izhitsa\0\
v3\0\
c3\0\
g3\0\
a+\0\
bet\0\
b+\0\
gimel\0\
g+\0\
dalet\0\
d+\0\
he\0\
h+\0\
vav\0\
w+\0\
zayin\0\
z+\0\
het\0\
x+\0\
tet\0\
tj\0\
yod\0\
j+\0\
kaf\0\
k%\0\
k+\0\
lamed\0\
l+\0\
mem\0\
m%\0\
m+\0\
nun\0\
n%\0\
n+\0\
samekh\0\
s+\0\
ayin\0\
e+\0\
p%\0\
p+\0\
tsadi\0\
zj\0\
qof\0\
q+\0\
resh\0\
r+\0\
shin\0\
tav\0\
t+\0\
,+\0\
;+\0\
?+\0\
hamza\0\
h'\0\
madda\0\
am\0\
ah\0\
waw hamza\0\
wh\0\
yeh hamza\0\
yh\0\
beh\0\
teh marbuta\0\
tm\0\
teh\0\
theh\0\
tk\0\
jeem\0\
hah\0\
"
"hk\0\
khah\0\
dal\0\
thal\0\
dk\0\
reh\0\
zain\0\
seen\0\
sheen\0\
sn\0\
sad\0\
c+\0\
dad\0\
dd\0\
tah\0\
zah\0\
zh\0\
ain\0\
ghain\0\
i+\0\
tatweel\0\
++\0\
feh\0\
f+\0\
qaf\0\
lam\0\
meem\0\
noon\0\
heh\0\
waw\0\
maksura\0\
yeh\0\
y+\0\
fathatan\0\
:+\0\
dammatan\0\
\"+\0\
kasratan\0\
=+\0\
fatha\0\
/+\0\
damma\0\
'+\0\
kasra\0\
1+\0\
shadda\0\
3+\0\
sukun\0\
0+\0\
0a\0\
1a\0\
2a\0\
3a\0\
4a\0\
5a\0\
6a\0\
7a\0\
8a\0\
9a\0\
%a\0\
as\0\
peh\0\
hah hamza\0\
hh\0\
tcheh\0\
tc\0\
jeh\0\
veh\0\
v+\0\
gaf\0\
gf\0\
a-0\0\
b.\0\
b-.\0\
b_\0\
c,'\0\
d.\0\
d-.\0\
d_\0\
d,\0\
d->\0\
e-!\0\
e-'\0\
e->\0\
e-?\0\
e,(\0\
f.\0\
g-\0\
h.\0\
h-.\0\
h:\0\
"
"h,\0\
h-(\0\
i-?\0\
i:'\0\
k'\0\
k-.\0\
k_\0\
l-.\0\
l--.\0\
l_\0\
l->\0\
m'\0\
m.\0\
m-.\0\
n.\0\
n-.\0\
n_\0\
n->\0\
o?'\0\
o?:\0\
o-!\0\
o-'\0\
p'\0\
p.\0\
r.\0\
r-.\0\
r--.\0\
r_\0\
s.\0\
s-.\0\
s'.\0\
s<.\0\
s.-.\0\
t.\0\
t-.\0\
t_\0\
t->\0\
u--:\0\
u-?\0\
u->\0\
u?'\0\
u-:\0\
v?\0\
v-.\0\
w!\0\
w'\0\
w:\0\
w.\0\
w-.\0\
x.\0\
x:\0\
y.\0\
z>\0\
z-.\0\
z_\0\
a-.\0\
a2\0\
a>'\0\
a>!\0\
a>2\0\
a>?\0\
a>-.\0\
a('\0\
a(!\0\
a(2\0\
a(?\0\
a(-.\0\
e-.\0\
e2\0\
e?\0\
e>'\0\
e>!\0\
e>2\0\
e>?\0\
e>-.\0\
i2\0\
i-.\0\
o-.\0\
o2\0\
o>'\0\
o>!\0\
o>2\0\
o>?\0\
o>-.\0\
o9'\0\
o9!\0\
o92\0\
o9?\0\
o9-.\0\
u-.\0\
u2\0\
u9'\0\
u9!\0\
"
"u92\0\
u9?\0\
u9-.\0\
y!\0\
y-.\0\
y2\0\
y?\0\
a*,\0\
a*;\0\
a*,!\0\
a*;!\0\
a*,'\0\
a*;'\0\
a*,?\0\
a*;?\0\
e*,\0\
e*;\0\
e*,!\0\
e*;!\0\
e*,'\0\
e*;'\0\
y*,\0\
y*;\0\
y*,!\0\
y*;!\0\
y*,'\0\
y*;'\0\
y*,?\0\
y*;?\0\
i*,\0\
i*;\0\
i*,!\0\
i*;!\0\
i*,'\0\
i*;'\0\
i*,?\0\
i*;?\0\
o*,\0\
o*;\0\
o*,!\0\
o*;!\0\
o*,'\0\
o*;'\0\
u*,\0\
u*;\0\
u*,!\0\
u*;!\0\
u*,'\0\
u*;'\0\
u*,?\0\
u*;?\0\
w*,\0\
w*;\0\
w*,!\0\
w*;!\0\
w*,'\0\
w*;'\0\
w*,?\0\
w*;?\0\
a*!\0\
a*'\0\
e*!\0\
e*'\0\
y*!\0\
y*'\0\
i*!\0\
i*'\0\
o*!\0\
o*'\0\
u*!\0\
u*'\0\
w*!\0\
w*'\0\
a*,j\0\
a*;j\0\
a*,!j\0\
a*;!j\0\
a*,'j\0\
a*;'j\0\
a*,?j\0\
a*;?j\0\
y*,j\0\
y*;j\0\
y*,!j\0\
y*;!j\0\
y*,'j\0\
"
"y*;'j\0\
y*,?j\0\
y*;?j\0\
w*,j\0\
w*;j\0\
w*,!j\0\
w*;!j\0\
w*,'j\0\
w*;'j\0\
w*,?j\0\
w*;?j\0\
vrachy\0\
a*(\0\
a*-\0\
a*!j\0\
a*j\0\
a*'j\0\
a*?\0\
a*?j\0\
koronis\0\
)*\0\
,,\0\
?*\0\
?:\0\
y*!j\0\
y*j\0\
y*'j\0\
y*?\0\
y*?j\0\
e*!!\0\
,!\0\
,'\0\
?,\0\
i*(\0\
i*-\0\
i*:!\0\
i*:'\0\
i*?\0\
i*:?\0\
;!\0\
;'\0\
?;\0\
u*(\0\
u*-\0\
u*:!\0\
u*:'\0\
r*,\0\
r*;\0\
u*?\0\
u*:?\0\
!:\0\
:'\0\
!*\0\
w*!j\0\
w*j\0\
w*'j\0\
w*?\0\
w*?j\0\
/*\0\
;;\0\
1n\0\
1m\0\
three per em\0\
3m\0\
four per em\0\
4m\0\
six per em\0\
6m\0\
thin\0\
1t\0\
hair\0\
1h\0\
lr\0\
rl\0\
en dash\0\
-n\0\
em dash\0\
-m\0\
-3\0\
!2\0\
=2\0\
'6\0\
'9\0\
low-9 quotation\0\
.9\0\
"
"high reversed-9 quotation\0\
9'\0\
\"6\0\
\"9\0\
:9\0\
9\"\0\
dagger\0\
/-\0\
/=\0\
bullet\0\
triangular bullet\0\
3b\0\
two leader\0\
..\0\
ellipsis\0\
.3\0\
hyphenation point\0\
.-\0\
separator\0\
linesep\0\
paragraph separator\0\
parsep\0\
per mille\0\
%0\0\
prime\0\
1'\0\
2'\0\
triple prime\0\
3'\0\
reversed prime\0\
1\"\0\
2\"\0\
reversed triple prime\0\
3\"\0\
caret\0\
ca\0\
<1\0\
>1\0\
reference\0\
:x\0\
!*2\0\
overline\0\
'-\0\
hyphen bullet\0\
-b\0\
/f\0\
0s\0\
4s\0\
5s\0\
6s\0\
7s\0\
8s\0\
9s\0\
+s\0\
minus\0\
-s\0\
=s\0\
(s\0\
)s\0\
french franc\0\
lira\0\
peseta\0\
won\0\
w=\0\
euro\0\
combining harpoon\0\
\"7\0\
degree celsius\0\
care\0\
degree fahrenheit\0\
numero\0\
n0\0\
sound recording copyright\0\
po\0\
"
"prescription take\0\
rx\0\
service\0\
sm\0\
trade\0\
ohm\0\
om\0\
angstrom\0\
ao\0\
estimated symbol\0\
est\0\
third\0\
13\0\
two thirds\0\
23\0\
fifth\0\
15\0\
two fifths\0\
25\0\
three fifths\0\
35\0\
four fifths\0\
45\0\
sixth\0\
16\0\
five sixths\0\
56\0\
eighth\0\
18\0\
three eighths\0\
38\0\
five eighths\0\
58\0\
seven eighths\0\
78\0\
1r\0\
2r\0\
3r\0\
4r\0\
5r\0\
6r\0\
7r\0\
8r\0\
9r\0\
ten\0\
ar\0\
eleven\0\
br\0\
twelve\0\
fifty\0\
50r\0\
hundred\0\
100r\0\
five hundred\0\
500r\0\
thousand\0\
1000r\0\
thousand c d\0\
1000rcd\0\
five thousand\0\
5000r\0\
ten thousand\0\
10000r\0\
leftwards\0\
<-\0\
upwards\0\
-!\0\
rightwards\0\
->\0\
downwards\0\
-v\0\
<>\0\
ud\0\
north west\0\
<!!\0\
north east\0\
"
"//>\0\
south east\0\
!!>\0\
south west\0\
<//\0\
base\0\
ud-\0\
rightwards harpoon barb upwards\0\
>v\0\
<=\0\
=>\0\
==\0\
for all\0\
fa\0\
partial differential\0\
dp\0\
there exists\0\
empty set\0\
/0\0\
increment\0\
nabla\0\
element\0\
(-\0\
contains as member\0\
-)\0\
proof\0\
fp\0\
n ary product\0\
*p\0\
n ary summation\0\
+z\0\
-2\0\
minus plus\0\
-+\0\
.+\0\
asterisk operator\0\
*-\0\
operator\0\
ob\0\
bullet operator\0\
root\0\
rt\0\
proportional\0\
0(\0\
infinity\0\
00\0\
angle\0\
-l\0\
parallel\0\
pp\0\
logical\0\
an\0\
intersection\0\
(u\0\
union\0\
)u\0\
integral\0\
di\0\
contour integral\0\
therefore\0\
.:\0\
because\0\
:.\0\
ratio\0\
:r\0\
proportion\0\
::\0\
?1\0\
lazy s\0\
cg\0\
asymptotically\0\
"
"?-\0\
approximately\0\
?=\0\
almost\0\
?2\0\
all\0\
=?\0\
image approximately\0\
hi\0\
!=\0\
identical\0\
=3\0\
=<\0\
>=\0\
much less\0\
<*\0\
much greater\0\
*>\0\
not less\0\
!<\0\
not greater\0\
!>\0\
subset\0\
(c\0\
superset\0\
)c\0\
(_\0\
)_\0\
0.\0\
02\0\
tack\0\
-t\0\
.p\0\
:3\0\
house\0\
eh\0\
ceiling\0\
<7\0\
>7\0\
floor\0\
7<\0\
7>\0\
reversed not\0\
ni\0\
arc\0\
(a\0\
telephone recorder\0\
tr\0\
place interest\0\
88\0\
top integral\0\
iu\0\
bottom integral\0\
il\0\
pointing angle\0\
</\0\
/>\0\
open\0\
chair\0\
3h\0\
fork\0\
2h\0\
4h\0\
branch bank identification\0\
1j\0\
amount check\0\
2j\0\
dash\0\
3j\0\
customer account\0\
4j\0\
1-o\0\
2-o\0\
3-o\0\
4-o\0\
5-o\0\
6-o\0\
"
"7-o\0\
8-o\0\
9-o\0\
10-o\0\
11-o\0\
12-o\0\
thirteen\0\
13-o\0\
fourteen\0\
14-o\0\
fifteen\0\
15-o\0\
sixteen\0\
16-o\0\
seventeen\0\
17-o\0\
eighteen\0\
18-o\0\
nineteen\0\
19-o\0\
twenty\0\
20-o\0\
(1)\0\
(2)\0\
(3)\0\
(4)\0\
(5)\0\
(6)\0\
(7)\0\
(8)\0\
(9)\0\
(10)\0\
(11)\0\
(12)\0\
(13)\0\
(14)\0\
(15)\0\
(16)\0\
(17)\0\
(18)\0\
(19)\0\
(20)\0\
1.\0\
2.\0\
3.\0\
4.\0\
5.\0\
6.\0\
7.\0\
8.\0\
9.\0\
10.\0\
11.\0\
12.\0\
13.\0\
14.\0\
15.\0\
16.\0\
17.\0\
18.\0\
19.\0\
20.\0\
(a)\0\
(b)\0\
(c)\0\
(d)\0\
(e)\0\
(f)\0\
(g)\0\
(h)\0\
(i)\0\
(j)\0\
(k)\0\
(l)\0\
(m)\0\
(n)\0\
(o)\0\
(p)\0\
(q)\0\
(r)\0\
(s)\0\
(t)\0\
(u)\0\
(v)\0\
(w)\0\
(x)\0\
(y)\0\
"
"(z)\0\
a o\0\
b o\0\
c o\0\
d o\0\
e o\0\
f o\0\
g o\0\
h o\0\
i o\0\
j o\0\
k o\0\
l o\0\
m o\0\
n o\0\
o o\0\
p o\0\
q o\0\
r o\0\
s o\0\
t o\0\
u o\0\
v o\0\
w o\0\
x o\0\
y o\0\
z o\0\
0-o\0\
_-\0\
hh-\0\
_=\0\
vv\0\
_!\0\
vv-\0\
triple dash\0\
3-\0\
3_\0\
3!\0\
3/\0\
quadruple dash\0\
4-\0\
4_\0\
4!\0\
4/\0\
dr\0\
_v>\0\
dr-\0\
_v<w\0\
dl-\0\
ld-\0\
ur\0\
_a>\0\
ur-\0\
ul\0\
_a<\0\
ul-\0\
vr\0\
_!>\0\
vr-\0\
udr\0\
vl\0\
_!<\0\
vl-\0\
udl\0\
dh\0\
_v-\0\
dlr\0\
dh-\0\
uh\0\
_-a\0\
ulr\0\
uh-\0\
vh\0\
_!-\0\
vlr\0\
vh-\0\
udh\0\
udlr\0\
ld\0\
diagonal upper lower\0\
fd\0\
_>/\0\
bd\0\
upper block\0\
tb\0\
lower block\0\
lb\0\
block\0\
fb\0\
"
"rb\0\
shade\0\
.s\0\
medium shade\0\
:s\0\
dark shade\0\
?s\0\
os\0\
rounded corners\0\
ro\0\
containing\0\
rr\0\
fill\0\
rf\0\
ry\0\
orthogonal crosshatch fill\0\
rh\0\
upper lower fill\0\
rz\0\
rk\0\
diagonal crosshatch fill\0\
rectangle\0\
sr\0\
pointing triangle\0\
ut\0\
pointing pointer\0\
pr\0\
tl\0\
pl\0\
diamond\0\
db\0\
dw\0\
lozenge\0\
lz\0\
circle\0\
0m\0\
bullseye\0\
0o\0\
0l\0\
0r\0\
inverse bullet\0\
inverse circle\0\
ic\0\
lower triangle\0\
_.>/\0\
large circle\0\
star\0\
*2\0\
*1\0\
telephone\0\
tel\0\
pointing index\0\
<h\0\
>h\0\
smiling face\0\
0u\0\
sun rays\0\
su\0\
female\0\
fm\0\
male\0\
ml\0\
spade\0\
cs\0\
heart\0\
ch\0\
cd\0\
club\0\
cs-\0\
ch-\0\
cd-\0\
cc-\0\
quarter note\0\
"
"md\0\
eighth note\0\
m8\0\
_d!\0\
beamed eighth notes\0\
m2\0\
beamed sixteenth notes\0\
m16\0\
music flat\0\
mb\0\
music natural\0\
mx\0\
music sharp\0\
check\0\
ok\0\
ballot x\0\
xx\0\
maltese cross\0\
-x\0\
is\0\
,_\0\
._\0\
ditto\0\
+\"\0\
japanese industrial standard symbol\0\
jis\0\
iteration\0\
*_\0\
closing\0\
;_\0\
0_\0\
<+\0\
>+\0\
corner\0\
<'\0\
>'\0\
<\"\0\
>\"\0\
lenticular\0\
(\"\0\
)\"\0\
postal\0\
=t\0\
geta\0\
=_\0\
tortoise shell\0\
('\0\
)'\0\
(i\0\
)i\0\
wave dash\0\
-?\0\
postal face\0\
=t:)\0\
a5\0\
i5\0\
u5\0\
e5\0\
o5\0\
ga\0\
ki\0\
gi\0\
ku\0\
gu\0\
ke\0\
ge\0\
ko\0\
go\0\
za\0\
zi\0\
zu\0\
zo\0\
ta\0\
da\0\
ti\0\
tu\0\
du\0\
na\0\
ne\0\
ba\0\
bi\0\
"
"hu\0\
bu\0\
bo\0\
ma\0\
mi\0\
me\0\
mo\0\
yo\0\
ra\0\
ru\0\
re\0\
wa\0\
wi\0\
we\0\
wo\0\
n5\0\
vu\0\
voiced sound\0\
\"5\0\
semi voiced sound\0\
05\0\
*5\0\
voiced iteration\0\
+5\0\
a6\0\
i6\0\
u6\0\
e6\0\
o6\0\
n6\0\
va\0\
vi\0\
vo\0\
.6\0\
prolonged sound\0\
-6\0\
*6\0\
+6\0\
b4\0\
p4\0\
m4\0\
f4\0\
t4\0\
n4\0\
l4\0\
g4\0\
k4\0\
h4\0\
j4\0\
q4\0\
x4\0\
r4\0\
z4\0\
c4\0\
s4\0\
a4\0\
o4\0\
e4\0\
eh4\0\
ai\0\
ei\0\
au\0\
ou\0\
ang\0\
i4\0\
u4\0\
v4\0\
gn\0\
hangul cieuc u\0\
(ju)\0\
1c\0\
2c\0\
3c\0\
4c\0\
5c\0\
6c\0\
7c\0\
8c\0\
9c\0\
10c\0\
korean standard symbol\0\
ksc\0\
fi\0\
fl\0\
ffi\0\
ffl\0\
long s t\0\
3+;\0\
h'-\0\
am-\0\
"
"am.\0\
ah-\0\
ah.\0\
wh-\0\
yh,\0\
a+-\0\
a+.\0\
b+-\0\
b+.\0\
b+,\0\
b+;\0\
tm-\0\
tm.\0\
t+-\0\
t+.\0\
t+,\0\
t+;\0\
tk-\0\
tk.\0\
tk,\0\
tk;\0\
g+-\0\
g+.\0\
g+,\0\
g+;\0\
hk-\0\
hk.\0\
hk,\0\
hk;\0\
x+-\0\
x+.\0\
x+,\0\
x+;\0\
d+-\0\
d+.\0\
dk-\0\
dk.\0\
r+-\0\
r+.\0\
z+-\0\
z+.\0\
s+-\0\
s+.\0\
s+,\0\
s+;\0\
sn-\0\
sn.\0\
sn,\0\
sn;\0\
c+-\0\
c+.\0\
c+,\0\
c+;\0\
dd-\0\
dd.\0\
dd,\0\
dd;\0\
tj-\0\
tj.\0\
tj,\0\
tj;\0\
zh-\0\
zh.\0\
zh,\0\
zh;\0\
e+-\0\
e+.\0\
e+,\0\
e+;\0\
i+-\0\
i+.\0\
i+,\0\
i+;\0\
f+-\0\
f+.\0\
f+,\0\
f+;\0\
q+-\0\
q+.\0\
q+,\0\
q+;\0\
k+-\0\
k+.\0\
k+,\0\
k+;\0\
l+-\0\
l+.\0\
l+,\0\
l+;\0\
m+-\0\
m+.\0\
"
"m+,\0\
m+;\0\
n+-\0\
n+.\0\
n+,\0\
n+;\0\
h+-\0\
h+.\0\
h+,\0\
h+;\0\
w+-\0\
w+.\0\
j+-\0\
j+.\0\
y+-\0\
y+.\0\
y+,\0\
y+;\0\
lam madda\0\
lm-\0\
lm.\0\
lam hamza\0\
lh-\0\
lh.\0\
la-\0\
la.\0\
";
#endif /* UCS_BYTE */

static const char*	ucs_strings[] =
{
	&ucs_strings_0[0],
#if !UCS_BYTE
	&ucs_strings_1[0],
#endif /* UCS_BYTE */
};

static const Ucs_dat_t	ucs_attrs[] =
{
	{{0x00000001,0x00000000,0x00000000},0x0000,0,0},
	{{0x00000001,0x00000000,0x00000000},0x0000,0,7},
	{{0x00000001,0x00000000,0x00000000},0x0000,0,12},
	{{0x00000001,0x00000000,0x00000000},0x0000,0,16},
	{{0x00000001,0x00000000,0x00000000},0x0000,0,22},
	{{0x00000001,0x00000000,0x00000000},0x0000,0,27},
	{{0x00000002,0x00000000,0x00000000},0x0001,0,32},
	{{0x00000002,0x00000000,0x00000000},0x0001,0,40},
	{{0x00000004,0x00000000,0x00000000},0x0002,0,43},
	{{0x00000004,0x00000000,0x00000000},0x0002,0,49},
	{{0x00000008,0x00000000,0x00000000},0x0003,0,52},
	{{0x00000010,0x00000000,0x00000000},0x0004,0,58},
	{{0x00000020,0x00000000,0x00000000},0x0005,0,64},
	{{0x00000040,0x00000000,0x00000000},0x0006,0,69},
	{{0x00000080,0x00000000,0x00000000},0x0007,0,75},
	{{0x00000100,0x00000000,0x00000000},0x0008,0,82},
	{{0x00000200,0x00000000,0x00000000},0x0009,0,88},
	{{0x00000400,0x00000000,0x00000000},0x000a,0,97},
	{{0x00000800,0x00000000,0x00000000},0x000b,0,101},
	{{0x00001000,0x00000000,0x00000000},0x000c,0,107},
	{{0x00002000,0x00000000,0x00000000},0x000d,0,113},
	{{0x00004000,0x00000000,0x00000000},0x000e,0,121},
	{{0x00008000,0x00000000,0x00000000},0x000f,0,129},
	{{0x00010000,0x00000000,0x00000000},0x0010,0,140},
	{{0x00020000,0x00000000,0x00000000},0x0011,0,149},
	{{0x00040000,0x00000000,0x00000000},0x0012,0,155},
	{{0x00080000,0x00000000,0x00000000},0x0013,0,165},
	{{0x00100000,0x00000000,0x00000000},0x0014,0,169},
	{{0x00200000,0x00000000,0x00000000},0x0015,0,176},
	{{0x00400000,0x00000000,0x00000000},0x0016,0,181},
	{{0x00800000,0x00000000,0x00000000},0x0017,0,190},
	{{0x01000000,0x00000000,0x00000000},0x0018,0,194},
	{{0x02000000,0x00000000,0x00000000},0x0019,0,200},
	{{0x04000000,0x00000000,0x00000000},0x001a,0,205},
	{{0x08000000,0x00000000,0x00000000},0x001b,0,211},
	{{0x10000000,0x00000000,0x00000000},0x001c,0,217},
	{{0x20000000,0x00000000,0x00000000},0x001d,0,223},
	{{0x40000000,0x00000000,0x00000000},0x001e,0,230},
	{{0x80000000,0x00000000,0x00000000},0x001f,0,239},
	{{0x00000000,0x00000001,0x00000000},0x0020,0,244},
	{{0x00000000,0x00000002,0x00000000},0x0021,0,255},
	{{0x00000000,0x00000004,0x00000000},0x0022,0,260},
	{{0x00000000,0x00000008,0x00000000},0x0023,0,268},
	{{0x00000000,0x00000010,0x00000000},0x0024,0,273},
	{{0x00000000,0x00000020,0x00000000},0x0025,0,282},
	{{0x00000000,0x00000040,0x00000000},0x0026,0,291},
	{{0x00000000,0x00000080,0x00000000},0x0027,0,297},
	{{0x00000000,0x00000100,0x00000000},0x0028,0,302},
	{{0x00000000,0x00000200,0x00000000},0x0029,0,308},
	{{0x00000000,0x00000400,0x00000000},0x002a,0,313},
	{{0x00000000,0x00000800,0x00000000},0x002b,0,320},
	{{0x00000000,0x00001000,0x00000000},0x002c,0,325},
	{{0x00000000,0x00002000,0x00000000},0x002d,0,332},
	{{0x00000000,0x00004000,0x00000000},0x002e,0,339},
	{{0x00000000,0x00008000,0x00000000},0x002f,0,347},
	{{0x00000000,0x00010000,0x00000000},0x0030,0,353},
	{{0x00000000,0x00020000,0x00000000},0x0031,0,357},
	{{0x00000000,0x00040000,0x00000000},0x0032,0,362},
	{{0x00000000,0x00080000,0x00000000},0x0033,0,376},
	{{0x00000000,0x00100000,0x00000000},0x0034,0,388},
	{{0x00000000,0x00200000,0x00000000},0x0035,0,403},
	{{0x00000000,0x00400000,0x00000000},0x0036,0,409},
	{{0x00000000,0x00800000,0x00000000},0x0037,0,415},
	{{0x00000000,0x01000000,0x00000000},0x0038,0,421},
	{{0x00000000,0x02000000,0x00000000},0x0039,0,428},
	{{0x00000000,0x04000000,0x00000000},0x003a,0,434},
	{{0x00000000,0x08000000,0x00000000},0x003b,0,437},
	{{0x00000000,0x10000000,0x00000000},0x003c,0,440},
	{{0x00000000,0x20000000,0x00000000},0x003d,0,448},
	{{0x00000000,0x40000000,0x00000000},0x003e,0,454},
	{{0x00000000,0x80000000,0x00000000},0x003f,0,463},
	{{0x00000000,0x00000000,0x00000001},0x0040,0,469},
	{{0x00000000,0x00000000,0x00000002},0x0041,0,472},
	{{0x00000000,0x00000000,0x00000004},0x0042,0,477},
	{{0x00000000,0x00000000,0x00000008},0x0043,0,483},
	{{0x00000000,0x00000000,0x00000010},0x0044,0,492},
	{{0x00000000,0x00000000,0x00000020},0x0045,0,499},
	{{0x00000000,0x00000000,0x00000040},0x0046,0,511},
	{{0x00000000,0x00000000,0x00000080},0x0047,0,521},
	{{0x00000000,0x00000000,0x00000100},0x0048,0,528},
	{{0x00000000,0x00000000,0x00000200},0x0049,0,537},
	{{0x00000000,0x00000000,0x00000400},0x004a,0,543},
	{{0x00000000,0x00000000,0x00000800},0x004b,0,549},
	{{0x00000000,0x00000000,0x00000800},0x004b,0,559},
	{{0x00000000,0x00000000,0x00001000},0x004c,0,571},
	{{0x00000000,0x00000000,0x00002000},0x004d,0,577},
	{{0x00000000,0x00000000,0x00004000},0x004e,0,583},
	{{0x00000000,0x00000000,0x00008000},0x004f,0,588},
	{{0x00000000,0x00000000,0x00010000},0x0050,0,593},
	{{0x00000000,0x00000000,0x00020000},0x0051,0,596},
	{{0x00000000,0x00000000,0x00040000},0x0052,0,604},
	{{0x00000000,0x00000000,0x00080000},0x0053,0,608},
	{{0x00000000,0x00000000,0x00100000},0x0054,0,613},
	{{0x00000000,0x00000000,0x00200000},0x0055,0,617},
	{{0x00000000,0x00000000,0x00400000},0x0056,0,621},
	{{0x00000000,0x00000000,0x00800000},0x0057,0,634},
	{{0x00000000,0x00000000,0x01000000},0x0058,0,643},
	{{0x00000000,0x00000000,0x02000000},0x0059,0,650},
	{{0x00000000,0x00000000,0x04000000},0x005a,0,657},
	{{0x00000000,0x00000000,0x08000000},0x005b,0,662},
	{{0x00000000,0x00000000,0x10000000},0x005c,0,668},
	{{0x00000000,0x00000000,0x20000000},0x005d,0,675},
	{{0x00000000,0x00000000,0x40000000},0x005e,0,681},
	{{0x00000000,0x00000000,0x80000000},0x005f,0,691},
};

static const Ucs_dat_t	ucs_names[] =
{
	{{0x00000000,0x00000000,0x00000200},0x0020,0,1288},
	{{0x00000001,0x00002000,0x00000000},0x0023,0,1288},
	{{0x00080000,0x00000000,0x00000000},0x002e,0,1288},
	{{0x00000001,0x00010000,0x00000000},0x0031,0,1288},
	{{0x00008000,0x00000000,0x00000000},0x005e,0,1288},
	{{0x00000000,0x02000000,0x00000000},0x007e,0,1288},
	{{0x00040000,0x00000000,0x00000000},0x00a8,0,1288},
	{{0x00000000,0x00000400,0x00000000},0x00af,0,1288},
	{{0x00002000,0x00000000,0x00000000},0x00b8,0,1288},
	{{0x02000000,0x00000000,0x00000002},0x002e,0,1288},
	{{0x00000000,0x40000200,0x00000000},0x007c,0,1288},
	{{0x00080000,0x00000000,0x01000000},0x00b7,0,1288},
	{{0x00000000,0x00010000,0x00000020},0x00b9,0,1288},
	{{0x00000000,0x00400000,0x00020080},0x005d,0,1288},
	{{0x00000000,0x00010000,0x00080018},0x00bd,0,1288},
	{{0x00000000,0x00000000,0x00000000},0x007d,0,1678},
	{{0x00000000,0x00000000,0x00000000},0x00a6,0,2550},
	{{0x00000000,0x00000000,0x00000000},0x00a2,0,2499},
	{{0x00000000,0x00000000,0x00000000},0x00a1,0,2488},
	{{0x00000000,0x00000000,0x00000000},0x0024,0,1330},
	{{0x00000000,0x00000000,0x00000000},0x0060,0,1656},
	{{0x00000000,0x00000000,0x00000000},0x00b8,0,2736},
	{{0x00000000,0x00000000,0x00000000},0x00a8,0,2564},
	{{0x00000000,0x00000000,0x00000000},0x005e,0,1638},
	{{0x00000000,0x00000000,0x00000000},0x007e,0,1681},
	{{0x00000000,0x00000000,0x00000000},0x00af,0,2677},
	{{0x00000000,0x00000000,0x00000000},0x007b,0,1671},
	{{0x00000000,0x00000000,0x00000000},0x005d,0,1624},
	{{0x00000000,0x00000000,0x00000000},0x00d7,0,2899},
	{{0x00000000,0x00000000,0x00000000},0x00b1,0,2701},
	{{0x00000000,0x00000000,0x00000000},0x00ad,0,2660},
	{{0x00000000,0x00000000,0x00000000},0x00f7,0,2949},
	{{0x00000000,0x00000000,0x00000000},0x00aa,0,2607},
	{{0x00000000,0x00000000,0x00000000},0x00ba,0,2770},
	{{0x00000000,0x00000000,0x00000000},0x00b7,0,2733},
	{{0x00000000,0x00000000,0x00000000},0x00bd,0,2787},
	{{0x00000000,0x00000000,0x00000000},0x00bc,0,2784},
	{{0x00000000,0x00000000,0x00000000},0x00b9,0,2739},
	{{0x00000000,0x00000000,0x00000000},0x00b2,0,2704},
	{{0x00000000,0x00000000,0x00000000},0x00be,0,2805},
	{{0x00000000,0x00000000,0x00000000},0x00b3,0,2707},
	{{0x00000000,0x00000000,0x00000000},0x00ac,0,2645},
	{{0x00000000,0x00000000,0x00000000},0x00b6,0,2730},
	{{0x00000000,0x00000000,0x00000000},0x00ab,0,2635},
	{{0x00000000,0x00000000,0x00000000},0x00bb,0,2773},
	{{0x00000000,0x00000000,0x00000000},0x00bf,0,2808},
	{{0x00000003,0x00000040,0x00000000},0x0041,0,1546},
	{{0x00000005,0x00000040,0x00000000},0x0061,0,1546},
	{{0x04000003,0x00000040,0x00000000},0x00c0,0,1546},
	{{0x00000013,0x00000040,0x00000000},0x00c1,0,1546},
	{{0x00008003,0x00000040,0x00000000},0x00c2,0,1546},
	{{0x00000003,0x02000040,0x00000000},0x00c3,0,1546},
	{{0x00040003,0x00000040,0x00000000},0x00c4,0,1546},
	{{0x04000005,0x00000040,0x00000000},0x00e0,0,1546},
	{{0x00000015,0x00000040,0x00000000},0x00e1,0,1546},
	{{0x00008005,0x00000040,0x00000000},0x00e2,0,1546},
	{{0x00000005,0x02000040,0x00000000},0x00e3,0,1546},
	{{0x00040005,0x00000040,0x00000000},0x00e4,0,1546},
	{{0x0000000b,0x00000040,0x04000000},0x00c5,0,1546},
	{{0x0000000d,0x00000040,0x04000000},0x00e5,0,1546},
	{{0x00000000,0x00000000,0x00000000},0x00c0,0,2811},
	{{0x00000000,0x00000000,0x00000000},0x00e0,0,2811},
	{{0x00000000,0x00000000,0x00000000},0x00c1,0,2814},
	{{0x00000000,0x00000000,0x00000000},0x00e1,0,2814},
	{{0x00000000,0x00000000,0x00000000},0x00c4,0,2823},
	{{0x00000000,0x00000000,0x00000000},0x00e4,0,2823},
	{{0x00000000,0x00000000,0x00000000},0x00c2,0,2817},
	{{0x00000000,0x00000000,0x00000000},0x00e2,0,2817},
	{{0x00000000,0x00000000,0x00000000},0x00c3,0,2820},
	{{0x00000000,0x00000000,0x00000000},0x00e3,0,2820},
	{{0x00000000,0x00000000,0x00000000},0x00c5,0,2826},
	{{0x00000000,0x00000000,0x00000000},0x00e5,0,2826},
	{{0x00000000,0x00000000,0x00000000},0x009f,0,2469},
	{{0x00008000,0x00000000,0x00000000},0x005e,0,1627},
	{{0x04000000,0x00000000,0x00000000},0x0060,0,1627},
	{{0x00000010,0x00000000,0x00000000},0x00b4,0,1627},
	{{0x00000000,0x00000000,0x00000000},0x0006,0,808},
	{{0x00000000,0x00000000,0x00000000},0x0006,0,796},
	{{0x00000000,0x00000000,0x00000000},0x00c6,0,2829},
	{{0x00000000,0x00000000,0x00000000},0x00e6,0,2829},
	{{0x00000003,0x00000040,0x00000000},0x00c6,0,2829},
	{{0x00000005,0x00000040,0x00000000},0x00e6,0,2829},
	{{0x00000000,0x00000000,0x00000000},0x0006,0,812},
	{{0x00000000,0x00000000,0x00000000},0x0007,0,827},
	{{0x00000000,0x00000000,0x00000000},0x0026,0,1341},
	{{0x00000000,0x00000000,0x00000000},0x009f,0,2472},
	{{0x00000000,0x00000000,0x00000000},0x0027,0,1351},
	{{0x00000000,0x00000000,0x00000000},0x009f,0,2441},
	{{0x00000000,0x00000000,0x00000000},0x002a,0,1374},
	{{0x00000000,0x00000000,0x00000000},0x0040,0,1540},
	{{0x00000003,0x00000040,0x00000000},0x0042,0,1548},
	{{0x00000005,0x00000040,0x00000000},0x0062,0,1548},
	{{0x00000000,0x00000000,0x00000000},0x005c,0,1614},
	{{0x00000000,0x00000000,0x00000000},0x0008,0,833},
	{{0x00000000,0x00000000,0x00000000},0x007c,0,1674},
	{{0x00000000,0x00000000,0x00000000},0x00a6,0,2547},
	{{0x00000000,0x00000000,0x00000000},0x0007,0,820},
	{{0x00000000,0x00000000,0x00000000},0x0007,0,815},
	{{0x00000000,0x00000000,0x00000000},0x0082,0,1770},
	{{0x00000000,0x00000000,0x00000000},0x0007,0,824},
	{{0x00000000,0x00000000,0x00000000},0x0082,0,1773},
	{{0x00000000,0x00000080,0x00000000},0x007b,0,1665},
	{{0x00000000,0x00400000,0x00000000},0x007d,0,1665},
	{{0x00000000,0x00000000,0x00000000},0x0082,0,1749},
	{{0x00000000,0x00000000,0x00000000},0x00a6,0,2536},
	{{0x00000000,0x00000000,0x00000000},0x0008,0,843},
	{{0x00000003,0x00000040,0x00000000},0x0043,0,1550},
	{{0x00000005,0x00000040,0x00000000},0x0063,0,1550},
	{{0x00002003,0x00000040,0x00000000},0x00c7,0,1550},
	{{0x00002005,0x00000040,0x00000000},0x00e7,0,1550},
	{{0x00000000,0x00000000,0x00000000},0x00c7,0,2832},
	{{0x00000000,0x00000000,0x00000000},0x00e7,0,2832},
	{{0x00000000,0x00000000,0x00000000},0x0018,0,1142},
	{{0x00000000,0x00000000,0x00000000},0x0018,0,1135},
	{{0x00000000,0x00000000,0x00000000},0x0094,0,2163},
	{{0x00000000,0x00000000,0x00000000},0x000d,0,886},
	{{0x00000000,0x00000000,0x00000000},0x0094,0,2180},
	{{0x00000000,0x00000000,0x00000000},0x0094,0,2183},
	{{0x00000001,0x00000000,0x00000000},0x00a2,0,2491},
	{{0x00000000,0x01000000,0x00000000},0x009a,0,2306},
	{{0x00000001,0x00000000,0x00000000},0x0089,0,1903},
	{{0x00000000,0x00000000,0x00000000},0x0088,0,1871},
	{{0x00000000,0x00000000,0x00000000},0x009b,0,2362},
	{{0x00000000,0x00000000,0x00000000},0x0018,0,1146},
	{{0x00000000,0x00000000,0x00000000},0x00a9,0,2577},
	{{0x00000000,0x00000000,0x00000000},0x003a,0,1481},
	{{0x00000000,0x00000000,0x00000000},0x002c,0,1388},
	{{0x00000000,0x00000000,0x00000000},0x0040,0,1526},
	{{0x00000000,0x00000000,0x00000000},0x009b,0,2334},
	{{0x00000001,0x00000000,0x00000000},0x00a9,0,2567},
	{{0x00000000,0x00000000,0x00000000},0x000d,0,902},
	{{0x00000000,0x00000000,0x00000000},0x009b,0,2365},
	{{0x00000000,0x00000000,0x00000000},0x00a2,0,2496},
	{{0x00000000,0x00000000,0x00000000},0x00a4,0,2520},
	{{0x00000000,0x00000080,0x00020000},0x007b,0,1659},
	{{0x00000000,0x00400000,0x00020000},0x007d,0,1659},
	{{0x00000001,0x00000000,0x00000000},0x00a4,0,2511},
	{{0x00000003,0x00000040,0x00000000},0x0044,0,1552},
	{{0x00000005,0x00000040,0x00000000},0x0064,0,1552},
	{{0x00000000,0x00000000,0x00000000},0x00d0,0,2863},
	{{0x00000000,0x00000000,0x00000000},0x00f0,0,2863},
	{{0x00000000,0x00000000,0x00000000},0x0011,0,969},
	{{0x00000000,0x00000000,0x00000000},0x0012,0,995},
	{{0x00000000,0x00000000,0x00000000},0x0013,0,1023},
	{{0x00000000,0x00000000,0x00000000},0x0014,0,1050},
	{{0x00000000,0x00000000,0x00000000},0x0010,0,930},
	{{0x00000000,0x00000000,0x00000000},0x0090,0,2088},
	{{0x00000000,0x00000000,0x00000000},0x0011,0,972},
	{{0x00000000,0x00000000,0x00000000},0x0012,0,998},
	{{0x00000000,0x00000000,0x00000000},0x0013,0,1026},
	{{0x00000000,0x00000000,0x00000000},0x0014,0,1053},
	{{0x00000000,0x00000000,0x00000000},0x0090,0,2091},
	{{0x00000001,0x00000000,0x00000000},0x00b0,0,2680},
	{{0x00000000,0x00000000,0x00000000},0x007f,0,1692},
	{{0x00000000,0x00000000,0x00000000},0x007f,0,1685},
	{{0x00000000,0x00010000,0x00000000},0x0011,0,954},
	{{0x00000000,0x00000000,0x00000000},0x0014,0,1030},
	{{0x00000000,0x00000000,0x00000000},0x0090,0,2066},
	{{0x00000000,0x00000000,0x00000000},0x0013,0,1002},
	{{0x00000000,0x00000000,0x00000000},0x0012,0,976},
	{{0x00000000,0x00000000,0x00000000},0x00b0,0,2687},
	{{0x00000001,0x00000000,0x00000000},0x00f7,0,2940},
	{{0x00000000,0x00000000,0x00000000},0x0010,0,947},
	{{0x00000000,0x00000000,0x00000000},0x0010,0,950},
	{{0x00000000,0x00000000,0x00000000},0x0024,0,1327},
	{{0x00000001,0x00000000,0x00000000},0x0024,0,1320},
	{{0x00000000,0x00000000,0x00000000},0x007f,0,1696},
	{{0x00000003,0x00000040,0x00000000},0x0045,0,1554},
	{{0x00000005,0x00000040,0x00000000},0x0065,0,1554},
	{{0x04000003,0x00000040,0x00000000},0x00c8,0,1554},
	{{0x00000013,0x00000040,0x00000000},0x00c9,0,1554},
	{{0x00008003,0x00000040,0x00000000},0x00ca,0,1554},
	{{0x00040003,0x00000040,0x00000000},0x00cb,0,1554},
	{{0x04000005,0x00000040,0x00000000},0x00e8,0,1554},
	{{0x00000015,0x00000040,0x00000000},0x00e9,0,1554},
	{{0x00008005,0x00000040,0x00000000},0x00ea,0,1554},
	{{0x00040005,0x00000040,0x00000000},0x00eb,0,1554},
	{{0x00000000,0x00000000,0x00000000},0x00c8,0,2835},
	{{0x00000000,0x00000000,0x00000000},0x00e8,0,2835},
	{{0x00000000,0x00000000,0x00000000},0x00c9,0,2838},
	{{0x00000000,0x00000000,0x00000000},0x00e9,0,2838},
	{{0x00000000,0x00000000,0x00000000},0x00cb,0,2844},
	{{0x00000000,0x00000000,0x00000000},0x00eb,0,2844},
	{{0x00000000,0x00000000,0x00000000},0x00ca,0,2841},
	{{0x00000000,0x00000000,0x00000000},0x00ea,0,2841},
	{{0x00000000,0x00000000,0x00000000},0x0017,0,1128},
	{{0x00000000,0x00000000,0x00000000},0x001b,0,1184},
	{{0x00000000,0x00000000,0x00000000},0x0097,0,2245},
	{{0x00000001,0x00000000,0x00000000},0x0038,0,1470},
	{{0x00000000,0x00000000,0x00000000},0x0019,0,1156},
	{{0x00000000,0x00000000,0x00000000},0x0005,0,789},
	{{0x00000000,0x00000000,0x00000000},0x0005,0,781},
	{{0x00000000,0x00000000,0x00000000},0x0004,0,774},
	{{0x00000000,0x00000000,0x00000000},0x0097,0,2248},
	{{0x00000000,0x00000000,0x00000000},0x0005,0,793},
	{{0x00000001,0x00000000,0x00000000},0x003d,0,1502},
	{{0x00000000,0x00000000,0x00000000},0x0087,0,1864},
	{{0x00000000,0x00000000,0x00000000},0x0087,0,1867},
	{{0x00000000,0x00000000,0x00000000},0x001b,0,1187},
	{{0x00000000,0x00000000,0x00000000},0x001b,0,1177},
	{{0x00000000,0x00000000,0x00000000},0x0004,0,778},
	{{0x00000000,0x00000000,0x00000000},0x0017,0,1131},
	{{0x00000003,0x00000040,0x00000000},0x00d0,0,2859},
	{{0x00000005,0x00000040,0x00000000},0x00f0,0,2859},
	{{0x00000000,0x00000000,0x00000000},0x0003,0,754},
	{{0x00000000,0x00000000,0x00000000},0x0003,0,758},
	{{0x00000000,0x00000800,0x00000000},0x0021,0,1292},
	{{0x00000000,0x00000800,0x00800000},0x00a1,0,1292},
	{{0x00000003,0x00000040,0x00000000},0x0046,0,1556},
	{{0x00000005,0x00000040,0x00000000},0x0066,0,1556},
	{{0x00000001,0x00000000,0x00000000},0x000c,0,864},
	{{0x00000000,0x00000200,0x00000000},0x000a,0,864},
	{{0x00000000,0x00000000,0x00000000},0x00aa,0,2580},
	{{0x00000000,0x00000000,0x00000000},0x000c,0,883},
	{{0x00000000,0x00000000,0x00000000},0x001c,0,1191},
	{{0x00000001,0x00000000,0x00000000},0x0035,0,1455},
	{{0x00000001,0x00000000,0x00000000},0x0034,0,1450},
	{{0x00000000,0x00000000,0x00000000},0x001c,0,1206},
	{{0x00000003,0x00000040,0x00000000},0x0047,0,1558},
	{{0x00000005,0x00000040,0x00000000},0x0067,0,1558},
	{{0x00000000,0x00000000,0x00000000},0x0099,0,2298},
	{{0x00000000,0x01000000,0x00000000},0x0099,0,2269},
	{{0x00000001,0x00000000,0x00004000},0x003e,0,1509},
	{{0x00000000,0x00000000,0x00000000},0x001d,0,1213},
	{{0x00000000,0x00000000,0x00000000},0x001d,0,1229},
	{{0x00000000,0x00000000,0x00100001},0x0097,0,2232},
	{{0x00000003,0x00000040,0x00000000},0x0048,0,1560},
	{{0x00000005,0x00000040,0x00000000},0x0068,0,1560},
	{{0x00000000,0x00000000,0x00000000},0x0023,0,1317},
	{{0x00000000,0x00000000,0x00000000},0x005e,0,1634},
	{{0x00000000,0x00000000,0x00000000},0x0081,0,1724},
	{{0x00000000,0x00000000,0x00000000},0x0089,0,1938},
	{{0x00000000,0x00000000,0x00000000},0x0081,0,1742},
	{{0x00000000,0x00000000,0x00000000},0x0081,0,1745},
	{{0x00000000,0x00000000,0x00000000},0x0088,0,1896},
	{{0x00000000,0x00000000,0x00000000},0x0009,0,861},
	{{0x00000000,0x00000000,0x00000000},0x0089,0,1941},
	{{0x00000000,0x00000000,0x00000000},0x0088,0,1899},
	{{0x00000000,0x00000000,0x00000000},0x002d,0,1407},
	{{0x00000000,0x00000000,0x00000000},0x002d,0,1394},
	{{0x00000003,0x00000040,0x00000000},0x0049,0,1562},
	{{0x00000005,0x00000040,0x00000000},0x0069,0,1562},
	{{0x04000003,0x00000040,0x00000000},0x00cc,0,1562},
	{{0x00000013,0x00000040,0x00000000},0x00cd,0,1562},
	{{0x00008003,0x00000040,0x00000000},0x00ce,0,1562},
	{{0x00040003,0x00000040,0x00000000},0x00cf,0,1562},
	{{0x04000005,0x00000040,0x00000000},0x00ec,0,1562},
	{{0x00000015,0x00000040,0x00000000},0x00ed,0,1562},
	{{0x00008005,0x00000040,0x00000000},0x00ee,0,1562},
	{{0x00040005,0x00000040,0x00000000},0x00ef,0,1562},
	{{0x00000000,0x00000000,0x00000000},0x00cc,0,2847},
	{{0x00000000,0x00000000,0x00000000},0x00ec,0,2847},
	{{0x00000000,0x00000000,0x00000000},0x00cd,0,2850},
	{{0x00000000,0x00000000,0x00000000},0x00ed,0,2850},
	{{0x00000000,0x00000000,0x00000000},0x00cf,0,2856},
	{{0x00000000,0x00000000,0x00000000},0x00ef,0,2856},
	{{0x00000000,0x00000000,0x00000000},0x00ce,0,2853},
	{{0x00000000,0x00000000,0x00000000},0x00ee,0,2853},
	{{0x00000000,0x00000000,0x00000000},0x0084,0,1804},
	{{0x00000000,0x00000000,0x00000000},0x0084,0,1807},
	{{0x00000000,0x00000000,0x00000000},0x0084,0,1798},
	{{0x00000000,0x00000000,0x00000000},0x001d,0,1236},
	{{0x00000000,0x00000000,0x00000000},0x001f,0,1281},
	{{0x00000000,0x00000000,0x00000000},0x001e,0,1259},
	{{0x00000000,0x00000000,0x00000000},0x001d,0,1232},
	{{0x00000000,0x00000000,0x00000000},0x001c,0,1209},
	{{0x00000003,0x00000040,0x00000000},0x004a,0,1564},
	{{0x00000005,0x00000040,0x00000000},0x006a,0,1564},
	{{0x00000003,0x00000040,0x00000000},0x004b,0,1566},
	{{0x00000005,0x00000040,0x00000000},0x006b,0,1566},
	{{0x00000003,0x00000040,0x00000000},0x004c,0,1568},
	{{0x00000005,0x00000040,0x00000000},0x006c,0,1568},
	{{0x00000000,0x00000000,0x00000000},0x00a3,0,2508},
	{{0x00000001,0x00000000,0x00004000},0x003c,0,1497},
	{{0x00000000,0x00000000,0x00000000},0x000a,0,869},
	{{0x00000000,0x00000200,0x00000000},0x005f,0,1641},
	{{0x00000003,0x00000040,0x00000000},0x004d,0,1570},
	{{0x00000005,0x00000040,0x00000000},0x006d,0,1570},
	{{0x00000000,0x00000000,0x00000000},0x00ba,0,2742},
	{{0x00000000,0x00000000,0x00100001},0x0019,0,1149},
	{{0x00000000,0x00000000,0x00000000},0x0095,0,2187},
	{{0x00000001,0x00000000,0x00000000},0x00b5,0,2710},
	{{0x00000001,0x00000000,0x00000000},0x00d7,0,2884},
	{{0x00000000,0x00000000,0x00000000},0x0095,0,2203},
	{{0x00000000,0x00000000,0x00000000},0x00b5,0,2716},
	{{0x00000003,0x00000040,0x00000000},0x004e,0,1572},
	{{0x00000005,0x00000040,0x00000000},0x006e,0,1572},
	{{0x00000003,0x02000040,0x00000000},0x00d1,0,1572},
	{{0x00000005,0x02000040,0x00000000},0x00f1,0,1572},
	{{0x00000000,0x00000000,0x00000000},0x00d1,0,2866},
	{{0x00000000,0x00000000,0x00000000},0x00f1,0,2866},
	{{0x00000000,0x00000000,0x00000000},0x0015,0,1078},
	{{0x00000000,0x00000000,0x00000000},0x0023,0,1314},
	{{0x00000000,0x00000000,0x00000000},0x0083,0,1794},
	{{0x00000000,0x00000000,0x00000000},0x0015,0,1057},
	{{0x00000000,0x00000000,0x00000000},0x0085,0,1819},
	{{0x00000000,0x00000000,0x00000000},0x000a,0,872},
	{{0x00000000,0x00000200,0x00000000},0x0085,0,1811},
	{{0x00000000,0x00000000,0x00000000},0x0083,0,1791},
	{{0x00000001,0x00000000,0x00000000},0x0039,0,1476},
	{{0x00000000,0x00000000,0x00000000},0x0015,0,1082},
	{{0x00000000,0x00000000,0x00000000},0x0085,0,1816},
	{{0x00000000,0x00000000,0x00000000},0x00ac,0,2642},
	{{0x00000000,0x00000000,0x00000200},0x00a0,0,2476},
	{{0x00000000,0x00000000,0x00000000},0x0083,0,1777},
	{{0x00000001,0x00000000,0x00000000},0x00ac,0,2638},
	{{0x00000000,0x00000000,0x00000000},0x00a0,0,2485},
	{{0x00000000,0x00000000,0x00000000},0x0000,0,707},
	{{0x00000000,0x00000000,0x00000000},0x0000,0,703},
	{{0x00000000,0x00000000,0x00000000},0x0000,0,698},
	{{0x00000003,0x00000040,0x00000000},0x004f,0,1574},
	{{0x00000005,0x00000040,0x00000000},0x006f,0,1574},
	{{0x04000003,0x00000040,0x00000000},0x00d2,0,1574},
	{{0x00000013,0x00000040,0x00000000},0x00d3,0,1574},
	{{0x00008003,0x00000040,0x00000000},0x00d4,0,1574},
	{{0x00000003,0x02000040,0x00000000},0x00d5,0,1574},
	{{0x00040003,0x00000040,0x00000000},0x00d6,0,1574},
	{{0x00000003,0x00000040,0x10000000},0x00d8,0,1574},
	{{0x04000005,0x00000040,0x00000000},0x00f2,0,1574},
	{{0x00000015,0x00000040,0x00000000},0x00f3,0,1574},
	{{0x00008005,0x00000040,0x00000000},0x00f4,0,1574},
	{{0x00000005,0x02000040,0x00000000},0x00f5,0,1574},
	{{0x00040005,0x00000040,0x00000000},0x00f6,0,1574},
	{{0x00000005,0x00000040,0x10000000},0x00f8,0,1574},
	{{0x00000000,0x00000000,0x00000000},0x00d2,0,2869},
	{{0x00000000,0x00000000,0x00000000},0x00f2,0,2869},
	{{0x00000000,0x00000000,0x00000000},0x00d3,0,2872},
	{{0x00000000,0x00000000,0x00000000},0x00f3,0,2872},
	{{0x00000000,0x00000000,0x00000000},0x00d8,0,2902},
	{{0x00000000,0x00000000,0x00000000},0x00f8,0,2902},
	{{0x00000000,0x00000000,0x00000000},0x00d6,0,2881},
	{{0x00000000,0x00000000,0x00000000},0x00f6,0,2881},
	{{0x00000000,0x00000000,0x00000000},0x00d4,0,2875},
	{{0x00000000,0x00000000,0x00000000},0x00f4,0,2875},
	{{0x00000000,0x00000000,0x00000000},0x00d5,0,2878},
	{{0x00000000,0x00000000,0x00000000},0x00f5,0,2878},
	{{0x00000000,0x00000000,0x00000000},0x0040,0,1543},
	{{0x00000000,0x00000000,0x00000000},0x009d,0,2415},
	{{0x00000000,0x00000000,0x00000000},0x009d,0,2390},
	{{0x00000000,0x00000000,0x00000000},0x009d,0,2418},
	{{0x00000003,0x00000040,0x00000000},0x0050,0,1576},
	{{0x00000005,0x00000040,0x00000000},0x0070,0,1576},
	{{0x00000000,0x00000000,0x00000000},0x0091,0,2107},
	{{0x00000000,0x00000000,0x00000000},0x0092,0,2130},
	{{0x00000000,0x00000000,0x00000000},0x0080,0,1717},
	{{0x00000000,0x00000000,0x00000000},0x0080,0,1720},
	{{0x00000000,0x00000000,0x00000000},0x0080,0,1699},
	{{0x00000000,0x00000080,0x00000000},0x0028,0,1362},
	{{0x00000000,0x00400000,0x00000000},0x0029,0,1362},
	{{0x00000000,0x00000200,0x00000000},0x008c,0,1990},
	{{0x00000000,0x00000200,0x00000000},0x008b,0,1967},
	{{0x00000000,0x00000000,0x00000000},0x008b,0,1983},
	{{0x00000000,0x00000000,0x00000000},0x00a3,0,1983},
	{{0x00000001,0x00000000,0x00000000},0x0025,0,1333},
	{{0x00000000,0x00000000,0x00000000},0x002e,0,1414},
	{{0x00000000,0x00000000,0x00000000},0x00b6,0,2727},
	{{0x00000001,0x00000000,0x00000000},0x00b6,0,2719},
	{{0x00000000,0x00000000,0x00000000},0x008b,0,1986},
	{{0x00000000,0x00000000,0x00000000},0x008c,0,2010},
	{{0x00000001,0x00000000,0x00000000},0x002b,0,1383},
	{{0x00000001,0x00000000,0x00000000},0x00b1,0,2690},
	{{0x00000000,0x00000000,0x00000000},0x009e,0,2438},
	{{0x00100000,0x00000880,0x00000000},0x00ab,0,2610},
	{{0x00100000,0x00400800,0x00000000},0x00bb,0,2610},
	{{0x00000001,0x00000000,0x00000000},0x00a3,0,2502},
	{{0x00000000,0x00000000,0x00000000},0x009e,0,2422},
	{{0x00000000,0x00010000,0x00000000},0x0091,0,2095},
	{{0x00000000,0x00000000,0x00000000},0x0092,0,2114},
	{{0x00000000,0x00000000,0x00000000},0x008c,0,2007},
	{{0x00000000,0x00000000,0x00000000},0x0091,0,2110},
	{{0x00000000,0x00000000,0x00000000},0x0092,0,2133},
	{{0x00000003,0x00000040,0x00000000},0x0051,0,1578},
	{{0x00000005,0x00000040,0x00000000},0x0071,0,1578},
	{{0x00000000,0x00010000,0x00000018},0x00bc,0,2776},
	{{0x00000000,0x00000800,0x00000000},0x003f,0,1517},
	{{0x00000000,0x00000800,0x00800000},0x00bf,0,1517},
	{{0x00000000,0x00000800,0x00000000},0x0022,0,1304},
	{{0x00000003,0x00000040,0x00000000},0x0052,0,1580},
	{{0x00000005,0x00000040,0x00000000},0x0072,0,1580},
	{{0x00000000,0x00000000,0x00000000},0x001e,0,1242},
	{{0x00000001,0x00000000,0x00000000},0x00ae,0,2663},
	{{0x00000000,0x00000200,0x00000000},0x008d,0,2014},
	{{0x00000000,0x00000000,0x00000000},0x005c,0,1598},
	{{0x00000000,0x00000000,0x00000000},0x00ae,0,2674},
	{{0x00000000,0x00000000,0x00000000},0x008d,0,2027},
	{{0x00000000,0x00000000,0x00000000},0x001e,0,1263},
	{{0x00000003,0x00000040,0x00000000},0x0053,0,1582},
	{{0x00000005,0x00000040,0x00000000},0x0073,0,1582},
	{{0x00000000,0x00000000,0x00000000},0x008e,0,2040},
	{{0x00000000,0x00000000,0x00000000},0x008f,0,2059},
	{{0x00000000,0x00000000,0x00000000},0x0086,0,1843},
	{{0x00000000,0x00000000,0x00000000},0x001a,0,1170},
	{{0x00000000,0x00000000,0x00000000},0x009a,0,2327},
	{{0x00000000,0x00000000,0x00000000},0x009a,0,2330},
	{{0x00000000,0x00000000,0x00000000},0x00a7,0,2561},
	{{0x00000001,0x00000000,0x00000000},0x00a7,0,2553},
	{{0x00000000,0x00000000,0x00100001},0x0087,0,1850},
	{{0x00000000,0x00000000,0x00000000},0x003b,0,1487},
	{{0x00000000,0x00000000,0x00000000},0x0093,0,2137},
	{{0x00000001,0x00000000,0x00000000},0x0037,0,1464},
	{{0x00000000,0x00000000,0x00000000},0x0096,0,2225},
	{{0x00000000,0x00000000,0x00000000},0x0099,0,2301},
	{{0x00000000,0x00000000,0x00000000},0x0001,0,728},
	{{0x00000005,0x00000040,0x00000000},0x00df,0,2929},
	{{0x00000000,0x00000000,0x00000000},0x000f,0,918},
	{{0x00000000,0x00000000,0x00000000},0x000e,0,905},
	{{0x00000000,0x01000000,0x00000000},0x008f,0,2047},
	{{0x00000000,0x01000000,0x00000000},0x008e,0,2030},
	{{0x00000000,0x00000000,0x00000000},0x000f,0,927},
	{{0x00000001,0x00000000,0x00000000},0x0036,0,1460},
	{{0x00000000,0x00000000,0x00000000},0x002f,0,1429},
	{{0x00000000,0x00000000,0x00000000},0x000e,0,915},
	{{0x00000000,0x00000000,0x00000000},0x00ad,0,2648},
	{{0x00000000,0x00000000,0x00000000},0x0001,0,724},
	{{0x00000000,0x00000000,0x00000000},0x002f,0,1421},
	{{0x00000000,0x00000000,0x00000000},0x0098,0,2265},
	{{0x00000000,0x00000000,0x00000000},0x0020,0,1289},
	{{0x00000000,0x00000000,0x00000000},0x0096,0,2228},
	{{0x00000000,0x00000000,0x00000000},0x00df,0,2937},
	{{0x00000000,0x00000000,0x00000000},0x008e,0,2043},
	{{0x00000000,0x00000000,0x00000000},0x008f,0,2062},
	{{0x00000000,0x00000000,0x00000000},0x0086,0,1846},
	{{0x00000000,0x00000000,0x00000000},0x009c,0,2387},
	{{0x00000000,0x00000000,0x00000001},0x0096,0,2206},
	{{0x00000000,0x00000000,0x00000001},0x0001,0,710},
	{{0x00000000,0x00000000,0x00000001},0x0086,0,1823},
	{{0x00000000,0x00000000,0x00000001},0x0098,0,2252},
	{{0x00000000,0x00000000,0x00000001},0x0002,0,731},
	{{0x00000000,0x00000000,0x00000000},0x009c,0,2369},
	{{0x00000000,0x00000000,0x00000000},0x0093,0,2159},
	{{0x00000000,0x00000000,0x00000000},0x0002,0,742},
	{{0x00000000,0x00000000,0x00000000},0x001a,0,1173},
	{{0x00000000,0x00000000,0x00000000},0x001a,0,1159},
	{{0x00000000,0x00000000,0x00000000},0x0002,0,746},
	{{0x00000000,0x00000000,0x00000000},0x0016,0,1102},
	{{0x00000000,0x00000000,0x00000000},0x0016,0,1105},
	{{0x00000000,0x00000000,0x00000000},0x0016,0,1085},
	{{0x00000003,0x00000040,0x00000000},0x0054,0,1584},
	{{0x00000005,0x00000040,0x00000000},0x0074,0,1584},
	{{0x00000000,0x00000000,0x00000000},0x0009,0,857},
	{{0x00000000,0x00000001,0x00000000},0x0009,0,857},
	{{0x00000000,0x40000000,0x00000000},0x000b,0,857},
	{{0x00000000,0x00000001,0x00000000},0x0009,0,846},
	{{0x00000000,0x40000000,0x00000000},0x000b,0,846},
	{{0x00000000,0x00000200,0x00000000},0x008a,0,1945},
	{{0x00000000,0x00000000,0x00100001},0x0003,0,749},
	{{0x00000000,0x00000000,0x00000000},0x00de,0,2926},
	{{0x00000000,0x00000000,0x00000000},0x00fe,0,2926},
	{{0x00000003,0x00000040,0x00000000},0x00de,0,2920},
	{{0x00000005,0x00000040,0x00000000},0x00fe,0,2920},
	{{0x00000001,0x00000000,0x00000000},0x0033,0,1444},
	{{0x00000000,0x00000000,0x00000020},0x00b3,0,1444},
	{{0x00000000,0x00000000,0x00000018},0x00be,0,2790},
	{{0x00000000,0x00000000,0x00100001},0x0004,0,761},
	{{0x00000000,0x00000000,0x00100001},0x0017,0,1109},
	{{0x00000000,0x00000000,0x00000000},0x0093,0,2156},
	{{0x00000001,0x00000000,0x00000000},0x0032,0,1440},
	{{0x00000000,0x00000000,0x00000020},0x00b2,0,1440},
	{{0x00000003,0x00000040,0x00000000},0x0055,0,1586},
	{{0x00000005,0x00000040,0x00000000},0x0075,0,1586},
	{{0x04000003,0x00000040,0x00000000},0x00d9,0,1586},
	{{0x00000013,0x00000040,0x00000000},0x00da,0,1586},
	{{0x00008003,0x00000040,0x00000000},0x00db,0,1586},
	{{0x00040003,0x00000040,0x00000000},0x00dc,0,1586},
	{{0x04000005,0x00000040,0x00000000},0x00f9,0,1586},
	{{0x00000015,0x00000040,0x00000000},0x00fa,0,1586},
	{{0x00008005,0x00000040,0x00000000},0x00fb,0,1586},
	{{0x00040005,0x00000040,0x00000000},0x00fc,0,1586},
	{{0x00000000,0x00000000,0x00000000},0x00d9,0,2905},
	{{0x00000000,0x00000000,0x00000000},0x00f9,0,2905},
	{{0x00000000,0x00000000,0x00000000},0x00da,0,2908},
	{{0x00000000,0x00000000,0x00000000},0x00fa,0,2908},
	{{0x00000000,0x00000000,0x00000000},0x00dc,0,2914},
	{{0x00000000,0x00000000,0x00000000},0x00fc,0,2914},
	{{0x00000000,0x00000000,0x00000000},0x00db,0,2911},
	{{0x00000000,0x00000000,0x00000000},0x00fb,0,2911},
	{{0x00000000,0x00000000,0x00000000},0x005f,0,1645},
	{{0x00000000,0x00000000,0x00000000},0x001f,0,1266},
	{{0x00000000,0x00000000,0x00000000},0x001f,0,1285},
	{{0x00000003,0x00000040,0x00000000},0x0056,0,1588},
	{{0x00000005,0x00000040,0x00000000},0x0076,0,1588},
	{{0x00000000,0x00000000,0x00000000},0x008a,0,1960},
	{{0x00000000,0x00000000,0x00000000},0x000b,0,880},
	{{0x00000000,0x00000000,0x00000000},0x008a,0,1963},
	{{0x00000003,0x00000040,0x00000000},0x0057,0,1590},
	{{0x00000005,0x00000040,0x00000000},0x0077,0,1590},
	{{0x00000003,0x00000040,0x00000000},0x0058,0,1592},
	{{0x00000005,0x00000040,0x00000000},0x0078,0,1592},
	{{0x00000000,0x00000000,0x00000000},0x00a4,0,2523},
	{{0x00000003,0x00000040,0x00000000},0x0059,0,1594},
	{{0x00000005,0x00000040,0x00000000},0x0079,0,1594},
	{{0x00000013,0x00000040,0x00000000},0x00dd,0,1594},
	{{0x00000015,0x00000040,0x00000000},0x00fd,0,1594},
	{{0x00040005,0x00000040,0x00000000},0x00ff,0,1594},
	{{0x00000000,0x00000000,0x00000000},0x00dd,0,2917},
	{{0x00000000,0x00000000,0x00000000},0x00fd,0,2917},
	{{0x00000000,0x00000000,0x00000000},0x00a5,0,2533},
	{{0x00000000,0x00000000,0x00000000},0x00ff,0,2952},
	{{0x00000000,0x00000000,0x00000000},0x00a5,0,2530},
	{{0x00000001,0x00000000,0x00000000},0x00a5,0,2526},
	{{0x00000003,0x00000040,0x00000000},0x005a,0,1596},
	{{0x00000005,0x00000040,0x00000000},0x007a,0,1596},
	{{0x00000001,0x00000000,0x00000000},0x0030,0,1435},
#if !UCS_BYTE
	{{0x00001000,0x00000000,0x00000000},0x02c7,0,1288},
	{{0x00000800,0x00000000,0x00000000},0x02d8,0,1288},
	{{0x00000000,0x00000000,0x02000000},0x02db,0,1288},
	{{0x00000000,0x00000000,0x00000001},0x2109,0,1288},
	{{0x00000000,0x00000000,0x00010000},0x2228,0,1288},
	{{0x00000000,0x00000000,0x00010000},0x25ad,0,1288},
	{{0x00080008,0x00000000,0x00000000},0x02d9,0,1288},
	{{0x00000008,0x00000000,0x04000000},0x02da,0,1288},
	{{0x00000004,0x02000000,0x00000000},0x02dc,0,1288},
	{{0x08000001,0x00004000,0x00000000},0x0374,0,1288},
	{{0x08000000,0x00000000,0x20000000},0x0384,0,1288},
	{{0x20000021,0x00000000,0x00000000},0x05d0,0,1288},
	{{0x000000a1,0x00000000,0x00000000},0x0627,0,1288},
	{{0x08000000,0x00100000,0x00000000},0x1fbe,0,1288},
	{{0x08000000,0x00200000,0x00000000},0x1fbf,0,1288},
	{{0x08000000,0x00080000,0x00000000},0x1fc0,0,1288},
	{{0x08000000,0x20000000,0x00000000},0x1fef,0,1288},
	{{0x08000000,0x00020000,0x00000000},0x1ffd,0,1288},
	{{0x08020000,0x00000000,0x00000000},0x1ffe,0,1288},
	{{0x00000000,0x00010000,0x00000040},0x2081,0,1288},
	{{0x80000000,0x00000000,0x00040000},0x2440,0,1288},
	{{0x00004001,0x00010000,0x00000000},0x2460,0,1288},
	{{0x00000001,0x00050000,0x00000000},0x2474,0,1288},
	{{0x00000000,0x00000000,0x00000084},0x25a0,0,1288},
	{{0x00000000,0x80000000,0x00000080},0x25a1,0,1288},
	{{0x00000000,0x00000000,0x00000a00},0x3000,0,1288},
	{{0x40000001,0x04000000,0x00000000},0x3068,0,1288},
	{{0x00000001,0x04000020,0x00000000},0x30c8,0,1288},
	{{0x08000043,0x00000000,0x00000000},0x0391,0,1288},
	{{0x08800003,0x00000000,0x00000000},0x0397,0,1288},
	{{0x08000003,0x00000008,0x00000000},0x0399,0,1288},
	{{0x08000003,0x10000000,0x00000000},0x03a5,0,1288},
	{{0x08000003,0x00008000,0x00000000},0x03a9,0,1288},
	{{0x08000045,0x00000000,0x00000000},0x03b1,0,1288},
	{{0x08800005,0x00000000,0x00000000},0x03b7,0,1288},
	{{0x08000005,0x00000008,0x00000000},0x03b9,0,1288},
	{{0x08000005,0x10000000,0x00000000},0x03c5,0,1288},
	{{0x08000005,0x00008000,0x00000000},0x03c9,0,1288},
	{{0x00000081,0x00010000,0x00000400},0x0661,0,1288},
	{{0x000000a1,0x00000000,0x00000020},0x0670,0,1288},
	{{0x08000001,0x20200000,0x00000000},0x1fcd,0,1288},
	{{0x08000001,0x00220000,0x00000000},0x1fce,0,1288},
	{{0x08000001,0x00280000,0x00000000},0x1fcf,0,1288},
	{{0x08020001,0x20000000,0x00000000},0x1fdd,0,1288},
	{{0x08020001,0x00020000,0x00000000},0x1fde,0,1288},
	{{0x08020001,0x00080000,0x00000000},0x1fdf,0,1288},
	{{0x00100000,0x40000200,0x00000000},0x2016,0,1288},
	{{0x00000000,0x00814000,0x00000000},0x2160,0,1288},
	{{0x00000000,0x00400080,0x00002000},0x2194,0,1288},
	{{0x00200000,0x08000000,0x00002000},0x2195,0,1288},
	{{0x02000001,0x00010000,0x00000002},0x2488,0,1288},
	{{0x00000004,0x00000000,0x00000084},0x25aa,0,1288},
	{{0x02000000,0x00000000,0x00000802},0x3002,0,1288},
	{{0x00080000,0x00000020,0x01000000},0x30fb,0,1288},
	{{0x00000000,0x00050000,0x00000800},0x3220,0,1288},
	{{0x000000a1,0x00000010,0x00000000},0xfe8d,0,1288},
	{{0x010000a1,0x00000000,0x00000000},0xfe8e,0,1288},
	{{0x08000043,0x00000000,0x20000000},0x0386,0,1288},
	{{0x08800003,0x00000000,0x20000000},0x0389,0,1288},
	{{0x08000003,0x00000008,0x20000000},0x038a,0,1288},
	{{0x08000003,0x10000000,0x20000000},0x038e,0,1288},
	{{0x08000003,0x00008000,0x20000000},0x038f,0,1288},
	{{0x08000045,0x00000000,0x20000000},0x03ac,0,1288},
	{{0x08800005,0x00000000,0x20000000},0x03ae,0,1288},
	{{0x08000005,0x00000008,0x20000000},0x03af,0,1288},
	{{0x08000005,0x10000000,0x20000000},0x03cd,0,1288},
	{{0x08000005,0x00008000,0x20000000},0x03ce,0,1288},
	{{0x08000045,0x00200000,0x00000000},0x1f00,0,1288},
	{{0x08020045,0x00000000,0x00000000},0x1f01,0,1288},
	{{0x08000043,0x00200000,0x00000000},0x1f08,0,1288},
	{{0x08020043,0x00000000,0x00000000},0x1f09,0,1288},
	{{0x08800005,0x00200000,0x00000000},0x1f20,0,1288},
	{{0x08820005,0x00000000,0x00000000},0x1f21,0,1288},
	{{0x08800003,0x00200000,0x00000000},0x1f28,0,1288},
	{{0x08820003,0x00000000,0x00000000},0x1f29,0,1288},
	{{0x08000005,0x00200008,0x00000000},0x1f30,0,1288},
	{{0x08020005,0x00000008,0x00000000},0x1f31,0,1288},
	{{0x08000003,0x00200008,0x00000000},0x1f38,0,1288},
	{{0x08020003,0x00000008,0x00000000},0x1f39,0,1288},
	{{0x08000005,0x10200000,0x00000000},0x1f50,0,1288},
	{{0x08020005,0x10000000,0x00000000},0x1f51,0,1288},
	{{0x08020003,0x10000000,0x00000000},0x1f59,0,1288},
	{{0x08000005,0x00208000,0x00000000},0x1f60,0,1288},
	{{0x08020005,0x00008000,0x00000000},0x1f61,0,1288},
	{{0x08000003,0x00208000,0x00000000},0x1f68,0,1288},
	{{0x08020003,0x00008000,0x00000000},0x1f69,0,1288},
	{{0x08000045,0x20000000,0x00000000},0x1f70,0,1288},
	{{0x08000045,0x00020000,0x00000000},0x1f71,0,1288},
	{{0x08800005,0x20000000,0x00000000},0x1f74,0,1288},
	{{0x08800005,0x00020000,0x00000000},0x1f75,0,1288},
	{{0x08000005,0x20000008,0x00000000},0x1f76,0,1288},
	{{0x08000005,0x00020008,0x00000000},0x1f77,0,1288},
	{{0x08000005,0x30000000,0x00000000},0x1f7a,0,1288},
	{{0x08000005,0x10020000,0x00000000},0x1f7b,0,1288},
	{{0x08000005,0x20008000,0x00000000},0x1f7c,0,1288},
	{{0x08000005,0x00028000,0x00000000},0x1f7d,0,1288},
	{{0x08000045,0x00000400,0x00000000},0x1fb1,0,1288},
	{{0x08000045,0x00080000,0x00000000},0x1fb6,0,1288},
	{{0x08000043,0x00000400,0x00000000},0x1fb9,0,1288},
	{{0x08000043,0x20000000,0x00000000},0x1fba,0,1288},
	{{0x08000043,0x00020000,0x00000000},0x1fbb,0,1288},
	{{0x08000043,0x00100000,0x00000000},0x1fbc,0,1288},
	{{0x08800005,0x00080000,0x00000000},0x1fc6,0,1288},
	{{0x08800003,0x20000000,0x00000000},0x1fca,0,1288},
	{{0x08800003,0x00020000,0x00000000},0x1fcb,0,1288},
	{{0x08800003,0x00100000,0x00000000},0x1fcc,0,1288},
	{{0x08000005,0x00000408,0x00000000},0x1fd1,0,1288},
	{{0x08000005,0x00080008,0x00000000},0x1fd6,0,1288},
	{{0x08000003,0x00000408,0x00000000},0x1fd9,0,1288},
	{{0x08000003,0x20000008,0x00000000},0x1fda,0,1288},
	{{0x08000003,0x00020008,0x00000000},0x1fdb,0,1288},
	{{0x08000005,0x10000400,0x00000000},0x1fe1,0,1288},
	{{0x08000005,0x10080000,0x00000000},0x1fe6,0,1288},
	{{0x08000003,0x10000400,0x00000000},0x1fe9,0,1288},
	{{0x08000003,0x30000000,0x00000000},0x1fea,0,1288},
	{{0x08000003,0x10020000,0x00000000},0x1feb,0,1288},
	{{0x08000005,0x00088000,0x00000000},0x1ff6,0,1288},
	{{0x08000003,0x20008000,0x00000000},0x1ffa,0,1288},
	{{0x08000003,0x00028000,0x00000000},0x1ffb,0,1288},
	{{0x08000003,0x00108000,0x00000000},0x1ffc,0,1288},
	{{0x00000000,0x04400880,0x00000000},0x200e,0,1288},
	{{0x00000000,0x04400880,0x00000000},0x200f,0,1288},
	{{0x00000004,0x00814000,0x00000000},0x2170,0,1288},
	{{0x00100000,0x00400080,0x00002000},0x21d4,0,1288},
	{{0x00400400,0x00000101,0x00000000},0x2500,0,1288},
	{{0x10400400,0x00000001,0x00000000},0x2501,0,1288},
	{{0x00400400,0x40000100,0x00000000},0x2502,0,1288},
	{{0x10400400,0x40000000,0x00000000},0x2503,0,1288},
	{{0x00500400,0x00000001,0x00000000},0x2550,0,1288},
	{{0x00500400,0x40000000,0x00000000},0x2551,0,1288},
	{{0x08000045,0x20200000,0x00000000},0x1f02,0,1288},
	{{0x08020045,0x20000000,0x00000000},0x1f03,0,1288},
	{{0x08000045,0x00220000,0x00000000},0x1f04,0,1288},
	{{0x08020045,0x00020000,0x00000000},0x1f05,0,1288},
	{{0x08000045,0x00280000,0x00000000},0x1f06,0,1288},
	{{0x08020045,0x00080000,0x00000000},0x1f07,0,1288},
	{{0x08000043,0x20200000,0x00000000},0x1f0a,0,1288},
	{{0x08020043,0x20000000,0x00000000},0x1f0b,0,1288},
	{{0x08000043,0x00220000,0x00000000},0x1f0c,0,1288},
	{{0x08020043,0x00020000,0x00000000},0x1f0d,0,1288},
	{{0x08000043,0x00280000,0x00000000},0x1f0e,0,1288},
	{{0x08020043,0x00080000,0x00000000},0x1f0f,0,1288},
	{{0x08800005,0x20200000,0x00000000},0x1f22,0,1288},
	{{0x08820005,0x20000000,0x00000000},0x1f23,0,1288},
	{{0x08800005,0x00220000,0x00000000},0x1f24,0,1288},
	{{0x08820005,0x00020000,0x00000000},0x1f25,0,1288},
	{{0x08800005,0x00280000,0x00000000},0x1f26,0,1288},
	{{0x08820005,0x00080000,0x00000000},0x1f27,0,1288},
	{{0x08800003,0x20200000,0x00000000},0x1f2a,0,1288},
	{{0x08820003,0x20000000,0x00000000},0x1f2b,0,1288},
	{{0x08800003,0x00220000,0x00000000},0x1f2c,0,1288},
	{{0x08820003,0x00020000,0x00000000},0x1f2d,0,1288},
	{{0x08800003,0x00280000,0x00000000},0x1f2e,0,1288},
	{{0x08820003,0x00080000,0x00000000},0x1f2f,0,1288},
	{{0x08000005,0x20200008,0x00000000},0x1f32,0,1288},
	{{0x08020005,0x20000008,0x00000000},0x1f33,0,1288},
	{{0x08000005,0x00220008,0x00000000},0x1f34,0,1288},
	{{0x08020005,0x00020008,0x00000000},0x1f35,0,1288},
	{{0x08000005,0x00280008,0x00000000},0x1f36,0,1288},
	{{0x08020005,0x00080008,0x00000000},0x1f37,0,1288},
	{{0x08000003,0x20200008,0x00000000},0x1f3a,0,1288},
	{{0x08020003,0x20000008,0x00000000},0x1f3b,0,1288},
	{{0x08000003,0x00220008,0x00000000},0x1f3c,0,1288},
	{{0x08020003,0x00020008,0x00000000},0x1f3d,0,1288},
	{{0x08000003,0x00280008,0x00000000},0x1f3e,0,1288},
	{{0x08020003,0x00080008,0x00000000},0x1f3f,0,1288},
	{{0x08000005,0x30200000,0x00000000},0x1f52,0,1288},
	{{0x08020005,0x30000000,0x00000000},0x1f53,0,1288},
	{{0x08000005,0x10220000,0x00000000},0x1f54,0,1288},
	{{0x08020005,0x10020000,0x00000000},0x1f55,0,1288},
	{{0x08000005,0x10280000,0x00000000},0x1f56,0,1288},
	{{0x08020005,0x10080000,0x00000000},0x1f57,0,1288},
	{{0x08020003,0x30000000,0x00000000},0x1f5b,0,1288},
	{{0x08020003,0x10020000,0x00000000},0x1f5d,0,1288},
	{{0x08020003,0x10080000,0x00000000},0x1f5f,0,1288},
	{{0x08000005,0x20208000,0x00000000},0x1f62,0,1288},
	{{0x08020005,0x20008000,0x00000000},0x1f63,0,1288},
	{{0x08000005,0x00228000,0x00000000},0x1f64,0,1288},
	{{0x08020005,0x00028000,0x00000000},0x1f65,0,1288},
	{{0x08000005,0x00288000,0x00000000},0x1f66,0,1288},
	{{0x08020005,0x00088000,0x00000000},0x1f67,0,1288},
	{{0x08000003,0x20208000,0x00000000},0x1f6a,0,1288},
	{{0x08020003,0x20008000,0x00000000},0x1f6b,0,1288},
	{{0x08000003,0x00228000,0x00000000},0x1f6c,0,1288},
	{{0x08020003,0x00028000,0x00000000},0x1f6d,0,1288},
	{{0x08000003,0x00288000,0x00000000},0x1f6e,0,1288},
	{{0x08020003,0x00088000,0x00000000},0x1f6f,0,1288},
	{{0x08000043,0x00300000,0x00000000},0x1f88,0,1288},
	{{0x08020043,0x00100000,0x00000000},0x1f89,0,1288},
	{{0x08800003,0x00300000,0x00000000},0x1f98,0,1288},
	{{0x08820003,0x00100000,0x00000000},0x1f99,0,1288},
	{{0x08000003,0x00308000,0x00000000},0x1fa8,0,1288},
	{{0x08020003,0x00108000,0x00000000},0x1fa9,0,1288},
	{{0x00600401,0x00400100,0x00000000},0x250c,0,1288},
	{{0x10600401,0x00400000,0x00000000},0x250f,0,1288},
	{{0x00600401,0x00000180,0x00000000},0x2510,0,1288},
	{{0x10600401,0x00000080,0x00000000},0x2513,0,1288},
	{{0x00400401,0x08400100,0x00000000},0x2514,0,1288},
	{{0x10400401,0x08400000,0x00000000},0x2517,0,1288},
	{{0x00400401,0x08000180,0x00000000},0x2518,0,1288},
	{{0x10400401,0x08000080,0x00000000},0x251b,0,1288},
	{{0x00400401,0x40400100,0x00000000},0x251c,0,1288},
	{{0x10400401,0x40400000,0x00000000},0x2523,0,1288},
	{{0x00400401,0x40000180,0x00000000},0x2524,0,1288},
	{{0x10400401,0x40000080,0x00000000},0x252b,0,1288},
	{{0x00600401,0x00000101,0x00000000},0x252c,0,1288},
	{{0x10600401,0x00000001,0x00000000},0x2533,0,1288},
	{{0x00400401,0x08000101,0x00000000},0x2534,0,1288},
	{{0x10400401,0x08000001,0x00000000},0x253b,0,1288},
	{{0x00400401,0x40000101,0x00000000},0x253c,0,1288},
	{{0x10400401,0x40000001,0x00000000},0x254b,0,1288},
	{{0x00700401,0x00400000,0x00000000},0x2554,0,1288},
	{{0x00700401,0x00000080,0x00000000},0x2557,0,1288},
	{{0x00500401,0x08400000,0x00000000},0x255a,0,1288},
	{{0x00500401,0x08000080,0x00000000},0x255d,0,1288},
	{{0x00500401,0x40400000,0x00000000},0x2560,0,1288},
	{{0x00500401,0x40000080,0x00000000},0x2563,0,1288},
	{{0x00700401,0x00000001,0x00000000},0x2566,0,1288},
	{{0x00500401,0x08000001,0x00000000},0x2569,0,1288},
	{{0x00500401,0x40000001,0x00000000},0x256c,0,1288},
	{{0x08000043,0x20300000,0x00000000},0x1f8a,0,1288},
	{{0x08020043,0x20100000,0x00000000},0x1f8b,0,1288},
	{{0x08000043,0x00320000,0x00000000},0x1f8c,0,1288},
	{{0x08020043,0x00120000,0x00000000},0x1f8d,0,1288},
	{{0x08000043,0x00380000,0x00000000},0x1f8e,0,1288},
	{{0x08020043,0x00180000,0x00000000},0x1f8f,0,1288},
	{{0x08800003,0x20300000,0x00000000},0x1f9a,0,1288},
	{{0x08820003,0x20100000,0x00000000},0x1f9b,0,1288},
	{{0x08800003,0x00320000,0x00000000},0x1f9c,0,1288},
	{{0x08820003,0x00120000,0x00000000},0x1f9d,0,1288},
	{{0x08800003,0x00380000,0x00000000},0x1f9e,0,1288},
	{{0x08820003,0x00180000,0x00000000},0x1f9f,0,1288},
	{{0x08000003,0x20308000,0x00000000},0x1faa,0,1288},
	{{0x08020003,0x20108000,0x00000000},0x1fab,0,1288},
	{{0x08000003,0x00328000,0x00000000},0x1fac,0,1288},
	{{0x08020003,0x00128000,0x00000000},0x1fad,0,1288},
	{{0x08000003,0x00388000,0x00000000},0x1fae,0,1288},
	{{0x08020003,0x00188000,0x00000000},0x1faf,0,1288},
	{{0x10600401,0x00400100,0x00000000},0x250d,0,1288},
	{{0x10600401,0x00400100,0x00000000},0x250e,0,1288},
	{{0x10600401,0x00000180,0x00000000},0x2511,0,1288},
	{{0x10600401,0x00000180,0x00000000},0x2512,0,1288},
	{{0x10400401,0x08400100,0x00000000},0x2515,0,1288},
	{{0x10400401,0x08400100,0x00000000},0x2516,0,1288},
	{{0x10400401,0x08000180,0x00000000},0x2519,0,1288},
	{{0x10400401,0x08000180,0x00000000},0x251a,0,1288},
	{{0x10400401,0x40400100,0x00000000},0x251d,0,1288},
	{{0x10400401,0x40400100,0x00000000},0x2520,0,1288},
	{{0x10400401,0x40000180,0x00000000},0x2525,0,1288},
	{{0x10400401,0x40000180,0x00000000},0x2528,0,1288},
	{{0x10600401,0x00000101,0x00000000},0x252f,0,1288},
	{{0x10600401,0x00000101,0x00000000},0x2530,0,1288},
	{{0x10400401,0x08000101,0x00000000},0x2537,0,1288},
	{{0x10400401,0x08000101,0x00000000},0x2538,0,1288},
	{{0x10400401,0x40000101,0x00000000},0x253f,0,1288},
	{{0x10400401,0x40000101,0x00000000},0x2542,0,1288},
	{{0x00700401,0x01400000,0x00000000},0x2552,0,1288},
	{{0x00700401,0x01400000,0x00000000},0x2553,0,1288},
	{{0x00700401,0x01000080,0x00000000},0x2555,0,1288},
	{{0x00700401,0x01000080,0x00000000},0x2556,0,1288},
	{{0x00500401,0x09400000,0x00000000},0x2558,0,1288},
	{{0x00500401,0x09400000,0x00000000},0x2559,0,1288},
	{{0x00500401,0x09000080,0x00000000},0x255b,0,1288},
	{{0x00500401,0x09000080,0x00000000},0x255c,0,1288},
	{{0x00500401,0x41400000,0x00000000},0x255e,0,1288},
	{{0x00500401,0x41400000,0x00000000},0x255f,0,1288},
	{{0x00500401,0x41000080,0x00000000},0x2561,0,1288},
	{{0x00500401,0x41000080,0x00000000},0x2562,0,1288},
	{{0x00700401,0x01000001,0x00000000},0x2564,0,1288},
	{{0x00700401,0x01000001,0x00000000},0x2565,0,1288},
	{{0x00500401,0x09000001,0x00000000},0x2567,0,1288},
	{{0x00500401,0x09000001,0x00000000},0x2568,0,1288},
	{{0x00500401,0x41000001,0x00000000},0x256a,0,1288},
	{{0x00500401,0x41000001,0x00000000},0x256b,0,1288},
	{{0x10600401,0x08400100,0x00000000},0x251e,0,1288},
	{{0x10600401,0x08400100,0x00000000},0x251f,0,1288},
	{{0x10600401,0x08400100,0x00000000},0x2521,0,1288},
	{{0x10600401,0x08400100,0x00000000},0x2522,0,1288},
	{{0x10600401,0x08000180,0x00000000},0x2526,0,1288},
	{{0x10600401,0x08000180,0x00000000},0x2527,0,1288},
	{{0x10600401,0x08000180,0x00000000},0x2529,0,1288},
	{{0x10600401,0x08000180,0x00000000},0x252a,0,1288},
	{{0x10600401,0x00400180,0x00000000},0x252d,0,1288},
	{{0x10600401,0x00400180,0x00000000},0x252e,0,1288},
	{{0x10600401,0x00400180,0x00000000},0x2531,0,1288},
	{{0x10600401,0x00400180,0x00000000},0x2532,0,1288},
	{{0x10400401,0x08400180,0x00000000},0x2535,0,1288},
	{{0x10400401,0x08400180,0x00000000},0x2536,0,1288},
	{{0x10400401,0x08400180,0x00000000},0x2539,0,1288},
	{{0x10400401,0x08400180,0x00000000},0x253a,0,1288},
	{{0x10400401,0x40400180,0x00000000},0x253d,0,1288},
	{{0x10400401,0x40400180,0x00000000},0x253e,0,1288},
	{{0x10600401,0x08000101,0x00000000},0x2540,0,1288},
	{{0x10600401,0x08000101,0x00000000},0x2541,0,1288},
	{{0x10600401,0x08000101,0x00000000},0x2547,0,1288},
	{{0x10600401,0x08000101,0x00000000},0x2548,0,1288},
	{{0x10400401,0x40400180,0x00000000},0x2549,0,1288},
	{{0x10400401,0x40400180,0x00000000},0x254a,0,1288},
	{{0x10600401,0x08400180,0x00000000},0x2543,0,1288},
	{{0x10600401,0x08400180,0x00000000},0x2544,0,1288},
	{{0x10600401,0x08400180,0x00000000},0x2545,0,1288},
	{{0x10600401,0x08400180,0x00000000},0x2546,0,1288},
	{{0x00000000,0x00000000,0x00000000},0x2198,1,3955},
	{{0x00000000,0x00000000,0x00000000},0x1fef,1,2787},
	{{0x00000000,0x00000000,0x00000000},0x203c,1,3237},
	{{0x00000000,0x00000000,0x00000000},0x2016,1,2917},
	{{0x00000000,0x00000000,0x00000000},0x1fed,1,2781},
	{{0x00000000,0x00000000,0x00000000},0x226e,1,4568},
	{{0x00000000,0x00000000,0x00000000},0x2260,1,4508},
	{{0x00000000,0x00000000,0x00000000},0x226f,1,4583},
	{{0x00000000,0x00000000,0x00000000},0x0301,1,560},
	{{0x00000000,0x00000000,0x00000000},0x064c,1,1587},
	{{0x00000000,0x00000000,0x00000000},0x309b,1,6688},
	{{0x00000000,0x00000000,0x00000000},0x201c,1,2977},
	{{0x00000000,0x00000000,0x00000000},0x20d1,1,3370},
	{{0x00000000,0x00000000,0x00000000},0x201d,1,2980},
	{{0x00000000,0x00000000,0x00000000},0x0300,1,557},
	{{0x00000000,0x00000000,0x00000000},0x042c,1,1100},
	{{0x00000000,0x00000000,0x00000000},0x044c,1,1118},
	{{0x00000000,0x00000000,0x00000000},0x2030,1,3132},
	{{0x00000000,0x00000000,0x00000000},0x066a,1,1678},
	{{0x00000000,0x00000000,0x00000000},0x02dd,1,537},
	{{0x00000000,0x00000000,0x00000000},0x0385,1,608},
	{{0x00000000,0x00000000,0x00000000},0x02d8,1,522},
	{{0x00000000,0x00000000,0x00000000},0x0384,1,595},
	{{0x00000000,0x00000000,0x00000000},0x064f,1,1617},
	{{0x00000000,0x00000000,0x00000000},0x203e,1,3250},
	{{0x00000000,0x00000000,0x00000000},0x02d9,1,525},
	{{0x00000000,0x00000000,0x00000000},0x02da,1,528},
	{{0x00000000,0x00000000,0x00000000},0x2018,1,2923},
	{{0x00000000,0x00000000,0x00000000},0x2019,1,2926},
	{{0x00000000,0x00000000,0x00000000},0x02db,1,531},
	{{0x00000000,0x00000000,0x00000000},0x02c7,1,504},
	{{0x00000000,0x00000000,0x00000000},0x0374,1,563},
	{{0x00000000,0x00000000,0x00000000},0x0149,1,150},
	{{0x00000000,0x00000000,0x00000000},0x3010,1,6462},
	{{0x00000000,0x00000000,0x00000000},0x3014,1,6501},
	{{0x00000000,0x00000000,0x00000000},0x2208,1,4112},
	{{0x00000000,0x00000000,0x00000000},0x2474,1,5047},
	{{0x00000000,0x00000000,0x00000000},0x247d,1,5083},
	{{0x00000000,0x00000000,0x00000000},0x247e,1,5088},
	{{0x00000000,0x00000000,0x00000000},0x247f,1,5093},
	{{0x00000000,0x00000000,0x00000000},0x2480,1,5098},
	{{0x00000000,0x00000000,0x00000000},0x2481,1,5103},
	{{0x00000000,0x00000000,0x00000000},0x2482,1,5108},
	{{0x00000000,0x00000000,0x00000000},0x2483,1,5113},
	{{0x00000000,0x00000000,0x00000000},0x2484,1,5118},
	{{0x00000000,0x00000000,0x00000000},0x2485,1,5123},
	{{0x00000000,0x00000000,0x00000000},0x2486,1,5128},
	{{0x00000000,0x00000000,0x00000000},0x2475,1,5051},
	{{0x00000000,0x00000000,0x00000000},0x2487,1,5133},
	{{0x00000000,0x00000000,0x00000000},0x2476,1,5055},
	{{0x00000000,0x00000000,0x00000000},0x2477,1,5059},
	{{0x00000000,0x00000000,0x00000000},0x2478,1,5063},
	{{0x00000000,0x00000000,0x00000000},0x2479,1,5067},
	{{0x00000000,0x00000000,0x00000000},0x247a,1,5071},
	{{0x00000000,0x00000000,0x00000000},0x247b,1,5075},
	{{0x00000000,0x00000000,0x00000000},0x247c,1,5079},
	{{0x00000000,0x00000000,0x00000000},0x2286,1,4608},
	{{0x00000000,0x00000000,0x00000000},0x2312,1,4689},
	{{0x00000000,0x00000000,0x00000000},0x249c,1,5209},
	{{0x00000000,0x00000000,0x00000000},0x249d,1,5213},
	{{0x00000000,0x00000000,0x00000000},0x2282,1,4593},
	{{0x00000000,0x00000000,0x00000000},0x249e,1,5217},
	{{0x00000000,0x00000000,0x00000000},0x249f,1,5221},
	{{0x00000000,0x00000000,0x00000000},0x24a0,1,5225},
	{{0x00000000,0x00000000,0x00000000},0x24a1,1,5229},
	{{0x00000000,0x00000000,0x00000000},0x24a2,1,5233},
	{{0x00000000,0x00000000,0x00000000},0x24a3,1,5237},
	{{0x00000000,0x00000000,0x00000000},0x3016,1,6507},
	{{0x00000000,0x00000000,0x00000000},0x24a4,1,5241},
	{{0x00000000,0x00000000,0x00000000},0x24a5,1,5245},
	{{0x00000000,0x00000000,0x00000000},0x321c,1,6897},
	{{0x00000000,0x00000000,0x00000000},0x24a6,1,5249},
	{{0x00000000,0x00000000,0x00000000},0x24a7,1,5253},
	{{0x00000000,0x00000000,0x00000000},0x24a8,1,5257},
	{{0x00000000,0x00000000,0x00000000},0x24a9,1,5261},
	{{0x00000000,0x00000000,0x00000000},0x24aa,1,5265},
	{{0x00000000,0x00000000,0x00000000},0x24ab,1,5269},
	{{0x00000000,0x00000000,0x00000000},0x24ac,1,5273},
	{{0x00000000,0x00000000,0x00000000},0x24ad,1,5277},
	{{0x00000000,0x00000000,0x00000000},0x207d,1,3309},
	{{0x00000000,0x00000000,0x00000000},0x208d,1,3309},
	{{0x00000000,0x00000000,0x00000000},0x24ae,1,5281},
	{{0x00000000,0x00000000,0x00000000},0x24af,1,5285},
	{{0x00000000,0x00000000,0x00000000},0x2229,1,4332},
	{{0x00000000,0x00000000,0x00000000},0x24b0,1,5289},
	{{0x00000000,0x00000000,0x00000000},0x24b1,1,5293},
	{{0x00000000,0x00000000,0x00000000},0x24b2,1,5297},
	{{0x00000000,0x00000000,0x00000000},0x24b3,1,5301},
	{{0x00000000,0x00000000,0x00000000},0x24b4,1,5305},
	{{0x00000000,0x00000000,0x00000000},0x24b5,1,5309},
	{{0x00000000,0x00000000,0x00000000},0x3011,1,6465},
	{{0x00000000,0x00000000,0x00000000},0x3015,1,6504},
	{{0x00000000,0x00000000,0x00000000},0x1fbd,1,2661},
	{{0x00000000,0x00000000,0x00000000},0x2287,1,4611},
	{{0x00000000,0x00000000,0x00000000},0x2283,1,4605},
	{{0x00000000,0x00000000,0x00000000},0x3017,1,6510},
	{{0x00000000,0x00000000,0x00000000},0x207e,1,3312},
	{{0x00000000,0x00000000,0x00000000},0x208e,1,3312},
	{{0x00000000,0x00000000,0x00000000},0x222a,1,4341},
	{{0x00000000,0x00000000,0x00000000},0x2217,1,4220},
	{{0x00000000,0x00000000,0x00000000},0x2606,1,6049},
	{{0x00000000,0x00000000,0x00000000},0x2605,1,6046},
	{{0x00000000,0x00000000,0x00000000},0x309d,1,6712},
	{{0x00000000,0x00000000,0x00000000},0x30fd,1,6784},
	{{0x00000000,0x00000000,0x00000000},0x226b,1,4556},
	{{0x00000000,0x00000000,0x00000000},0x3005,1,6409},
	{{0x00000000,0x00000000,0x00000000},0x220f,1,4160},
	{{0x00000000,0x00000000,0x00000000},0x03c2,1,818},
	{{0x00000000,0x00000000,0x00000000},0x3003,1,6356},
	{{0x00000000,0x00000000,0x00000000},0x0640,1,1515},
	{{0x00000000,0x00000000,0x00000000},0x309e,1,6732},
	{{0x00000000,0x00000000,0x00000000},0x30fe,1,6787},
	{{0x00000000,0x00000000,0x00000000},0x207a,1,3294},
	{{0x00000000,0x00000000,0x00000000},0x208a,1,3294},
	{{0x00000000,0x00000000,0x00000000},0x2211,1,4179},
	{{0x00000000,0x00000000,0x00000000},0x1fcd,1,2701},
	{{0x00000000,0x00000000,0x00000000},0x1fce,1,2704},
	{{0x00000000,0x00000000,0x00000000},0x060c,1,1330},
	{{0x00000000,0x00000000,0x00000000},0x1fbf,1,2664},
	{{0x00000000,0x00000000,0x00000000},0x3001,1,6344},
	{{0x00000000,0x00000000,0x00000000},0x0375,1,572},
	{{0x00000000,0x00000000,0x00000000},0x2191,1,3878},
	{{0x00000000,0x00000000,0x00000000},0x220b,1,4134},
	{{0x00000000,0x00000000,0x00000000},0x2213,1,4196},
	{{0x00000000,0x00000000,0x00000000},0x2212,1,4182},
	{{0x00000000,0x00000000,0x00000000},0x2015,1,2914},
	{{0x00000000,0x00000000,0x00000000},0x30fc,1,6781},
	{{0x00000000,0x00000000,0x00000000},0x2192,1,3892},
	{{0x00000000,0x00000000,0x00000000},0x301c,1,6523},
	{{0x00000000,0x00000000,0x00000000},0x2043,1,3267},
	{{0x00000000,0x00000000,0x00000000},0x221f,1,4293},
	{{0x00000000,0x00000000,0x00000000},0x2014,1,2911},
	{{0x00000000,0x00000000,0x00000000},0x2013,1,2900},
	{{0x00000000,0x00000000,0x00000000},0x207b,1,3303},
	{{0x00000000,0x00000000,0x00000000},0x208b,1,3303},
	{{0x00000000,0x00000000,0x00000000},0x22a5,1,4625},
	{{0x00000000,0x00000000,0x00000000},0x2193,1,3905},
	{{0x00000000,0x00000000,0x00000000},0x2220,1,3905},
	{{0x00000000,0x00000000,0x00000000},0x2720,1,6338},
	{{0x00000000,0x00000000,0x00000000},0x0387,1,625},
	{{0x00000000,0x00000000,0x00000000},0x2214,1,4199},
	{{0x00000000,0x00000000,0x00000000},0x2027,1,3074},
	{{0x00000000,0x00000000,0x00000000},0x2025,1,3041},
	{{0x00000000,0x00000000,0x00000000},0x2026,1,3053},
	{{0x00000000,0x00000000,0x00000000},0x30fb,1,6762},
	{{0x00000000,0x00000000,0x00000000},0x201a,1,2945},
	{{0x00000000,0x00000000,0x00000000},0x2234,1,4383},
	{{0x00000000,0x00000000,0x00000000},0x3002,1,6347},
	{{0x00000000,0x00000000,0x00000000},0x22c5,1,4628},
	{{0x00000000,0x00000000,0x00000000},0x2591,1,5704},
	{{0x00000000,0x00000000,0x00000000},0x1ffd,1,2813},
	{{0x00000000,0x00000000,0x00000000},0x064e,1,1608},
	{{0x00000000,0x00000000,0x00000000},0x2020,1,2996},
	{{0x00000000,0x00000000,0x00000000},0x2197,1,3940},
	{{0x00000000,0x00000000,0x00000000},0x2205,1,4085},
	{{0x00000000,0x00000000,0x00000000},0x2021,1,2999},
	{{0x00000000,0x00000000,0x00000000},0x232a,1,4785},
	{{0x00000000,0x00000000,0x00000000},0x2044,1,3270},
	{{0x00000000,0x00000000,0x00000000},0x221d,1,4272},
	{{0x00000000,0x00000000,0x00000000},0x0652,1,1645},
	{{0x00000000,0x00000000,0x00000000},0x24ea,1,5417},
	{{0x00000000,0x00000000,0x00000000},0x2299,1,4614},
	{{0x00000000,0x00000000,0x00000000},0x221e,1,4284},
	{{0x00000000,0x00000000,0x00000000},0x229a,1,4617},
	{{0x00000000,0x00000000,0x00000000},0x309c,1,6709},
	{{0x00000000,0x00000000,0x00000000},0x3007,1,6423},
	{{0x00000000,0x00000000,0x00000000},0x0660,1,1648},
	{{0x00000000,0x00000000,0x00000000},0x25d0,1,5969},
	{{0x00000000,0x00000000,0x00000000},0x25cb,1,5954},
	{{0x00000000,0x00000000,0x00000000},0x25cf,1,5954},
	{{0x00000000,0x00000000,0x00000000},0x25ce,1,5966},
	{{0x00000000,0x00000000,0x00000000},0x25d1,1,5972},
	{{0x00000000,0x00000000,0x00000000},0x2070,1,3273},
	{{0x00000000,0x00000000,0x00000000},0x2080,1,3273},
	{{0x00000000,0x00000000,0x00000000},0x263a,1,6100},
	{{0x00000000,0x00000000,0x00000000},0x263b,1,6100},
	{{0x00000000,0x00000000,0x00000000},0x02cb,1,519},
	{{0x00000000,0x00000000,0x00000000},0x2035,1,3178},
	{{0x00000000,0x00000000,0x00000000},0x2032,1,3141},
	{{0x00000000,0x00000000,0x00000000},0x0650,1,1626},
	{{0x00000000,0x00000000,0x00000000},0x02c9,1,516},
	{{0x00000000,0x00000000,0x00000000},0x2460,1,4887},
	{{0x00000000,0x00000000,0x00000000},0x2488,1,5138},
	{{0x00000000,0x00000000,0x00000000},0x2469,1,4923},
	{{0x00000000,0x00000000,0x00000000},0x2491,1,5165},
	{{0x00000000,0x00000000,0x00000000},0x2182,1,3850},
	{{0x00000000,0x00000000,0x00000000},0x216f,1,3790},
	{{0x00000000,0x00000000,0x00000000},0x217f,1,3790},
	{{0x00000000,0x00000000,0x00000000},0x2180,1,3809},
	{{0x00000000,0x00000000,0x00000000},0x216d,1,3758},
	{{0x00000000,0x00000000,0x00000000},0x217d,1,3758},
	{{0x00000000,0x00000000,0x00000000},0x3229,1,6929},
	{{0x00000000,0x00000000,0x00000000},0x246a,1,4928},
	{{0x00000000,0x00000000,0x00000000},0x2492,1,5169},
	{{0x00000000,0x00000000,0x00000000},0x246b,1,4933},
	{{0x00000000,0x00000000,0x00000000},0x2493,1,5173},
	{{0x00000000,0x00000000,0x00000000},0x2153,1,3534},
	{{0x00000000,0x00000000,0x00000000},0x246c,1,4947},
	{{0x00000000,0x00000000,0x00000000},0x2494,1,5177},
	{{0x00000000,0x00000000,0x00000000},0x246d,1,4961},
	{{0x00000000,0x00000000,0x00000000},0x2495,1,5181},
	{{0x00000000,0x00000000,0x00000000},0x2155,1,3557},
	{{0x00000000,0x00000000,0x00000000},0x246e,1,4974},
	{{0x00000000,0x00000000,0x00000000},0x2496,1,5185},
	{{0x00000000,0x00000000,0x00000000},0x2159,1,3611},
	{{0x00000000,0x00000000,0x00000000},0x246f,1,4987},
	{{0x00000000,0x00000000,0x00000000},0x2497,1,5189},
	{{0x00000000,0x00000000,0x00000000},0x2470,1,5002},
	{{0x00000000,0x00000000,0x00000000},0x2498,1,5193},
	{{0x00000000,0x00000000,0x00000000},0x215b,1,3636},
	{{0x00000000,0x00000000,0x00000000},0x2471,1,5016},
	{{0x00000000,0x00000000,0x00000000},0x2499,1,5197},
	{{0x00000000,0x00000000,0x00000000},0x2472,1,5030},
	{{0x00000000,0x00000000,0x00000000},0x249a,1,5201},
	{{0x00000000,0x00000000,0x00000000},0x02c6,1,501},
	{{0x00000000,0x00000000,0x00000000},0x02dc,1,534},
	{{0x00000000,0x00000000,0x00000000},0x0661,1,1651},
	{{0x00000000,0x00000000,0x00000000},0x3220,1,6902},
	{{0x00000000,0x00000000,0x00000000},0x200a,1,2883},
	{{0x00000000,0x00000000,0x00000000},0x2440,1,2883},
	{{0x00000000,0x00000000,0x00000000},0x2446,1,4840},
	{{0x00000000,0x00000000,0x00000000},0x2003,1,2822},
	{{0x00000000,0x00000000,0x00000000},0x2002,1,2819},
	{{0x00000000,0x00000000,0x00000000},0x2160,1,3689},
	{{0x00000000,0x00000000,0x00000000},0x2170,1,3689},
	{{0x00000000,0x00000000,0x00000000},0x2081,0,2739},
	{{0x00000000,0x00000000,0x00000000},0x2009,1,2875},
	{{0x00000000,0x00000000,0x00000000},0x2036,1,3181},
	{{0x00000000,0x00000000,0x00000000},0x2033,1,3144},
	{{0x00000000,0x00000000,0x00000000},0x2461,1,4891},
	{{0x00000000,0x00000000,0x00000000},0x2489,1,5141},
	{{0x00000000,0x00000000,0x00000000},0x2473,1,5042},
	{{0x00000000,0x00000000,0x00000000},0x249b,1,5205},
	{{0x00000000,0x00000000,0x00000000},0x2154,1,3548},
	{{0x00000000,0x00000000,0x00000000},0x2156,1,3571},
	{{0x00000000,0x00000000,0x00000000},0x0662,1,1654},
	{{0x00000000,0x00000000,0x00000000},0x3221,1,6905},
	{{0x00000000,0x00000000,0x00000000},0x2442,1,4807},
	{{0x00000000,0x00000000,0x00000000},0x2447,1,4856},
	{{0x00000000,0x00000000,0x00000000},0x2161,1,3692},
	{{0x00000000,0x00000000,0x00000000},0x2171,1,3692},
	{{0x00000000,0x00000000,0x00000000},0x2082,0,2704},
	{{0x00000000,0x00000000,0x00000000},0x2506,1,5459},
	{{0x00000000,0x00000000,0x00000000},0x2037,1,3206},
	{{0x00000000,0x00000000,0x00000000},0x2034,1,3160},
	{{0x00000000,0x00000000,0x00000000},0x0651,1,1636},
	{{0x00000000,0x00000000,0x00000000},0xfe7d,1,6983},
	{{0x00000000,0x00000000,0x00000000},0x2504,1,5453},
	{{0x00000000,0x00000000,0x00000000},0x2462,1,4895},
	{{0x00000000,0x00000000,0x00000000},0x248a,1,5144},
	{{0x00000000,0x00000000,0x00000000},0x2507,1,5462},
	{{0x00000000,0x00000000,0x00000000},0x2157,1,3587},
	{{0x00000000,0x00000000,0x00000000},0x215c,1,3653},
	{{0x00000000,0x00000000,0x00000000},0x2505,1,5456},
	{{0x00000000,0x00000000,0x00000000},0x0663,1,1657},
	{{0x00000000,0x00000000,0x00000000},0x2023,1,3027},
	{{0x00000000,0x00000000,0x00000000},0x3222,1,6908},
	{{0x00000000,0x00000000,0x00000000},0x2441,1,4799},
	{{0x00000000,0x00000000,0x00000000},0x2448,1,4864},
	{{0x00000000,0x00000000,0x00000000},0x2004,1,2838},
	{{0x00000000,0x00000000,0x00000000},0x2162,1,3695},
	{{0x00000000,0x00000000,0x00000000},0x2172,1,3695},
	{{0x00000000,0x00000000,0x00000000},0x2083,0,2707},
	{{0x00000000,0x00000000,0x00000000},0x250a,1,5486},
	{{0x00000000,0x00000000,0x00000000},0x2508,1,5480},
	{{0x00000000,0x00000000,0x00000000},0x2463,1,4899},
	{{0x00000000,0x00000000,0x00000000},0x248b,1,5147},
	{{0x00000000,0x00000000,0x00000000},0x250b,1,5489},
	{{0x00000000,0x00000000,0x00000000},0x2158,1,3602},
	{{0x00000000,0x00000000,0x00000000},0x2509,1,5483},
	{{0x00000000,0x00000000,0x00000000},0x0664,1,1660},
	{{0x00000000,0x00000000,0x00000000},0x3223,1,6911},
	{{0x00000000,0x00000000,0x00000000},0x2443,1,4810},
	{{0x00000000,0x00000000,0x00000000},0x2449,1,4884},
	{{0x00000000,0x00000000,0x00000000},0x2005,1,2853},
	{{0x00000000,0x00000000,0x00000000},0x2163,1,3698},
	{{0x00000000,0x00000000,0x00000000},0x2173,1,3698},
	{{0x00000000,0x00000000,0x00000000},0x2074,1,3276},
	{{0x00000000,0x00000000,0x00000000},0x2084,1,3276},
	{{0x00000000,0x00000000,0x00000000},0x2464,1,4903},
	{{0x00000000,0x00000000,0x00000000},0x248c,1,5150},
	{{0x00000000,0x00000000,0x00000000},0x2181,1,3831},
	{{0x00000000,0x00000000,0x00000000},0x216e,1,3776},
	{{0x00000000,0x00000000,0x00000000},0x217e,1,3776},
	{{0x00000000,0x00000000,0x00000000},0x216c,1,3746},
	{{0x00000000,0x00000000,0x00000000},0x217c,1,3746},
	{{0x00000000,0x00000000,0x00000000},0x215a,1,3626},
	{{0x00000000,0x00000000,0x00000000},0x215d,1,3669},
	{{0x00000000,0x00000000,0x00000000},0x0665,1,1663},
	{{0x00000000,0x00000000,0x00000000},0x3224,1,6914},
	{{0x00000000,0x00000000,0x00000000},0x2164,1,3701},
	{{0x00000000,0x00000000,0x00000000},0x2174,1,3701},
	{{0x00000000,0x00000000,0x00000000},0x2075,1,3279},
	{{0x00000000,0x00000000,0x00000000},0x2085,1,3279},
	{{0x00000000,0x00000000,0x00000000},0x2465,1,4907},
	{{0x00000000,0x00000000,0x00000000},0x248d,1,5153},
	{{0x00000000,0x00000000,0x00000000},0x0666,1,1666},
	{{0x00000000,0x00000000,0x00000000},0x3225,1,6917},
	{{0x00000000,0x00000000,0x00000000},0x2006,1,2867},
	{{0x00000000,0x00000000,0x00000000},0x2165,1,3704},
	{{0x00000000,0x00000000,0x00000000},0x2175,1,3704},
	{{0x00000000,0x00000000,0x00000000},0x2076,1,3282},
	{{0x00000000,0x00000000,0x00000000},0x2086,1,3282},
	{{0x00000000,0x00000000,0x00000000},0x2466,1,4911},
	{{0x00000000,0x00000000,0x00000000},0x248e,1,5156},
	{{0x00000000,0x00000000,0x00000000},0x215e,1,3686},
	{{0x00000000,0x00000000,0x00000000},0x230a,1,4663},
	{{0x00000000,0x00000000,0x00000000},0x230b,1,4666},
	{{0x00000000,0x00000000,0x00000000},0x0667,1,1669},
	{{0x00000000,0x00000000,0x00000000},0x3226,1,6920},
	{{0x00000000,0x00000000,0x00000000},0x2166,1,3707},
	{{0x00000000,0x00000000,0x00000000},0x2176,1,3707},
	{{0x00000000,0x00000000,0x00000000},0x2077,1,3285},
	{{0x00000000,0x00000000,0x00000000},0x2087,1,3285},
	{{0x00000000,0x00000000,0x00000000},0x2467,1,4915},
	{{0x00000000,0x00000000,0x00000000},0x248f,1,5159},
	{{0x00000000,0x00000000,0x00000000},0x2318,1,4729},
	{{0x00000000,0x00000000,0x00000000},0x0668,1,1672},
	{{0x00000000,0x00000000,0x00000000},0x3227,1,6923},
	{{0x00000000,0x00000000,0x00000000},0x2167,1,3710},
	{{0x00000000,0x00000000,0x00000000},0x2177,1,3710},
	{{0x00000000,0x00000000,0x00000000},0x2078,1,3288},
	{{0x00000000,0x00000000,0x00000000},0x2088,1,3288},
	{{0x00000000,0x00000000,0x00000000},0x201f,1,2986},
	{{0x00000000,0x00000000,0x00000000},0x201b,1,2974},
	{{0x00000000,0x00000000,0x00000000},0x2468,1,4919},
	{{0x00000000,0x00000000,0x00000000},0x2490,1,5162},
	{{0x00000000,0x00000000,0x00000000},0x0669,1,1675},
	{{0x00000000,0x00000000,0x00000000},0x3228,1,6926},
	{{0x00000000,0x00000000,0x00000000},0x2168,1,3713},
	{{0x00000000,0x00000000,0x00000000},0x2178,1,3713},
	{{0x00000000,0x00000000,0x00000000},0x2079,1,3291},
	{{0x00000000,0x00000000,0x00000000},0x2089,1,3291},
	{{0x00000000,0x00000000,0x00000000},0x1fee,1,2784},
	{{0x00000000,0x00000000,0x00000000},0x064b,1,1575},
	{{0x00000000,0x00000000,0x00000000},0x2235,1,4394},
	{{0x00000000,0x00000000,0x00000000},0x22ee,1,4631},
	{{0x00000000,0x00000000,0x00000000},0x201e,1,2983},
	{{0x00000000,0x00000000,0x00000000},0x2237,1,4417},
	{{0x00000000,0x00000000,0x00000000},0x2236,1,4403},
	{{0x00000000,0x00000000,0x00000000},0x2592,1,5720},
	{{0x00000000,0x00000000,0x00000000},0x203b,1,3234},
	{{0x00000000,0x00000000,0x00000000},0x1fdd,1,2737},
	{{0x00000000,0x00000000,0x00000000},0x1fde,1,2740},
	{{0x00000000,0x00000000,0x00000000},0x061b,1,1333},
	{{0x00000000,0x00000000,0x00000000},0x1ffe,1,2816},
	{{0x00000000,0x00000000,0x00000000},0x3006,1,6420},
	{{0x00000000,0x00000000,0x00000000},0x02bb,1,482},
	{{0x00000000,0x00000000,0x00000000},0x2196,1,3925},
	{{0x00000000,0x00000000,0x00000000},0x300e,1,6445},
	{{0x00000000,0x00000000,0x00000000},0x300c,1,6439},
	{{0x00000000,0x00000000,0x00000000},0x226a,1,4540},
	{{0x00000000,0x00000000,0x00000000},0x300a,1,6426},
	{{0x00000000,0x00000000,0x00000000},0x2190,1,3867},
	{{0x00000000,0x00000000,0x00000000},0x2329,1,4782},
	{{0x00000000,0x00000000,0x00000000},0x2199,1,3970},
	{{0x00000000,0x00000000,0x00000000},0x2039,1,3218},
	{{0x00000000,0x00000000,0x00000000},0x2308,1,4651},
	{{0x00000000,0x00000000,0x00000000},0x21d0,1,4018},
	{{0x00000000,0x00000000,0x00000000},0x2194,1,3908},
	{{0x00000000,0x00000000,0x00000000},0x261c,1,6081},
	{{0x00000000,0x00000000,0x00000000},0x042a,1,1084},
	{{0x00000000,0x00000000,0x00000000},0x044a,1,1115},
	{{0x00000000,0x00000000,0x00000000},0x064d,1,1599},
	{{0x00000000,0x00000000,0x00000000},0x2017,1,2920},
	{{0x00000000,0x00000000,0x00000000},0x2261,1,4521},
	{{0x00000000,0x00000000,0x00000000},0x2264,1,4524},
	{{0x00000000,0x00000000,0x00000000},0x21d4,1,4024},
	{{0x00000000,0x00000000,0x00000000},0x21d2,1,4021},
	{{0x00000000,0x00000000,0x00000000},0x224c,1,4482},
	{{0x00000000,0x00000000,0x00000000},0x3013,1,6483},
	{{0x00000000,0x00000000,0x00000000},0x207c,1,3306},
	{{0x00000000,0x00000000,0x00000000},0x208c,1,3306},
	{{0x00000000,0x00000000,0x00000000},0x3012,1,6475},
	{{0x00000000,0x00000000,0x00000000},0x3020,1,6538},
	{{0x00000000,0x00000000,0x00000000},0x300f,1,6448},
	{{0x00000000,0x00000000,0x00000000},0x300d,1,6442},
	{{0x00000000,0x00000000,0x00000000},0x300b,1,6429},
	{{0x00000000,0x00000000,0x00000000},0x203a,1,3221},
	{{0x00000000,0x00000000,0x00000000},0x2309,1,4654},
	{{0x00000000,0x00000000,0x00000000},0x2265,1,4527},
	{{0x00000000,0x00000000,0x00000000},0x261e,1,6084},
	{{0x00000000,0x00000000,0x00000000},0x21c0,1,4015},
	{{0x00000000,0x00000000,0x00000000},0x037e,1,592},
	{{0x00000000,0x00000000,0x00000000},0x1fc0,1,2667},
	{{0x00000000,0x00000000,0x00000000},0x061f,1,1336},
	{{0x00000000,0x00000000,0x00000000},0x1fcf,1,2707},
	{{0x00000000,0x00000000,0x00000000},0x2243,1,4448},
	{{0x00000000,0x00000000,0x00000000},0x223c,1,4420},
	{{0x00000000,0x00000000,0x00000000},0x2248,1,4475},
	{{0x00000000,0x00000000,0x00000000},0x1fc1,1,2670},
	{{0x00000000,0x00000000,0x00000000},0x1fdf,1,2743},
	{{0x00000000,0x00000000,0x00000000},0x2245,1,4465},
	{{0x00000000,0x00000000,0x00000000},0x2593,1,5734},
	{{0x00000000,0x00000000,0x00000000},0x2502,1,5434},
	{{0x00000000,0x00000000,0x00000000},0x253c,1,5601},
	{{0x00000000,0x00000000,0x00000000},0x2524,1,5556},
	{{0x00000000,0x00000000,0x00000000},0x251c,1,5541},
	{{0x00000000,0x00000000,0x00000000},0x2500,1,5421},
	{{0x00000000,0x00000000,0x00000000},0x2534,1,5586},
	{{0x00000000,0x00000000,0x00000000},0x25e2,1,6023},
	{{0x00000000,0x00000000,0x00000000},0x2501,1,5428},
	{{0x00000000,0x00000000,0x00000000},0x2571,1,5649},
	{{0x00000000,0x00000000,0x00000000},0x2518,1,5530},
	{{0x00000000,0x00000000,0x00000000},0x2514,1,5519},
	{{0x00000000,0x00000000,0x00000000},0x266a,1,6206},
	{{0x00000000,0x00000000,0x00000000},0x252c,1,5571},
	{{0x00000000,0x00000000,0x00000000},0x2510,1,5503},
	{{0x00000000,0x00000000,0x00000000},0x250c,1,5495},
	{{0x40000001,0x00000000,0x00000000},0x3042,0,1546},
	{{0x00000001,0x00000020,0x00000000},0x30a2,0,1546},
	{{0x00000201,0x00000000,0x00000000},0x311a,0,1546},
	{{0x00010003,0x00000000,0x00000000},0x0410,0,1546},
	{{0x00010005,0x00000000,0x00000000},0x0430,0,1546},
	{{0x40000005,0x00000000,0x00000000},0x3041,0,1546},
	{{0x00000005,0x00000020,0x00000000},0x30a1,0,1546},
	{{0x00000003,0x00000440,0x00000000},0x0100,0,1546},
	{{0x00000005,0x00000440,0x00000000},0x0101,0,1546},
	{{0x00000803,0x00000040,0x00000000},0x0102,0,1546},
	{{0x00000805,0x00000040,0x00000000},0x0103,0,1546},
	{{0x00000003,0x00000040,0x02000000},0x0104,0,1546},
	{{0x00000005,0x00000040,0x02000000},0x0105,0,1546},
	{{0x00001003,0x00000040,0x00000000},0x01cd,0,1546},
	{{0x00001005,0x00000040,0x00000000},0x01ce,0,1546},
	{{0x00000005,0x00040040,0x00000000},0x249c,0,1546},
	{{0x00004003,0x00000040,0x00000000},0x24b6,0,1546},
	{{0x00004005,0x00000040,0x00000000},0x24d0,0,1546},
	{{0x00040003,0x00000440,0x00000000},0x01de,0,1546},
	{{0x00040005,0x00000440,0x00000000},0x01df,0,1546},
	{{0x04100003,0x00000040,0x00000000},0x0200,0,1546},
	{{0x04100005,0x00000040,0x00000000},0x0201,0,1546},
	{{0x00000803,0x00000040,0x00800000},0x0202,0,1546},
	{{0x00000805,0x00000040,0x00800000},0x0203,0,1546},
	{{0x00000103,0x00000040,0x04000000},0x1e00,0,1546},
	{{0x00000105,0x00000040,0x04000000},0x1e01,0,1546},
	{{0x00080103,0x00000040,0x00000000},0x1ea0,0,1546},
	{{0x00080105,0x00000040,0x00000000},0x1ea1,0,1546},
	{{0x8000000b,0x00000040,0x00000000},0x1ea2,0,1546},
	{{0x8000000d,0x00000040,0x00000000},0x1ea3,0,1546},
	{{0x00008013,0x00000040,0x00000000},0x1ea4,0,1546},
	{{0x00008015,0x00000040,0x00000000},0x1ea5,0,1546},
	{{0x04008003,0x00000040,0x00000000},0x1ea6,0,1546},
	{{0x04008005,0x00000040,0x00000000},0x1ea7,0,1546},
	{{0x00008003,0x02000040,0x00000000},0x1eaa,0,1546},
	{{0x00008005,0x02000040,0x00000000},0x1eab,0,1546},
	{{0x00000813,0x00000040,0x00000000},0x1eae,0,1546},
	{{0x00000815,0x00000040,0x00000000},0x1eaf,0,1546},
	{{0x04000803,0x00000040,0x00000000},0x1eb0,0,1546},
	{{0x04000805,0x00000040,0x00000000},0x1eb1,0,1546},
	{{0x00000803,0x02000040,0x00000000},0x1eb4,0,1546},
	{{0x00000805,0x02000040,0x00000000},0x1eb5,0,1546},
	{{0x0008000b,0x00000440,0x00000000},0x01e0,0,1546},
	{{0x0008000d,0x00000440,0x00000000},0x01e1,0,1546},
	{{0x0000001b,0x00000040,0x04000000},0x01fa,0,1546},
	{{0x0000001d,0x00000040,0x04000000},0x01fb,0,1546},
	{{0x8000800b,0x00000040,0x00000000},0x1ea8,0,1546},
	{{0x8000800d,0x00000040,0x00000000},0x1ea9,0,1546},
	{{0x00088103,0x00000040,0x00000000},0x1eac,0,1546},
	{{0x00088105,0x00000040,0x00000000},0x1ead,0,1546},
	{{0x8000080b,0x00000040,0x00000000},0x1eb2,0,1546},
	{{0x8000080d,0x00000040,0x00000000},0x1eb3,0,1546},
	{{0x00080903,0x00000040,0x00000000},0x1eb6,0,1546},
	{{0x00080905,0x00000040,0x00000000},0x1eb7,0,1546},
	{{0x00000000,0x00000000,0x00000000},0x24b6,1,5313},
	{{0x00000000,0x00000000,0x00000000},0x24d0,1,5313},
	{{0x00000000,0x00000000,0x00000000},0x0200,1,404},
	{{0x00000000,0x00000000,0x00000000},0x0201,1,404},
	{{0x00000000,0x00000000,0x00000000},0x0386,1,611},
	{{0x00000000,0x00000000,0x00000000},0x03ac,1,611},
	{{0x00000000,0x00000000,0x00000000},0x0102,1,3},
	{{0x00000000,0x00000000,0x00000000},0x0103,1,3},
	{{0x00000000,0x00000000,0x00000000},0x1eb0,1,2030},
	{{0x00000000,0x00000000,0x00000000},0x1eb1,1,2030},
	{{0x00000000,0x00000000,0x00000000},0x1eae,1,2026},
	{{0x00000000,0x00000000,0x00000000},0x1eaf,1,2026},
	{{0x00000000,0x00000000,0x00000000},0x1eb6,1,2042},
	{{0x00000000,0x00000000,0x00000000},0x1eb7,1,2042},
	{{0x00000000,0x00000000,0x00000000},0x1eb2,1,2034},
	{{0x00000000,0x00000000,0x00000000},0x1eb3,1,2034},
	{{0x00000000,0x00000000,0x00000000},0x1eb4,1,2038},
	{{0x00000000,0x00000000,0x00000000},0x1eb5,1,2038},
	{{0x00000000,0x00000000,0x00000000},0x0202,1,408},
	{{0x00000000,0x00000000,0x00000000},0x0203,1,408},
	{{0x00000000,0x00000000,0x00000000},0x0391,1,665},
	{{0x00000000,0x00000000,0x00000000},0x03b1,1,665},
	{{0x00000000,0x00000000,0x00000000},0x1f70,1,2421},
	{{0x00000000,0x00000000,0x00000000},0x1fba,1,2421},
	{{0x00000000,0x00000000,0x00000000},0x1fb2,1,2630},
	{{0x00000000,0x00000000,0x00000000},0x1f71,1,2425},
	{{0x00000000,0x00000000,0x00000000},0x1fbb,1,2425},
	{{0x00000000,0x00000000,0x00000000},0x1fb4,1,2639},
	{{0x00000000,0x00000000,0x00000000},0x1fb0,1,2622},
	{{0x00000000,0x00000000,0x00000000},0x1fb8,1,2622},
	{{0x00000000,0x00000000,0x00000000},0x1f00,1,2175},
	{{0x00000000,0x00000000,0x00000000},0x1f08,1,2175},
	{{0x00000000,0x00000000,0x00000000},0x1f02,1,2183},
	{{0x00000000,0x00000000,0x00000000},0x1f0a,1,2183},
	{{0x00000000,0x00000000,0x00000000},0x1f82,1,2487},
	{{0x00000000,0x00000000,0x00000000},0x1f8a,1,2487},
	{{0x00000000,0x00000000,0x00000000},0x1f04,1,2193},
	{{0x00000000,0x00000000,0x00000000},0x1f0c,1,2193},
	{{0x00000000,0x00000000,0x00000000},0x1f84,1,2499},
	{{0x00000000,0x00000000,0x00000000},0x1f8c,1,2499},
	{{0x00000000,0x00000000,0x00000000},0x1f06,1,2203},
	{{0x00000000,0x00000000,0x00000000},0x1f0e,1,2203},
	{{0x00000000,0x00000000,0x00000000},0x1f86,1,2511},
	{{0x00000000,0x00000000,0x00000000},0x1f8e,1,2511},
	{{0x00000000,0x00000000,0x00000000},0x1f80,1,2477},
	{{0x00000000,0x00000000,0x00000000},0x1f88,1,2477},
	{{0x00000000,0x00000000,0x00000000},0x1fb1,1,2626},
	{{0x00000000,0x00000000,0x00000000},0x1fb9,1,2626},
	{{0x00000000,0x00000000,0x00000000},0x1f01,1,2179},
	{{0x00000000,0x00000000,0x00000000},0x1f09,1,2179},
	{{0x00000000,0x00000000,0x00000000},0x1f03,1,2188},
	{{0x00000000,0x00000000,0x00000000},0x1f0b,1,2188},
	{{0x00000000,0x00000000,0x00000000},0x1f83,1,2493},
	{{0x00000000,0x00000000,0x00000000},0x1f8b,1,2493},
	{{0x00000000,0x00000000,0x00000000},0x1f05,1,2198},
	{{0x00000000,0x00000000,0x00000000},0x1f0d,1,2198},
	{{0x00000000,0x00000000,0x00000000},0x1f85,1,2505},
	{{0x00000000,0x00000000,0x00000000},0x1f8d,1,2505},
	{{0x00000000,0x00000000,0x00000000},0x1f07,1,2208},
	{{0x00000000,0x00000000,0x00000000},0x1f0f,1,2208},
	{{0x00000000,0x00000000,0x00000000},0x1f87,1,2517},
	{{0x00000000,0x00000000,0x00000000},0x1f8f,1,2517},
	{{0x00000000,0x00000000,0x00000000},0x1f81,1,2482},
	{{0x00000000,0x00000000,0x00000000},0x1f89,1,2482},
	{{0x00000000,0x00000000,0x00000000},0x1fb6,1,2644},
	{{0x00000000,0x00000000,0x00000000},0x1fb7,1,2648},
	{{0x00000000,0x00000000,0x00000000},0x1fb3,1,2635},
	{{0x00000000,0x00000000,0x00000000},0x1fbc,1,2635},
	{{0x00000000,0x00000000,0x00000000},0x05d0,1,1160},
	{{0x00000000,0x00000000,0x00000000},0x0627,1,1160},
	{{0x00000000,0x00000000,0x00000000},0xfe8d,1,7015},
	{{0x00000000,0x00000000,0x00000000},0xfe8e,1,7019},
	{{0x00000000,0x00000000,0x00000000},0x0100,1,0},
	{{0x00000000,0x00000000,0x00000000},0x0101,1,0},
	{{0x00000000,0x00000000,0x00000000},0x1ea0,1,1998},
	{{0x00000000,0x00000000,0x00000000},0x1ea1,1,1998},
	{{0x00000000,0x00000000,0x00000000},0x1e00,1,1728},
	{{0x00000000,0x00000000,0x00000000},0x1e01,1,1728},
	{{0x00000000,0x00000000,0x00000000},0x01de,1,355},
	{{0x00000000,0x00000000,0x00000000},0x01df,1,355},
	{{0x00000000,0x00000000,0x00000000},0x1ea2,1,2002},
	{{0x00000000,0x00000000,0x00000000},0x1ea3,1,2002},
	{{0x00000000,0x00000000,0x00000000},0x01e2,1,361},
	{{0x00000000,0x00000000,0x00000000},0x01e3,1,361},
	{{0x00000000,0x00000000,0x00000000},0x311a,1,6841},
	{{0x00000000,0x00000000,0x00000000},0x3041,1,6543},
	{{0x00000000,0x00000000,0x00000000},0x3042,1,6543},
	{{0x00000000,0x00000000,0x00000000},0x30a1,1,6735},
	{{0x00000000,0x00000000,0x00000000},0x30a2,1,6735},
	{{0x00000000,0x00000000,0x00000000},0x01e0,1,358},
	{{0x00000000,0x00000000,0x00000000},0x01e1,1,358},
	{{0x00000000,0x00000000,0x00000000},0x0104,1,6},
	{{0x00000000,0x00000000,0x00000000},0x0105,1,6},
	{{0x00000000,0x00000000,0x00000000},0x01cd,1,315},
	{{0x00000000,0x00000000,0x00000000},0x01ce,1,315},
	{{0x00000000,0x00000000,0x00000000},0x0410,1,942},
	{{0x00000000,0x00000000,0x00000000},0x0430,1,942},
	{{0x00000000,0x00000000,0x00000000},0x1ea6,1,2009},
	{{0x00000000,0x00000000,0x00000000},0x1ea7,1,2009},
	{{0x00000000,0x00000000,0x00000000},0x1ea4,1,2005},
	{{0x00000000,0x00000000,0x00000000},0x1ea5,1,2005},
	{{0x00000000,0x00000000,0x00000000},0x1eac,1,2021},
	{{0x00000000,0x00000000,0x00000000},0x1ead,1,2021},
	{{0x00000000,0x00000000,0x00000000},0x1ea8,1,2013},
	{{0x00000000,0x00000000,0x00000000},0x1ea9,1,2013},
	{{0x00000000,0x00000000,0x00000000},0x1eaa,1,2017},
	{{0x00000000,0x00000000,0x00000000},0x1eab,1,2017},
	{{0x00000000,0x00000000,0x00000000},0x01fa,1,392},
	{{0x00000000,0x00000000,0x00000000},0x01fb,1,392},
	{{0x00100010,0x00000000,0x00000000},0x02dd,0,1627},
	{{0x00000003,0x00000440,0x00000000},0x01e2,0,2829},
	{{0x00000005,0x00000440,0x00000000},0x01e3,0,2829},
	{{0x00000013,0x00000040,0x00000000},0x01fc,0,2829},
	{{0x00000015,0x00000040,0x00000000},0x01fd,0,2829},
	{{0x00000000,0x00000000,0x00000000},0x01fc,1,396},
	{{0x00000000,0x00000000,0x00000000},0x01fd,1,396},
	{{0x00000000,0x00000000,0x00000000},0x0623,1,1357},
	{{0x00000000,0x00000000,0x00000000},0x0625,1,1357},
	{{0x00000000,0x00000000,0x00000000},0xfe83,1,6999},
	{{0x00000000,0x00000000,0x00000000},0xfe84,1,7003},
	{{0x00000000,0x00000000,0x00000000},0xfe88,1,7003},
	{{0x00000201,0x00000000,0x00000000},0x311e,1,6854},
	{{0x00000081,0x00000000,0x00000000},0x0639,1,1494},
	{{0x00000081,0x00000010,0x00000000},0xfec9,1,1494},
	{{0x01000081,0x00000000,0x00000000},0xfeca,1,1494},
	{{0x00000081,0x00000004,0x00000000},0xfecb,1,1494},
	{{0x00000081,0x00001000,0x00000000},0xfecc,1,1494},
	{{0x00000000,0x04000000,0x00001000},0x224c,1,4478},
	{{0x00000000,0x04000000,0x00001000},0x2248,1,4468},
	{{0x00000000,0x00000000,0x00000000},0x0622,1,1354},
	{{0x00000000,0x00000000,0x00000080},0x33c2,1,1354},
	{{0x00000000,0x00000000,0x00000000},0xfe81,1,6991},
	{{0x00000000,0x00000000,0x00000000},0xfe82,1,6995},
	{{0x00000000,0x00000000,0x00040001},0x2447,1,4843},
	{{0x00000000,0x00000000,0x00000000},0x2227,1,4316},
	{{0x00000201,0x00000000,0x00000000},0x3122,1,4316},
	{{0x00000201,0x00000000,0x00000000},0x3124,1,6866},
	{{0x00000000,0x00000000,0x00000000},0x2220,1,4287},
	{{0x00000000,0x00400000,0x00000000},0x221f,1,4287},
	{{0x00100000,0x00000080,0x00020000},0x300a,1,4287},
	{{0x00100000,0x00400000,0x00020000},0x300b,1,4287},
	{{0x00000001,0x00000000,0x00000000},0x212b,1,3495},
	{{0x08000000,0x00000000,0x00000000},0x0387,1,614},
	{{0x00000000,0x00000000,0x00000000},0x212b,1,3504},
	{{0x00000000,0x04000000,0x00001000},0x2245,1,4451},
	{{0x00000000,0x00000000,0x00000000},0x2169,1,3720},
	{{0x00000000,0x00000000,0x00000000},0x2179,1,3720},
	{{0x00000000,0x00000000,0x00000000},0x2312,1,4685},
	{{0x00000000,0x00000000,0x00000000},0x0670,1,1681},
	{{0x00000000,0x00000000,0x00000000},0x2217,1,4202},
	{{0x00000000,0x04000000,0x00001000},0x2243,1,4433},
	{{0x00000201,0x00000000,0x00000000},0x3120,1,6860},
	{{0x20000001,0x00000000,0x00000000},0x05e2,1,1280},
	{{0x00000201,0x00000000,0x00000000},0x3105,0,1548},
	{{0x00000005,0x00000040,0x10000000},0x0180,0,1548},
	{{0x80000003,0x00000040,0x00000000},0x0181,0,1548},
	{{0x00000005,0x00040040,0x00000000},0x249d,0,1548},
	{{0x00004003,0x00000040,0x00000000},0x24b7,0,1548},
	{{0x00004005,0x00000040,0x00000000},0x24d1,0,1548},
	{{0x0008000b,0x00000040,0x00000000},0x1e02,0,1548},
	{{0x0008000d,0x00000040,0x00000000},0x1e03,0,1548},
	{{0x00080103,0x00000040,0x00000000},0x1e04,0,1548},
	{{0x00080105,0x00000040,0x00000000},0x1e05,0,1548},
	{{0x00000103,0x00000240,0x00000000},0x1e06,0,1548},
	{{0x00000105,0x00000240,0x00000000},0x1e07,0,1548},
	{{0x00000000,0x00000000,0x00000000},0x24b7,1,5317},
	{{0x00000000,0x00000000,0x00000000},0x24d1,1,5317},
	{{0x00000000,0x00000000,0x00000000},0x0392,1,673},
	{{0x00000000,0x00000000,0x00000000},0x03b2,1,673},
	{{0x00000000,0x00000000,0x00000000},0x05d1,1,1167},
	{{0x00000000,0x00000000,0x00000000},0x0628,1,1167},
	{{0x00000000,0x00000000,0x00000000},0xfe91,1,7031},
	{{0x00000000,0x00000000,0x00000000},0xfe8f,1,7023},
	{{0x00000000,0x00000000,0x00000000},0xfe90,1,7027},
	{{0x00000000,0x00000000,0x00000000},0xfe92,1,7035},
	{{0x00000000,0x00000000,0x00000000},0x1e04,1,1735},
	{{0x00000000,0x00000000,0x00000000},0x1e05,1,1735},
	{{0x00000000,0x00000000,0x00000000},0x1e02,1,1732},
	{{0x00000000,0x00000000,0x00000000},0x1e03,1,1732},
	{{0x00000000,0x00000000,0x00000000},0x0180,1,245},
	{{0x00000000,0x00000000,0x00000000},0x0181,1,248},
	{{0x00000000,0x00000000,0x00000000},0x03d0,1,833},
	{{0x00000000,0x00000000,0x00000000},0x3105,1,6790},
	{{0x00000000,0x00000000,0x00000000},0x0411,1,948},
	{{0x00000000,0x00000000,0x00000000},0x0431,1,948},
	{{0x00000000,0x00000000,0x00000000},0x1e06,1,1739},
	{{0x00000000,0x00000000,0x00000000},0x1e07,1,1739},
	{{0x40000001,0x00000000,0x00000000},0x3070,1,6618},
	{{0x00000001,0x00000020,0x00000000},0x30d0,1,6618},
	{{0x00000000,0x00000000,0x00000000},0x2717,1,6312},
	{{0x00000000,0x00000001,0x00000000},0x2015,0,1674},
	{{0x00200001,0x08000000,0x00002000},0x21a8,1,3974},
	{{0x00000000,0x00000000,0x00000000},0x2572,1,5653},
	{{0x00000000,0x00000000,0x00000000},0x25e3,1,5653},
	{{0x40000001,0x00000000,0x00000000},0x3079,1,945},
	{{0x00000001,0x00000020,0x00000000},0x30d9,1,945},
	{{0x00010003,0x00000000,0x00000000},0x0411,1,945},
	{{0x00010005,0x00000000,0x00000000},0x0431,1,945},
	{{0x00000000,0x00000000,0x00000000},0x266b,1,6210},
	{{0x00000000,0x00000000,0x00000000},0x266c,1,6233},
	{{0x00000000,0x00000000,0x00000000},0x2235,1,4386},
	{{0x00000081,0x00000000,0x00000000},0x0628,1,1386},
	{{0x00000081,0x00000010,0x00000000},0xfe8f,1,1386},
	{{0x01000081,0x00000000,0x00000000},0xfe90,1,1386},
	{{0x00000081,0x00000004,0x00000000},0xfe91,1,1386},
	{{0x00000081,0x00001000,0x00000000},0xfe92,1,1386},
	{{0x20000001,0x00000000,0x00000000},0x05d1,1,1163},
	{{0x08000003,0x00000000,0x00000000},0x0392,1,668},
	{{0x08000005,0x00000000,0x00000000},0x03b2,1,668},
	{{0x08000000,0x00000000,0x00000000},0x03d0,1,821},
	{{0x40000001,0x00000000,0x00000000},0x3073,1,6621},
	{{0x00000001,0x00000020,0x00000000},0x30d3,1,6621},
	{{0x02000000,0x00000000,0x00000000},0x2588,1,5686},
	{{0x00000000,0x00000080,0x00080000},0x258c,1,5686},
	{{0x00000000,0x00400000,0x00080000},0x2590,1,5686},
	{{0x40000001,0x00000000,0x00000000},0x307c,1,6630},
	{{0x00000001,0x00000020,0x00000000},0x30dc,1,6630},
	{{0x00000000,0x00000000,0x00080000},0x2321,1,4748},
	{{0x00000000,0x00000000,0x00000000},0x216a,1,3730},
	{{0x00000000,0x00000000,0x00000000},0x217a,1,3730},
	{{0x00000000,0x00000000,0x00040000},0x2446,1,4813},
	{{0x40000001,0x00000000,0x00000000},0x3076,1,6627},
	{{0x00000001,0x00000020,0x00000000},0x30d6,1,6627},
	{{0x00000000,0x00000000,0x00000000},0x2022,1,3002},
	{{0x00000000,0x00000000,0x00000000},0x2219,1,4235},
	{{0x00000000,0x00000000,0x00000000},0x25ce,1,5957},
	{{0x00000201,0x00000000,0x00000000},0x3118,0,1550},
	{{0x00000013,0x00000040,0x00000000},0x0106,0,1550},
	{{0x00000015,0x00000040,0x00000000},0x0107,0,1550},
	{{0x00008003,0x00000040,0x00000000},0x0108,0,1550},
	{{0x00008005,0x00000040,0x00000000},0x0109,0,1550},
	{{0x00001003,0x00000040,0x00000000},0x010c,0,1550},
	{{0x00001005,0x00000040,0x00000000},0x010d,0,1550},
	{{0x80000003,0x00000040,0x00000000},0x0187,0,1550},
	{{0x80000005,0x00000040,0x00000000},0x0188,0,1550},
	{{0x00000005,0x00040040,0x00000000},0x249e,0,1550},
	{{0x00004003,0x00000040,0x00000000},0x24b8,0,1550},
	{{0x00004005,0x00000040,0x00000000},0x24d2,0,1550},
	{{0x0008000b,0x00000040,0x00000000},0x010a,0,1550},
	{{0x0008000d,0x00000040,0x00000000},0x010b,0,1550},
	{{0x00002013,0x00000040,0x00000000},0x1e08,0,1550},
	{{0x00002015,0x00000040,0x00000000},0x1e09,0,1550},
	{{0x00000000,0x00000000,0x00000000},0x24b8,1,5321},
	{{0x00000000,0x00000000,0x00000000},0x24d2,1,5321},
	{{0x00000000,0x00000000,0x00000000},0x0427,1,1063},
	{{0x00000000,0x00000000,0x00000000},0x0447,1,1063},
	{{0x00000000,0x00000000,0x00000000},0x0106,1,9},
	{{0x00000000,0x00000000,0x00000000},0x0107,1,9},
	{{0x00000000,0x00000000,0x00000000},0x039e,1,750},
	{{0x00000000,0x00000000,0x00000000},0x03be,1,750},
	{{0x00000000,0x00000000,0x00000000},0x0635,1,1473},
	{{0x00000000,0x00000000,0x00000000},0xfebb,1,7199},
	{{0x00000000,0x00000000,0x00000000},0xfeb9,1,7191},
	{{0x00000000,0x00000000,0x00000000},0xfeba,1,7195},
	{{0x00000000,0x00000000,0x00000000},0xfebc,1,7203},
	{{0x00000000,0x00000000,0x00000000},0x1e08,1,1742},
	{{0x00000000,0x00000000,0x00000000},0x1e09,1,1742},
	{{0x00000000,0x00000000,0x00000000},0x010a,1,15},
	{{0x00000000,0x00000000,0x00000000},0x010b,1,15},
	{{0x00000000,0x00000000,0x00000000},0x0187,1,251},
	{{0x00000000,0x00000000,0x00000000},0x0188,1,251},
	{{0x00000000,0x00000000,0x00000000},0x0480,1,1154},
	{{0x00000000,0x00000000,0x00000000},0x0481,1,1154},
	{{0x00000000,0x00000000,0x00000000},0x3118,1,6835},
	{{0x00000000,0x00000000,0x00000000},0x010c,1,18},
	{{0x00000000,0x00000000,0x00000000},0x010d,1,18},
	{{0x00000000,0x00000000,0x00000000},0x0426,1,1056},
	{{0x00000000,0x00000000,0x00000000},0x0446,1,1056},
	{{0x00000000,0x00000000,0x00000000},0x0108,1,12},
	{{0x00000000,0x00000000,0x00000000},0x0109,1,12},
	{{0x00000000,0x00000000,0x00000000},0x2038,1,3215},
	{{0x00000000,0x00000000,0x00000001},0x2105,1,3388},
	{{0x00000000,0x00000000,0x00000000},0x2038,1,3209},
	{{0x00000000,0x00000000,0x00000000},0x2663,0,2180},
	{{0x00000000,0x00000000,0x00000000},0x2667,1,6171},
	{{0x00000000,0x00000000,0x00000000},0x2662,1,6151},
	{{0x00000000,0x00000000,0x00000000},0x2666,1,6167},
	{{0x00000000,0x00000080,0x00000000},0x2308,1,4643},
	{{0x00000000,0x00400000,0x00000000},0x2309,1,4643},
	{{0x00000000,0x00000000,0x00000000},0x223e,1,4430},
	{{0x00000000,0x00000000,0x00000000},0x2661,1,6148},
	{{0x00000201,0x00000000,0x00000000},0x3114,1,6148},
	{{0x00000000,0x00000000,0x00000000},0x2665,1,6163},
	{{0x00000000,0x00000000,0x00040000},0x2441,1,4793},
	{{0x00010003,0x00000000,0x00000000},0x0427,1,1059},
	{{0x00010005,0x00000000,0x00000000},0x0447,1,1059},
	{{0x00000000,0x00000800,0x00000000},0x2713,1,6303},
	{{0x08000003,0x00000000,0x00000000},0x03a7,1,792},
	{{0x08000005,0x00000000,0x00000000},0x03c7,1,792},
	{{0x00000000,0x00000000,0x00000000},0x25ef,0,2362},
	{{0x00000000,0x80000000,0x00000000},0x25cb,1,5947},
	{{0x00000000,0x00000000,0x00000004},0x25cf,1,5947},
	{{0x00000001,0x00000080,0x00080004},0x25d0,1,5947},
	{{0x00000001,0x00400000,0x00080004},0x25d1,1,5947},
	{{0x00000000,0x00000800,0x00000800},0x3006,1,6412},
	{{0x00000000,0x00000000,0x00008004},0x2663,1,6154},
	{{0x00000000,0x80000000,0x00008000},0x2667,1,6154},
	{{0x00000000,0x00000000,0x00000000},0x2105,0,2577},
	{{0x04000000,0x00000000,0x00000000},0x0300,1,540},
	{{0x00000010,0x00000000,0x00000000},0x0301,1,540},
	{{0x00000008,0x00400000,0x00000000},0x20d1,1,3352},
	{{0x00000080,0x00000000,0x00000000},0x060c,0,1388},
	{{0x00000000,0x00000000,0x00000800},0x3001,0,1388},
	{{0x00000004,0x80000000,0x00000084},0x25a3,1,5759},
	{{0x00000000,0x00000000,0x00000000},0x220b,1,4115},
	{{0x00000000,0x00000000,0x00000000},0x222e,1,4356},
	{{0x00000000,0x00000080,0x00020000},0x300c,1,6432},
	{{0x00000000,0x00400000,0x00020000},0x300d,1,6432},
	{{0x00000000,0x80000080,0x00020000},0x300e,1,6432},
	{{0x00000000,0x80400000,0x00020000},0x300f,1,6432},
	{{0x00000000,0x00000000,0x00000000},0x216b,0,902},
	{{0x00000000,0x00000000,0x00000000},0x217b,0,902},
	{{0x00000000,0x00000000,0x00000000},0x2660,1,6139},
	{{0x00000000,0x00000000,0x00000000},0x2664,1,6159},
	{{0x00000000,0x00002000,0x00040000},0x2449,1,4867},
	{{0x00000201,0x00000000,0x00000000},0x3109,0,1552},
	{{0x00001003,0x00000040,0x00000000},0x010e,0,1552},
	{{0x00001005,0x00000040,0x00000000},0x010f,0,1552},
	{{0x00000003,0x00000040,0x10000000},0x0110,0,1552},
	{{0x00000005,0x00000040,0x10000000},0x0111,0,1552},
	{{0x00002003,0x00000040,0x00000000},0x1e10,0,1552},
	{{0x00002005,0x00000040,0x00000000},0x1e11,0,1552},
	{{0x00000005,0x00040040,0x00000000},0x249f,0,1552},
	{{0x00004003,0x00000040,0x00000000},0x24b9,0,1552},
	{{0x00004005,0x00000040,0x00000000},0x24d3,0,1552},
	{{0x0008000b,0x00000040,0x00000000},0x1e0a,0,1552},
	{{0x0008000d,0x00000040,0x00000000},0x1e0b,0,1552},
	{{0x00080103,0x00000040,0x00000000},0x1e0c,0,1552},
	{{0x00080105,0x00000040,0x00000000},0x1e0d,0,1552},
	{{0x00000103,0x00000240,0x00000000},0x1e0e,0,1552},
	{{0x00000105,0x00000240,0x00000000},0x1e0f,0,1552},
	{{0x00008103,0x00000040,0x00000000},0x1e12,0,1552},
	{{0x00008105,0x00000040,0x00000000},0x1e13,0,1552},
	{{0x00000000,0x00000000,0x00000000},0x24b9,1,5325},
	{{0x00000000,0x00000000,0x00000000},0x24d3,1,5325},
	{{0x00000007,0x00000040,0x00000000},0x01f2,1,289},
	{{0x00001007,0x00000040,0x00000000},0x01c5,1,289},
	{{0x00000000,0x00000000,0x00000000},0x0402,1,882},
	{{0x00000000,0x00000000,0x00000000},0x0452,1,882},
	{{0x00000000,0x00000000,0x00000000},0x0394,1,691},
	{{0x00000000,0x00000000,0x00000000},0x03b4,1,691},
	{{0x00000000,0x00000000,0x00000000},0x05d3,1,1185},
	{{0x00000000,0x00000000,0x00000000},0x062f,1,1185},
	{{0x00000000,0x00000000,0x00000000},0xfea9,1,7127},
	{{0x00000000,0x00000000,0x00000000},0xfeaa,1,7131},
	{{0x00000000,0x00000000,0x00000000},0x1e10,1,1756},
	{{0x00000000,0x00000000,0x00000000},0x1e11,1,1756},
	{{0x00000000,0x00000000,0x00000000},0x1e0c,1,1749},
	{{0x00000000,0x00000000,0x00000000},0x1e0d,1,1749},
	{{0x00000000,0x00000000,0x00000000},0x1e12,1,1759},
	{{0x00000000,0x00000000,0x00000000},0x1e13,1,1759},
	{{0x00000000,0x00000000,0x00000000},0x1e0a,1,1746},
	{{0x00000000,0x00000000,0x00000000},0x1e0b,1,1746},
	{{0x00000000,0x00000000,0x00000000},0x0110,1,24},
	{{0x00000000,0x00000000,0x00000000},0x0111,1,24},
	{{0x00000000,0x00000000,0x00000000},0x3109,0,1050},
	{{0x00000000,0x00000000,0x00000000},0x010e,1,21},
	{{0x00000000,0x00000000,0x00000000},0x010f,1,21},
	{{0x00000000,0x00000000,0x00000000},0x0414,1,967},
	{{0x00000000,0x00000000,0x00000000},0x0434,1,967},
	{{0x00000000,0x00000000,0x00000000},0x1e0e,1,1753},
	{{0x00000000,0x00000000,0x00000000},0x1e0f,1,1753},
	{{0x40000001,0x00000000,0x00000000},0x3060,1,6600},
	{{0x00000001,0x00000020,0x00000000},0x30c0,1,6600},
	{{0x00000081,0x00000000,0x00000000},0x0636,1,1476},
	{{0x00000081,0x00000010,0x00000000},0xfebd,1,1476},
	{{0x01000081,0x00000000,0x00000000},0xfebe,1,1476},
	{{0x00000081,0x00000004,0x00000000},0xfebf,1,1476},
	{{0x00000081,0x00001000,0x00000000},0xfec0,1,1476},
	{{0x00000000,0x00000000,0x00000000},0x2020,1,2989},
	{{0x00100000,0x00000000,0x00000000},0x2021,1,2989},
	{{0x00000081,0x00000000,0x00000000},0x062f,1,1434},
	{{0x00000081,0x00000010,0x00000000},0xfea9,1,1434},
	{{0x01000081,0x00000000,0x00000000},0xfeaa,1,1434},
	{{0x20000001,0x00000000,0x00000000},0x05d3,1,1179},
	{{0x00000080,0x00000000,0x00000000},0x064f,1,1611},
	{{0x00000080,0x00000000,0x00000000},0x064c,1,1578},
	{{0x00000000,0x00000000,0x00000000},0x2593,1,5723},
	{{0x00000000,0x00000000,0x00040000},0x2448,1,4859},
	{{0x00000000,0x00000000,0x00000000},0x25c6,1,5930},
	{{0x00000000,0x00000000,0x00000000},0x0636,1,1480},
	{{0x00000000,0x00000000,0x00000000},0xfebf,1,7215},
	{{0x00000000,0x00000000,0x00000000},0xfebd,1,7207},
	{{0x00000000,0x00000000,0x00000000},0xfebe,1,7211},
	{{0x00000000,0x00000000,0x00000000},0xfec0,1,7219},
	{{0x00000000,0x00000000,0x00000000},0x2206,1,964},
	{{0x40000001,0x00000000,0x00000000},0x3067,1,964},
	{{0x00000001,0x00000020,0x00000000},0x30c7,1,964},
	{{0x00010003,0x00000000,0x00000000},0x0414,1,964},
	{{0x00010005,0x00000000,0x00000000},0x0434,1,964},
	{{0x00000000,0x00000000,0x00000000},0x2103,1,3373},
	{{0x00000000,0x00000000,0x00000000},0x2109,1,3393},
	{{0x08000003,0x00000000,0x00000000},0x0394,1,685},
	{{0x08000005,0x00000000,0x00000000},0x03b4,1,685},
	{{0x00000000,0x00000000,0x00000000},0x252c,1,5568},
	{{0x00000000,0x00000000,0x00000000},0x2564,1,5568},
	{{0x00000000,0x00000000,0x00000000},0x2565,1,5568},
	{{0x00000000,0x00000000,0x00000000},0x2566,1,5568},
	{{0x00000000,0x00000000,0x00000000},0x252f,1,5579},
	{{0x00000000,0x00000000,0x00000000},0x2530,1,5579},
	{{0x00000000,0x00000000,0x00000000},0x2533,1,5579},
	{{0x00000000,0x00000000,0x00000000},0x222c,1,4353},
	{{0x40000001,0x00000000,0x00000000},0x3062,1,4353},
	{{0x00000001,0x00000020,0x00000000},0x30c2,1,4353},
	{{0x00000001,0x00000000,0x00000080},0x25a9,1,5837},
	{{0x00400400,0x04400180,0x00000000},0x2571,1,5625},
	{{0x00400400,0x04400180,0x00000000},0x2572,1,5625},
	{{0x08000000,0x00000000,0x20000000},0x0385,1,598},
	{{0x08000001,0x00080000,0x00000000},0x1fc1,1,598},
	{{0x08000001,0x20000000,0x00000000},0x1fed,1,598},
	{{0x08000001,0x00020000,0x00000000},0x1fee,1,598},
	{{0x08000003,0x00000008,0x00000000},0x03aa,1,598},
	{{0x08000003,0x10000000,0x00000000},0x03ab,1,598},
	{{0x08000005,0x00000008,0x00000000},0x03ca,1,598},
	{{0x08000005,0x10000000,0x00000000},0x03cb,1,598},
	{{0x08000005,0x00000008,0x20000000},0x0390,1,598},
	{{0x08000005,0x10000000,0x20000000},0x03b0,1,598},
	{{0x08000005,0x20000008,0x00000000},0x1fd2,1,598},
	{{0x08000005,0x00020008,0x00000000},0x1fd3,1,598},
	{{0x08000005,0x00080008,0x00000000},0x1fd7,1,598},
	{{0x08000005,0x30000000,0x00000000},0x1fe2,1,598},
	{{0x08000005,0x10020000,0x00000000},0x1fe3,1,598},
	{{0x08000005,0x10080000,0x00000000},0x1fe7,1,598},
	{{0x00000000,0x00000000,0x00000004},0x25c6,1,5922},
	{{0x00000000,0x80000000,0x00000000},0x25c7,1,5922},
	{{0x00000000,0x80000000,0x00008000},0x2662,1,5922},
	{{0x00000000,0x00000000,0x00008004},0x2666,1,5922},
	{{0x08000001,0x00000000,0x00000000},0x03dc,1,846},
	{{0x00000000,0x00000800,0x00000000},0x3003,1,6350},
	{{0x00010003,0x00000000,0x00000000},0x0402,1,878},
	{{0x00010005,0x00000000,0x00000000},0x0452,1,878},
	{{0x00000000,0x00000000,0x00000000},0x0630,1,1443},
	{{0x00000000,0x00000000,0x00000000},0xfeab,1,7135},
	{{0x00000000,0x00000000,0x00000000},0xfeac,1,7139},
	{{0x00000000,0x00000000,0x00000000},0x2510,0,947},
	{{0x00000000,0x00000000,0x00000000},0x2555,0,947},
	{{0x00000000,0x00000000,0x00000000},0x2556,0,947},
	{{0x00000000,0x00000000,0x00000000},0x2511,1,5508},
	{{0x00000000,0x00000000,0x00000000},0x2512,1,5508},
	{{0x00000000,0x00000000,0x00000000},0x252d,1,5575},
	{{0x00000000,0x00000000,0x00000000},0x252e,1,5575},
	{{0x00000000,0x00000000,0x00000000},0x2531,1,5575},
	{{0x00000000,0x00000000,0x00000000},0x2532,1,5575},
	{{0x40000001,0x00000000,0x00000000},0x3069,0,1327},
	{{0x00000001,0x00000020,0x00000000},0x30c9,0,1327},
	{{0x00000005,0x00000040,0x00000000},0x0131,1,75},
	{{0x00000000,0x00000000,0x00002000},0x2193,1,3895},
	{{0x00000000,0x00000000,0x00000000},0x2202,1,4059},
	{{0x00000000,0x00000000,0x00000000},0x250c,1,5492},
	{{0x00000000,0x00000000,0x00000000},0x2552,1,5492},
	{{0x00000000,0x00000000,0x00000000},0x2553,1,5492},
	{{0x00000000,0x00000000,0x00000000},0x2554,1,5492},
	{{0x00000000,0x00000000,0x00000000},0x250d,1,5499},
	{{0x00000000,0x00000000,0x00000000},0x250e,1,5499},
	{{0x00000000,0x00000000,0x00000000},0x250f,1,5499},
	{{0x00000000,0x00000000,0x00000000},0x0405,1,899},
	{{0x00000000,0x00000000,0x00000000},0x0455,1,899},
	{{0x00000000,0x00000000,0x00000000},0x25bc,0,1696},
	{{0x00000000,0x00000000,0x00000000},0x25bd,0,1696},
	{{0x40000001,0x00000000,0x00000000},0x3065,1,6609},
	{{0x00000001,0x00000020,0x00000000},0x30c5,1,6609},
	{{0x00000000,0x00000000,0x00000000},0x25c7,1,5933},
	{{0x00000000,0x00000000,0x00000000},0x040f,1,282},
	{{0x00000000,0x00000000,0x00000000},0x045f,1,282},
	{{0x00000003,0x00000040,0x00000000},0x01f1,1,282},
	{{0x00000005,0x00000040,0x00000000},0x01f3,1,282},
	{{0x00001003,0x00000040,0x00000000},0x01c4,1,282},
	{{0x00001005,0x00000040,0x00000000},0x01c6,1,282},
	{{0x00000000,0x00000000,0x00000000},0x01f1,1,385},
	{{0x00000000,0x00000000,0x00000000},0x01f2,1,385},
	{{0x00000000,0x00000000,0x00000000},0x01f3,1,385},
	{{0x00000000,0x00000000,0x00000000},0x01c4,1,285},
	{{0x00000000,0x00000000,0x00000000},0x01c5,1,285},
	{{0x00000000,0x00000000,0x00000000},0x01c6,1,285},
	{{0x00010003,0x00000000,0x00000000},0x0405,1,895},
	{{0x00010005,0x00000000,0x00000000},0x0455,1,895},
	{{0x00010003,0x00000000,0x00000000},0x040f,1,937},
	{{0x00010005,0x00000000,0x00000000},0x045f,1,937},
	{{0x40000001,0x00000000,0x00000000},0x3048,0,1554},
	{{0x00000001,0x00000020,0x00000000},0x30a8,0,1554},
	{{0x00000201,0x00000000,0x00000000},0x311c,0,1554},
	{{0x00010003,0x00000000,0x00000000},0x042d,0,1554},
	{{0x00010005,0x00000000,0x00000000},0x044d,0,1554},
	{{0x40000005,0x00000000,0x00000000},0x3047,0,1554},
	{{0x00000005,0x00000020,0x00000000},0x30a7,0,1554},
	{{0x00000003,0x00000440,0x00000000},0x0112,0,1554},
	{{0x00000005,0x00000440,0x00000000},0x0113,0,1554},
	{{0x00000803,0x00000040,0x00000000},0x0114,0,1554},
	{{0x00000805,0x00000040,0x00000000},0x0115,0,1554},
	{{0x00000003,0x00000040,0x02000000},0x0118,0,1554},
	{{0x00000005,0x00000040,0x02000000},0x0119,0,1554},
	{{0x00001003,0x00000040,0x00000000},0x011a,0,1554},
	{{0x00001005,0x00000040,0x00000000},0x011b,0,1554},
	{{0x00000003,0x02000040,0x00000000},0x1ebc,0,1554},
	{{0x00000005,0x02000040,0x00000000},0x1ebd,0,1554},
	{{0x00000005,0x00040040,0x00000000},0x24a0,0,1554},
	{{0x00004003,0x00000040,0x00000000},0x24ba,0,1554},
	{{0x00004005,0x00000040,0x00000000},0x24d4,0,1554},
	{{0x0008000b,0x00000040,0x00000000},0x0116,0,1554},
	{{0x0008000d,0x00000040,0x00000000},0x0117,0,1554},
	{{0x04100003,0x00000040,0x00000000},0x0204,0,1554},
	{{0x04100005,0x00000040,0x00000000},0x0205,0,1554},
	{{0x00000803,0x00000040,0x00800000},0x0206,0,1554},
	{{0x00000805,0x00000040,0x00800000},0x0207,0,1554},
	{{0x04000003,0x00000440,0x00000000},0x1e14,0,1554},
	{{0x04000005,0x00000440,0x00000000},0x1e15,0,1554},
	{{0x00000013,0x00000440,0x00000000},0x1e16,0,1554},
	{{0x00000015,0x00000440,0x00000000},0x1e17,0,1554},
	{{0x00008103,0x00000040,0x00000000},0x1e18,0,1554},
	{{0x00008105,0x00000040,0x00000000},0x1e19,0,1554},
	{{0x00000103,0x02000040,0x00000000},0x1e1a,0,1554},
	{{0x00000105,0x02000040,0x00000000},0x1e1b,0,1554},
	{{0x00002803,0x00000040,0x00000000},0x1e1c,0,1554},
	{{0x00002805,0x00000040,0x00000000},0x1e1d,0,1554},
	{{0x00080103,0x00000040,0x00000000},0x1eb8,0,1554},
	{{0x00080105,0x00000040,0x00000000},0x1eb9,0,1554},
	{{0x8000000b,0x00000040,0x00000000},0x1eba,0,1554},
	{{0x8000000d,0x00000040,0x00000000},0x1ebb,0,1554},
	{{0x00008013,0x00000040,0x00000000},0x1ebe,0,1554},
	{{0x00008015,0x00000040,0x00000000},0x1ebf,0,1554},
	{{0x04008003,0x00000040,0x00000000},0x1ec0,0,1554},
	{{0x04008005,0x00000040,0x00000000},0x1ec1,0,1554},
	{{0x00008003,0x02000040,0x00000000},0x1ec4,0,1554},
	{{0x00008005,0x02000040,0x00000000},0x1ec5,0,1554},
	{{0x8000800b,0x00000040,0x00000000},0x1ec2,0,1554},
	{{0x8000800d,0x00000040,0x00000000},0x1ec3,0,1554},
	{{0x00088103,0x00000040,0x00000000},0x1ec6,0,1554},
	{{0x00088105,0x00000040,0x00000000},0x1ec7,0,1554},
	{{0x00000000,0x00000000,0x00000000},0x24ba,1,5329},
	{{0x00000000,0x00000000,0x00000000},0x24d4,1,5329},
	{{0x00000000,0x00000000,0x00000000},0x0204,1,411},
	{{0x00000000,0x00000000,0x00000000},0x0205,1,411},
	{{0x00000000,0x00000000,0x00000000},0x0388,1,636},
	{{0x00000000,0x00000000,0x00000000},0x03ad,1,636},
	{{0x00000000,0x00000000,0x00000000},0x0114,1,30},
	{{0x00000000,0x00000000,0x00000000},0x0115,1,30},
	{{0x00000000,0x00000000,0x00000000},0x0206,1,415},
	{{0x00000000,0x00000000,0x00000000},0x0207,1,415},
	{{0x00000000,0x00000000,0x00000000},0x0395,1,694},
	{{0x00000000,0x00000000,0x00000000},0x03b5,1,694},
	{{0x00000000,0x00000000,0x00000000},0x1f72,1,2429},
	{{0x00000000,0x00000000,0x00000000},0x1fc8,1,2696},
	{{0x00000000,0x00000000,0x00000000},0x1f73,1,2433},
	{{0x00000000,0x00000000,0x00000000},0x1fc9,1,2433},
	{{0x00000000,0x00000000,0x00000000},0x1f10,1,2213},
	{{0x00000000,0x00000000,0x00000000},0x1f18,1,2213},
	{{0x00000000,0x00000000,0x00000000},0x1f12,1,2221},
	{{0x00000000,0x00000000,0x00000000},0x1f1a,1,2221},
	{{0x00000000,0x00000000,0x00000000},0x1f14,1,2231},
	{{0x00000000,0x00000000,0x00000000},0x1f1c,1,2231},
	{{0x00000000,0x00000000,0x00000000},0x1f11,1,2217},
	{{0x00000000,0x00000000,0x00000000},0x1f19,1,2217},
	{{0x00000000,0x00000000,0x00000000},0x1f13,1,2226},
	{{0x00000000,0x00000000,0x00000000},0x1f1b,1,2226},
	{{0x00000000,0x00000000,0x00000000},0x1f15,1,2236},
	{{0x00000000,0x00000000,0x00000000},0x1f1d,1,2236},
	{{0x00000000,0x00000000,0x00000000},0x05e2,1,1285},
	{{0x00000000,0x00000000,0x00000000},0x0639,1,1285},
	{{0x00000000,0x00000000,0x00000000},0xfecb,1,7263},
	{{0x00000000,0x00000000,0x00000000},0xfec9,1,7255},
	{{0x00000000,0x00000000,0x00000000},0xfeca,1,7259},
	{{0x00000000,0x00000000,0x00000000},0xfecc,1,7267},
	{{0x00000000,0x00000000,0x00000000},0x1e1c,1,1779},
	{{0x00000000,0x00000000,0x00000000},0x1e1d,1,1779},
	{{0x00000000,0x00000000,0x00000000},0x0112,1,27},
	{{0x00000000,0x00000000,0x00000000},0x0113,1,27},
	{{0x00000000,0x00000000,0x00000000},0x1e14,1,1763},
	{{0x00000000,0x00000000,0x00000000},0x1e15,1,1763},
	{{0x00000000,0x00000000,0x00000000},0x1e16,1,1767},
	{{0x00000000,0x00000000,0x00000000},0x1e17,1,1767},
	{{0x00000000,0x00000000,0x00000000},0x1eb8,1,2047},
	{{0x00000000,0x00000000,0x00000000},0x1eb9,1,2047},
	{{0x00000000,0x00000000,0x00000000},0x1e18,1,1771},
	{{0x00000000,0x00000000,0x00000000},0x1e19,1,1771},
	{{0x00000000,0x00000000,0x00000000},0x1e1a,1,1775},
	{{0x00000000,0x00000000,0x00000000},0x1e1b,1,1775},
	{{0x00000000,0x00000000,0x00000000},0x0116,1,33},
	{{0x00000000,0x00000000,0x00000000},0x0117,1,33},
	{{0x00000000,0x00000000,0x00000000},0x01dd,1,352},
	{{0x00000000,0x00000000,0x00000000},0x1eba,1,2051},
	{{0x00000000,0x00000000,0x00000000},0x1ebb,1,2051},
	{{0x00000000,0x00000000,0x00000000},0x311c,1,6847},
	{{0x00000000,0x00000000,0x00000000},0x3047,1,6552},
	{{0x00000000,0x00000000,0x00000000},0x3048,1,6552},
	{{0x00000000,0x00000000,0x00000000},0x30a7,1,6744},
	{{0x00000000,0x00000000,0x00000000},0x30a8,1,6744},
	{{0x00000000,0x00000000,0x00000000},0x0118,1,36},
	{{0x00000000,0x00000000,0x00000000},0x0119,1,36},
	{{0x00000000,0x00000000,0x00000000},0x011a,1,39},
	{{0x00000000,0x00000000,0x00000000},0x011b,1,39},
	{{0x00000000,0x00000000,0x00000000},0x0415,1,970},
	{{0x00000000,0x00000000,0x00000000},0x0435,1,970},
	{{0x00000000,0x00000000,0x00000000},0x1ec0,1,2061},
	{{0x00000000,0x00000000,0x00000000},0x1ec1,1,2061},
	{{0x00000000,0x00000000,0x00000000},0x1ebe,1,2057},
	{{0x00000000,0x00000000,0x00000000},0x1ebf,1,2057},
	{{0x00000000,0x00000000,0x00000000},0x1ec6,1,2073},
	{{0x00000000,0x00000000,0x00000000},0x1ec7,1,2073},
	{{0x00000000,0x00000000,0x00000000},0x1ec2,1,2065},
	{{0x00000000,0x00000000,0x00000000},0x1ec3,1,2065},
	{{0x00000000,0x00000000,0x00000000},0x1ec4,1,2069},
	{{0x00000000,0x00000000,0x00000000},0x1ec5,1,2069},
	{{0x00000000,0x00000000,0x00000000},0x1ebc,1,2054},
	{{0x00000000,0x00000000,0x00000000},0x1ebd,1,2054},
	{{0x00000000,0x00000000,0x00000000},0x01b7,1,279},
	{{0x00000000,0x00000000,0x00000000},0x0292,1,279},
	{{0x00010003,0x00000000,0x00000000},0x0424,1,1040},
	{{0x00010005,0x00000000,0x00000000},0x0444,1,1040},
	{{0x00000000,0x00000000,0x00000000},0x2302,1,4640},
	{{0x00000201,0x00000000,0x00000000},0x311d,1,4640},
	{{0x00000000,0x00000000,0x00000000},0x311d,1,6850},
	{{0x00000201,0x00000000,0x00000000},0x311f,1,6857},
	{{0x00000000,0x00000000,0x00000020},0x2078,0,1470},
	{{0x00000000,0x00000000,0x00000040},0x2088,0,1470},
	{{0x00004001,0x00000000,0x00000000},0x2467,0,1470},
	{{0x00000001,0x00040000,0x00000000},0x247b,0,1470},
	{{0x00000081,0x00000000,0x00000400},0x0668,0,1470},
	{{0x00000000,0x00804000,0x00000000},0x2167,0,1470},
	{{0x02000001,0x00000000,0x00000002},0x248f,0,1470},
	{{0x00000000,0x00040000,0x00000800},0x3227,0,1470},
	{{0x00000004,0x00804000,0x00000000},0x2177,0,1470},
	{{0x00004000,0x00002000,0x00000000},0x2471,1,5007},
	{{0x00000000,0x00042000,0x00000000},0x2485,1,5007},
	{{0x02000000,0x00002000,0x00000002},0x2499,1,5007},
	{{0x00000000,0x00010000,0x00000018},0x215b,1,3629},
	{{0x00000000,0x00000000,0x00000000},0x266a,1,6191},
	{{0x00010003,0x00000000,0x00000000},0x041b,1,998},
	{{0x00010005,0x00000000,0x00000000},0x043b,1,998},
	{{0x00000000,0x00000000,0x00000001},0x2208,1,4104},
	{{0x00000000,0x00804000,0x00000000},0x216a,1,3723},
	{{0x00004000,0x00002000,0x00000000},0x246a,1,3723},
	{{0x00000000,0x00042000,0x00000000},0x247e,1,3723},
	{{0x00000004,0x00804000,0x00000000},0x217a,1,3723},
	{{0x02000000,0x00002000,0x00000002},0x2492,1,3723},
	{{0x00000000,0x00000001,0x00000000},0x2026,1,3044},
	{{0x00000000,0x40000000,0x00000000},0x22ee,1,3044},
	{{0x00000000,0x00000000,0x00000200},0x2003,0,1156},
	{{0x00010003,0x00000000,0x00000000},0x041c,0,1156},
	{{0x00010005,0x00000000,0x00000000},0x043c,0,1156},
	{{0x00000000,0x00000000,0x00000000},0x2014,1,2903},
	{{0x00000000,0x00000000,0x00000000},0x2205,1,4075},
	{{0x00000000,0x00000000,0x00000200},0x2002,1,1007},
	{{0x00000201,0x00000000,0x00000000},0x3123,1,1007},
	{{0x00010003,0x00000000,0x00000000},0x041d,1,1007},
	{{0x00010005,0x00000000,0x00000000},0x043d,1,1007},
	{{0x00000000,0x00000000,0x00000000},0x2013,1,2892},
	{{0x00000201,0x00000000,0x00000000},0x3125,1,153},
	{{0x00000003,0x00000040,0x00000000},0x014a,1,153},
	{{0x00000005,0x00000040,0x00000000},0x014b,1,153},
	{{0x08000003,0x00000000,0x00000000},0x0395,1,628},
	{{0x08000005,0x00000000,0x00000000},0x03b5,1,628},
	{{0x08000003,0x00000000,0x20000000},0x0388,1,628},
	{{0x08000005,0x00000000,0x20000000},0x03ad,1,628},
	{{0x08000005,0x00200000,0x00000000},0x1f10,1,628},
	{{0x08020005,0x00000000,0x00000000},0x1f11,1,628},
	{{0x08000003,0x00200000,0x00000000},0x1f18,1,628},
	{{0x08020003,0x00000000,0x00000000},0x1f19,1,628},
	{{0x08000005,0x20000000,0x00000000},0x1f72,1,628},
	{{0x08000005,0x00020000,0x00000000},0x1f73,1,628},
	{{0x08000003,0x20000000,0x00000000},0x1fc8,1,628},
	{{0x08000003,0x00020000,0x00000000},0x1fc9,1,628},
	{{0x08000005,0x20200000,0x00000000},0x1f12,1,628},
	{{0x08020005,0x20000000,0x00000000},0x1f13,1,628},
	{{0x08000005,0x00220000,0x00000000},0x1f14,1,628},
	{{0x08020005,0x00020000,0x00000000},0x1f15,1,628},
	{{0x08000003,0x20200000,0x00000000},0x1f1a,1,628},
	{{0x08020003,0x20000000,0x00000000},0x1f1b,1,628},
	{{0x08000003,0x00220000,0x00000000},0x1f1c,1,628},
	{{0x08020003,0x00020000,0x00000000},0x1f1d,1,628},
	{{0x00000001,0x00000000,0x00000020},0x207c,0,1502},
	{{0x00000001,0x00000000,0x00000040},0x208c,0,1502},
	{{0x00000201,0x00000000,0x00000000},0x3126,1,1022},
	{{0x00010003,0x00000000,0x00000000},0x0420,1,1022},
	{{0x00010005,0x00000000,0x00000000},0x0440,1,1022},
	{{0x00010003,0x00000000,0x00000000},0x0421,0,1864},
	{{0x00010005,0x00000000,0x00000000},0x0441,0,1864},
	{{0x00000000,0x00000000,0x00000000},0x212e,1,3524},
	{{0x00000000,0x00000000,0x00000000},0x212e,1,3507},
	{{0x00000001,0x00000000,0x00000000},0x20ac,1,3347},
	{{0x00100000,0x00000800,0x00000000},0x203c,0,1292},
	{{0x00000000,0x00000000,0x00000000},0x01ee,1,379},
	{{0x00000000,0x00000000,0x00000000},0x01ef,1,379},
	{{0x00000003,0x00000040,0x00000000},0x01b7,1,275},
	{{0x00000005,0x00000040,0x00000000},0x0292,1,275},
	{{0x00001003,0x00000040,0x00000000},0x01ee,1,275},
	{{0x00001005,0x00000040,0x00000000},0x01ef,1,275},
	{{0x00000201,0x00000000,0x00000000},0x3108,0,1556},
	{{0x80000003,0x00000040,0x00000000},0x0191,0,1556},
	{{0x80000005,0x00000040,0x00000000},0x0192,0,1556},
	{{0x00000005,0x00040040,0x00000000},0x24a1,0,1556},
	{{0x00004003,0x00000040,0x00000000},0x24bb,0,1556},
	{{0x00004005,0x00000040,0x00000000},0x24d5,0,1556},
	{{0x0008000b,0x00000040,0x00000000},0x1e1e,0,1556},
	{{0x0008000d,0x00000040,0x00000000},0x1e1f,0,1556},
	{{0x00000000,0x00000000,0x00000000},0x24bb,1,5333},
	{{0x00000000,0x00000000,0x00000000},0x24d5,1,5333},
	{{0x00000000,0x00000000,0x00000000},0x03a6,1,789},
	{{0x00000000,0x00000000,0x00000000},0x03c6,1,789},
	{{0x00000000,0x00000000,0x00000000},0x0641,1,1522},
	{{0x00000000,0x00000000,0x00000000},0xfed3,1,7295},
	{{0x00000000,0x00000000,0x00000000},0xfed1,1,7287},
	{{0x00000000,0x00000000,0x00000000},0xfed2,1,7291},
	{{0x00000000,0x00000000,0x00000000},0xfed4,1,7299},
	{{0x00000000,0x00000000,0x00000000},0x1e1e,1,1783},
	{{0x00000000,0x00000000,0x00000000},0x1e1f,1,1783},
	{{0x00000000,0x00000000,0x00000000},0x0191,1,254},
	{{0x00000000,0x00000000,0x00000000},0x0192,1,254},
	{{0x00000000,0x00000000,0x00000000},0x0472,1,1140},
	{{0x00000000,0x00000000,0x00000000},0x0473,1,1140},
	{{0x00000000,0x00000000,0x00000000},0x3108,1,6799},
	{{0x00000000,0x00000000,0x00000000},0x0424,1,1043},
	{{0x00000000,0x00000000,0x00000000},0x0444,1,1043},
	{{0x00000000,0x00000000,0x00000000},0x2200,1,4035},
	{{0x00000080,0x00000000,0x00000000},0x064e,1,1602},
	{{0x00000080,0x00000000,0x00000000},0x064b,1,1566},
	{{0x00000000,0x00000000,0x00000000},0x2588,1,5692},
	{{0x00000000,0x00000000,0x00000000},0x2571,1,5646},
	{{0x00000000,0x00000000,0x00000000},0x25e2,1,5646},
	{{0x00000081,0x00000000,0x00000000},0x0641,1,1518},
	{{0x00000081,0x00000010,0x00000000},0xfed1,1,1518},
	{{0x01000081,0x00000000,0x00000000},0xfed2,1,1518},
	{{0x00000081,0x00000004,0x00000000},0xfed3,1,1518},
	{{0x00000081,0x00001000,0x00000000},0xfed4,1,1518},
	{{0x00000001,0x00000000,0x00000000},0x2640,1,6115},
	{{0x00000000,0x00000000,0x00000000},0xfb00,0,883},
	{{0x00000004,0x00000040,0x00000100},0xfb00,0,883},
	{{0x00000000,0x00000000,0x00000000},0xfb03,1,6966},
	{{0x00000004,0x00000040,0x00000100},0xfb03,1,6966},
	{{0x00000000,0x00000000,0x00000000},0xfb04,1,6970},
	{{0x00000004,0x00000040,0x00000100},0xfb04,1,6970},
	{{0x00000000,0x00000000,0x00000000},0xfb01,1,6960},
	{{0x00000004,0x00000040,0x00000100},0xfb01,1,6960},
	{{0x00004000,0x00002000,0x00000000},0x246e,1,4966},
	{{0x00000000,0x00042000,0x00000000},0x2482,1,4966},
	{{0x02000000,0x00002000,0x00000002},0x2496,1,4966},
	{{0x00000000,0x00010000,0x00000018},0x2155,1,3551},
	{{0x00000000,0x00804000,0x00000000},0x216c,1,3740},
	{{0x00000004,0x00804000,0x00000000},0x217c,1,3740},
	{{0x00000001,0x00000001,0x00000080},0x25a4,1,5773},
	{{0x00000001,0x40000000,0x00000080},0x25a5,1,5773},
	{{0x00010003,0x00000000,0x00000000},0x0472,1,1135},
	{{0x00010005,0x00000000,0x00000000},0x0473,1,1135},
	{{0x00000000,0x00000000,0x00000020},0x2075,0,1455},
	{{0x00000000,0x00000000,0x00000040},0x2085,0,1455},
	{{0x00004001,0x00000000,0x00000000},0x2464,0,1455},
	{{0x00000001,0x00040000,0x00000000},0x2478,0,1455},
	{{0x00000081,0x00000000,0x00000400},0x0665,0,1455},
	{{0x00000000,0x00804000,0x00000000},0x2164,0,1455},
	{{0x02000001,0x00000000,0x00000002},0x248c,0,1455},
	{{0x00000000,0x00040000,0x00000800},0x3224,0,1455},
	{{0x00000004,0x00804000,0x00000000},0x2174,0,1455},
	{{0x00000000,0x00000000,0x00000018},0x215d,1,3656},
	{{0x00000000,0x00804000,0x00000000},0x216e,1,3763},
	{{0x00000004,0x00804000,0x00000000},0x217e,1,3763},
	{{0x00000000,0x00000000,0x00000018},0x215a,1,3614},
	{{0x00000000,0x00804000,0x00000000},0x2181,1,3817},
	{{0x00000000,0x00000000,0x00000000},0xfb02,1,6963},
	{{0x00000004,0x00000040,0x00000100},0xfb02,1,6963},
	{{0x00000000,0x00000080,0x00000000},0x230a,1,4657},
	{{0x00000000,0x00400000,0x00000000},0x230b,1,4657},
	{{0x00000000,0x00000000,0x00000000},0x2640,1,6122},
	{{0x00000000,0x00000000,0x00000000},0x2200,1,4027},
	{{0x00000000,0x00000000,0x00040000},0x2442,1,4802},
	{{0x00000000,0x00000000,0x00840000},0x2443,1,4802},
	{{0x00000000,0x00000000,0x00000020},0x2074,0,1450},
	{{0x00000000,0x00000000,0x00000040},0x2084,0,1450},
	{{0x00004001,0x00000000,0x00000000},0x2463,0,1450},
	{{0x00000001,0x00040000,0x00000000},0x2477,0,1450},
	{{0x00000081,0x00000000,0x00000400},0x0664,0,1450},
	{{0x00000000,0x00804000,0x00000000},0x2163,0,1450},
	{{0x02000001,0x00000000,0x00000002},0x248b,0,1450},
	{{0x00000000,0x00040000,0x00000800},0x3223,0,1450},
	{{0x00000004,0x00804000,0x00000000},0x2173,0,1450},
	{{0x00000000,0x00000000,0x00000018},0x2158,1,3590},
	{{0x00000000,0x00000000,0x00000200},0x2005,1,2841},
	{{0x00004000,0x00002000,0x00000000},0x246d,1,4952},
	{{0x00000000,0x00042000,0x00000000},0x2481,1,4952},
	{{0x02000000,0x00002000,0x00000002},0x2495,1,4952},
	{{0x00000000,0x00000000,0x00000000},0x220e,1,4143},
	{{0x00000001,0x00000000,0x00000000},0x20a3,1,3315},
	{{0x00000000,0x00000000,0x00000000},0x25a0,0,1206},
	{{0x00000201,0x00000000,0x00000000},0x310d,0,1558},
	{{0x00008003,0x00000040,0x00000000},0x011c,0,1558},
	{{0x00008005,0x00000040,0x00000000},0x011d,0,1558},
	{{0x00000803,0x00000040,0x00000000},0x011e,0,1558},
	{{0x00000805,0x00000040,0x00000000},0x011f,0,1558},
	{{0x00002003,0x00000040,0x00000000},0x0122,0,1558},
	{{0x00002005,0x00000040,0x00000000},0x0123,0,1558},
	{{0x00000003,0x00000040,0x10000000},0x01e4,0,1558},
	{{0x00000005,0x00000040,0x10000000},0x01e5,0,1558},
	{{0x00001003,0x00000040,0x00000000},0x01e6,0,1558},
	{{0x00001005,0x00000040,0x00000000},0x01e7,0,1558},
	{{0x00000013,0x00000040,0x00000000},0x01f4,0,1558},
	{{0x00000015,0x00000040,0x00000000},0x01f5,0,1558},
	{{0x00000003,0x00000440,0x00000000},0x1e20,0,1558},
	{{0x00000005,0x00000440,0x00000000},0x1e21,0,1558},
	{{0x00000005,0x00040040,0x00000000},0x24a2,0,1558},
	{{0x00004003,0x00000040,0x00000000},0x24bc,0,1558},
	{{0x00004005,0x00000040,0x00000000},0x24d6,0,1558},
	{{0x0008000b,0x00000040,0x00000000},0x0120,0,1558},
	{{0x0008000d,0x00000040,0x00000000},0x0121,0,1558},
	{{0x00000000,0x00000000,0x00000000},0x24bc,1,5337},
	{{0x00000000,0x00000000,0x00000000},0x24d6,1,5337},
	{{0x00000000,0x00000000,0x00000000},0x0403,1,889},
	{{0x00000000,0x00000000,0x00000000},0x0453,1,889},
	{{0x00000000,0x00000000,0x00000000},0x01f4,1,389},
	{{0x00000000,0x00000000,0x00000000},0x01f5,1,389},
	{{0x00000000,0x00000000,0x00000000},0x011e,1,45},
	{{0x00000000,0x00000000,0x00000000},0x011f,1,45},
	{{0x00000000,0x00000000,0x00000000},0x0393,1,682},
	{{0x00000000,0x00000000,0x00000000},0x03b3,1,682},
	{{0x00000000,0x00000000,0x00000000},0x05d2,1,1176},
	{{0x00000000,0x00000000,0x00000000},0x062c,1,1176},
	{{0x00000000,0x00000000,0x00000000},0xfe9f,1,7087},
	{{0x00000000,0x00000000,0x00000000},0xfe9d,1,7079},
	{{0x00000000,0x00000000,0x00000000},0xfe9e,1,7083},
	{{0x00000000,0x00000000,0x00000000},0xfea0,1,7091},
	{{0x00000000,0x00000000,0x00000000},0x0122,1,51},
	{{0x00000000,0x00000000,0x00000000},0x0123,1,51},
	{{0x00000000,0x00000000,0x00000000},0x1e20,1,1786},
	{{0x00000000,0x00000000,0x00000000},0x1e21,1,1786},
	{{0x00000000,0x00000000,0x00000000},0x0120,1,48},
	{{0x00000000,0x00000000,0x00000000},0x0121,1,48},
	{{0x00000000,0x00000000,0x00000000},0x01e4,1,364},
	{{0x00000000,0x00000000,0x00000000},0x01e5,1,364},
	{{0x00000000,0x00000000,0x00000000},0x0490,1,1157},
	{{0x00000000,0x00000000,0x00000000},0x0491,1,1157},
	{{0x00000000,0x00000000,0x00000000},0x310d,1,6811},
	{{0x00000000,0x00000000,0x00000000},0x01e6,1,367},
	{{0x00000000,0x00000000,0x00000000},0x01e7,1,367},
	{{0x00000000,0x00000000,0x00000000},0x0413,1,961},
	{{0x00000000,0x00000000,0x00000000},0x0433,1,961},
	{{0x00000000,0x00000000,0x00000000},0x011c,1,42},
	{{0x00000000,0x00000000,0x00000000},0x011d,1,42},
	{{0x40000001,0x00000000,0x00000000},0x304c,1,6558},
	{{0x00000001,0x00000020,0x00000000},0x30ac,1,6558},
	{{0x00000081,0x00000000,0x00000000},0x06af,1,1721},
	{{0x08000003,0x00000000,0x00000000},0x0393,1,676},
	{{0x08000005,0x00000000,0x00000000},0x03b3,1,676},
	{{0x40000001,0x00000000,0x00000000},0x3052,1,6576},
	{{0x00000001,0x00000020,0x00000000},0x30b2,1,6576},
	{{0x00000000,0x00000800,0x00000000},0x3013,1,6478},
	{{0x00000000,0x00000000,0x00000000},0x06af,1,1725},
	{{0x00000081,0x00000000,0x00000000},0x063a,1,1498},
	{{0x00000081,0x00000010,0x00000000},0xfecd,1,1498},
	{{0x01000081,0x00000000,0x00000000},0xfece,1,1498},
	{{0x00000081,0x00000004,0x00000000},0xfecf,1,1498},
	{{0x00000081,0x00001000,0x00000000},0xfed0,1,1498},
	{{0x00010003,0x00000000,0x00000000},0x0413,1,957},
	{{0x00010005,0x00000000,0x00000000},0x0433,1,957},
	{{0x00010003,0x00000000,0x80000000},0x0490,1,957},
	{{0x00010005,0x00000000,0x80000000},0x0491,1,957},
	{{0x40000001,0x00000000,0x00000000},0x304e,1,6564},
	{{0x00000001,0x00000020,0x00000000},0x30ae,1,6564},
	{{0x20000001,0x00000000,0x00000000},0x05d2,1,1170},
	{{0x00010003,0x00000000,0x00000000},0x0403,1,885},
	{{0x00010005,0x00000000,0x00000000},0x0453,1,885},
	{{0x00000201,0x00000000,0x00000000},0x312c,1,6879},
	{{0x40000001,0x00000000,0x00000000},0x3054,1,6582},
	{{0x00000001,0x00000020,0x00000000},0x30b4,1,6582},
	{{0x00000000,0x04000000,0x00015000},0x2265,0,1509},
	{{0x40000001,0x00000000,0x00000000},0x3050,1,6570},
	{{0x00000001,0x00000020,0x00000000},0x30b0,1,6570},
	{{0x00000201,0x00000000,0x00000000},0x310f,0,1560},
	{{0x00008003,0x00000040,0x00000000},0x0124,0,1560},
	{{0x00008005,0x00000040,0x00000000},0x0125,0,1560},
	{{0x00000003,0x00000040,0x10000000},0x0126,0,1560},
	{{0x00000005,0x00000040,0x10000000},0x0127,0,1560},
	{{0x00040003,0x00000040,0x00000000},0x1e26,0,1560},
	{{0x00040005,0x00000040,0x00000000},0x1e27,0,1560},
	{{0x00002003,0x00000040,0x00000000},0x1e28,0,1560},
	{{0x00002005,0x00000040,0x00000000},0x1e29,0,1560},
	{{0x00000005,0x00040040,0x00000000},0x24a3,0,1560},
	{{0x00004003,0x00000040,0x00000000},0x24bd,0,1560},
	{{0x00004005,0x00000040,0x00000000},0x24d7,0,1560},
	{{0x0008000b,0x00000040,0x00000000},0x1e22,0,1560},
	{{0x0008000d,0x00000040,0x00000000},0x1e23,0,1560},
	{{0x00080103,0x00000040,0x00000000},0x1e24,0,1560},
	{{0x00080105,0x00000040,0x00000000},0x1e25,0,1560},
	{{0x00000903,0x00000040,0x00000000},0x1e2a,0,1560},
	{{0x00000905,0x00000040,0x00000000},0x1e2b,0,1560},
	{{0x00000000,0x00000000,0x00000000},0x24bd,1,5341},
	{{0x00000000,0x00000000,0x00000000},0x24d7,1,5341},
	{{0x00000000,0x00000000,0x00000000},0x0621,1,1345},
	{{0x00000000,0x00000000,0x00000000},0xfe80,1,6987},
	{{0x00000000,0x00000000,0x00000000},0x0398,1,714},
	{{0x00000000,0x00000000,0x00000000},0x03b8,1,714},
	{{0x00000000,0x00000000,0x00000000},0x05d4,1,1191},
	{{0x00000000,0x00000000,0x00000000},0x0647,1,1191},
	{{0x00000000,0x00000000,0x00000000},0xfeeb,1,7391},
	{{0x00000000,0x00000000,0x00000000},0xfee9,1,7383},
	{{0x00000000,0x00000000,0x00000000},0xfeea,1,7387},
	{{0x00000000,0x00000000,0x00000000},0xfeec,1,7395},
	{{0x00000000,0x00000000,0x00000000},0x1e28,1,1799},
	{{0x00000000,0x00000000,0x00000000},0x1e29,1,1799},
	{{0x00000000,0x00000000,0x00000000},0x1e2a,1,1802},
	{{0x00000000,0x00000000,0x00000000},0x1e2b,1,1802},
	{{0x00000000,0x00000000,0x00000000},0x1e24,1,1792},
	{{0x00000000,0x00000000,0x00000000},0x1e25,1,1792},
	{{0x00000000,0x00000000,0x00000000},0x1e22,1,1789},
	{{0x00000000,0x00000000,0x00000000},0x1e23,1,1789},
	{{0x00000000,0x00000000,0x00000000},0x0126,1,57},
	{{0x00000000,0x00000000,0x00000000},0x0127,1,57},
	{{0x00000000,0x00000000,0x00000000},0x310f,1,6817},
	{{0x00000000,0x00000000,0x00000000},0x1e26,1,1796},
	{{0x00000000,0x00000000,0x00000000},0x1e27,1,1796},
	{{0x00000000,0x00000000,0x00000000},0x0425,1,1049},
	{{0x00000000,0x00000000,0x00000000},0x0445,1,1049},
	{{0x00000000,0x00000000,0x00000000},0x0124,1,54},
	{{0x00000000,0x00000000,0x00000000},0x0125,1,54},
	{{0x40000001,0x00000000,0x00000000},0x306f,1,1046},
	{{0x00000001,0x00000020,0x00000000},0x30cf,1,1046},
	{{0x00010003,0x00000000,0x00000000},0x0425,1,1046},
	{{0x00010005,0x00000000,0x00000000},0x0445,1,1046},
	{{0x00000081,0x00000000,0x00000000},0x062d,1,1422},
	{{0x00000081,0x00000010,0x00000000},0xfea1,1,1422},
	{{0x01000081,0x00000000,0x00000000},0xfea2,1,1422},
	{{0x00000081,0x00000004,0x00000000},0xfea3,1,1422},
	{{0x00000081,0x00001000,0x00000000},0xfea4,1,1422},
	{{0x00000089,0x00000000,0x00000000},0x0681,1,1688},
	{{0x00000000,0x00000000,0x00000200},0x200a,1,2878},
	{{0x00000081,0x00000000,0x00000000},0x0621,1,1339},
	{{0x00000081,0x00000010,0x00000000},0xfe80,1,1339},
	{{0x000000a9,0x00000000,0x00000000},0x0623,1,1339},
	{{0x000001a1,0x00000000,0x00000000},0x0625,1,1339},
	{{0x000000a9,0x00000010,0x00000000},0xfe83,1,1339},
	{{0x010000a9,0x00000000,0x00000000},0xfe84,1,1339},
	{{0x010001a1,0x00000000,0x00000000},0xfe88,1,1339},
	{{0x00000000,0x00040000,0x00000000},0x321c,1,6882},
	{{0x00010003,0x00000000,0x00000000},0x042a,1,1079},
	{{0x00010005,0x00000000,0x00000000},0x044a,1,1079},
	{{0x20000001,0x00000000,0x00000000},0x05d4,1,1188},
	{{0x40000001,0x00000000,0x00000000},0x3078,1,1188},
	{{0x00000001,0x00000020,0x00000000},0x30d8,1,1188},
	{{0x00000000,0x80000000,0x00008000},0x2661,1,6142},
	{{0x00000000,0x00000000,0x00008004},0x2665,1,6142},
	{{0x00000081,0x00000000,0x00000000},0x0647,1,1543},
	{{0x00000081,0x00000010,0x00000000},0xfee9,1,1543},
	{{0x01000081,0x00000000,0x00000000},0xfeea,1,1543},
	{{0x00000081,0x00000004,0x00000000},0xfeeb,1,1543},
	{{0x00000081,0x00001000,0x00000000},0xfeec,1,1543},
	{{0x20000001,0x00000000,0x00000000},0x05d7,1,1210},
	{{0x00000000,0x00000000,0x00000000},0x0681,1,1698},
	{{0x00000000,0x00000000,0x00000000},0x2500,1,1698},
	{{0x00000000,0x00000000,0x00000000},0x2550,1,1698},
	{{0x00000000,0x00000000,0x00000000},0x2501,1,5424},
	{{0x00000000,0x00000000,0x00000000},0x2253,1,4505},
	{{0x40000001,0x00000000,0x00000000},0x3072,1,4505},
	{{0x00000001,0x00000020,0x00000000},0x30d2,1,4505},
	{{0x00000000,0x01000800,0x00000000},0x201b,1,2948},
	{{0x00100000,0x00000800,0x00000000},0x201f,1,2948},
	{{0x00000000,0x00000000,0x00000000},0x062d,1,1426},
	{{0x00000000,0x00000000,0x00000000},0xfea3,1,7103},
	{{0x00000000,0x00000000,0x00000000},0xfea1,1,7095},
	{{0x00000000,0x00000000,0x00000000},0xfea2,1,7099},
	{{0x00000000,0x00000000,0x00000000},0xfea4,1,7107},
	{{0x40000001,0x00000000,0x00000000},0x307b,0,1742},
	{{0x00000001,0x00000020,0x00000000},0x30db,0,1742},
	{{0x00000000,0x00000000,0x00000000},0x2302,1,4634},
	{{0x40000001,0x00000000,0x00000000},0x3075,1,6624},
	{{0x00000001,0x00000020,0x00000000},0x30d5,1,6624},
	{{0x00000000,0x00814000,0x00000000},0x216d,1,3750},
	{{0x00000004,0x00814000,0x00000000},0x217d,1,3750},
	{{0x00000000,0x00000000,0x00000000},0x2010,0,1407},
	{{0x00000000,0x00000000,0x00000000},0x2043,1,3253},
	{{0x00000000,0x00000000,0x00000000},0x2027,1,3056},
	{{0x40000001,0x00000000,0x00000000},0x3044,0,1562},
	{{0x00000001,0x00000020,0x00000000},0x30a4,0,1562},
	{{0x00000201,0x00000000,0x00000000},0x3127,0,1562},
	{{0x00010003,0x00000000,0x00000000},0x0418,0,1562},
	{{0x00010005,0x00000000,0x00000000},0x0438,0,1562},
	{{0x40000005,0x00000000,0x00000000},0x3043,0,1562},
	{{0x00000005,0x00000020,0x00000000},0x30a3,0,1562},
	{{0x00000003,0x02000040,0x00000000},0x0128,0,1562},
	{{0x00000005,0x02000040,0x00000000},0x0129,0,1562},
	{{0x00000003,0x00000440,0x00000000},0x012a,0,1562},
	{{0x00000005,0x00000440,0x00000000},0x012b,0,1562},
	{{0x00000803,0x00000040,0x00000000},0x012c,0,1562},
	{{0x00000805,0x00000040,0x00000000},0x012d,0,1562},
	{{0x00000003,0x00000040,0x02000000},0x012e,0,1562},
	{{0x00000005,0x00000040,0x02000000},0x012f,0,1562},
	{{0x00001003,0x00000040,0x00000000},0x01cf,0,1562},
	{{0x00001005,0x00000040,0x00000000},0x01d0,0,1562},
	{{0x00010003,0x00000000,0x08000000},0x0419,0,1562},
	{{0x00010005,0x00000000,0x08000000},0x0439,0,1562},
	{{0x00000005,0x00040040,0x00000000},0x24a4,0,1562},
	{{0x00004003,0x00000040,0x00000000},0x24be,0,1562},
	{{0x00004005,0x00000040,0x00000000},0x24d8,0,1562},
	{{0x0008000b,0x00000040,0x00000000},0x0130,0,1562},
	{{0x04100003,0x00000040,0x00000000},0x0208,0,1562},
	{{0x04100005,0x00000040,0x00000000},0x0209,0,1562},
	{{0x00000803,0x00000040,0x00800000},0x020a,0,1562},
	{{0x00000805,0x00000040,0x00800000},0x020b,0,1562},
	{{0x00010003,0x00000000,0x40400000},0x0406,0,1562},
	{{0x00010005,0x00000000,0x40400000},0x0456,0,1562},
	{{0x00000103,0x02000040,0x00000000},0x1e2c,0,1562},
	{{0x00000105,0x02000040,0x00000000},0x1e2d,0,1562},
	{{0x00040013,0x00000040,0x00000000},0x1e2e,0,1562},
	{{0x00040015,0x00000040,0x00000000},0x1e2f,0,1562},
	{{0x8000000b,0x00000040,0x00000000},0x1ec8,0,1562},
	{{0x8000000d,0x00000040,0x00000000},0x1ec9,0,1562},
	{{0x00080103,0x00000040,0x00000000},0x1eca,0,1562},
	{{0x00080105,0x00000040,0x00000000},0x1ecb,0,1562},
	{{0x00000000,0x00000000,0x00000000},0x24be,1,5345},
	{{0x00000000,0x00000000,0x00000000},0x24d8,1,5345},
	{{0x00000000,0x00000000,0x00000000},0x0208,1,418},
	{{0x00000000,0x00000000,0x00000000},0x0209,1,418},
	{{0x00000000,0x00000000,0x00000000},0x038a,1,642},
	{{0x00000000,0x00000000,0x00000000},0x03af,1,642},
	{{0x00000000,0x00000000,0x00000000},0x012c,1,66},
	{{0x00000000,0x00000000,0x00000000},0x012d,1,66},
	{{0x00000000,0x00000000,0x00000000},0x020a,1,422},
	{{0x00000000,0x00000000,0x00000000},0x020b,1,422},
	{{0x00000000,0x00000000,0x00000000},0x0399,1,717},
	{{0x00000000,0x00000000,0x00000000},0x03b9,1,717},
	{{0x00000000,0x00000000,0x00000000},0x1f76,1,2445},
	{{0x00000000,0x00000000,0x00000000},0x1fda,1,2445},
	{{0x00000000,0x00000000,0x00000000},0x1f77,1,2449},
	{{0x00000000,0x00000000,0x00000000},0x1fdb,1,2449},
	{{0x00000000,0x00000000,0x00000000},0x1fd0,1,2710},
	{{0x00000000,0x00000000,0x00000000},0x1fd8,1,2710},
	{{0x00000000,0x00000000,0x00000000},0x1f30,1,2279},
	{{0x00000000,0x00000000,0x00000000},0x1f38,1,2279},
	{{0x00000000,0x00000000,0x00000000},0x1f32,1,2287},
	{{0x00000000,0x00000000,0x00000000},0x1f3a,1,2287},
	{{0x00000000,0x00000000,0x00000000},0x1f34,1,2297},
	{{0x00000000,0x00000000,0x00000000},0x1f3c,1,2297},
	{{0x00000000,0x00000000,0x00000000},0x1f36,1,2307},
	{{0x00000000,0x00000000,0x00000000},0x1f3e,1,2307},
	{{0x00000000,0x00000000,0x00000000},0x1fd1,1,2714},
	{{0x00000000,0x00000000,0x00000000},0x1fd9,1,2714},
	{{0x00000000,0x00000000,0x00000000},0x1fd2,1,2718},
	{{0x00000000,0x00000000,0x00000000},0x1fd3,1,2723},
	{{0x00000000,0x00000000,0x00000000},0x1fd7,1,2732},
	{{0x00000000,0x00000000,0x00000000},0x1f31,1,2283},
	{{0x00000000,0x00000000,0x00000000},0x1f39,1,2283},
	{{0x00000000,0x00000000,0x00000000},0x1f33,1,2292},
	{{0x00000000,0x00000000,0x00000000},0x1f3b,1,2292},
	{{0x00000000,0x00000000,0x00000000},0x1f35,1,2302},
	{{0x00000000,0x00000000,0x00000000},0x1f3d,1,2302},
	{{0x00000000,0x00000000,0x00000000},0x1f37,1,2312},
	{{0x00000000,0x00000000,0x00000000},0x1f3f,1,2312},
	{{0x00000000,0x00000000,0x00000000},0x1fd6,1,2728},
	{{0x00000000,0x00000000,0x00000000},0x063a,1,1504},
	{{0x00000000,0x00000000,0x00000000},0xfecf,1,7279},
	{{0x00000000,0x00000000,0x00000000},0xfecd,1,7271},
	{{0x00000000,0x00000000,0x00000000},0xfece,1,7275},
	{{0x00000000,0x00000000,0x00000000},0xfed0,1,7283},
	{{0x00000000,0x00000000,0x00000000},0x012a,1,63},
	{{0x00000000,0x00000000,0x00000000},0x012b,1,63},
	{{0x00000000,0x00000000,0x00000000},0x1eca,1,2081},
	{{0x00000000,0x00000000,0x00000000},0x1ecb,1,2081},
	{{0x00000000,0x00000000,0x00000000},0x1e2c,1,1806},
	{{0x00000000,0x00000000,0x00000000},0x1e2d,1,1806},
	{{0x00000000,0x00000000,0x00000000},0x0130,1,72},
	{{0x00000000,0x00000000,0x00000000},0x0131,1,72},
	{{0x00000000,0x00000000,0x00000000},0x1ec8,1,2078},
	{{0x00000000,0x00000000,0x00000000},0x1ec9,1,2078},
	{{0x00000000,0x00000000,0x00000000},0x0390,1,662},
	{{0x00000000,0x00000000,0x00000000},0x3127,1,6870},
	{{0x00000000,0x00000000,0x00000000},0x3043,1,6546},
	{{0x00000000,0x00000000,0x00000000},0x3044,1,6546},
	{{0x00000000,0x00000000,0x00000000},0x30a3,1,6738},
	{{0x00000000,0x00000000,0x00000000},0x30a4,1,6738},
	{{0x00000000,0x00000000,0x00000000},0x1e2e,1,1810},
	{{0x00000000,0x00000000,0x00000000},0x1e2f,1,1810},
	{{0x00000000,0x00000000,0x00000000},0x012e,1,69},
	{{0x00000000,0x00000000,0x00000000},0x012f,1,69},
	{{0x00000000,0x00000000,0x00000000},0x01cf,1,318},
	{{0x00000000,0x00000000,0x00000000},0x01d0,1,318},
	{{0x00000000,0x00000000,0x00000000},0x0418,1,986},
	{{0x00000000,0x00000000,0x00000000},0x0438,1,986},
	{{0x00000000,0x00000000,0x00000000},0x0128,1,60},
	{{0x00000000,0x00000000,0x00000000},0x0129,1,60},
	{{0x00000000,0x00000000,0x00000000},0x25d9,1,6005},
	{{0x00000000,0x04000000,0x00000000},0x2261,1,4511},
	{{0x00000000,0x00000000,0x00000000},0x0404,1,892},
	{{0x00000000,0x00000000,0x00000000},0x0454,1,892},
	{{0x00010003,0x00000000,0x00000000},0x0415,1,892},
	{{0x00010005,0x00000000,0x00000000},0x0435,1,892},
	{{0x00010003,0x00000000,0x40000000},0x0404,1,892},
	{{0x00010005,0x00000000,0x40000000},0x0454,1,892},
	{{0x00000000,0x00000000,0x00000000},0x0406,1,902},
	{{0x00000000,0x00000000,0x00000000},0x0456,1,902},
	{{0x00000000,0x00000000,0x00000000},0x0132,1,85},
	{{0x00000000,0x00000000,0x00000000},0x0133,1,85},
	{{0x00000002,0x00000040,0x00000100},0x0132,1,85},
	{{0x00000004,0x00000040,0x00000100},0x0133,1,85},
	{{0x00000000,0x00000000,0x00000000},0x2321,1,4764},
	{{0x00000000,0x04000000,0x00011001},0x2253,1,4485},
	{{0x00000000,0x00000000,0x00000000},0x222b,0,1804},
	{{0x00000000,0x00000000,0x00000000},0x2206,1,4088},
	{{0x00000000,0x00000000,0x00000000},0x221e,1,4275},
	{{0x00000000,0x00000000,0x00000000},0x222b,1,4344},
	{{0x00100000,0x00000000,0x00000000},0x222c,1,4344},
	{{0x00000000,0x00000000,0x00000000},0x2229,1,4319},
	{{0x00000000,0x00000000,0x00000000},0x25d8,1,5975},
	{{0x00000000,0x80000000,0x00000000},0x25d9,1,5990},
	{{0x00000000,0x00000000,0x00000000},0x0401,1,875},
	{{0x00000000,0x00000000,0x00000000},0x0451,1,875},
	{{0x00000000,0x00000000,0x00000000},0x222e,1,875},
	{{0x00010003,0x00000000,0x00000000},0x0401,1,875},
	{{0x00010005,0x00000000,0x00000000},0x0451,1,875},
	{{0x00000000,0x00000000,0x00000000},0x3000,1,6341},
	{{0x00000000,0x00000800,0x00000800},0x3005,1,6399},
	{{0x40000000,0x00000800,0x00000000},0x309d,1,6399},
	{{0x00000000,0x00000820,0x00000000},0x30fd,1,6399},
	{{0x00000000,0x00000000,0x00000000},0x2320,1,4745},
	{{0x00000201,0x00000000,0x00000000},0x3129,1,4745},
	{{0x00010003,0x00000000,0x00000000},0x0474,1,1143},
	{{0x00010005,0x00000000,0x00000000},0x0475,1,1143},
	{{0x00000201,0x00000000,0x00000000},0x3110,0,1564},
	{{0x00008003,0x00000040,0x00000000},0x0134,0,1564},
	{{0x00008005,0x00000040,0x00000000},0x0135,0,1564},
	{{0x00001005,0x00000040,0x00000000},0x01f0,0,1564},
	{{0x00000005,0x00040040,0x00000000},0x24a5,0,1564},
	{{0x00004003,0x00000040,0x00000000},0x24bf,0,1564},
	{{0x00004005,0x00000040,0x00000000},0x24d9,0,1564},
	{{0x00000000,0x00000000,0x00000000},0x24bf,1,5349},
	{{0x00000000,0x00000000,0x00000000},0x24d9,1,5349},
	{{0x00000000,0x00000000,0x00000000},0x0408,1,911},
	{{0x00000000,0x00000000,0x00000000},0x0458,1,911},
	{{0x00000000,0x00000000,0x00000000},0x03aa,1,809},
	{{0x00000000,0x00000000,0x00000000},0x03ca,1,809},
	{{0x00000000,0x00000000,0x00000000},0x05d9,1,1228},
	{{0x00000000,0x00000000,0x00000000},0x0649,1,1228},
	{{0x00000000,0x00000000,0x00000000},0xfeef,1,7407},
	{{0x00000000,0x00000000,0x00000000},0xfef0,1,7411},
	{{0x00000000,0x00000000,0x00000000},0x037a,1,589},
	{{0x00000000,0x00000000,0x00000000},0x1fbe,1,589},
	{{0x00000000,0x00000000,0x00000000},0x3110,1,6820},
	{{0x00000000,0x00000000,0x00000000},0x01f0,1,382},
	{{0x00000000,0x00000000,0x00000000},0x0419,1,989},
	{{0x00000000,0x00000000,0x00000000},0x0439,1,989},
	{{0x00000000,0x00000000,0x00000000},0x0134,1,88},
	{{0x00000000,0x00000000,0x00000000},0x0135,1,88},
	{{0x00000000,0x00000000,0x00000000},0x042f,1,1112},
	{{0x00000000,0x00000000,0x00000000},0x044f,1,1112},
	{{0x00000000,0x00000000,0x00000000},0x3004,1,6359},
	{{0x00000000,0x00000000,0x00000000},0x042d,1,908},
	{{0x00000000,0x00000000,0x00000000},0x044d,1,908},
	{{0x00010003,0x00000000,0x00000000},0x0408,1,908},
	{{0x00010005,0x00000000,0x00000000},0x0458,1,908},
	{{0x00000081,0x00000000,0x00000000},0x062c,1,1417},
	{{0x00000081,0x00000010,0x00000000},0xfe9d,1,1417},
	{{0x01000081,0x00000000,0x00000000},0xfe9e,1,1417},
	{{0x00000081,0x00000004,0x00000000},0xfe9f,1,1417},
	{{0x00000081,0x00001000,0x00000000},0xfea0,1,1417},
	{{0x00000081,0x00000000,0x00000000},0x0698,1,1710},
	{{0x00000000,0x00000000,0x00000000},0x3004,1,6395},
	{{0x00000000,0x00000000,0x00000000},0x042e,1,1106},
	{{0x00000000,0x00000000,0x00000000},0x044e,1,1106},
	{{0x00000201,0x00000000,0x00000000},0x310e,0,1566},
	{{0x00002003,0x00000040,0x00000000},0x0136,0,1566},
	{{0x00002005,0x00000040,0x00000000},0x0137,0,1566},
	{{0x80000003,0x00000040,0x00000000},0x0198,0,1566},
	{{0x80000005,0x00000040,0x00000000},0x0199,0,1566},
	{{0x00001003,0x00000040,0x00000000},0x01e8,0,1566},
	{{0x00001005,0x00000040,0x00000000},0x01e9,0,1566},
	{{0x00000013,0x00000040,0x00000000},0x1e30,0,1566},
	{{0x00000015,0x00000040,0x00000000},0x1e31,0,1566},
	{{0x00000005,0x00040040,0x00000000},0x24a6,0,1566},
	{{0x00004003,0x00000040,0x00000000},0x24c0,0,1566},
	{{0x00004005,0x00000040,0x00000000},0x24da,0,1566},
	{{0x00080103,0x00000040,0x00000000},0x1e32,0,1566},
	{{0x00080105,0x00000040,0x00000000},0x1e33,0,1566},
	{{0x00000103,0x00000240,0x00000000},0x1e34,0,1566},
	{{0x00000105,0x00000240,0x00000000},0x1e35,0,1566},
	{{0x00000000,0x00000000,0x00000000},0x24c0,1,5353},
	{{0x00000000,0x00000000,0x00000000},0x24da,1,5353},
	{{0x00000000,0x00000000,0x00000000},0x05da,1,1235},
	{{0x00000000,0x00000000,0x00000000},0x1e30,1,1814},
	{{0x00000000,0x00000000,0x00000000},0x1e31,1,1814},
	{{0x00000000,0x00000000,0x00000000},0x039a,1,726},
	{{0x00000000,0x00000000,0x00000000},0x03ba,1,726},
	{{0x00000000,0x00000000,0x00000000},0x05db,1,1238},
	{{0x00000000,0x00000000,0x00000000},0x0643,1,1238},
	{{0x00000000,0x00000000,0x00000000},0xfedb,1,7327},
	{{0x00000000,0x00000000,0x00000000},0xfed9,1,7319},
	{{0x00000000,0x00000000,0x00000000},0xfeda,1,7323},
	{{0x00000000,0x00000000,0x00000000},0xfedc,1,7331},
	{{0x00000000,0x00000000,0x00000000},0x0136,1,91},
	{{0x00000000,0x00000000,0x00000000},0x0137,1,91},
	{{0x00000000,0x00000000,0x00000000},0x1e32,1,1817},
	{{0x00000000,0x00000000,0x00000000},0x1e33,1,1817},
	{{0x00000000,0x00000000,0x00000000},0x0198,1,257},
	{{0x00000000,0x00000000,0x00000000},0x0199,1,257},
	{{0x00000000,0x00000000,0x00000000},0x03de,1,863},
	{{0x00000000,0x00000000,0x00000000},0x310e,1,6814},
	{{0x00000000,0x00000000,0x00000000},0x01e8,1,370},
	{{0x00000000,0x00000000,0x00000000},0x01e9,1,370},
	{{0x00000000,0x00000000,0x00000000},0x041a,1,995},
	{{0x00000000,0x00000000,0x00000000},0x043a,1,995},
	{{0x00000000,0x00000000,0x00000000},0x1e34,1,1821},
	{{0x00000000,0x00000000,0x00000000},0x1e35,1,1821},
	{{0x40000001,0x00000000,0x00000000},0x304b,1,992},
	{{0x00000001,0x00000020,0x00000000},0x30ab,1,992},
	{{0x00010003,0x00000000,0x00000000},0x041a,1,992},
	{{0x00010005,0x00000000,0x00000000},0x043a,1,992},
	{{0x00000005,0x00000020,0x00000000},0x30f5,1,992},
	{{0x20000001,0x00000000,0x00000000},0x05db,1,1231},
	{{0x00000081,0x00000000,0x00000000},0x0643,1,1231},
	{{0x21000001,0x00000000,0x00000000},0x05da,1,1231},
	{{0x00000081,0x00000010,0x00000000},0xfed9,1,1231},
	{{0x01000081,0x00000000,0x00000000},0xfeda,1,1231},
	{{0x00000081,0x00000004,0x00000000},0xfedb,1,1231},
	{{0x00000081,0x00001000,0x00000000},0xfedc,1,1231},
	{{0x08000003,0x00000000,0x00000000},0x039a,1,720},
	{{0x08000005,0x00000000,0x00000000},0x03ba,1,720},
	{{0x00000080,0x00000000,0x00000000},0x0650,1,1620},
	{{0x00000080,0x00000000,0x00000000},0x064d,1,1590},
	{{0x40000001,0x00000000,0x00000000},0x3051,1,6573},
	{{0x00000001,0x00000020,0x00000000},0x30b1,1,6573},
	{{0x00000005,0x00000020,0x00000000},0x30f6,1,6573},
	{{0x00000081,0x00000000,0x00000000},0x062e,1,1429},
	{{0x00000081,0x00000010,0x00000000},0xfea5,1,1429},
	{{0x01000081,0x00000000,0x00000000},0xfea6,1,1429},
	{{0x00000081,0x00000004,0x00000000},0xfea7,1,1429},
	{{0x00000081,0x00001000,0x00000000},0xfea8,1,1429},
	{{0x40000001,0x00000000,0x00000000},0x304d,1,6561},
	{{0x00000001,0x00000020,0x00000000},0x30ad,1,6561},
	{{0x00000000,0x00000000,0x00000000},0x040c,1,931},
	{{0x00000000,0x00000000,0x00000000},0x045c,1,931},
	{{0x00010003,0x00000000,0x00000000},0x040c,1,927},
	{{0x00010005,0x00000000,0x00000000},0x045c,1,927},
	{{0x00000000,0x00000000,0x00000000},0x0138,1,98},
	{{0x40000001,0x00000000,0x00000000},0x3053,1,6579},
	{{0x00000001,0x00000020,0x00000000},0x30b3,1,6579},
	{{0x08000001,0x00000000,0x00000000},0x03de,1,857},
	{{0x00010003,0x00000000,0x00000000},0x0480,1,857},
	{{0x00010005,0x00000000,0x00000000},0x0481,1,857},
	{{0x00000000,0x00000000,0x00000000},0x327f,1,6933},
	{{0x08000000,0x00000000,0x00000000},0x1fbd,1,2653},
	{{0x00000005,0x00000040,0x00000000},0x0138,1,94},
	{{0x00000000,0x00000000,0x00000000},0x327f,1,6956},
	{{0x40000001,0x00000000,0x00000000},0x304f,1,6567},
	{{0x00000001,0x00000020,0x00000000},0x30af,1,6567},
	{{0x00000201,0x00000000,0x00000000},0x310c,0,1568},
	{{0x00000013,0x00000040,0x00000000},0x0139,0,1568},
	{{0x00000015,0x00000040,0x00000000},0x013a,0,1568},
	{{0x00002003,0x00000040,0x00000000},0x013b,0,1568},
	{{0x00002005,0x00000040,0x00000000},0x013c,0,1568},
	{{0x00001003,0x00000040,0x00000000},0x013d,0,1568},
	{{0x00001005,0x00000040,0x00000000},0x013e,0,1568},
	{{0x00000003,0x00000040,0x10000000},0x0141,0,1568},
	{{0x00000005,0x00000040,0x10000000},0x0142,0,1568},
	{{0x00000005,0x00040040,0x00000000},0x24a7,0,1568},
	{{0x00004003,0x00000040,0x00000000},0x24c1,0,1568},
	{{0x00004005,0x00000040,0x00000000},0x24db,0,1568},
	{{0x00080003,0x00000040,0x01000000},0x013f,0,1568},
	{{0x00080005,0x00000040,0x01000000},0x0140,0,1568},
	{{0x00080103,0x00000040,0x00000000},0x1e36,0,1568},
	{{0x00080105,0x00000040,0x00000000},0x1e37,0,1568},
	{{0x00000103,0x00000240,0x00000000},0x1e3a,0,1568},
	{{0x00000105,0x00000240,0x00000000},0x1e3b,0,1568},
	{{0x00008103,0x00000040,0x00000000},0x1e3c,0,1568},
	{{0x00008105,0x00000040,0x00000000},0x1e3d,0,1568},
	{{0x00080103,0x00000440,0x00000000},0x1e38,0,1568},
	{{0x00080105,0x00000440,0x00000000},0x1e39,0,1568},
	{{0x00000007,0x00000040,0x00000000},0x01c8,1,300},
	{{0x00000000,0x00000000,0x00000000},0x24c1,1,5357},
	{{0x00000000,0x00000000,0x00000000},0x24db,1,5357},
	{{0x00000000,0x00000000,0x00000000},0x0139,1,101},
	{{0x00000000,0x00000000,0x00000000},0x013a,1,101},
	{{0x00000000,0x00000000,0x00000000},0x039b,1,735},
	{{0x00000000,0x00000000,0x00000000},0x03bb,1,735},
	{{0x00000000,0x00000000,0x00000000},0x05dc,1,1247},
	{{0x00000000,0x00000000,0x00000000},0x0644,1,1247},
	{{0x00000000,0x00000000,0x00000000},0xfedf,1,7343},
	{{0x00000000,0x00000000,0x00000000},0xfedd,1,7335},
	{{0x00000000,0x00000000,0x00000000},0xfede,1,7339},
	{{0x00000000,0x00000000,0x00000000},0xfee0,1,7347},
	{{0x00000000,0x00000000,0x00000000},0x013b,1,104},
	{{0x00000000,0x00000000,0x00000000},0x013c,1,104},
	{{0x00000000,0x00000000,0x00000000},0x1e38,1,1828},
	{{0x00000000,0x00000000,0x00000000},0x1e39,1,1828},
	{{0x00000000,0x00000000,0x00000000},0x1e36,1,1824},
	{{0x00000000,0x00000000,0x00000000},0x1e37,1,1824},
	{{0x00000000,0x00000000,0x00000000},0x1e3c,1,1836},
	{{0x00000000,0x00000000,0x00000000},0x1e3d,1,1836},
	{{0x00000000,0x00000000,0x00000000},0x013f,1,110},
	{{0x00000000,0x00000000,0x00000000},0x0140,1,110},
	{{0x00000000,0x00000000,0x00000000},0x0141,1,113},
	{{0x00000000,0x00000000,0x00000000},0x0142,1,113},
	{{0x00000000,0x00000000,0x00000000},0x310c,1,6808},
	{{0x00000000,0x00000000,0x00000000},0x013d,1,107},
	{{0x00000000,0x00000000,0x00000000},0x013e,1,107},
	{{0x00000000,0x00000000,0x00000000},0x041b,1,1001},
	{{0x00000000,0x00000000,0x00000000},0x043b,1,1001},
	{{0x00000000,0x00000000,0x00000000},0x1e3a,1,1833},
	{{0x00000000,0x00000000,0x00000000},0x1e3b,1,1833},
	{{0x00000000,0x00000000,0x00000000},0xfefb,1,7467},
	{{0x00000000,0x00000000,0x00000000},0xfefc,1,7471},
	{{0x00000081,0x00000000,0x00000000},0x0644,1,1529},
	{{0x00000081,0x00000010,0x00000000},0xfedd,1,1529},
	{{0x01000081,0x00000000,0x00000000},0xfede,1,1529},
	{{0x00000081,0x00000004,0x00000000},0xfedf,1,1529},
	{{0x00000081,0x00001000,0x00000000},0xfee0,1,1529},
	{{0x000000a1,0x00000010,0x00000100},0xfefb,1,1529},
	{{0x010000a1,0x00000000,0x00000100},0xfefc,1,1529},
	{{0x000000a9,0x00000010,0x00000100},0xfef7,1,7449},
	{{0x010000a9,0x00000000,0x00000100},0xfef8,1,7449},
	{{0x000001a1,0x00000010,0x00000100},0xfef9,1,7449},
	{{0x010001a1,0x00000000,0x00000100},0xfefa,1,7449},
	{{0x000000a9,0x00000010,0x00000100},0xfef5,1,7431},
	{{0x010000a9,0x00000000,0x00000100},0xfef6,1,7431},
	{{0x08000003,0x00000000,0x00000000},0x039b,1,729},
	{{0x08000005,0x00000000,0x00000000},0x03bb,1,729},
	{{0x20000001,0x00000000,0x00000000},0x05dc,1,1241},
	{{0x00000000,0x00000000,0x00000000},0x25ef,1,6028},
	{{0x00000000,0x00000000,0x00800000},0x223e,1,4423},
	{{0x00000000,0x00000000,0x00000000},0x2584,1,5683},
	{{0x00000000,0x00000000,0x00000000},0x258c,1,5683},
	{{0x00000000,0x00000000,0x00000000},0x2557,1,5622},
	{{0x00000000,0x00000000,0x00000000},0x2513,1,5512},
	{{0x00000000,0x00000000,0x00002000},0x2190,1,3857},
	{{0x00100000,0x00000000,0x00002000},0x21d0,1,3857},
	{{0x00000000,0x00000080,0x00020004},0x3010,1,6451},
	{{0x00000000,0x00400000,0x00020004},0x3011,1,6451},
	{{0x00000000,0x80000080,0x00020000},0x3016,1,6451},
	{{0x00000000,0x80400000,0x00020000},0x3017,1,6451},
	{{0x00000000,0x04000000,0x00015000},0x2264,0,1497},
	{{0x00000000,0x00000000,0x00000000},0xfef7,1,7459},
	{{0x00000000,0x00000000,0x00000000},0xfef9,1,7459},
	{{0x00000000,0x00000000,0x00000000},0xfef8,1,7463},
	{{0x00000000,0x00000000,0x00000000},0xfefa,1,7463},
	{{0x00000000,0x00000000,0x00000000},0x2028,1,3087},
	{{0x00000001,0x00000000,0x00000000},0x20a4,1,3328},
	{{0x00000000,0x00000000,0x00000000},0x0409,1,293},
	{{0x00000000,0x00000000,0x00000000},0x0459,1,293},
	{{0x00000003,0x00000040,0x00000000},0x01c7,1,293},
	{{0x00000005,0x00000040,0x00000000},0x01c9,1,293},
	{{0x00000000,0x00000000,0x00000000},0x01c7,1,296},
	{{0x00000000,0x00000000,0x00000000},0x01c8,1,296},
	{{0x00000000,0x00000000,0x00000000},0x01c9,1,296},
	{{0x00010003,0x00000000,0x00000000},0x0409,1,914},
	{{0x00010005,0x00000000,0x00000000},0x0459,1,914},
	{{0x00000000,0x00000000,0x00000000},0xfef5,1,7441},
	{{0x00000000,0x00000000,0x00000000},0xfef6,1,7445},
	{{0x00000001,0x00000000,0x00000000},0x2227,1,4308},
	{{0x00000000,0x00000000,0x00010000},0x2228,1,4308},
	{{0x00000005,0x00000040,0x00000000},0x017f,1,235},
	{{0x00000004,0x00000040,0x00000100},0xfb05,1,6974},
	{{0x00100000,0x00000200,0x00000000},0x2017,0,1641},
	{{0x00000000,0x01000800,0x00000000},0x201a,1,2929},
	{{0x00100000,0x00000800,0x00000000},0x201e,1,2929},
	{{0x08000001,0x00004000,0x00000000},0x0375,1,566},
	{{0x00000000,0x00000000,0x00080000},0x2584,1,5671},
	{{0x00000000,0x00400000,0x00000004},0x25e2,1,6008},
	{{0x00000000,0x00000080,0x00000004},0x25e3,1,6008},
	{{0x00000000,0x00000000,0x00000000},0x25ca,1,5936},
	{{0x00000000,0x00000000,0x00000000},0x200e,1,2886},
	{{0x00000000,0x00000000,0x00000000},0x25ca,1,5944},
	{{0x00000201,0x00000000,0x00000000},0x3107,0,1570},
	{{0x00000013,0x00000040,0x00000000},0x1e3e,0,1570},
	{{0x00000015,0x00000040,0x00000000},0x1e3f,0,1570},
	{{0x00000005,0x00040040,0x00000000},0x24a8,0,1570},
	{{0x00004003,0x00000040,0x00000000},0x24c2,0,1570},
	{{0x00004005,0x00000040,0x00000000},0x24dc,0,1570},
	{{0x0008000b,0x00000040,0x00000000},0x1e40,0,1570},
	{{0x0008000d,0x00000040,0x00000000},0x1e41,0,1570},
	{{0x00080103,0x00000040,0x00000000},0x1e42,0,1570},
	{{0x00080105,0x00000040,0x00000000},0x1e43,0,1570},
	{{0x00000000,0x00000000,0x00000000},0x24c2,1,5361},
	{{0x00000000,0x00000000,0x00000000},0x24dc,1,5361},
	{{0x00000000,0x00000000,0x00000000},0x05dd,1,1254},
	{{0x00000000,0x00000000,0x00000000},0x1e3e,1,1840},
	{{0x00000000,0x00000000,0x00000000},0x1e3f,1,1840},
	{{0x00000000,0x00000000,0x00000000},0x039c,1,741},
	{{0x00000000,0x00000000,0x00000000},0x03bc,1,741},
	{{0x00000000,0x00000000,0x00000000},0x05de,1,1257},
	{{0x00000000,0x00000000,0x00000000},0x0645,1,1257},
	{{0x00000000,0x00000000,0x00000000},0xfee3,1,7359},
	{{0x00000000,0x00000000,0x00000000},0xfee1,1,7351},
	{{0x00000000,0x00000000,0x00000000},0xfee2,1,7355},
	{{0x00000000,0x00000000,0x00000000},0xfee4,1,7363},
	{{0x00000000,0x00000000,0x00000000},0x1e42,1,1846},
	{{0x00000000,0x00000000,0x00000000},0x1e43,1,1846},
	{{0x00000000,0x00000000,0x00000000},0x1e40,1,1843},
	{{0x00000000,0x00000000,0x00000000},0x1e41,1,1843},
	{{0x00000000,0x00000000,0x00000000},0x266c,1,6256},
	{{0x00000000,0x00000000,0x00000000},0x266b,1,6230},
	{{0x00000000,0x00000000,0x00000000},0x03dc,1,854},
	{{0x00000000,0x00000000,0x00000000},0x3107,1,6796},
	{{0x00000000,0x00000000,0x00000000},0x266a,1,6203},
	{{0x00000000,0x00000000,0x00000000},0x041c,1,1004},
	{{0x00000000,0x00000000,0x00000000},0x043c,1,1004},
	{{0x40000001,0x00000000,0x00000000},0x307e,1,6633},
	{{0x00000001,0x00000020,0x00000000},0x30de,1,6633},
	{{0x000000a9,0x00000000,0x00000000},0x0622,1,1348},
	{{0x000000a9,0x00000010,0x00000000},0xfe81,1,1348},
	{{0x010000a9,0x00000000,0x00000000},0xfe82,1,1348},
	{{0x000000a1,0x00000000,0x00000000},0x0649,1,1551},
	{{0x000000a1,0x00000010,0x00000000},0xfeef,1,1551},
	{{0x010000a1,0x00000000,0x00000000},0xfef0,1,1551},
	{{0x00000001,0x00000000,0x00000000},0x2642,1,6125},
	{{0x00000000,0x00000000,0x00000000},0x2720,1,6324},
	{{0x00000000,0x00000000,0x00000000},0x266d,1,6271},
	{{0x00000000,0x00000000,0x00000000},0x2669,1,6188},
	{{0x40000001,0x00000000,0x00000000},0x3081,1,6639},
	{{0x00000001,0x00000020,0x00000000},0x30e1,1,6639},
	{{0x00000000,0x00000000,0x00000000},0x2592,1,5707},
	{{0x00000081,0x00000000,0x00000000},0x0645,1,1533},
	{{0x00000081,0x00000010,0x00000000},0xfee1,1,1533},
	{{0x01000081,0x00000000,0x00000000},0xfee2,1,1533},
	{{0x00000081,0x00000004,0x00000000},0xfee3,1,1533},
	{{0x00000081,0x00001000,0x00000000},0xfee4,1,1533},
	{{0x20000001,0x00000000,0x00000000},0x05de,1,1250},
	{{0x21000001,0x00000000,0x00000000},0x05dd,1,1250},
	{{0x40000001,0x00000000,0x00000000},0x307f,1,6636},
	{{0x00000001,0x00000020,0x00000000},0x30df,1,6636},
	{{0x00000001,0x00000000,0x00000000},0x2212,1,3297},
	{{0x00000000,0x00000000,0x00000020},0x207b,1,3297},
	{{0x00000000,0x00000000,0x00000040},0x208b,1,3297},
	{{0x00000001,0x00000000,0x00010000},0x2213,1,4185},
	{{0x00000000,0x00000000,0x00000000},0x2642,1,6130},
	{{0x40000001,0x00000000,0x00000000},0x3082,1,6642},
	{{0x00000001,0x00000020,0x00000000},0x30e2,1,6642},
	{{0x00000001,0x00000400,0x00000000},0x02c9,1,507},
	{{0x00008001,0x00000000,0x00000000},0x02c6,1,485},
	{{0x04000001,0x00000000,0x00000000},0x02cb,1,485},
	{{0x00000001,0x00000000,0x00000000},0x02bb,1,460},
	{{0x40000001,0x00000000,0x00000000},0x3080,1,738},
	{{0x00000001,0x00000020,0x00000000},0x30e0,1,738},
	{{0x08000003,0x00000000,0x00000000},0x039c,1,738},
	{{0x08000005,0x00000000,0x00000000},0x03bc,1,738},
	{{0x00000000,0x00000000,0x00004000},0x226b,1,4543},
	{{0x00000000,0x00000000,0x00004000},0x226a,1,4530},
	{{0x00000001,0x00000000,0x00000000},0x266d,1,6260},
	{{0x00000001,0x00000000,0x00000000},0x266e,1,6274},
	{{0x00000001,0x00000000,0x00000000},0x266f,1,6291},
	{{0x00000000,0x00000000,0x00000000},0x266e,1,6288},
	{{0x00000000,0x00000000,0x00000000},0x266f,1,6288},
	{{0x40000001,0x00000000,0x00000000},0x3093,0,1572},
	{{0x00000001,0x00000020,0x00000000},0x30f3,0,1572},
	{{0x00000201,0x00000000,0x00000000},0x310b,0,1572},
	{{0x00000013,0x00000040,0x00000000},0x0143,0,1572},
	{{0x00000015,0x00000040,0x00000000},0x0144,0,1572},
	{{0x00002003,0x00000040,0x00000000},0x0145,0,1572},
	{{0x00002005,0x00000040,0x00000000},0x0146,0,1572},
	{{0x00001003,0x00000040,0x00000000},0x0147,0,1572},
	{{0x00001005,0x00000040,0x00000000},0x0148,0,1572},
	{{0x00000005,0x00000040,0x00000020},0x207f,0,1572},
	{{0x00000005,0x00040040,0x00000000},0x24a9,0,1572},
	{{0x00004003,0x00000040,0x00000000},0x24c3,0,1572},
	{{0x00004005,0x00000040,0x00000000},0x24dd,0,1572},
	{{0x0008000b,0x00000040,0x00000000},0x1e44,0,1572},
	{{0x0008000d,0x00000040,0x00000000},0x1e45,0,1572},
	{{0x00080103,0x00000040,0x00000000},0x1e46,0,1572},
	{{0x00080105,0x00000040,0x00000000},0x1e47,0,1572},
	{{0x00000103,0x00000240,0x00000000},0x1e48,0,1572},
	{{0x00000105,0x00000240,0x00000000},0x1e49,0,1572},
	{{0x00008103,0x00000040,0x00000000},0x1e4a,0,1572},
	{{0x00008105,0x00000040,0x00000000},0x1e4b,0,1572},
	{{0x00000000,0x00000000,0x00000000},0x220f,1,4146},
	{{0x00000000,0x00000000,0x00000000},0x2211,1,4163},
	{{0x00000007,0x00000040,0x00000000},0x01cb,1,311},
	{{0x00000000,0x00000000,0x00000000},0x24c3,1,5365},
	{{0x00000000,0x00000000,0x00000000},0x24dd,1,5365},
	{{0x00000005,0x00000040,0x00000000},0x0149,1,125},
	{{0x00000000,0x00000000,0x00000000},0x05df,1,1264},
	{{0x00000000,0x00000000,0x00000000},0x0143,1,116},
	{{0x00000000,0x00000000,0x00000000},0x0144,1,116},
	{{0x00000000,0x00000000,0x00000000},0x039d,1,744},
	{{0x00000000,0x00000000,0x00000000},0x03bd,1,744},
	{{0x00000000,0x00000000,0x00000000},0x05e0,1,1267},
	{{0x00000000,0x00000000,0x00000000},0x0646,1,1267},
	{{0x00000000,0x00000000,0x00000000},0xfee7,1,7375},
	{{0x00000000,0x00000000,0x00000000},0xfee5,1,7367},
	{{0x00000000,0x00000000,0x00000000},0xfee6,1,7371},
	{{0x00000000,0x00000000,0x00000000},0xfee8,1,7379},
	{{0x00000000,0x00000000,0x00000000},0x0145,1,119},
	{{0x00000000,0x00000000,0x00000000},0x0146,1,119},
	{{0x00000000,0x00000000,0x00000000},0x1e46,1,1853},
	{{0x00000000,0x00000000,0x00000000},0x1e47,1,1853},
	{{0x00000000,0x00000000,0x00000000},0x1e4a,1,1860},
	{{0x00000000,0x00000000,0x00000000},0x1e4b,1,1860},
	{{0x00000000,0x00000000,0x00000000},0x1e44,1,1850},
	{{0x00000000,0x00000000,0x00000000},0x1e45,1,1850},
	{{0x00000000,0x00000000,0x00000000},0x2116,1,3418},
	{{0x00000000,0x00000000,0x00000000},0x310b,1,6805},
	{{0x00000000,0x00000000,0x00000000},0x3093,1,6669},
	{{0x00000000,0x00000000,0x00000000},0x30f3,1,6750},
	{{0x00000000,0x00000000,0x00000000},0x0147,1,122},
	{{0x00000000,0x00000000,0x00000000},0x0148,1,122},
	{{0x00000000,0x00000000,0x00000000},0x041d,1,1010},
	{{0x00000000,0x00000000,0x00000000},0x043d,1,1010},
	{{0x00000000,0x00000000,0x00000000},0x1e48,1,1857},
	{{0x00000000,0x00000000,0x00000000},0x1e49,1,1857},
	{{0x40000001,0x00000000,0x00000000},0x306a,1,6612},
	{{0x00000001,0x00000020,0x00000000},0x30ca,1,6612},
	{{0x00000000,0x00000000,0x00000000},0x2207,1,4098},
	{{0x00000000,0x00000000,0x00000000},0x2207,0,1314},
	{{0x40000001,0x00000000,0x00000000},0x306d,1,6615},
	{{0x00000001,0x00000020,0x00000000},0x30cd,1,6615},
	{{0x00000000,0x00000000,0x00000000},0x014a,1,157},
	{{0x00000000,0x00000000,0x00000000},0x014b,1,157},
	{{0x00000201,0x00000000,0x00000000},0x312b,1,157},
	{{0x00000000,0x00000000,0x00000000},0x2310,1,4682},
	{{0x40000001,0x00000000,0x00000000},0x306b,1,4682},
	{{0x00000001,0x00000020,0x00000000},0x30cb,1,4682},
	{{0x00000000,0x00000000,0x00000020},0x2079,0,1476},
	{{0x00000000,0x00000000,0x00000040},0x2089,0,1476},
	{{0x00004001,0x00000000,0x00000000},0x2468,0,1476},
	{{0x00000001,0x00040000,0x00000000},0x247c,0,1476},
	{{0x00000081,0x00000000,0x00000400},0x0669,0,1476},
	{{0x00000000,0x00804000,0x00000000},0x2168,0,1476},
	{{0x02000001,0x00000000,0x00000002},0x2490,0,1476},
	{{0x00000000,0x00040000,0x00000800},0x3228,0,1476},
	{{0x00000004,0x00804000,0x00000000},0x2178,0,1476},
	{{0x00004000,0x00002000,0x00000000},0x2472,1,5021},
	{{0x00000000,0x00042000,0x00000000},0x2486,1,5021},
	{{0x02000000,0x00002000,0x00000002},0x249a,1,5021},
	{{0x00000000,0x00000000,0x00000000},0x040a,1,304},
	{{0x00000000,0x00000000,0x00000000},0x045a,1,304},
	{{0x00000003,0x00000040,0x00000000},0x01ca,1,304},
	{{0x00000005,0x00000040,0x00000000},0x01cc,1,304},
	{{0x00000000,0x00000000,0x00000000},0x01ca,1,307},
	{{0x00000000,0x00000000,0x00000000},0x01cb,1,307},
	{{0x00000000,0x00000000,0x00000000},0x01cc,1,307},
	{{0x00010003,0x00000000,0x00000000},0x040a,1,918},
	{{0x00010005,0x00000000,0x00000000},0x045a,1,918},
	{{0x40000001,0x00000000,0x00000000},0x306e,0,2642},
	{{0x00000001,0x00000020,0x00000000},0x30ce,0,2642},
	{{0x00000081,0x00000000,0x00000000},0x0646,1,1538},
	{{0x00000081,0x00000010,0x00000000},0xfee5,1,1538},
	{{0x01000081,0x00000000,0x00000000},0xfee6,1,1538},
	{{0x00000081,0x00000004,0x00000000},0xfee7,1,1538},
	{{0x00000081,0x00001000,0x00000000},0xfee8,1,1538},
	{{0x00000000,0x00000000,0x00002000},0x2197,1,3929},
	{{0x00000000,0x00000000,0x00002000},0x2196,1,3914},
	{{0x00000000,0x04000000,0x00001000},0x2260,0,2638},
	{{0x00000000,0x00000000,0x00004000},0x226f,1,4571},
	{{0x00000000,0x00000000,0x00004000},0x226e,1,4559},
	{{0x00000000,0x00000000,0x00000000},0x207f,0,2485},
	{{0x40000001,0x00000000,0x00000000},0x306c,0,707},
	{{0x00000001,0x00000020,0x00000000},0x30cc,0,707},
	{{0x08000003,0x00000000,0x00000000},0x039d,0,707},
	{{0x08000005,0x00000000,0x00000000},0x03bd,0,707},
	{{0x00000001,0x00000000,0x00000000},0x2116,1,3411},
	{{0x20000001,0x00000000,0x00000000},0x05e0,1,1260},
	{{0x21000001,0x00000000,0x00000000},0x05df,1,1260},
	{{0x40000001,0x00000000,0x00000000},0x304a,0,1574},
	{{0x00000001,0x00000020,0x00000000},0x30aa,0,1574},
	{{0x00000201,0x00000000,0x00000000},0x311b,0,1574},
	{{0x00010003,0x00000000,0x00000000},0x041e,0,1574},
	{{0x00010005,0x00000000,0x00000000},0x043e,0,1574},
	{{0x40000005,0x00000000,0x00000000},0x3049,0,1574},
	{{0x00000005,0x00000020,0x00000000},0x30a9,0,1574},
	{{0x00000003,0x00000440,0x00000000},0x014c,0,1574},
	{{0x00000005,0x00000440,0x00000000},0x014d,0,1574},
	{{0x00000803,0x00000040,0x00000000},0x014e,0,1574},
	{{0x00000805,0x00000040,0x00000000},0x014f,0,1574},
	{{0x00000003,0x00000042,0x00000000},0x01a0,0,1574},
	{{0x00000005,0x00000042,0x00000000},0x01a1,0,1574},
	{{0x00001003,0x00000040,0x00000000},0x01d1,0,1574},
	{{0x00001005,0x00000040,0x00000000},0x01d2,0,1574},
	{{0x00000003,0x00000040,0x02000000},0x01ea,0,1574},
	{{0x00000005,0x00000040,0x02000000},0x01eb,0,1574},
	{{0x00000005,0x00040040,0x00000000},0x24aa,0,1574},
	{{0x00004003,0x00000040,0x00000000},0x24c4,0,1574},
	{{0x00004005,0x00000040,0x00000000},0x24de,0,1574},
	{{0x00100013,0x00000040,0x00000000},0x0150,0,1574},
	{{0x00100015,0x00000040,0x00000000},0x0151,0,1574},
	{{0x00000003,0x00000440,0x02000000},0x01ec,0,1574},
	{{0x00000005,0x00000440,0x02000000},0x01ed,0,1574},
	{{0x00000013,0x00000040,0x10000000},0x01fe,0,1574},
	{{0x00000015,0x00000040,0x10000000},0x01ff,0,1574},
	{{0x04100003,0x00000040,0x00000000},0x020c,0,1574},
	{{0x04100005,0x00000040,0x00000000},0x020d,0,1574},
	{{0x00000803,0x00000040,0x00800000},0x020e,0,1574},
	{{0x00000805,0x00000040,0x00800000},0x020f,0,1574},
	{{0x00000013,0x02000040,0x00000000},0x1e4c,0,1574},
	{{0x00000015,0x02000040,0x00000000},0x1e4d,0,1574},
	{{0x00040003,0x02000040,0x00000000},0x1e4e,0,1574},
	{{0x00040005,0x02000040,0x00000000},0x1e4f,0,1574},
	{{0x04000003,0x00000440,0x00000000},0x1e50,0,1574},
	{{0x04000005,0x00000440,0x00000000},0x1e51,0,1574},
	{{0x00000013,0x00000440,0x00000000},0x1e52,0,1574},
	{{0x00000015,0x00000440,0x00000000},0x1e53,0,1574},
	{{0x00080103,0x00000040,0x00000000},0x1ecc,0,1574},
	{{0x00080105,0x00000040,0x00000000},0x1ecd,0,1574},
	{{0x8000000b,0x00000040,0x00000000},0x1ece,0,1574},
	{{0x8000000d,0x00000040,0x00000000},0x1ecf,0,1574},
	{{0x00008013,0x00000040,0x00000000},0x1ed0,0,1574},
	{{0x00008015,0x00000040,0x00000000},0x1ed1,0,1574},
	{{0x04008003,0x00000040,0x00000000},0x1ed2,0,1574},
	{{0x04008005,0x00000040,0x00000000},0x1ed3,0,1574},
	{{0x00008003,0x02000040,0x00000000},0x1ed6,0,1574},
	{{0x00008005,0x02000040,0x00000000},0x1ed7,0,1574},
	{{0x00000013,0x00000042,0x00000000},0x1eda,0,1574},
	{{0x00000015,0x00000042,0x00000000},0x1edb,0,1574},
	{{0x04000003,0x00000042,0x00000000},0x1edc,0,1574},
	{{0x04000005,0x00000042,0x00000000},0x1edd,0,1574},
	{{0x00000003,0x02000042,0x00000000},0x1ee0,0,1574},
	{{0x00000005,0x02000042,0x00000000},0x1ee1,0,1574},
	{{0x8000800b,0x00000040,0x00000000},0x1ed4,0,1574},
	{{0x8000800d,0x00000040,0x00000000},0x1ed5,0,1574},
	{{0x00088103,0x00000040,0x00000000},0x1ed8,0,1574},
	{{0x00088105,0x00000040,0x00000000},0x1ed9,0,1574},
	{{0x8000000b,0x00000042,0x00000000},0x1ede,0,1574},
	{{0x8000000d,0x00000042,0x00000000},0x1edf,0,1574},
	{{0x00080103,0x00000042,0x00000000},0x1ee2,0,1574},
	{{0x00080105,0x00000042,0x00000000},0x1ee3,0,1574},
	{{0x00000000,0x00000000,0x00000000},0x24c4,1,5369},
	{{0x00000000,0x00000000,0x00000000},0x24de,1,5369},
	{{0x00000000,0x00000000,0x00000000},0x020c,1,425},
	{{0x00000000,0x00000000,0x00000000},0x020d,1,425},
	{{0x00000000,0x00000000,0x00000000},0x0150,1,166},
	{{0x00000000,0x00000000,0x00000000},0x0151,1,166},
	{{0x00000000,0x00000000,0x00000000},0x038c,1,653},
	{{0x00000000,0x00000000,0x00000000},0x03cc,1,653},
	{{0x00000000,0x00000000,0x00000000},0x014e,1,163},
	{{0x00000000,0x00000000,0x00000000},0x014f,1,163},
	{{0x00000000,0x00000000,0x00000000},0x020e,1,429},
	{{0x00000000,0x00000000,0x00000000},0x020f,1,429},
	{{0x00000000,0x00000000,0x00000000},0x039f,1,753},
	{{0x00000000,0x00000000,0x00000000},0x03bf,1,753},
	{{0x00000000,0x00000000,0x00000000},0x1f78,1,2453},
	{{0x00000000,0x00000000,0x00000000},0x1ff8,1,2453},
	{{0x00000000,0x00000000,0x00000000},0x1f79,1,2457},
	{{0x00000000,0x00000000,0x00000000},0x1ff9,1,2457},
	{{0x00000000,0x00000000,0x00000000},0x1f40,1,2317},
	{{0x00000000,0x00000000,0x00000000},0x1f48,1,2317},
	{{0x00000000,0x00000000,0x00000000},0x1f42,1,2325},
	{{0x00000000,0x00000000,0x00000000},0x1f4a,1,2325},
	{{0x00000000,0x00000000,0x00000000},0x1f44,1,2335},
	{{0x00000000,0x00000000,0x00000000},0x1f4c,1,2335},
	{{0x00000000,0x00000000,0x00000000},0x1f41,1,2321},
	{{0x00000000,0x00000000,0x00000000},0x1f49,1,2321},
	{{0x00000000,0x00000000,0x00000000},0x1f43,1,2330},
	{{0x00000000,0x00000000,0x00000000},0x1f4b,1,2330},
	{{0x00000000,0x00000000,0x00000000},0x1f45,1,2340},
	{{0x00000000,0x00000000,0x00000000},0x1f4d,1,2340},
	{{0x00000000,0x00000000,0x00000000},0x014c,1,160},
	{{0x00000000,0x00000000,0x00000000},0x014d,1,160},
	{{0x00000000,0x00000000,0x00000000},0x1e50,1,1872},
	{{0x00000000,0x00000000,0x00000000},0x1e51,1,1872},
	{{0x00000000,0x00000000,0x00000000},0x1e52,1,1876},
	{{0x00000000,0x00000000,0x00000000},0x1e53,1,1876},
	{{0x00000000,0x00000000,0x00000000},0x1ecc,1,2085},
	{{0x00000000,0x00000000,0x00000000},0x1ecd,1,2085},
	{{0x00000000,0x00000000,0x00000000},0x01fe,1,400},
	{{0x00000000,0x00000000,0x00000000},0x01ff,1,400},
	{{0x00000000,0x00000000,0x00000000},0x01ec,1,376},
	{{0x00000000,0x00000000,0x00000000},0x01ed,1,376},
	{{0x00000000,0x00000000,0x00000000},0x1ece,1,2089},
	{{0x00000000,0x00000000,0x00000000},0x1ecf,1,2089},
	{{0x00000000,0x00000000,0x00000000},0x046a,1,1132},
	{{0x00000000,0x00000000,0x00000000},0x046b,1,1132},
	{{0x00000000,0x00000000,0x00000000},0x311b,1,6844},
	{{0x00000000,0x00000000,0x00000000},0x3049,1,6555},
	{{0x00000000,0x00000000,0x00000000},0x304a,1,6555},
	{{0x00000000,0x00000000,0x00000000},0x30a9,1,6747},
	{{0x00000000,0x00000000,0x00000000},0x30aa,1,6747},
	{{0x00000000,0x00000000,0x00000000},0x01a0,1,260},
	{{0x00000000,0x00000000,0x00000000},0x01a1,1,260},
	{{0x00000000,0x00000000,0x00000000},0x1edc,1,2117},
	{{0x00000000,0x00000000,0x00000000},0x1edd,1,2117},
	{{0x00000000,0x00000000,0x00000000},0x1eda,1,2113},
	{{0x00000000,0x00000000,0x00000000},0x1edb,1,2113},
	{{0x00000000,0x00000000,0x00000000},0x1ee2,1,2129},
	{{0x00000000,0x00000000,0x00000000},0x1ee3,1,2129},
	{{0x00000000,0x00000000,0x00000000},0x1ede,1,2121},
	{{0x00000000,0x00000000,0x00000000},0x1edf,1,2121},
	{{0x00000000,0x00000000,0x00000000},0x1ee0,1,2125},
	{{0x00000000,0x00000000,0x00000000},0x1ee1,1,2125},
	{{0x00000000,0x00000000,0x00000000},0x01ea,1,373},
	{{0x00000000,0x00000000,0x00000000},0x01eb,1,373},
	{{0x00000000,0x00000000,0x00000000},0x01d1,1,321},
	{{0x00000000,0x00000000,0x00000000},0x01d2,1,321},
	{{0x00000000,0x00000000,0x00000000},0x041e,1,1013},
	{{0x00000000,0x00000000,0x00000000},0x043e,1,1013},
	{{0x00000000,0x00000000,0x00000000},0x1ed2,1,2096},
	{{0x00000000,0x00000000,0x00000000},0x1ed3,1,2096},
	{{0x00000000,0x00000000,0x00000000},0x1ed0,1,2092},
	{{0x00000000,0x00000000,0x00000000},0x1ed1,1,2092},
	{{0x00000000,0x00000000,0x00000000},0x1ed8,1,2108},
	{{0x00000000,0x00000000,0x00000000},0x1ed9,1,2108},
	{{0x00000000,0x00000000,0x00000000},0x1ed4,1,2100},
	{{0x00000000,0x00000000,0x00000000},0x1ed5,1,2100},
	{{0x00000000,0x00000000,0x00000000},0x1ed6,1,2104},
	{{0x00000000,0x00000000,0x00000000},0x1ed7,1,2104},
	{{0x00000000,0x00000000,0x00000000},0x1e4c,1,1864},
	{{0x00000000,0x00000000,0x00000000},0x1e4d,1,1864},
	{{0x00000000,0x00000000,0x00000000},0x1e4e,1,1868},
	{{0x00000000,0x00000000,0x00000000},0x1e4f,1,1868},
	{{0x00000000,0x00000000,0x00000000},0x2218,1,4232},
	{{0x00000000,0x00000000,0x00000000},0x2103,0,2415},
	{{0x00000000,0x00000000,0x00000000},0x0152,1,169},
	{{0x00000000,0x00000000,0x00000000},0x0153,1,169},
	{{0x00000002,0x00000040,0x00000100},0x0152,1,169},
	{{0x00000004,0x00000040,0x00000100},0x0153,1,169},
	{{0x00000001,0x00000000,0x00000000},0x2126,1,3488},
	{{0x00000000,0x00000000,0x00000000},0x01a2,1,263},
	{{0x00000000,0x00000000,0x00000000},0x01a3,1,263},
	{{0x00000003,0x00000040,0x00000000},0x01a2,1,263},
	{{0x00000005,0x00000040,0x00000000},0x01a3,1,263},
	{{0x00000000,0x00000000,0x00000000},0x2713,1,6309},
	{{0x00000000,0x00000000,0x00000000},0x2126,1,3492},
	{{0x08000003,0x00000000,0x00000000},0x039f,1,645},
	{{0x08000005,0x00000000,0x00000000},0x03bf,1,645},
	{{0x08000003,0x00000000,0x20000000},0x038c,1,645},
	{{0x08000005,0x00000000,0x20000000},0x03cc,1,645},
	{{0x08000005,0x00200000,0x00000000},0x1f40,1,645},
	{{0x08020005,0x00000000,0x00000000},0x1f41,1,645},
	{{0x08000003,0x00200000,0x00000000},0x1f48,1,645},
	{{0x08020003,0x00000000,0x00000000},0x1f49,1,645},
	{{0x08000005,0x20000000,0x00000000},0x1f78,1,645},
	{{0x08000005,0x00020000,0x00000000},0x1f79,1,645},
	{{0x08000003,0x20000000,0x00000000},0x1ff8,1,645},
	{{0x08000003,0x00020000,0x00000000},0x1ff9,1,645},
	{{0x08000005,0x20200000,0x00000000},0x1f42,1,645},
	{{0x08020005,0x20000000,0x00000000},0x1f43,1,645},
	{{0x08000005,0x00220000,0x00000000},0x1f44,1,645},
	{{0x08020005,0x00020000,0x00000000},0x1f45,1,645},
	{{0x08000003,0x20200000,0x00000000},0x1f4a,1,645},
	{{0x08020003,0x20000000,0x00000000},0x1f4b,1,645},
	{{0x08000003,0x00220000,0x00000000},0x1f4c,1,645},
	{{0x08020003,0x00020000,0x00000000},0x1f4d,1,645},
	{{0x00000400,0x00000000,0x00000000},0x2423,1,4788},
	{{0x00000000,0x00000000,0x04000000},0x2218,1,4223},
	{{0x00000000,0x02000000,0x00000000},0x223c,1,4223},
	{{0x00080000,0x00000000,0x00000000},0x22c5,1,4223},
	{{0x00084000,0x00000000,0x00000000},0x2299,1,4223},
	{{0x00004000,0x00000000,0x04000000},0x229a,1,4223},
	{{0x00000001,0x00000000,0x00000080},0x25a6,1,5784},
	{{0x00000000,0x00000000,0x00000000},0x25a1,1,5737},
	{{0x00000201,0x00000000,0x00000000},0x3121,1,6863},
	{{0x00000000,0x00000000,0x00000000},0x203e,1,3241},
	{{0x00000201,0x00000000,0x00000000},0x3106,0,1576},
	{{0x00000013,0x00000040,0x00000000},0x1e54,0,1576},
	{{0x00000015,0x00000040,0x00000000},0x1e55,0,1576},
	{{0x00000005,0x00040040,0x00000000},0x24ab,0,1576},
	{{0x00004003,0x00000040,0x00000000},0x24c5,0,1576},
	{{0x00004005,0x00000040,0x00000000},0x24df,0,1576},
	{{0x0008000b,0x00000040,0x00000000},0x1e56,0,1576},
	{{0x0008000d,0x00000040,0x00000000},0x1e57,0,1576},
	{{0x00000000,0x00000000,0x00000000},0x24c5,1,5373},
	{{0x00000000,0x00000000,0x00000000},0x24df,1,5373},
	{{0x00000000,0x00000000,0x00000000},0x05e3,1,1288},
	{{0x00000000,0x00000000,0x00000000},0x1e54,1,1880},
	{{0x00000000,0x00000000,0x00000000},0x1e55,1,1880},
	{{0x00000000,0x00000000,0x00000000},0x03a0,1,756},
	{{0x00000000,0x00000000,0x00000000},0x03c0,1,756},
	{{0x00000000,0x00000000,0x00000000},0x05e4,1,1291},
	{{0x00000000,0x00000000,0x00000000},0x067e,1,1291},
	{{0x00000000,0x00000000,0x00000000},0x1e56,1,1883},
	{{0x00000000,0x00000000,0x00000000},0x1e57,1,1883},
	{{0x00000000,0x00000000,0x00000000},0x03e0,1,872},
	{{0x00000000,0x00000000,0x00000000},0x3106,1,6793},
	{{0x00000000,0x00000000,0x00000000},0x041f,1,1019},
	{{0x00000000,0x00000000,0x00000000},0x043f,1,1019},
	{{0x40000001,0x00000000,0x00000000},0x3071,0,1717},
	{{0x00000001,0x00000020,0x00000000},0x30d1,0,1717},
	{{0x00000000,0x00000000,0x00000000},0x2029,1,3095},
	{{0x00000000,0x04000000,0x00000000},0x2225,1,4296},
	{{0x00000000,0x00000080,0x00000020},0x207d,0,1362},
	{{0x00000000,0x00400000,0x00000020},0x207e,0,1362},
	{{0x00000000,0x00000080,0x00000040},0x208d,0,1362},
	{{0x00000000,0x00400000,0x00000040},0x208e,0,1362},
	{{0x00000000,0x00000000,0x00000000},0x2029,1,3115},
	{{0x00000000,0x00000000,0x00000000},0x2202,1,4038},
	{{0x20000001,0x00000000,0x00000000},0x05e4,1,1016},
	{{0x40000001,0x00000000,0x00000000},0x307a,1,1016},
	{{0x00000001,0x00000020,0x00000000},0x30da,1,1016},
	{{0x00010003,0x00000000,0x00000000},0x041f,1,1016},
	{{0x00010005,0x00000000,0x00000000},0x043f,1,1016},
	{{0x21000001,0x00000000,0x00000000},0x05e3,1,1016},
	{{0x00000081,0x00000000,0x00000000},0x067e,1,1684},
	{{0x00000001,0x00000000,0x00000000},0x2030,1,3122},
	{{0x00000081,0x00000000,0x00000000},0x066a,0,1333},
	{{0x00000001,0x00000000,0x00000000},0x20a7,1,3333},
	{{0x08000003,0x00000000,0x00000000},0x03a6,1,785},
	{{0x08000005,0x00000000,0x00000000},0x03c6,1,785},
	{{0x40000001,0x00000000,0x00000000},0x3074,0,2727},
	{{0x00000001,0x00000020,0x00000000},0x30d4,0,2727},
	{{0x08000003,0x00000000,0x00000000},0x03a0,0,2727},
	{{0x08000005,0x00000000,0x00000000},0x03c0,0,2727},
	{{0x00000000,0x00000000,0x00000000},0x25c4,1,5919},
	{{0x00000001,0x00000000,0x00000001},0x2318,1,4714},
	{{0x00000001,0x00000000,0x00000020},0x207a,0,1383},
	{{0x00000001,0x00000000,0x00000040},0x208a,0,1383},
	{{0x00080000,0x00000000,0x00000000},0x2214,0,1383},
	{{0x00000000,0x00000000,0x00000080},0x33d8,0,2438},
	{{0x00000000,0x00000000,0x00000000},0x2117,1,3447},
	{{0x40000001,0x00000000,0x00000000},0x307d,1,3447},
	{{0x00000001,0x00000020,0x00000000},0x30dd,1,3447},
	{{0x00000000,0x00000080,0x00020000},0x2329,1,4767},
	{{0x00000000,0x00400000,0x00020000},0x232a,1,4767},
	{{0x00000000,0x01000880,0x00000000},0x2039,0,2610},
	{{0x00000000,0x01400800,0x00000000},0x203a,0,2610},
	{{0x00000000,0x80000080,0x00000000},0x261c,1,6066},
	{{0x00000000,0x80400000,0x00000000},0x261e,1,6066},
	{{0x00000000,0x00400000,0x00000004},0x25ba,1,5896},
	{{0x00000000,0x00000080,0x00000004},0x25c4,1,5896},
	{{0x00000000,0x08000000,0x00000004},0x25b2,1,5875},
	{{0x00000000,0x88000000,0x00000000},0x25b3,1,5875},
	{{0x00000000,0x80400000,0x00000000},0x25b7,1,5875},
	{{0x00200000,0x00000000,0x00000004},0x25bc,1,5875},
	{{0x00200000,0x80000000,0x00000000},0x25bd,1,5875},
	{{0x00000000,0x80000080,0x00000000},0x25c1,1,5875},
	{{0x00000000,0x00000800,0x00000000},0x3012,1,6468},
	{{0x00000000,0x00000800,0x00000000},0x3020,1,6526},
	{{0x00000000,0x00000000,0x00000000},0x2225,1,4305},
	{{0x00000000,0x00000000,0x00000000},0x25ba,1,5913},
	{{0x00000000,0x00000000,0x00000000},0x211e,1,3450},
	{{0x00000000,0x00000000,0x00000000},0x2032,1,3135},
	{{0x00100000,0x00000000,0x00000000},0x2033,1,3135},
	{{0x40000000,0x00000820,0x00000000},0x30fc,1,6765},
	{{0x00000000,0x00000000,0x00100001},0x220e,1,4137},
	{{0x00000000,0x00000000,0x00000000},0x2237,1,4406},
	{{0x00000000,0x04000000,0x00000000},0x221d,1,4259},
	{{0x08000003,0x00000000,0x00000000},0x03a8,1,799},
	{{0x08000005,0x00000000,0x00000000},0x03c8,1,799},
	{{0x40000001,0x00000000,0x00000000},0x3077,0,2007},
	{{0x00000001,0x00000020,0x00000000},0x30d7,0,2007},
	{{0x00000201,0x00000000,0x00000000},0x3111,0,1578},
	{{0x00000005,0x00040040,0x00000000},0x24ac,0,1578},
	{{0x00004003,0x00000040,0x00000000},0x24c6,0,1578},
	{{0x00004005,0x00000040,0x00000000},0x24e0,0,1578},
	{{0x00000000,0x00000000,0x00000000},0x24c6,1,5377},
	{{0x00000000,0x00000000,0x00000000},0x24e0,1,5377},
	{{0x00000000,0x00000000,0x00000000},0x03a8,1,803},
	{{0x00000000,0x00000000,0x00000000},0x03c8,1,803},
	{{0x00000000,0x00000000,0x00000000},0x05e7,1,1307},
	{{0x00000000,0x00000000,0x00000000},0x0642,1,1307},
	{{0x00000000,0x00000000,0x00000000},0xfed7,1,7311},
	{{0x00000000,0x00000000,0x00000000},0xfed5,1,7303},
	{{0x00000000,0x00000000,0x00000000},0xfed6,1,7307},
	{{0x00000000,0x00000000,0x00000000},0xfed8,1,7315},
	{{0x00000000,0x00000000,0x00000000},0x3111,1,6823},
	{{0x00000081,0x00000000,0x00000000},0x0642,1,1525},
	{{0x00000081,0x00000010,0x00000000},0xfed5,1,1525},
	{{0x01000081,0x00000000,0x00000000},0xfed6,1,1525},
	{{0x00000081,0x00000004,0x00000000},0xfed7,1,1525},
	{{0x00000081,0x00001000,0x00000000},0xfed8,1,1525},
	{{0x20000001,0x00000000,0x00000000},0x05e7,1,1303},
	{{0x00400400,0x00000101,0x00000000},0x2508,1,5465},
	{{0x10400400,0x00000001,0x00000000},0x2509,1,5465},
	{{0x00400400,0x40000100,0x00000000},0x250a,1,5465},
	{{0x10400400,0x40000000,0x00000000},0x250b,1,5465},
	{{0x00000000,0x00000000,0x00000000},0x2669,1,6175},
	{{0x08000000,0x00000800,0x00000000},0x037e,0,1517},
	{{0x00000080,0x00000800,0x00000000},0x061f,0,1517},
	{{0x00000000,0x01000880,0x00000000},0x2018,0,1304},
	{{0x00000000,0x01400800,0x00000000},0x2019,0,1304},
	{{0x00100000,0x00000880,0x00000000},0x201c,0,1304},
	{{0x00100000,0x00400800,0x00000000},0x201d,0,1304},
	{{0x00000201,0x00000000,0x00000000},0x3116,0,1580},
	{{0x00000013,0x00000040,0x00000000},0x0154,0,1580},
	{{0x00000015,0x00000040,0x00000000},0x0155,0,1580},
	{{0x00002003,0x00000040,0x00000000},0x0156,0,1580},
	{{0x00002005,0x00000040,0x00000000},0x0157,0,1580},
	{{0x00001003,0x00000040,0x00000000},0x0158,0,1580},
	{{0x00001005,0x00000040,0x00000000},0x0159,0,1580},
	{{0x00000005,0x00040040,0x00000000},0x24ad,0,1580},
	{{0x00004003,0x00000040,0x00000000},0x24c7,0,1580},
	{{0x00004005,0x00000040,0x00000000},0x24e1,0,1580},
	{{0x04100003,0x00000040,0x00000000},0x0210,0,1580},
	{{0x04100005,0x00000040,0x00000000},0x0211,0,1580},
	{{0x00000803,0x00000040,0x00800000},0x0212,0,1580},
	{{0x00000805,0x00000040,0x00800000},0x0213,0,1580},
	{{0x0008000b,0x00000040,0x00000000},0x1e58,0,1580},
	{{0x0008000d,0x00000040,0x00000000},0x1e59,0,1580},
	{{0x00080103,0x00000040,0x00000000},0x1e5a,0,1580},
	{{0x00080105,0x00000040,0x00000000},0x1e5b,0,1580},
	{{0x00000103,0x00000240,0x00000000},0x1e5e,0,1580},
	{{0x00000105,0x00000240,0x00000000},0x1e5f,0,1580},
	{{0x00080103,0x00000440,0x00000000},0x1e5c,0,1580},
	{{0x00080105,0x00000440,0x00000000},0x1e5d,0,1580},
	{{0x00000005,0x00000040,0x00000000},0x027c,1,446},
	{{0x00000000,0x00000000,0x00000000},0x24c7,1,5381},
	{{0x00000000,0x00000000,0x00000000},0x24e1,1,5381},
	{{0x00000000,0x00000000,0x00000000},0x0210,1,432},
	{{0x00000000,0x00000000,0x00000000},0x0211,1,432},
	{{0x00000000,0x00000000,0x00000000},0x0154,1,172},
	{{0x00000000,0x00000000,0x00000000},0x0155,1,172},
	{{0x00000000,0x00000000,0x00000000},0x0212,1,436},
	{{0x00000000,0x00000000,0x00000000},0x0213,1,436},
	{{0x00000000,0x00000000,0x00000000},0x03a1,1,763},
	{{0x00000000,0x00000000,0x00000000},0x03c1,1,763},
	{{0x00000000,0x00000000,0x00000000},0x1fe4,1,2764},
	{{0x00000000,0x00000000,0x00000000},0x1fe5,1,2768},
	{{0x00000000,0x00000000,0x00000000},0x1fec,1,2768},
	{{0x00000000,0x00000000,0x00000000},0x05e8,1,1315},
	{{0x00000000,0x00000000,0x00000000},0x0631,1,1315},
	{{0x00000000,0x00000000,0x00000000},0xfead,1,7143},
	{{0x00000000,0x00000000,0x00000000},0xfeae,1,7147},
	{{0x00000000,0x00000000,0x00000000},0x0156,1,175},
	{{0x00000000,0x00000000,0x00000000},0x0157,1,175},
	{{0x00000000,0x00000000,0x00000000},0x1e5c,1,1893},
	{{0x00000000,0x00000000,0x00000000},0x1e5d,1,1893},
	{{0x00000000,0x00000000,0x00000000},0x1e5a,1,1889},
	{{0x00000000,0x00000000,0x00000000},0x1e5b,1,1889},
	{{0x00000000,0x00000000,0x00000000},0x1e58,1,1886},
	{{0x00000000,0x00000000,0x00000000},0x1e59,1,1886},
	{{0x00000000,0x00000000,0x00000000},0x027c,1,457},
	{{0x00000000,0x00000000,0x00000000},0x3116,1,6829},
	{{0x00000000,0x00000000,0x00000000},0x0158,1,178},
	{{0x00000000,0x00000000,0x00000000},0x0159,1,178},
	{{0x00000000,0x00000000,0x00000000},0x0420,1,1025},
	{{0x00000000,0x00000000,0x00000000},0x0440,1,1025},
	{{0x00000000,0x00000000,0x00000000},0x1e5e,1,1898},
	{{0x00000000,0x00000000,0x00000000},0x1e5f,1,1898},
	{{0x40000001,0x00000000,0x00000000},0x3089,1,6648},
	{{0x00000001,0x00000020,0x00000000},0x30e9,1,6648},
	{{0x00000000,0x00000000,0x00000000},0x2236,1,4397},
	{{0x00000000,0x00000000,0x00000000},0x2590,1,5695},
	{{0x40000001,0x00000000,0x00000000},0x308c,1,6654},
	{{0x00000001,0x00000020,0x00000000},0x30ec,1,6654},
	{{0x00000000,0x00000000,0x00000004},0x25ac,1,5862},
	{{0x00000000,0x80000000,0x00000000},0x25ad,1,5862},
	{{0x00000000,0x00000800,0x00000000},0x203b,1,3224},
	{{0x00000081,0x00000000,0x00000000},0x0631,1,1446},
	{{0x00000081,0x00000010,0x00000000},0xfead,1,1446},
	{{0x01000081,0x00000000,0x00000000},0xfeae,1,1446},
	{{0x20000001,0x00000000,0x00000000},0x05e8,1,1310},
	{{0x00000001,0x00000000,0x00000000},0x2310,1,4669},
	{{0x00000000,0x00000000,0x00000000},0x2035,1,3163},
	{{0x00100000,0x00000000,0x00000000},0x2036,1,3163},
	{{0x00000000,0x00000000,0x00000000},0x2037,1,3184},
	{{0x00000000,0x00000000,0x00000000},0x25a4,1,5778},
	{{0x00000000,0x00000000,0x00000000},0x25a6,1,5811},
	{{0x08000003,0x00000000,0x00000000},0x03a1,1,759},
	{{0x08000005,0x00000000,0x00000000},0x03c1,1,759},
	{{0x08000005,0x00200000,0x00000000},0x1fe4,1,759},
	{{0x08020005,0x00000000,0x00000000},0x1fe5,1,759},
	{{0x08020003,0x00000000,0x00000000},0x1fec,1,759},
	{{0x40000001,0x00000000,0x00000000},0x308a,0,2027},
	{{0x00000001,0x00000020,0x00000000},0x30ea,0,2027},
	{{0x00000000,0x00000000,0x00002000},0x2192,1,3881},
	{{0x00100000,0x00000000,0x00002000},0x21d2,1,3881},
	{{0x00000001,0x00000000,0x00000000},0x21c0,1,3983},
	{{0x00000000,0x00000000,0x00000000},0x25a8,1,5834},
	{{0x00000000,0x00000000,0x00000000},0x200f,1,2889},
	{{0x00000000,0x00000000,0x00000000},0x25a2,1,5756},
	{{0x40000001,0x00000000,0x00000000},0x308d,1,5756},
	{{0x00000001,0x00000020,0x00000000},0x30ed,1,5756},
	{{0x00000000,0x00000000,0x00000080},0x221a,1,4251},
	{{0x00000001,0x80000000,0x00000080},0x25a2,1,5740},
	{{0x00000000,0x00000000,0x00000000},0x25a3,1,5770},
	{{0x00000000,0x00000000,0x00000000},0x221a,1,4256},
	{{0x40000001,0x00000000,0x00000000},0x308b,1,6651},
	{{0x00000001,0x00000020,0x00000000},0x30eb,1,6651},
	{{0x00000000,0x00000000,0x00000000},0x211e,1,3468},
	{{0x00000000,0x00000000,0x00000000},0x25a9,1,3468},
	{{0x00000000,0x00000000,0x00000000},0x25a5,1,5781},
	{{0x00000000,0x00000000,0x00000000},0x25a7,1,5831},
	{{0x00000201,0x00000000,0x00000000},0x3119,0,1582},
	{{0x00000013,0x00000040,0x00000000},0x015a,0,1582},
	{{0x00000015,0x00000040,0x00000000},0x015b,0,1582},
	{{0x00008003,0x00000040,0x00000000},0x015c,0,1582},
	{{0x00008005,0x00000040,0x00000000},0x015d,0,1582},
	{{0x00002003,0x00000040,0x00000000},0x015e,0,1582},
	{{0x00002005,0x00000040,0x00000000},0x015f,0,1582},
	{{0x00001003,0x00000040,0x00000000},0x0160,0,1582},
	{{0x00001005,0x00000040,0x00000000},0x0161,0,1582},
	{{0x00000005,0x00040040,0x00000000},0x24ae,0,1582},
	{{0x00004003,0x00000040,0x00000000},0x24c8,0,1582},
	{{0x00004005,0x00000040,0x00000000},0x24e2,0,1582},
	{{0x0008000b,0x00000040,0x00000000},0x1e60,0,1582},
	{{0x0008000d,0x00000040,0x00000000},0x1e61,0,1582},
	{{0x00080103,0x00000040,0x00000000},0x1e62,0,1582},
	{{0x00080105,0x00000040,0x00000000},0x1e63,0,1582},
	{{0x0008001b,0x00000040,0x00000000},0x1e64,0,1582},
	{{0x0008001d,0x00000040,0x00000000},0x1e65,0,1582},
	{{0x0008100b,0x00000040,0x00000000},0x1e66,0,1582},
	{{0x0008100d,0x00000040,0x00000000},0x1e67,0,1582},
	{{0x0008010b,0x00000040,0x00000000},0x1e68,0,1582},
	{{0x0008010d,0x00000040,0x00000000},0x1e69,0,1582},
	{{0x00000000,0x00000000,0x00000000},0x24c8,1,5385},
	{{0x00000000,0x00000000,0x00000000},0x24e2,1,5385},
	{{0x00000000,0x00000000,0x00000000},0x0428,1,1070},
	{{0x00000000,0x00000000,0x00000000},0x0448,1,1070},
	{{0x00000000,0x00000000,0x00000000},0x015a,1,181},
	{{0x00000000,0x00000000,0x00000000},0x015b,1,181},
	{{0x00000000,0x00000000,0x00000000},0x1e64,1,1908},
	{{0x00000000,0x00000000,0x00000000},0x1e65,1,1908},
	{{0x00000000,0x00000000,0x00000000},0x03a3,1,772},
	{{0x00000000,0x00000000,0x00000000},0x03c3,1,772},
	{{0x00000000,0x00000000,0x00000000},0x05e1,1,1277},
	{{0x00000000,0x00000000,0x00000000},0x0633,1,1277},
	{{0x00000000,0x00000000,0x00000000},0xfeb3,1,7167},
	{{0x00000000,0x00000000,0x00000000},0xfeb1,1,7159},
	{{0x00000000,0x00000000,0x00000000},0xfeb2,1,7163},
	{{0x00000000,0x00000000,0x00000000},0xfeb4,1,7171},
	{{0x00000000,0x00000000,0x00000000},0x015e,1,187},
	{{0x00000000,0x00000000,0x00000000},0x015f,1,187},
	{{0x00000000,0x00000000,0x00000000},0x1e62,1,1904},
	{{0x00000000,0x00000000,0x00000000},0x1e63,1,1904},
	{{0x00000000,0x00000000,0x00000000},0x1e60,1,1901},
	{{0x00000000,0x00000000,0x00000000},0x1e61,1,1901},
	{{0x00000000,0x00000000,0x00000000},0x1e68,1,1916},
	{{0x00000000,0x00000000,0x00000000},0x1e69,1,1916},
	{{0x00000000,0x00000000,0x00000000},0x017f,1,242},
	{{0x00000000,0x00000000,0x00000000},0x3119,1,6838},
	{{0x00000000,0x00000000,0x00000000},0x0160,1,190},
	{{0x00000000,0x00000000,0x00000000},0x0161,1,190},
	{{0x00000000,0x00000000,0x00000000},0x1e66,1,1912},
	{{0x00000000,0x00000000,0x00000000},0x1e67,1,1912},
	{{0x00000000,0x00000000,0x00000000},0x0421,1,1028},
	{{0x00000000,0x00000000,0x00000000},0x0441,1,1028},
	{{0x00000000,0x00000000,0x00000000},0x015c,1,184},
	{{0x00000000,0x00000000,0x00000000},0x015d,1,184},
	{{0x40000001,0x00000000,0x00000000},0x3055,0,1843},
	{{0x00000001,0x00000020,0x00000000},0x30b5,0,1843},
	{{0x00000081,0x00000000,0x00000000},0x0635,1,1469},
	{{0x00000081,0x00000010,0x00000000},0xfeb9,1,1469},
	{{0x01000081,0x00000000,0x00000000},0xfeba,1,1469},
	{{0x00000081,0x00000004,0x00000000},0xfebb,1,1469},
	{{0x00000081,0x00001000,0x00000000},0xfebc,1,1469},
	{{0x20000001,0x00000000,0x00000000},0x05e1,1,1270},
	{{0x08000001,0x00000000,0x00000000},0x03e0,1,866},
	{{0x00000000,0x00000000,0x00000000},0x2022,0,1170},
	{{0x00000000,0x00000000,0x00000000},0x2219,0,1170},
	{{0x00000000,0x00000000,0x00000000},0x25aa,0,1170},
	{{0x00000000,0x00000000,0x00000000},0x0429,0,2327},
	{{0x00000000,0x00000000,0x00000000},0x0449,0,2327},
	{{0x40000001,0x00000000,0x00000000},0x305b,0,2561},
	{{0x00000001,0x00000020,0x00000000},0x30bb,0,2561},
	{{0x00000081,0x00000000,0x00000000},0x0633,1,1455},
	{{0x00000081,0x00000010,0x00000000},0xfeb1,1,1455},
	{{0x01000081,0x00000000,0x00000000},0xfeb2,1,1455},
	{{0x00000081,0x00000004,0x00000000},0xfeb3,1,1455},
	{{0x00000081,0x00001000,0x00000000},0xfeb4,1,1455},
	{{0x40000000,0x00000820,0x00000000},0x309c,1,6691},
	{{0x00000080,0x00000000,0x00000000},0x061b,0,1487},
	{{0x00000000,0x00000200,0x00000000},0x2028,1,3077},
	{{0x00000000,0x00000800,0x00000000},0x2120,1,3471},
	{{0x00000000,0x00000000,0x00000020},0x2077,0,1464},
	{{0x00000000,0x00000000,0x00000040},0x2087,0,1464},
	{{0x00004001,0x00000000,0x00000000},0x2466,0,1464},
	{{0x00000001,0x00040000,0x00000000},0x247a,0,1464},
	{{0x00000081,0x00000000,0x00000400},0x0667,0,1464},
	{{0x00000000,0x00804000,0x00000000},0x2166,0,1464},
	{{0x02000001,0x00000000,0x00000002},0x248e,0,1464},
	{{0x00000000,0x00040000,0x00000800},0x3226,0,1464},
	{{0x00000004,0x00804000,0x00000000},0x2176,0,1464},
	{{0x00000000,0x00000000,0x00000018},0x215e,1,3672},
	{{0x00004000,0x00002000,0x00000000},0x2470,1,4992},
	{{0x00000000,0x00042000,0x00000000},0x2484,1,4992},
	{{0x02000000,0x00002000,0x00000002},0x2498,1,4992},
	{{0x00000000,0x00000000,0x00000000},0x05e9,0,728},
	{{0x00000201,0x00000000,0x00000000},0x3115,0,728},
	{{0x00010003,0x00000000,0x00000000},0x0428,1,1066},
	{{0x00010005,0x00000000,0x00000000},0x0448,1,1066},
	{{0x00000080,0x00000000,0x00000000},0x0651,1,1629},
	{{0x00000081,0x00001000,0x00000000},0xfe7d,1,1629},
	{{0x00000000,0x00000100,0x00000000},0x2591,1,5698},
	{{0x00010003,0x00000000,0x00000000},0x0429,1,1073},
	{{0x00010005,0x00000000,0x00000000},0x0449,1,1073},
	{{0x00000081,0x00000000,0x00000000},0x0634,1,1460},
	{{0x00000081,0x00000010,0x00000000},0xfeb5,1,1460},
	{{0x01000081,0x00000000,0x00000000},0xfeb6,1,1460},
	{{0x00000081,0x00000004,0x00000000},0xfeb7,1,1460},
	{{0x00000081,0x00001000,0x00000000},0xfeb8,1,1460},
	{{0x20000001,0x00000000,0x00000000},0x05e9,1,1318},
	{{0x40000001,0x00000000,0x00000000},0x3057,0,927},
	{{0x00000001,0x00000020,0x00000000},0x30b7,0,927},
	{{0x08000003,0x00000000,0x00000000},0x03a3,1,766},
	{{0x08000005,0x00000000,0x00000000},0x03c3,1,766},
	{{0x09000005,0x00000000,0x00000000},0x03c2,1,766},
	{{0x00000000,0x00000000,0x00000020},0x2076,0,1460},
	{{0x00000000,0x00000000,0x00000040},0x2086,0,1460},
	{{0x00004001,0x00000000,0x00000000},0x2465,0,1460},
	{{0x00000001,0x00040000,0x00000000},0x2479,0,1460},
	{{0x00000081,0x00000000,0x00000400},0x0666,0,1460},
	{{0x00000000,0x00804000,0x00000000},0x2165,0,1460},
	{{0x02000001,0x00000000,0x00000002},0x248d,0,1460},
	{{0x00000000,0x00040000,0x00000800},0x3225,0,1460},
	{{0x00000004,0x00804000,0x00000000},0x2175,0,1460},
	{{0x00000000,0x00000000,0x00000200},0x2006,1,2856},
	{{0x00004000,0x00002000,0x00000000},0x246f,1,4979},
	{{0x00000000,0x00042000,0x00000000},0x2483,1,4979},
	{{0x02000000,0x00002000,0x00000002},0x2497,1,4979},
	{{0x00000000,0x00010000,0x00000018},0x2159,1,3605},
	{{0x00000000,0x00000000,0x00000008},0x2044,0,1429},
	{{0x00000000,0x00000000,0x00000000},0x2120,1,3479},
	{{0x00000000,0x80000000,0x00000000},0x263a,1,6087},
	{{0x00000000,0x00000000,0x00000004},0x263b,1,6087},
	{{0x00000000,0x00000000,0x00000000},0x0634,1,1466},
	{{0x00000000,0x00000000,0x00000000},0x25d8,1,1466},
	{{0x00000000,0x00000000,0x00000000},0xfeb7,1,7183},
	{{0x00000000,0x00000000,0x00000000},0xfeb5,1,7175},
	{{0x00000000,0x00000000,0x00000000},0xfeb6,1,7179},
	{{0x00000000,0x00000000,0x00000000},0xfeb8,1,7187},
	{{0x40000001,0x00000000,0x00000000},0x305d,0,915},
	{{0x00000001,0x00000020,0x00000000},0x30bd,0,915},
	{{0x00010003,0x00000000,0x00000000},0x042c,1,1095},
	{{0x00010005,0x00000000,0x00000000},0x044c,1,1095},
	{{0x00000000,0x00000000,0x00000000},0x2117,1,3421},
	{{0x00000000,0x00000000,0x00002000},0x2198,1,3944},
	{{0x00000000,0x00000000,0x00002000},0x2199,1,3959},
	{{0x00000000,0x00000000,0x00008004},0x2660,1,6133},
	{{0x00000000,0x80000000,0x00008000},0x2664,1,6133},
	{{0x00000000,0x00000000,0x00000000},0x25ac,1,5872},
	{{0x00000000,0x00000000,0x00000000},0xfb05,0,2387},
	{{0x00000000,0x00000000,0x00000000},0xfb06,0,2387},
	{{0x00000004,0x00000040,0x00000100},0xfb06,0,2387},
	{{0x00000000,0x00000000,0x00000004},0x2605,1,6041},
	{{0x00000000,0x80000000,0x00000000},0x2606,1,6041},
	{{0x08000001,0x00000000,0x00000000},0x03da,1,836},
	{{0x00000000,0x00000000,0x00000000},0x263c,1,6112},
	{{0x40000001,0x00000000,0x00000000},0x3059,1,6112},
	{{0x00000001,0x00000020,0x00000000},0x30b9,1,6112},
	{{0x00000000,0x00000000,0x00000001},0x2282,1,4586},
	{{0x00000000,0x04000000,0x00011001},0x2286,1,4586},
	{{0x00000080,0x00000000,0x00000000},0x0652,1,1639},
	{{0x00000001,0x80000000,0x00000000},0x263c,1,6103},
	{{0x00000000,0x00000000,0x00000001},0x2283,1,4596},
	{{0x00000000,0x04000000,0x00011001},0x2287,1,4596},
	{{0x00000201,0x00000000,0x00000000},0x310a,0,1584},
	{{0x00002003,0x00000040,0x00000000},0x0162,0,1584},
	{{0x00002005,0x00000040,0x00000000},0x0163,0,1584},
	{{0x00001003,0x00000040,0x00000000},0x0164,0,1584},
	{{0x00001005,0x00000040,0x00000000},0x0165,0,1584},
	{{0x00000003,0x00000040,0x10000000},0x0166,0,1584},
	{{0x00000005,0x00000040,0x10000000},0x0167,0,1584},
	{{0x00000005,0x00040040,0x00000000},0x24af,0,1584},
	{{0x00004003,0x00000040,0x00000000},0x24c9,0,1584},
	{{0x00004005,0x00000040,0x00000000},0x24e3,0,1584},
	{{0x0008000b,0x00000040,0x00000000},0x1e6a,0,1584},
	{{0x0008000d,0x00000040,0x00000000},0x1e6b,0,1584},
	{{0x00080103,0x00000040,0x00000000},0x1e6c,0,1584},
	{{0x00080105,0x00000040,0x00000000},0x1e6d,0,1584},
	{{0x00000103,0x00000240,0x00000000},0x1e6e,0,1584},
	{{0x00000105,0x00000240,0x00000000},0x1e6f,0,1584},
	{{0x00008103,0x00000040,0x00000000},0x1e70,0,1584},
	{{0x00008105,0x00000040,0x00000000},0x1e71,0,1584},
	{{0x00000000,0x00000000,0x00000000},0x24c9,1,5389},
	{{0x00000000,0x00000000,0x00000000},0x24e3,1,5389},
	{{0x00000000,0x00000000,0x00000000},0x03a4,1,779},
	{{0x00000000,0x00000000,0x00000000},0x03c4,1,779},
	{{0x00000000,0x00000000,0x00000000},0x05ea,1,1327},
	{{0x00000000,0x00000000,0x00000000},0x062a,1,1327},
	{{0x00000000,0x00000000,0x00000000},0xfe97,1,7055},
	{{0x00000000,0x00000000,0x00000000},0xfe95,1,7047},
	{{0x00000000,0x00000000,0x00000000},0xfe96,1,7051},
	{{0x00000000,0x00000000,0x00000000},0xfe98,1,7059},
	{{0x00000000,0x00000000,0x00000000},0x0162,1,193},
	{{0x00000000,0x00000000,0x00000000},0x0163,1,193},
	{{0x00000000,0x00000000,0x00000000},0x1e6c,1,1924},
	{{0x00000000,0x00000000,0x00000000},0x1e6d,1,1924},
	{{0x00000000,0x00000000,0x00000000},0x1e70,1,1931},
	{{0x00000000,0x00000000,0x00000000},0x1e71,1,1931},
	{{0x00000000,0x00000000,0x00000000},0x1e6a,1,1921},
	{{0x00000000,0x00000000,0x00000000},0x1e6b,1,1921},
	{{0x00000000,0x00000000,0x00000000},0x0166,1,199},
	{{0x00000000,0x00000000,0x00000000},0x0167,1,199},
	{{0x00000000,0x00000000,0x00000000},0x03da,1,843},
	{{0x00000000,0x00000000,0x00000000},0x310a,1,6802},
	{{0x00000000,0x00000000,0x00000000},0x0164,1,196},
	{{0x00000000,0x00000000,0x00000000},0x0165,1,196},
	{{0x00000000,0x00000000,0x00000000},0x0422,1,1034},
	{{0x00000000,0x00000000,0x00000000},0x0442,1,1034},
	{{0x00000000,0x00000000,0x00000000},0x1e6e,1,1928},
	{{0x00000000,0x00000000,0x00000000},0x1e6f,1,1928},
	{{0x40000001,0x00000000,0x00000000},0x305f,1,6597},
	{{0x00000001,0x00000020,0x00000000},0x30bf,1,6597},
	{{0x00000000,0x08000000,0x00000000},0x22a5,1,4620},
	{{0x00000081,0x00000000,0x00000000},0x0637,1,1483},
	{{0x00000081,0x00000010,0x00000000},0xfec1,1,1483},
	{{0x01000081,0x00000000,0x00000000},0xfec2,1,1483},
	{{0x00000081,0x00000004,0x00000000},0xfec3,1,1483},
	{{0x00000081,0x00001000,0x00000000},0xfec4,1,1483},
	{{0x00000080,0x00000000,0x00000000},0x0640,1,1507},
	{{0x08000003,0x00000000,0x00000000},0x03a4,1,775},
	{{0x08000005,0x00000000,0x00000000},0x03c4,1,775},
	{{0x20000001,0x00000000,0x00000000},0x05ea,1,1323},
	{{0x00000000,0x00000000,0x00000000},0x2580,1,5668},
	{{0x00000000,0x00000000,0x00000000},0x0686,1,1707},
	{{0x00000081,0x00000000,0x00000000},0x0686,1,1701},
	{{0x00000000,0x00000000,0x00000000},0x2203,1,1031},
	{{0x40000001,0x00000000,0x00000000},0x3066,1,1031},
	{{0x00000001,0x00000020,0x00000000},0x30c6,1,1031},
	{{0x00010003,0x00000000,0x00000000},0x0422,1,1031},
	{{0x00010005,0x00000000,0x00000000},0x0442,1,1031},
	{{0x00000081,0x00000000,0x00000000},0x062a,1,1405},
	{{0x00000081,0x00000010,0x00000000},0xfe95,1,1405},
	{{0x01000081,0x00000000,0x00000000},0xfe96,1,1405},
	{{0x00000081,0x00000004,0x00000000},0xfe97,1,1405},
	{{0x00000081,0x00001000,0x00000000},0xfe98,1,1405},
	{{0x00000081,0x00000000,0x00000000},0x0629,1,1390},
	{{0x00000081,0x00000010,0x00000000},0xfe93,1,1390},
	{{0x01000081,0x00000000,0x00000000},0xfe94,1,1390},
	{{0x00000000,0x00000000,0x00000000},0x260e,1,6062},
	{{0x00000000,0x00000000,0x00000000},0x260f,1,6062},
	{{0x00000000,0x00000000,0x00000004},0x260e,1,6052},
	{{0x00000000,0x80000000,0x00000000},0x260f,1,6052},
	{{0x00000000,0x00000000,0x00000000},0x2315,1,4692},
	{{0x00000000,0x00804000,0x00000000},0x2169,1,3716},
	{{0x00004000,0x00002000,0x00000000},0x2469,1,3716},
	{{0x00000000,0x00042000,0x00000000},0x247d,1,3716},
	{{0x00000000,0x00040000,0x00000800},0x3229,1,3716},
	{{0x00000004,0x00804000,0x00000000},0x2179,1,3716},
	{{0x02000000,0x00002000,0x00000002},0x2491,1,3716},
	{{0x00000000,0x00804000,0x00000000},0x2182,1,3837},
	{{0x20000001,0x00000000,0x00000000},0x05d8,1,1217},
	{{0x00000081,0x00000000,0x00000000},0x0630,1,1438},
	{{0x00000081,0x00000010,0x00000000},0xfeab,1,1438},
	{{0x01000081,0x00000000,0x00000000},0xfeac,1,1438},
	{{0x00000081,0x00000000,0x00000000},0x062b,1,1409},
	{{0x00000081,0x00000010,0x00000000},0xfe99,1,1409},
	{{0x01000081,0x00000000,0x00000000},0xfe9a,1,1409},
	{{0x00000081,0x00000004,0x00000000},0xfe9b,1,1409},
	{{0x00000081,0x00001000,0x00000000},0xfe9c,1,1409},
	{{0x00000000,0x00000000,0x00000000},0x2203,1,4062},
	{{0x00000000,0x00000000,0x00000000},0x2234,1,4373},
	{{0x08000003,0x00000000,0x00000000},0x0398,1,708},
	{{0x08000005,0x00000000,0x00000000},0x03b8,1,708},
	{{0x00000000,0x00000000,0x00000200},0x2009,1,2870},
	{{0x00000000,0x00010000,0x00000018},0x2153,1,3528},
	{{0x00004000,0x00002000,0x00000000},0x246c,1,4938},
	{{0x00000000,0x00042000,0x00000000},0x2480,1,4938},
	{{0x02000000,0x00002000,0x00000002},0x2494,1,4938},
	{{0x00000000,0x00814000,0x00000000},0x216f,1,3781},
	{{0x00000004,0x00814000,0x00000000},0x217f,1,3781},
	{{0x00000000,0x00814000,0x00000000},0x2180,1,3796},
	{{0x00000000,0x00000000,0x00000040},0x2083,0,1444},
	{{0x00004001,0x00000000,0x00000000},0x2462,0,1444},
	{{0x00000001,0x00040000,0x00000000},0x2476,0,1444},
	{{0x00000081,0x00000000,0x00000400},0x0663,0,1444},
	{{0x00000000,0x00804000,0x00000000},0x2162,0,1444},
	{{0x02000001,0x00000000,0x00000002},0x248a,0,1444},
	{{0x00000000,0x00040000,0x00000800},0x3222,0,1444},
	{{0x00000004,0x00804000,0x00000000},0x2172,0,1444},
	{{0x00000000,0x00000000,0x00000018},0x215c,1,3639},
	{{0x00000000,0x00000000,0x00000018},0x2157,1,3574},
	{{0x00000000,0x00000000,0x00000200},0x2004,1,2825},
	{{0x40000001,0x00000000,0x00000000},0x3061,1,6603},
	{{0x00000001,0x00000020,0x00000000},0x30c1,1,6603},
	{{0x00000000,0x00000000,0x00000000},0x05d8,1,1221},
	{{0x00000000,0x00000000,0x00000000},0x0637,1,1221},
	{{0x00000000,0x00000000,0x00000000},0xfec3,1,7231},
	{{0x00000000,0x00000000,0x00000000},0xfec1,1,7223},
	{{0x00000000,0x00000000,0x00000000},0xfec2,1,7227},
	{{0x00000000,0x00000000,0x00000000},0xfec4,1,7235},
	{{0x00000000,0x00000000,0x00000000},0x062b,1,1414},
	{{0x00000000,0x00000000,0x00000000},0xfe9b,1,7071},
	{{0x00000000,0x00000000,0x00000000},0xfe99,1,7063},
	{{0x00000000,0x00000000,0x00000000},0xfe9a,1,7067},
	{{0x00000000,0x00000000,0x00000000},0xfe9c,1,7075},
	{{0x00000000,0x00000000,0x00000000},0x25c1,1,5916},
	{{0x00000000,0x00000000,0x00000000},0x0629,1,1402},
	{{0x00000000,0x00000000,0x00000000},0x2122,1,1402},
	{{0x00000000,0x00000000,0x00000000},0xfe93,1,7039},
	{{0x00000000,0x00000000,0x00000000},0xfe94,1,7043},
	{{0x00000000,0x00000000,0x00080000},0x2320,1,4732},
	{{0x00000000,0x00000080,0x00020000},0x3014,1,6486},
	{{0x00000000,0x00400000,0x00020000},0x3015,1,6486},
	{{0x00000000,0x00000000,0x00000000},0x2315,1,4711},
	{{0x00000000,0x00000000,0x00000000},0x25b7,1,4711},
	{{0x00000001,0x00000800,0x00000000},0x2122,1,3482},
	{{0x00000000,0x00000000,0x00000000},0x2023,1,3009},
	{{0x00400400,0x00000101,0x00000000},0x2504,1,5441},
	{{0x10400400,0x00000001,0x00000000},0x2505,1,5441},
	{{0x00400400,0x40000100,0x00000000},0x2506,1,5441},
	{{0x10400400,0x40000000,0x00000000},0x2507,1,5441},
	{{0x00000000,0x00000000,0x00000000},0x2034,1,3147},
	{{0x00000000,0x00000000,0x00000000},0x040b,0,2156},
	{{0x00000000,0x00000000,0x00000000},0x045b,0,2156},
	{{0x20000001,0x00000000,0x00000000},0x05e6,1,1294},
	{{0x21000001,0x00000000,0x00000000},0x05e5,1,1294},
	{{0x00010003,0x00000000,0x00000000},0x0426,1,1052},
	{{0x00010005,0x00000000,0x00000000},0x0446,1,1052},
	{{0x00010003,0x00000000,0x00000000},0x040b,1,922},
	{{0x00010005,0x00000000,0x00000000},0x045b,1,922},
	{{0x40000001,0x00000000,0x00000000},0x3064,1,6606},
	{{0x00000001,0x00000020,0x00000000},0x30c4,1,6606},
	{{0x40000005,0x00000000,0x00000000},0x3063,1,6606},
	{{0x00000005,0x00000020,0x00000000},0x30c3,1,6606},
	{{0x00000005,0x00000040,0x00000000},0x01dd,1,343},
	{{0x00000000,0x00804000,0x00000000},0x216b,1,3733},
	{{0x00004000,0x00002000,0x00000000},0x246b,1,3733},
	{{0x00000000,0x00042000,0x00000000},0x247f,1,3733},
	{{0x00000004,0x00804000,0x00000000},0x217b,1,3733},
	{{0x02000000,0x00002000,0x00000002},0x2493,1,3733},
	{{0x00004000,0x00002000,0x00000000},0x2473,1,5035},
	{{0x00000000,0x00042000,0x00000000},0x2487,1,5035},
	{{0x02000000,0x00002000,0x00000002},0x249b,1,5035},
	{{0x00000000,0x00000000,0x00000040},0x2082,0,1440},
	{{0x00004001,0x00000000,0x00000000},0x2461,0,1440},
	{{0x00000001,0x00040000,0x00000000},0x2475,0,1440},
	{{0x00000081,0x00000000,0x00000400},0x0662,0,1440},
	{{0x00000000,0x00804000,0x00000000},0x2161,0,1440},
	{{0x02000001,0x00000000,0x00000002},0x2489,0,1440},
	{{0x00000000,0x00040000,0x00000800},0x3221,0,1440},
	{{0x00000004,0x00804000,0x00000000},0x2171,0,1440},
	{{0x00000000,0x00000000,0x00000018},0x2156,1,3560},
	{{0x00080000,0x00000000,0x00000000},0x2025,1,3030},
	{{0x00000000,0x00000000,0x00000018},0x2154,1,3537},
	{{0x40000001,0x00000000,0x00000000},0x3046,0,1586},
	{{0x00000001,0x00000020,0x00000000},0x30a6,0,1586},
	{{0x00000201,0x00000000,0x00000000},0x3128,0,1586},
	{{0x00010003,0x00000000,0x00000000},0x0423,0,1586},
	{{0x00010005,0x00000000,0x00000000},0x0443,0,1586},
	{{0x40000005,0x00000000,0x00000000},0x3045,0,1586},
	{{0x00000005,0x00000020,0x00000000},0x30a5,0,1586},
	{{0x00000003,0x02000040,0x00000000},0x0168,0,1586},
	{{0x00000005,0x02000040,0x00000000},0x0169,0,1586},
	{{0x00000003,0x00000440,0x00000000},0x016a,0,1586},
	{{0x00000005,0x00000440,0x00000000},0x016b,0,1586},
	{{0x00000803,0x00000040,0x00000000},0x016c,0,1586},
	{{0x00000805,0x00000040,0x00000000},0x016d,0,1586},
	{{0x00000003,0x00000040,0x02000000},0x0172,0,1586},
	{{0x00000005,0x00000040,0x02000000},0x0173,0,1586},
	{{0x00000003,0x00000042,0x00000000},0x01af,0,1586},
	{{0x00000005,0x00000042,0x00000000},0x01b0,0,1586},
	{{0x00001003,0x00000040,0x00000000},0x01d3,0,1586},
	{{0x00001005,0x00000040,0x00000000},0x01d4,0,1586},
	{{0x00010003,0x00000000,0x08000000},0x040e,0,1586},
	{{0x00010005,0x00000000,0x08000000},0x045e,0,1586},
	{{0x00000005,0x00040040,0x00000000},0x24b0,0,1586},
	{{0x00004003,0x00000040,0x00000000},0x24ca,0,1586},
	{{0x00004005,0x00000040,0x00000000},0x24e4,0,1586},
	{{0x0000000b,0x00000040,0x04000000},0x016e,0,1586},
	{{0x0000000d,0x00000040,0x04000000},0x016f,0,1586},
	{{0x00100013,0x00000040,0x00000000},0x0170,0,1586},
	{{0x00100015,0x00000040,0x00000000},0x0171,0,1586},
	{{0x00040003,0x00000440,0x00000000},0x01d5,0,1586},
	{{0x00040005,0x00000440,0x00000000},0x01d6,0,1586},
	{{0x00040013,0x00000040,0x00000000},0x01d7,0,1586},
	{{0x00040015,0x00000040,0x00000000},0x01d8,0,1586},
	{{0x00041003,0x00000040,0x00000000},0x01d9,0,1586},
	{{0x00041005,0x00000040,0x00000000},0x01da,0,1586},
	{{0x04040003,0x00000040,0x00000000},0x01db,0,1586},
	{{0x04040005,0x00000040,0x00000000},0x01dc,0,1586},
	{{0x04100003,0x00000040,0x00000000},0x0214,0,1586},
	{{0x04100005,0x00000040,0x00000000},0x0215,0,1586},
	{{0x00000803,0x00000040,0x00800000},0x0216,0,1586},
	{{0x00000805,0x00000040,0x00800000},0x0217,0,1586},
	{{0x00040103,0x00000040,0x00000000},0x1e72,0,1586},
	{{0x00040105,0x00000040,0x00000000},0x1e73,0,1586},
	{{0x00000103,0x02000040,0x00000000},0x1e74,0,1586},
	{{0x00000105,0x02000040,0x00000000},0x1e75,0,1586},
	{{0x00008103,0x00000040,0x00000000},0x1e76,0,1586},
	{{0x00008105,0x00000040,0x00000000},0x1e77,0,1586},
	{{0x00000013,0x02000040,0x00000000},0x1e78,0,1586},
	{{0x00000015,0x02000040,0x00000000},0x1e79,0,1586},
	{{0x00040003,0x00000440,0x00000000},0x1e7a,0,1586},
	{{0x00040005,0x00000440,0x00000000},0x1e7b,0,1586},
	{{0x00080103,0x00000040,0x00000000},0x1ee4,0,1586},
	{{0x00080105,0x00000040,0x00000000},0x1ee5,0,1586},
	{{0x8000000b,0x00000040,0x00000000},0x1ee6,0,1586},
	{{0x8000000d,0x00000040,0x00000000},0x1ee7,0,1586},
	{{0x00000013,0x00000042,0x00000000},0x1ee8,0,1586},
	{{0x00000015,0x00000042,0x00000000},0x1ee9,0,1586},
	{{0x04000003,0x00000042,0x00000000},0x1eea,0,1586},
	{{0x04000005,0x00000042,0x00000000},0x1eeb,0,1586},
	{{0x00000003,0x02000042,0x00000000},0x1eee,0,1586},
	{{0x00000005,0x02000042,0x00000000},0x1eef,0,1586},
	{{0x8000000b,0x00000042,0x00000000},0x1eec,0,1586},
	{{0x8000000d,0x00000042,0x00000000},0x1eed,0,1586},
	{{0x00080103,0x00000042,0x00000000},0x1ef0,0,1586},
	{{0x00080105,0x00000042,0x00000000},0x1ef1,0,1586},
	{{0x00000000,0x00000000,0x00000000},0x24ca,1,5393},
	{{0x00000000,0x00000000,0x00000000},0x24e4,1,5393},
	{{0x00000000,0x00000000,0x00000000},0x0214,1,439},
	{{0x00000000,0x00000000,0x00000000},0x0215,1,439},
	{{0x00000000,0x00000000,0x00000000},0x0170,1,214},
	{{0x00000000,0x00000000,0x00000000},0x0171,1,214},
	{{0x00000000,0x00000000,0x00000000},0x038e,1,656},
	{{0x00000000,0x00000000,0x00000000},0x03cd,1,656},
	{{0x00000000,0x00000000,0x00000000},0x016c,1,208},
	{{0x00000000,0x00000000,0x00000000},0x016d,1,208},
	{{0x00000000,0x00000000,0x00000000},0x0216,1,443},
	{{0x00000000,0x00000000,0x00000000},0x0217,1,443},
	{{0x00000000,0x00000000,0x00000000},0x03a5,1,782},
	{{0x00000000,0x00000000,0x00000000},0x03c5,1,782},
	{{0x00000000,0x00000000,0x00000000},0x1f7a,1,2461},
	{{0x00000000,0x00000000,0x00000000},0x1fea,1,2461},
	{{0x00000000,0x00000000,0x00000000},0x1f7b,1,2465},
	{{0x00000000,0x00000000,0x00000000},0x1feb,1,2465},
	{{0x00000000,0x00000000,0x00000000},0x1fe0,1,2746},
	{{0x00000000,0x00000000,0x00000000},0x1fe8,1,2746},
	{{0x00000000,0x00000000,0x00000000},0x1f50,1,2345},
	{{0x00000000,0x00000000,0x00000000},0x1f52,1,2353},
	{{0x00000000,0x00000000,0x00000000},0x1f54,1,2363},
	{{0x00000000,0x00000000,0x00000000},0x1f56,1,2373},
	{{0x00000000,0x00000000,0x00000000},0x1fe1,1,2750},
	{{0x00000000,0x00000000,0x00000000},0x1fe9,1,2750},
	{{0x00000000,0x00000000,0x00000000},0x1fe2,1,2754},
	{{0x00000000,0x00000000,0x00000000},0x1fe3,1,2759},
	{{0x00000000,0x00000000,0x00000000},0x1fe7,1,2776},
	{{0x00000000,0x00000000,0x00000000},0x1f51,1,2349},
	{{0x00000000,0x00000000,0x00000000},0x1f59,1,2349},
	{{0x00000000,0x00000000,0x00000000},0x1f53,1,2358},
	{{0x00000000,0x00000000,0x00000000},0x1f5b,1,2358},
	{{0x00000000,0x00000000,0x00000000},0x1f55,1,2368},
	{{0x00000000,0x00000000,0x00000000},0x1f5d,1,2368},
	{{0x00000000,0x00000000,0x00000000},0x1f57,1,2378},
	{{0x00000000,0x00000000,0x00000000},0x1f5f,1,2378},
	{{0x00000000,0x00000000,0x00000000},0x1fe6,1,2772},
	{{0x00000000,0x00000000,0x00000000},0x016a,1,205},
	{{0x00000000,0x00000000,0x00000000},0x016b,1,205},
	{{0x00000000,0x00000000,0x00000000},0x1e72,1,1935},
	{{0x00000000,0x00000000,0x00000000},0x1e73,1,1935},
	{{0x00000000,0x00000000,0x00000000},0x1ee4,1,2134},
	{{0x00000000,0x00000000,0x00000000},0x1ee5,1,2134},
	{{0x00000000,0x00000000,0x00000000},0x1e7a,1,1952},
	{{0x00000000,0x00000000,0x00000000},0x1e7b,1,1952},
	{{0x00000000,0x00000000,0x00000000},0x1e76,1,1944},
	{{0x00000000,0x00000000,0x00000000},0x1e77,1,1944},
	{{0x00000000,0x00000000,0x00000000},0x1e74,1,1940},
	{{0x00000000,0x00000000,0x00000000},0x1e75,1,1940},
	{{0x00000000,0x00000000,0x00000000},0x016e,1,211},
	{{0x00000000,0x00000000,0x00000000},0x016f,1,211},
	{{0x00000000,0x00000000,0x00000000},0x1ee6,1,2138},
	{{0x00000000,0x00000000,0x00000000},0x1ee7,1,2138},
	{{0x00000000,0x00000000,0x00000000},0x03b0,1,815},
	{{0x00000000,0x00000000,0x00000000},0x3128,1,6873},
	{{0x00000000,0x00000000,0x00000000},0x3045,1,6549},
	{{0x00000000,0x00000000,0x00000000},0x3046,1,6549},
	{{0x00000000,0x00000000,0x00000000},0x30a5,1,6741},
	{{0x00000000,0x00000000,0x00000000},0x30a6,1,6741},
	{{0x00000000,0x00000000,0x00000000},0x01af,1,269},
	{{0x00000000,0x00000000,0x00000000},0x01b0,1,269},
	{{0x00000000,0x00000000,0x00000000},0x1eea,1,2145},
	{{0x00000000,0x00000000,0x00000000},0x1eeb,1,2145},
	{{0x00000000,0x00000000,0x00000000},0x1ee8,1,2141},
	{{0x00000000,0x00000000,0x00000000},0x1ee9,1,2141},
	{{0x00000000,0x00000000,0x00000000},0x1ef0,1,2157},
	{{0x00000000,0x00000000,0x00000000},0x1ef1,1,2157},
	{{0x00000000,0x00000000,0x00000000},0x1eec,1,2149},
	{{0x00000000,0x00000000,0x00000000},0x1eed,1,2149},
	{{0x00000000,0x00000000,0x00000000},0x1eee,1,2153},
	{{0x00000000,0x00000000,0x00000000},0x1eef,1,2153},
	{{0x00000000,0x00000000,0x00000000},0x01db,1,339},
	{{0x00000000,0x00000000,0x00000000},0x01dc,1,339},
	{{0x00000000,0x00000000,0x00000000},0x01d7,1,331},
	{{0x00000000,0x00000000,0x00000000},0x01d8,1,331},
	{{0x00000000,0x00000000,0x00000000},0x01d5,1,327},
	{{0x00000000,0x00000000,0x00000000},0x01d6,1,327},
	{{0x00000000,0x00000000,0x00000000},0x01d9,1,335},
	{{0x00000000,0x00000000,0x00000000},0x01da,1,335},
	{{0x00000000,0x00000000,0x00000000},0x0172,1,217},
	{{0x00000000,0x00000000,0x00000000},0x0173,1,217},
	{{0x00000000,0x00000000,0x00000000},0x01d3,1,324},
	{{0x00000000,0x00000000,0x00000000},0x01d4,1,324},
	{{0x00000000,0x00000000,0x00000000},0x0423,1,1037},
	{{0x00000000,0x00000000,0x00000000},0x0443,1,1037},
	{{0x00000000,0x00000000,0x00000000},0x0168,1,202},
	{{0x00000000,0x00000000,0x00000000},0x0169,1,202},
	{{0x00000000,0x00000000,0x00000000},0x1e78,1,1948},
	{{0x00000000,0x00000000,0x00000000},0x1e79,1,1948},
	{{0x00000000,0x00000000,0x00000000},0x2195,1,3911},
	{{0x00000000,0x00000000,0x00000000},0x21a8,1,3979},
	{{0x00000000,0x00000000,0x00000000},0x2540,1,5613},
	{{0x00000000,0x00000000,0x00000000},0x2541,1,5613},
	{{0x00000000,0x00000000,0x00000000},0x2547,1,5613},
	{{0x00000000,0x00000000,0x00000000},0x2548,1,5613},
	{{0x00000000,0x00000000,0x00000000},0x2526,1,5564},
	{{0x00000000,0x00000000,0x00000000},0x2527,1,5564},
	{{0x00000000,0x00000000,0x00000000},0x2529,1,5564},
	{{0x00000000,0x00000000,0x00000000},0x252a,1,5564},
	{{0x00000000,0x00000000,0x00000000},0x2543,1,5617},
	{{0x00000000,0x00000000,0x00000000},0x2544,1,5617},
	{{0x00000000,0x00000000,0x00000000},0x2545,1,5617},
	{{0x00000000,0x00000000,0x00000000},0x2546,1,5617},
	{{0x00000000,0x00000000,0x00000000},0x251e,1,5549},
	{{0x00000000,0x00000000,0x00000000},0x251f,1,5549},
	{{0x00000000,0x00000000,0x00000000},0x2521,1,5549},
	{{0x00000000,0x00000000,0x00000000},0x2522,1,5549},
	{{0x00000000,0x00000000,0x00000000},0x2534,1,5583},
	{{0x00000000,0x00000000,0x00000000},0x2567,1,5583},
	{{0x00000000,0x00000000,0x00000000},0x2568,1,5583},
	{{0x00000000,0x00000000,0x00000000},0x2569,1,5583},
	{{0x00000000,0x00000000,0x00000000},0x2537,1,5594},
	{{0x00000000,0x00000000,0x00000000},0x2538,1,5594},
	{{0x00000000,0x00000000,0x00000000},0x253b,1,5594},
	{{0x00000000,0x00000000,0x00000000},0x2518,1,5527},
	{{0x00000000,0x00000000,0x00000000},0x255b,1,5527},
	{{0x00000000,0x00000000,0x00000000},0x255c,1,5527},
	{{0x00000000,0x00000000,0x00000000},0x255d,1,5527},
	{{0x00000000,0x00000000,0x00000000},0x2519,1,5534},
	{{0x00000000,0x00000000,0x00000000},0x251a,1,5534},
	{{0x00000000,0x00000000,0x00000000},0x251b,1,5534},
	{{0x00000000,0x00000000,0x00000000},0x2535,1,5590},
	{{0x00000000,0x00000000,0x00000000},0x2536,1,5590},
	{{0x00000000,0x00000000,0x00000000},0x2539,1,5590},
	{{0x00000000,0x00000000,0x00000000},0x253a,1,5590},
	{{0x00000000,0x00000000,0x00000000},0x222a,1,4335},
	{{0x00000000,0x00000000,0x00080000},0x2580,1,5656},
	{{0x00000001,0x04400080,0x00000080},0x25a7,1,5814},
	{{0x00000001,0x04400080,0x00000080},0x25a8,1,5814},
	{{0x00000000,0x00000000,0x00002000},0x2191,1,3870},
	{{0x00000000,0x00000000,0x00000000},0x2514,1,5516},
	{{0x00000000,0x00000000,0x00000000},0x2558,1,5516},
	{{0x00000000,0x00000000,0x00000000},0x2559,1,5516},
	{{0x00000000,0x00000000,0x00000000},0x255a,1,5516},
	{{0x00000000,0x00000000,0x00000000},0x2515,1,5523},
	{{0x00000000,0x00000000,0x00000000},0x2516,1,5523},
	{{0x00000000,0x00000000,0x00000000},0x2517,1,5523},
	{{0x00000000,0x00000000,0x00000000},0x25b2,1,5893},
	{{0x00000000,0x00000000,0x00000000},0x25b3,1,5893},
	{{0x00000201,0x00000000,0x00000000},0x312a,0,1588},
	{{0x00000003,0x02000040,0x00000000},0x1e7c,0,1588},
	{{0x00000005,0x02000040,0x00000000},0x1e7d,0,1588},
	{{0x00000005,0x00040040,0x00000000},0x24b1,0,1588},
	{{0x00004003,0x00000040,0x00000000},0x24cb,0,1588},
	{{0x00004005,0x00000040,0x00000000},0x24e5,0,1588},
	{{0x00080103,0x00000040,0x00000000},0x1e7e,0,1588},
	{{0x00080105,0x00000040,0x00000000},0x1e7f,0,1588},
	{{0x00000000,0x00000000,0x00000000},0x24cb,1,5397},
	{{0x00000000,0x00000000,0x00000000},0x24e5,1,5397},
	{{0x00000000,0x00000000,0x00000000},0x040e,1,934},
	{{0x00000000,0x00000000,0x00000000},0x045e,1,934},
	{{0x00000000,0x00000000,0x00000000},0x03ab,1,812},
	{{0x00000000,0x00000000,0x00000000},0x03cb,1,812},
	{{0x00000000,0x00000000,0x00000000},0x06a4,1,1718},
	{{0x00000000,0x00000000,0x00000000},0x1e7e,1,1959},
	{{0x00000000,0x00000000,0x00000000},0x1e7f,1,1959},
	{{0x00000000,0x00000000,0x00000000},0x0474,1,1151},
	{{0x00000000,0x00000000,0x00000000},0x0475,1,1151},
	{{0x00000000,0x00000000,0x00000000},0x312a,1,6876},
	{{0x00000000,0x00000000,0x00000000},0x0412,1,954},
	{{0x00000000,0x00000000,0x00000000},0x0432,1,954},
	{{0x00000000,0x00000000,0x00000000},0x1e7c,1,1956},
	{{0x00000000,0x00000000,0x00000000},0x1e7d,1,1956},
	{{0x00000001,0x00000020,0x00000000},0x30f7,1,6753},
	{{0x20000001,0x00000000,0x00000000},0x05d5,1,1194},
	{{0x00000001,0x00000020,0x00000000},0x30f9,1,951},
	{{0x00010003,0x00000000,0x00000000},0x0412,1,951},
	{{0x00010005,0x00000000,0x00000000},0x0432,1,951},
	{{0x00000081,0x00000000,0x00000000},0x06a4,1,1714},
	{{0x00000000,0x00000000,0x00000000},0x253c,1,5598},
	{{0x00000000,0x00000000,0x00000000},0x256a,1,5598},
	{{0x00000000,0x00000000,0x00000000},0x256b,1,5598},
	{{0x00000000,0x00000000,0x00000000},0x256c,1,5598},
	{{0x00000000,0x00000000,0x00000000},0x253f,1,5609},
	{{0x00000000,0x00000000,0x00000000},0x2542,1,5609},
	{{0x00000000,0x00000000,0x00000000},0x254b,1,5609},
	{{0x00000001,0x00000020,0x00000000},0x30f8,1,6756},
	{{0x00000000,0x00000000,0x00000000},0x2524,1,5553},
	{{0x00000000,0x00000000,0x00000000},0x2561,1,5553},
	{{0x00000000,0x00000000,0x00000000},0x2562,1,5553},
	{{0x00000000,0x00000000,0x00000000},0x2563,1,5553},
	{{0x00000000,0x00000000,0x00000000},0x2525,1,5560},
	{{0x00000000,0x00000000,0x00000000},0x2528,1,5560},
	{{0x00000000,0x00000000,0x00000000},0x252b,1,5560},
	{{0x00000000,0x00000000,0x00000000},0x253d,1,5605},
	{{0x00000000,0x00000000,0x00000000},0x253e,1,5605},
	{{0x00000000,0x00000000,0x00000000},0x2549,1,5605},
	{{0x00000000,0x00000000,0x00000000},0x254a,1,5605},
	{{0x00000001,0x00000020,0x00000000},0x30fa,1,6759},
	{{0x40000000,0x00000800,0x00000000},0x309e,1,6715},
	{{0x00000000,0x00000820,0x00000000},0x30fe,1,6715},
	{{0x40000000,0x00000820,0x00000000},0x309b,1,6675},
	{{0x00000000,0x00000000,0x00000000},0x251c,1,5538},
	{{0x00000000,0x00000000,0x00000000},0x255e,1,5538},
	{{0x00000000,0x00000000,0x00000000},0x255f,1,5538},
	{{0x00000000,0x00000000,0x00000000},0x2560,1,5538},
	{{0x00000000,0x00000000,0x00000000},0x251d,1,5545},
	{{0x00000000,0x00000000,0x00000000},0x2520,1,5545},
	{{0x00000000,0x00000000,0x00000000},0x2523,1,5545},
	{{0x08000045,0x00000000,0x00000000},0x1fb0,1,2615},
	{{0x08000043,0x00000000,0x00000000},0x1fb8,1,2615},
	{{0x08000005,0x00000008,0x00000000},0x1fd0,1,2615},
	{{0x08000003,0x00000008,0x00000000},0x1fd8,1,2615},
	{{0x08000005,0x10000000,0x00000000},0x1fe0,1,2615},
	{{0x08000003,0x10000000,0x00000000},0x1fe8,1,2615},
	{{0x00000000,0x00000000,0x00000000},0x2423,0,1960},
	{{0x40000001,0x00000000,0x00000000},0x3094,1,6672},
	{{0x00000001,0x00000020,0x00000000},0x30f4,1,6672},
	{{0x00000000,0x00000000,0x00000000},0x2502,1,5431},
	{{0x00000000,0x00000000,0x00000000},0x2551,1,5431},
	{{0x00000000,0x00000000,0x00000000},0x2503,1,5437},
	{{0x00008003,0x00000040,0x00000000},0x0174,0,1590},
	{{0x00008005,0x00000040,0x00000000},0x0175,0,1590},
	{{0x04000003,0x00000040,0x00000000},0x1e80,0,1590},
	{{0x04000005,0x00000040,0x00000000},0x1e81,0,1590},
	{{0x00000013,0x00000040,0x00000000},0x1e82,0,1590},
	{{0x00000015,0x00000040,0x00000000},0x1e83,0,1590},
	{{0x00040003,0x00000040,0x00000000},0x1e84,0,1590},
	{{0x00040005,0x00000040,0x00000000},0x1e85,0,1590},
	{{0x00000005,0x00040040,0x00000000},0x24b2,0,1590},
	{{0x00004003,0x00000040,0x00000000},0x24cc,0,1590},
	{{0x00004005,0x00000040,0x00000000},0x24e6,0,1590},
	{{0x0008000b,0x00000040,0x00000000},0x1e86,0,1590},
	{{0x0008000d,0x00000040,0x00000000},0x1e87,0,1590},
	{{0x00080103,0x00000040,0x00000000},0x1e88,0,1590},
	{{0x00080105,0x00000040,0x00000000},0x1e89,0,1590},
	{{0x00000000,0x00000000,0x00000000},0x24cc,1,5401},
	{{0x00000000,0x00000000,0x00000000},0x24e6,1,5401},
	{{0x00000000,0x00000000,0x00000000},0x1e80,1,1963},
	{{0x00000000,0x00000000,0x00000000},0x1e81,1,1963},
	{{0x00000000,0x00000000,0x00000000},0x038f,1,659},
	{{0x00000000,0x00000000,0x00000000},0x03ce,1,659},
	{{0x00000000,0x00000000,0x00000000},0x1e82,1,1966},
	{{0x00000000,0x00000000,0x00000000},0x1e83,1,1966},
	{{0x00000000,0x00000000,0x00000000},0x03a9,1,806},
	{{0x00000000,0x00000000,0x00000000},0x03c9,1,806},
	{{0x00000000,0x00000000,0x00000000},0x1f7c,1,2469},
	{{0x00000000,0x00000000,0x00000000},0x1ffa,1,2469},
	{{0x00000000,0x00000000,0x00000000},0x1ff2,1,2790},
	{{0x00000000,0x00000000,0x00000000},0x1f7d,1,2473},
	{{0x00000000,0x00000000,0x00000000},0x1ffb,1,2473},
	{{0x00000000,0x00000000,0x00000000},0x1ff4,1,2799},
	{{0x00000000,0x00000000,0x00000000},0x1f60,1,2383},
	{{0x00000000,0x00000000,0x00000000},0x1f68,1,2383},
	{{0x00000000,0x00000000,0x00000000},0x1f62,1,2391},
	{{0x00000000,0x00000000,0x00000000},0x1f6a,1,2391},
	{{0x00000000,0x00000000,0x00000000},0x1fa2,1,2579},
	{{0x00000000,0x00000000,0x00000000},0x1faa,1,2579},
	{{0x00000000,0x00000000,0x00000000},0x1f64,1,2401},
	{{0x00000000,0x00000000,0x00000000},0x1f6c,1,2401},
	{{0x00000000,0x00000000,0x00000000},0x1fa4,1,2591},
	{{0x00000000,0x00000000,0x00000000},0x1fac,1,2591},
	{{0x00000000,0x00000000,0x00000000},0x1f66,1,2411},
	{{0x00000000,0x00000000,0x00000000},0x1f6e,1,2411},
	{{0x00000000,0x00000000,0x00000000},0x1fa6,1,2603},
	{{0x00000000,0x00000000,0x00000000},0x1fae,1,2603},
	{{0x00000000,0x00000000,0x00000000},0x1fa0,1,2569},
	{{0x00000000,0x00000000,0x00000000},0x1fa8,1,2569},
	{{0x00000000,0x00000000,0x00000000},0x1f61,1,2387},
	{{0x00000000,0x00000000,0x00000000},0x1f69,1,2387},
	{{0x00000000,0x00000000,0x00000000},0x1f63,1,2396},
	{{0x00000000,0x00000000,0x00000000},0x1f6b,1,2396},
	{{0x00000000,0x00000000,0x00000000},0x1fa3,1,2585},
	{{0x00000000,0x00000000,0x00000000},0x1fab,1,2585},
	{{0x00000000,0x00000000,0x00000000},0x1f65,1,2406},
	{{0x00000000,0x00000000,0x00000000},0x1f6d,1,2406},
	{{0x00000000,0x00000000,0x00000000},0x1fa5,1,2597},
	{{0x00000000,0x00000000,0x00000000},0x1fad,1,2597},
	{{0x00000000,0x00000000,0x00000000},0x1f67,1,2416},
	{{0x00000000,0x00000000,0x00000000},0x1f6f,1,2416},
	{{0x00000000,0x00000000,0x00000000},0x1fa7,1,2609},
	{{0x00000000,0x00000000,0x00000000},0x1faf,1,2609},
	{{0x00000000,0x00000000,0x00000000},0x1fa1,1,2574},
	{{0x00000000,0x00000000,0x00000000},0x1fa9,1,2574},
	{{0x00000000,0x00000000,0x00000000},0x1ff6,1,2804},
	{{0x00000000,0x00000000,0x00000000},0x1ff7,1,2808},
	{{0x00000000,0x00000000,0x00000000},0x1ff3,1,2795},
	{{0x00000000,0x00000000,0x00000000},0x1ffc,1,2795},
	{{0x00000000,0x00000000,0x00000000},0x05d5,1,1198},
	{{0x00000000,0x00000000,0x00000000},0x0648,1,1198},
	{{0x00000000,0x00000000,0x00000000},0xfeed,1,7399},
	{{0x00000000,0x00000000,0x00000000},0xfeee,1,7403},
	{{0x00000000,0x00000000,0x00000000},0x1e88,1,1975},
	{{0x00000000,0x00000000,0x00000000},0x1e89,1,1975},
	{{0x00000000,0x00000000,0x00000000},0x1e86,1,1972},
	{{0x00000000,0x00000000,0x00000000},0x1e87,1,1972},
	{{0x00000000,0x00000000,0x00000000},0x1e84,1,1969},
	{{0x00000000,0x00000000,0x00000000},0x1e85,1,1969},
	{{0x00000000,0x00000000,0x00000000},0x20a9,1,3344},
	{{0x00000000,0x00000000,0x00000000},0x0174,1,220},
	{{0x00000000,0x00000000,0x00000000},0x0175,1,220},
	{{0x40000001,0x00000000,0x00000000},0x308f,1,6657},
	{{0x00000001,0x00000020,0x00000000},0x30ef,1,6657},
	{{0x40000005,0x00000000,0x00000000},0x308e,1,6657},
	{{0x00000005,0x00000020,0x00000000},0x30ee,1,6657},
	{{0x00000000,0x00000000,0x00000000},0x301c,1,6513},
	{{0x00000081,0x00000000,0x00000000},0x0648,1,1547},
	{{0x00000081,0x00000010,0x00000000},0xfeed,1,1547},
	{{0x01000081,0x00000000,0x00000000},0xfeee,1,1547},
	{{0x00000089,0x00000000,0x00000000},0x0624,1,1360},
	{{0x00000089,0x00000010,0x00000000},0xfe85,1,1360},
	{{0x40000001,0x00000000,0x00000000},0x3091,1,6663},
	{{0x00000001,0x00000020,0x00000000},0x30f1,1,6663},
	{{0x00000000,0x00000000,0x00000000},0x0624,1,1370},
	{{0x00000000,0x00000000,0x00000000},0xfe85,1,7007},
	{{0x40000001,0x00000000,0x00000000},0x3090,1,6660},
	{{0x00000001,0x00000020,0x00000000},0x30f0,1,6660},
	{{0x40000001,0x00000000,0x00000000},0x3092,1,6666},
	{{0x00000001,0x00000020,0x00000000},0x30f2,1,6666},
	{{0x00000001,0x00000000,0x00000000},0x20a9,1,3340},
	{{0x00000201,0x00000000,0x00000000},0x3112,0,1592},
	{{0x00040003,0x00000040,0x00000000},0x1e8c,0,1592},
	{{0x00040005,0x00000040,0x00000000},0x1e8d,0,1592},
	{{0x00000005,0x00040040,0x00000000},0x24b3,0,1592},
	{{0x00004003,0x00000040,0x00000000},0x24cd,0,1592},
	{{0x00004005,0x00000040,0x00000000},0x24e7,0,1592},
	{{0x0008000b,0x00000040,0x00000000},0x1e8a,0,1592},
	{{0x0008000d,0x00000040,0x00000000},0x1e8b,0,1592},
	{{0x00000000,0x00000000,0x00000000},0x24cd,1,5405},
	{{0x00000000,0x00000000,0x00000000},0x24e7,1,5405},
	{{0x00000000,0x00000000,0x00000000},0x03a7,1,796},
	{{0x00000000,0x00000000,0x00000000},0x03c7,1,796},
	{{0x00000000,0x00000000,0x00000000},0x05d7,1,1214},
	{{0x00000000,0x00000000,0x00000000},0x062e,1,1214},
	{{0x00000000,0x00000000,0x00000000},0xfea7,1,7119},
	{{0x00000000,0x00000000,0x00000000},0xfea5,1,7111},
	{{0x00000000,0x00000000,0x00000000},0xfea6,1,7115},
	{{0x00000000,0x00000000,0x00000000},0xfea8,1,7123},
	{{0x00000000,0x00000000,0x00000000},0x1e8a,1,1979},
	{{0x00000000,0x00000000,0x00000000},0x1e8b,1,1979},
	{{0x00000000,0x00000000,0x00000000},0x3112,1,6826},
	{{0x00000000,0x00000000,0x00000000},0x1e8c,1,1982},
	{{0x00000000,0x00000000,0x00000000},0x1e8d,1,1982},
	{{0x08000003,0x00000000,0x00000000},0x039e,1,747},
	{{0x08000005,0x00000000,0x00000000},0x03be,1,747},
	{{0x00000000,0x00000000,0x00000000},0x2717,1,6321},
	{{0x00008003,0x00000040,0x00000000},0x0176,0,1594},
	{{0x00008005,0x00000040,0x00000000},0x0177,0,1594},
	{{0x00040003,0x00000040,0x00000000},0x0178,0,1594},
	{{0x04000003,0x00000040,0x00000000},0x1ef2,0,1594},
	{{0x04000005,0x00000040,0x00000000},0x1ef3,0,1594},
	{{0x00000003,0x02000040,0x00000000},0x1ef8,0,1594},
	{{0x00000005,0x02000040,0x00000000},0x1ef9,0,1594},
	{{0x00000005,0x00040040,0x00000000},0x24b4,0,1594},
	{{0x00004003,0x00000040,0x00000000},0x24ce,0,1594},
	{{0x00004005,0x00000040,0x00000000},0x24e8,0,1594},
	{{0x0008000b,0x00000040,0x00000000},0x1e8e,0,1594},
	{{0x0008000d,0x00000040,0x00000000},0x1e8f,0,1594},
	{{0x00080103,0x00000040,0x00000000},0x1ef4,0,1594},
	{{0x00080105,0x00000040,0x00000000},0x1ef5,0,1594},
	{{0x8000000b,0x00000040,0x00000000},0x1ef6,0,1594},
	{{0x8000000d,0x00000040,0x00000000},0x1ef7,0,1594},
	{{0x00000000,0x00000000,0x00000000},0x24ce,1,5409},
	{{0x00000000,0x00000000,0x00000000},0x24e8,1,5409},
	{{0x00000000,0x00000000,0x00000000},0x1ef2,1,2162},
	{{0x00000000,0x00000000,0x00000000},0x1ef3,1,2162},
	{{0x00000000,0x00000000,0x00000000},0x0389,1,639},
	{{0x00000000,0x00000000,0x00000000},0x03ae,1,639},
	{{0x00000000,0x00000000,0x00000000},0x0397,1,705},
	{{0x00000000,0x00000000,0x00000000},0x03b7,1,705},
	{{0x00000000,0x00000000,0x00000000},0x1f74,1,2437},
	{{0x00000000,0x00000000,0x00000000},0x1fca,1,2437},
	{{0x00000000,0x00000000,0x00000000},0x1fc2,1,2673},
	{{0x00000000,0x00000000,0x00000000},0x1f75,1,2441},
	{{0x00000000,0x00000000,0x00000000},0x1fcb,1,2441},
	{{0x00000000,0x00000000,0x00000000},0x1fc4,1,2682},
	{{0x00000000,0x00000000,0x00000000},0x1f20,1,2241},
	{{0x00000000,0x00000000,0x00000000},0x1f28,1,2241},
	{{0x00000000,0x00000000,0x00000000},0x1f22,1,2249},
	{{0x00000000,0x00000000,0x00000000},0x1f2a,1,2249},
	{{0x00000000,0x00000000,0x00000000},0x1f92,1,2533},
	{{0x00000000,0x00000000,0x00000000},0x1f9a,1,2533},
	{{0x00000000,0x00000000,0x00000000},0x1f24,1,2259},
	{{0x00000000,0x00000000,0x00000000},0x1f2c,1,2259},
	{{0x00000000,0x00000000,0x00000000},0x1f94,1,2545},
	{{0x00000000,0x00000000,0x00000000},0x1f9c,1,2545},
	{{0x00000000,0x00000000,0x00000000},0x1f26,1,2269},
	{{0x00000000,0x00000000,0x00000000},0x1f2e,1,2269},
	{{0x00000000,0x00000000,0x00000000},0x1f96,1,2557},
	{{0x00000000,0x00000000,0x00000000},0x1f9e,1,2557},
	{{0x00000000,0x00000000,0x00000000},0x1f90,1,2523},
	{{0x00000000,0x00000000,0x00000000},0x1f98,1,2523},
	{{0x00000000,0x00000000,0x00000000},0x1f21,1,2245},
	{{0x00000000,0x00000000,0x00000000},0x1f29,1,2245},
	{{0x00000000,0x00000000,0x00000000},0x1f23,1,2254},
	{{0x00000000,0x00000000,0x00000000},0x1f2b,1,2254},
	{{0x00000000,0x00000000,0x00000000},0x1f93,1,2539},
	{{0x00000000,0x00000000,0x00000000},0x1f9b,1,2539},
	{{0x00000000,0x00000000,0x00000000},0x1f25,1,2264},
	{{0x00000000,0x00000000,0x00000000},0x1f2d,1,2264},
	{{0x00000000,0x00000000,0x00000000},0x1f95,1,2551},
	{{0x00000000,0x00000000,0x00000000},0x1f9d,1,2551},
	{{0x00000000,0x00000000,0x00000000},0x1f27,1,2274},
	{{0x00000000,0x00000000,0x00000000},0x1f2f,1,2274},
	{{0x00000000,0x00000000,0x00000000},0x1f97,1,2563},
	{{0x00000000,0x00000000,0x00000000},0x1f9f,1,2563},
	{{0x00000000,0x00000000,0x00000000},0x1f91,1,2528},
	{{0x00000000,0x00000000,0x00000000},0x1f99,1,2528},
	{{0x00000000,0x00000000,0x00000000},0x1fc6,1,2687},
	{{0x00000000,0x00000000,0x00000000},0x1fc7,1,2691},
	{{0x00000000,0x00000000,0x00000000},0x1fc3,1,2678},
	{{0x00000000,0x00000000,0x00000000},0x1fcc,1,2678},
	{{0x00000000,0x00000000,0x00000000},0x064a,1,1563},
	{{0x00000000,0x00000000,0x00000000},0xfef3,1,7423},
	{{0x00000000,0x00000000,0x00000000},0xfef1,1,7415},
	{{0x00000000,0x00000000,0x00000000},0xfef2,1,7419},
	{{0x00000000,0x00000000,0x00000000},0xfef4,1,7427},
	{{0x00000000,0x00000000,0x00000000},0x1ef4,1,2165},
	{{0x00000000,0x00000000,0x00000000},0x1ef5,1,2165},
	{{0x00000000,0x00000000,0x00000000},0x1e8e,1,1985},
	{{0x00000000,0x00000000,0x00000000},0x1e8f,1,1985},
	{{0x00000000,0x00000000,0x00000000},0x1ef6,1,2169},
	{{0x00000000,0x00000000,0x00000000},0x1ef7,1,2169},
	{{0x00000000,0x00000000,0x00000000},0x0462,1,1125},
	{{0x00000000,0x00000000,0x00000000},0x0463,1,1125},
	{{0x00000000,0x00000000,0x00000000},0x0178,0,2952},
	{{0x00000000,0x00000000,0x00000000},0x042b,1,1092},
	{{0x00000000,0x00000000,0x00000000},0x044b,1,1092},
	{{0x00000000,0x00000000,0x00000000},0x0176,1,223},
	{{0x00000000,0x00000000,0x00000000},0x0177,1,223},
	{{0x00000000,0x00000000,0x00000000},0x1ef8,1,2172},
	{{0x00000000,0x00000000,0x00000000},0x1ef9,1,2172},
	{{0x40000001,0x00000000,0x00000000},0x3084,1,1109},
	{{0x00000001,0x00000020,0x00000000},0x30e4,1,1109},
	{{0x00010003,0x00000000,0x00000000},0x042f,1,1109},
	{{0x00010005,0x00000000,0x00000000},0x044f,1,1109},
	{{0x40000005,0x00000000,0x00000000},0x3083,1,1109},
	{{0x00000005,0x00000020,0x00000000},0x30e3,1,1109},
	{{0x00010003,0x00000000,0x00000000},0x0462,1,1121},
	{{0x00010005,0x00000000,0x00000000},0x0463,1,1121},
	{{0x00000081,0x00000000,0x00000000},0x064a,1,1559},
	{{0x00000081,0x00000010,0x00000000},0xfef1,1,1559},
	{{0x01000081,0x00000000,0x00000000},0xfef2,1,1559},
	{{0x00000081,0x00000004,0x00000000},0xfef3,1,1559},
	{{0x00000081,0x00001000,0x00000000},0xfef4,1,1559},
	{{0x00000089,0x00000000,0x00000000},0x0626,1,1373},
	{{0x00000089,0x00000004,0x00000000},0xfe8b,1,1373},
	{{0x00010003,0x00000000,0x00000000},0x042b,1,1087},
	{{0x00010005,0x00000000,0x00000000},0x044b,1,1087},
	{{0x00000000,0x00000000,0x00000000},0x0626,1,1383},
	{{0x00000000,0x00000000,0x00000000},0xfe8b,1,7011},
	{{0x00000000,0x00000000,0x00000000},0x0407,1,905},
	{{0x00000000,0x00000000,0x00000000},0x0457,1,905},
	{{0x00010003,0x00000000,0x00000000},0x0407,1,905},
	{{0x00010005,0x00000000,0x00000000},0x0457,1,905},
	{{0x40000001,0x00000000,0x00000000},0x3088,1,6645},
	{{0x00000001,0x00000020,0x00000000},0x30e8,1,6645},
	{{0x40000005,0x00000000,0x00000000},0x3087,1,6645},
	{{0x00000005,0x00000020,0x00000000},0x30e7,1,6645},
	{{0x20000001,0x00000000,0x00000000},0x05d9,1,1224},
	{{0x08000000,0x00000000,0x00000000},0x037a,1,575},
	{{0x08000045,0x00000000,0x00000000},0x1fb3,1,575},
	{{0x08800005,0x00000000,0x00000000},0x1fc3,1,575},
	{{0x08000005,0x00008000,0x00000000},0x1ff3,1,575},
	{{0x08000045,0x00200000,0x00000000},0x1f80,1,575},
	{{0x08020045,0x00000000,0x00000000},0x1f81,1,575},
	{{0x08800005,0x00200000,0x00000000},0x1f90,1,575},
	{{0x08820005,0x00000000,0x00000000},0x1f91,1,575},
	{{0x08000005,0x00208000,0x00000000},0x1fa0,1,575},
	{{0x08020005,0x00008000,0x00000000},0x1fa1,1,575},
	{{0x08000045,0x20000000,0x00000000},0x1fb2,1,575},
	{{0x08000045,0x00020000,0x00000000},0x1fb4,1,575},
	{{0x08000045,0x00080000,0x00000000},0x1fb7,1,575},
	{{0x08800005,0x20000000,0x00000000},0x1fc2,1,575},
	{{0x08800005,0x00020000,0x00000000},0x1fc4,1,575},
	{{0x08800005,0x00080000,0x00000000},0x1fc7,1,575},
	{{0x08000005,0x20008000,0x00000000},0x1ff2,1,575},
	{{0x08000005,0x00028000,0x00000000},0x1ff4,1,575},
	{{0x08000005,0x00088000,0x00000000},0x1ff7,1,575},
	{{0x08000045,0x20200000,0x00000000},0x1f82,1,575},
	{{0x08020045,0x20000000,0x00000000},0x1f83,1,575},
	{{0x08000045,0x00220000,0x00000000},0x1f84,1,575},
	{{0x08020045,0x00020000,0x00000000},0x1f85,1,575},
	{{0x08000045,0x00280000,0x00000000},0x1f86,1,575},
	{{0x08020045,0x00080000,0x00000000},0x1f87,1,575},
	{{0x08800005,0x20200000,0x00000000},0x1f92,1,575},
	{{0x08820005,0x20000000,0x00000000},0x1f93,1,575},
	{{0x08800005,0x00220000,0x00000000},0x1f94,1,575},
	{{0x08820005,0x00020000,0x00000000},0x1f95,1,575},
	{{0x08800005,0x00280000,0x00000000},0x1f96,1,575},
	{{0x08820005,0x00080000,0x00000000},0x1f97,1,575},
	{{0x08000005,0x20208000,0x00000000},0x1fa2,1,575},
	{{0x08020005,0x20008000,0x00000000},0x1fa3,1,575},
	{{0x08000005,0x00228000,0x00000000},0x1fa4,1,575},
	{{0x08020005,0x00028000,0x00000000},0x1fa5,1,575},
	{{0x08000005,0x00288000,0x00000000},0x1fa6,1,575},
	{{0x08020005,0x00088000,0x00000000},0x1fa7,1,575},
	{{0x00000000,0x00000000,0x00000000},0x01a6,1,266},
	{{0x00000001,0x00000040,0x00000000},0x01a6,1,266},
	{{0x40000001,0x00000000,0x00000000},0x3086,1,1103},
	{{0x00000001,0x00000020,0x00000000},0x30e6,1,1103},
	{{0x00010003,0x00000000,0x00000000},0x042e,1,1103},
	{{0x00010005,0x00000000,0x00000000},0x044e,1,1103},
	{{0x40000005,0x00000000,0x00000000},0x3085,1,1103},
	{{0x00000005,0x00000020,0x00000000},0x30e5,1,1103},
	{{0x00010003,0x00000000,0x00200000},0x046a,1,1128},
	{{0x00010005,0x00000000,0x00200000},0x046b,1,1128},
	{{0x00000201,0x00000000,0x00000000},0x3117,0,1596},
	{{0x00000013,0x00000040,0x00000000},0x0179,0,1596},
	{{0x00000015,0x00000040,0x00000000},0x017a,0,1596},
	{{0x00001003,0x00000040,0x00000000},0x017d,0,1596},
	{{0x00001005,0x00000040,0x00000000},0x017e,0,1596},
	{{0x00000003,0x00000040,0x10000000},0x01b5,0,1596},
	{{0x00000005,0x00000040,0x10000000},0x01b6,0,1596},
	{{0x00008003,0x00000040,0x00000000},0x1e90,0,1596},
	{{0x00008005,0x00000040,0x00000000},0x1e91,0,1596},
	{{0x00000005,0x00040040,0x00000000},0x24b5,0,1596},
	{{0x00004003,0x00000040,0x00000000},0x24cf,0,1596},
	{{0x00004005,0x00000040,0x00000000},0x24e9,0,1596},
	{{0x0008000b,0x00000040,0x00000000},0x017b,0,1596},
	{{0x0008000d,0x00000040,0x00000000},0x017c,0,1596},
	{{0x00080103,0x00000040,0x00000000},0x1e92,0,1596},
	{{0x00080105,0x00000040,0x00000000},0x1e93,0,1596},
	{{0x00000103,0x00000240,0x00000000},0x1e94,0,1596},
	{{0x00000105,0x00000240,0x00000000},0x1e95,0,1596},
	{{0x00000000,0x00000000,0x00000000},0x24cf,1,5413},
	{{0x00000000,0x00000000,0x00000000},0x24e9,1,5413},
	{{0x00000000,0x00000000,0x00000000},0x0416,1,977},
	{{0x00000000,0x00000000,0x00000000},0x0436,1,977},
	{{0x00000000,0x00000000,0x00000000},0x0179,1,226},
	{{0x00000000,0x00000000,0x00000000},0x017a,1,226},
	{{0x00000000,0x00000000,0x00000000},0x0396,1,702},
	{{0x00000000,0x00000000,0x00000000},0x03b6,1,702},
	{{0x00000000,0x00000000,0x00000000},0x05d6,1,1207},
	{{0x00000000,0x00000000,0x00000000},0x0632,1,1207},
	{{0x00000000,0x00000000,0x00000000},0xfeaf,1,7151},
	{{0x00000000,0x00000000,0x00000000},0xfeb0,1,7155},
	{{0x00000000,0x00000000,0x00000000},0x1e92,1,1991},
	{{0x00000000,0x00000000,0x00000000},0x1e93,1,1991},
	{{0x00000000,0x00000000,0x00000000},0x017b,1,229},
	{{0x00000000,0x00000000,0x00000000},0x017c,1,229},
	{{0x00000000,0x00000000,0x00000000},0x01b5,1,272},
	{{0x00000000,0x00000000,0x00000000},0x01b6,1,272},
	{{0x00000000,0x00000000,0x00000000},0x3117,1,6832},
	{{0x00000000,0x00000000,0x00000000},0x017d,1,232},
	{{0x00000000,0x00000000,0x00000000},0x017e,1,232},
	{{0x00000000,0x00000000,0x00000000},0x0417,1,983},
	{{0x00000000,0x00000000,0x00000000},0x0437,1,983},
	{{0x00000000,0x00000000,0x00000000},0x1e90,1,1988},
	{{0x00000000,0x00000000,0x00000000},0x1e91,1,1988},
	{{0x00000000,0x00000000,0x00000000},0x1e94,1,1995},
	{{0x00000000,0x00000000,0x00000000},0x1e95,1,1995},
	{{0x40000001,0x00000000,0x00000000},0x3056,1,6585},
	{{0x00000001,0x00000020,0x00000000},0x30b6,1,6585},
	{{0x00000081,0x00000000,0x00000000},0x0638,1,1487},
	{{0x00000081,0x00000010,0x00000000},0xfec5,1,1487},
	{{0x01000081,0x00000000,0x00000000},0xfec6,1,1487},
	{{0x00000081,0x00000004,0x00000000},0xfec7,1,1487},
	{{0x00000081,0x00001000,0x00000000},0xfec8,1,1487},
	{{0x00000081,0x00000000,0x00000000},0x0632,1,1450},
	{{0x00000081,0x00000010,0x00000000},0xfeaf,1,1450},
	{{0x01000081,0x00000000,0x00000000},0xfeb0,1,1450},
	{{0x20000001,0x00000000,0x00000000},0x05d6,1,1201},
	{{0x40000001,0x00000000,0x00000000},0x305c,1,980},
	{{0x00000001,0x00000020,0x00000000},0x30bc,1,980},
	{{0x00010003,0x00000000,0x00000000},0x0417,1,980},
	{{0x00010005,0x00000000,0x00000000},0x0437,1,980},
	{{0x00000000,0x00000000,0x00000020},0x2070,0,1435},
	{{0x00000000,0x00000000,0x00000040},0x2080,0,1435},
	{{0x00004001,0x00000000,0x00000000},0x24ea,0,1435},
	{{0x00000081,0x00000000,0x00000400},0x0660,0,1435},
	{{0x00000000,0x00002000,0x00000800},0x3007,0,1435},
	{{0x08000003,0x00000000,0x00000000},0x0396,1,697},
	{{0x08000005,0x00000000,0x00000000},0x03b6,1,697},
	{{0x00000000,0x00000000,0x00000000},0x0638,1,1491},
	{{0x00000201,0x00000000,0x00000000},0x3113,1,1491},
	{{0x00000000,0x00000000,0x00000000},0xfec7,1,7247},
	{{0x00000000,0x00000000,0x00000000},0xfec5,1,7239},
	{{0x00000000,0x00000000,0x00000000},0xfec6,1,7243},
	{{0x00000000,0x00000000,0x00000000},0xfec8,1,7251},
	{{0x00010003,0x00000000,0x00000000},0x0416,1,973},
	{{0x00010005,0x00000000,0x00000000},0x0436,1,973},
	{{0x40000001,0x00000000,0x00000000},0x3058,1,6588},
	{{0x00000001,0x00000020,0x00000000},0x30b8,1,6588},
	{{0x00000000,0x00000000,0x00000000},0x05e5,1,1300},
	{{0x00000000,0x00000000,0x00000000},0x05e6,1,1300},
	{{0x00000000,0x00000000,0x00000000},0x0698,1,1300},
	{{0x40000001,0x00000000,0x00000000},0x305e,1,6594},
	{{0x00000001,0x00000020,0x00000000},0x30be,1,6594},
	{{0x40000001,0x00000000,0x00000000},0x305a,1,6591},
	{{0x00000001,0x00000020,0x00000000},0x30ba,1,6591},
#endif /* UCS_BYTE */
};
