/***************************************************************************
                          chatinformation.cpp  -  description
                             -------------------
    begin                : Sat Jan 18 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "chatinformation.h"

#include <QDateTime>



// The constructor for a user-started chat
ChatInformation::ChatInformation( MsnNotificationConnection *parent, const QString& handle,
                                  int transactionId, ConnectionType type )
 : connectionType_(type)
 , contactHandle_(handle)
 , notificationConnection_(parent)
 , port_(0)
 , requestTime_( QDateTime::currentDateTime().toTime_t() )
 , transactionId_(transactionId)
 , userStartedChat_(true)
{
}



// The constructor for a contact-started chat
ChatInformation::ChatInformation( MsnNotificationConnection *parent, const QString& handle,
                                  const QString &ip, quint16 port, const QString &authorization, const QString &chatId,
                                  ConnectionType type )
 : authorization_(authorization)
 , chatId_(chatId)
 , connectionType_(type)
 , contactHandle_(handle)
 , ip_(ip)
 , notificationConnection_(parent)
 , port_(port)
 , requestTime_( QDateTime::currentDateTime().toTime_t() )
 , transactionId_(0)
 , userStartedChat_(false)
{
}



// The destructor
ChatInformation::~ChatInformation()
{
}



// Return the switchboard authorization
const QString& ChatInformation::getAuthorization() const
{
  return authorization_;
}



// Return the contact-started chat verification id
const QString& ChatInformation::getChatId() const
{
  return chatId_;
}



// Return the handle of the contact this is a chat with
const QString& ChatInformation::getContactHandle() const
{
  return contactHandle_;
}



// Return the switchboard server ip
const QString& ChatInformation::getIp() const
{
  return ip_;
}



// Return the notification connection that spawned this object
MsnNotificationConnection * ChatInformation::getNotificationConnection() const
{
  return notificationConnection_;
}



// Return the switchboard server port
quint16 ChatInformation::getPort() const
{
  return port_;
}



// Return the time of when the SB transfer request has been sent
int ChatInformation::getTime() const
{
  return requestTime_;
}



// Return the transaction ID used in the "XFR" command.
int ChatInformation::getTransactionId() const
{
  return transactionId_;
}



// Return the switchboard connection type
ChatInformation::ConnectionType ChatInformation::getType() const
{
  return connectionType_;
}



// Return whether the user started the chat
bool ChatInformation::getUserStartedChat() const
{
  return userStartedChat_;
}



// Set server information
void ChatInformation::setServerInformation( const QString& ip, const quint16& port, const QString& authorization )
{
  ip_ = ip;
  port_ = port;
  authorization_ = authorization;
}
