/***************************************************************************
                          passivepopupview.cpp -  Displays the passive popup
                            contents
                             -------------------
    begin                : Tuesday April 10 2007
    copyright            : (C) 2007 by Valerio Pilo
    email                : amroth@coldshock.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "passivepopupview.h"

#include <qlabel.h>
#include <qpixmap.h>



// Class constructor
PassivePopupView::PassivePopupView( QWidget *parent, QString icon, QString message, QString status )
  : PassivePopupInterface(parent, "PassivePopupView")
{
  iconLoader_ = KGlobal::iconLoader();

  changeIcon( icon );
  changeStatusIcon( status );
  message_->setText( message );

  // Add a side image, the KMess Hummingbird, to make the popups identifiable
  // as belonging to KMess.
  kMessLogo_->setPixmap( iconLoader_->loadIcon( "kmess", KIcon::Desktop, KIcon::SizeHuge ) );
}



// Changes the popup icon
void PassivePopupView::changeIcon( QString icon )
{
  QPixmap picture;

  // If the specified icon is not valid, we'll use the KMess icon
  if( ! picture.load( icon ) )
  {
    picture = iconLoader_->loadIcon( "kmesspic", KIcon::User );
  }

  displayPicture_->setPixmap( picture );
}



// Changes the popup status icon
void PassivePopupView::changeStatusIcon( QString status )
{
  if( status.isNull() || status.isEmpty() )
  {
    return;
  }

  if     ( status == "AWY" ) status = "away";
  else if( status == "BRB" ) status = "berightback";
  else if( status == "BSY" ) status = "busy";
  else if( status == "FLN" ) status = "offline";
  else if( status == "HDN" ) status = "invisible";
  else if( status == "IDL" ) status = "away";
  else if( status == "LUN" ) status = "lunch";
  else if( status == "PHN" ) status = "onthephone";
  else                       status = "online";

  statusPixmap_->setPixmap( iconLoader_->loadIcon( status, KIcon::User ) );
}



// Changes the popup message
void PassivePopupView::changeMessage( QString message )
{
  message_->setText( message );
}



#include "passivepopupview.moc"
