/***************************************************************************
                          soapmessage.h  -  description
                             -------------------
    begin                : Sun Sep 25 2005
    copyright            : (C) 2005 by Diederik van der Boor
    email                : vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SOAPMESSAGE_H
#define SOAPMESSAGE_H

#include <qobject.h>
#include <qdom.h>
#include <qmap.h>
#include <qstring.h>
#include <qstringlist.h>


/**
 * A class to parse SOAP messages.
 * These messages can be sent to a remote server with the HttpSoapConnection class.
 *
 * @author Diederik van der Boor
 * @ingroup NetworkSoap
 */
class SoapMessage
{
  public:  // public methods
    // The constructor to create messages
                         SoapMessage();
    // The constructor to parse incoming messages
                         SoapMessage(const QString &message);
    // The destructor
    virtual             ~SoapMessage();

    // Add a field to the message
    void                 addField(const QString& field, const QString& value);
    // Sets the field in the message, or adds it if it doesn't exist.
    void                 setField(const QString& field, const QString& value);
    // Return the action type
    const QString&       getAction() const;
    // Return the action type namespace prefix
    const QString&       getActionPrefix() const;
    // Return the action type namespace
    const QString&       getActionNamespace() const;
    // Return the error code
    int                  getErrorCode() const;
    // Return the error description
    const QString&       getErrorDescription() const;
    // Return the entire message as string
    QString              getMessage() const;
    // The total number of fields
    uint                 getNoFields() const;
    // Get a value given a field
    const QString&       getValue(const QString& field) const;
    // Return the response xml tree
    const QDomNode&      getResponseBody() const;
    // Test whether a given field exists in the message
    bool                 hasField(const QString& field) const;

    // Return whether this was an error response
    bool                 isErrorMessage() const;

    // Set the message type
    void                 setAction(const QString &action,
                                   const QString &prefix = QString::null,
                                   const QString &xmlns = QString::null);


  private:  // Protected methods
    // Helper function, get a specific node
    QDomNode             getNode(const QDomNode &rootNode, const QString &path) const;
    // Helper function, get the text value of a node
    QString              getNodeValue(const QDomNode &rootNode, const QString &path) const;
    // Parse the incoming message
    void                 parseMessage(const QString &message);

  private:
    // The error code from the soap response
    int                  errorCode_;
    // The error description from the soap response
    QString              errorDescription_;

    // The message type
    QString              action_;
    // The xml namespace prefix for the message
    QString              actionPrefix_;
    // The xml namespace
    QString              actionNs_;

    // The message fields
    QStringList          fields_;
    // The message values (corresponding to the fields)
    QStringList          values_;

    // The result nodes
    QDomNode             responseBody_;
};

#endif
