/***************************************************************************
                          msnappdirectoryservice.h -  description
                             -------------------
    begin                : Sun Sep 25 2005
    copyright            : (C) 2005 by Diederik van der Boor
    email                : vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MSNAPPDIRECTORYSERVICE_H
#define MSNAPPDIRECTORYSERVICE_H

#include <qobject.h>
#include <qptrlist.h>

#include "httpsoapconnection.h"

class QDomElement;

/**
 * Wrapper for SOAP calls to the MSN application directory service.
 *
 * @author Diederik van der Boor
 * @ingroup NetworkSoap
 */
class MsnAppDirectoryService : public HttpSoapConnection
{
  Q_OBJECT

  public:
    // Types of service listings to request
    enum MsnAppDirectoryServiceType { GAMES, ACTIVITIES };

    struct Entry
    {
      int     entryId;
      QString subscriptionUrl;
      QString error;
      QString locale;
      bool    kids;
      int     page;
      int     categoryId;
      QString sequence;
      QString name;
      QString description;
      QString url;
      QString iconUrl;
      QString appIconUrl;
      int     passportSiteId;
      QString type;
      int     height;
      int     width;
      QString location;
      int     minUsers;
      int     maxUsers;
      bool    enableIp;
      bool    activeX;
      bool    sendFile;
      bool    receiveIM;
      bool    replaceIM;
      bool    windows;
      int     maxPacketRate;
      bool    userProperties;
      QString clientVersion;
      int     appType;
      bool    hidden;
    };

  public:  // public methods
    // The constructor
                         MsnAppDirectoryService( QObject *parent = 0 );
    // The destructor
    virtual             ~MsnAppDirectoryService();

    // Return an application entry with a certain ID
    const Entry *        getEntryById(int entryId);
    // Return all entries
    const QPtrList<Entry>& getEntries() const;
    // Request a list of all services
    void                 queryServiceList(MsnAppDirectoryServiceType type);

  private:
    // Process server responses
    void                 parseSoapResult( const QDomElement &resultRoot, const QDomElement &headerNode );


  private:
    // A list of all received entries
    QPtrList<Entry>      entries_;
};

#endif
