/***************************************************************************
                          msnappdirectoryservice.cpp -  description
                             -------------------
    begin                : Sun Sep 25 2005
    copyright            : (C) 2005 by Diederik van der Boor
    email                : vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "msnappdirectoryservice.h"

#include "httpsoapconnection.h"
#include "soapmessage.h"

#include "../extra/xmlfunctions.h"
#include "../../kmessdebug.h"

#ifdef KMESSDEBUG_APPDIRECTORYSERVICE
#define KMESSDEBUG_APPDIRECTORYSERVICE_GENERAL
#endif


// Constructor
MsnAppDirectoryService::MsnAppDirectoryService( QObject *parent )
  : HttpSoapConnection("http://appdirectory.messenger.msn.com/AppDirectory/AppDirectory.asmx", parent, "MsnAppDirectoryService")
{
#ifdef KMESSDEBUG_APPDIRECTORYSERVICE_GENERAL
  kdDebug() << "CREATED MsnAppDirectoryService" << endl;
#endif
}



// Destructor
MsnAppDirectoryService::~MsnAppDirectoryService()
{
#ifdef KMESSDEBUG_APPDIRECTORYSERVICE_GENERAL
  kdDebug() << "DESTROYED MsnAppDirectoryService" << endl;
#endif
}



// Return an application entry with a certain ID
const MsnAppDirectoryService::Entry * MsnAppDirectoryService::getEntryById(int entryId)
{
  QPtrListIterator<Entry> it(entries_);
  while(! it.atLast())
  {
    if(it.current()->entryId == entryId)
    {
      return it.current();
    }

    ++it;
  }

  return 0;
}



// Return all entries
const QPtrList<MsnAppDirectoryService::Entry>& MsnAppDirectoryService::getEntries() const
{
  return entries_;
}



// A soap request finished
void MsnAppDirectoryService::parseSoapResult( const QDomElement &resultRoot, const QDomElement &headerNode )
{
  Q_UNUSED( headerNode ); // Avoid compiler warning

#ifdef KMESSDEBUG_APPDIRECTORYSERVICE_GENERAL
  kdDebug() << "MsnAppDirectoryService: Got query response" << endl;
#endif

  // Parse the list of result entries
  QDomNode     dataSet = XmlFunctions::getNode( resultRoot, "diffgram/NewDataSet" );
  QDomNodeList entries = dataSet.childNodes();
  for(uint i = 0; i < entries.count(); i++)
  {
    QDomNode entryProperties = entries.item(i);

    int entryId = XmlFunctions::getNodeValue(entryProperties, "EntryID").toInt();
    if(getEntryById(entryId) != 0)
    {
      // Ignore entries that are already present
      continue;
    }

    // Fill the values
    Entry *entry = new Entry;
    entry->entryId         = entryId;
    entry->subscriptionUrl = XmlFunctions::getNodeValue(entryProperties, "SubscriptionURL");
    entry->error           = XmlFunctions::getNodeValue(entryProperties, "Error");
    entry->locale          = XmlFunctions::getNodeValue(entryProperties, "Locale");
    entry->kids            = XmlFunctions::getNodeValue(entryProperties, "Kids") == "1";
    entry->page            = XmlFunctions::getNodeValue(entryProperties, "Page").toInt();
    entry->categoryId      = XmlFunctions::getNodeValue(entryProperties, "CategoryID").toInt();
    entry->sequence        = XmlFunctions::getNodeValue(entryProperties, "Sequence");
    entry->name            = XmlFunctions::getNodeValue(entryProperties, "Name");
    entry->description     = XmlFunctions::getNodeValue(entryProperties, "Description");
    entry->url             = XmlFunctions::getNodeValue(entryProperties, "URL");
    entry->iconUrl         = XmlFunctions::getNodeValue(entryProperties, "IconURL");
    entry->appIconUrl      = XmlFunctions::getNodeValue(entryProperties, "AppIconURL");
    entry->passportSiteId  = XmlFunctions::getNodeValue(entryProperties, "PassportSiteID").toInt();
    entry->type            = XmlFunctions::getNodeValue(entryProperties, "Type");
    entry->height          = XmlFunctions::getNodeValue(entryProperties, "Height").toInt();
    entry->width           = XmlFunctions::getNodeValue(entryProperties, "Width").toInt();
    entry->location        = XmlFunctions::getNodeValue(entryProperties, "Location");
    entry->minUsers        = XmlFunctions::getNodeValue(entryProperties, "MinUsers").toInt();
    entry->maxUsers        = XmlFunctions::getNodeValue(entryProperties, "MaxUsers").toInt();
    entry->enableIp        = XmlFunctions::getNodeValue(entryProperties, "EnableIP")       == "True";
    entry->activeX         = XmlFunctions::getNodeValue(entryProperties, "ActiveX")        == "True";
    entry->sendFile        = XmlFunctions::getNodeValue(entryProperties, "SendFile")       == "True";
    entry->receiveIM       = XmlFunctions::getNodeValue(entryProperties, "ReceiveIM")      == "True";
    entry->replaceIM       = XmlFunctions::getNodeValue(entryProperties, "ReplaceIM")      == "True";
    entry->windows         = XmlFunctions::getNodeValue(entryProperties, "Windows")        == "True";
    entry->maxPacketRate   = XmlFunctions::getNodeValue(entryProperties, "MaxPacketRate").toInt();
    entry->userProperties  = XmlFunctions::getNodeValue(entryProperties, "UserProperties") == "True";
    entry->clientVersion   = XmlFunctions::getNodeValue(entryProperties, "ClientVersion");
    entry->appType         = XmlFunctions::getNodeValue(entryProperties, "AppType").toInt();
    entry->hidden          = XmlFunctions::getNodeValue(entryProperties, "Hidden")         == "True";

#ifdef KMESSDEBUG_APPDIRECTORYSERVICE_GENERAL
    kdDebug() << "MsnAppDirectoryService: Received entry " << entry->name << "." << endl;
#endif

    // Add to the list
    entries_.append( entry );
  }

#ifdef KMESSDEBUG_APPDIRECTORYSERVICE_GENERAL
  kdDebug() << "MsnAppDirectoryService: Emitting that request was successful" << endl;
#endif
}



// Request a list of all services
void MsnAppDirectoryService::queryServiceList(MsnAppDirectoryServiceType type)
{
#ifdef KMESSDEBUG_APPDIRECTORYSERVICE_GENERAL
  kdDebug() << "MsnAppDirectoryService: Querying service list" << endl;
#endif

  SoapMessage message;
  message.setAction("GetFilteredDataSet2", QString::null,
                    "http://www.msn.com/webservices/Messenger/Client");
  message.addField("locale",  "en-us");
  message.addField("Page",    "1");
  message.addField("Kids",    "-1");
  message.addField("AppType", QString::number(type)); // 0=games, 1=activities

  sendRequest("http://www.msn.com/webservices/Messenger/Client/GetFilteredDataSet2", message);
}


#include "msnappdirectoryservice.moc"
