/***************************************************************************
                          multipacketmessage.h -  description
                             -------------------
    begin                : Thu May 23 2005
    copyright            : (C) 2006 by Diederik van der Boor
    email                : "vdboor" --at-- "codingdomain.com"
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MULTIPACKETMESSAGE_H
#define MULTIPACKETMESSAGE_H

#include "mimemessage.h"

#include <qdatetime.h>
#include <qbuffer.h>

/**
 * @author Diederik van der Boor
 */
class MultiPacketMessage
{
  public: // public methods

    // The constructor
                           MultiPacketMessage();

    // The destructor
    virtual               ~MultiPacketMessage();

    // Add a message to the part
    void                   addChunk( const MimeMessage &message );
    // Returh the complete message
    const MimeMessage    & getMessage() const;
    // Return whether the full message is received
    bool                   isComplete() const;

  private:
    // The buffer for the data
    QBuffer                buffer_;
    // The number of chunks the message consists of
    int                    chunks_;
    // The last chunk received.
    int                    lastChunk_;
    // The message ID
    QString                messageId_;
    // The result message
    MimeMessage            result_;

};


#endif
