/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Sun Jan  5 15:18:36 CST 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "kmess.h"
#include "kmesstest.h"
#include "kmessdebug.h"
#include "kmessapplication.h"

#ifdef HAVE_CONFIG_H
 #include "config.h"
#endif

#ifdef ENABLE_BINRELOC
// Required for autopackage support.
// Handles detection of paths at run time.
#include "binreloc.h"
#endif

#include <qstringlist.h>
#include <kstandarddirs.h>
#include <kiconloader.h>

// Command line options
static KCmdLineOptions kmessOptions[] =
{
  { "autologin ", I18N_NOOP("Autologin with the given email address"), 0 },
  { 0, 0, 0 }
};


// Main starting point of the application
int main(int argc, char *argv[])
{
  // Tab 1: General
  KAboutData aboutData( "kmess",                 /* internal app name */
                        I18N_NOOP("KMess"),      /* real program name */
                        VERSION,                 /* app version (from config.h, generated with Makefile.am) */
                        "KMess",                 /* description of the app */
                        KAboutData::License_GPL, /* license */
                        "(c) 2002-2008, Mike K. Bennett\n"         /* copyright */
                        "(c) 2005-2008, Diederik van der Boor\n"
                        "(c) 2007-2008, Valerio Pilo\n",
                        "A MSN Messenger client for KDE",          /* free form text */
                        "http://www.kmess.org/",                   /* project home page */
                        "codingdomain" "@" "users.sourceforge.net" /* address for bugs */
                      );

  // Note all e-mail addresses are written in an anti-spam style.

  // Tab 2: Authors
  // TODO: escape the special characters to some Unicode format. (how?)
  aboutData.addAuthor( "Mike K. Bennett",       0, "mkb137"           "@" "users.sourceforge" "." "net" );
  aboutData.addAuthor( "Michael Curtis",        0, "mdcurtis"         "@" "users.sourceforge" "." "net" );
  aboutData.addAuthor( "Jan Tönjes",            0, "jan" ".toenjes"   "@" "web" "." "de" );
  aboutData.addAuthor( "Diederik van der Boor", 0, "vdboor"           "@" "codingdomain" "." "com" );
  aboutData.addAuthor( "Richard Conway",        0, "richard" "conway" "@" "users.sourceforge" "." "net" );
  aboutData.addAuthor( "Valerio Pilo",          0, "amroth"           "@" "coldshock" "." "net" );

  // Tab 3: Credits
  aboutData.addCredit("Jan Tönjes",                I18N_NOOP("German translation, testing, documentation, web master, project management, etc..."), "jan" "." "toenjes" "@" "web" "." "de");
  aboutData.addCredit("Dane Harnett",              I18N_NOOP("Web design"),                     "dynamitedane" "@" "hotmail" "." "com");
  aboutData.addCredit("David Vignoni",             I18N_NOOP("The main and yellow/blue/violet emoticon sets and Italian translation"), "dvgn" "@" "libero" "." "it");
  aboutData.addCredit("Julien Joubin",             I18N_NOOP("Cartoon emoticons"),               "jujubinche" "@" "netscape" "." "net");
  aboutData.addCredit("Christian Müller",          I18N_NOOP("Default sound theme"),             "cmue81" "@" "gmx" "." "de");

  // Translations
  // Sorted by Alphabetic order of language.
  aboutData.addCredit("Mohamed Aser",              I18N_NOOP("Arabic translation, internationalization of file saving fix" "." ""), "mohasr" "@" "link" "." "net");
  aboutData.addCredit("Youssef Chahibi",           I18N_NOOP("More Arabic translation"),         "chahibi" "@" "gmail" "." "com");
  aboutData.addCredit("Mauricio Rother",           I18N_NOOP("Brazilian Portuguese translation"), "mauricio" "@" "digicomm" "." "com.br");
  aboutData.addCredit("Jaume Cornadó",             I18N_NOOP("Catalan translation"),              "jaumec" "@" "lleida" "." "net");

  aboutData.addCredit("Lin Haoxiang",              I18N_NOOP("Simplified Chinese translation, file send bug fix, proxy connect code"), "linhaoxiang" "@" "hotmail" "." "com");
  aboutData.addCredit("Liu Sizhuang",              I18N_NOOP("More Simplified Chinese translation"),  "chinatslsz" "@" "hotmail.com");
  aboutData.addCredit("Yen-chou Chen",             I18N_NOOP("Traditional Chinese translation"),  "yenchou" "." "mse90" "@" "nctu" "." "edu" "." "tw");

  aboutData.addCredit("Lars Sommer",               I18N_NOOP("Danish translation"),               "admin" "@" "lasg" "." "dk");
  aboutData.addCredit("Pascal d'Hermilly",         I18N_NOOP("More Danish translation"),          "pascal" "@" "tipisoft" "." "dk");
  aboutData.addCredit("Arend van Beelen Jr.",      I18N_NOOP("Dutch translation"),               "arend" "@" "auton" "." "nl");
  aboutData.addCredit("Jaap Woldringh",            I18N_NOOP("More Dutch translation"),          "jjh" "." "woldringh" "@" "planet" "." "nl");

  aboutData.addCredit("Jyri Toomessoo",            I18N_NOOP("Estonian translation"),             "nuubik" "@" "hotmail" "." "com");
  aboutData.addCredit("Markus Vuori",              I18N_NOOP("Finnish translation"),              "markus" "@" "vuoret" "." "net");
  aboutData.addCredit("Joonas Niilola",            I18N_NOOP("More Finnish translation"),         "juippis" "@" "roskakori" "." "org");
  aboutData.addCredit("Jussi Timperi",             I18N_NOOP("More Finnish translation"),         "jussi.timperi" "@" "gmail" "." "com");

  aboutData.addCredit("Choplair",                  I18N_NOOP("French translation"),              "pachilor" "@" "yahoo" "." "co" "." "jp");
  aboutData.addCredit("Vincent Fretin",            I18N_NOOP("More French translation, MSN6 emoticon definitions"), "fretinvincent" "@" "hotmail" "." "com");
  aboutData.addCredit("Andrea Blankenstijn",       I18N_NOOP("More French translation"),         "darkan9el" "@" "gmail" "." "com" ); // or "andrea" "@" "zenephiris" "." "ch"

  aboutData.addCredit("Páder Rezsõ",               I18N_NOOP("Hungarian translation"),            "rezso" "@" "rezso" "." "net");
  aboutData.addCredit("Valerio Pilo",              I18N_NOOP("More Italian translation"),        "amroth" "@" "coldshock" "." "net");
  aboutData.addCredit("Vincenzo Reale",            I18N_NOOP("More Italian translation"),        "smart2128" "@" "baslug" "." "org");
  aboutData.addCredit("Park Dong Cheon",           I18N_NOOP("Korean translation"),              "pdc" "@" "kaist" "." "ac.kr");
  aboutData.addCredit("Øyvind Sæther",             I18N_NOOP("Norsk Bokmål translation"),         "oyvind" "@" "sather" "." "tk");

  aboutData.addCredit("Matjaž kaše",               I18N_NOOP("Slovenian translation"),          "matjaz" "." "kase" "@" "g-kabel" "." "si");
  aboutData.addCredit("Johanna Gersch",            I18N_NOOP("Spanish translation"));
  aboutData.addCredit("J.C.A. Javi",               I18N_NOOP("More Spanish translation"),        "yovoya30ks" "@" "hotmail" "." "com");
  aboutData.addCredit("Alejandro Araiza Alvarado", I18N_NOOP("More Spanish translation"),        "mebrelith" "@" "gmail" "." "com");
  aboutData.addCredit("Jaume Corbí",               I18N_NOOP("More Spanish translation"),        "jaume4" "@" "gmail" "." "com");
  aboutData.addCredit("Christian Kaiser",          I18N_NOOP("More Spanish translation"),        "k39" "@" "users" "." "sourceforge" "." "net");
  aboutData.addCredit("Christian Lundgren",        I18N_NOOP("Swedish translation"),            "zeflunk" "@" "gmail" "." "com");

  aboutData.addCredit("Rachan Hongpairote",        I18N_NOOP("Thai translation"),                 "rachanh" "@" "yahoo" "." "com");
  aboutData.addCredit("Gorkem Cetin",              I18N_NOOP("Turkish translation"),            "gorkem" "@" "gelecek" "." "com" "." "tr");
  aboutData.addCredit("Barbaros Ulutas",           I18N_NOOP("More Turkish translation"),        "ulutas" "@" "gmail" "." "com");
  aboutData.addCredit("Uğur Çetin",                I18N_NOOP("More Turkish translation"),        "ugur" "." "jnmbk" "@" "gmail" "." "com");

  // Other contributors
  aboutData.addCredit("Liu Sizhuang",              I18N_NOOP("P4-Context field support"),        "chinatslsz" "@" "hotmail.com");
  aboutData.addCredit("Scott Morgan",              I18N_NOOP("Xinerama fixes"),                  "blumf" "@" "blumf" "." "freeserve" "." "co" "." "uk");
  aboutData.addCredit("Laurence Anderson",         I18N_NOOP("Original file receive code"),      "l.d" "." "anderson" "@" "warwick" ".ac.uk");
  aboutData.addCredit("Choe Hwanjin",              I18N_NOOP("Various internationalization fixes" "." ""), "hjchoe" "@" "hancom" "." "com");
  aboutData.addCredit("Damien Sandras",            I18N_NOOP("GnomeMeeting developer"),          "dsandras" "@" "seconix" "." "com");
  aboutData.addCredit("Tobias Tönjes",             I18N_NOOP("Guy with a bag over his head"),    "");

  // Other apps
  aboutData.addCredit("KMerlin (kmerlin.olsd.de)", I18N_NOOP("Inspiration and assorted code"));
  aboutData.addCredit("Kopete (kopete.kde.org)",   I18N_NOOP("Old popup balloons code, initial p2p code, msn challenge handler"));
  aboutData.addCredit("KScreensaver",              I18N_NOOP("Idle timer code"));

  // Nice community detail (very subtle at the bottom..)
  aboutData.addCredit( I18N_NOOP("Your name here?"), I18N_NOOP("You are welcome to sent bugfixes and patches to the KMess help forums!\nIf you feel your name is missing here, please contact us too!"), "you@kmess.org");

  // Add the translation names from the .po file:
  aboutData.setTranslator(I18N_NOOP("_: NAME OF TRANSLATORS\nYour names"),I18N_NOOP("_: EMAIL OF TRANSLATORS\nYour emails"));


  // Register the command line parameters
  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( kmessOptions );


  // Fetch the command line arguments
  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
  QString autologinHandle = args->getOption("autologin");


  // Create the KApplication object
  KMessApplication a;


#ifdef ENABLE_BINRELOC
  // Register run-time detected paths for Autopackage support.
  // This also prevents the "square boxes images" problem from happening
  // if the --prefix of ./configure was incorrect.
  BrInitError brError;
  if( br_init( &brError ) == 0 && brError != BR_INIT_ERROR_DISABLED)
  {
    kdWarning() << "BinReloc failed to initialize (error code " << brError << ")" << endl;
    kdDebug()   << "Will fallback to hardcoded compile-time path (" << KMESS_PREFIX << ")." << endl;
  }

  // Detect run-time paths, fallback to KMESS_PREFIX of configure
  KGlobal::dirs()       -> addPrefix( br_find_prefix( KMESS_PREFIX ) );
  KGlobal::iconLoader() -> addAppDir( br_find_data_dir( KMESS_PREFIX "/share" ) );
#else
  // Add compile time paths as fallback
  KGlobal::dirs()       -> addPrefix( KMESS_PREFIX );
  KGlobal::iconLoader() -> addAppDir( KMESS_PREFIX "/share" );
#endif

  // Test whether the prefix is correct.
  if( KGlobal::dirs()->findResource( "appdata", "pics/kmesslogo.png" ).isNull() )
  {
    kdWarning() << "KMess could not find resources in the search paths: "
                << KGlobal::dirs()->findDirs( "appdata", QString::null ).join(", ") << endl;
  }

  // For KDE 3.3 and below, add the prefix for emoticons (only available as of KDE 3.4)
  if( ! KGlobal::dirs()->allTypes().contains("emoticons") )
  {
    KGlobal::dirs()->addResourceType("emoticons", "share/emoticons");
  }


  // Create the main window  (inherits KMessInterface and KMainWindow)
  KMess *kmess = new KMess(0, "mainwindow");

  // Initialize the main window
  if( kmess->initialize() )
  {
    // Set as main widget
    a.setMainWidget(kmess);

    // Avoid showing the main window is KMess is started with KDE.
    if( ! kapp->isRestored() )
    {
      kmess->show();
    }

    // Start auto login
    kmess->checkAutologin( autologinHandle );

 /*
    // For debugging:
#ifdef KMESSTEST
    KMessTest *kmessTest = new KMessTest(kmess);
    kmessTest->test();
    delete kmessTest;
#endif
 */
  }

  // Start the application + event loop
  return a.exec();
}
