/***************************************************************************
                          kmesslistviewitem.cpp  -  description
                             -------------------
    begin                : Fri Mar 28 2003
    copyright            : (C) 2003 by Mike K. Bennett
                           (C) 2005 by Diederik van der Boor
    email                : mkb137b@hotmail.com
                           vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmesslistviewitem.h"

#include "kmessdebug.h"

#include <qcolor.h>
#include <qmime.h>
#include <qpainter.h>
#include <qregexp.h>
#include <qsimplerichtext.h>

#include <kdebug.h>

#ifdef KMESSDEBUG_KMESSLISTVIEWITEM
#define KMESSDEBUG_KMESSLISTVIEWITEM_GENERAL
#endif


// The constructor
KMessListViewItem::KMessListViewItem(QListView *parent)
 : QListViewItem( parent ),
   richText_(0),
   htmlText_(QString("")),
   listParent_(parent)
{
  setMultiLinesEnabled( false );
  updateAppearance();
}



// The constructor
KMessListViewItem::KMessListViewItem(QListViewItem *parent)
 : QListViewItem( parent ),
   richText_(0),
   htmlText_(QString("")),
   listParent_(0)
{
  setMultiLinesEnabled( false );
  updateAppearance();
}



// The destructor
KMessListViewItem::~KMessListViewItem()
{
  if( richText_ != 0 ) delete richText_;
}



// Change the text displayed by this item
void KMessListViewItem::setText( const QString &text )
{
  htmlText_ = QString( text );
  updateAppearance();
}



// Change the text used as sorting key by the parent QListView
void KMessListViewItem::setKey( const QString &key )
{
  // Set the item's text, this will only be used as sorting key and not displayed
  QListViewItem::setText( 0, key );
}



// // Compare
// int KMessListViewItem::compare( QListViewItem *item, int /* col */, bool /* asc */) const
// {
// #ifdef KMESSTEST
//   ASSERT( dynamic_cast<KMessListViewItem *>(item) != 0 );
// #endif
//
//   int thisType = this->getType(); // Is overwritten in sub classes
//   int thatType = static_cast<KMessListViewItem *>(item) -> getType();
//
//   if(thisType == thatType)         return  0; // Equal.
//   if(thisType == LISTTYPE_CONTACT) return -1; // Contact is smaller, show individual contacts above the groups.
//   return 1; // "Group" and "base" are greather, sort at the bottom.
// }



// Return the type ID
int KMessListViewItem::getType() const
{
  return LISTTYPE_BASE;
}



// Paint a cell (column 0, always) - this allows us emoticons, through QSimpleRichText
void KMessListViewItem::paintCell( QPainter *painter, const QColorGroup &colourGroup, int column, int width, int align )
{
  // Columns other than the contacts' one are displayed normally
  if( column != 0 )
  {
    QListViewItem::paintCell( painter, colourGroup, column, width, align );
    return;
  }

  // We need to change the cell's colors, to prevent the original text from displaying:
  // this is required due to the QSimpleRichText widget that we're putting over the cell
  QColorGroup customColourGroup = QColorGroup( colourGroup );

  // Hide the sorting key text, both when selected and normal items are being painted
  if( isSelected() )
  {
    // Hide it using the selection bar's color
    customColourGroup.setColor( QColorGroup::HighlightedText, colourGroup.color( QColorGroup::Highlight ) );
  }
  else
  {
    // Hide it using a transparent color
    customColourGroup.setColor( QColorGroup::Text, QColor( qRgba( 255,255,255,0 ) ) );
  }

  // Repaint the cell - with the transparent text
  QListViewItem::paintCell( painter, customColourGroup, column, width, align );

  // Redraw the rich text
  richText_->draw( painter, listView()->itemMargin(), 0, QRect( 0, 0, width, height() ), colourGroup, 0 );

  // Fit the cell to the rich text's height
  setHeight( richText_->height() );
}



// Recreate the rich text
void KMessListViewItem::updateAppearance()
{
  // Delete the existing rich text
  if ( richText_ != 0 )
  {
    delete richText_;
    richText_ = 0;
  }

  // Create a new rich text object
  richText_ = new QSimpleRichText( "<qt><nobr>" + htmlText_ + "</nobr></qt>", listView()->viewport()->font() );
  // TODO: use the QMimeSourceFactory parameter to load all graphics only once.

  // Avoid using widthUsed() since that breaks with right-aligned text (right-to-left languages).
  richText_->setWidth( 0 );

  // Tell the listview to re-calculate it's width
  widthChanged(0);

  repaint();
}


// Re-sort the parent nodes
void KMessListViewItem::resortParent()
{
  // Ask parent to re-run the sorting algorithm
  if(QListViewItem::parent() != 0)
  {
    QListViewItem::parent()->sort();
  }
  else if(listParent_ != 0)
  {
    // FIXME: remove this if the QListViewItem::parent() also works for listviews
    listParent_->sort();
  }
#ifdef KMESSDEBUG_KMESSLISTVIEWITEM_GENERAL
  else
  {
    kdDebug() << "KMessListViewItem::resortParent: No parent found!" << endl;
  }
#endif
}



// returns the width of the text in the column
int KMessListViewItem::width( const QFontMetrics & fm, const QListView * lv, int c) const
{
  if(c == 0)
  {
    return richText_->width();
  }

  return QListViewItem::width( fm, lv, c );
}
