/***************************************************************************
                          kmessapplication.cpp -  description
                             -------------------
    begin                : Wed 7 13 2005
    copyright            : (C) 2005 by Diederik van der Boor
    email                : vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmessapplication.h"


// Constructor
KMessApplication::KMessApplication()
  : KApplication()
  , savingSession_(false)
  , quitSelected_(false)
{
  // This class subclasses KApplication so we can
  // add the sessionSaving() method for KDE 3.1 compatibility

  // KMessApplication is created from main.cpp,
  // and the "KMess" class (inheriting KMessInterface, KMainWindow)
  // is set as main widget.
}


// Destructor
KMessApplication::~KMessApplication()
{

}



#if KDE_IS_VERSION(3,1,1)
  // KDE has a sessionSaving() method
#else

  // QApplication wants to save the session
  void KMessApplication::commitData(QSessionManager &sm)
  {
    // Set a boolean, just like the KApplication::commitData() source does as of KDE 3.1.1

    // I've also attempted to use KSessionManaged::commitData(). While the KSessionManaged
    // class is supposed eliminate the need to subclass KApplication, it can't be used here.
    // Somehow KSessionManaged::commitData() is called after KMainWindow::queryExit()
    // ..and the whole point of the sessionSaving() call is being called from queryExit() !!
    savingSession_ = true;

    // Do the original commit
    KApplication::commitData(sm);

    savingSession_ = false;
  }


  // Return true if we're saving the session (for queryExit())
  bool KMessApplication::sessionSaving() const
  {
    // This is called from KMess::queryExit()
    return savingSession_;
  }

#endif



// Return true if quit was selected
bool KMessApplication::quitSelected() const
{
  return quitSelected_;
}



// Tell the application that quit was selected
void KMessApplication::setQuitSelected(bool quitSelected)
{
  quitSelected_ = quitSelected;
}

