/***************************************************************************
                          group.h  -  description
                             -------------------
    begin                : Sun Jan 5 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GROUP_H
#define GROUP_H

#include <qobject.h>

// Forward declarations
class KConfig;


/**
 * @brief Data class for group information.
 *
 * This class is only used to store group information.
 * the information is changed by the MsnNotificationConnection
 * and user interface classes. The user interface classes
 * respond to the signals sent by this class to update their view.
 * In the contact list view, this class is represented by the GroupListViewItem class.
 *
 * @author Mike K. Bennett
 * @ingroup Contact
 */
class Group : public QObject
{
  Q_OBJECT

  public: // Public methods
    // The constructor
                         Group(QString id, QString name);
    // The destructor
                        ~Group();
    // Return the group ID
    const QString&       getId() const;
    // Return the group name
    const QString&       getName() const;
    // Return the sort value
    int                  getSortPosition() const;
    // Return true if this group is expanded.
    bool                 isExpanded() const;
    // Return true if this is a special group
    bool                 isSpecialGroup() const;
    // Save group properties
    void                 saveProperties(KConfig *config);
    // Change the group name
    void                 setName(const QString& newName);
    // Change the sort position
    void                 setSortPosition(int sortPosition);
    // Change the expanded state
    void                 setExpanded(bool expanded);

  private: // Private methods
    // Read in group properties
    void                 readProperties();

  private: // Private attributes
    // The group id
    QString              id_;
    // The group's expanded state
    bool                 isExpanded_;
    // True if the group is a special group
    bool                 isSpecialGroup_;
    // The group name
    QString              name_;
    // The group's sort value
    int                  sortPosition_;

  signals: // Public signals
    // The expanded state was changed
    void                 expandedStateChanged();
    // The name was changed
    void                 nameChanged();
    // The sorting index was changed
    void                 sortPositionChanged();

};

#endif
