# kcmnvview.spec
#
# $Id: kcmnvview.spec,v 1.3 2007/05/28 12:40:36 heinemann Exp $
#
# @since 27.05.2007 Undefined
# @modified 28.05.2007 Undefined
#
# rpmbuild -ba SPECS/kcmnvview.spec
#

%define version      0.3
%define packagename  kcmnvview-%{version}
%define suse         %(if [ "%{_host_vendor}" == suse ] ; then echo 1; else echo 0; fi)
%define _kdeprefix   %(kde-config --prefix)
%define _kdeminver   3.5.0
%define _qtminver    3.3.6
%define debug        no
%define numcpus      -j%(getconf -v POSIX_V6_ILP32_OFF32 _NPROCESSORS_CONF)

Name:           kcmnvview
Summary:        KDE Controlcenter Module for Displaying Nvidia Options
Version:        %{version}
Release:        %{_host_vendor}
%if %suse
Group:          System/GUI/KDE
%else
Group:          Applications/Productivity
%endif
License:        GPL
Autoreq:        no
Url:            http://%{name}.hjcms.de
Source0:        %{_sourcedir}/%packagename.tar.bz2
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
Obsoletes:      nvview
Provides:       kcm_nvview
%if %suse
Requires:       kdelibs3 >= %{_kdeminver}, kdebase3 >= %{_kdeminver}
BuildRequires:  qt3-devel >= %{_qtminver}, lsb, gettext-devel
BuildRequires:  kdelibs3-devel >= %{_kdeminver}
BuildRequires:  kdebase3-devel >= %{_kdeminver}
%else
Requires:       kdelibs >= %{_kdeminver}, kdebase >= %{_kdeminver}
BuildRequires:  qt-devel >= %{_qtminver}, lsb, gettext-devel
BuildRequires:  kdelibs-devel >= %{_kdeminver}
BuildRequires:  kdebase-devel >= %{_kdeminver}
%endif
Vendor:         Undefined <heinemann(DOT)juergen(AT)hjcms(DOT)de>
Packager:       %{vendor}
Distribution:   %(lsb_release -i | awk -F: '{print $2}')
ExclusiveArch:  i386 i586 i686 athlon
BuildArch:      %{_arch}
Exclusiveos:    %{_os}
Prefix:         %{_kdeprefix}

%description
KControl Center Modul for Display NVidia Kernel and AGP Options!
Build with KDE Version %(kde-config --version)
Developer: %{vendor}

%if %suse
%debug_package
%endif

%prep
rm -rf %{buildroot}

%setup -q -n %packagename

test -x configure || {
  UNSERMAKE=no %__make -f admin/Makefile.common dist
}

%build

CXXFLAGS="-O0 -march=%{_arch}" \
./configure --host=%{_host} --build=%{_build} \
  --target=%{_target_platform}  --program-suffix=%{?_program_prefix} \
  --prefix=%{_kdeprefix} --bindir=%{_kdeprefix}/bin \
  --datadir=%{_kdeprefix}/share --disable-rpath \
  --enable-optimized --enable-debug=%debug \
  --without-arts

%__make %{numcpus}

%install
rm -rf %{buildroot}
%__mkdir_p %{buildroot}%{_kdeprefix}

%makeinstall

%post
%postun

%files
%defattr(-, root, root)
## modul
%attr(0755,root,root) %{_kdeprefix}/lib/kde3/kcm_nvview.so
%attr(0755,root,root) %{_kdeprefix}/lib/kde3/kcm_nvview.la
## xdg-data
%{_kdeprefix}/share/applications/kde/%{name}.desktop
## description
%dir %{_kdeprefix}/share/apps/kcontrol/xml
%{_kdeprefix}/share/apps/kcontrol/xml/%{name}.xml
## locale
%{_kdeprefix}/share/locale/*/LC_MESSAGES/%{name}.mo
## icons
%{_kdeprefix}/share/icons/hicolor/*/apps/%{name}.png

%clean
rm -rf %{buildroot}
if [ -d "%{_builddir}/%packagename" ] ; then
   rm -rf %{_builddir}/%packagename
fi

%changelog -n %{name}
* Mon May 28 2007 - %{vendor}
- Update to Version 0.3
- add description column with xml database
- translation modified 
- add kde based row highlighting 
- resize mode modified

* Sun May 27 2007 - %{vendor}
- Update to Version 0.2
- add support for multible cards

* Sun May 27 2007 - %{vendor}
- First Version 0.1

