#ifndef _ARRAY_H
#define _ARRAY_H

/**
    Kaya run-time system
    Copyright (C) 2004, 2005 Edwin Brady

    This file is distributed under the terms of the GNU Lesser General
    Public Licence. See COPYING for licence.
*/

using namespace std;

#ifndef WIN32
#include <pthread.h>
#define GC_THREADS
#else
#define GC_WIN32_THREADS
#endif
#include <gc/gc_cpp.h>
#include <map>

class Value;

// An array is stored as an array of pointers to blocks of values.
// Each block's length is some power of 2 (all blocks in an array are the
// same length) so it's quick to find which block a particular index is in
// by bit shifting.

// We can't just have one block, since the array needs to grow dynamically,
// and there may be pointers into the array from elsewhere. So once something
// is in the array, it can't move.

// If we ever write our own garbage collector, it probably ought to compact
// arrays (so that at least they aren't stored in lots of
// blocks all over memory).

class Array : public gc_cleanup
{
public:
    Array(unsigned size=0);
    ~Array();
    void push_back(Value* v);
    Value* lookup(unsigned i);
    inline unsigned size() { return m_size-m_offset; }
    unsigned reserved_size();
    Array* copy(map<Value*,Value*>& done);
    void resize(unsigned i);
    Value* shift();
    void unshift(Value* v);

    /// Make sure there's enough space for at least i things.
    void expectedSize(unsigned i);

    unsigned memusage();

    bool eq(Array* x,map<Value*,Value*>& done);
    int cmp(Array* x);

private:
    unsigned m_offset;
    unsigned m_numBlocks;
    unsigned m_alloc;
    unsigned m_size;
    Value*** m_blocks; // array of pointers to a list of values
};

#endif
