/*
 * File:		DICTClient.hh
 * Version:		0.9
 * History:             see DICTClient.cc
 *
 * Legalese
 * Copyright (C) 1999 Sudhakar Chandrasekharan (thaths@netscape.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef DICT_HH
#define DICT_HH

#include <string>
#include <vector>

class DICTClient {
private:
  DICTClient(const DICTClient & other);
  DICTClient & operator=(const DICTClient & other);
  
public:

  DICTClient(const char * h = "dict.org", int p = 2628);
  ~DICTClient() {hangup();}

  void dial();                     // Connect to dict server */
  void hangup();                   // diconnect from dict server
  void setHost(const char * h = "dict.org", int p = 2628); 
                                   // set dict server
  void setTimeout(int);
  const char * getHost();	   // Get name of dict server
  int getPort();		   // Get port of dict server
  bool isConnected() {return connected;}

  struct DB {
    std::string book;
    std::string description;
  };
  typedef std::vector<DB> DBs;

  DBs ListBooks();

  struct Definition {
    std::string book;
    std::string definition;
    Definition(const std::string & b) : book(b) {}
  };
  typedef std::vector<Definition> Definitions;

  Definitions lookup(const char *, const char * book = "*");   
                                // Looks up a defination and 

  struct Exception {
    virtual std::string message() const = 0;
    virtual ~Exception() {}
  };
  struct BadPort : public Exception {
    int port;
    BadPort(int p) : port(p) {}
    std::string message() const;
  };
  struct InvalidHost : public Exception {
    std::string host_name;
    InvalidHost(const std::string & n) : host_name(n) {}
    std::string message() const;
  };
  struct CannotMapTcpToProtocolNumber : public Exception {
    std::string message() const {return "Cannot map \"tcp\" to protocol number";}
  };
  struct SocketCreationFailed : public Exception {
    std::string message() const {return "Socket creation failed";}
  };
  struct SetsockoptFailed : public Exception {
    std::string message() const {return "setsockopt() failed";}
  };
  struct ConnectFailed : public Exception {
    std::string message() const {return "connect() failed";}
  };
  struct NotConnected : public Exception {
    std::string message() const {return "Not connected";}
  };
  struct ServerDisconnected : public Exception {
    std::string message() const {return "The server disconnected";}
  };

private:
  int		sd;		/* socket descriptor */
  std::string	host;	/* dict server */
  int		port;	/* port of dict server */
  bool		connected;	/* A flag to indicate whether connected */
  int timeout;

  int		readline(int, char *, int);
  std::string	find_book(const char *);
  void SendClient();
#ifdef _WIN32
  static bool winsock_init;
#endif
};

struct WordNetDefinition {
  std::string part_of_speech;
  std::string number;
  std::string definition;
};

#endif
