/*
 *   Jackbeat - JACK sequencer
 *    
 *   Copyright (c) 2004-2008 Olivier Guilyardi <olivier {at} samalyse {dot} com>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   SVN:$Id: arg.c 607 2009-06-25 15:49:51Z olivier $
*/

/*
 *   This file was first generated by genparse, then customized
 *   See http://genparse.sourceforge.net/
 */

#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdlib.h>
#include <getopt.h>
#include <gtk/gtk.h>
#include "config.h"
#include "arg.h"
#include "util.h"
#include "osc.h"

/* Print out usage information, then exit */
void arg_usage(char * executable)
{
  printf("Usage: %s [options] [jab filename]\n", executable);
  printf("Options:\n");
  printf("  -c, --clientname=STRING   client/application name for Jack, PulseAudio,..\n");
  printf("  -h, --help                Display help information\n");
  printf("  -n, --null-stream         Do not load any audio stream driver on startup\n");
  printf("  -o, --osc-reflect         Print OSC interface to standard output\n");
  printf("  -v, --version             Output version\n");
}


/* Parse the argv array into the command line structure */
arg_t *arg_parse (int argc, char *argv[])
{
  extern char *optarg;
  extern int optind;
  int option_index = 0;
  int c;
  arg_t *arg;
  int errflg = 0;

  static struct option long_options[] =
  {
    {"clientname",  1, 0, 'c'},
    {"help",        0, 0, 'h'},
    {"null-stream", 0, 0, 'n'},
    {"osc-reflect", 0, 0, 'o'},
    {"version",     0, 0, 'v'},
    {0,             0, 0, 0}
  };

  gtk_init(&argc, &argv);

  arg = (arg_t *) malloc (sizeof(arg_t));

  arg->argc = argc;
  arg->argv = calloc (argc, sizeof (char *));
  for (c=0; c < argc; c++) arg->argv[c] = strdup (argv[c]);
  
  arg->client_name  = NULL;
  arg->filename     = NULL;
  arg->null_stream  = 0;

  while ((c = getopt_long(argc, argv, "c:hnov", long_options, &option_index)) != EOF)
    {
      switch(c)
        {
        case 'c': 
          if (arg->client_name)
            free (arg->client_name);
          arg->client_name = strdup(optarg);
          break;

        case 'n': 
          arg->null_stream = 1;
          break;

        case 'o': 
          osc_print_interface();
          exit(0);
          break;

        case 'v': 
          printf ("%s\n", VERSION);
          exit(0);
          break;

        case 'h': 
        default:
          arg_usage(argv[0]);
          exit(0);

        }
    } /* while */

  if (errflg)
   {
    arg_usage(argv[0]);
    exit(1);
   }

  if (optind < argc) 
      arg->filename = strdup (argv[optind]);

  return arg;
}

void
arg_cleanup (arg_t *arg)
{
  int c;
  for (c=0; c < arg->argc; c++) 
    free (arg->argv[c]);
  free (arg->argv);
  free (arg->client_name);
  free (arg->filename);
  free (arg);
}
