
/****************************************************************************
 *
 * All portions copyright their respective authors.  All rights reserved.
 *
 * This file is part of IVMan (ivm).
 *
 * This file may be distributed under the terms of the Q Public License
 * as defined by Troll Tech AS of Norway and appearing in the file
 * LICENSE.QPL included in the packaging of this file.
 * 
 * See http://www.troll.no/qpl for QPL licensing information.
 *
 * $Id: IvmConfigBase.c,v 1.24 2005/11/22 00:25:58 ro_han Exp $
 ****************************************************************************
*/

#include <string.h>
#include <glib.h>
#include <libxml/tree.h>

#include "IvmConfigBase.h"
#include "common.h"

IvmConfigBase *parseIvmConfigBase(char const *const path)
{
    LIBXML_TEST_VERSION IvmConfigBase *ret = NULL;

    ret = (IvmConfigBase *) malloc(sizeof(IvmConfigBase));

    if (ret == NULL)
    {
        DEBUG(_("Out of memory!\n"));
        return NULL;
    }

    memset(ret, 0, sizeof(IvmConfigBase));

    // Set some defaults
    ret->umask = "007";
    ret->sleep = TRUE;

    xmlDocPtr doc;
    xmlNodePtr cur;

    doc = xmlParseFile(path);
    if (doc == NULL)
    {
        DEBUG(_("Document not parsed successfully."));
        return NULL;
    }

    cur = xmlDocGetRootElement(doc);
    if (cur == NULL)
    {
        DEBUG(_("Document is empty!"));
        xmlFreeDoc(doc);
        return NULL;
    }
    if (xmlStrcmp(cur->name, (const xmlChar *) "BaseConfig"))
    {
        DEBUG(_
              ("Incorrect document type, root node should have been %s"),
              "BaseConfig");
        xmlFreeDoc(doc);
        return NULL;
    }
    cur = cur->xmlChildrenNode;
    while (cur != NULL)
    {
        if (!xmlStrcmp(cur->name, (const xmlChar *) "Option"))
        {
            xmlChar *name;

            name = xmlGetProp(cur, "name");

            xmlChar *value;

            value = xmlGetProp(cur, "value");

            if ((name == NULL) || (value == NULL))
            {
                DEBUG(_("Warning: %s XML tag encountered with missing or bad attributes, ignored\n"), cur->name);
                goto nextOption;
            }

            if (!xmlStrcmp(name, (const xmlChar *) "debug"))
            {
                if (!xmlStrcmp(value, (const xmlChar *) "true"))
                    ret->debug = TRUE;
                else
                    ret->debug = FALSE;
            }
            if (!xmlStrcmp(name, (const xmlChar *) "fork"))
            {
                if (!xmlStrcmp(value, (const xmlChar *) "true"))
                    ret->fork = TRUE;
                else
                    ret->fork = FALSE;
            }
            if (!xmlStrcmp(name, (const xmlChar *) "sleep"))
            {
                if (!xmlStrcmp(value, (const xmlChar *) "true"))
                    ret->sleep = TRUE;
                else
                    ret->sleep = FALSE;
            }

            if (!xmlStrcmp(name, (const xmlChar *) "pidfile"))
            {
                ret->pidFile = (char *) strdup((char *) value);
            }

            if (!xmlStrcmp(name, (const xmlChar *) "mountcommand"))
            {
                ret->mountcommand = (char *) strdup((char *) value);
            }

            if (!xmlStrcmp(name, (const xmlChar *) "umountcommand"))
            {
                ret->umountcommand = (char *) strdup((char *) value);
            }

            if (!xmlStrcmp(name, (const xmlChar *) "umask"))
            {
                ret->umask = (char *) strdup((char *) value);
            }

            if (!xmlStrcmp(name, (const xmlChar *) "group"))
            {
                ret->group = (char *) strdup((char *) value);
            }

            if (!xmlStrcmp(name, (const xmlChar *) "user"))
            {
                ret->user = (char *) strdup((char *) value);
            }

nextOption:
            if (value) xmlFree(value);
            if (name) xmlFree(name);
        }
        cur = cur->next;
    }
    xmlFreeDoc(doc);

    xmlCleanupParser();

    return ret;
}
