/*=========================================================================

  Program:   Insight Segmentation & Registration Toolkit
  Module:    $RCSfile: itkBasicFiltersTests3.cxx,v $
  Language:  C++
  Date:      $Date: 2010-04-23 07:09:42 $
  Version:   $Revision: 1.15 $

  Copyright (c) Insight Software Consortium. All rights reserved.
  See ITKCopyright.txt or http://www.itk.org/HTML/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/
#if defined(_MSC_VER)
#pragma warning ( disable : 4786 )
#endif

// this file defines the itkBasicFiltersTest for the test driver
// and all it expects is that you have a function called RegisterTests
#include <iostream>
#include "itkTestMain.h" 


void RegisterTests()
{
  REGISTER_TEST(itkAccumulateImageFilterTest );
  REGISTER_TEST(itkApproximateSignedDistanceMapImageFilterTest );
  REGISTER_TEST(itkCheckerBoardImageFilterTest );
  REGISTER_TEST(itkHessianRecursiveGaussianFilterTest );
  REGISTER_TEST(itkHessianRecursiveGaussianFilterScaleSpaceTest );
  REGISTER_TEST(itkLabelStatisticsImageFilterTest );
  REGISTER_TEST(itkSymmetricEigenAnalysisImageFilterTest );
  REGISTER_TEST(itkNormalizedCorrelationImageFilterTest );
  REGISTER_TEST(itkPolylineMaskImageFilterTest );
  REGISTER_TEST(itkPolylineMask2DImageFilterTest );
  REGISTER_TEST(itkTensorFractionalAnisotropyImageFilterTest );
  REGISTER_TEST(itkTensorRelativeAnisotropyImageFilterTest );
  REGISTER_TEST(itkTriangleMeshToBinaryImageFilterTest );
  REGISTER_TEST(itkTriangleMeshToBinaryImageFilterTest2 );
  REGISTER_TEST(itkVectorAnisotropicDiffusionImageFilterTest );
  REGISTER_TEST(itkVectorConfidenceConnectedImageFilterTest );
  REGISTER_TEST(itkVectorExpandImageFilterTest );
  REGISTER_TEST(itkVectorGradientMagnitudeImageFilterTest1 );
  REGISTER_TEST(itkVectorGradientMagnitudeImageFilterTest2 );
  REGISTER_TEST(itkVectorNeighborhoodOperatorImageFilterTest );
  REGISTER_TEST(itkVectorResampleImageFilterTest );
  REGISTER_TEST(itkVectorRescaleIntensityImageFilterTest );
  REGISTER_TEST(itkVotingBinaryHoleFillingImageFilterTest );
  REGISTER_TEST(itkVotingBinaryImageFilterTest );
  REGISTER_TEST(itkVotingBinaryIterativeHoleFillingImageFilterTest );
  REGISTER_TEST(itkWarpImageFilterTest );
  REGISTER_TEST(itkWarpMeshFilterTest );
  REGISTER_TEST(itkWarpVectorImageFilterTest );
  REGISTER_TEST(itkWeightedAddImageFilterTest);
  REGISTER_TEST(itkWrapPadImageTest );
  REGISTER_TEST(itkXorImageFilterTest );
  REGISTER_TEST(itkZeroCrossingBasedEdgeDetectionImageFilterTest );
  REGISTER_TEST(itkZeroCrossingImageFilterTest );
}

