.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbAllocIndicatorMaps __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbAllocIndicatorMaps \- Allocates, directly, the 
.I indicators 
member of the keyboard description record 
.SH SYNOPSIS
.HP
.B Status XkbAllocIndicatorMaps
.BI "(\^variable_type *" "xkb" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- xkb
keyboard description structure
.SH DESCRIPTION
.LP
The 
.I xkb 
parameter must point to a valid keyboard description. If it doesn't, 
.I XkbAllocIndicatorMaps 
returns a BadMatch error. Otherwise, 
.I XkbAllocIndicatorMaps 
allocates and initializes the 
.I indicators 
member of the keyboard description record and returns Success. If 
.I XkbAllocIndicatorMaps 
was unable to allocate the indicators record, it reports a BadAlloc error.
.SH RETURN VALUES"
.TP 15
Success
The 
.I XkbAllocIndicatorMaps 
function returns Success if it is successful in allocating and initializing the 
.I indicators 
member of the keyboard description record.
.SH DIAGNOSTICS
.TP 15
.B BadMatch
A compatible version of Xkb was not available in the server or an argument has 
correct type and range, but is otherwise invalid
.TP 15
.B BadAlloc
Unable to allocate storage
