namespace reso_tube {
// generated from file '../src/faust/reso_tube.dsp'

FAUSTFLOAT&	fslider0 = get_alias("tube2.resonanz");
int 	IOTA;
double 	fVec0[4096];
FAUSTFLOAT&	fslider1 = get_alias("tube2.vibrato");
double 	fRec0[2];
FAUSTFLOAT&	fslider2 = get_alias("tube2.fuzzy");
int	fSamplingFreq;

void init(int samplingFreq)
{
	fSamplingFreq = samplingFreq;
	IOTA = 0;
	for (int i=0; i<4096; i++) fVec0[i] = 0;
	for (int i=0; i<2; i++) fRec0[i] = 0;
}

void compute(int count, float *input0, float *output0)
{
	double 	fSlow0 = (fslider0 + 0.09999999999999998);
	double 	fSlow1 = fslider1;
	int 	iSlow2 = int((int((0 - fSlow1)) & 4095));
	int 	iSlow3 = int((int((1 - fSlow1)) & 4095));
	double 	fSlow4 = (0.5 * fslider2);
	for (int i=0; i<count; i++) {
		double fTemp0 = ((double)input0[i] + 1e-20);
		double fTemp1 = ((0.5 * ((fTemp0 * (2 - fabs(fTemp0))) - fTemp0)) + (fSlow0 * fRec0[1]));
		fVec0[IOTA&4095] = fTemp1;
		fRec0[0] = (0.5 * (fVec0[(IOTA-iSlow3)&4095] + fVec0[(IOTA-iSlow2)&4095]));
		output0[i] = (FAUSTFLOAT)max(-0.7, min(0.7, (fTemp0 - max(-0.7, min(0.7, (fSlow4 * fRec0[0]))))));
		// post processing
		fRec0[1] = fRec0[0];
		IOTA = IOTA+1;
	}
}

static struct RegisterParams { RegisterParams(); } RegisterParams;
RegisterParams::RegisterParams()
{
	registerInit("tube2", init);
}

} // end namespace reso_tube
